/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.KafkaConfig;
import kafka.server.StorageProbe$;
import kafka.server.StorageProbe$LogDirMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001\u0002\u001f>\u0001\tC\u0001B\u0017\u0001\u0003\u0006\u0004%Ia\u0017\u0005\tA\u0002\u0011\t\u0011)A\u00059\"A\u0011\r\u0001BC\u0002\u0013%!\r\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003d\u0011!\u0001\bA!b\u0001\n\u0013\t\b\u0002\u0003=\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u000be\u0004A\u0011\u0001>\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"!\u0003\u0001A\u0003%\u00111\u0001\u0005\n\u0003\u0017\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"!\u0006\u0001A\u0003%\u0011q\u0002\u0005\n\u0003/\u0001!\u0019!C\u0005\u0003\u001bA\u0001\"!\u0007\u0001A\u0003%\u0011q\u0002\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"a\r\u0001A\u0003%\u0011q\u0004\u0005\f\u0003k\u0001\u0001\u0019!a\u0001\n\u0013\t9\u0004C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0003bCA'\u0001\u0001\u0007\t\u0011)Q\u0005\u0003sA\u0001\"\u0015\u0001A\u0002\u0013%\u0011q\n\u0005\n\u0005\u000b\u0002\u0001\u0019!C\u0005\u0005\u000fB\u0001Ba\u0013\u0001A\u0003&\u0011\u0011\u000b\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0005\u001fBqAa\u0015\u0001\t\u0003\u0011)\u0006C\u0004\u0003d\u0001!\tA!\u001a\t\u000f\t5\u0004\u0001\"\u0001\u0003P\u00191\u0011Q\u000e\u0001A\u0003_B!\"a!\u001c\u0005+\u0007I\u0011AAC\u0011)\t)j\u0007B\tB\u0003%\u0011q\u0011\u0005\u000b\u0003/[\"Q3A\u0005\u0002\u0005e\u0005BCAQ7\tE\t\u0015!\u0003\u0002\u001c\"Q\u00111U\u000e\u0003\u0016\u0004%\t!!*\t\u0015\u0005u6D!E!\u0002\u0013\t9\u000b\u0003\u0006\u0002@n\u0011)\u001a!C\u0001\u0003\u0003D!\"a4\u001c\u0005#\u0005\u000b\u0011BAb\u0011\u0019I8\u0004\"\u0001\u0002R\"I\u00111\\\u000e\u0002\u0002\u0013\u0005\u0011Q\u001c\u0005\n\u0003O\\\u0012\u0013!C\u0001\u0003SD\u0011\"a@\u001c#\u0003%\tA!\u0001\t\u0013\t\u00151$%A\u0005\u0002\t\u001d\u0001\"\u0003B\u00067E\u0005I\u0011\u0001B\u0007\u0011%\u0011\tbGA\u0001\n\u0003\ni\u0001C\u0005\u0003\u0014m\t\t\u0011\"\u0001\u0002\u0002!I!QC\u000e\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005CY\u0012\u0011!C!\u0005GA\u0011B!\r\u001c\u0003\u0003%\tAa\r\t\u0013\t]2$!A\u0005B\te\u0002\"\u0003B\u001e7\u0005\u0005I\u0011\tB\u001f\u0011%\u0011ydGA\u0001\n\u0003\u0012\teB\u0005\u0003x\u0001\t\t\u0011#\u0001\u0003z\u0019I\u0011Q\u000e\u0001\u0002\u0002#\u0005!1\u0010\u0005\u0007sN\"\tA!#\t\u0013\tm2'!A\u0005F\tu\u0002\"\u0003BFg\u0005\u0005I\u0011\u0011BG\u0011%\u00119jMA\u0001\n\u0003\u0013IjB\u0005\u0003,v\n\t\u0011#\u0001\u0003.\u001aAA(PA\u0001\u0012\u0003\u0011y\u000b\u0003\u0004zs\u0011\u0005!\u0011\u0017\u0005\n\u0005gK\u0014\u0013!C\u0001\u0005k\u0013Ab\u0015;pe\u0006<W\r\u0015:pE\u0016T!AP \u0002\rM,'O^3s\u0015\u0005\u0001\u0015!B6bM.\f7\u0001A\n\u0006\u0001\r[e\n\u0016\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000bA\u0001\\1oO*\t\u0001*\u0001\u0003kCZ\f\u0017B\u0001&F\u0005\u0019y%M[3diB\u0011A\tT\u0005\u0003\u001b\u0016\u0013\u0001BU;o]\u0006\u0014G.\u001a\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#~\nq!\\3ue&\u001c7/\u0003\u0002T!\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0011\u0005UCV\"\u0001,\u000b\u0005]{\u0014!B;uS2\u001c\u0018BA-W\u0005\u001daunZ4j]\u001e\faaY8oM&<W#\u0001/\u0011\u0005usV\"A\u001f\n\u0005}k$aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0003uS6,W#A2\u0011\u0005\u0011lW\"A3\u000b\u0005]3'BA4i\u0003\u0019\u0019w.\\7p]*\u0011\u0001)\u001b\u0006\u0003U.\fa!\u00199bG\",'\"\u00017\u0002\u0007=\u0014x-\u0003\u0002oK\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003-\u0019H/\u0019:u)\"\u0014X-\u00193\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT\u0011!^\u0001\u0006g\u000e\fG.Y\u0005\u0003oR\u0014qAQ8pY\u0016\fg.\u0001\u0007ti\u0006\u0014H\u000f\u00165sK\u0006$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005wrlh\u0010\u0005\u0002^\u0001!)!l\u0002a\u00019\")\u0011m\u0002a\u0001G\"9\u0001o\u0002I\u0001\u0002\u0004\u0011\u0018a\u0002<feNLwN\\\u000b\u0003\u0003\u0007\u00012a]A\u0003\u0013\r\t9\u0001\u001e\u0002\u0004\u0013:$\u0018\u0001\u0003<feNLwN\u001c\u0011\u0002#1\fG/\u001a8ds6+GO]5d\u001d\u0006lW-\u0006\u0002\u0002\u0010A\u0019A)!\u0005\n\u0007\u0005MQI\u0001\u0004TiJLgnZ\u0001\u0013Y\u0006$XM\\2z\u001b\u0016$(/[2OC6,\u0007%\u0001\fdkJ\u0014XM\u001c;Xe&$X-T3ue&\u001cg*Y7f\u0003]\u0019WO\u001d:f]R<&/\u001b;f\u001b\u0016$(/[2OC6,\u0007%\u0001\u0007tQV$Hm\\<o\r2\fw-\u0006\u0002\u0002 A!\u0011\u0011EA\u0018\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012AB1u_6L7M\u0003\u0003\u0002*\u0005-\u0012AC2p]\u000e,(O]3oi*\u0019\u0011QF$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003c\t\u0019CA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000eg\",H\u000fZ8x]\u001ac\u0017m\u001a\u0011\u0002\rQD'/Z1e+\t\tI\u0004E\u0002e\u0003wI1!!\u0010f\u0005-Y\u0015MZ6b)\"\u0014X-\u00193\u0002\u0015QD'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002D\u0005%\u0003cA:\u0002F%\u0019\u0011q\t;\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0017\n\u0012\u0011!a\u0001\u0003s\t1\u0001\u001f\u00132\u0003\u001d!\bN]3bI\u0002*\"!!\u0015\u0011\r\u0005M\u00131MA5\u001d\u0011\t)&a\u0018\u000f\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017B\u0003\u0019a$o\\8u}%\tQ/C\u0002\u0002bQ\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002f\u0005\u001d$\u0001\u0002'jgRT1!!\u0019u!\r\tYgG\u0007\u0002\u0001\tiAj\\4ESJlU\r\u001e:jGN\u001craGA9\u0003o\ni\bE\u0002t\u0003gJ1!!\u001eu\u0005\u0019\te.\u001f*fMB\u00191/!\u001f\n\u0007\u0005mDOA\u0004Qe>$Wo\u0019;\u0011\u0007M\fy(C\u0002\u0002\u0002R\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fAA\\1nKV\u0011\u0011q\u0011\t\u0005\u0003\u0013\u000b\tJ\u0004\u0003\u0002\f\u00065\u0005cAA,i&\u0019\u0011q\u0012;\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019\"a%\u000b\u0007\u0005=E/A\u0003oC6,\u0007%A\u000bdkJ\u0014XM\u001c;Xe&$Xm\u0015;beR,G-T:\u0016\u0005\u0005m\u0005\u0003BA\u0011\u0003;KA!a(\u0002$\tQ\u0011\t^8nS\u000eduN\\4\u0002-\r,(O]3oi^\u0013\u0018\u000e^3Ti\u0006\u0014H/\u001a3Ng\u0002\n\u0011\u0002[5ti><'/Y7\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003sk!!a+\u000b\t\u00055\u0016qV\u0001\u0005G>\u0014XMC\u0002R\u0003cSA!a-\u00026\u00061\u00110Y7nKJT!!a.\u0002\u0007\r|W.\u0003\u0003\u0002<\u0006-&!\u0003%jgR|wM]1n\u0003)A\u0017n\u001d;pOJ\fW\u000eI\u0001\nQ\u0016\f'\u000f\u001e2fCR,\"!a1\u0011\r\u0005%\u0016QYAe\u0013\u0011\t9-a+\u0003\u000b\u001d\u000bWoZ3\u0011\u0007M\fY-C\u0002\u0002NR\u0014A\u0001T8oO\u0006Q\u0001.Z1si\n,\u0017\r\u001e\u0011\u0015\u0015\u0005%\u00141[Ak\u0003/\fI\u000eC\u0004\u0002\u0004\u0012\u0002\r!a\"\t\u000f\u0005]E\u00051\u0001\u0002\u001c\"9\u00111\u0015\u0013A\u0002\u0005\u001d\u0006bBA`I\u0001\u0007\u00111Y\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002j\u0005}\u0017\u0011]Ar\u0003KD\u0011\"a!&!\u0003\u0005\r!a\"\t\u0013\u0005]U\u0005%AA\u0002\u0005m\u0005\"CARKA\u0005\t\u0019AAT\u0011%\ty,\nI\u0001\u0002\u0004\t\u0019-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-(\u0006BAD\u0003[\\#!a<\u0011\t\u0005E\u00181`\u0007\u0003\u0003gTA!!>\u0002x\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003s$\u0018AC1o]>$\u0018\r^5p]&!\u0011Q`Az\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019A\u000b\u0003\u0002\u001c\u00065\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0013QC!a*\u0002n\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B\bU\u0011\t\u0019-!<\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0007\u0003 A\u00191Oa\u0007\n\u0007\tuAOA\u0002B]fD\u0011\"a\u0013-\u0003\u0003\u0005\r!a\u0001\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\n\u0011\r\t\u001d\"Q\u0006B\r\u001b\t\u0011ICC\u0002\u0003,Q\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yC!\u000b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004e\nU\u0002\"CA&]\u0005\u0005\t\u0019\u0001B\r\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0002\u0003!!xn\u0015;sS:<GCAA\b\u0003\u0019)\u0017/^1mgR\u0019!Oa\u0011\t\u0013\u0005-\u0013'!AA\u0002\te\u0011aC7fiJL7m]0%KF$B!a\u0011\u0003J!I\u00111\n\u000b\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\t[\u0016$(/[2tA\u000591\u000f^1siV\u0004HCAA\"\u0003!\u0019\b.\u001e;e_^t\u0017a\u00029bs2|\u0017\r\u001a\u000b\u0003\u0005/\u0002BA!\u0017\u0003`5\u0011!1\f\u0006\u0004\u0005;:\u0015a\u00018j_&!!\u0011\rB.\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u0006aJ|'-\u001a\u000b\u0003\u0005O\u0002\u0002\"!#\u0003j\u0005\u001d\u0015\u0011Z\u0005\u0005\u0005W\n\u0019JA\u0002NCB\f1A];oQ\rQ\"\u0011\u000f\t\u0004\t\nM\u0014b\u0001B;\u000b\nAqJ^3se&$W-A\u0007M_\u001e$\u0015N]'fiJL7m\u001d\t\u0004\u0003W\u001a4#B\u001a\u0003~\u0005u\u0004C\u0004B@\u0005\u000b\u000b9)a'\u0002(\u0006\r\u0017\u0011N\u0007\u0003\u0005\u0003S1Aa!u\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\"\u0003\u0002\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\te\u0014!B1qa2LHCCA5\u0005\u001f\u0013\tJa%\u0003\u0016\"9\u00111\u0011\u001cA\u0002\u0005\u001d\u0005bBALm\u0001\u0007\u00111\u0014\u0005\b\u0003G3\u0004\u0019AAT\u0011\u001d\tyL\u000ea\u0001\u0003\u0007\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001c\n\u001d\u0006#B:\u0003\u001e\n\u0005\u0016b\u0001BPi\n1q\n\u001d;j_:\u00042b\u001dBR\u0003\u000f\u000bY*a*\u0002D&\u0019!Q\u0015;\u0003\rQ+\b\u000f\\35\u0011%\u0011IkNA\u0001\u0002\u0004\tI'A\u0002yIA\nAb\u0015;pe\u0006<W\r\u0015:pE\u0016\u0004\"!X\u001d\u0014\u0007e\n\t\b\u0006\u0002\u0003.\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"Aa.+\u0007I\fi\u000f")
public class StorageProbe
implements Runnable,
KafkaMetricsGroup {
    private volatile StorageProbe$LogDirMetrics$ LogDirMetrics$module;
    private final KafkaConfig config;
    private final Time time;
    private final boolean startThread;
    private final int version;
    private final String latencyMetricName;
    private final String currentWriteMetricName;
    private final AtomicBoolean shutdownFlag;
    private KafkaThread thread;
    private List<LogDirMetrics> metrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return StorageProbe$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public StorageProbe$LogDirMetrics$ LogDirMetrics() {
        if (this.LogDirMetrics$module == null) {
            this.LogDirMetrics$lzycompute$1();
        }
        return this.LogDirMetrics$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private Time time() {
        return this.time;
    }

    private boolean startThread() {
        return this.startThread;
    }

    private int version() {
        return this.version;
    }

    private String latencyMetricName() {
        return this.latencyMetricName;
    }

    private String currentWriteMetricName() {
        return this.currentWriteMetricName;
    }

    private AtomicBoolean shutdownFlag() {
        return this.shutdownFlag;
    }

    private KafkaThread thread() {
        return this.thread;
    }

    private void thread_$eq(KafkaThread x$1) {
        this.thread = x$1;
    }

    private List<LogDirMetrics> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(List<LogDirMetrics> x$1) {
        this.metrics = x$1;
    }

    public void startup() {
        if (Predef$.MODULE$.Long2long(this.config().storageProbePeriodMs()) > 0L) {
            this.metrics_$eq((List<LogDirMetrics>)((TraversableOnce)this.config().logDirs().map((Function1 & Serializable & scala.Serializable)logDir -> {
                scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), logDir)}));
                AtomicLong currentWriteTimeStartedMs = new AtomicLong(-1L);
                return new LogDirMetrics(this, (String)logDir, currentWriteTimeStartedMs, this.newHistogram(this.latencyMetricName(), true, (Map<String, String>)tags), this.newGauge(this.currentWriteMetricName(), new Gauge<Object>(this, currentWriteTimeStartedMs){
                    private final /* synthetic */ StorageProbe $outer;
                    private final AtomicLong currentWriteTimeStartedMs$1;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$2(this.currentWriteTimeStartedMs$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.currentWriteTimeStartedMs$1 = currentWriteTimeStartedMs$1;
                    }
                }, (Map<String, String>)tags));
            }, Seq$.MODULE$.canBuildFrom())).toList());
            String nonDaemon_name = "StorageProbe";
            this.thread_$eq(new KafkaThread(nonDaemon_name, (Runnable)this, false));
            if (this.startThread()) {
                this.thread().start();
                return;
            }
        }
    }

    public void shutdown() {
        this.shutdownFlag().set(true);
        if (Predef$.MODULE$.Long2long(this.config().storageProbePeriodMs()) > 0L) {
            this.metrics().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                StorageProbe.$anonfun$shutdown$1(this, logDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public ByteBuffer payload() {
        return ByteBuffer.wrap(new StringBuilder(1).append(this.version()).append(",").append(this.time().milliseconds()).toString().getBytes(StandardCharsets.UTF_8));
    }

    public scala.collection.immutable.Map<String, Object> probe() {
        return ((TraversableOnce)this.metrics().map((Function1 & Serializable & scala.Serializable)logDir -> {
            try {
                Tuple2 tuple2;
                Path path = Paths.get(logDir.name(), "storage.probe");
                ByteBuffer payloadBytes = this.payload();
                logDir.currentWriteStartedMs().set(this.time().hiResClockMs());
                FileChannel fc = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                try {
                    fc.truncate(0L);
                    long startMs = this.time().hiResClockMs();
                    fc.write(payloadBytes);
                    fc.force(true);
                    long tookMs = this.time().hiResClockMs() - startMs;
                    if (tookMs >= 5000L) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "storage probe write and flush took over 10s");
                    }
                    logDir.histogram().update(tookMs);
                    tuple2 = new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)tookMs));
                }
                finally {
                    logDir.currentWriteStartedMs().set(-1L);
                    fc.close();
                }
                return tuple2;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed writing storage probe data to logdir ").append(logDir.name()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                return new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public void run() {
        do {
            this.probe();
            Thread.sleep(Predef$.MODULE$.Long2long(this.config().storageProbePeriodMs()));
        } while (!this.shutdownFlag().get());
    }

    private final void LogDirMetrics$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirMetrics$module == null) {
                this.LogDirMetrics$module = new StorageProbe$LogDirMetrics$(this);
            }
            return;
        }
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$2(AtomicLong currentWriteTimeStartedMs$1) {
        long startedMs = currentWriteTimeStartedMs$1.get();
        if (startedMs == -1L) {
            return 0L;
        }
        return this.time().hiResClockMs() - startedMs;
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(StorageProbe $this, LogDirMetrics logDir) {
        scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), (Object)logDir.name())}));
        $this.removeMetric($this.latencyMetricName(), (Map<String, String>)tags);
        $this.removeMetric($this.currentWriteMetricName(), (Map<String, String>)tags);
    }

    public StorageProbe(KafkaConfig config, Time time, boolean startThread) {
        this.config = config;
        this.time = time;
        this.startThread = startThread;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.version = 0;
        this.latencyMetricName = "StorageProbeLatencyMs";
        this.currentWriteMetricName = "CurrentWriteDurationMs";
        this.shutdownFlag = new AtomicBoolean(false);
        this.metrics = Nil$.MODULE$;
    }

    public class LogDirMetrics
    implements Product,
    scala.Serializable {
        private final String name;
        private final AtomicLong currentWriteStartedMs;
        private final Histogram histogram;
        private final Gauge<Object> heartbeat;
        public final /* synthetic */ StorageProbe $outer;

        public String name() {
            return this.name;
        }

        public AtomicLong currentWriteStartedMs() {
            return this.currentWriteStartedMs;
        }

        public Histogram histogram() {
            return this.histogram;
        }

        public Gauge<Object> heartbeat() {
            return this.heartbeat;
        }

        public LogDirMetrics copy(String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat) {
            return new LogDirMetrics(this.kafka$server$StorageProbe$LogDirMetrics$$$outer(), name, currentWriteStartedMs, histogram, heartbeat);
        }

        public String copy$default$1() {
            return this.name();
        }

        public AtomicLong copy$default$2() {
            return this.currentWriteStartedMs();
        }

        public Histogram copy$default$3() {
            return this.histogram();
        }

        public Gauge<Object> copy$default$4() {
            return this.heartbeat();
        }

        public String productPrefix() {
            return "LogDirMetrics";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.currentWriteStartedMs();
                }
                case 2: {
                    return this.histogram();
                }
                case 3: {
                    return this.heartbeat();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirMetrics;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof LogDirMetrics)) return false;
            if (((LogDirMetrics)x$1).kafka$server$StorageProbe$LogDirMetrics$$$outer() != this.kafka$server$StorageProbe$LogDirMetrics$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LogDirMetrics logDirMetrics = (LogDirMetrics)x$1;
            String string = this.name();
            String string2 = logDirMetrics.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equalsNumNum((Number)this.currentWriteStartedMs(), (Number)logDirMetrics.currentWriteStartedMs())) return false;
            Histogram histogram = this.histogram();
            Histogram histogram2 = logDirMetrics.histogram();
            if (histogram == null) {
                if (histogram2 != null) {
                    return false;
                }
            } else if (!histogram.equals(histogram2)) return false;
            Gauge<Object> gauge = this.heartbeat();
            Gauge<Object> gauge2 = logDirMetrics.heartbeat();
            if (gauge == null) {
                if (gauge2 != null) {
                    return false;
                }
            } else if (!gauge.equals(gauge2)) return false;
            if (!logDirMetrics.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageProbe kafka$server$StorageProbe$LogDirMetrics$$$outer() {
            return this.$outer;
        }

        public LogDirMetrics(StorageProbe $outer, String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat) {
            this.name = name;
            this.currentWriteStartedMs = currentWriteStartedMs;
            this.histogram = histogram;
            this.heartbeat = heartbeat;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

