/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.IoThread$;
import kafka.server.NetworkThread$;
import kafka.server.NonExemptRequest$;
import kafka.server.RequestThrottleType;
import kafka.server.SensorAccess;
import kafka.server.ThreadType;
import kafka.server.ThreadUsageMetrics$;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0006\u0004%I\u0001\t\u0005\t[\u0001\u0011\t\u0011)A\u0005C!Aa\u0006\u0001BC\u0002\u0013%q\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00031\u0011\u0015!\u0004\u0001\"\u00016\u0011\u001dQ\u0004A1A\u0005\nmBa\u0001\u0013\u0001!\u0002\u0013a\u0004bB%\u0001\u0005\u0004%IA\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B&\t\u000b=\u0003A\u0011\u0001)\t\u000fa\u0004\u0011\u0013!C\u0001s\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001\u0002CA\n\u0001E\u0005I\u0011A=\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!A\u00111\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0010C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\t\u0011B\u000b\u001b:fC\u0012,6/Y4f'\u0016t7o\u001c:t\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u00069Q.\u001a;sS\u000e\u001cX#A\u0011\u0011\u0005\tZS\"A\u0012\u000b\u0005}!#BA\u0013'\u0003\u0019\u0019w.\\7p]*\u0011ac\n\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014x-\u0003\u0002-G\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002G%t\u0017m\u0019;jm\u0016\u001cVM\\:pe\u0016C\b/\u001b:bi&|g\u000eV5nKN+7m\u001c8egV\t\u0001\u0007\u0005\u0002\u001bc%\u0011!g\u0007\u0002\u0005\u0019>tw-\u0001\u0013j]\u0006\u001cG/\u001b<f'\u0016t7o\u001c:FqBL'/\u0019;j_:$\u0016.\\3TK\u000e|g\u000eZ:!\u0003\u0019a\u0014N\\5u}Q\u0019a\u0007O\u001d\u0011\u0005]\u0002Q\"A\n\t\u000b})\u0001\u0019A\u0011\t\u000b9*\u0001\u0019\u0001\u0019\u0002\t1|7m[\u000b\u0002yA\u0011QHR\u0007\u0002})\u0011q\bQ\u0001\u0006Y>\u001c7n\u001d\u0006\u0003\u0003\n\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u0019E)\u0001\u0003vi&d'\"A#\u0002\t)\fg/Y\u0005\u0003\u000fz\u0012aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u0006Y>\u001c7\u000eI\u0001\u000fg\u0016t7o\u001c:BG\u000e,7o]8s+\u0005Y\u0005CA\u001cM\u0013\ti5C\u0001\u0007TK:\u001cxN]!dG\u0016\u001c8/A\btK:\u001cxN]!dG\u0016\u001c8o\u001c:!\u0003E\u0011XmY8sIRC'/Z1e+N\fw-\u001a\u000b\u0007#RK6\f\u00199\u0011\u0005i\u0011\u0016BA*\u001c\u0005\u0011)f.\u001b;\t\u000bUS\u0001\u0019\u0001,\u0002\u000bY\fG.^3\u0011\u0005i9\u0016B\u0001-\u001c\u0005\u0019!u.\u001e2mK\")!L\u0003a\u0001a\u00051A/[7f\u001bNDQ\u0001\u0018\u0006A\u0002u\u000b!\u0002\u001e5sK\u0006$G+\u001f9f!\t9d,\u0003\u0002`'\tQA\u000b\u001b:fC\u0012$\u0016\u0010]3\t\u000b\u0005T\u0001\u0019\u00012\u0002\u00155,GO]5d)\u0006<7\u000f\u0005\u0003dU6lgB\u00013i!\t)7$D\u0001g\u0015\t9w#\u0001\u0004=e>|GOP\u0005\u0003Sn\ta\u0001\u0015:fI\u00164\u0017BA6m\u0005\ri\u0015\r\u001d\u0006\u0003Sn\u0001\"a\u00198\n\u0005=d'AB*ue&tw\rC\u0004r\u0015A\u0005\t\u0019\u0001:\u0002\u001fQD'o\u001c;uY\u0016$\u0016\u0010]3PaR\u00042AG:v\u0013\t!8D\u0001\u0004PaRLwN\u001c\t\u0003oYL!a^\n\u0003'I+\u0017/^3tiRC'o\u001c;uY\u0016$\u0016\u0010]3\u00027I,7m\u001c:e)\"\u0014X-\u00193Vg\u0006<W\r\n3fM\u0006,H\u000e\u001e\u00136+\u0005Q(F\u0001:|W\u0005a\bcA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r1$\u0001\u0006b]:|G/\u0019;j_:L1!a\u0002\u007f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014e\u0016\u001cwN\u001d3J_RC'/Z1e+N\fw-\u001a\u000b\b#\u00065\u0011qBA\t\u0011\u0015)F\u00021\u0001W\u0011\u0015QF\u00021\u00011\u0011\u001d\tH\u0002%AA\u0002I\fQD]3d_J$\u0017j\u001c+ie\u0016\fG-V:bO\u0016$C-\u001a4bk2$HeM\u0001\u0019e\u0016\u001cwN\u001d3OKR<xN]6UQJ,\u0017\rZ+tC\u001e,G#C)\u0002\u001a\u0005m\u0011QDA\u0011\u0011\u0015)f\u00021\u0001W\u0011\u0015Qf\u00021\u00011\u0011\u0019\tyB\u0004a\u0001[\u0006aA.[:uK:,'OT1nK\"9\u0011O\u0004I\u0001\u0002\u0004\u0011\u0018A\t:fG>\u0014HMT3uo>\u00148\u000e\u00165sK\u0006$Wk]1hK\u0012\"WMZ1vYR$C'A\u000bsK6|g/\u001a'jgR,g.\u001a:NKR\u0014\u0018nY:\u0015\u0007E\u000bI\u0003\u0003\u0004\u0002 A\u0001\r!\\\u0001\u0016i\"\u0014X-\u00193Vg\u0006<WmU3og>\u0014h*Y7f)\u001di\u0017qFA\u0019\u0003gAQ\u0001X\tA\u0002uCQ!Y\tA\u0002\tDQ!]\tA\u0002I\u0004")
public class ThreadUsageSensors {
    private final Metrics metrics;
    private final long inactiveSensorExpirationTimeSeconds;
    private final ReentrantReadWriteLock lock;
    private final SensorAccess sensorAccessor;

    private Metrics metrics() {
        return this.metrics;
    }

    private long inactiveSensorExpirationTimeSeconds() {
        return this.inactiveSensorExpirationTimeSeconds;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public void recordThreadUsage(double value, long timeMs, ThreadType threadType, Map<String, String> metricTags, Option<RequestThrottleType> throttleTypeOpt) {
        String sensorName = this.threadUsageSensorName(threadType, metricTags, throttleTypeOpt);
        this.sensorAccessor().getOrCreate(sensorName, this.inactiveSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.add(ThreadUsageMetrics$.MODULE$.threadUsageMetricName(this.metrics(), threadType, (Map<String, String>)metricTags, (Option<RequestThrottleType>)throttleTypeOpt), (MeasurableStat)new Rate());
            return BoxedUnit.UNIT;
        }).record(value, timeMs);
    }

    public Option<RequestThrottleType> recordThreadUsage$default$5() {
        return None$.MODULE$;
    }

    public void recordIoThreadUsage(double value, long timeMs, Option<RequestThrottleType> throttleTypeOpt) {
        this.recordThreadUsage(value, timeMs, IoThread$.MODULE$, ThreadUsageMetrics$.MODULE$.ioThreadUsageMetricTags(), throttleTypeOpt);
    }

    public Option<RequestThrottleType> recordIoThreadUsage$default$3() {
        return None$.MODULE$;
    }

    public void recordNetworkThreadUsage(double value, long timeMs, String listenerName, Option<RequestThrottleType> throttleTypeOpt) {
        this.recordThreadUsage(value, timeMs, NetworkThread$.MODULE$, ThreadUsageMetrics$.MODULE$.listenerNetworkThreadUsageMetricTags(listenerName), throttleTypeOpt);
    }

    public Option<RequestThrottleType> recordNetworkThreadUsage$default$4() {
        return None$.MODULE$;
    }

    public void removeListenerMetrics(String listenerName) {
        this.metrics().removeSensor(this.threadUsageSensorName(NetworkThread$.MODULE$, ThreadUsageMetrics$.MODULE$.listenerNetworkThreadUsageMetricTags(listenerName), (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$)));
        this.metrics().removeSensor(this.threadUsageSensorName(NetworkThread$.MODULE$, ThreadUsageMetrics$.MODULE$.listenerNetworkThreadUsageMetricTags(listenerName), (Option<RequestThrottleType>)None$.MODULE$));
    }

    private String threadUsageSensorName(ThreadType threadType, Map<String, String> metricTags, Option<RequestThrottleType> throttleTypeOpt) {
        String suffix = metricTags.isEmpty() ? "" : new StringBuilder(1).append("-").append(metricTags.values().mkString(":")).toString();
        String prefix = (String)throttleTypeOpt.map((Function1 & Serializable & scala.Serializable)throttleType -> new StringBuilder(1).append(throttleType.name()).append("-").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(15).append(prefix).append("-").append(threadType.name()).append("-thread-usage-").append(suffix).toString();
    }

    public ThreadUsageSensors(Metrics metrics, long inactiveSensorExpirationTimeSeconds) {
        this.metrics = metrics;
        this.inactiveSensorExpirationTimeSeconds = inactiveSensorExpirationTimeSeconds;
        this.lock = new ReentrantReadWriteLock();
        this.sensorAccessor = new SensorAccess(this.lock(), metrics);
    }
}

