/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.controller.KafkaController;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\b\u0010\u0001QA\u0001\"\n\u0001\u0003\u0006\u0004%IA\n\u0005\tU\u0001\u0011\t\u0011)A\u0005O!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00050\u0001\t\u0015\r\u0011\"\u00011\u0011!y\u0004A!A!\u0002\u0013\t\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b)\u0003A\u0011A&\t\u000fE\u0003!\u0019!C\u0005%\"1\u0011\f\u0001Q\u0001\nMCQA\u0017\u0001\u0005\nmCQ\u0001\u001f\u0001\u0005\u0002eDQ\u0001 \u0001\u0005\u0002uDq!!\u0007\u0001\t\u0003\tYB\u0001\nU_BL7mQ8oM&<\u0007*\u00198eY\u0016\u0014(B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001)2d\b\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"A\b\n\u0005yy!!D\"p]\u001aLw\rS1oI2,'\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002##\u0005)Q\u000f^5mg&\u0011A%\t\u0002\b\u0019><w-\u001b8h\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012a\n\t\u00039!J!!K\b\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0006lC\u001a\\\u0017mQ8oM&<\u0007C\u0001\u000f.\u0013\tqsBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AB9v_R\f7/F\u00012!\t\u0011DH\u0004\u00024u9\u0011A'\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003oM\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005A\t\u0012BA\u001e\u0010\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\tidHA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0003w=\tq!];pi\u0006\u001c\b%A\blC\u001a\\\u0017mQ8oiJ|G\u000e\\3s!\r1\"\tR\u0005\u0003\u0007^\u0011aa\u00149uS>t\u0007CA#I\u001b\u00051%BA$\u0012\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0003\u0013\u001a\u0013qbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1kej\u0014)\u0011\u0005q\u0001\u0001\"B\u0013\b\u0001\u00049\u0003\"B\u0016\b\u0001\u0004a\u0003\"B\u0018\b\u0001\u0004\t\u0004\"\u0002!\b\u0001\u0004\t\u0015A\u00037pO6\u000bg.Y4feV\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002W#\u0005\u0019An\\4\n\u0005a+&A\u0003'pO6\u000bg.Y4fe\u0006YAn\\4NC:\fw-\u001a:!\u0003=)\b\u000fZ1uK2{wmQ8oM&<G\u0003\u0002/`SN\u0004\"AF/\n\u0005y;\"\u0001B+oSRDQ\u0001\u0019\u0006A\u0002\u0005\fQ\u0001^8qS\u000e\u0004\"A\u00194\u000f\u0005\r$\u0007CA\u001b\u0018\u0013\t)w#\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3\u0018\u0011\u0015Q'\u00021\u0001l\u0003-!x\u000e]5d\u0007>tg-[4\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001B;uS2T\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\nQ\u0001K]8qKJ$\u0018.Z:\t\u000bQT\u0001\u0019A;\u0002)\r|gNZ5h\u001d\u0006lWm\u001d+p\u000bb\u001cG.\u001e3f!\r\u0011g/Y\u0005\u0003o\"\u00141aU3u\u0003Q\u0001(o\\2fgN\u001cuN\u001c4jO\u000eC\u0017M\\4fgR\u0019AL_>\t\u000b\u0001\\\u0001\u0019A1\t\u000b)\\\u0001\u0019A6\u00021A\f'o]3UQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7\u000fF\u0004\u007f\u0003\u001f\t\t\"!\u0006\u0011\u000b}\f)!!\u0003\u000e\u0005\u0005\u0005!bAA\u0002/\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0004'\u0016\f\bc\u0001\f\u0002\f%\u0019\u0011QB\f\u0003\u0007%sG\u000fC\u0003k\u0019\u0001\u00071\u000eC\u0004\u0002\u00141\u0001\r!!\u0003\u0002\u0011\t\u0014xn[3s\u0013\u0012Da!a\u0006\r\u0001\u0004\t\u0017\u0001\u00029s_B\fq\"\u001a=dYV$W\rZ\"p]\u001aLwm\u001d\u000b\u0006k\u0006u\u0011q\u0004\u0005\u0006A6\u0001\r!\u0019\u0005\u0006U6\u0001\ra\u001b")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final Option<KafkaController> kafkaController;
    private final LogManager logManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    /*
     * WARNING - void declaration
     */
    private void updateLogConfig(String topic, Properties topicConfig, Set<String> configNamesToExclude) {
        this.logManager().topicConfigUpdated(topic);
        Seq<AbstractLog> logs = this.logManager().logsByTopic(topic);
        if (logs.nonEmpty()) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            Properties props = new Properties();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(key, value) -> {
                if (!configNamesToExclude.contains(key)) {
                    return props.put(key, value);
                }
                return BoxedUnit.UNIT;
            };
            Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala());
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
            ((IterableLike)logs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicPartition(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                TopicConfigHandler.$anonfun$updateLogConfig$3(this, logConfig, topicPartition);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        this.updateLogConfig(topic, topicConfig, configNamesToExclude);
        this.updateThrottledList$1(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topicConfig, topic);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            this.kafkaController.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.enableTopicUncleanLeaderElection(topic);
                return BoxedUnit.UNIT;
            });
        }
        this.kafkaController.foreach((Function1 & Serializable & scala.Serializable)controller -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> controller.controllerContext().putMinIsrConfigValues(topic, new StringOps(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp()))).toInt())));
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        Object object;
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        if ("".equals(configValue)) {
            object = Nil$.MODULE$;
        } else {
            String string = ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue();
            if (!(string != null ? !string.equals(configValue) : configValue != null)) {
                object = Constants$.MODULE$.NoReplicas();
            } else {
                String string2 = ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue();
                object = !(string2 != null ? !string2.equals(configValue) : configValue != null) ? Constants$.MODULE$.AllReplicas() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(","))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$4))))).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq();
            }
        }
        return object;
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable & scala.Serializable)versionString -> {
            LogConfig.MessageFormatVersion messageFormatVersion = new LogConfig.MessageFormatVersion((String)versionString, $this.kafkaConfig.interBrokerProtocolVersion().version());
            if (messageFormatVersion.shouldIgnore()) {
                if (messageFormatVersion.shouldWarn()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> messageFormatVersion.topicWarningMessage(topic));
                }
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            if ($this.kafkaConfig.interBrokerProtocolVersion().$less(messageFormatVersion.messageFormatVersion())) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Topic configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append("is higher than what is allowed by the inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString());
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            return None$.MODULE$;
        })).toSet();
    }

    public static final /* synthetic */ void $anonfun$updateLogConfig$3(TopicConfigHandler $this, LogConfig logConfig$1, TopicPartition topicPartition) {
        $this.replicaManager().updateLogConfig(topicPartition, logConfig$1);
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4[1])).toInt() == brokerId$1;
    }

    public static final /* synthetic */ int $anonfun$parseThrottledPartitions$3(String[] x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5[0])).toInt();
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, Option<KafkaController> kafkaController) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
        Logging.$init$(this);
        this.logManager = replicaManager.logManager();
    }
}

