/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.TenantHelpers;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.ZkMetadataCache$;
import kafka.server.ZkMetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015c\u0001B'O\u0001MC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\")A\u000e\u0001C\u0001[\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bBB@\u0001A\u0003%1\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004!I!1\u000f\u0001A\u0002\u0013%!Q\u000f\u0005\t\u0005\u007f\u0002\u0001\u0015)\u0003\u0002\u0006!I!\u0011\u0012\u0001C\u0002\u0013%!1\u0012\u0005\t\u00053\u0003\u0001\u0015!\u0003\u0003\u000e\"9!1\u0014\u0001\u0005\n\tu\u0005b\u0002B_\u0001\u0011%!q\u0018\u0005\b\u0005g\u0004A\u0011\u0002B{\u0011\u001d\u0011i\u0010\u0001C\u0005\u0005\u007fDqa!\u0003\u0001\t\u0003\u0019Y\u0001C\u0005\u0004*\u0001\t\n\u0011\"\u0001\u0004,!I1q\u0006\u0001\u0012\u0002\u0013\u000511\u0006\u0005\b\u0007c\u0001A\u0011IB\u001a\u0011\u001d\u0019Y\u0004\u0001C!\u0007{Aqa!\r\u0001\t\u0013\u0019Y\u0005C\u0004\u0004R\u0001!Iaa\u0015\t\u000f\re\u0003\u0001\"\u0001\u0004\\!91q\f\u0001\u0005B\r\u0005\u0004bBB3\u0001\u0011\u00053q\r\u0005\b\u0007o\u0002A\u0011IB=\u0011\u001d\u0019y\b\u0001C!\u0007\u0003Cqaa\"\u0001\t\u0003\u0019I\tC\u0004\u0004\u0014\u0002!\ta!&\t\u000f\re\u0005\u0001\"\u0001\u0004\u001c\"911\u0015\u0001\u0005\u0002\r\u0015\u0006bBBX\u0001\u0011\u0005\u00111\u0015\u0005\b\u0007c\u0003A\u0011ABZ\u0011\u001d\u0019\t\r\u0001C\u0001\u0007\u0007Dqaa7\u0001\t\u0003\u0019i\u000eC\u0004\u0004\\\u0002!\ta!9\t\u000f\r\u0015\b\u0001\"\u0003\u0004h\"91Q\u001f\u0001\u0005\n\r]hABA\u0005\u0001\u0001\u000bY\u0001\u0003\u0006\u0002\u001a\u0019\u0012)\u001a!C\u0001\u00037A!\"! '\u0005#\u0005\u000b\u0011BA\u000f\u0011)\tyH\nBK\u0002\u0013\u0005\u0011\u0011\u0011\u0005\u000b\u0003\u00173#\u0011#Q\u0001\n\u0005\r\u0005BCAGM\tU\r\u0011\"\u0001\u0002\u0010\"Q\u0011q\u0014\u0014\u0003\u0012\u0003\u0006I!!%\t\u0015\u0005\u0005fE!f\u0001\n\u0003\t\u0019\u000b\u0003\u0006\u0002,\u001a\u0012\t\u0012)A\u0005\u0003KC!\"!,'\u0005+\u0007I\u0011AAX\u0011)\tyL\nB\tB\u0003%\u0011\u0011\u0017\u0005\u000b\u0003\u00034#Q3A\u0005\u0002\u0005\r\u0007BCApM\tE\t\u0015!\u0003\u0002F\"1AN\nC\u0001\u0003CD\u0011\"a<'\u0003\u0003%\t!!=\t\u0013\u0005}h%%A\u0005\u0002\t\u0005\u0001\"\u0003B\fME\u0005I\u0011\u0001B\r\u0011%\u0011iBJI\u0001\n\u0003\u0011y\u0002C\u0005\u0003$\u0019\n\n\u0011\"\u0001\u0003&!I!\u0011\u0006\u0014\u0012\u0002\u0013\u0005!1\u0006\u0005\n\u0005_1\u0013\u0013!C\u0001\u0005cA\u0011B!\u000e'\u0003\u0003%\tEa\u000e\t\u0013\t\rc%!A\u0005\u0002\t\u0015\u0003\"\u0003B$M\u0005\u0005I\u0011\u0001B%\u0011%\u0011)FJA\u0001\n\u0003\u00129\u0006C\u0005\u0003`\u0019\n\t\u0011\"\u0001\u0003b!I!Q\r\u0014\u0002\u0002\u0013\u0005#q\r\u0005\n\u0005S2\u0013\u0011!C!\u0005WB\u0011B!\u001c'\u0003\u0003%\tEa\u001c\b\u0013\u0011\u001d\u0001!!A\t\u0002\u0011%a!CA\u0005\u0001\u0005\u0005\t\u0012\u0001C\u0006\u0011\u0019aG\t\"\u0001\u0005\u001a!I!\u0011\u000e#\u0002\u0002\u0013\u0015#1\u000e\u0005\n\t7!\u0015\u0011!CA\t;A\u0011\u0002b\u000bE\u0003\u0003%\t\t\"\f\b\u0013\u0011mb*!A\t\u0002\u0011ub\u0001C'O\u0003\u0003E\t\u0001b\u0010\t\r1TE\u0011\u0001C!\u0011%!\u0019ESI\u0001\n\u0003\u0019YCA\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0015\ty\u0005+\u0001\u0004tKJ4XM\u001d\u0006\u0002#\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001U5z\u0003\"!\u0016-\u000e\u0003YS\u0011aV\u0001\u0006g\u000e\fG.Y\u0005\u00033Z\u0013a!\u00118z%\u00164\u0007CA.]\u001b\u0005q\u0015BA/O\u00055iU\r^1eCR\f7)Y2iKB\u0011qLY\u0007\u0002A*\u0011\u0011\rU\u0001\u0006kRLGn]\u0005\u0003G\u0002\u0014q\u0001T8hO&tw-\u0001\u0005ce>\\WM]%e!\t)f-\u0003\u0002h-\n\u0019\u0011J\u001c;\u0002\u001b%\u001cX*\u001e7uSR+g.\u00198u!\t)&.\u0003\u0002l-\n9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u0002o_B\u0004\"a\u0017\u0001\t\u000b\u0011\u001c\u0001\u0019A3\t\u000f!\u001c\u0001\u0013!a\u0001S\u0006)\u0002/\u0019:uSRLwN\\'fi\u0006$\u0017\r^1M_\u000e\\W#A:\u0011\u0005QlX\"A;\u000b\u0005Y<\u0018!\u00027pG.\u001c(B\u0001=z\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@v\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017A\u00069beRLG/[8o\u001b\u0016$\u0018\rZ1uC2{7m\u001b\u0011\u0002!5,G/\u00193bi\u0006\u001cf.\u00199tQ>$XCAA\u0003!\r\t9AJ\u0007\u0002\u0001\t\u0001R*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^\n\u0007MQ\u000bi!a\u0005\u0011\u0007U\u000by!C\u0002\u0002\u0012Y\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002V\u0003+I1!a\u0006W\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003=\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u001cXCAA\u000f!!\ty\"!\u000b\u0002.\u0005\rSBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u000f5,H/\u00192mK*\u0019\u0011q\u0005,\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0005\"!C!osJ+g-T1q!\u0011\ty#!\u0010\u000f\t\u0005E\u0012\u0011\b\t\u0004\u0003g1VBAA\u001b\u0015\r\t9DU\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mb+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\t\tE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003w1\u0006CBA\u0010\u0003\u000b\nI%\u0003\u0003\u0002H\u0005\u0005\"a\u0002'p]\u001el\u0015\r\u001d\t\u0005\u0003\u0017\n9H\u0004\u0003\u0002N\u0005Ed\u0002BA(\u0003WrA!!\u0015\u0002f9!\u00111KA1\u001d\u0011\t)&a\u0017\u000f\t\u0005M\u0012qK\u0005\u0003\u00033\n1a\u001c:h\u0013\u0011\ti&a\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI&C\u0002R\u0003GRA!!\u0018\u0002`%!\u0011qMA5\u0003\u0019\u0019w.\\7p]*\u0019\u0011+a\u0019\n\t\u00055\u0014qN\u0001\b[\u0016\u001c8/Y4f\u0015\u0011\t9'!\u001b\n\t\u0005M\u0014QO\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018M\u0003\u0003\u0002n\u0005=\u0014\u0002BA=\u0003w\u0012A$\u00169eCR,W*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0002t\u0005U\u0014\u0001\u00059beRLG/[8o'R\fG/Z:!\u00039!x\u000e]5dg\nKH+\u001a8b]R,\"!a!\u0011\u0011\u0005}\u0011\u0011FA\u0017\u0003\u000b\u0003b!a\b\u0002\b\u00065\u0012\u0002BAE\u0003C\u0011q\u0001S1tQN+G/A\bu_BL7m\u001d\"z)\u0016t\u0017M\u001c;!\u0003!!x\u000e]5d\u0013\u0012\u001cXCAAI!!\ty#a%\u0002.\u0005]\u0015\u0002BAK\u0003\u0003\u00121!T1q!\u0011\tI*a'\u000e\u0005\u0005=\u0014\u0002BAO\u0003_\u0012A!V;jI\u0006IAo\u001c9jG&#7\u000fI\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0003\u0003K\u0003B!VATK&\u0019\u0011\u0011\u0016,\u0003\r=\u0003H/[8o\u00035\u0019wN\u001c;s_2dWM]%eA\u0005a\u0011\r\\5wK\n\u0013xn[3sgV\u0011\u0011\u0011\u0017\t\u0007\u0003?\t)%a-\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/Q\u0003\u001d\u0019G.^:uKJLA!!0\u00028\n1!I]8lKJ\fQ\"\u00197jm\u0016\u0014%o\\6feN\u0004\u0013AC1mSZ,gj\u001c3fgV\u0011\u0011Q\u0019\t\u0007\u0003?\t)%a2\u0011\u0011\u0005%\u00171ZAg\u00033l!!!\n\n\t\u0005U\u0015Q\u0005\t\u0005\u0003\u001f\f).\u0004\u0002\u0002R*!\u00111[A8\u0003\u001dqW\r^<pe.LA!a6\u0002R\naA*[:uK:,'OT1nKB!\u0011\u0011TAn\u0013\u0011\ti.a\u001c\u0003\t9{G-Z\u0001\fC2Lg/\u001a(pI\u0016\u001c\b\u0005\u0006\b\u0002\u0006\u0005\r\u0018Q]At\u0003S\fY/!<\t\u000f\u0005e1\u00071\u0001\u0002\u001e!9\u0011qP\u001aA\u0002\u0005\r\u0005bBAGg\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003C\u001b\u0004\u0019AAS\u0011\u001d\tik\ra\u0001\u0003cCq!!14\u0001\u0004\t)-\u0001\u0003d_BLHCDA\u0003\u0003g\f)0a>\u0002z\u0006m\u0018Q \u0005\n\u00033!\u0004\u0013!a\u0001\u0003;A\u0011\"a 5!\u0003\u0005\r!a!\t\u0013\u00055E\u0007%AA\u0002\u0005E\u0005\"CAQiA\u0005\t\u0019AAS\u0011%\ti\u000b\u000eI\u0001\u0002\u0004\t\t\fC\u0005\u0002BR\u0002\n\u00111\u0001\u0002F\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0002U\u0011\tiB!\u0002,\u0005\t\u001d\u0001\u0003\u0002B\u0005\u0005'i!Aa\u0003\u000b\t\t5!qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0005W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005+\u0011YAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001c)\"\u00111\u0011B\u0003\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\t+\t\u0005E%QA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u00119C\u000b\u0003\u0002&\n\u0015\u0011AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0005[QC!!-\u0003\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001B\u001aU\u0011\t)M!\u0002\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u0004\u0005\u0003\u0003<\t\u0005SB\u0001B\u001f\u0015\r\u0011yd_\u0001\u0005Y\u0006tw-\u0003\u0003\u0002@\tu\u0012\u0001\u00049s_\u0012,8\r^!sSRLX#A3\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\nB)!\r)&QJ\u0005\u0004\u0005\u001f2&aA!os\"A!1K\u001f\u0002\u0002\u0003\u0007Q-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00053\u0002b!!3\u0003\\\t-\u0013\u0002\u0002B/\u0003K\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0011Na\u0019\t\u0013\tMs(!AA\u0002\t-\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0015\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005s\ta!Z9vC2\u001cHcA5\u0003r!I!1\u000b\"\u0002\u0002\u0003\u0007!1J\u0001\u0015[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R|F%Z9\u0015\t\t]$Q\u0010\t\u0004+\ne\u0014b\u0001B>-\n!QK\\5u\u0011%\u0011\u0019fBA\u0001\u0002\u0004\t)!A\tnKR\fG-\u0019;b':\f\u0007o\u001d5pi\u0002B3\u0001\u0003BB!\r)&QQ\u0005\u0004\u0005\u000f3&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0003\u000eB!!q\u0012BK\u001b\t\u0011\tJC\u0002\u0003\u0014B\u000b!bY8oiJ|G\u000e\\3s\u0013\u0011\u00119J!%\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0013\u0001G7bs\n,g)\u001b7uKJ\fE.\u001b<f%\u0016\u0004H.[2bgRQ!q\u0014BW\u0005c\u0013)L!/\u0011\r\t\u0005&1\u0015BT\u001b\u0005I\u0018b\u0001BSs\n!A*[:u!\u0011\u0011YD!+\n\t\t-&Q\b\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011yk\u0003a\u0001\u0003\u000b\t\u0001b\u001d8baNDw\u000e\u001e\u0005\b\u0005g[\u0001\u0019\u0001BP\u0003\u001d\u0011'o\\6feNDqAa.\f\u0001\u0004\ti-\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0003\u0004\u0003<.\u0001\r![\u0001\u001bM&dG/\u001a:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo]\u0001\u0015O\u0016$\b+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u0015\u0019\t\u0005'1\u001dBs\u0005S\u0014YOa<\u0011\u000bU\u000b9Ka1\u0011\r\t\u0015'q\u001aBk\u001d\u0011\u00119Ma3\u000f\t\u0005M\"\u0011Z\u0005\u0002/&\u0019!Q\u001a,\u0002\u000fA\f7m[1hK&!!\u0011\u001bBj\u0005!IE/\u001a:bE2,'b\u0001Bg-B!!q\u001bBo\u001d\u0011\tiE!7\n\t\tm\u0017QO\u0001\u0015\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t}'\u0011\u001d\u0002\u001a\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|gN\u0003\u0003\u0003\\\u0006U\u0004b\u0002BX\u0019\u0001\u0007\u0011Q\u0001\u0005\b\u0005Od\u0001\u0019AA\u0017\u0003\u0015!x\u000e]5d\u0011\u001d\u00119\f\u0004a\u0001\u0003\u001bDaA!<\r\u0001\u0004I\u0017!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiNDaA!=\r\u0001\u0004I\u0017!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u0019&\u001cH/\u001a8feN\f\u0001\u0003[1t\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u000f%\u00149P!?\u0003|\"9!qV\u0007A\u0002\u0005\u0015\u0001\"\u00023\u000e\u0001\u0004)\u0007b\u0002B\\\u001b\u0001\u0007\u0011QZ\u0001\u0011O\u0016$\u0018\t\\5wK\u0016sG\r]8j]R$\u0002b!\u0001\u0004\u0004\r\u00151q\u0001\t\u0006+\u0006\u001d\u0016\u0011\u001c\u0005\b\u0005_s\u0001\u0019AA\u0003\u0011\u0015!g\u00021\u0001f\u0011\u001d\u00119L\u0004a\u0001\u0003\u001b\f\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0015\r51\u0011DB\u0012\u0007K\u00199\u0003\u0005\u0004\u0002J\u000e=11C\u0005\u0005\u0007#\t)CA\u0002TKF\u0004BAa6\u0004\u0016%!1q\u0003Bq\u0005UiU\r^1eCR\f'+Z:q_:\u001cX\rV8qS\u000eDqaa\u0007\u0010\u0001\u0004\u0019i\"\u0001\u0004u_BL7m\u001d\t\u0007\u0003\u0013\u001cy\"!\f\n\t\r\u0005\u0012Q\u0005\u0002\u0004'\u0016$\bb\u0002B\\\u001f\u0001\u0007\u0011Q\u001a\u0005\t\u0005[|\u0001\u0013!a\u0001S\"A!\u0011_\b\u0011\u0002\u0003\u0007\u0011.\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0004.)\u001a\u0011N!\u0002\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\t\ru1Q\u0007\u0005\b\u0007o\u0011\u0002\u0019AB\u001d\u0003=!XM\\1oiB\u0013XMZ5y\u001fB$\b#B+\u0002(\u00065\u0012AE4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N$Baa\u0010\u0004HA1\u0011\u0011ZB\u0010\u0007\u0003\u0002B!!'\u0004D%!1QIA8\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dqa!\u0013\u0014\u0001\u0004\ti#A\u0005u_BL7MT1nKR11QDB'\u0007\u001fBqAa,\u0015\u0001\u0004\t)\u0001C\u0004\u00048Q\u0001\ra!\u000f\u0002!\u001d,G/\u00117m!\u0006\u0014H/\u001b;j_:\u001cH\u0003BB+\u0007/\u0002\u0002\"a\f\u0002\u0014\u000e\u0005\u0013\u0011\n\u0005\b\u0005_+\u0002\u0019AA\u0003\u0003Q9W\r\u001e(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dgR!1QDB/\u0011\u001d\u0019YB\u0006a\u0001\u0007;\ta\u0002[1t\u00032Lg/\u001a\"s_.,'\u000fF\u0002j\u0007GBQ\u0001Z\fA\u0002\u0015\fqbZ3u\u00032Lg/\u001a\"s_.,'o\u001d\u000b\u0003\u0007S\u0002bA!2\u0003P\u000e-\u0004\u0003BB7\u0007gj!aa\u001c\u000b\u0007\rE\u0004+A\u0003bI6Lg.\u0003\u0003\u0004v\r=$A\u0004\"s_.,'/T3uC\u0012\fG/Y\u0001\u0013O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$W\r\u0006\u0004\u0004\u0002\rm4Q\u0010\u0005\u0006If\u0001\r!\u001a\u0005\b\u0005oK\u0002\u0019AAg\u0003M9W\r^!mSZ,'I]8lKJtu\u000eZ3t)\u0011\u0019\u0019i!\"\u0011\r\t\u0015'qZAm\u0011\u001d\u00119L\u0007a\u0001\u0003\u001b\f\u0001cZ3u!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\r-5QRBH!\u0015)\u0016qUA%\u0011\u001d\u00119o\u0007a\u0001\u0003[Aaa!%\u001c\u0001\u0004)\u0017a\u00039beRLG/[8o\u0013\u0012\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001cH\u0003BAS\u0007/CqAa:\u001d\u0001\u0004\ti#\u0001\u000ehKR\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0005\u0004\u0002\ru5qTBQ\u0011\u001d\u00119/\ba\u0001\u0003[Aaa!%\u001e\u0001\u0004)\u0007b\u0002B\\;\u0001\u0007\u0011QZ\u0001\u001dO\u0016$\b+\u0019:uSRLwN\u001c*fa2L7-Y#oIB|\u0017N\u001c;t)\u0019\u00199k!+\u0004.B9\u0011qFAJK\u0006e\u0007bBBV=\u0001\u00071\u0011I\u0001\u0003iBDqAa.\u001f\u0001\u0004\ti-A\bhKR\u001cuN\u001c;s_2dWM]%e\u0003I9W\r^\"mkN$XM]'fi\u0006$\u0017\r^1\u0015\r\rU61XB`!\u0011\tIja.\n\t\re\u0016q\u000e\u0002\b\u00072,8\u000f^3s\u0011\u001d\u0019i\f\ta\u0001\u0003[\t\u0011b\u00197vgR,'/\u00133\t\u000f\t]\u0006\u00051\u0001\u0002N\u0006qQ\u000f\u001d3bi\u0016lU\r^1eCR\fGCBBc\u0007\u000f\u001cY\r\u0005\u0004\u0002J\u000e=1\u0011\t\u0005\u0007\u0007\u0013\f\u0003\u0019A3\u0002\u001b\r|'O]3mCRLwN\\%e\u0011\u001d\u0019i-\ta\u0001\u0007\u001f\fQ#\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0005\u0003\u0004R\u000e]WBABj\u0015\u0011\u0019).a\u001c\u0002\u0011I,\u0017/^3tiNLAa!7\u0004T\n)R\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$\u0018\u0001C2p]R\f\u0017N\\:\u0015\u0007%\u001cy\u000eC\u0004\u0003h\n\u0002\r!!\f\u0015\u0007%\u001c\u0019\u000fC\u0004\u0004,\u000e\u0002\ra!\u0011\u00021\u0005$Gm\u0014:Va\u0012\fG/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0007\u0003x\r%81^Bw\u0007_\u001c\t\u0010C\u0004\u0002\u001a\u0011\u0002\r!!\b\t\u000f\u0005}D\u00051\u0001\u0002\u0004\"9!q\u001d\u0013A\u0002\u00055\u0002BBBII\u0001\u0007Q\rC\u0004\u0004t\u0012\u0002\r!!\u0013\u0002\u0013M$\u0018\r^3J]\u001a|\u0017a\u0005:f[>4X\rU1si&$\u0018n\u001c8J]\u001a|G\u0003\u0004B<\u0007s\u001cYp!@\u0005\u0004\u0011\u0015\u0001bBA\rK\u0001\u0007\u0011Q\u0004\u0005\b\u0003\u007f*\u0003\u0019AAB\u0011\u001d\ti)\na\u0001\u0007\u007f\u0004\u0002\"a\b\u0005\u0002\u00055\u0012qS\u0005\u0005\u0003+\u000b\t\u0003C\u0004\u0003h\u0016\u0002\r!!\f\t\r\rEU\u00051\u0001f\u0003AiU\r^1eCR\f7K\\1qg\"|G\u000fE\u0002\u0002\b\u0011\u001bR\u0001\u0012C\u0007\u0003'\u0001\"\u0003b\u0004\u0005\u0016\u0005u\u00111QAI\u0003K\u000b\t,!2\u0002\u00065\u0011A\u0011\u0003\u0006\u0004\t'1\u0016a\u0002:v]RLW.Z\u0005\u0005\t/!\tBA\tBEN$(/Y2u\rVt7\r^5p]Z\"\"\u0001\"\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001d\u0005\u0015Aq\u0004C\u0011\tG!)\u0003b\n\u0005*!9\u0011\u0011D$A\u0002\u0005u\u0001bBA@\u000f\u0002\u0007\u00111\u0011\u0005\b\u0003\u001b;\u0005\u0019AAI\u0011\u001d\t\tk\u0012a\u0001\u0003KCq!!,H\u0001\u0004\t\t\fC\u0004\u0002B\u001e\u0003\r!!2\u0002\u000fUt\u0017\r\u001d9msR!Aq\u0006C\u001c!\u0015)\u0016q\u0015C\u0019!=)F1GA\u000f\u0003\u0007\u000b\t*!*\u00022\u0006\u0015\u0017b\u0001C\u001b-\n1A+\u001e9mKZB\u0011\u0002\"\u000fI\u0003\u0003\u0005\r!!\u0002\u0002\u0007a$\u0003'A\b[W6+G/\u00193bi\u0006\u001c\u0015m\u00195f!\tY&j\u0005\u0002K)R\u0011AQH\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final boolean isMultiTenant;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return ZkMetadataCache$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(scala.math.package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(brokers).asScala()).foreach((Function1 & Serializable & scala.Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            if (x0$1 == null) throw new MatchError(null);
            long partitionId = x0$1._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            List replicas = partitionState.replicas();
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            List isr = partitionState.isr();
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
            List offlineReplicas = partitionState.offlineReplicas();
            List observers = partitionState.observers();
            List<Integer> filteredObservers = this.maybeFilterAliveReplicas(snapshot, observers, listenerName, errorUnavailableEndpoints);
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors2;
                if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors2 = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                    errors2 = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors2;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
            }
            if (!(maybeLeader instanceof Some)) throw new MatchError(maybeLeader);
            if (filteredReplicas.size() < replicas.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else if (filteredIsr.size() < isr.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(isr).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else {
                errors = Errors.NONE;
            }
            Errors error = errors;
            return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (!this.isMultiTenant && tenantPrefixOpt.isDefined()) {
            throw new IllegalStateException("Multi-tenant getAllTopics but metadataCache is not multitenant. Multitenant interceptor and multitenant metadata must always be configured together in a multitenant broker.");
        }
        return this.getAllTopics(this.metadataSnapshot(), tenantPrefixOpt);
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((TraversableOnce)((MapLike)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(topicName, p.partitionIndex()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot, Option<String> tenantPrefixOpt) {
        Set set;
        if (tenantPrefixOpt instanceof Some) {
            String tenantPrefix = (String)((Some)tenantPrefixOpt).value();
            set = (Set)snapshot.topicsByTenant().getOrElse((Object)tenantPrefix, (Function0 & Serializable & scala.Serializable)() -> Set$.MODULE$.empty());
        } else if (None$.MODULE$.equals(tenantPrefixOpt)) {
            set = snapshot.partitionStates().keySet();
        } else {
            throw new MatchError(tenantPrefixOpt);
        }
        return set;
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                long partition = x0$2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return topics.diff((GenSet)this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> Option$.MODULE$.option2Iterable(x$5.getNode(listenerName)), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                node = (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.get((long)tp.partition())).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long id = x0$1._1$mcJ$sp();
            Map nodesByListener = (Map)x0$1._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(nodesByListener.get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node)));
            return iterable;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
            PartitionInfo partitionInfo = PartitionInfo.of((String)tp.topic(), (int)tp.partition(), (Node)ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.observers()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))), (Node[])((Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot, (Option<String>)None$.MODULE$).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$10(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.partitionMetadataLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        String tenantPrefix;
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
        if (this.isMultiTenant && (tenantPrefix = TenantHelpers.extractTenantPrefix(topic)) != null) {
            ((HashSet)topicsByTenant.getOrElseUpdate((Object)tenantPrefix, (Function0 & Serializable & scala.Serializable)() -> HashSet$.MODULE$.empty())).add((Object)topic);
            return;
        }
    }

    private void removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        partitionStates.get((Object)topic).foreach((Function1 & Serializable & scala.Serializable)infos -> {
            ZkMetadataCache.$anonfun$removePartitionInfo$1(this, partitionId, partitionStates, topic, topicIds, topicsByTenant, infos);
            return BoxedUnit.UNIT;
        });
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Node)pair._2()).isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable & scala.Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$10(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$10)))) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x$11) {
        Object object = x$11._2();
        Uuid uuid = Uuid.ZERO_UUID;
        return object == null ? uuid != null : !object.equals(uuid);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            java.util.Map tags = UpdateMetadataRequest.tagMapFromBrokerTagCollection((List)broker.tags());
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new ConfluentNode(broker.id(), ep.host(), ep.port(), broker.rack(), tags));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack()), (scala.collection.immutable.Map<String, String>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(tags).asScala()).toMap(Predef$.MODULE$.$conforms())));
            aliveNodes.update((long)broker.id(), CollectionConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map newTopicIds = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest$1.topicStates()).asScala()).map((Function1 & Serializable & scala.Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(x$11)))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Map topicIds = Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        topicIds.$plus$plus$eq((TraversableOnce)newTopicIds);
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), $this.metadataSnapshot().topicsByTenant(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            void forKeyValue$extension_f2;
            void forKeyValue$extension_$this2;
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topic, partitions) -> {
                partitionStates.update((Object)topic, (Object)partitions.clone());
                return BoxedUnit.UNIT;
            };
            Map<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods($this.metadataSnapshot().partitionStates());
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
            AnyRefMap topicsByTenant = new AnyRefMap($this.metadataSnapshot().topicsByTenant().size());
            Function2 & Serializable & scala.Serializable intersect2 = (Function2 & Serializable & scala.Serializable)(tenantPrefix, topics) -> {
                topicsByTenant.update((Object)tenantPrefix, (Object)topics.clone());
                return BoxedUnit.UNIT;
            };
            Map<String, HashSet<String>> map2 = Implicits$.MODULE$.MapExtensionMethods($this.metadataSnapshot().topicsByTenant());
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable & scala.Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (AnyRefMap<String, HashSet<String>>)topicsByTenant, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ void $anonfun$removePartitionInfo$1(ZkMetadataCache $this, int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, AnyRefMap topicsByTenant$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            String tenantPrefix;
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
            if ($this.isMultiTenant && (tenantPrefix = TenantHelpers.extractTenantPrefix(topic$4)) != null) {
                topicsByTenant$2.get((Object)tenantPrefix).foreach((Function1 & Serializable & scala.Serializable)topics -> {
                    topics.remove((Object)topic$4);
                    if (topics.isEmpty()) {
                        return topicsByTenant$2.remove((Object)tenantPrefix);
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
    }

    public ZkMetadataCache(int brokerId, boolean isMultiTenant) {
        this.brokerId = brokerId;
        this.isMultiTenant = isMultiTenant;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (AnyRefMap<String, HashSet<String>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final AnyRefMap<String, HashSet<String>> topicsByTenant;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ ZkMetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public AnyRefMap<String, HashSet<String>> topicsByTenant() {
            return this.topicsByTenant;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicsByTenant, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public AnyRefMap<String, HashSet<String>> copy$default$2() {
            return this.topicsByTenant();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$3() {
            return this.topicIds();
        }

        public Option<Object> copy$default$4() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$5() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$6() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicsByTenant();
                }
                case 2: {
                    return this.topicIds();
                }
                case 3: {
                    return this.controllerId();
                }
                case 4: {
                    return this.aliveBrokers();
                }
                case 5: {
                    return this.aliveNodes();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)x$1).kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            AnyRefMap<String, HashSet<String>> anyRefMap3 = this.topicsByTenant();
            AnyRefMap<String, HashSet<String>> anyRefMap4 = metadataSnapshot.topicsByTenant();
            if (anyRefMap3 == null) {
                if (anyRefMap4 != null) {
                    return false;
                }
            } else if (!anyRefMap3.equals(anyRefMap4)) return false;
            scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
            scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, AnyRefMap<String, HashSet<String>> topicsByTenant, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicsByTenant = topicsByTenant;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

