/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.server.checkpoints.CheckpointReadBuffer;
import kafka.utils.Logging;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001\u0002\n\u0014\u0001iA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000ba\u0003A\u0011A-\t\u000f\u0001\u0004!\u0019!C\u0005C\"1\u0011\u000e\u0001Q\u0001\n\tDqA\u001b\u0001C\u0002\u0013%\u0011\r\u0003\u0004l\u0001\u0001\u0006IA\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019!\b\u0001)A\u0005]\")Q\u000f\u0001C\u0001m\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u00059\u0019\u0005.Z2la>Lg\u000e\u001e$jY\u0016T!\u0001F\u000b\u0002\u0017\rDWmY6q_&tGo\u001d\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001U\u00111DP\n\u0004\u0001q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g\r\u0005\u0002$M5\tAE\u0003\u0002&/\u0005)Q\u000f^5mg&\u0011q\u0005\n\u0002\b\u0019><w-\u001b8h\u0003\u00111\u0017\u000e\\3\u0016\u0003)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u0005%|'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c1\u0012AAR5mK\u0006)a-\u001b7fA\u00059a/\u001a:tS>t\u0007CA\u000f6\u0013\t1dDA\u0002J]R\f\u0011BZ8s[\u0006$H/\u001a:\u0011\u0007eRD(D\u0001\u0014\u0013\tY4CA\fDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3G_Jl\u0017\r\u001e;feB\u0011QH\u0010\u0007\u0001\t\u0015y\u0004A1\u0001A\u0005\u0005!\u0016CA!E!\ti\")\u0003\u0002D=\t9aj\u001c;iS:<\u0007CA\u000fF\u0013\t1eDA\u0002B]f\fA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007CA%K\u001b\u0005)\u0012BA&\u0016\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u00061An\\4ESJ\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)\u001f\u001b\u0005\t&B\u0001*\u001a\u0003\u0019a$o\\8u}%\u0011AKH\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U=\u00051A(\u001b8jiz\"bAW.];z{\u0006cA\u001d\u0001y!)\u0001f\u0002a\u0001U!)1g\u0002a\u0001i!)qg\u0002a\u0001q!)qi\u0002a\u0001\u0011\")Aj\u0002a\u0001\u001b\u0006!\u0001/\u0019;i+\u0005\u0011\u0007CA2h\u001b\u0005!'B\u0001\u0015f\u0015\t1g&A\u0002oS>L!\u0001\u001b3\u0003\tA\u000bG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\ti\u0016l\u0007\u000fU1uQ\u0006IA/Z7q!\u0006$\b\u000eI\u0001\u0005Y>\u001c7.F\u0001o!\ty'/D\u0001q\u0015\t\th&\u0001\u0003mC:<\u0017BA:q\u0005\u0019y%M[3di\u0006)An\\2lA\u0005)qO]5uKR\u0011qO\u001f\t\u0003;aL!!\u001f\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006w:\u0001\r\u0001`\u0001\bK:$(/[3t!\u0011i\u0018Q\u0001\u001f\u000f\u0007y\f\tA\u0004\u0002Q\u007f&\tq$C\u0002\u0002\u0004y\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0005%!\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005\ra$\u0001\txe&$X\rV8CsR,\u0017I\u001d:bsR!\u0011qBA\u000e!\u0015i\u0012\u0011CA\u000b\u0013\r\t\u0019B\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004;\u0005]\u0011bAA\r=\t!!)\u001f;f\u0011\u0019\tib\u0004a\u0001y\u00061Q\r]8dQN\fQb\u001e:ji\u0016$vn\u0016:ji\u0016\u0014H#B<\u0002$\u0005\u0015\u0002\"B>\u0011\u0001\u0004a\bbBA\u0014!\u0001\u0007\u0011\u0011F\u0001\u0007oJLG/\u001a:\u0011\u0007-\nY#C\u0002\u0002.1\u0012aBQ;gM\u0016\u0014X\rZ,sSR,'/\u0001\u0003sK\u0006$GCAA\u001a!\u0015\t)$a\u000f=\u001b\t\t9DC\u0002\u0002:y\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti$a\u000e\u0003\u0007M+\u0017\u000f")
public class CheckpointFile<T>
implements Logging {
    private final File file;
    private final int version;
    private final CheckpointFileFormatter<T> formatter;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String logDir;
    private final Path path;
    private final Path tempPath;
    private final Object lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    private Path path() {
        return this.path;
    }

    private Path tempPath() {
        return this.tempPath;
    }

    private Object lock() {
        return this.lock;
    }

    public void write(Iterable<T> entries) {
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(entries);
            return;
        }
    }

    public byte[] writeToByteArray(Iterable<T> epochs) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8));){
            this.writeToWriter(epochs, bufferedWriter);
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private void writeToWriter(Iterable<T> entries, BufferedWriter writer) {
        writer.write(Integer.toString(this.version));
        writer.newLine();
        writer.write(Integer.toString(entries.size()));
        writer.newLine();
        entries.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            CheckpointFile.$anonfun$writeToWriter$1(this, writer, entry);
            return BoxedUnit.UNIT;
        });
        writer.flush();
    }

    public Seq<T> read() {
        Object object = this.lock();
        synchronized (object) {
            Seq seq = this.liftedTree2$1();
            return seq;
        }
    }

    private final /* synthetic */ void liftedTree1$1(Iterable entries$1) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempPath().toFile());
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));){
                this.writeToWriter(entries$1, writer);
                fileOutputStream.getFD().sync();
            }
            Utils.atomicMoveWithFallback((Path)this.tempPath(), (Path)this.path());
            return;
        }
        catch (IOException e) {
            String msg = new StringBuilder(39).append("Error while writing to checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$writeToWriter$1(CheckpointFile $this, BufferedWriter writer$1, Object entry) {
        writer$1.write($this.formatter.toLine(entry));
        writer$1.newLine();
    }

    private final /* synthetic */ Seq liftedTree2$1() {
        try {
            Seq<T> seq;
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                seq = new CheckpointReadBuffer<T>(this.file().getAbsolutePath(), reader, this.version, this.formatter).read();
            }
            return seq;
        }
        catch (IOException e) {
            String msg = new StringBuilder(36).append("Error while reading checkpoint file ").append(this.file().getAbsolutePath()).toString();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public CheckpointFile(File file, int version, CheckpointFileFormatter<T> formatter, LogDirFailureChannel logDirFailureChannel, String logDir) {
        this.file = file;
        this.version = version;
        this.formatter = formatter;
        this.logDirFailureChannel = logDirFailureChannel;
        this.logDir = logDir;
        Logging.$init$(this);
        this.path = file.toPath().toAbsolutePath();
        this.tempPath = Paths.get(new StringBuilder(4).append(((Object)this.path()).toString()).append(".tmp").toString(), new String[0]);
        this.lock = new Object();
        try {
            Files.createFile(file.toPath(), new FileAttribute[0]);
            return;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            return;
        }
    }
}

