/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.server.DelayedFuturePurgatory;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAdminClient$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkManager$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$PendingStoppedMirror$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.LinkMode;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.server.link.LinkState;
import kafka.server.link.PausedClusterLink$;
import kafka.server.link.UnavailableClusterLink$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rEa\u0001B\u0011#\u0001%B\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0001\"AQ\t\u0001BC\u0002\u0013\u0005a\t\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003H\u0011!\u0019\u0006A!b\u0001\n\u0003!\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011q\u0003!Q1A\u0005\u0002uC\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"Aq\u000e\u0001B\u0001B\u0003%\u0001\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0004\u007f\u0001\t\u0007I\u0011B@\t\u0011\u0005\u001d\u0001\u0001)A\u0005\u0003\u0003Aq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAw\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0003{\u0004A\u0011AA\u0000\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u0003(\u0001!IA!\u000b\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!\u0011\n\u0001\u0005\u0002\t-\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005K\u0002A\u0011\u0002B4\u0011\u001d\u0011)\n\u0001C\u0005\u0005/CqAa.\u0001\t\u0013\u0011I\fC\u0004\u0003P\u0002!IA!5\t\u000f\t\u001d\b\u0001\"\u0003\u0003j\"9!1\u001f\u0001\u0005\n\tU\bb\u0002B|\u0001\u0011%!\u0011 \u0002\u0018\u00072,8\u000f^3s\u0019&t7.\u00113nS:l\u0015M\\1hKJT!a\t\u0013\u0002\t1Lgn\u001b\u0006\u0003K\u0019\naa]3sm\u0016\u0014(\"A\u0014\u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u000b\u00199!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011'\u000e\b\u0003eMj\u0011AI\u0005\u0003i\t\n!c\u00117vgR,'\u000fT5oW\u001a\u000b7\r^8ss&\u0011ag\u000e\u0002\r\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\u0006\u0003i\t\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0014\u0002\u000bU$\u0018\u000e\\:\n\u0005uR$a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0016\u0003\u0001\u0003\"!\u0011\"\u000e\u0003\u0011J!a\u0011\u0013\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u00039awnY1m\u00072,8\u000f^3s\u0013\u0012,\u0012a\u0012\t\u0003\u0011>s!!S'\u0011\u0005)cS\"A&\u000b\u00051C\u0013A\u0002\u001fs_>$h(\u0003\u0002OY\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tqE&A\bm_\u000e\fGn\u00117vgR,'/\u00133!\u0003!Q8n\u00117jK:$X#A+\u0011\u0005YKV\"A,\u000b\u0005a3\u0013A\u0001>l\u0013\tQvKA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\n!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\ta\f\u0005\u00023?&\u0011\u0001M\t\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T1oC\u001e,'/A\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b%A\u0004nKR\u0014\u0018nY:\u0011\u0005\u0011lW\"A3\u000b\u0005\t4'BA4i\u0003\u0019\u0019w.\\7p]*\u0011q%\u001b\u0006\u0003U.\fa!\u00199bG\",'\"\u00017\u0002\u0007=\u0014x-\u0003\u0002oK\n9Q*\u001a;sS\u000e\u001c\u0018\u0001\u0002;j[\u0016\u0004\"!]:\u000e\u0003IT!a\u000f4\n\u0005Q\u0014(\u0001\u0002+j[\u0016\fa\u0001P5oSRtDcB<ysj\\H0 \t\u0003e\u0001AQAP\u0006A\u0002\u0001CQ!R\u0006A\u0002\u001dCQaU\u0006A\u0002UCQ\u0001X\u0006A\u0002yCQAY\u0006A\u0002\rDQa\\\u0006A\u0002A\f\u0011\u0002];sO\u0006$xN]=\u0016\u0005\u0005\u0005\u0001cA!\u0002\u0004%\u0019\u0011Q\u0001\u0013\u0003-\u0011+G.Y=fI\u001a+H/\u001e:f!V\u0014x-\u0019;pef\f!\u0002];sO\u0006$xN]=!\u0003Q!(/_\"p[BdW\r^3FYN,w+\u0019;dQV!\u0011QBA$)!\ty!!\u0006\u0002 \u0005e\u0003cA\u0016\u0002\u0012%\u0019\u00111\u0003\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003/q\u0001\u0019AA\r\u0003%!\u0018.\\3pkRl5\u000fE\u0002,\u00037I1!!\b-\u0005\u0011auN\\4\t\u000f\u0005\u0005b\u00021\u0001\u0002$\u00059a-\u001e;ve\u0016\u001c\bCBA\u0013\u0003W\ty#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0017\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002.\u0005\u001d\"aA*fcB1\u0011\u0011GA \u0003\u0007j!!a\r\u000b\t\u0005U\u0012qG\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u001d\u0003w\tA!\u001e;jY*\u0011\u0011QH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002B\u0005M\"!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!\u0011QIA$\u0019\u0001!q!!\u0013\u000f\u0005\u0004\tYEA\u0001U#\u0011\ti%a\u0015\u0011\u0007-\ny%C\u0002\u0002R1\u0012qAT8uQ&tw\rE\u0002,\u0003+J1!a\u0016-\u0005\r\te.\u001f\u0005\b\u00037r\u0001\u0019AA/\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000eE\u0003,\u0003?\ny!C\u0002\u0002b1\u0012\u0011BR;oGRLwN\u001c\u0019\u0002\u0011MDW\u000f\u001e3po:$\"!a\u0004\u0002#\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000e\u0006\t\u0002l\u0005e\u0014QRAL\u0003O\u000b\t,!.\u0002>B1\u0011\u0011GA \u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\nY$\u0001\u0003mC:<\u0017\u0002BA<\u0003c\u0012AAV8jI\"9\u00111\u0010\tA\u0002\u0005u\u0014A\u00048fo\u000ecWo\u001d;fe2Kgn\u001b\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0015\tG-\\5o\u0015\r\t9\t[\u0001\bG2LWM\u001c;t\u0013\u0011\tY)!!\u0003\u001d9+wo\u00117vgR,'\u000fT5oW\"9\u0011q\u0012\tA\u0002\u0005E\u0015\u0001\u0004;f]\u0006tG\u000f\u0015:fM&D\b\u0003B\u0016\u0002\u0014\u001eK1!!&-\u0005\u0019y\u0005\u000f^5p]\"9\u0011\u0011\u0014\tA\u0002\u0005m\u0015a\u0005:fcV,7\u000f\u001e'jgR,g.\u001a:OC6,\u0007\u0003BAO\u0003Gk!!a(\u000b\u0007\u0005\u0005f-A\u0004oKR<xN]6\n\t\u0005\u0015\u0016q\u0014\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0003S\u0003\u0002\u0019AAV\u000311\u0018\r\\5eCR,wJ\u001c7z!\rY\u0013QV\u0005\u0004\u0003_c#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003g\u0003\u0002\u0019AAV\u000311\u0018\r\\5eCR,G*\u001b8l\u0011\u001d\t9\u0002\u0005a\u0001\u0003o\u00032aKA]\u0013\r\tY\f\f\u0002\u0004\u0013:$\bbBA`!\u0001\u0007\u0011qW\u0001\u000bCBLg+\u001a:tS>t\u0017\u0001\u00057jgR\u001cE.^:uKJd\u0015N\\6t)!\t)-a7\u0002h\u0006-\bCBAd\u0003#\f)N\u0004\u0003\u0002J\u00065gb\u0001&\u0002L&\tQ&C\u0002\u0002P2\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002.\u0005M'bAAhYA!\u0011qPAl\u0013\u0011\tI.!!\u0003%\rcWo\u001d;fe2Kgn\u001b'jgRLgn\u001a\u0005\b\u0003;\f\u0002\u0019AAp\u0003%a\u0017N\\6OC6,7\u000fE\u0003,\u0003'\u000b\t\u000f\u0005\u0003I\u0003G<\u0015bAAs#\n\u00191+\u001a;\t\u000f\u0005%\u0018\u00031\u0001\u0002,\u0006i\u0011N\\2mk\u0012,Gk\u001c9jGNDq!a0\u0012\u0001\u0004\t9,A\teK2,G/Z\"mkN$XM\u001d'j].$\"\"a\u0004\u0002r\u0006U\u0018q_A~\u0011\u0019\t\u0019P\u0005a\u0001\u000f\u0006AA.\u001b8l\u001d\u0006lW\rC\u0004\u0002*J\u0001\r!a+\t\u000f\u0005e(\u00031\u0001\u0002,\u0006)am\u001c:dK\"9\u0011q\u0018\nA\u0002\u0005]\u0016aC1mi\u0016\u0014X*\u001b:s_J$\"\"a\u001b\u0003\u0002\t\u0015!q\u0002B\t\u0011\u0019\u0011\u0019a\u0005a\u0001\u000f\u0006)Ao\u001c9jG\"9!qA\nA\u0002\t%\u0011AA8q!\u0011\tyHa\u0003\n\t\t5\u0011\u0011\u0011\u0002\u000e\u00032$XM]'jeJ|'o\u00149\t\u000f\u0005%6\u00031\u0001\u0002,\"9\u0011qX\nA\u0002\u0005]\u0016aD:u_Bl\u0015N\u001d:peR{\u0007/[2\u0015\u0011\u0005-$q\u0003B\r\u0005;AaAa\u0001\u0015\u0001\u00049\u0005b\u0002B\u000e)\u0001\u0007\u00111V\u0001\fgft7\r\u001b:p]&TX\rC\u0004\u0002*R\u0001\r!a+\u0002!\rdW-\u0019:NSJ\u0014xN\u001d+pa&\u001cGCBA6\u0005G\u0011)\u0003\u0003\u0004\u0003\u0004U\u0001\ra\u0012\u0005\b\u0003S+\u0002\u0019AAV\u0003A\u0001\u0018-^:f\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0006\u0002l\t-\"Q\u0006B\u0019\u0005kAaAa\u0001\u0017\u0001\u00049\u0005b\u0002B\u0018-\u0001\u0007\u00111V\u0001\u0007K:\f'\r\\3\t\u000f\tMb\u00031\u0001\u0002,\u0006Y\u0011n\u001d'j].dUM^3m\u0011\u001d\tIK\u0006a\u0001\u0003W\u000b1\u0002\\5ti6K'O]8sgRA!1\bB!\u0005\u0007\u00129\u0005E\u0003\u0002H\nur)\u0003\u0003\u0003@\u0005M'\u0001C%uKJ\f'\r\\3\t\u000f\u0005Mx\u00031\u0001\u0002\u0012\"9!QI\fA\u0002\u0005-\u0016AD5oG2,H-Z*u_B\u0004X\r\u001a\u0005\b\u0003\u007f;\u0002\u0019AA\\\u00039!Wm]2sS\n,W*\u001b:s_J$bA!\u0014\u0003T\tU\u0003\u0003BA@\u0005\u001fJAA!\u0015\u0002\u0002\n1R*\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000e\u0003\u0004\u0003\u0004a\u0001\ra\u0012\u0005\b\u0003\u007fC\u0002\u0019AA\\\u00035I7\u000fV8qS\u000e\u0004\u0016-^:fIR!\u00111\u0016B.\u0011\u001d\u0011i&\u0007a\u0001\u0005?\nQa\u001d;bi\u0016\u00042A\rB1\u0013\r\u0011\u0019G\t\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eV8qS\u000e\u001cF/\u0019;f\u0003]1\u0017N\\5tQ\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000e\u0006\t\u0002\u0010\t%$1\u000eB=\u0005{\u0012yH!#\u0003\u0014\"1\u00111\u001f\u000eA\u0002\u001dCqA!\u001c\u001b\u0001\u0004\u0011y'\u0001\u0004mS:\\\u0017\n\u001a\t\u0006W\u0005M%\u0011\u000f\t\u0005\u0005g\u0012)(\u0004\u0002\u00028%!!qOA\u001c\u0005\u0011)V+\u0013#\t\u000f\tm$\u00041\u0001\u0002\u0012\u0006iA.\u001b8l\u00072,8\u000f^3s\u0013\u0012Dq!a$\u001b\u0001\u0004\t\t\nC\u0004\u0003\u0002j\u0001\rAa!\u0002\u00151Lgn[\"p]\u001aLw\rE\u00023\u0005\u000bK1Aa\"#\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0005\b\u0005\u0017S\u0002\u0019\u0001BG\u0003=\u0001XM]:jgR,g\u000e\u001e)s_B\u001c\b\u0003\u0002B:\u0005\u001fKAA!%\u00028\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005%&\u00041\u0001\u0002,\u0006yq/\u001b;i%\u0016lw\u000e^3BI6Lg.\u0006\u0003\u0003\u001a\n}E\u0003\u0003BN\u0005c\u0013\u0019L!.\u0015\t\tu%\u0011\u0015\t\u0005\u0003\u000b\u0012y\nB\u0004\u0002Jm\u0011\r!a\u0013\t\u000f\t\r6\u00041\u0001\u0003&\u0006!a-\u001e8d!\u001dY#q\u0015BV\u0005;K1A!+-\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u0000\t5\u0016\u0002\u0002BX\u0003\u0003\u0013abQ8oM2,XM\u001c;BI6Lg\u000e\u0003\u0004\u0002tn\u0001\ra\u0012\u0005\b\u0005\u0003[\u0002\u0019\u0001BB\u0011\u001d\tyi\u0007a\u0001\u0003#\u000baD^1mS\u0012\fG/\u001a#fgRLg.\u0019;j_:\u001cE.^:uKJd\u0015N\\6\u0015\u0019\u0005E%1\u0018Bb\u0005\u000f\u0014YM!4\t\u000f\u0005\rE\u00041\u0001\u0003>B!\u0011q\u0010B`\u0013\u0011\u0011\t-!!\u0003\u000b\u0005#W.\u001b8\t\u000f\t\u0015G\u00041\u0001\u0002\u0012\u0006\tR\r\u001f9fGR,Gm\u00117vgR,'/\u00133\t\u000f\t%G\u00041\u0001\u0003\u000e\u0006)\u0001O]8qg\"9\u0011q\u0003\u000fA\u0002\u0005]\u0006BBAz9\u0001\u0007q)A\rwC2LG-\u0019;f'>,(oY3DYV\u001cH/\u001a:MS:\\G\u0003\u0004Bj\u00053\u0014iNa8\u0003b\n\u0015\bCB\u0016\u0003V\nEt)C\u0002\u0003X2\u0012a\u0001V;qY\u0016\u0014\u0004b\u0002Bn;\u0001\u0007!1V\u0001\fe\u0016lw\u000e^3BI6Lg\u000e\u0003\u0004\u0002tv\u0001\ra\u0012\u0005\b\u0003\u001fk\u0002\u0019AAI\u0011\u001d\u0011\u0019/\ba\u0001\u0003#\u000bQ#\u001a=qK\u000e$X\r\u001a#fgR\u001cE.^:uKJLE\rC\u0004\u0002\u0018u\u0001\r!a.\u0002%\u001d,G/\u00117m\u001b&\u0014(o\u001c:U_BL7m\u001d\u000b\u0005\u0005W\u0014\t\u0010E\u0004\u0002&\t5xIa\u0018\n\t\t=\u0018q\u0005\u0002\u0004\u001b\u0006\u0004\bb\u0002B#=\u0001\u0007\u00111V\u0001\u0018O\u0016$\u0018\t\u001c7NSJ\u0014xN\u001d+pa&\u001c7/\u00138Vg\u0016,\"Aa;\u0002'Y\fG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\u0015\t\tm8q\u0001\t\u0005\u0005{\u001c\u0019!\u0004\u0002\u0003\u0000*\u00191\u0011\u00014\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\u0019)Aa@\u0003\u0019\u0005\u0003\u0018.\u0012=dKB$\u0018n\u001c8\t\u000f\r%\u0001\u00051\u0001\u0004\f\u0005IA\u000f\u001b:po\u0006\u0014G.\u001a\t\u0005\u0003\u000f\u001ci!\u0003\u0003\u0004\u0010\u0005M'!\u0003+ie><\u0018M\u00197f\u0001")
public class ClusterLinkAdminManager
implements ClusterLinkFactory.AdminManager,
Logging {
    private final KafkaConfig config;
    private final String localClusterId;
    private final KafkaZkClient zkClient;
    private final ClusterLinkManager clusterLinkManager;
    private final Metrics metrics;
    private final Time time;
    private final DelayedFuturePurgatory purgatory;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private DelayedFuturePurgatory purgatory() {
        return this.purgatory;
    }

    @Override
    public <T> void tryCompleteElseWatch(long timeoutMs, Seq<CompletableFuture<T>> futures, Function0<BoxedUnit> responseCallback) {
        this.purgatory().tryCompleteElseWatch(timeoutMs, futures, responseCallback);
    }

    @Override
    public void shutdown() {
        this.purgatory().shutdown();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompletableFuture<Void> createClusterLink(NewClusterLink newClusterLink, Option<String> tenantPrefix, ListenerName requestListenerName, boolean validateOnly, boolean validateLink, int timeoutMs, int apiVersion) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Attempting to create cluster link with link-name ").append(newClusterLink.linkName()).append(" with validateOnly=").append(validateOnly).append(" and validateLink=").append(validateLink).toString());
        if (this.config().interBrokerProtocolVersion().$less$eq(KAFKA_2_3_IV1$.MODULE$)) {
            throw new InvalidClusterLinkException(new StringBuilder(68).append("Cluster linking is not supported with inter-broker protocol version ").append(this.config().interBrokerProtocolVersion()).toString());
        }
        String linkName = newClusterLink.linkName();
        ClusterLinkUtils$.MODULE$.validateLinkName(linkName);
        this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq((Map<String, Object>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newClusterLink.configs()).asScala()));
        if (!props.containsKey(ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            props.put(ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), requestListenerName.value());
        }
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create(props);
        Option expectedClusterId = Option$.MODULE$.apply((Object)newClusterLink.clusterId());
        if (expectedClusterId.contains((Object)this.localClusterId())) {
            throw new InvalidRequestException(new StringBuilder(85).append("Requested cluster ID matches local cluster ID '").append(this.localClusterId()).append("' - cannot create cluster link to self").toString());
        }
        LinkMode linkMode = linkConfig.linkMode();
        LinkMode$Destination$ linkMode$Destination$ = LinkMode$Destination$.MODULE$;
        if (!(linkMode != null ? !linkMode.equals(linkMode$Destination$) : linkMode$Destination$ != null)) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null) && expectedClusterId.isEmpty()) {
                throw new InvalidRequestException("Remote cluster id must be provided for destination cluster link that is source initiated");
            }
        }
        LinkMode linkMode2 = linkConfig.linkMode();
        LinkMode$Source$ linkMode$Source$ = LinkMode$Source$.MODULE$;
        if (!(linkMode2 != null ? !linkMode2.equals(linkMode$Source$) : linkMode$Source$ != null)) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null)) {
                throw new InvalidRequestException("Source links are currently supported only for source initiated links");
            }
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        Properties persistentProps = this.clusterLinkManager().configEncoder().encode(props);
        LinkMode linkMode3 = linkConfig.linkMode();
        LinkMode$Source$ linkMode$Source$2 = LinkMode$Source$.MODULE$;
        if (!(linkMode3 != null ? !linkMode3.equals(linkMode$Source$2) : linkMode$Source$2 != null)) {
            this.clusterLinkManager().scheduler().schedule("CreateSourceClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    void var11_18;
                    void var10_17;
                    Tuple2 tuple2;
                    ClusterLinkAdminClient withRemoteAdmin_admin;
                    block12: {
                        ClusterLinkAdminClient clusterLinkAdminClient;
                        try {
                            clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                        }
                        catch (Throwable withRemoteAdmin_e) {
                            throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(withRemoteAdmin_e.getMessage()).toString(), withRemoteAdmin_e);
                        }
                        withRemoteAdmin_admin = clusterLinkAdminClient;
                        try {
                            ClientInterceptor withRemoteAdmin_clientInterceptor = (ClientInterceptor)tenantPrefix.map((Function1 & Serializable & scala.Serializable)prefix -> ClusterLinkManager$.MODULE$.tenantInterceptor((String)prefix, linkName, linkConfig.linkMode(), $this.metrics)).orNull(Predef$.MODULE$.$conforms());
                            LinkMode linkMode = linkConfig.linkMode();
                            if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, withRemoteAdmin_clientInterceptor, null);
                                break block12;
                            }
                            if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, withRemoteAdmin_clientInterceptor, null, null);
                                break block12;
                            }
                            throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                        }
                        catch (Throwable withRemoteAdmin_e) {
                            throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                        }
                    }
                    try {
                        ConfluentAdmin confluentAdmin = withRemoteAdmin_admin.admin();
                        tuple2 = this.validateSourceClusterLink(confluentAdmin, linkName, (Option<String>)tenantPrefix, (Option<String>)expectedClusterId, timeoutMs);
                    }
                    finally {
                        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> withRemoteAdmin_admin.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError(null);
                    }
                    UUID linkId = (UUID)tuple22._1();
                    String remoteClusterId = (String)tuple22._2();
                    void linkId2 = var10_17;
                    void remoteClusterId2 = var11_18;
                    this.finishCreateClusterLink(linkName, (Option<UUID>)new Some((Object)linkId2), (Option<String>)new Some((Object)remoteClusterId2), tenantPrefix, linkConfig, persistentProps, validateOnly);
                    result.complete(null);
                    return;
                }
                catch (Throwable e) {
                    result.completeExceptionally(this.validationException(e));
                    return;
                }
            }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
            return result;
        }
        if (validateLink) {
            ConnectionMode connectionMode = linkConfig.connectionMode();
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Outbound$) : connectionMode$Outbound$ != null)) {
                this.clusterLinkManager().scheduler().schedule("CreateDestinationClusterLink", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    try {
                        Option option;
                        ClusterLinkAdminClient withRemoteAdmin_admin;
                        block11: {
                            ClusterLinkAdminClient clusterLinkAdminClient;
                            try {
                                clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), $this.metrics, $this.time);
                            }
                            catch (Throwable withRemoteAdmin_e) {
                                throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(withRemoteAdmin_e.getMessage()).toString(), withRemoteAdmin_e);
                            }
                            withRemoteAdmin_admin = clusterLinkAdminClient;
                            try {
                                ClientInterceptor withRemoteAdmin_clientInterceptor = (ClientInterceptor)tenantPrefix.map((Function1 & Serializable & scala.Serializable)prefix -> ClusterLinkManager$.MODULE$.tenantInterceptor((String)prefix, linkName, linkConfig.linkMode(), $this.metrics)).orNull(Predef$.MODULE$.$conforms());
                                LinkMode linkMode = linkConfig.linkMode();
                                if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                                    withRemoteAdmin_admin.networkClient().enableDestinationClusterLink(null, withRemoteAdmin_clientInterceptor, null);
                                    break block11;
                                }
                                if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                                    withRemoteAdmin_admin.networkClient().enableSourceClusterLink(null, withRemoteAdmin_clientInterceptor, null, null);
                                    break block11;
                                }
                                throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
                            }
                            catch (Throwable withRemoteAdmin_e) {
                                throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", withRemoteAdmin_e);
                            }
                        }
                        try {
                            ConfluentAdmin confluentAdmin = withRemoteAdmin_admin.admin();
                            option = this.validateDestinationClusterLink((Admin)confluentAdmin, (Option<String>)expectedClusterId, props, timeoutMs, linkName);
                        }
                        finally {
                            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> withRemoteAdmin_admin.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                        }
                        Option remoteClusterId = option;
                        this.finishCreateClusterLink(linkName, (Option<UUID>)None$.MODULE$, (Option<String>)remoteClusterId, tenantPrefix, linkConfig, persistentProps, validateOnly);
                        result.complete(null);
                        return;
                    }
                    catch (Throwable e) {
                        result.completeExceptionally(this.validationException(e));
                        return;
                    }
                }, this.clusterLinkManager().scheduler().schedule$default$3(), this.clusterLinkManager().scheduler().schedule$default$4(), this.clusterLinkManager().scheduler().schedule$default$5());
                return result;
            }
        }
        try {
            this.finishCreateClusterLink(linkName, (Option<UUID>)None$.MODULE$, (Option<String>)expectedClusterId, tenantPrefix, linkConfig, persistentProps, validateOnly);
            result.complete(null);
            return result;
        }
        catch (Throwable e) {
            result.completeExceptionally(this.validationException(e));
        }
        return result;
    }

    @Override
    public Seq<ClusterLinkListing> listClusterLinks(Option<scala.collection.immutable.Set<String>> linkNames, boolean includeTopics, int apiVersion) {
        None$ none$;
        Seq clusterLinkDatas = (Seq)this.clusterLinkManager().listClusterLinks().filter((Function1 & Serializable & scala.Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)linkNames.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)cld.linkName())))));
        if (includeTopics) {
            scala.collection.immutable.Set linkIds = ((TraversableOnce)clusterLinkDatas.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.linkId(), Seq$.MODULE$.canBuildFrom())).toSet();
            none$ = new Some(this.getAllMirrorTopics(false).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)linkIds.contains((Object)((ClusterLinkTopicState)e._2()).linkId()))));
        } else {
            none$ = None$.MODULE$;
        }
        None$ topics = none$;
        return (Seq)clusterLinkDatas.map(arg_0 -> ClusterLinkAdminManager.$anonfun$listClusterLinks$5(this, (Option)topics, arg_0), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void deleteClusterLink(String linkName, boolean validateOnly, boolean force, int apiVersion) {
        String topicsInUse;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Attempting to delete cluster link ").append(linkName).append(" with validateOnly=").append(validateOnly).append(" and force=").append(force).toString());
        ClusterLinkUtils$.MODULE$.validateLinkName(linkName);
        UUID linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
        if (!force && new StringOps(Predef$.MODULE$.augmentString(topicsInUse = ((MapLike)this.getAllMirrorTopicsInUse().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$deleteClusterLink$2(linkId, x$5)))).keys().mkString(", "))).nonEmpty()) {
            throw new ClusterLinkInUseException(new StringBuilder(46).append("Cluster link '").append(linkName).append("' with ID '").append(linkId).append("' in used by topics: ").append(topicsInUse).toString());
        }
        if (!validateOnly) {
            this.clusterLinkManager().deleteClusterLink(linkName, linkId);
        }
    }

    @Override
    public CompletableFuture<Void> alterMirror(String topic, AlterMirrorOp op, boolean validateOnly, int apiVersion) {
        CompletableFuture<Void> completableFuture;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Attempting to alter mirror topic ").append(topic).append(" with request ").append(op).append(" and validateOnly=").append(validateOnly).toString());
        if (AlterMirrorOp.PROMOTE.equals(op)) {
            completableFuture = this.stopMirrorTopic(topic, true, validateOnly);
        } else if (AlterMirrorOp.FAILOVER.equals(op)) {
            completableFuture = this.stopMirrorTopic(topic, false, validateOnly);
        } else if (AlterMirrorOp.CLEAR.equals(op)) {
            completableFuture = this.clearMirrorTopic(topic, validateOnly);
        } else if (AlterMirrorOp.PAUSE.equals(op)) {
            completableFuture = this.pauseMirrorTopic(topic, true, false, validateOnly);
        } else if (AlterMirrorOp.RESUME.equals(op)) {
            completableFuture = this.pauseMirrorTopic(topic, false, false, validateOnly);
        } else if (AlterMirrorOp.PAUSE_LINK.equals(op)) {
            completableFuture = this.pauseMirrorTopic(topic, true, true, validateOnly);
        } else if (AlterMirrorOp.RESUME_LINK.equals(op)) {
            completableFuture = this.pauseMirrorTopic(topic, false, true, validateOnly);
        } else {
            throw new UnsupportedVersionException("Unknown alter mirrors op type");
        }
        return completableFuture;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CompletableFuture<Void> stopMirrorTopic(String topic, boolean synchronize, boolean validateOnly) {
        ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror;
        block8: {
            Option option;
            block9: {
                boolean bl;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Requested to stop mirror topic for topic '").append(topic).append("' with synchronize=").append(synchronize).append(", validateOnly=").append(validateOnly).toString());
                Topic.validate((String)topic);
                if (!this.clusterLinkManager().adminManager().metadataCache().contains(topic)) {
                    throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
                }
                option = this.zkClient().getClusterLinkForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
                if (!(option instanceof Some)) break block9;
                ClusterLinkTopicState clusterLink = (ClusterLinkTopicState)((Some)option).value();
                String linkName = clusterLink.linkName();
                boolean bl2 = clusterLink instanceof ClusterLinkTopicState.Mirror ? true : (clusterLink instanceof ClusterLinkTopicState.FailedMirror ? true : clusterLink instanceof ClusterLinkTopicState.PausedMirror);
                if (bl2) {
                    pendingStoppedMirror = new ClusterLinkTopicState.PendingStoppedMirror(linkName, clusterLink.linkId(), clusterLink.sourceTopicId(), synchronize, ClusterLinkTopicState$PendingStoppedMirror$.MODULE$.apply$default$5());
                    break block8;
                } else if (clusterLink instanceof ClusterLinkTopicState.PendingStoppedMirror && (bl = ((ClusterLinkTopicState.PendingStoppedMirror)clusterLink).synchronize()) && !synchronize) {
                    pendingStoppedMirror = new ClusterLinkTopicState.PendingStoppedMirror(linkName, clusterLink.linkId(), clusterLink.sourceTopicId(), false, ClusterLinkTopicState$PendingStoppedMirror$.MODULE$.apply$default$5());
                    break block8;
                } else {
                    boolean bl3 = clusterLink instanceof ClusterLinkTopicState.PendingStoppedMirror ? true : clusterLink instanceof ClusterLinkTopicState.StoppedMirror;
                    if (bl3) {
                        throw new InvalidRequestException(new StringBuilder(47).append("Topic '").append(topic).append("' has already stopped its mirror from '").append(linkName).append("'").toString());
                    }
                    throw new MatchError((Object)clusterLink);
                }
            }
            if (None$.MODULE$.equals(option)) {
                throw new InvalidRequestException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
            }
            throw new MatchError((Object)option);
        }
        if (!validateOnly) {
            this.zkClient().setTopicClusterLink(topic, (Option<ClusterLinkTopicState>)new Some((Object)pendingStoppedMirror));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> clearMirrorTopic(String topic, boolean validateOnly) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Requested to clear mirror topic for topic '").append(topic).append("' with validateOnly=").append(validateOnly).toString());
        Topic.validate((String)topic);
        if (!this.clusterLinkManager().adminManager().metadataCache().contains(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
        }
        if (!validateOnly && this.zkClient().getClusterLinkForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).contains((Object)topic)) {
            this.zkClient().setTopicClusterLink(topic, (Option<ClusterLinkTopicState>)None$.MODULE$);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * Unable to fully structure code
     */
    private CompletableFuture<Void> pauseMirrorTopic(String topic, boolean enable, boolean isLinkLevel, boolean validateOnly) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$pauseMirrorTopic$1(java.lang.String boolean boolean boolean ), ()Ljava/lang/String;)((String)topic, (boolean)enable, (boolean)isLinkLevel, (boolean)validateOnly));
        Topic.validate((String)topic);
        if (!this.clusterLinkManager().adminManager().metadataCache().contains(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(16).append("Topic ").append(topic).append(" not found").toString());
        }
        var6_5 = false;
        var7_6 = null;
        var8_7 = this.zkClient().getClusterLinkForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
        var6_5 = true;
        var7_6 = (Some)var8_7;
        clusterLink = (ClusterLinkTopicState)var7_6.value();
        if (enable) {
            var5_9 = clusterLink.toPausedState(isLinkLevel);
        } else if (var6_5) {
            var5_9 = ((ClusterLinkTopicState)var7_6.value()).toUnpausedState(isLinkLevel);
        } else {
            if (None$.MODULE$.equals(var8_7)) {
                throw new InvalidRequestException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
            }
            throw new MatchError((Object)var8_7);
        }
        if (!validateOnly) {
            var5_9.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$pauseMirrorTopic$2$adapted(kafka.server.link.ClusterLinkAdminManager java.lang.String kafka.server.link.ClusterLinkTopicState ), (Lkafka/server/link/ClusterLinkTopicState;)Ljava/lang/Object;)((ClusterLinkAdminManager)this, (String)topic));
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Iterable<String> listMirrors(Option<String> linkName, boolean includeStopped, int apiVersion) {
        Option linkId = linkName.map((Function1 & Serializable & scala.Serializable)ln -> this.clusterLinkManager().resolveLinkIdOrThrow((String)ln));
        return ((MapLike)this.getAllMirrorTopics(includeStopped).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listMirrors$2(linkId, x0$1)))).keys();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MirrorTopicDescription describeMirror(String topic, int apiVersion) {
        List list;
        void var6_6;
        Topic.validate((String)topic);
        int numPartitions = BoxesRunTime.unboxToInt((Object)this.clusterLinkManager().adminManager().metadataCache().numPartitions(topic).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new UnknownTopicOrPartitionException(new StringBuilder(15).append("Unknown topic: ").append(topic).toString());
        }));
        ClusterLinkTopicState state = (ClusterLinkTopicState)this.clusterLinkManager().controller().controllerContext().linkedTopics().getOrElse((Object)topic, (Function0 & Serializable & scala.Serializable)() -> {
            throw new ClusterLinkNotFoundException(new StringBuilder(24).append("Topic '").append(topic).append("' is not mirrored").toString());
        });
        if (this.clusterLinkManager().controller().controllerContext().isTopicQueuedUpForDeletion(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(15).append("Unknown topic: ").append(topic).toString());
        }
        Tuple2 tuple2 = (Tuple2)this.clusterLinkManager().clusterLinkInfo(state.linkName()).map((Function1 & Serializable & scala.Serializable)link -> {
            MirrorTopicDescription.State state = state.mirrorTopicDescriptionState();
            MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
            if (!(state != null ? !state.equals(state2) : state2 != null)) {
                return new Tuple2((Object)state.mirrorTopicDescriptionState(), (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
            }
            LinkState linkState = link.linkStateInfo().linkState();
            FailedClusterLink$ failedClusterLink$ = FailedClusterLink$.MODULE$;
            if (!(linkState != null ? !linkState.equals(failedClusterLink$) : failedClusterLink$ != null)) {
                return new Tuple2((Object)MirrorTopicDescription.State.LINK_FAILED, (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
            }
            LinkState linkState2 = link.linkStateInfo().linkState();
            UnavailableClusterLink$ unavailableClusterLink$ = UnavailableClusterLink$.MODULE$;
            if (!(linkState2 != null ? !linkState2.equals(unavailableClusterLink$) : unavailableClusterLink$ != null)) {
                return new Tuple2((Object)MirrorTopicDescription.State.SOURCE_UNAVAILABLE, (Object)BoxesRunTime.boxToLong((long)this.clusterLinkManager().linkStateMs(state.linkName())));
            }
            if (this.isTopicPaused(state)) {
                return new Tuple2((Object)state.mirrorTopicDescriptionState(), (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
            }
            LinkState linkState3 = link.linkStateInfo().linkState();
            PausedClusterLink$ pausedClusterLink$ = PausedClusterLink$.MODULE$;
            if (!(linkState3 != null ? !linkState3.equals(pausedClusterLink$) : pausedClusterLink$ != null)) {
                return new Tuple2((Object)MirrorTopicDescription.State.LINK_PAUSED, (Object)BoxesRunTime.boxToLong((long)this.clusterLinkManager().linkStateMs(state.linkName())));
            }
            return new Tuple2((Object)state.mirrorTopicDescriptionState(), (Object)BoxesRunTime.boxToLong((long)state.timeMs()));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)MirrorTopicDescription.State.SOURCE_UNAVAILABLE, (Object)BoxesRunTime.boxToLong((long)state.timeMs())));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MirrorTopicDescription.State mirrorTopicState = (MirrorTopicDescription.State)tuple2._1();
        long l = tuple2._2$mcJ$sp();
        void v0 = var6_6;
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
        if (!(v0 != null ? !v0.equals(state2) : state2 != null)) {
            ClusterLinkTopicState.StoppedMirror stoppedMirrorState = (ClusterLinkTopicState.StoppedMirror)state;
            list = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)stoppedMirrorState.logEndOffsets().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava();
        } else {
            list = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava();
        }
        List stoppedLogEndOffsets = list;
        return new MirrorTopicDescription(state.linkName(), state.linkId(), topic, numPartitions, (MirrorTopicDescription.State)var6_6, l, stoppedLogEndOffsets);
    }

    private boolean isTopicPaused(ClusterLinkTopicState state) {
        boolean bl = state instanceof ClusterLinkTopicState.PausedMirror ? ((ClusterLinkTopicState.PausedMirror)state).topicLevel() : false;
        return bl;
    }

    private void finishCreateClusterLink(String linkName, Option<UUID> linkId, Option<String> linkClusterId, Option<String> tenantPrefix, ClusterLinkConfig linkConfig, Properties persistentProps, boolean validateOnly) {
        if (!validateOnly) {
            ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, (UUID)linkId.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID()), linkClusterId, tenantPrefix, false);
            this.clusterLinkManager().createClusterLink(clusterLinkData, linkConfig, persistentProps);
        }
    }

    private <T> T withRemoteAdmin(String linkName, ClusterLinkConfig linkConfig, Option<String> tenantPrefix, Function1<ConfluentAdmin, T> func) {
        Object object;
        ClusterLinkAdminClient admin;
        block9: {
            ClusterLinkAdminClient clusterLinkAdminClient;
            try {
                clusterLinkAdminClient = ClusterLinkAdminClient$.MODULE$.createRemoteAdmin(linkName, linkConfig, (Option<ClusterLinkDestConnectionManager>)None$.MODULE$, "validate-admin", this.config().brokerId(), this.metrics, this.time);
            }
            catch (Throwable e) {
                throw new InvalidConfigurationException(new StringBuilder(84).append("Unable to create client using provided properties when validating the cluster link: ").append(e.getMessage()).toString(), e);
            }
            admin = clusterLinkAdminClient;
            try {
                ClientInterceptor clientInterceptor = (ClientInterceptor)tenantPrefix.map((Function1 & Serializable & scala.Serializable)prefix -> ClusterLinkManager$.MODULE$.tenantInterceptor((String)prefix, linkName, linkConfig.linkMode(), $this.metrics)).orNull(Predef$.MODULE$.$conforms());
                LinkMode linkMode = linkConfig.linkMode();
                if (LinkMode$Destination$.MODULE$.equals(linkMode)) {
                    admin.networkClient().enableDestinationClusterLink(null, clientInterceptor, null);
                    break block9;
                }
                if (LinkMode$Source$.MODULE$.equals(linkMode)) {
                    admin.networkClient().enableSourceClusterLink(null, clientInterceptor, null, null);
                    break block9;
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Unsupported link mode ").append(linkConfig.linkMode()).toString());
            }
            catch (Throwable e) {
                throw new InvalidConfigurationException("Unable to enable cluster link for client when validating new link", e);
            }
        }
        try {
            object = func.apply((Object)admin.admin());
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> withRemoteAdmin_admin.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        return (T)object;
    }

    private Option<String> validateDestinationClusterLink(Admin admin, Option<String> expectedClusterId, Properties props, int timeoutMs, String linkName) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Validating creating destination cluster link ").append(linkName).toString());
        boolean aclSyncEnabled = ClusterLinkConfig$.MODULE$.create(props).aclSyncEnable();
        DescribeClusterResult describeResult = admin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(aclSyncEnabled).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)));
        if (aclSyncEnabled && !((Set)describeResult.authorizedOperations().get()).contains(AclOperation.DESCRIBE)) {
            throw new ClusterAuthorizationException("ACL sync was requested, but link credentials don't have DESCRIBE access for the source cluster");
        }
        Option linkClusterId = Option$.MODULE$.apply(describeResult.clusterId().get());
        if (linkClusterId instanceof Some) {
            String lcid = (String)((Some)linkClusterId).value();
            expectedClusterId.foreach((Function1 & Serializable & scala.Serializable)ecid -> {
                ClusterLinkAdminManager.$anonfun$validateDestinationClusterLink$2(lcid, ecid);
                return BoxedUnit.UNIT;
            });
        } else if (None$.MODULE$.equals(linkClusterId)) {
            expectedClusterId.foreach((Function1 & Serializable & scala.Serializable)ecid -> {
                throw new InvalidRequestException(new StringBuilder(67).append("Expected cluster ID '").append((String)ecid).append("' does not match due to no resolved cluster ID").toString());
            });
        } else {
            throw new MatchError((Object)linkClusterId);
        }
        return linkClusterId;
    }

    private Tuple2<UUID, String> validateSourceClusterLink(ConfluentAdmin remoteAdmin, String linkName, Option<String> tenantPrefix2, Option<String> expectedDestClusterId, int timeoutMs) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Validating creating source cluster link ").append(linkName).toString());
        Iterator iterator = ((Collection)remoteAdmin.listClusterLinks((ListClusterLinksOptions)new ListClusterLinksOptions().linkNames(Optional.of(Collections.singletonList(linkName))).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs))).result().get()).iterator();
        if (!iterator.hasNext()) {
            throw new InvalidConfigurationException(new StringBuilder(105).append("Source initiated link '").append(linkName).append("' cannot be created because the destination cluster does not have a link named '").append(linkName).append("'.").toString());
        }
        ClusterLinkListing result = (ClusterLinkListing)iterator.next();
        if (!((Set)remoteAdmin.describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true).timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs))).authorizedOperations().get()).contains(AclOperation.ALTER)) {
            throw new ClusterAuthorizationException("Link credentials don't have ALTER access for the destination cluster");
        }
        String destClusterId = result.localClusterId();
        String sourceClusterId = result.remoteClusterId();
        UUID linkId = result.linkId();
        Option option = Option$.MODULE$.apply((Object)destClusterId);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new InvalidRequestException("Destination cluster id could not be determined for the cluster link");
            }
            throw new MatchError((Object)option);
        }
        String clusterId = (String)((Some)option).value();
        expectedDestClusterId.foreach((Function1 & Serializable & scala.Serializable)expectedId -> {
            ClusterLinkAdminManager.$anonfun$validateSourceClusterLink$2(clusterId, expectedId);
            return BoxedUnit.UNIT;
        });
        String expectedSourceClusterId = (String)tenantPrefix2.map((Function1 & Serializable & scala.Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.localClusterId());
        String string = sourceClusterId;
        if (string == null ? expectedSourceClusterId != null : !string.equals(expectedSourceClusterId)) {
            throw new InvalidRequestException(new StringBuilder(84).append("Source cluster id '").append(expectedSourceClusterId).append("' does not match the cluster id '").append(sourceClusterId).append("' configured on the destination.").toString());
        }
        return new Tuple2((Object)linkId, (Object)destClusterId);
    }

    private Map<String, ClusterLinkTopicState> getAllMirrorTopics(boolean includeStopped) {
        return ((TraversableOnce)this.clusterLinkManager().controller().controllerContext().linkedTopics().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$getAllMirrorTopics$1(this, includeStopped, x0$1)))).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, ClusterLinkTopicState> getAllMirrorTopicsInUse() {
        return ((TraversableOnce)this.clusterLinkManager().controller().controllerContext().linkedTopics().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$getAllMirrorTopicsInUse$1(this, x0$1)))).toMap(Predef$.MODULE$.$conforms());
    }

    private ApiException validationException(Throwable throwable) {
        return ClusterLinkUtils$.MODULE$.apiException(throwable, "Unable to validate cluster link");
    }

    public static final /* synthetic */ boolean $anonfun$listClusterLinks$6(ClusterLinkData cld$2, Tuple2 x$4) {
        UUID uUID = ((ClusterLinkTopicState)x$4._2()).linkId();
        UUID uUID2 = cld$2.linkId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ ClusterLinkListing $anonfun$listClusterLinks$5(ClusterLinkAdminManager $this, Option topics$1, ClusterLinkData cld) {
        Optional<Object> optional;
        if (topics$1 instanceof Some) {
            Map lt = (Map)((Some)topics$1).value();
            optional = Optional.of(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((MapLike)lt.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listClusterLinks$6(cld, x$4)))).keys().toList()).asJavaCollection());
        } else if (None$.MODULE$.equals(topics$1)) {
            optional = Optional.empty();
        } else {
            throw new MatchError((Object)topics$1);
        }
        boolean available = $this.clusterLinkManager().isLinkAvailable(cld.linkName());
        return new ClusterLinkListing(cld.linkName(), cld.linkId(), (String)cld.clusterId().orNull(Predef$.MODULE$.$conforms()), $this.localClusterId(), optional, available);
    }

    public static final /* synthetic */ boolean $anonfun$deleteClusterLink$2(UUID linkId$1, Tuple2 x$5) {
        UUID uUID = ((ClusterLinkTopicState)x$5._2()).linkId();
        return !(uUID != null ? !((Object)uUID).equals(linkId$1) : linkId$1 != null);
    }

    public static final /* synthetic */ String $anonfun$pauseMirrorTopic$1(String topic$4, boolean enable$1, boolean isLinkLevel$1, boolean validateOnly$6) {
        return new StringBuilder(86).append("Requested to pause mirror topic for topic '").append(topic$4).append("' with enable=").append(enable$1).append(", isLinkLevel=").append(isLinkLevel$1).append(", validateOnly=").append(validateOnly$6).toString();
    }

    public static final /* synthetic */ void $anonfun$pauseMirrorTopic$2(ClusterLinkAdminManager $this, String topic$4, ClusterLinkTopicState ncl) {
        $this.zkClient().setTopicClusterLink(topic$4, (Option<ClusterLinkTopicState>)new Some((Object)ncl));
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$3(ClusterLinkTopicState state$1, UUID x$6) {
        UUID uUID = x$6;
        UUID uUID2 = state$1.linkId();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$listMirrors$2(Option linkId$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
        boolean bl = linkId$2.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAdminManager.$anonfun$listMirrors$3(state, x$6)));
        return bl;
    }

    public static final /* synthetic */ void $anonfun$validateDestinationClusterLink$2(String lcid$1, String ecid) {
        String string = ecid;
        if (string == null ? lcid$1 != null : !string.equals(lcid$1)) {
            throw new InvalidRequestException(new StringBuilder(60).append("Expected cluster ID '").append(ecid).append("' does not match resolved cluster ID '").append(lcid$1).append("'").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateSourceClusterLink$2(String clusterId$1, String expectedId) {
        String string = expectedId;
        if (string == null ? clusterId$1 != null : !string.equals(clusterId$1)) {
            throw new InvalidRequestException(new StringBuilder(60).append("Expected cluster ID '").append(expectedId).append("' does not match the dest cluster ID '").append(clusterId$1).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllMirrorTopics$1(ClusterLinkAdminManager $this, boolean includeStopped$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String topic = (String)x0$1._1();
        ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
        boolean bl = (includeStopped$1 || !(state instanceof ClusterLinkTopicState.StoppedMirror)) && !$this.clusterLinkManager().controller().controllerContext().isTopicQueuedUpForDeletion(topic);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getAllMirrorTopicsInUse$1(ClusterLinkAdminManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String topic = (String)x0$1._1();
        ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
        boolean bl = !(state instanceof ClusterLinkTopicState.PendingStoppedMirror) && !(state instanceof ClusterLinkTopicState.StoppedMirror) && !$this.clusterLinkManager().controller().controllerContext().isTopicQueuedUpForDeletion(topic);
        return bl;
    }

    public ClusterLinkAdminManager(KafkaConfig config, String localClusterId, KafkaZkClient zkClient, ClusterLinkManager clusterLinkManager, Metrics metrics, Time time) {
        this.config = config;
        this.localClusterId = localClusterId;
        this.zkClient = zkClient;
        this.clusterLinkManager = clusterLinkManager;
        this.metrics = metrics;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(41).append("[Cluster Link Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.purgatory = new DelayedFuturePurgatory("ClusterLink", config.brokerId());
    }

    public static final /* synthetic */ Object $anonfun$pauseMirrorTopic$2$adapted(ClusterLinkAdminManager $this, String topic$4, ClusterLinkTopicState ncl) {
        ClusterLinkAdminManager.$anonfun$pauseMirrorTopic$2($this, topic$4, ncl);
        return BoxedUnit.UNIT;
    }
}

