/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0011#\u0001%B\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\to\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!)\u0005A!b\u0001\n\u00031\u0005\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011m\u0003!\u0011!Q\u0001\nqCQa\u0018\u0001\u0005\u0002\u0001Dqa\u001a\u0001A\u0002\u0013%\u0001\u000eC\u0004m\u0001\u0001\u0007I\u0011B7\t\rM\u0004\u0001\u0015)\u0003j\u0011\u001d!\bA1A\u0005\nUDq!a\u0005\u0001A\u0003%a\u000f\u0003\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003v\u0011\u001d\t9\u0002\u0001Q\u0001\nYD\u0011\"!\u0007\u0001\u0001\u0004%I!a\u0007\t\u0013\u0005\r\u0002\u00011A\u0005\n\u0005\u0015\u0002\u0002CA\u0015\u0001\u0001\u0006K!!\b\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002bBA\u0018\u0001\u0001\u0006I!\u0014\u0005\n\u0003c\u0001!\u0019!C\u0001\u00037A\u0001\"a\r\u0001A\u0003%\u0011Q\u0004\u0005\b\u0003k\u0001A\u0011KA\u001c\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002\\\u0001!I!!\u0018\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003K\u0003A\u0011BAT\u0011\u001d\tI\u000b\u0001C\u0001EUDq!a+\u0001\t\u0003\u0011SO\u0001\rDYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u001b&\u0014(o\u001c:j]\u001eT!a\t\u0013\u0002\t1Lgn\u001b\u0006\u0003K\u0019\naa]3sm\u0016\u0014(\"A\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u000b\t\u0003W=r!\u0001L\u0017\u000e\u0003\tJ!A\f\u0012\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t\u0001\u0014G\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u0002/E\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012\u0001\u000e\t\u0003YUJ!A\u000e\u0012\u00031\rcWo\u001d;fe2Kgn[\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002\u00111Lgn\u001b#bi\u0006\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0014\u0002\u0005i\\\u0017B\u0001 <\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017AC2p]R\u0014x\u000e\u001c7feB\u0011\u0011iQ\u0007\u0002\u0005*\u0011qHJ\u0005\u0003\t\n\u0013qbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0001\u0011I\u0016\u001cH/\u00113nS:4\u0015m\u0019;pef,\u0012a\u0012\t\u0004\u0011.kU\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001(Y\u001b\u0005y%B\u0001)R\u0003\u0015\tG-\\5o\u0015\t\u00116+A\u0004dY&,g\u000e^:\u000b\u0005\u001d\"&BA+W\u0003\u0019\t\u0007/Y2iK*\tq+A\u0002pe\u001eL!!W(\u0003\u000b\u0005#W.\u001b8\u0002#\u0011,7\u000f^!e[&tg)Y2u_JL\b%A\u0004nKR\u0014\u0018nY:\u0011\u00051j\u0016B\u00010#\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002\rqJg.\u001b;?)\u0019\t'm\u00193fMB\u0011A\u0006\u0001\u0005\u0006e!\u0001\r\u0001\u000e\u0005\u0006q!\u0001\r!\u000f\u0005\u0006\u007f!\u0001\r\u0001\u0011\u0005\u0006\u000b\"\u0001\ra\u0012\u0005\u00067\"\u0001\r\u0001X\u0001\u0007G>tg-[4\u0016\u0003%\u0004\"\u0001\f6\n\u0005-\u0014#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u00059\f\bC\u0001%p\u0013\t\u0001\u0018J\u0001\u0003V]&$\bb\u0002:\u000b\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\r[&\u0014(o\u001c:U_BL7m]\u000b\u0002mB\u0019q\u000f @\u000e\u0003aT!!\u001f>\u0002\u000f5,H/\u00192mK*\u001110S\u0001\u000bG>dG.Z2uS>t\u0017BA?y\u0005\r\u0019V\r\u001e\t\u0004\u007f\u00065a\u0002BA\u0001\u0003\u0013\u00012!a\u0001J\u001b\t\t)AC\u0002\u0002\b!\na\u0001\u0010:p_Rt\u0014bAA\u0006\u0013\u00061\u0001K]3eK\u001aLA!a\u0004\u0002\u0012\t11\u000b\u001e:j]\u001eT1!a\u0003J\u00035i\u0017N\u001d:peR{\u0007/[2tA\u0005)2m\u001c8gY&\u001cG/\u001b8h\t\u0016\u001cH\u000fV8qS\u000e\u001c\u0018AF2p]\u001ad\u0017n\u0019;j]\u001e$Um\u001d;U_BL7m\u001d\u0011\u0002!Q\f7o[:PkR\u001cH/\u00198eS:<WCAA\u000f!\rA\u0015qD\u0005\u0004\u0003CI%aA%oi\u0006!B/Y:lg>+Ho\u001d;b]\u0012LgnZ0%KF$2A\\A\u0014\u0011!\u0011\u0018#!AA\u0002\u0005u\u0011!\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8hA\u0005IA-Z:u\u0003\u0012l\u0017N\\\u000b\u0002\u001b\u0006QA-Z:u\u0003\u0012l\u0017N\u001c\u0011\u00021\r\u0013V)\u0011+F?R{\u0005+S\"T?\n\u000bEk\u0011%`'&SV)A\rD%\u0016\u000bE+R0U\u001fBK5iU0C\u0003R\u001b\u0005jX*J5\u0016\u0003\u0013a\u0001:v]R\u0011\u0011\u0011\b\t\u0004\u0011\u0006m\u0012bAA\u001f\u0013\n9!i\\8mK\u0006t\u0017A\u00065b]\u0012dW\rT5tiN{WO]2f)>\u0004\u0018nY:\u0015\t\u0005e\u00121\t\u0005\b\u0003\u000bB\u0002\u0019AA$\u0003\u0019\u0011Xm];miB\u0019a*!\u0013\n\u0007\u0005-sJ\u0001\tMSN$Hk\u001c9jGN\u0014Vm];mi\u0006!\u0002.\u00198eY\u0016d\u0015n\u001d;EKN$Hk\u001c9jGN$b!!\u000f\u0002R\u0005M\u0003bBA#3\u0001\u0007\u0011q\t\u0005\b\u0003+J\u0002\u0019AA,\u000391\u0017\u000e\u001c;fe\u0016$Gk\u001c9jGN\u0004Ba`A-}&\u0019Q0!\u0005\u0002\u0019\u0019LG\u000e^3s)>\u0004\u0018nY:\u0015\t\u0005]\u0013q\f\u0005\b\u0003CR\u0002\u0019AA,\u0003\u0019!x\u000e]5dg\u0006a1M]3bi\u0016$v\u000e]5dgR!\u0011\u0011HA4\u0011\u001d\t\tg\u0007a\u0001\u0003/\nq\u0003[1oI2,')\u0019;dQ\u000e\u0013X-\u0019;f)>\u0004\u0018nY:\u0015\t\u0005e\u0012Q\u000e\u0005\b\u0003_b\u0002\u0019AA9\u00035!x\u000e]5d\u0019&\u001cH/\u001b8hgB9\u00111OA?}\u0006\u0005UBAA;\u0015\u0011\t9(!\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003w\nAA[1wC&!\u0011qPA;\u0005\ri\u0015\r\u001d\t\u0007\u0003\u0007\u000bI)!$\u000e\u0005\u0005\u0015%bAAD'\u000611m\\7n_:LA!a#\u0002\u0006\nY1*\u00194lC\u001a+H/\u001e:f!\u0011\ty)!&\u000e\u0005\u0005E%\u0002BAJ\u0003s\nA\u0001\\1oO&!\u0011qSAI\u0005\u00111v.\u001b3\u0002=\u0005$G-T5se>\u0014X\r\u001a+pa&\u001c\u0017I\u001c3M_\u001e<\u0016M\u001d8j]\u001e\u001cH#\u00028\u0002\u001e\u0006\u0005\u0006BBAP;\u0001\u0007a0A\u0003u_BL7\rC\u0004\u0002$v\u0001\r!!!\u0002\r\u0019,H/\u001e:f\u0003UqwN\\!di&4X-T5se>\u0014Hk\u001c9jGN$\"!a\u0016\u0002\u001f\u001d,G/T5se>\u0014Hk\u001c9jGN\f\u0001dZ3u\u0007>tg\r\\5di&tw\rR3tiR{\u0007/[2t\u0001")
public class ClusterLinkAutoMirroring
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkClientManager clientManager;
    private final ClusterLinkData linkData;
    private final KafkaController controller;
    private final Function0<Admin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private final scala.collection.mutable.Set<String> mirrorTopics;
    private final scala.collection.mutable.Set<String> conflictingDestTopics;
    private int tasksOutstanding;
    private final Admin destAdmin;
    private final int CREATE_TOPICS_BATCH_SIZE;

    public ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    public Function0<Admin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private scala.collection.mutable.Set<String> mirrorTopics() {
        return this.mirrorTopics;
    }

    private scala.collection.mutable.Set<String> conflictingDestTopics() {
        return this.conflictingDestTopics;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private Admin destAdmin() {
        return this.destAdmin;
    }

    public int CREATE_TOPICS_BATCH_SIZE() {
        return this.CREATE_TOPICS_BATCH_SIZE;
    }

    @Override
    public boolean run() {
        this.mirrorTopics().clear();
        this.config_$eq(this.clientManager().currentConfig());
        if (this.controller.isActive() && this.config().autoMirroringEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().topicFilters().isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).append(" is true but no topic filters are specified. No topics will be mirrored.").toString());
            } else {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to list topics from source cluster");
                    ListTopicsResult listTopicsResult = this.clientManager().getAdmin().listTopics();
                    this.scheduleWhenComplete(listTopicsResult.namesToListings(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListSourceTopics(listTopicsResult));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                }
                catch (Throwable ex) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("Unable to list topics on source cluster. No topics will be automatically mirrored. ").append(ex).toString());
                }
            }
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean handleListSourceTopics(ListTopicsResult result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            ObjectRef filteredTopics = ObjectRef.create((Object)((scala.collection.immutable.Set)this.filterTopics((scala.collection.immutable.Set<String>)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)result.names().get()).asScala()).toSet()).$minus$minus(this.clientManager().getTopics()).$minus$minus(this.nonActiveMirrorTopics())));
            Map namesToListings = (Map)result.namesToListings().get();
            ((scala.collection.immutable.Set)filteredTopics.elem).foreach((Function1 & Serializable & scala.Serializable)topicName -> {
                ClusterLinkAutoMirroring.$anonfun$handleListSourceTopics$1(this, namesToListings, filteredTopics, topicName);
                return BoxedUnit.UNIT;
            });
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Will attempt to mirror following topics on destination cluster: ").append((scala.collection.immutable.Set)filteredTopics$1.elem).toString());
            if (((TraversableOnce)this.conflictingDestTopics().intersect((GenSet)((scala.collection.immutable.Set)filteredTopics.elem))).nonEmpty()) {
                ListTopicsResult listTopicsResult = this.destAdmin().listTopics();
                this.scheduleWhenComplete(listTopicsResult.namesToListings(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListDestTopics(listTopicsResult, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics$1.elem)));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            } else {
                if (this.conflictingDestTopics().nonEmpty()) {
                    this.conflictingDestTopics().clear();
                }
                this.createTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics.elem));
            }
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof AuthorizationException) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Unable to list topics on the source cluster. Please enable DESCRIBE ACLs on the source cluster to proceed. ").append(ex.getCause()).toString());
            }
            if (throwable != null) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unable to list topics on the source cluster. Topics will not be mirrored. ").append(ex).toString());
            }
            throw new MatchError(null);
        }
        catch (Throwable ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unable to list topics on the source cluster. Topics will not be mirrored. ").append(ex).toString());
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean handleListDestTopics(ListTopicsResult result, scala.collection.immutable.Set<String> filteredTopics) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            java.util.Set destTopics = (java.util.Set)result.names().get();
            if (this.conflictingDestTopics().nonEmpty()) {
                this.conflictingDestTopics().clear();
            }
            this.conflictingDestTopics().$plus$plus$eq((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(destTopics).asScala()).intersect(filteredTopics));
            if (this.conflictingDestTopics().nonEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found following conflicting topics on destination: ").append(this.conflictingDestTopics()).toString());
            }
            this.conflictingDestTopics().foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ClusterLinkAutoMirroring.$anonfun$handleListDestTopics$2(this, topic);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set topicsToCreate = (scala.collection.immutable.Set)filteredTopics.$minus$minus(this.conflictingDestTopics());
            this.createTopics((scala.collection.immutable.Set<String>)topicsToCreate);
        }
        catch (Throwable ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Unable to list topics on destination cluster to check for conflicting topics. ").append(ex).toString());
            this.createTopics(filteredTopics);
        }
        return this.tasksOutstanding() == 0;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<String> filterTopics(scala.collection.immutable.Set<String> topics) {
        void var4_4;
        void var3_3;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Filtering source topics to match topic filters JSON");
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilter(topics, this.config().topicFilters(), this.linkData.tenantPrefix());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        Seq unusedFilters = (Seq)tuple2._2();
        void filtered2 = var3_3;
        var4_4.foreach((Function1 & Serializable & scala.Serializable)unusedFilter -> {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(197).append("The filter ").append(unusedFilter).append(" does not match any source topic. This filter may not be ").append("required or the topics it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return BoxedUnit.UNIT;
        });
        return filtered2;
    }

    private boolean createTopics(scala.collection.immutable.Set<String> topics) {
        ((scala.collection.immutable.Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> new NewTopic(topic, Optional.empty(), Optional.empty()).mirror(Optional.of(new NewMirrorTopic($this.linkData.linkName(), topic))), Set$.MODULE$.canBuildFrom())).grouped(this.CREATE_TOPICS_BATCH_SIZE()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            ClusterLinkAutoMirroring.$anonfun$createTopics$2(this, batch);
            return BoxedUnit.UNIT;
        });
        return this.tasksOutstanding() == 0;
    }

    private boolean handleBatchCreateTopics(Map<String, KafkaFuture<Void>> topicListings) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        topicListings.forEach((topic, future) -> this.addMirroredTopicAndLogWarnings((String)topic, (KafkaFuture<Void>)future));
        return this.tasksOutstanding() == 0;
    }

    private void addMirroredTopicAndLogWarnings(String topic, KafkaFuture<Void> future) {
        try {
            future.get();
            this.mirrorTopics().$plus$eq((Object)topic);
            this.metrics.autoMirrorCreateSensor().record();
            return;
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof TopicExistsException) {
                this.conflictingDestTopics().add((Object)topic);
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Topic ").append(topic).append(" already exists on destination cluster. Will not mirror source").append(" topic. ").append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                return;
            }
            if (throwable instanceof AuthorizationException) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unable to create topic ").append(topic).append(". Please allow CREATE access on destination cluster to proceed. ").append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                return;
            }
            if (throwable != null) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unable to create topic ").append(topic).append(" on destination cluster. ").append(ex).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                return;
            }
            throw new MatchError(null);
        }
        catch (Throwable ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unable to create topic ").append(topic).append(" on destination cluster. ").append(ex).toString());
            this.metrics.autoMirrorCreateFailedSensor().record();
            return;
        }
    }

    private scala.collection.immutable.Set<String> nonActiveMirrorTopics() {
        return ((MapLike)this.controller.controllerContext().linkedTopics().filter((Function1 & Serializable & scala.Serializable)cl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAutoMirroring.$anonfun$nonActiveMirrorTopics$1(this, cl)))).keySet().toSet();
    }

    public scala.collection.mutable.Set<String> getMirrorTopics() {
        return this.mirrorTopics();
    }

    public scala.collection.mutable.Set<String> getConflictingDestTopics() {
        return this.conflictingDestTopics();
    }

    public static final /* synthetic */ void $anonfun$handleListSourceTopics$1(ClusterLinkAutoMirroring $this, Map namesToListings$1, ObjectRef filteredTopics$1, String topicName) {
        if (((TopicListing)namesToListings$1.get(topicName)).isInternal()) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Internal topic ").append(topicName).append(" will not be mirrored.").toString());
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus((Object)topicName);
        }
    }

    public static final /* synthetic */ void $anonfun$handleListDestTopics$2(ClusterLinkAutoMirroring $this, String topic) {
        $this.metrics.autoMirrorCreateFailedSensor().record();
    }

    public static final /* synthetic */ void $anonfun$createTopics$2(ClusterLinkAutoMirroring $this, scala.collection.immutable.Set batch) {
        try {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(batch).toString());
            CreateTopicsResult result = $this.destAdmin().createTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)batch).asJava());
            $this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.handleBatchCreateTopics(result.values()));
            $this.tasksOutstanding_$eq($this.tasksOutstanding() + 1);
            return;
        }
        catch (Throwable ex) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unable to create topics on destination cluster. ").append(ex).toString());
            $this.metrics.autoMirrorCreateFailedSensor().record((double)batch.size());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$nonActiveMirrorTopics$1(ClusterLinkAutoMirroring $this, Tuple2 cl) {
        return !((ClusterLinkTopicState)cl._2()).state().shouldSync() && ((ClusterLinkTopicState)cl._2()).linkName().equals($this.linkData.linkName());
    }

    public ClusterLinkAutoMirroring(ClusterLinkClientManager clientManager, ClusterLinkData linkData, KafkaController controller, Function0<Admin> destAdminFactory, ClusterLinkMetrics metrics) {
        this.clientManager = clientManager;
        this.linkData = linkData;
        this.controller = controller;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkAutoMirroring", (int)Predef$.MODULE$.Long2long(clientManager.currentConfig().metadataMaxAgeMs()));
        this.config = clientManager.currentConfig();
        this.mirrorTopics = scala.collection.mutable.Set$.MODULE$.empty();
        this.conflictingDestTopics = scala.collection.mutable.Set$.MODULE$.empty();
        this.tasksOutstanding = 0;
        this.destAdmin = (Admin)destAdminFactory.apply();
        this.CREATE_TOPICS_BATCH_SIZE = 100;
    }
}

