/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.LinkState;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.KafkaFuture;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u001d4A\u0001D\u0007\u0001)!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011!)\u0003A!A!\u0002\u00131\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u00135\u0002!\u0011!Q\u0001\n9\"\u0004\"\u0002\u001c\u0001\t\u00039\u0004b\u0002 \u0001\u0001\u0004%Ia\u0010\u0005\b\u0001\u0002\u0001\r\u0011\"\u0003B\u0011\u00199\u0005\u0001)Q\u0005]!)\u0001\n\u0001C)\u0013\")Q\n\u0001C\u0005\u001d\na2\t\\;ti\u0016\u0014H*\u001b8l\u0007\",7m[!wC&d\u0017MY5mSRL(B\u0001\b\u0010\u0003\u0011a\u0017N\\6\u000b\u0005A\t\u0012AB:feZ,'OC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YQbBA\f\u0019\u001b\u0005i\u0011BA\r\u000e\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u00111\u0004\b\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u000335\tQb\u00197jK:$X*\u00198bO\u0016\u0014\bCA\f \u0013\t\u0001SB\u0001\rDYV\u001cH/\u001a:MS:\\7\t\\5f]Rl\u0015M\\1hKJ\faaY8oM&<\u0007CA\f$\u0013\t!SBA\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\fq!\\3ue&\u001c7\u000f\u0005\u0002\u0018O%\u0011\u0001&\u0004\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\bCA\f,\u0013\taSB\u0001\nDYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\u0018AC5oi\u0016\u0014h/\u00197NgB\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t\u0019\u0011J\u001c;\n\u0005UR\u0012!\u0005:fg\u000eDW\rZ;mK\u0012+G.Y=Ng\u00061A(\u001b8jiz\"b\u0001O\u001d;wqj\u0004CA\f\u0001\u0011\u0015ib\u00011\u0001\u001f\u0011\u0015\tc\u00011\u0001#\u0011\u0015)c\u00011\u0001'\u0011\u0015Ic\u00011\u0001+\u0011\u0015ic\u00011\u0001/\u0003%1\u0017-\u001b7D_VtG/F\u0001/\u000351\u0017-\u001b7D_VtGo\u0018\u0013fcR\u0011!)\u0012\t\u0003_\rK!\u0001\u0012\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\r\"\t\t\u00111\u0001/\u0003\rAH%M\u0001\u000bM\u0006LGnQ8v]R\u0004\u0013a\u0001:v]R\t!\n\u0005\u00020\u0017&\u0011A\n\r\u0002\b\u0005>|G.Z1o\u00031A\u0017M\u001c3mKJ+7/\u001e7u)\tQu\nC\u0003Q\u0017\u0001\u0007\u0011+\u0001\u0004sKN,H\u000e\u001e\t\u0004%jcV\"A*\u000b\u0005Q+\u0016AB2p[6|gN\u0003\u0002\u0013-*\u0011q\u000bW\u0001\u0007CB\f7\r[3\u000b\u0003e\u000b1a\u001c:h\u0013\tY6KA\u0006LC\u001a\\\u0017MR;ukJ,\u0007CA/e\u001d\tq&\r\u0005\u0002`a5\t\u0001M\u0003\u0002b'\u00051AH]8pizJ!a\u0019\u0019\u0002\rA\u0013X\rZ3g\u0013\t)gM\u0001\u0004TiJLgn\u001a\u0006\u0003GB\u0002")
public class ClusterLinkCheckAvailability
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkClientManager clientManager;
    private final ClusterLinkConfig config;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkManager clusterLinkManager;
    private int failCount;

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    @Override
    public boolean run() {
        DescribeClusterResult describeClusterResult = this.clientManager.getAdmin().describeCluster(new DescribeClusterOptions());
        this.scheduleWhenComplete(describeClusterResult.clusterId(), (Function0<Object>)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> this.handleResult((KafkaFuture<String>)describeClusterResult.clusterId()));
        return false;
    }

    private boolean handleResult(KafkaFuture<String> result) {
        String linkName = this.metrics.linkName();
        try {
            result.get();
            this.failCount_$eq(0);
            this.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("Link ").append(linkName).append(" availability check succeeded").toString());
            this.clusterLinkManager.reportAvailableLink(linkName);
        }
        catch (Exception e) {
            LinkState linkState;
            this.failCount_$eq(this.failCount() + 1);
            this.metrics.linkSourceUnavailableSensor().record();
            if (this.failCount() >= Predef$.MODULE$.Integer2int(this.config.availabilityCheckConsecutiveFailureThreshold())) {
                this.clusterLinkManager.reportUnavailableLink(linkName, e);
            }
            LinkState linkState2 = linkState = this.clusterLinkManager.linkState(this.clientManager.linkData().linkName());
            ActiveClusterLink$ activeClusterLink$ = ActiveClusterLink$.MODULE$;
            if (!(linkState2 != null ? !linkState2.equals(activeClusterLink$) : activeClusterLink$ != null)) {
                this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(38).append("Link ").append(linkName).append(" availability check failed ").append(this.failCount()).append(" times").toString(), (Function0<Throwable>)(Function0 & java.io.Serializable & Serializable)() -> e);
            }
            this.debug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(50).append("Link ").append(linkName).append(" availability check in state ").append(linkState).append(" failed ").append(this.failCount()).append(" times: ").append(e.getCause()).toString());
        }
        return true;
    }

    public ClusterLinkCheckAvailability(ClusterLinkClientManager clientManager, ClusterLinkConfig config, ClusterLinkMetrics metrics, ClusterLinkManager clusterLinkManager, int intervalMs) {
        this.clientManager = clientManager;
        this.config = config;
        this.metrics = metrics;
        this.clusterLinkManager = clusterLinkManager;
        super(clientManager.scheduler(), "CheckAvailability", intervalMs);
        this.failCount = 0;
    }
}

