/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkClearMirrorTopics$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\u000e\u001c\u0001\tB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\ni\u0001\u0011\t\u0011)A\u0005kaB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!q\u0006A!A!\u0002\u0013y\u0006\"\u00032\u0001\u0005\u0003\u0005\u000b\u0011B0d\u0011!)\u0007A!A!\u0002\u0013y\u0006\"\u00024\u0001\t\u00039\u0007\"\u0003:\u0001\u0001\u0004\u0005\r\u0011\"\u0003t\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%I!!\u0007\t\u0015\u0005}\u0001\u00011A\u0001B\u0003&A\u000fC\u0004\u0002\"\u0001!\t&a\t\t\u000f\u0005-\u0002\u0001\"\u0003\u0002$!9\u0011Q\u0006\u0001\u0005\n\u0005\r\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003o\u0001A\u0011BA\u001d\u0011\u001d\ti\u0006\u0001C\u0005\u0003G9\u0011\"a\u0018\u001c\u0003\u0003E\t!!\u0019\u0007\u0011iY\u0012\u0011!E\u0001\u0003GBaAZ\u000b\u0005\u0002\u0005-\u0004\"CA7+E\u0005I\u0011AA8\u0011%\t))FI\u0001\n\u0003\ty\u0007C\u0005\u0002\bV\t\n\u0011\"\u0001\u0002p\ta2\t\\;ti\u0016\u0014H*\u001b8l\u00072,\u0017M]'jeJ|'\u000fV8qS\u000e\u001c(B\u0001\u000f\u001e\u0003\u0011a\u0017N\\6\u000b\u0005yy\u0012AB:feZ,'OC\u0001!\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0012\u0011\u0005\u0011BcBA\u0013'\u001b\u0005Y\u0012BA\u0014\u001c\u0003Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe&\u0011\u0011F\u000b\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0003Om\ta\u0001\\5oW&#\u0007CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011)H/\u001b7\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0005+VKE)A\u0005tG\",G-\u001e7feB\u0011QEN\u0005\u0003om\u0011Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018B\u0001\u001b)\u0003!Q8n\u00117jK:$\bCA\u001e?\u001b\u0005a$BA\u001f \u0003\tQ8.\u0003\u0002@y\ti1*\u00194lCj[7\t\\5f]R\f!bY8oiJ|G\u000e\\3s!\t\u0011E)D\u0001D\u0015\t\u0001u$\u0003\u0002F\u0007\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/\u0001\u0006m_\u000e\fG.\u00113nS:\u0004\"\u0001\u0013*\u000e\u0003%S!AS&\u0002\u000b\u0005$W.\u001b8\u000b\u00051k\u0015aB2mS\u0016tGo\u001d\u0006\u0003A9S!a\u0014)\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0016aA8sO&\u00111+\u0013\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003I\u0019w.\u001c9mKRLwN\\\"bY2\u0014\u0017mY6\u0011\u0007YK6,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002W9&\u0011Ql\u0016\u0002\u0005+:LG/\u0001\bu_BL7m\u0012:pkB\u001c\u0016N_3\u0011\u0005Y\u0003\u0017BA1X\u0005\rIe\u000e^\u0001\u000bS:$XM\u001d<bY6\u001b\u0018B\u00013)\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\re\u0016$(/\u001f#fY\u0006LXj]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015!L'n\u001b7n]>\u0004\u0018\u000f\u0005\u0002&\u0001!)1F\u0003a\u0001Y!)AG\u0003a\u0001k!)\u0011H\u0003a\u0001u!)\u0001I\u0003a\u0001\u0003\")aI\u0003a\u0001\u000f\")AK\u0003a\u0001+\"9aL\u0003I\u0001\u0002\u0004y\u0006b\u00022\u000b!\u0003\u0005\ra\u0018\u0005\bK*\u0001\n\u00111\u0001`\u0003-!x\u000e]5d\u000fJ|W\u000f]:\u0016\u0003Q\u0004B!^?\u0002\u00029\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u0006\na\u0001\u0010:p_Rt\u0014\"\u0001-\n\u0005q<\u0016a\u00029bG.\fw-Z\u0005\u0003}~\u0014A\u0001T5ti*\u0011Ap\u0016\t\u0007\u0003\u0007\tY!!\u0005\u000f\t\u0005\u0015\u0011q\u0001\t\u0003o^K1!!\u0003X\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\b\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u00139\u0006\u0003BA\u0002\u0003'IA!!\u0006\u0002\u0010\t11\u000b\u001e:j]\u001e\fq\u0002^8qS\u000e<%o\\;qg~#S-\u001d\u000b\u00047\u0006m\u0001\u0002CA\u000f\u0019\u0005\u0005\t\u0019\u0001;\u0002\u0007a$\u0013'\u0001\u0007u_BL7m\u0012:pkB\u001c\b%A\u0002sk:$\"!!\n\u0011\u0007Y\u000b9#C\u0002\u0002*]\u0013qAQ8pY\u0016\fg.A\u0007qe>\u001cWm]:U_BL7m]\u0001\u0012aJ|7-Z:t)>\u0004\u0018nY:P]\u000e,\u0017!E2mK\u0006\u0014X*\u001b:s_J$v\u000e]5dgR!\u0011QEA\u001a\u0011\u001d\t)$\u0005a\u0001\u0003\u0003\ta\u0001^8qS\u000e\u001c\u0018!G2mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg\u000e{W\u000e\u001d7fi\u0016$B!!\n\u0002<!9\u0011Q\b\nA\u0002\u0005}\u0012a\u0002:fgVdGo\u001d\t\b[\u0005\u0005\u0013\u0011CA#\u0013\r\t\u0019E\f\u0002\u0004\u001b\u0006\u0004\bCBA$\u0003\u001b\n\t&\u0004\u0002\u0002J)\u0019\u00111J'\u0002\r\r|W.\\8o\u0013\u0011\ty%!\u0013\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b\u0019\u0002\t1\fgnZ\u0005\u0005\u00037\n)F\u0001\u0003W_&$\u0017\u0001D8o\u0007>l\u0007\u000f\\3uS>t\u0017\u0001H\"mkN$XM\u001d'j].\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7m\u001d\t\u0003KU\u00192!FA3!\r1\u0016qM\u0005\u0004\u0003S:&AB!osJ+g\r\u0006\u0002\u0002b\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"!!\u001d+\u0007}\u000b\u0019h\u000b\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014!C;oG\",7m[3e\u0015\r\tyhV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAB\u0003s\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\u0002")
public class ClusterLinkClearMirrorTopics
extends ClusterLinkScheduler.PeriodicTask {
    private final UUID linkId;
    private final KafkaZkClient zkClient;
    private final KafkaController controller;
    private final ConfluentAdmin localAdmin;
    private final Function0<BoxedUnit> completionCallback;
    private final int topicGroupSize;
    private final int retryDelayMs;
    private List<Set<String>> topicGroups;

    public static int $lessinit$greater$default$9() {
        return ClusterLinkClearMirrorTopics$.MODULE$.$lessinit$greater$default$9();
    }

    public static int $lessinit$greater$default$8() {
        return ClusterLinkClearMirrorTopics$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return ClusterLinkClearMirrorTopics$.MODULE$.$lessinit$greater$default$7();
    }

    private List<Set<String>> topicGroups() {
        return this.topicGroups;
    }

    private void topicGroups_$eq(List<Set<String>> x$1) {
        this.topicGroups = x$1;
    }

    @Override
    public boolean run() {
        if (!this.zkClient.clusterLinkExists(this.linkId)) {
            return this.onCompletion();
        }
        if (this.controller.isActive()) {
            return this.processTopics();
        }
        return true;
    }

    private boolean processTopics() {
        Set<String> topicSet = this.zkClient.getAllTopicsInCluster(false);
        this.topicGroups_$eq((List<Set<String>>)topicSet.grouped(this.topicGroupSize).toList());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Processing ").append(topicSet.size()).append(" topics for cluster link removal for cluster link id ").append($this.linkId).toString());
        return this.processTopicsOnce();
    }

    private boolean processTopicsOnce() {
        if (this.topicGroups().isEmpty()) {
            return this.onCompletion();
        }
        Map links = (Map)this.zkClient.getClusterLinkForTopics((Set<String>)((Set)this.topicGroups().head())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearMirrorTopics.$anonfun$processTopicsOnce$1(this, x$1)));
        if (links.nonEmpty()) {
            return this.clearMirrorTopics((Set<String>)links.keys().toSet());
        }
        this.topicGroups_$eq((List<Set<String>>)this.topicGroups().drop(1));
        this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.processTopicsOnce(), this.scheduleOnce$default$2());
        return false;
    }

    private boolean clearMirrorTopics(Set<String> topics) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Clearing mirror topics for topics '").append(topics).append("' for cluster link id ").append($this.linkId).toString());
        try {
            scala.collection.immutable.Map ops = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)AlterMirrorOp.CLEAR), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            AlterMirrorsOptions options = new AlterMirrorsOptions();
            AlterMirrorsResult result = this.localAdmin.alterMirrors((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)ops).asJava(), options);
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.clearMirrorTopicsComplete(result.values()));
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Encountered error while clearing mirror topics", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.processTopicsOnce(), this.retryDelayMs);
        }
        return false;
    }

    private boolean clearMirrorTopicsComplete(java.util.Map<String, KafkaFuture<Void>> results) {
        if (((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(results).asScala()).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearMirrorTopics.$anonfun$clearMirrorTopicsComplete$1(this, x0$1)))) {
            this.topicGroups_$eq((List<Set<String>>)this.topicGroups().drop(1));
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.processTopicsOnce(), this.scheduleOnce$default$2());
        } else {
            this.scheduleOnce((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.processTopicsOnce(), this.retryDelayMs);
        }
        return false;
    }

    private boolean onCompletion() {
        this.shutdown();
        super.scheduler().scheduleOnce("ClearMirrorTopicsCompleted", this.completionCallback);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$processTopicsOnce$1(ClusterLinkClearMirrorTopics $this, Tuple2 x$1) {
        UUID uUID = ((ClusterLinkTopicState)x$1._2()).linkId();
        UUID uUID2 = $this.linkId;
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$clearMirrorTopicsComplete$1(ClusterLinkClearMirrorTopics $this, Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                bl = true;
            }
            catch (ExecutionException executionException) {
                boolean bl2;
                Throwable throwable = executionException.getCause();
                if (throwable instanceof UnknownTopicOrPartitionException) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Encountered UnknownTopicOrPartitionException while clearing mirror topic '").append(topic).append("'.").append(" Mirror topic may not exist").toString());
                    bl2 = true;
                } else if (throwable != null) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    bl2 = false;
                } else {
                    throw new MatchError(null);
                }
                bl = bl2;
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                bl = false;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public ClusterLinkClearMirrorTopics(UUID linkId, ClusterLinkScheduler scheduler, KafkaZkClient zkClient, KafkaController controller, ConfluentAdmin localAdmin, Function0<BoxedUnit> completionCallback, int topicGroupSize, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.zkClient = zkClient;
        this.controller = controller;
        this.localAdmin = localAdmin;
        this.completionCallback = completionCallback;
        this.topicGroupSize = topicGroupSize;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "ClearMirrorTopics", intervalMs);
    }
}

