/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.cluster.PartitionStatus;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkAutoMirroring;
import kafka.server.link.ClusterLinkCheckAvailability;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkListOffsets;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseMirrorTopics;
import kafka.server.link.ClusterLinkPauseMirrorTopics$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.ClusterLinkSyncOffsets;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r]g\u0001\u0002(P\u0001YC\u0001b\u001b\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\ta\u0002\u0011\t\u0011)A\u0005[\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001x\u0011!q\bA!A!\u0002\u0013A\b\"C@\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\t9\u0001\u0001BC\u0002\u0013\u0005\u0011\u0011\u0002\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005-\u0001BCA\n\u0001\t\u0015\r\u0011\"\u0001\u0002\u0016!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0006\t\u0015\u0005}\u0001A!a\u0001\n\u0013\t\t\u0003\u0003\u0006\u0002*\u0001\u0011\t\u0019!C\u0005\u0003WA!\"a\u000e\u0001\u0005\u0003\u0005\u000b\u0015BA\u0012\u0011)\t\t\u0005\u0001B\u0001B\u0003%\u00111\t\u0005\u000b\u0003?\u0002!\u0011!Q\u0001\n\u0005\u0005\u0004BCA6\u0001\t\u0015\r\u0011\"\u0001\u0002n!Q\u0011Q\u0010\u0001\u0003\u0002\u0003\u0006I!a\u001c\t\u0015\u0005}\u0004A!b\u0001\n\u0003\t\t\t\u0003\u0006\u0002\n\u0002\u0011\t\u0011)A\u0005\u0003\u0007C!\"a#\u0001\u0005\u0003\u0005\u000b\u0011BAG\u0011)\tI\n\u0001BC\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003g\u0003!\u0011!Q\u0001\n\u0005u\u0005bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\f\u0003S\u0003\u0001\u0019!a\u0001\n\u0013\t)\u000eC\u0006\u0002Z\u0002\u0001\r\u00111A\u0005\n\u0005m\u0007bCAp\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/D\u0011\"a9\u0001\u0001\u0004%I!!:\t\u0013\u0005=\b\u00011A\u0005\n\u0005E\b\u0002CA{\u0001\u0001\u0006K!a:\t\u0013\u0005]\b\u00011A\u0005\n\u0005e\b\"\u0003B\u0002\u0001\u0001\u0007I\u0011\u0002B\u0003\u0011!\u0011I\u0001\u0001Q!\n\u0005m\b\"\u0003B\u0006\u0001\u0001\u0007I\u0011\u0002B\u0007\u0011%\u00119\u0002\u0001a\u0001\n\u0013\u0011I\u0002\u0003\u0005\u0003\u001e\u0001\u0001\u000b\u0015\u0002B\b\u0011%\u0011y\u0002\u0001a\u0001\n\u0013\u0011\t\u0003C\u0005\u0003,\u0001\u0001\r\u0011\"\u0003\u0003.!A!\u0011\u0007\u0001!B\u0013\u0011\u0019\u0003C\u0005\u00034\u0001\u0001\r\u0011\"\u0003\u00036!I!q\b\u0001A\u0002\u0013%!\u0011\t\u0005\t\u0005\u000b\u0002\u0001\u0015)\u0003\u00038!I!q\t\u0001A\u0002\u0013%!\u0011\n\u0005\n\u0005'\u0002\u0001\u0019!C\u0005\u0005+B\u0001B!\u0017\u0001A\u0003&!1\n\u0005\n\u00057\u0002!\u0019!C\u0005\u0005;B\u0001B!\u001a\u0001A\u0003%!q\f\u0005\n\u0005O\u0002!\u0019!C\u0005\u0005SB\u0001Ba\u001f\u0001A\u0003%!1\u000e\u0005\n\u0005{\u0002!\u0019!C\u0005\u0005\u007fB\u0001Ba*\u0001A\u0003%!\u0011\u0011\u0005\n\u0005S\u0003!\u0019!C\u0001\u0005WC\u0001Ba-\u0001A\u0003%!Q\u0016\u0005\b\u0005k\u0003A\u0011\u0001B\\\u0011\u001d\u0011I\f\u0001C\u0005\u0005oCqAa/\u0001\t\u0003\u00119\fC\u0004\u0003>\u0002!IAa.\t\u0011\t}\u0006\u0001\"\u0001P\u0005\u0003D\u0001B!5\u0001\t\u0003z%1\u001b\u0005\t\u0005?\u0004A\u0011A(\u0003b\"A!Q\u001d\u0001\u0005\u0002=\u00139\u000fC\u0004\u0003l\u0002!\tA!<\t\u000f\t=\b\u0001\"\u0001\u0003r\"9!\u0011 \u0001\u0005\u0002\tm\bb\u0002B\u007f\u0001\u0011\u0005!q \u0005\b\u0007\u0003\u0001A\u0011AAs\u0011\u001d\u0019\u0019\u0001\u0001C\u0005\u0007\u000bAqaa\u0002\u0001\t\u0013\u00119\fC\u0004\u0004\n\u0001!IAa.\t\u000f\r-\u0001\u0001\"\u0001\u0004\u000e!91Q\u0006\u0001\u0005\u0002\r=\u0002bBB\u001f\u0001\u0011%1q\b\u0005\b\u0007S\u0002A\u0011BB6\u0011\u001d\u0019I\t\u0001C\u0001\u0007\u0017Cqa!,\u0001\t\u0013\u0019y\u000bC\u0004\u0004:\u0002!\t!!\t\t\u000f\rm\u0006\u0001\"\u0001\u0004>\"91Q\u001a\u0001\u0005\u0002\r='\u0001G\"mkN$XM\u001d'j].\u001cE.[3oi6\u000bg.Y4fe*\u0011\u0001+U\u0001\u0005Y&t7N\u0003\u0002S'\u000611/\u001a:wKJT\u0011\u0001V\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q+X3\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\r\u0005s\u0017PU3g!\tq&M\u0004\u0002`A6\tq*\u0003\u0002b\u001f\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t\u0019GMA\u0007DY&,g\u000e^'b]\u0006<WM\u001d\u0006\u0003C>\u0003\"AZ5\u000e\u0003\u001dT!\u0001[*\u0002\u000bU$\u0018\u000e\\:\n\u0005)<'a\u0002'pO\u001eLgnZ\u0001\u0013G2,8\u000f^3s\u0019&t7.T1oC\u001e,'/F\u0001n!\tyf.\u0003\u0002p\u001f\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u00031\u0011'o\\6fe\u000e{gNZ5h!\t\u0019H/D\u0001R\u0013\t)\u0018KA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00037j].$\u0015\r^1\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a_*\u0002\u0005i\\\u0017BA?{\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!\u00037j].$\u0015\r^1!\u000391W\r^2iKJl\u0015M\\1hKJ\u00042aXA\u0002\u0013\r\t)a\u0014\u0002\u001a\u00072,8\u000f^3s\u0019&t7NR3uG\",'/T1oC\u001e,'/A\u0005tG\",G-\u001e7feV\u0011\u00111\u0002\t\u0004?\u00065\u0011bAA\b\u001f\n!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003!Q8n\u00117jK:$XCAA\f!\rI\u0018\u0011D\u0005\u0004\u00037Q(!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u000511m\u001c8gS\u001e,\"!a\t\u0011\u0007}\u000b)#C\u0002\u0002(=\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003[\t\u0019\u0004E\u0002Y\u0003_I1!!\rZ\u0005\u0011)f.\u001b;\t\u0013\u0005UB\"!AA\u0002\u0005\r\u0012a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0003fA\u0007\u0002<A\u0019\u0001,!\u0010\n\u0007\u0005}\u0012L\u0001\u0005w_2\fG/\u001b7f\u0003)\tW\u000f\u001e5pe&TXM\u001d\t\u00061\u0006\u0015\u0013\u0011J\u0005\u0004\u0003\u000fJ&AB(qi&|g\u000e\u0005\u0003\u0002L\u0005mSBAA'\u0015\u0011\t\t%a\u0014\u000b\u0007I\u000b\tFC\u0002U\u0003'RA!!\u0016\u0002X\u00051\u0011\r]1dQ\u0016T!!!\u0017\u0002\u0007=\u0014x-\u0003\u0003\u0002^\u00055#AC!vi\"|'/\u001b>fe\u0006Q1m\u001c8ue>dG.\u001a:\u0011\t\u0005\r\u0014qM\u0007\u0003\u0003KR1!a\u0018T\u0013\u0011\tI'!\u001a\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJ\f\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\t\ty\u0007E\u0003Y\u0003\u000b\n\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\u0011\t9(a\u0014\u0002\rA|G.[2z\u0013\u0011\tY(!\u001e\u0003#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u00170\u0001\nbYR,'oQ8oM&<\u0007k\u001c7jGf\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003\u0007\u00032aXAC\u0013\r\t9i\u0014\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003Aa\u0017N\\6BI6LgNR1di>\u0014\u0018\u0010E\u0004Y\u0003\u001f\u000b\u0019#a%\n\u0007\u0005E\u0015LA\u0005Gk:\u001cG/[8ocA\u0019q,!&\n\u0007\u0005]uJ\u0001\fDYV\u001cH/\u001a:MS:\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003A!Wm\u001d;BI6LgNR1di>\u0014\u00180\u0006\u0002\u0002\u001eB)\u0001,a(\u0002$&\u0019\u0011\u0011U-\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003[\u000b\t&A\u0004dY&,g\u000e^:\n\t\u0005E\u0016q\u0015\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0012I\u0016\u001cH/\u00113nS:4\u0015m\u0019;pef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000f\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019-!2\u0002H\u0006%\u00171ZAg\u0003\u001f\f\t.a5\u0011\u0005}\u0003\u0001\"B6\u0018\u0001\u0004i\u0007\"B9\u0018\u0001\u0004\u0011\b\"\u0002<\u0018\u0001\u0004A\bBB@\u0018\u0001\u0004\t\t\u0001C\u0004\u0002\b]\u0001\r!a\u0003\t\u000f\u0005Mq\u00031\u0001\u0002\u0018!9\u0011qD\fA\u0002\u0005\r\u0002bBA!/\u0001\u0007\u00111\t\u0005\b\u0003?:\u0002\u0019AA1\u0011\u001d\tYg\u0006a\u0001\u0003_Bq!a \u0018\u0001\u0004\t\u0019\tC\u0004\u0002\f^\u0001\r!!$\t\u000f\u0005eu\u00031\u0001\u0002\u001eV\u0011\u0011q\u001b\t\u00061\u0006\u0015\u00131S\u0001\nC\u0012l\u0017N\\0%KF$B!!\f\u0002^\"I\u0011QG\r\u0002\u0002\u0003\u0007\u0011q[\u0001\u0007C\u0012l\u0017N\u001c\u0011)\u0007i\tY$A\ndYV\u001cH/\u001a:MS:\\7+\u001f8d\u0003\u000ed7/\u0006\u0002\u0002hB)\u0001,!\u0012\u0002jB\u0019q,a;\n\u0007\u00055xJA\nDYV\u001cH/\u001a:MS:\\7+\u001f8d\u0003\u000ed7/A\fdYV\u001cH/\u001a:MS:\\7+\u001f8d\u0003\u000ed7o\u0018\u0013fcR!\u0011QFAz\u0011%\t)\u0004HA\u0001\u0002\u0004\t9/\u0001\u000bdYV\u001cH/\u001a:MS:\\7+\u001f8d\u0003\u000ed7\u000fI\u0001\u0017G2,8\u000f^3s\u0019&t7nU=oG>3gm]3ugV\u0011\u00111 \t\u00061\u0006\u0015\u0013Q \t\u0004?\u0006}\u0018b\u0001B\u0001\u001f\n12\t\\;ti\u0016\u0014H*\u001b8l'ft7m\u00144gg\u0016$8/\u0001\u000edYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002.\t\u001d\u0001\"CA\u001b?\u0005\u0005\t\u0019AA~\u0003]\u0019G.^:uKJd\u0015N\\6Ts:\u001cwJ\u001a4tKR\u001c\b%A\u000edYV\u001cH/\u001a:MS:\\7+\u001f8d)>\u0004\u0018nY\"p]\u001aLwm]\u000b\u0003\u0005\u001f\u0001R\u0001WA#\u0005#\u00012a\u0018B\n\u0013\r\u0011)b\u0014\u0002\u001d\u00072,8\u000f^3s\u0019&t7nU=oGR{\u0007/[2t\u0007>tg-[4t\u0003}\u0019G.^:uKJd\u0015N\\6Ts:\u001cGk\u001c9jG\u000e{gNZ5hg~#S-\u001d\u000b\u0005\u0003[\u0011Y\u0002C\u0005\u00026\t\n\t\u00111\u0001\u0003\u0010\u0005a2\r\\;ti\u0016\u0014H*\u001b8l'ft7\rV8qS\u000e\u001cuN\u001c4jON\u0004\u0013\u0001H2mkN$XM\u001d'j].\u001c\u0005.Z2l\u0003Z\f\u0017\u000e\\1cS2LG/_\u000b\u0003\u0005G\u0001R\u0001WA#\u0005K\u00012a\u0018B\u0014\u0013\r\u0011Ic\u0014\u0002\u001d\u00072,8\u000f^3s\u0019&t7n\u00115fG.\fe/Y5mC\nLG.\u001b;z\u0003\u0001\u001aG.^:uKJd\u0015N\\6DQ\u0016\u001c7.\u0011<bS2\f'-\u001b7jif|F%Z9\u0015\t\u00055\"q\u0006\u0005\n\u0003k)\u0013\u0011!a\u0001\u0005G\tQd\u00197vgR,'\u000fT5oW\u000eCWmY6Bm\u0006LG.\u00192jY&$\u0018\u0010I\u0001\u0019G2,8\u000f^3s\u0019&t7.Q;u_6K'O]8sS:<WC\u0001B\u001c!\u0015A\u0016Q\tB\u001d!\ry&1H\u0005\u0004\u0005{y%\u0001G\"mkN$XM\u001d'j].\fU\u000f^8NSJ\u0014xN]5oO\u0006a2\r\\;ti\u0016\u0014H*\u001b8l\u0003V$x.T5se>\u0014\u0018N\\4`I\u0015\fH\u0003BA\u0017\u0005\u0007B\u0011\"!\u000e)\u0003\u0003\u0005\rAa\u000e\u00023\rdWo\u001d;fe2Kgn[!vi>l\u0015N\u001d:pe&tw\rI\u0001\u0017G2,8\u000f^3s\u0019&t7\u000eT5ti>3gm]3ugV\u0011!1\n\t\u00061\u0006\u0015#Q\n\t\u0004?\n=\u0013b\u0001B)\u001f\n12\t\\;ti\u0016\u0014H*\u001b8l\u0019&\u001cHo\u00144gg\u0016$8/\u0001\u000edYV\u001cH/\u001a:MS:\\G*[:u\u001f\u001a47/\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002.\t]\u0003\"CA\u001bW\u0005\u0005\t\u0019\u0001B&\u0003]\u0019G.^:uKJd\u0015N\\6MSN$xJ\u001a4tKR\u001c\b%\u0001\u000fdYV\u001cH/\u001a:MS:\\\u0007+Y;tK6K'O]8s)>\u0004\u0018nY:\u0016\u0005\t}\u0003cA0\u0003b%\u0019!1M(\u00039\rcWo\u001d;fe2Kgn\u001b)bkN,W*\u001b:s_J$v\u000e]5dg\u0006i2\r\\;ti\u0016\u0014H*\u001b8l!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\b%\u0001\u0003m_\u000e\\WC\u0001B6!\u0011\u0011iGa\u001e\u000e\u0005\t=$\u0002\u0002B9\u0005g\nA\u0001\\1oO*\u0011!QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003z\t=$AB(cU\u0016\u001cG/A\u0003m_\u000e\\\u0007%\u0001\u0004u_BL7m]\u000b\u0003\u0005\u0003\u0003bAa!\u0003\u000e\nEUB\u0001BC\u0015\u0011\u00119I!#\u0002\u000f5,H/\u00192mK*\u0019!1R-\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0010\n\u0015%aA*fiB!!1\u0013BQ\u001d\u0011\u0011)J!(\u0011\u0007\t]\u0015,\u0004\u0002\u0003\u001a*\u0019!1T+\u0002\rq\u0012xn\u001c;?\u0013\r\u0011y*W\u0001\u0007!J,G-\u001a4\n\t\t\r&Q\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t}\u0015,A\u0004u_BL7m\u001d\u0011\u0002\u001b\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u+\t\u0011i\u000bE\u0002z\u0005_K1A!-{\u00055\tE-\\5o5.\u001cE.[3oi\u0006q\u0011\rZ7j]j[7\t\\5f]R\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0003\u0003[\t!c\u001d;beR,\b/Q2uSZ,G+Y:lg\u0006A1\u000f[;uI><h.A\ntQV$Hm\\<o\u0003\u000e$\u0018N^3UCN\\7/A\u0006sK\u000e|gNZ5hkJ,GCBA\u0017\u0005\u0007\u00149\rC\u0004\u0003Ff\u0002\r!a\t\u0002\u00139,woQ8oM&<\u0007b\u0002Bes\u0001\u0007!1Z\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000f\u0005\u0004\u0003N\n='\u0011S\u0007\u0003\u0005\u0013KAAa$\u0003\n\u0006!rN\\!wC&d\u0017MY5mSRL8\t[1oO\u0016$B!!\f\u0003V\"9!q\u001b\u001eA\u0002\te\u0017aC5t\u0003Z\f\u0017\u000e\\1cY\u0016\u00042\u0001\u0017Bn\u0013\r\u0011i.\u0017\u0002\b\u0005>|G.Z1o\u0003%\tG\r\u001a+pa&\u001c7\u000f\u0006\u0003\u0002.\t\r\bb\u0002Bpw\u0001\u0007!1Z\u0001\re\u0016lwN^3U_BL7m\u001d\u000b\u0005\u0003[\u0011I\u000fC\u0004\u0003fr\u0002\rAa3\u0002\u0013\u001d,G\u000fV8qS\u000e\u001cXC\u0001Bf\u0003!9W\r^!e[&tWC\u0001Bz!\u0011\t)K!>\n\t\t]\u0018q\u0015\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003e9W\r^\"mkN$XM\u001d'j].\fE-\\5o\u00072LWM\u001c;\u0016\u0005\u0005M\u0015!D4fi\u0006+H\u000f[8sSj,'/\u0006\u0002\u0002D\u0005qq-\u001a;Ts:\u001c\u0017i\u00197UCN\\\u0017\u0001C5t\u0003\u000e$\u0018N^3\u0015\u0005\te\u0017!E2sK\u0006$X-\u00118e'\u0016$\u0018\tZ7j]\u0006Q1\r\\8tK\u0006#W.\u001b8\u0002)\u0019,Go\u00195U_BL7\rU1si&$\u0018n\u001c8t)\u0019\u0019ya!\n\u0004*A11\u0011CB\u000e\u0007?i!aa\u0005\u000b\t\rU1qC\u0001\u000bG>t7-\u001e:sK:$(\u0002BB\r\u0005g\nA!\u001e;jY&!1QDB\n\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u00041\u000e\u0005\u0012bAB\u00123\n\u0019\u0011J\u001c;\t\u000f\r\u001dR\t1\u0001\u0003\u0012\u0006)Ao\u001c9jG\"911F#A\u0002\r}\u0011!\u0003;j[\u0016|W\u000f^'t\u000391W\r^2i)>\u0004\u0018nY%oM>$ba!\r\u0004:\rm\u0002CBB\t\u00077\u0019\u0019\u0004E\u0002`\u0007kI1aa\u000eP\u0005Q\u0019E.^:uKJd\u0015N\\6U_BL7-\u00138g_\"91q\u0005$A\u0002\tE\u0005bBB\u0016\r\u0002\u00071qD\u0001\u001cM\u0016$8\r\u001b+pa&\u001c\u0017J\u001c4p\u0011\u0006tG\r\\3SKN,H\u000e^:\u0015\u0015\u000552\u0011IB\"\u00073\u001a)\u0007C\u0004\u0004(\u001d\u0003\rA!%\t\u000f\r\u0015s\t1\u0001\u0004H\u0005a1m\u001c8gS\u001e4U\u000f^;sKB11\u0011JB(\u0007'j!aa\u0013\u000b\t\r5\u0013\u0011K\u0001\u0007G>lWn\u001c8\n\t\rE31\n\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0003\u0002&\u000eU\u0013\u0002BB,\u0003O\u0013aaQ8oM&<\u0007bBB.\u000f\u0002\u00071QL\u0001\u0012I\u0016\u001c8M]5qi&|gNR;ukJ,\u0007CBB%\u0007\u001f\u001ay\u0006\u0005\u0003\u0002&\u000e\u0005\u0014\u0002BB2\u0003O\u0013\u0001\u0003V8qS\u000e$Um]2sSB$\u0018n\u001c8\t\u000f\r\u001dt\t1\u0001\u00042\u00051!/Z:vYR\f1DZ3uG\"$v\u000e]5d\u0013:4wn\u0016:ba\u0016C8-\u001a9uS>tG\u0003CB7\u0007\u007f\u001a\ti!\"\u0011\t\r=4\u0011\u0010\b\u0005\u0007c\u001a)H\u0004\u0003\u0003\u0018\u000eM\u0014\"\u0001.\n\u0007\r]\u0014,A\u0004qC\u000e\\\u0017mZ3\n\t\rm4Q\u0010\u0002\n)\"\u0014xn^1cY\u0016T1aa\u001eZ\u0011\u001d\u00199\u0003\u0013a\u0001\u0005#Cqaa!I\u0001\u0004\u0019i'A\u0001f\u0011\u001d\u00199\t\u0013a\u0001\u0005#\u000ba!Y2uS>t\u0017!\u0004:fa2L7-Y*uCR,8\u000f\u0006\u0003\u0004\u000e\u000e\u001d\u0006\u0003\u0003Bg\u0007\u001f\u001b\u0019j!'\n\t\rE%\u0011\u0012\u0002\u0004\u001b\u0006\u0004\b\u0003BB%\u0007+KAaa&\u0004L\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007CBB\t\u00077\u0019Y\n\u0005\u0003\u0004\u001e\u000e\rVBABP\u0015\r\u0019\tkU\u0001\bG2,8\u000f^3s\u0013\u0011\u0019)ka(\u0003\u001fA\u000b'\u000f^5uS>t7\u000b^1ukNDqa!+J\u0001\u0004\u0019Y+\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004bA!4\u0003P\u000eM\u0015A\u0007;p%\u0016\u001cX\u000f\u001c;NSJ\u0014xN]%oM>\u001cFO]5qa\u0016$G\u0003BBN\u0007cCqaa\u001aK\u0001\u0004\u0019\u0019\f\u0005\u0003\u0002&\u000eU\u0016\u0002BB\\\u0003O\u0013q\u0002U1si&$\u0018n\u001c8SKN,H\u000e^\u0001\u000eGV\u0014(/\u001a8u\u0007>tg-[4\u0002CI,7\u000f\u001e:jGR4\u0016\r\\5eCR,Gk\u001c9jG\u000e{gNZ5h!>d\u0017nY=\u0015\r\r}6qYBe!\u0011\u0019\tma1\u000e\u0005\r]\u0011\u0002BBc\u0007/\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u00199\u0003\u0014a\u0001\u0005#Cqaa3M\u0001\u0004\u0019y,A\u0003qe>\u00048/\u0001\u000bu_BL7mQ8oM&<7+\u001f8d%VdWm\u001d\u000b\u0003\u0007#\u00042aXBj\u0013\r\u0019)n\u0014\u0002\u001b\u001b&\u0014(o\u001c:U_BL7mQ8oM&<7+\u001f8d%VdWm\u001d")
public class ClusterLinkClientManager
implements ClusterLinkFactory.ClientManager,
Logging {
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ClusterLinkScheduler scheduler;
    private final KafkaZkClient zkClient;
    private volatile ClusterLinkConfig config;
    private final Option<Authorizer> authorizer;
    private final KafkaController controller;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkMetrics metrics;
    private final Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory;
    private final Function0<Admin> destAdminFactory;
    private volatile Option<ClusterLinkAdminClient> admin;
    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls;
    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets;
    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs;
    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability;
    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring;
    private Option<ClusterLinkListOffsets> clusterLinkListOffsets;
    private final ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics;
    private final Object lock;
    private final scala.collection.mutable.Set<String> topics;
    private final AdminZkClient adminZkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    public Function0<Admin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private Option<ClusterLinkAdminClient> admin() {
        return this.admin;
    }

    private void admin_$eq(Option<ClusterLinkAdminClient> x$1) {
        this.admin = x$1;
    }

    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls() {
        return this.clusterLinkSyncAcls;
    }

    private void clusterLinkSyncAcls_$eq(Option<ClusterLinkSyncAcls> x$1) {
        this.clusterLinkSyncAcls = x$1;
    }

    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets() {
        return this.clusterLinkSyncOffsets;
    }

    private void clusterLinkSyncOffsets_$eq(Option<ClusterLinkSyncOffsets> x$1) {
        this.clusterLinkSyncOffsets = x$1;
    }

    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs() {
        return this.clusterLinkSyncTopicConfigs;
    }

    private void clusterLinkSyncTopicConfigs_$eq(Option<ClusterLinkSyncTopicsConfigs> x$1) {
        this.clusterLinkSyncTopicConfigs = x$1;
    }

    private Option<ClusterLinkCheckAvailability> clusterLinkCheckAvailability() {
        return this.clusterLinkCheckAvailability;
    }

    private void clusterLinkCheckAvailability_$eq(Option<ClusterLinkCheckAvailability> x$1) {
        this.clusterLinkCheckAvailability = x$1;
    }

    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring() {
        return this.clusterLinkAutoMirroring;
    }

    private void clusterLinkAutoMirroring_$eq(Option<ClusterLinkAutoMirroring> x$1) {
        this.clusterLinkAutoMirroring = x$1;
    }

    private Option<ClusterLinkListOffsets> clusterLinkListOffsets() {
        return this.clusterLinkListOffsets;
    }

    private void clusterLinkListOffsets_$eq(Option<ClusterLinkListOffsets> x$1) {
        this.clusterLinkListOffsets = x$1;
    }

    private ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics() {
        return this.clusterLinkPauseMirrorTopics;
    }

    private Object lock() {
        return this.lock;
    }

    private scala.collection.mutable.Set<String> topics() {
        return this.topics;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Starting ClusterLinkClientManager with cluster link data ").append(this.linkData()).toString());
        if (this.isActive()) {
            this.createAndSetAdmin();
            this.startupActiveTasks();
        }
        this.clusterLinkPauseMirrorTopics().startup();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Startup of ClusterLinkClientManager with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void startupActiveTasks() {
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)new Some((Object)new ClusterLinkSyncOffsets(this, this.linkData(), this.controller, this.destAdminFactory(), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncOffsets().get()).startup();
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)new Some((Object)new ClusterLinkSyncTopicsConfigs(this, Predef$.MODULE$.Integer2int(this.config().topicConfigSyncMs()), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncTopicConfigs().get()).startup();
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)new Some((Object)new ClusterLinkListOffsets(this, this.fetcherManager, Predef$.MODULE$.Integer2int(this.config().availabilityCheckMs()))));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkListOffsets().get()).startup();
        if (this.config().aclSyncEnable()) {
            this.authorizer.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            });
            this.config().aclFilters().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but acl.filters is not set. Please set acl.filters to proceed with ACL migration.");
            });
            this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)new Some((Object)new ClusterLinkSyncAcls(this, this.controller, this.metrics())));
            ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncAcls().get()).startup();
        }
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this, this.config(), this.metrics(), this.clusterLinkManager(), Predef$.MODULE$.Integer2int(this.config().availabilityCheckMs()))));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)new Some((Object)new ClusterLinkAutoMirroring(this, this.linkData(), this.controller, this.destAdminFactory(), this.metrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkAutoMirroring().get()).startup();
    }

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Shutting down ClusterLinkClientManager with cluster link data ").append(this.linkData()).toString());
        this.clusterLinkPauseMirrorTopics().shutdown();
        if (this.isActive()) {
            this.shutdownActiveTasks();
            this.closeAdmin();
            this.admin_$eq(null);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Shutdown of ClusterLinkClientManager with cluster link data ").append(this.linkData()).append(" is complete").toString());
    }

    private void shutdownActiveTasks() {
        this.clusterLinkSyncTopicConfigs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)None$.MODULE$);
        this.clusterLinkSyncOffsets().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)None$.MODULE$);
        this.clusterLinkSyncAcls().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)None$.MODULE$);
        this.clusterLinkCheckAvailability().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)None$.MODULE$);
        this.clusterLinkAutoMirroring().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)None$.MODULE$);
        this.clusterLinkListOffsets().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)None$.MODULE$);
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.lock();
        synchronized (object) {
            boolean oldActive = this.isActive();
            this.config_$eq(newConfig);
            boolean newActive = this.isActive();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Reconfiguring ClusterLinkClientManager. oldActive=").append(oldActive).append(" and newActive=").append(newActive).toString());
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(oldActive, newActive);
            if (oldActive || newActive) {
                if (!oldActive && newActive) {
                    this.createAndSetAdmin();
                    this.startupActiveTasks();
                } else if (oldActive && !newActive) {
                    this.shutdownActiveTasks();
                    this.closeAdmin();
                    this.admin_$eq((Option<ClusterLinkAdminClient>)None$.MODULE$);
                } else if (oldActive && newActive) {
                    if (updatedKeys.diff(ClusterLinkConfig$.MODULE$.ReplicationProps()).nonEmpty()) {
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Reconfiguring AdminClient and restarting tasks for ClusterLinkClientManager");
                        this.createAndSetAdmin();
                        this.shutdownActiveTasks();
                        this.startupActiveTasks();
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
            }
            return;
        }
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processing link availability change to ").append(isAvailable).toString());
            this.shutdownActiveTasks();
            if (!Predef$.MODULE$.Boolean2boolean(this.currentConfig().clusterLinkPaused())) {
                if (isAvailable) {
                    this.startupActiveTasks();
                } else {
                    int intervalMs = Math.max(10, Math.min((int)Predef$.MODULE$.Long2long(this.config().reconnectBackoffMaxMs()), Predef$.MODULE$.Integer2int(this.config().availabilityCheckMs())));
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(105).append("Link is unavailable, starting availability checks with periodic interval ").append(intervalMs).append(" ms until link becomes available").toString());
                    this.clusterLinkCheckAvailability_$eq((Option<ClusterLinkCheckAvailability>)new Some((Object)new ClusterLinkCheckAvailability(this, this.config(), this.metrics(), this.clusterLinkManager(), intervalMs)));
                    ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkCheckAvailability().get()).startup();
                }
            }
            return;
        }
    }

    @Override
    public void addTopics(Set<String> addTopics) {
        Object object = this.lock();
        synchronized (object) {
            addTopics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ClusterLinkClientManager.$anonfun$addTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void removeTopics(Set<String> removeTopics) {
        Object object = this.lock();
        synchronized (object) {
            removeTopics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ClusterLinkClientManager.$anonfun$removeTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Set<String> getTopics() {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = this.topics().toSet();
            return set;
        }
    }

    public ConfluentAdmin getAdmin() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return ((ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        })).admin();
    }

    public ClusterLinkAdminClient getClusterLinkAdminClient() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(this.linkData()).toString());
        }
        return (ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.linkData().linkName()).append(" is paused").toString());
        });
    }

    public Option<Authorizer> getAuthorizer() {
        return this.authorizer;
    }

    public Option<ClusterLinkSyncAcls> getSyncAclTask() {
        return this.clusterLinkSyncAcls();
    }

    private boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.config().clusterLinkPaused());
    }

    private void createAndSetAdmin() {
        this.closeAdmin();
        this.admin_$eq((Option<ClusterLinkAdminClient>)new Some(this.linkAdminFactory.apply((Object)this.config())));
    }

    private void closeAdmin() {
        Option<ClusterLinkAdminClient> curAdmin = this.admin();
        if (curAdmin != null) {
            curAdmin.foreach((Function1 & Serializable & scala.Serializable)a -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> a.admin().close(Duration.ZERO), this, CoreUtils$.MODULE$.swallow$default$3());
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
        void var3_3;
        CompletableFuture result = new CompletableFuture();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            this.scheduler().scheduleWhenComplete("ClusterLinkFetchTopicPartitions", describeTopicsResult.all(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> result.complete(BoxesRunTime.boxToInteger((int)((TopicDescription)((KafkaFuture)describeTopicsResult.values().get(topic)).get()).partitions().size())));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "fetching partitions"));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs) {
        void var3_3;
        CompletableFuture result = new CompletableFuture();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)).includeAuthorizedOperations(true);
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            DescribeConfigsOptions describeConfigsOptions = new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeConfigsResult describeConfigsResult = this.getAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava(), describeConfigsOptions);
            KafkaFuture futures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{describeTopicsResult.all(), describeConfigsResult.all()});
            this.scheduler().scheduleWhenComplete("FetchTopicInfo", futures, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fetchTopicInfoHandleResults(topic, (KafkaFuture<Config>)((KafkaFuture)describeConfigsResult.values().get(resource)), (KafkaFuture<TopicDescription>)((KafkaFuture)describeTopicsResult.values().get(topic)), result));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "preparing client to fetch information"));
        }
        return var3_3;
    }

    private void fetchTopicInfoHandleResults(String topic, KafkaFuture<Config> configFuture, KafkaFuture<TopicDescription> descriptionFuture, CompletableFuture<ClusterLinkTopicInfo> result) {
        try {
            TopicDescription description = (TopicDescription)this.maybeThrowException$1(topic, descriptionFuture, "fetching description");
            Config config = (Config)this.maybeThrowException$1(topic, configFuture, "fetching configuration");
            result.complete(new ClusterLinkTopicInfo(description, config));
            return;
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
            return;
        }
    }

    private Throwable fetchTopicInfoWrapException(String topic, Throwable e, String action) {
        ApiError error = ApiError.fromThrowable((Throwable)e);
        return error.error().exception(new StringBuilder(42).append("While ").append(action).append(" for topic '").append(topic).append("' over cluster link '").append(this.linkData().linkName()).append("': ").append(error.messageWithFallback()).toString());
    }

    @Override
    public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
        ReplicaStatusOptions options = new ReplicaStatusOptions().includeLinkedReplicas(false);
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.getAdmin().replicaStatus((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(partitions).asJava(), options).partitionResults()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            KafkaFuture future = (KafkaFuture)x0$1._2();
            CompletableFuture completableFuture = new CompletableFuture();
            future.whenComplete((res, ex) -> {
                Option option = Option$.MODULE$.apply(ex);
                if (option instanceof Some) {
                    Throwable e = (Throwable)((Some)option).value();
                    completableFuture.completeExceptionally(e);
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    completableFuture.complete(this.toResultMirrorInfoStripped((PartitionResult)res));
                    return;
                }
                throw new MatchError((Object)option);
            });
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), completableFuture);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private PartitionStatus toResultMirrorInfoStripped(PartitionResult result) {
        Seq replicas = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)rs -> new ReplicaStatus(rs.brokerId(), rs.isLeader(), rs.isObserver(), rs.isIsrEligible(), rs.isInIsr(), rs.isCaughtUp(), rs.logStartOffset(), rs.logEndOffset(), rs.lastCaughtUpTimeMs(), rs.lastFetchTimeMs(), Optional.of(this.linkData().linkName()), Optional.empty()), Buffer$.MODULE$.canBuildFrom())).toSeq();
        return new PartitionStatus(result.leaderId(), result.leaderEpoch().getAsInt(), (Seq<ReplicaStatus>)replicas);
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.config();
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props) {
        Properties properties;
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            Properties properties2;
            AlterConfigPolicy policy = (AlterConfigPolicy)((Some)option).value();
            java.util.Map configs = Utils.propsToStringMap((Properties)props);
            if (policy instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)policy;
                java.util.Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                properties2 = Utils.mkProperties(newConfigs);
            } else {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                policy.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
                properties2 = props;
            }
            properties = properties2;
        } else if (None$.MODULE$.equals(option)) {
            properties = props;
        } else {
            throw new MatchError(option);
        }
        return properties;
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.currentConfig().topicConfigSyncRules();
    }

    public static final /* synthetic */ void $anonfun$addTopics$1(ClusterLinkClientManager $this, String topic) {
        if ($this.topics().add((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Added topic '").append(topic).append("' for cluster link data '").append($this.linkData()).append("'").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$removeTopics$1(ClusterLinkClientManager $this, String topic) {
        if ($this.topics().remove((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Removed topic '").append(topic).append("' for cluster link data '").append($this.linkData()).append("''").toString());
        }
    }

    private final Object maybeThrowException$1(String topic, KafkaFuture future, String action) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw this.fetchTopicInfoWrapException(topic, e.getCause(), action);
        }
        catch (Throwable e) {
            throw this.fetchTopicInfoWrapException(topic, e, action);
        }
    }

    public ClusterLinkClientManager(ClusterLinkManager clusterLinkManager, KafkaConfig brokerConfig, ClusterLinkData linkData, ClusterLinkFetcherManager fetcherManager, ClusterLinkScheduler scheduler, KafkaZkClient zkClient, ClusterLinkConfig config, Option<Authorizer> authorizer, KafkaController controller, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkMetrics metrics, Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory, Function0<Admin> destAdminFactory) {
        this.clusterLinkManager = clusterLinkManager;
        this.linkData = linkData;
        this.fetcherManager = fetcherManager;
        this.scheduler = scheduler;
        this.zkClient = zkClient;
        this.config = config;
        this.authorizer = authorizer;
        this.controller = controller;
        this.alterConfigPolicy = alterConfigPolicy;
        this.metrics = metrics;
        this.linkAdminFactory = linkAdminFactory;
        this.destAdminFactory = destAdminFactory;
        ClusterLinkFactory.ClientManager.$init$(this);
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(36).append("[ClusterLinkClientManager-").append(linkData.linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.clusterLinkSyncAcls = None$.MODULE$;
        this.clusterLinkSyncOffsets = None$.MODULE$;
        this.clusterLinkSyncTopicConfigs = None$.MODULE$;
        this.clusterLinkCheckAvailability = None$.MODULE$;
        this.clusterLinkAutoMirroring = None$.MODULE$;
        this.clusterLinkListOffsets = None$.MODULE$;
        this.clusterLinkPauseMirrorTopics = new ClusterLinkPauseMirrorTopics(linkData.linkId(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.isActive(), scheduler, controller, destAdminFactory, ClusterLinkPauseMirrorTopics$.MODULE$.$lessinit$greater$default$6(), ClusterLinkPauseMirrorTopics$.MODULE$.$lessinit$greater$default$7(), ClusterLinkPauseMirrorTopics$.MODULE$.$lessinit$greater$default$8());
        this.lock = new Object();
        this.topics = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.adminZkClient = new AdminZkClient(zkClient);
    }
}

