/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkMode$Destination$;
import kafka.server.link.LinkMode$Source$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!B\u0012%\u0003\u0003Y\u0003\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A!\t\u0011!\u0003!\u0011!Q\u0001\n\tC\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001b\u0002\u0011)\u0019!C\u0001\u001d\"A!\f\u0001B\u0001B\u0003%q\n\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d1\u0007A1A\u0005\u0012\u001dDaa\u001d\u0001!\u0002\u0013A\u0007b\u0002;\u0001\u0005\u0004%\t\"\u001e\u0005\u0007}\u0002\u0001\u000b\u0011\u0002<\t\u0011}\u0004\u0001\u0019!C\u0005\u0003\u0003A\u0011\"a\u0001\u0001\u0001\u0004%I!!\u0002\t\u000f\u0005E\u0001\u0001)Q\u0005\u0015\"I\u00111\u0004\u0001A\u0002\u0013E\u0011Q\u0004\u0005\n\u0003K\u0001\u0001\u0019!C\t\u0003OA\u0001\"a\u000b\u0001A\u0003&\u0011q\u0004\u0005\n\u0003_\u0001\u0001\u0019!C\t\u0003;A\u0011\"!\r\u0001\u0001\u0004%\t\"a\r\t\u0011\u0005]\u0002\u0001)Q\u0005\u0003?A\u0011\"a\u000f\u0001\u0005\u0004%\t!!\u0010\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003\u007fAq!!\u001a\u0001\t\u0003\n9\u0007\u0003\u0005\u0002j\u0001!\t\u0005JA6\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!!#\u0001\t\u0003\n9\u0007C\u0004\u0002\f\u0002!\t%!\b\t\u000f\u00055\u0005\u0001\"\u0011\u0002\u0002!9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAM\u0001\u0011E\u0011q\r\u0005\b\u00037\u0003A\u0011CA4\u0011\u001d\ti\n\u0001D\t\u0003OBq!a(\u0001\r#\t9\u0007C\u0004\u0002\"\u0002!\t\"a\u001a\u00039\rcWo\u001d;fe2Kgn[\"p]:,7\r^5p]6\u000bg.Y4fe*\u0011QEJ\u0001\u0005Y&t7N\u0003\u0002(Q\u000511/\u001a:wKJT\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001AF\r\u001e\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\t\u0019tG\u0004\u00025k5\tA%\u0003\u00027I\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\tA\u0014HA\tD_:tWm\u0019;j_:l\u0015M\\1hKJT!A\u000e\u0013\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uB\u0013!B;uS2\u001c\u0018BA =\u0005\u001daunZ4j]\u001e\f\u0001\u0002\\5oW\u0012\u000bG/Y\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tK\u0001\u0003u.L!a\u0012#\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006\f\u0011\u0002\\5oW\u0012\u000bG/\u0019\u0011\u0002\u001b%t\u0017\u000e^5bY\u000e{gNZ5h!\t!4*\u0003\u0002MI\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002'1|7-\u00197M_\u001eL7-\u00197DYV\u001cH/\u001a:\u0016\u0003=\u0003\"\u0001U,\u000f\u0005E+\u0006C\u0001*/\u001b\u0005\u0019&B\u0001++\u0003\u0019a$o\\8u}%\u0011aKL\u0001\u0007!J,G-\u001a4\n\u0005aK&AB*ue&twM\u0003\u0002W]\u0005!Bn\\2bY2{w-[2bY\u000ecWo\u001d;fe\u0002\nq!\\3ue&\u001c7\u000f\u0005\u00025;&\u0011a\f\n\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0004=S:LGO\u0010\u000b\u0006C\n\u001cG-\u001a\t\u0003i\u0001AQ\u0001Q\u0004A\u0002\tCQ!S\u0004A\u0002)CQ!T\u0004A\u0002=CQaW\u0004A\u0002q\u000ba\u0001\\5oW&#W#\u00015\u0011\u0005%\fX\"\u00016\u000b\u0005-d\u0017AB2p[6|gN\u0003\u0002*[*\u0011an\\\u0001\u0007CB\f7\r[3\u000b\u0003A\f1a\u001c:h\u0013\t\u0011(N\u0001\u0003Vk&$\u0017a\u00027j].LE\rI\u0001\u0010gR\fG/Z\"iC:<W\rT8dWV\ta\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006!A.\u00198h\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! =\u0003\r=\u0013'.Z2u\u0003A\u0019H/\u0019;f\u0007\"\fgnZ3M_\u000e\\\u0007%A\tdYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e,\u0012AS\u0001\u0016G2,8\u000f^3s\u0019&t7nQ8oM&<w\fJ3r)\u0011\t9!!\u0004\u0011\u00075\nI!C\u0002\u0002\f9\u0012A!\u00168ji\"A\u0011qB\u0007\u0002\u0002\u0003\u0007!*A\u0002yIE\n!c\u00197vgR,'\u000fT5oW\u000e{gNZ5hA!\u001aa\"!\u0006\u0011\u00075\n9\"C\u0002\u0002\u001a9\u0012\u0001B^8mCRLG.Z\u0001\u0018g>,(oY3D_:tWm\u0019;j_:,e.\u00192mK\u0012,\"!a\b\u0011\u00075\n\t#C\u0002\u0002$9\u0012qAQ8pY\u0016\fg.A\u000et_V\u00148-Z\"p]:,7\r^5p]\u0016s\u0017M\u00197fI~#S-\u001d\u000b\u0005\u0003\u000f\tI\u0003C\u0005\u0002\u0010A\t\t\u00111\u0001\u0002 \u0005A2o\\;sG\u0016\u001cuN\u001c8fGRLwN\\#oC\ndW\r\u001a\u0011)\u0007E\t)\"\u0001\u0005jg\u0006\u001bG/\u001b<f\u00031I7/Q2uSZ,w\fJ3r)\u0011\t9!!\u000e\t\u0013\u0005=1#!AA\u0002\u0005}\u0011!C5t\u0003\u000e$\u0018N^3!Q\r!\u0012QC\u0001\f[\u0006DHj\\4MKZ,G.\u0006\u0002\u0002@A1\u0011\u0011IA(\u0003'j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0007CR|W.[2\u000b\t\u0005%\u00131J\u0001\u000bG>t7-\u001e:sK:$(bAA'u\u0006!Q\u000f^5m\u0013\u0011\t\t&a\u0011\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&A\u0003fm\u0016tGOC\u0002\u0002^=\fQa\u001d7gi)LA!!\u0019\u0002X\t)A*\u001a<fY\u0006aQ.\u0019=M_\u001edUM^3mA\u000591\u000f^1siV\u0004HCAA\u0004\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005\u001d\u0011QNA9\u0011\u0019\ty\u0007\u0007a\u0001\u0015\u0006Ia.Z<D_:4\u0017n\u001a\u0005\b\u0003gB\u0002\u0019AA;\u0003-)\b\u000fZ1uK\u0012\\U-_:\u0011\u000b\u0005]\u0014QP(\u000e\u0005\u0005e$bAA>]\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\u0004'\u0016$\u0018\u0001F8o\u0003Z\f\u0017\u000e\\1cS2LG/_\"iC:<W\r\u0006\u0003\u0002\b\u0005\u0015\u0005bBAD3\u0001\u0007\u0011qD\u0001\fSN\fe/Y5mC\ndW-\u0001\u0005tQV$Hm\\<o\u0003\u0019\t7\r^5wK\u0006i1-\u001e:sK:$8i\u001c8gS\u001e\fA\u0002\\5oW\u000ecWo\u001d;feN,\"!a%\u0011\u000b\u0005]\u0014QS(\n\t\u0005]\u0015\u0011\u0010\u0002\u0004'\u0016\f\u0018aH3ogV\u0014XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8og\u0016s\u0017M\u00197fI\u0006Y\"/Z:fiJ+g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:\fAd\u0019:fCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg.A\u000edY>\u001cXMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u0003\u0012l\u0017N\\\u0001\u0016kB$\u0017\r^3BGRLg/\u001a'j].\u001cu.\u001e8u\u0001")
public abstract class ClusterLinkConnectionManager
implements ClusterLinkFactory.ConnectionManager,
Logging {
    private final ClusterLinkData linkData;
    private final String localLogicalCluster;
    private final ClusterLinkMetrics metrics;
    private final Uuid linkId;
    private final Object stateChangeLock;
    private volatile ClusterLinkConfig clusterLinkConfig;
    private volatile boolean sourceConnectionEnabled;
    private volatile boolean isActive;
    private final AtomicReference<Level> maxLogLevel;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void onControllerChange(boolean isActive) {
        ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
    }

    @Override
    public int persistentConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
    }

    @Override
    public int reverseConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public ClusterLinkData linkData() {
        return this.linkData;
    }

    @Override
    public String localLogicalCluster() {
        return this.localLogicalCluster;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Object stateChangeLock() {
        return this.stateChangeLock;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    public boolean sourceConnectionEnabled() {
        return this.sourceConnectionEnabled;
    }

    public void sourceConnectionEnabled_$eq(boolean x$1) {
        this.sourceConnectionEnabled = x$1;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public AtomicReference<Level> maxLogLevel() {
        return this.maxLogLevel;
    }

    @Override
    public void startup() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cluster link connection manager has started up.");
            if (!Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
                this.isActive_$eq(true);
                this.updateActiveLinkCount();
            } else {
                this.isActive_$eq(false);
            }
            this.resetReverseConnectionAdmin();
            return;
        }
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Reconfiguring link connection manager with new configs updated=").append(updatedKeys).append(" newConfig=").append(newConfig.values()).toString());
            this.clusterLinkConfig_$eq(newConfig);
            if (Predef$.MODULE$.Boolean2boolean(newConfig.clusterLinkPaused())) {
                if (this.isActive()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down cluster link connection manager because link has been paused");
                }
                this.shutdown();
            } else {
                this.isActive_$eq(true);
                this.resetReverseConnectionAdmin();
            }
            this.updateActiveLinkCount();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed reconfiguration of cluster link");
            return;
        }
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        if (isAvailable) {
            this.maxLogLevel().set(null);
            return;
        }
        this.maxLogLevel().set(Level.DEBUG);
    }

    @Override
    public void shutdown() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.isActive_$eq(false);
            this.closeReverseConnectionAdmin();
            this.updateActiveLinkCount();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Shutdown of ClusterLinkConnectionManager with cluster link data ").append(this.linkData()).toString());
            return;
        }
    }

    @Override
    public boolean active() {
        return this.isActive();
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.clusterLinkConfig();
    }

    @Override
    public Seq<String> linkClusters() {
        return (Seq)new .colon.colon((Object)this.localLogicalCluster(), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.linkData().clusterId()).toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    public void ensureReverseConnectionsEnabled() {
        if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
            throw new ClusterLinkPausedException(new StringBuilder(36).append("Cluster link ").append(this.linkData().linkName()).append(" is not active,").append(" paused=").append(this.clusterLinkConfig().clusterLinkPaused()).toString());
        }
        if (!this.sourceConnectionEnabled()) {
            throw new InvalidRequestException(new StringBuilder(46).append("Cluster link '").append(this.linkData().linkName()).append("' is not a source initiated link").toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resetReverseConnectionAdmin() {
        var1_1 = this.stateChangeLock();
        synchronized (var1_1) {
            block7: {
                config = this.currentConfig();
                if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(config.clusterLinkPaused())) ** GOTO lbl-1000
                v0 = config.linkMode();
                var3_3 = LinkMode$Destination$.MODULE$;
                if (v0 != null ? v0.equals(var3_3) == false : var3_3 != null) break block7;
                v1 = config.connectionMode();
                var4_4 = ConnectionMode$Inbound$.MODULE$;
                if (!(v1 == null ? var4_4 != null : v1.equals(var4_4) == false)) ** GOTO lbl-1000
            }
            v2 = config.linkMode();
            var5_5 = LinkMode$Source$.MODULE$;
            if (!(v2 != null ? v2.equals(var5_5) == false : var5_5 != null)) {
                v3 = config.connectionMode();
                var6_6 = ConnectionMode$Outbound$.MODULE$;
                ** if (v3 != null ? v3.equals((Object)var6_6) == false : var6_6 != null) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v4 = true;
                ** GOTO lbl23
            }
lbl-1000:
            // 3 sources

            {
                v4 = false;
            }
lbl23:
            // 2 sources

            this.sourceConnectionEnabled_$eq(v4);
            this.closeReverseConnectionAdmin();
            if (this.sourceConnectionEnabled()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resetReverseConnectionAdmin$1(kafka.server.link.ClusterLinkConnectionManager ), ()Ljava/lang/String;)((ClusterLinkConnectionManager)this));
                this.createReverseConnectionAdmin();
            }
            return;
        }
    }

    public abstract void createReverseConnectionAdmin();

    public abstract void closeReverseConnectionAdmin();

    public void updateActiveLinkCount() {
        boolean count = this.isActive();
        this.metrics.activeLinkCountSensor().record((double)count);
    }

    public static final /* synthetic */ String $anonfun$resetReverseConnectionAdmin$1(ClusterLinkConnectionManager $this) {
        return new StringBuilder(62).append("Recreating reverse connection clients sourceConnectionEnabled=").append($this.sourceConnectionEnabled()).toString();
    }

    public ClusterLinkConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, ClusterLinkMetrics metrics) {
        this.linkData = linkData;
        this.localLogicalCluster = localLogicalCluster;
        this.metrics = metrics;
        ClusterLinkFactory.ConnectionManager.$init$(this);
        Logging.$init$(this);
        this.linkId = new Uuid(linkData.linkId().getMostSignificantBits(), linkData.linkId().getLeastSignificantBits());
        this.stateChangeLock = new Object();
        this.clusterLinkConfig = initialConfig;
        this.sourceConnectionEnabled = false;
        this.isActive = true;
        this.maxLogLevel = new AtomicReference();
    }
}

