/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFailed;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkStopMirrorTopic;
import kafka.server.link.ClusterLinkStopMirrorTopic$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\t\u0012\u0001aA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006c\u0001!\tA\r\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0011\u001dQ\u0004\u00011A\u0005\nmBa!\u0011\u0001!B\u00139\u0004b\u0002$\u0001\u0001\u0004%Ia\u0012\u0005\b'\u0002\u0001\r\u0011\"\u0003U\u0011\u00191\u0006\u0001)Q\u0005\u0011\")q\u000b\u0001C\u00011\")\u0011\f\u0001C\u00011\")!\f\u0001C!7\")a\u000e\u0001C!_\")\u0001\u0010\u0001C\u0005s\")1\u0010\u0001C\u0005y\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M!!H\"mkN$XM\u001d'j].\u001cuN\u001c;s_2dWM\u001d'jgR,g.\u001a:\u000b\u0005I\u0019\u0012\u0001\u00027j].T!\u0001F\u000b\u0002\rM,'O^3s\u0015\u00051\u0012!B6bM.\f7\u0001A\n\u0005\u0001eyr\u0005\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0011r!!\t\u0012\u000e\u0003EI!aI\t\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u0003K\u0019\u0012QdQ8oiJ|G\u000e\\3s\u0019&t7.\u001a3U_BL7\rT5ti\u0016tWM\u001d\u0006\u0003GE\u0001\"\u0001K\u0016\u000e\u0003%R!AK\u000b\u0002\u000bU$\u0018\u000e\\:\n\u00051J#a\u0002'pO\u001eLgnZ\u0001\b[\u0006t\u0017mZ3s!\t\ts&\u0003\u00021#\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u0003\u0019a\u0014N\\5u}Q\u00111\u0007\u000e\t\u0003C\u0001AQ!\f\u0002A\u00029\n1\"\u001b8ji&\fG.\u001b>fIV\tq\u0007\u0005\u0002\u001bq%\u0011\u0011h\u0007\u0002\b\u0005>|G.Z1o\u0003=Ig.\u001b;jC2L'0\u001a3`I\u0015\fHC\u0001\u001f@!\tQR(\u0003\u0002?7\t!QK\\5u\u0011\u001d\u0001E!!AA\u0002]\n1\u0001\u001f\u00132\u00031Ig.\u001b;jC2L'0\u001a3!Q\t)1\t\u0005\u0002\u001b\t&\u0011Qi\u0007\u0002\tm>d\u0017\r^5mK\u0006Y1\u000f^1siV\u0004xk\u001c:l+\u0005A\u0005cA%O!6\t!J\u0003\u0002L\u0019\u00069Q.\u001e;bE2,'BA'\u001c\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f*\u0013aAQ;gM\u0016\u0014\bc\u0001\u000eRy%\u0011!k\u0007\u0002\n\rVt7\r^5p]B\nqb\u001d;beR,\boV8sW~#S-\u001d\u000b\u0003yUCq\u0001Q\u0004\u0002\u0002\u0003\u0007\u0001*\u0001\u0007ti\u0006\u0014H/\u001e9X_J\\\u0007%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003q\n\u0001b\u001d5vi\u0012|wO\\\u0001\f_:\u001cF/\u0019;f\u0013:LG\u000fF\u0002=9&DQ!X\u0006A\u0002y\u000bQ\u0001^8qS\u000e\u0004\"a\u00184\u000f\u0005\u0001$\u0007CA1\u001c\u001b\u0005\u0011'BA2\u0018\u0003\u0019a$o\\8u}%\u0011QmG\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f7!)!n\u0003a\u0001W\u0006)1\u000f^1uKB\u0011\u0011\u0005\\\u0005\u0003[F\u0011Qc\u00117vgR,'\u000fT5oWR{\u0007/[2Ti\u0006$X-A\u0007p]N#\u0018\r^3DQ\u0006tw-\u001a\u000b\u0005yA\fh\u000fC\u0003^\u0019\u0001\u0007a\fC\u0003s\u0019\u0001\u00071/\u0001\u0005pY\u0012\u001cF/\u0019;f!\rQBo[\u0005\u0003kn\u0011aa\u00149uS>t\u0007\"B<\r\u0001\u0004\u0019\u0018\u0001\u00038foN#\u0018\r^3\u0002!%\u001c\b+\u001a8eS:<7\u000b^8qa\u0016$GCA\u001c{\u0011\u0015QW\u00021\u0001l\u0003Y\u0011XO\\*u_Bl\u0015N\u001d:peR{\u0007/[2UCN\\Gc\u0001\u001f~}\")QL\u0004a\u0001=\"1qP\u0004a\u0001\u0003\u0003\ta\u0001\\5oW&#\u0007\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0005kRLGN\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!!\u0002\u0003\tU+\u0016\nR\u0001\t[\u0006L(-\u001a*v]R\u0019A(!\u0006\t\r\u0005]q\u00021\u0001Q\u0003\u00119xN]6")
public class ClusterLinkControllerListener
implements ClusterLinkFactory.ControllerLinkedTopicListener,
Logging {
    private final ClusterLinkManager manager;
    private volatile boolean initialized;
    private Buffer<Function0<BoxedUnit>> startupWork;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private Buffer<Function0<BoxedUnit>> startupWork() {
        return this.startupWork;
    }

    private void startupWork_$eq(Buffer<Function0<BoxedUnit>> x$1) {
        this.startupWork = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void startup() {
        Buffer buffer;
        synchronized (this) {
            Buffer buffer2;
            if (this.initialized()) {
                buffer2 = (Buffer)Buffer$.MODULE$.empty();
            } else {
                void var2_1;
                this.initialized_$eq(true);
                Buffer<Function0<BoxedUnit>> tmp = this.startupWork();
                this.startupWork_$eq(null);
                buffer2 = var2_1;
            }
            buffer = buffer2;
        }
        buffer.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.initialized_$eq(false);
    }

    @Override
    public void onStateInit(String topic, ClusterLinkTopicState state) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("See controller cluster link topic state initialization for '").append(topic).append("': ").append(state).toString());
        if (this.isPendingStopped(state)) {
            this.runStopMirrorTopicTask(topic, state.linkId());
        }
    }

    @Override
    public void onStateChange(String topic, Option<ClusterLinkTopicState> oldState, Option<ClusterLinkTopicState> newState) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("See controller cluster link topic state change for '").append(topic).append("': ").append(oldState).append(" -> ").append(newState).toString());
        if (oldState.forall((Function1 & Serializable & scala.Serializable)os -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControllerListener.$anonfun$onStateChange$2(this, os))) && newState.exists((Function1 & Serializable & scala.Serializable)ns -> BoxesRunTime.boxToBoolean((boolean)this.isPendingStopped(ns)))) {
            this.runStopMirrorTopicTask(topic, ((ClusterLinkTopicState)newState.get()).linkId());
        }
    }

    private boolean isPendingStopped(ClusterLinkTopicState state) {
        return state instanceof ClusterLinkTopicState.PendingStoppedMirror;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runStopMirrorTopicTask(String topic, UUID linkId) {
        Option<ClusterLinkFactory.ClientManager> option = this.manager.clientManager(linkId);
        if (option instanceof Some) {
            ClusterLinkFactory.ClientManager clientManager = (ClusterLinkFactory.ClientManager)((Some)option).value();
            if (clientManager instanceof ClusterLinkClientManager) {
                boolean bl;
                ClusterLinkClientManager clusterLinkClientManager = (ClusterLinkClientManager)clientManager;
                ClusterLinkStopMirrorTopic task = new ClusterLinkStopMirrorTopic(topic, clusterLinkClientManager, (Function0<ConfluentAdmin>)(Function0 & Serializable & scala.Serializable)() -> (ConfluentAdmin)clusterLinkClientManager.destAdminFactory().apply(), ClusterLinkStopMirrorTopic$.MODULE$.$lessinit$greater$default$4(), ClusterLinkStopMirrorTopic$.MODULE$.$lessinit$greater$default$5());
                JFunction0.mcV.sp & Serializable & scala.Serializable maybeRun_work = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> task.startup();
                if (this.initialized()) {
                    bl = true;
                } else {
                    synchronized (this) {
                        if (!this.initialized()) {
                            Option$.MODULE$.apply(this.startupWork()).foreach(arg_0 -> ClusterLinkControllerListener.$anonfun$maybeRun$1((Function0)maybeRun_work, arg_0));
                            return;
                        }
                        boolean bl2 = true;
                        boolean bl3 = bl2;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 6, 7] lbl18 : MonitorExitStatement: MONITOREXIT : this
                        bl = bl3;
                    }
                }
                if (!bl) return;
                task.startup();
                return;
            }
            if (!(clientManager instanceof ClusterLinkFailed.ClientManager)) throw new IllegalStateException(new StringBuilder(28).append("Unhandled link manager type ").append(clientManager).toString());
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Cannot start 'stop topic mirror' task, cluster link '").append(linkId).append("' is in a failed state").toString());
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Unable to resolve client manager for link ID '").append(linkId).append("', may be due to cluster link deletion race").toString());
    }

    private void maybeRun(Function0<BoxedUnit> work) {
        boolean bl;
        if (this.initialized()) {
            bl = true;
        } else {
            synchronized (this) {
                boolean bl2;
                if (this.initialized()) {
                    bl2 = true;
                } else {
                    Option$.MODULE$.apply(this.startupWork()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.$plus$eq((Object)work));
                    bl2 = false;
                }
                boolean bl3 = bl2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl12 : MonitorExitStatement: MONITOREXIT : this
                bl = bl3;
            }
        }
        if (bl) {
            work.apply$mcV$sp();
        }
    }

    public static final /* synthetic */ void $anonfun$startup$1(Function0 x$1) {
        x$1.apply$mcV$sp();
    }

    public static final /* synthetic */ boolean $anonfun$onStateChange$2(ClusterLinkControllerListener $this, ClusterLinkTopicState os) {
        return !$this.isPendingStopped(os);
    }

    public ClusterLinkControllerListener(ClusterLinkManager manager) {
        this.manager = manager;
        Logging.$init$(this);
        this.initialized = false;
        this.startupWork = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

