/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kafka.api.ApiVersion$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode$Combined$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager$;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFetcherThread$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.EpochUpdateState;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.FetchState;
import kafka.server.link.MetadataListener;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$IllegalState$;
import kafka.server.link.MirrorFailureType$NoSourceRecords$;
import kafka.server.link.MirrorFailureType$SourceTopicDeleted$;
import kafka.server.link.MirrorFailureType$SourceTopicUnavailable$;
import kafka.server.link.MirrorFailureType$TopicAuthorizationFailed$;
import kafka.server.link.PartitionAndState;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011-a\u0001\u0002%J\u0001AC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tc\u0002\u0011\t\u0011)A\u0005e\"A!\u0010\u0001B\u0001B\u0003%1\u0010\u0003\u0005\u007f\u0001\t\u0005\t\u0015!\u0003\u0000\u0011)\t)\u0001\u0001B\u0001B\u0003%\u0011q\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0001BCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005e\u0002A!A!\u0002\u0013\tY\u0004\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003\u0007B!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA&\u0011)\t\u0019\u0006\u0001B\u0001B\u0003%\u0011Q\u000b\u0005\u000b\u0003K\u0002!\u0011!Q\u0001\n\u0005-\u0003bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\n\u0003\u000f\u0003!\u0019!C\u0005\u0003\u0013C\u0001\"!*\u0001A\u0003%\u00111\u0012\u0005\n\u0003O\u0003!\u0019!C\u0005\u0003SC\u0001\"a/\u0001A\u0003%\u00111\u0016\u0005\u000b\u0003{\u0003!\u0019!C\u0001\u0013\u0006}\u0006\u0002CAe\u0001\u0001\u0006I!!1\t\u0013\u0005-\u0007A1A\u0005\n\u00055\u0007\u0002CAk\u0001\u0001\u0006I!a4\t\u0017\u0005]\u0007\u00011AA\u0002\u0013%\u0011\u0011\u001c\u0005\f\u0003C\u0004\u0001\u0019!a\u0001\n\u0013\t\u0019\u000fC\u0006\u0002p\u0002\u0001\r\u0011!Q!\n\u0005m\u0007bCA}\u0001\u0001\u0007\t\u0019!C\u0005\u0003wD1Ba\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0006!Y!\u0011\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA\u007f\u0011%\u0011i\u0001\u0001a\u0001\n\u0013\u0011y\u0001C\u0005\u0003\u0012\u0001\u0001\r\u0011\"\u0003\u0003\u0014!9!q\u0003\u0001!B\u0013Y\bb\u0002B\u000e\u0001\u0011\u0005!Q\u0004\u0005\t\u0005?\u0001A\u0011A%\u0003\"!9!1\u0005\u0001\u0005\u0002\tu\u0001\u0002\u0003B\u0013\u0001\u0011\u0005\u0011J!\b\t\u0011\t\u001d\u0002\u0001\"\u0001J\u0005SA\u0001B!\u000f\u0001\t\u0003J%1\b\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005;AqAa\u001b\u0001\t\u0003\u0012i\u0007C\u0004\u0003z\u0001!\tEa\u001f\t\u000f\tM\u0005\u0001\"\u0003\u0003\u001e!9!Q\u0013\u0001\u0005\n\t]\u0005\u0002\u0003Bb\u0001\u0011\u0005\u0011J!2\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"A!\u0011 \u0001\u0005\u0002%\u0013Y\u0010\u0003\u0005\u0004\u000e\u0001!\t!SB\b\u0011!\u0019I\u0002\u0001C!\u0013\u000em\u0001bBB\u0010\u0001\u0011%!Q\u0004\u0005\b\u0007C\u0001A\u0011AAg\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0005\u001fA\u0001b!\n\u0001\t\u0003I\u0015\u0011\u001c\u0005\t\u0007O\u0001A\u0011A%\u0004*!Q1\u0011\t\u0001\u0012\u0002\u0013\u0005\u0011ja\u0011\t\u000f\re\u0003\u0001\"\u0003\u0004\\!A11\r\u0001\u0005\u0002%\u001b)\u0007\u0003\u0006\u0004v\u0001\t\n\u0011\"\u0001J\u0007\u0007B\u0001Ba>\u0001\t\u0003I5q\u000f\u0005\b\u0007{\u0002A\u0011\u0002B\u000f\u0011\u001d\u0019y\b\u0001C\u0001\u0007\u0003Cqaa\"\u0001\t\u0013\u0019I\tC\u0004\u0004\u0014\u0002!\tb!&\t\u000f\re\u0005\u0001\"\u0001\u0004\u001c\"91\u0011\u0016\u0001\u0005\u0002\r-\u0006bBBu\u0001\u0011\u000511\u001e\u0005\b\u0007[\u0004A\u0011IBx\u0011\u001d\u0019i\u000f\u0001C\u0001\u0007c<\u0011ba>J\u0003\u0003E\ta!?\u0007\u0011!K\u0015\u0011!E\u0001\u0007wDq!a\u001aF\t\u0003!\u0019\u0001C\u0005\u0005\u0006\u0015\u000b\n\u0011\"\u0001\u0005\b\tI2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s\u0015\tQ5*\u0001\u0003mS:\\'B\u0001'N\u0003\u0019\u0019XM\u001d<fe*\ta*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\t\u0016\f\u0019\t\u0004%N+V\"A&\n\u0005Q[%AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0011\u0005Y;V\"A%\n\u0005aK%\u0001G\"mkN$XM\u001d'j].4U\r^2iKJ$\u0006N]3bIB\u0011!,\u0018\b\u0003-nK!\u0001X%\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u0003=~\u0013aBR3uG\",'/T1oC\u001e,'O\u0003\u0002]\u0013B\u0011a+Y\u0005\u0003E&\u0013\u0001#T3uC\u0012\fG/\u0019'jgR,g.\u001a:\u0002\u00111Lgn\u001b(b[\u0016\u0004\"!\u001a8\u000f\u0005\u0019d\u0007CA4k\u001b\u0005A'BA5P\u0003\u0019a$o\\8u})\t1.A\u0003tG\u0006d\u0017-\u0003\u0002nU\u00061\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti'.\u0001\u0004mS:\\\u0017\n\u001a\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA!\u001e;jY*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0011)V+\u0013#\u0002\u001b%t\u0017\u000e^5bY\u000e{gNZ5h!\t1F0\u0003\u0002~\u0013\n\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\t\u0004-\u0006\u0005\u0011bAA\u0002\u0013\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u0003U!Wm\u001d;D_:tWm\u0019;j_:l\u0015M\\1hKJ\u00042AVA\u0005\u0013\r\tY!\u0013\u0002!\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000e{gN\\3di&|g.T1oC\u001e,'/\u0001\u0007ce>\\WM]\"p]\u001aLw\rE\u0002S\u0003#I1!a\u0005L\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0019!+!\u0007\n\u0007\u0005m1J\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001f\u0011,7\u000f^!e[&t7\t\\5f]R\u0004B!!\t\u000265\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0003bI6LgN\u0003\u0003\u0002*\u0005-\u0012aB2mS\u0016tGo\u001d\u0006\u0004\u001d\u00065\"\u0002BA\u0018\u0003c\ta!\u00199bG\",'BAA\u001a\u0003\ry'oZ\u0005\u0005\u0003o\t\u0019CA\u0003BI6Lg.A\u0003rk>$\u0018\rE\u0002S\u0003{I1!a\u0010L\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003\u001diW\r\u001e:jGN\u00042AVA#\u0013\r\t9%\u0013\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0004uK:\fg\u000e\u001e\t\u0006\u0003\u001b\ny\u0005Z\u0007\u0002U&\u0019\u0011\u0011\u000b6\u0003\r=\u0003H/[8o\u0003\u0011!\u0018.\\3\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005)Q\u000f^5mg*!\u0011qLA\u0016\u0003\u0019\u0019w.\\7p]&!\u00111MA-\u0005\u0011!\u0016.\\3\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\u0018A\u0002\u001fj]&$h\b\u0006\u000f\u0002l\u00055\u0014qNA9\u0003g\n)(a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0011\u0005Y\u0003\u0001\"B2\u000f\u0001\u0004!\u0007\"B9\u000f\u0001\u0004\u0011\b\"\u0002>\u000f\u0001\u0004Y\b\"\u0002@\u000f\u0001\u0004y\bbBA\u0003\u001d\u0001\u0007\u0011q\u0001\u0005\b\u0003\u001bq\u0001\u0019AA\b\u0011\u001d\t)B\u0004a\u0001\u0003/Aq!!\b\u000f\u0001\u0004\ty\u0002C\u0004\u0002:9\u0001\r!a\u000f\t\u000f\u0005\u0005c\u00021\u0001\u0002D!9\u0011\u0011\n\bA\u0002\u0005-\u0003bBA*\u001d\u0001\u0007\u0011Q\u000b\u0005\n\u0003Kr\u0001\u0013!a\u0001\u0003\u0017\n\u0001\u0003\\5oW\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005-\u0005\u0003CAG\u0003'\u000b9*a(\u000e\u0005\u0005=%bAAIi\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u0015q\u0012\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BAM\u00037k!!!\u0018\n\t\u0005u\u0015Q\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\r1\u0016\u0011U\u0005\u0004\u0003GK%!\u0005)beRLG/[8o\u0003:$7\u000b^1uK\u0006\tB.\u001b8lK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002)Ut\u0017m]:jO:,G\rU1si&$\u0018n\u001c8t+\t\tY\u000b\u0005\u0004\u0002.\u0006]\u0016qS\u0007\u0003\u0003_SA!!-\u00024\u00069Q.\u001e;bE2,'bAA[U\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0016q\u0016\u0002\u0004'\u0016$\u0018!F;oCN\u001c\u0018n\u001a8fIB\u000b'\u000f^5uS>t7\u000fI\u0001\u0012o\u0006LG/\u001b8h!\u0006\u0014H/\u001b;j_:\u001cXCAAa!!\ti)a%\u0002\u0018\u0006\r\u0007\u0003BA'\u0003\u000bL1!a2k\u0005\u0011auN\\4\u0002%]\f\u0017\u000e^5oOB\u000b'\u000f^5uS>t7\u000fI\u0001+SN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e\u001f:dunY1m\u00072,8\u000f^3s+\t\ty\r\u0005\u0003\u0002N\u0005E\u0017bAAjU\n9!i\\8mK\u0006t\u0017aK5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\rZ(o\u0019>\u001c\u0017\r\\\"mkN$XM\u001d\u0011\u0002\u00115,G/\u00193bi\u0006,\"!a7\u0011\u0007Y\u000bi.C\u0002\u0002`&\u00131c\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006\fA\"\\3uC\u0012\fG/Y0%KF$B!!:\u0002lB!\u0011QJAt\u0013\r\tIO\u001b\u0002\u0005+:LG\u000fC\u0005\u0002nb\t\t\u00111\u0001\u0002\\\u0006\u0019\u0001\u0010J\u0019\u0002\u00135,G/\u00193bi\u0006\u0004\u0003fA\r\u0002tB!\u0011QJA{\u0013\r\t9P\u001b\u0002\tm>d\u0017\r^5mK\u0006)R.\u001a;bI\u0006$\u0018MU3ge\u0016\u001c\b\u000e\u00165sK\u0006$WCAA\u007f!\r1\u0016q`\u0005\u0004\u0005\u0003I%!G\"mkN$XM\u001d'j].lU\r^1eCR\fG\u000b\u001b:fC\u0012\f\u0011$\\3uC\u0012\fG/\u0019*fMJ,7\u000f\u001b+ie\u0016\fGm\u0018\u0013fcR!\u0011Q\u001dB\u0004\u0011%\tioGA\u0001\u0002\u0004\ti0\u0001\fnKR\fG-\u0019;b%\u00164'/Z:i)\"\u0014X-\u00193!Q\ra\u00121_\u0001\u0012G2,8\u000f^3s\u0019&t7nQ8oM&<W#A>\u0002+\rdWo\u001d;fe2Kgn[\"p]\u001aLwm\u0018\u0013fcR!\u0011Q\u001dB\u000b\u0011!\tiOHA\u0001\u0002\u0004Y\u0018AE2mkN$XM\u001d'j].\u001cuN\u001c4jO\u0002B3aHAz\u0003\u001d\u0019H/\u0019:ukB$\"!!:\u0002\u0011%\u001c\u0018i\u0019;jm\u0016$\"!a4\u0002%%t\u0017\u000e^5bY&TX-T3uC\u0012\fG/Y\u0001\u0014gR\f'\u000f^'fi\u0006$\u0017\r^1UQJ,\u0017\rZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002f\n-\"q\u0006\u0005\u0007\u0005[!\u0003\u0019A>\u0002\u00139,woQ8oM&<\u0007b\u0002B\u0019I\u0001\u0007!1G\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000fE\u0003\u00036\t]B-\u0004\u0002\u00024&!\u0011\u0011XAZ\u0003Qyg.\u0011<bS2\f'-\u001b7jif\u001c\u0005.\u00198hKR!\u0011Q\u001dB\u001f\u0011\u001d\u0011y$\na\u0001\u0003\u001f\f1\"[:Bm\u0006LG.\u00192mK\u0006\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIR9QK!\u0012\u0003P\t}\u0003b\u0002B$M\u0001\u0007!\u0011J\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004B!!\u0014\u0003L%\u0019!Q\n6\u0003\u0007%sG\u000fC\u0004\u0003R\u0019\u0002\rAa\u0015\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\t\tU#1L\u0007\u0003\u0005/R1A!\u0017N\u0003\u001d\u0019G.^:uKJLAA!\u0018\u0003X\tq!I]8lKJ,e\u000e\u001a)pS:$\bb\u0002B1M\u0001\u0007!1M\u0001\fM\u0016$8\r[3s!>|G\u000eE\u0002S\u0005KJ1Aa\u001aL\u0005-1U\r^2iKJ\u0004vn\u001c7\u0002\u0011MDW\u000f\u001e3po:\fQb\u001c8OK^lU\r^1eCR\fG\u0003BAs\u0005_BqA!\u001d)\u0001\u0004\u0011\u0019(\u0001\u0006oK^\u001cE.^:uKJ\u0004B!!'\u0003v%!!qOA/\u0005\u001d\u0019E.^:uKJ\f\u0011c\u001c8NKR\fG-\u0019;b\r\u0006LG.\u001e:f)\u0011\t)O! \t\u000f\t}\u0014\u00061\u0001\u0003\u0002\u0006IQ\r_2faRLwN\u001c\t\u0005\u0005\u0007\u0013iI\u0004\u0003\u0003\u0006\n%ebA4\u0003\b&\t1.C\u0002\u0003\f*\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0010\nE%!C#yG\u0016\u0004H/[8o\u0015\r\u0011YI[\u0001\u001aa>\u0004X\u000f\\1uK\u001a+Go\u00195feB\u000b'\u000f^5uS>t7/\u0001\u0010nCf\u0014W\rS1oI2,Gk\\8NC:LX\t]8dQV\u0003H-\u0019;fgRA\u0011q\u001aBM\u0005;\u0013\t\u000bC\u0004\u0003\u001c.\u0002\r!a&\u0002\u0005Q\u0004\bb\u0002BPW\u0001\u0007\u0011qT\u0001\u0012a\u0006\u0014H/\u001b;j_:\fe\u000eZ*uCR,\u0007b\u0002BRW\u0001\u0007!QU\u0001\u0012]\u0016<H*Z1eKJ\fe\u000eZ#q_\u000eD\u0007\u0003\u0002BT\u0005{sAA!+\u0003::!!1\u0016B\\\u001d\u0011\u0011iK!.\u000f\t\t=&1\u0017\b\u0004O\nE\u0016BAA\u001a\u0013\u0011\ty#!\r\n\u00079\u000bi#\u0003\u0003\u0002*\u0005-\u0012\u0002\u0002B^\u0003O\t\u0001\"T3uC\u0012\fG/Y\u0005\u0005\u0005\u007f\u0013\tM\u0001\bMK\u0006$WM]!oI\u0016\u0003xn\u00195\u000b\t\tm\u0016qE\u0001\u0014Q\u0006tG\r\\3T_V\u00148-Z(gMN,Go\u001d\u000b\u0005\u0003K\u00149\rC\u0004\u0003J2\u0002\rAa3\u0002\u001b1\fG/Z:u\u001f\u001a47/\u001a;t!\u001d\u0019(QZAL\u0005#L1Aa4u\u0005\ri\u0015\r\u001d\t\u0005\u0005'\u0014IN\u0004\u0003\u0002\"\tU\u0017\u0002\u0002Bl\u0003G\t\u0011\u0003T5ti>3gm]3ugJ+7/\u001e7u\u0013\u0011\u0011YN!8\u0003+1K7\u000f^(gMN,Go\u001d*fgVdG/\u00138g_*!!q[A\u0012\u0003qyg\u000eT5oW\u0016$G*Z1eKJ,\u0006\u000fZ1uKJ+7\u000f]8og\u0016$BAa9\u0003vR!\u0011Q\u001dBs\u0011\u001d\u00119/\fa\u0001\u0005S\fQ!\u001a:s_J\u0004BAa;\u0003r6\u0011!Q\u001e\u0006\u0005\u0005_\fi&\u0001\u0005qe>$xnY8m\u0013\u0011\u0011\u0019P!<\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\u001190\fa\u0001\u0003/\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0002;\u0005$G\rT5oW\u0016$g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$B!!:\u0003~\"9!q \u0018A\u0002\r\u0005\u0011A\u00039beRLG/[8ogB1!1QB\u0002\u0007\u000fIAa!\u0002\u0003\u0012\nA\u0011\n^3sC\ndW\r\u0005\u0003\u0003V\r%\u0011\u0002BB\u0006\u0005/\u0012\u0011\u0002U1si&$\u0018n\u001c8\u0002AI,Wn\u001c<f\u0019&t7.\u001a3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003K\u001c\tb!\u0006\t\u000f\t}x\u00061\u0001\u0004\u0014A1!Q\u0007B\u001c\u0003/Cqaa\u00060\u0001\u0004\ty-\u0001\bsKR\f\u0017N\\'fi\u0006$\u0017\r^1\u000215\f\u0017PY3O_RLg-\u001f*fC\u0012Lhi\u001c:GKR\u001c\u0007\u000e\u0006\u0003\u0002f\u000eu\u0001b\u0002B|a\u0001\u00071qA\u0001\u0015kB$\u0017\r^3NKR\fG-\u0019;b)>\u0004\u0018nY:\u0002\u000f%\u001cX)\u001c9us\u0006i1-\u001e:sK:$8i\u001c8gS\u001e\fqbY;se\u0016tG/T3uC\u0012\fG/Y\u0001\u0017_:\u0004\u0016M\u001d;ji&|g\u000eT5oW\u001a\u000b\u0017\u000e\\;sKRQ\u0011qZB\u0016\u0007_\u0019Id!\u0010\t\u000f\r5R\u00071\u0001\u0002\u0018\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBB\u0019k\u0001\u000711G\u0001\fM\u0006LG.\u001e:f)f\u0004X\rE\u0002W\u0007kI1aa\u000eJ\u0005Ei\u0015N\u001d:pe\u001a\u000b\u0017\u000e\\;sKRK\b/\u001a\u0005\u0007\u0007w)\u0004\u0019\u00013\u0002\rI,\u0017m]8o\u0011%\u0019y$\u000eI\u0001\u0002\u0004\ty-\u0001\bnCf\u001cFo\u001c9GKR\u001c\u0007.\u001a:\u0002A=t\u0007+\u0019:uSRLwN\u001c'j].4\u0015-\u001b7ve\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007\u000bRC!a4\u0004H-\u00121\u0011\n\t\u0005\u0007\u0017\u001a)&\u0004\u0002\u0004N)!1qJB)\u0003%)hn\u00195fG.,GMC\u0002\u0004T)\f!\"\u00198o_R\fG/[8o\u0013\u0011\u00199f!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000ep]2Kgn\u001b$bS2,(/Z+qI\u0006$XMU3ta>t7/\u001a\u000b\u0005\u0007;\u001a\t\u0007\u0006\u0003\u0002f\u000e}\u0003b\u0002Bto\u0001\u0007!\u0011\u001e\u0005\b\u0005o<\u0004\u0019AAL\u0003e\u0019G.Z1s!\u0006\u0014H/\u001b;j_:d\u0015N\\6GC&dWO]3\u0015\u0011\u0005\u00158qMB5\u0007cBqa!\f9\u0001\u0004\t9\n\u0003\u0005\u0004<a\"\t\u0019AB6!\u0015\tie!\u001ce\u0013\r\u0019yG\u001b\u0002\ty\tLh.Y7f}!I11\u000f\u001d\u0011\u0002\u0003\u0007\u0011qZ\u0001\u000eQ\u0006\u001ch*Z<SK\u000e|'\u000fZ:\u0002G\rdW-\u0019:QCJ$\u0018\u000e^5p]2Kgn\u001b$bS2,(/\u001a\u0013eK\u001a\fW\u000f\u001c;%gQ!1\u0011PB>!\u0019\ti%a\u0014\u0004\b!9!1\u0014\u001eA\u0002\u0005]\u0015AF7bs\n,\u0017\t\u001a3MS:\\W\r\u001a$fi\u000eDWM]:\u0002\u0017\u001d,G\u000fV8qS\u000ed\u0015m\u001a\u000b\u0005\u0003\u0007\u001c\u0019\t\u0003\u0004\u0004\u0006r\u0002\r\u0001Z\u0001\u0006i>\u0004\u0018nY\u0001\u0015kB$\u0017\r^3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0015\t\u0005\u001581\u0012\u0005\b\u0007\u001bk\u0004\u0019ABH\u0003Q!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8ugB9!QGBII\n%\u0013\u0002\u0002Bh\u0003g\u000ba\u0002]1si&$\u0018n\u001c8D_VtG\u000f\u0006\u0003\u0003J\r]\u0005BBBC}\u0001\u0007A-A\rva\u0012\fG/\u001a)beRLG/[8o\r\u0016$8\r[*uCR,GCBAs\u0007;\u001by\nC\u0004\u0004.}\u0002\r!a&\t\u000f\r\u0005v\b1\u0001\u0004$\u0006Qa-\u001a;dQN#\u0018\r^3\u0011\u0007Y\u001b)+C\u0002\u0004(&\u0013!BR3uG\"\u001cF/\u0019;f\u0003Q\u0001\u0018M\u001d;ji&|g.T5se>\u00148\u000b^1uKRA1QVBb\u0007\u000b\u001c9\u000e\u0005\u0004\u0002N\u0005=3q\u0016\t\u0005\u0007c\u001biL\u0004\u0003\u00044\u000eeVBAB[\u0015\u0011\u00199,!\u0018\u0002\u000fI,\u0007\u000f\\5dC&!11XB[\u00035\u0011V\r\u001d7jG\u0006\u001cF/\u0019;vg&!1qXBa\u0005)i\u0015N\u001d:pe&sgm\u001c\u0006\u0005\u0007w\u001b)\fC\u0004\u0004.\u0001\u0003\r!a&\t\u000f\r\u001d\u0007\t1\u0001\u0004J\u0006)\u0002/\u001a:tSN$XM\u001c;NSJ\u0014xN]*uCR,\u0007\u0003BBf\u0007#tAa!-\u0004N&!1qZBa\u0003)i\u0015N\u001d:pe&sgm\\\u0005\u0005\u0007'\u001c)NA\u0003Ti\u0006$XM\u0003\u0003\u0004P\u000e\u0005\u0007bBBm\u0001\u0002\u000711\\\u0001\u001aY&t7.\u0011<bS2\f'-\u001b7jif,\u0005pY3qi&|g\u000e\u0005\u0004\u0002N\u0005=3Q\u001c\t\u0005\u0007?\u001c)/\u0004\u0002\u0004b*!11]A/\u0003\u0019)'O]8sg&!1q]Bq\u00051\t\u0005/[#yG\u0016\u0004H/[8o\u0003Qi\u0017N\u001d:peB\u000b'\u000f^5uS>t7i\\;oiR\u0011!\u0011J\u0001\u0013M\u0016$8\r[3s)\"\u0014X-\u00193D_VtG/\u0006\u0002\u0003JQ!!\u0011JBz\u0011\u001d\u0019)p\u0011a\u0001\u0005\u0013\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\u001a\u00072,8\u000f^3s\u0019&t7NR3uG\",'/T1oC\u001e,'\u000f\u0005\u0002W\u000bN\u0019Qi!@\u0011\t\u000553q`\u0005\u0004\t\u0003Q'AB!osJ+g\r\u0006\u0002\u0004z\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u001aTC\u0001C\u0005U\u0011\tYea\u0012")
public class ClusterLinkFetcherManager
extends AbstractFetcherManager<ClusterLinkFetcherThread>
implements ClusterLinkFactory.FetcherManager,
MetadataListener {
    private final String linkName;
    private final UUID linkId;
    private final ClusterLinkManager clusterLinkManager;
    private final ClusterLinkDestConnectionManager destConnectionManager;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Admin destAdminClient;
    private final ReplicaQuota quota;
    private final ClusterLinkMetrics metrics;
    private final Option<String> tenant;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ConcurrentHashMap<TopicPartition, PartitionAndState> linkedPartitions;
    private final scala.collection.mutable.Set<TopicPartition> unassignedPartitions;
    private final ConcurrentHashMap<TopicPartition, Object> waitingPartitions;
    private final boolean isTruncationOnFetchSupportedOnLocalCluster;
    private volatile ClusterLinkMetadata metadata;
    private volatile ClusterLinkMetadataThread metadataRefreshThread;
    private volatile ClusterLinkConfig clusterLinkConfig;

    public static Option<String> $lessinit$greater$default$13() {
        return ClusterLinkFetcherManager$.MODULE$.$lessinit$greater$default$13();
    }

    private ConcurrentHashMap<TopicPartition, PartitionAndState> linkedPartitions() {
        return this.linkedPartitions;
    }

    private scala.collection.mutable.Set<TopicPartition> unassignedPartitions() {
        return this.unassignedPartitions;
    }

    public ConcurrentHashMap<TopicPartition, Object> waitingPartitions() {
        return this.waitingPartitions;
    }

    private boolean isTruncationOnFetchSupportedOnLocalCluster() {
        return this.isTruncationOnFetchSupportedOnLocalCluster;
    }

    private ClusterLinkMetadata metadata() {
        return this.metadata;
    }

    private void metadata_$eq(ClusterLinkMetadata x$1) {
        this.metadata = x$1;
    }

    private ClusterLinkMetadataThread metadataRefreshThread() {
        return this.metadataRefreshThread;
    }

    private void metadataRefreshThread_$eq(ClusterLinkMetadataThread x$1) {
        this.metadataRefreshThread = x$1;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    @Override
    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Starting ClusterLinkFetcherManager for cluster link ").append($this.linkName).toString());
        this.initializeMetadata();
        if (this.isActive()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Starting fetcher manager metadata thread for cluster link ").append($this.linkName).toString());
            this.startMetadataThread();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Startup of ClusterLinkFetcherManager for cluster link ").append($this.linkName).append(" is complete").toString());
    }

    public boolean isActive() {
        return !Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused());
    }

    public void initializeMetadata() {
        ClusterLinkConfig config = this.clusterLinkConfig();
        this.metadata_$eq(new ClusterLinkMetadata(this.brokerConfig, this.linkName, this.linkId, config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs())));
        List addresses = ClientUtils.parseAndValidateAddresses(config.bootstrapServers(), (ClientDnsLookup)config.dnsLookup());
        this.metadata().bootstrap(addresses);
    }

    public void startMetadataThread() {
        this.metadataRefreshThread_$eq(new ClusterLinkMetadataThread(this.clusterLinkConfig(), (Option<ClusterLinkDestConnectionManager>)new Some((Object)this.destConnectionManager), this.metadata(), this.metrics.metrics(), this.time));
        this.metadataRefreshThread().addListener(this);
        this.metadataRefreshThread().start();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        block16: {
            if (this.isDebugEnabled()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$1(kafka.server.link.ClusterLinkFetcherManager ), ()Ljava/lang/String;)((ClusterLinkFetcherManager)this));
                this.fetcherThreadMap().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$reconfigure$2$adapted(kafka.server.link.ClusterLinkFetcherManager scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((ClusterLinkFetcherManager)this));
            }
            var3_3 = this.lock();
            synchronized (var3_3) {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    oldActive = this.isActive();
                                    this.clusterLinkConfig_$eq(newConfig);
                                    newActive = this.isActive();
                                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$4(kafka.server.link.ClusterLinkFetcherManager scala.collection.Set kafka.server.link.ClusterLinkConfig ), ()Ljava/lang/String;)((ClusterLinkFetcherManager)this, updatedKeys, (ClusterLinkConfig)newConfig));
                                    var6_6 = new Tuple2.mcZZ.sp(oldActive, newActive);
                                    if (oldActive || newActive) break block15;
                                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$5(), ()Ljava/lang/String;)());
                                    var11_7 = false;
                                    var10_8 = false;
                                    break block16;
                                }
                                if (oldActive || !newActive) break block17;
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$6(), ()Ljava/lang/String;)());
                                this.populateFetcherPartitions();
                                var11_7 = true;
                                var10_8 = false;
                                break block16;
                            }
                            if (!oldActive || newActive) break block18;
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$7(), ()Ljava/lang/String;)());
                            var11_7 = false;
                            var10_8 = true;
                            break block16;
                        }
                        if (!oldActive || !newActive || !updatedKeys.diff(ClusterLinkConfig$.MODULE$.PeriodicTaskProps()).isEmpty()) break block19;
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$8(), ()Ljava/lang/String;)());
                        var11_7 = false;
                        var10_8 = false;
                        break block16;
                    }
                    if (!oldActive || !newActive || !SslConfigs.RECONFIGURABLE_CONFIGS.containsAll((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(updatedKeys).asJava())) break block20;
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$9(scala.collection.Set ), ()Ljava/lang/String;)(updatedKeys));
                    newConfigValues = newConfig.values();
                    this.metadataRefreshThread().clusterLinkClient().validateReconfiguration(newConfigValues);
                    this.metadataRefreshThread().clusterLinkClient().reconfigure(newConfigValues);
                    ((IterableLike)this.fetcherThreadMap().values().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$reconfigure$10(kafka.server.link.ClusterLinkFetcherThread ), (Lkafka/server/link/ClusterLinkFetcherThread;)Lkafka/server/link/ClusterLinkNetworkClient;)(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$reconfigure$11$adapted(java.util.Map kafka.server.link.ClusterLinkNetworkClient ), (Lkafka/server/link/ClusterLinkNetworkClient;)Ljava/lang/Object;)((java.util.Map)newConfigValues));
                    var11_7 = false;
                    var10_8 = false;
                    break block16;
                }
                if (!oldActive || !newActive) ** GOTO lbl-1000
                v0 = updatedKeys;
                var8_10 = scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()}));
                if (!(v0 != null ? v0.equals((Object)var8_10) == false : var8_10 != null)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$12(kafka.server.link.ClusterLinkConfig ), ()Ljava/lang/String;)((ClusterLinkConfig)newConfig));
                    this.resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.numClusterLinkFetchers()));
                    var11_7 = false;
                    var10_8 = false;
                } else if (oldActive && newActive) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$reconfigure$13(scala.collection.Set ), ()Ljava/lang/String;)(updatedKeys));
                    this.clusterLinkConfig_$eq(newConfig);
                    var11_7 = true;
                    var10_8 = true;
                } else {
                    throw new MatchError((Object)var6_6);
                }
            }
        }
        if (var10_8) {
            this.metadataRefreshThread().shutdown();
            var9_11 = this.lock();
            synchronized (var9_11) {
                if (var11_7) {
                    this.populateFetcherPartitions();
                }
                this.closeAllFetchers();
            }
            if (!var11_7) {
                this.linkedPartitions().forEach((BiConsumer<TopicPartition, PartitionAndState>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, $anonfun$reconfigure$14(kafka.server.link.ClusterLinkFetcherManager org.apache.kafka.common.TopicPartition kafka.server.link.PartitionAndState ), (Lorg/apache/kafka/common/TopicPartition;Lkafka/server/link/PartitionAndState;)V)((ClusterLinkFetcherManager)this));
            }
        }
        if (var11_7) {
            this.initializeMetadata();
            this.updateMetadataTopics();
            this.startMetadataThread();
        }
        this.clusterLinkManager.updateDynamicFetchSize();
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processing link availability change to ").append(isAvailable).toString());
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (Predef$.MODULE$.Boolean2boolean(this.currentConfig().clusterLinkPaused())) {
                bl2 = false;
            } else if (!isAvailable) {
                this.populateFetcherPartitions();
                this.closeAllFetchers();
                bl2 = true;
            } else {
                this.metadata().requestUpdate();
                bl2 = false;
            }
            bl = bl2;
        }
        if (bl) {
            this.clusterLinkManager.updateDynamicFetchSize();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClusterLinkFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker, FetcherPool fetcherPool) {
        void apply_tenant;
        void apply_dynamicFetchSize;
        void apply_quota;
        void apply_replicaMgr;
        void apply_failedPartitions;
        void apply_time;
        void apply_clusterLinkMetrics;
        void apply_clusterLinkConfig;
        void apply_destConnectionManager;
        void apply_clusterLinkMetadata;
        void apply_brokerConfig;
        String prefix2 = (String)this.threadNamePrefix.map((Function1 & Serializable & scala.Serializable)prefix -> new StringBuilder(1).append((String)prefix).append(":").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String threadName = new StringBuilder(28).append(prefix2).append("ClusterLinkFetcherThread-").append(fetcherId).append("-").append(this.linkName).append("-").append(sourceBroker.id()).append("-").append(fetcherPool.name()).toString();
        Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> $this.clusterLinkManager.fetchResponseSize(this.clusterLinkConfig());
        Option<String> option = this.tenant;
        Time time = this.time;
        ClusterLinkMetrics clusterLinkMetrics = this.metrics;
        ReplicaQuota replicaQuota = this.quota;
        ReplicaManager replicaManager = this.replicaManager;
        FailedPartitions failedPartitions = this.failedPartitions();
        ClusterLinkDestConnectionManager clusterLinkDestConnectionManager = this.destConnectionManager;
        ClusterLinkMetadata clusterLinkMetadata = this.metadata();
        ClusterLinkConfig clusterLinkConfig = this.clusterLinkConfig();
        KafkaConfig kafkaConfig = this.brokerConfig;
        if (ClusterLinkFetcherThread$.MODULE$ == null) {
            throw null;
        }
        int apply_brokerId = apply_brokerConfig.brokerId();
        LogContext apply_logContext = new LogContext(new StringBuilder(68).append("[ClusterLinkFetcher brokerId=").append(apply_brokerId).append(" ").append("fetcherId=").append(fetcherId).append("] source(link=").append(apply_clusterLinkMetadata.linkName()).append(", leaderId=").append(sourceBroker.id()).append(")] ").toString(), apply_destConnectionManager.maxLogLevel());
        ClusterLinkNetworkClient apply_clusterLinkClient = new ClusterLinkNetworkClient((ClusterLinkConfig)apply_clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(apply_clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), apply_clusterLinkMetrics.metrics(), (Map<String, String>)ClusterLinkFactory$.MODULE$.linkMetricTags(apply_clusterLinkMetadata.linkName()).$plus$plus((GenTraversableOnce)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(sourceBroker.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(fetcherId))}))), (Time)apply_time, new StringBuilder(22).append("link-").append(apply_clusterLinkMetadata.linkName()).append("-broker-").append(apply_brokerId).append("-fetcher-").append(fetcherId).toString(), "fetcher", apply_logContext);
        apply_destConnectionManager.enableClusterLink(apply_clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        ReplicaFetcherBlockingSend apply_leaderEndpoint = new ReplicaFetcherBlockingSend(sourceBroker, (KafkaConfig)apply_brokerConfig, Predef$.MODULE$.Integer2int(apply_clusterLinkConfig.replicaSocketTimeoutMs()), (Time)apply_time, apply_clusterLinkClient.networkClient(), (Option<Reconfigurable>)None$.MODULE$);
        return new ClusterLinkFetcherThread(threadName, fetcherId, (KafkaConfig)apply_brokerConfig, (ClusterLinkConfig)apply_clusterLinkConfig, (ClusterLinkMetadata)apply_clusterLinkMetadata, this, sourceBroker, (FailedPartitions)apply_failedPartitions, (ReplicaManager)apply_replicaMgr, (ReplicaQuota)apply_quota, (ClusterLinkMetrics)apply_clusterLinkMetrics, (Time)apply_time, (Function0<FetchResponseSize>)apply_dynamicFetchSize, apply_clusterLinkClient, apply_leaderEndpoint, (Option<LogContext>)new Some((Object)apply_logContext), (Option<String>)apply_tenant);
    }

    @Override
    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Shutting down ClusterLinkFetcherManager for cluster link ").append($this.linkName).toString());
        this.closeAllFetchers();
        if (this.metadataRefreshThread() != null) {
            this.metadataRefreshThread().shutdown();
        }
        this.clusterLinkManager.updateDynamicFetchSize();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Shutdown of ClusterLinkFetcherManager for cluster link ").append($this.linkName).append(" is complete").toString());
    }

    @Override
    public void onNewMetadata(Cluster newCluster) {
        scala.collection.mutable.Map linkedEpochChanges = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map failedLinks = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = this.lock();
        synchronized (object) {
            scala.collection.mutable.Set updatedPartitions = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("onNewMetadata linkedPartitions ").append(this.linkedPartitions().keySet()).append(" unassigned ").append(this.unassignedPartitions()).append(" : ").append(newCluster).toString());
            scala.collection.mutable.Map updatedPartitionCounts = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            scala.collection.concurrent.Map linkedPartitions = (scala.collection.concurrent.Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.linkedPartitions()).asScala();
            linkedPartitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ClusterLinkFetcherManager.$anonfun$onNewMetadata$3(this, newCluster, updatedPartitionCounts, failedLinks, x0$1);
                return BoxedUnit.UNIT;
            });
            if (updatedPartitionCounts.nonEmpty()) {
                this.updatePartitionCount((Map<String, Object>)updatedPartitionCounts);
            }
            linkedPartitions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ClusterLinkFetcherManager.$anonfun$onNewMetadata$7(this, updatedPartitions, linkedEpochChanges, failedLinks, x0$2);
                return BoxedUnit.UNIT;
            });
            scala.collection.mutable.Set partitionsToReassign = (scala.collection.mutable.Set)updatedPartitions.diff(this.unassignedPartitions()).diff((GenSet)CollectionConverters$.MODULE$.asScalaSetConverter(this.waitingPartitions().keySet()).asScala());
            if (partitionsToReassign.nonEmpty()) {
                this.removeFetcherForPartitions((Set<TopicPartition>)partitionsToReassign);
                this.unassignedPartitions().$plus$plus$eq((TraversableOnce)partitionsToReassign);
            }
            this.maybeAddLinkedFetchers();
        }
        linkedEpochChanges.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ClusterLinkFetcherManager.$anonfun$onNewMetadata$10(this, x0$3);
            return BoxedUnit.UNIT;
        });
        if (failedLinks.count((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherManager.$anonfun$onNewMetadata$12(this, x0$4))) > 0) {
            this.metadata().requestUpdate();
        }
        this.clusterLinkManager.updateDynamicFetchSize();
    }

    @Override
    public void onMetadataFailure(Exception exception) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Processing metadata refresh failure ").append(exception).toString());
        MirrorFailureType$.MODULE$.failureType(exception).foreach((Function1 & Serializable & scala.Serializable)failureType -> {
            ClusterLinkFetcherManager.$anonfun$onMetadataFailure$2(this, failureType);
            return BoxedUnit.UNIT;
        });
    }

    private void populateFetcherPartitions() {
        ((ConcurrentHashMap.KeySetView)this.waitingPartitions().keySet()).forEach(elem -> this.unassignedPartitions().add(elem));
        this.waitingPartitions().clear();
        this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            ClusterLinkFetcherManager.$anonfun$populateFetcherPartitions$2(this, x$5);
            return BoxedUnit.UNIT;
        });
    }

    private boolean maybeHandleTooManyEpochUpdates(TopicPartition tp, PartitionAndState partitionAndState, Metadata.LeaderAndEpoch newLeaderAndEpoch) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            block8: {
                if (!partitionAndState.updateEpochState(newLeaderAndEpoch)) {
                    bl = this.waitingPartitions().containsKey(tp);
                    break block8;
                }
                int numUpdates = partitionAndState.lastEpochUpdateState().numEmptyEpochUpdates();
                if (numUpdates > MirrorFailureType$NoSourceRecords$.MODULE$.ConsecutiveEpochChangeUpperThreshold()) {
                    if (!this.waitingPartitions().containsKey(tp)) {
                        long logEndOffset = BoxesRunTime.unboxToLong((Object)this.replicaManager.onlinePartition(tp).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.log()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.logEndOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(200).append("Source epoch for mirror partition ").append(tp).append(" was updated ").append(numUpdates).append(" times without any new records, this may indicate ").append("circular mirror. Log end offset is ").append(logEndOffset).append(". Mirroring will be restarted when new source records are available.").toString());
                        this.waitingPartitions().put(tp, BoxesRunTime.boxToLong((long)logEndOffset));
                        this.unassignedPartitions().remove((Object)tp);
                        this.removeLinkedFetcherForPartitions((Set<TopicPartition>)((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), true);
                    }
                } else if (numUpdates > MirrorFailureType$NoSourceRecords$.MODULE$.ConsecutiveEpochChangeLowerThreshold()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Source epoch for mirror partition ").append(tp).append(" was updated ").append(numUpdates).append(" times without any new records.").toString());
                }
                boolean bl2 = this.waitingPartitions().containsKey(tp);
                return bl2;
            }
            return bl;
        }
    }

    public void handleSourceOffsets(java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> latestOffsets) {
        Object object = this.lock();
        synchronized (object) {
            BooleanRef hasReadyPartitions = BooleanRef.create((boolean)false);
            if (!Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
                latestOffsets.forEach((tp, offsetInfo) -> {
                    Option option = Option$.MODULE$.apply(this.waitingPartitions().get(tp));
                    if (option instanceof Some) {
                        long lastOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                        long currentOffset = offsetInfo.offset();
                        if (currentOffset >= 0L && (lastOffset < 0L || lastOffset > currentOffset)) {
                            this.waitingPartitions().put((TopicPartition)tp, BoxesRunTime.boxToLong((long)currentOffset));
                            return;
                        }
                        if (currentOffset > lastOffset) {
                            this.waitingPartitions().remove(tp);
                            Option$.MODULE$.apply((Object)this.linkedPartitions().get(tp)).foreach((Function1 & Serializable & scala.Serializable)partitionState -> {
                                ClusterLinkFetcherManager.$anonfun$handleSourceOffsets$2(this, tp, hasReadyPartitions, partitionState);
                                return BoxedUnit.UNIT;
                            });
                            return;
                        }
                    } else {
                        if (None$.MODULE$.equals(option)) {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition offsets not required any more, discarding");
                            return;
                        }
                        throw new MatchError((Object)option);
                    }
                });
                if (hasReadyPartitions.elem) {
                    this.metadata().requestUpdate();
                }
                return;
            }
            this.waitingPartitions().clear();
            return;
        }
    }

    private void onLinkedLeaderUpdateResponse(TopicPartition partition, Errors error) {
        boolean bl = Errors.OPERATION_NOT_ATTEMPTED.equals(error) ? true : (Errors.FENCED_LEADER_EPOCH.equals(error) ? true : Errors.INVALID_UPDATE_VERSION.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("We did not update cluster link state for ").append(partition).append(" since new metadata is available").toString());
            this.metadata().requestUpdate();
            return;
        }
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Linked leader update successful for ").append(partition).toString());
            return;
        }
        this.onPartitionLinkFailure(partition, MirrorFailureType$IllegalState$.MODULE$, new StringBuilder(51).append("Unexpected error in update of linked leader epoch: ").append(error).toString(), this.onPartitionLinkFailure$default$4());
    }

    @Override
    public void addLinkedFetcherForPartitions(Iterable<Partition> partitions) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("addLinkedFetcherForPartitions ").append(partitions).toString());
        Object object = this.lock();
        synchronized (object) {
            partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                ClusterLinkFetcherManager.$anonfun$addLinkedFetcherForPartitions$2(this, partition);
                return BoxedUnit.UNIT;
            });
            this.updateMetadataTopics();
            if (this.isActive()) {
                this.maybeAddLinkedFetchers();
            }
            return;
        }
    }

    @Override
    public void removeLinkedFetcherForPartitions(Set<TopicPartition> partitions, boolean retainMetadata) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("removeLinkedFetcherForPartitions ").append(partitions).append(" retainMetadata=").append(retainMetadata).toString());
        Object object = this.lock();
        synchronized (object) {
            this.removeFetcherForPartitions(partitions);
            if (!retainMetadata) {
                partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
                    this.unassignedPartitions().remove(tp);
                    this.waitingPartitions().remove(tp);
                    return this.linkedPartitions().remove(tp);
                });
            }
            this.updateMetadataTopics();
            if (retainMetadata) {
                this.metadata().requestUpdate();
            }
        }
        this.clusterLinkManager.updateDynamicFetchSize();
    }

    @Override
    public void maybeNotifyReadyForFetch(Partition partition) {
        Option option;
        Object object = this.lock();
        synchronized (object) {
            option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherManager.$anonfun$maybeNotifyReadyForFetch$1(partition, x$9)));
        }
        option.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.maybeNotifyReadyForFetch(partition);
            return BoxedUnit.UNIT;
        });
    }

    private void updateMetadataTopics() {
        this.metadata().setTopics((scala.collection.immutable.Set<String>)((TraversableOnce)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.linkedPartitions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.topic(), Set$.MODULE$.canBuildFrom())).toSet());
    }

    public boolean isEmpty() {
        Object object = this.lock();
        synchronized (object) {
            boolean bl = this.linkedPartitions().isEmpty();
            return bl;
        }
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.clusterLinkConfig();
    }

    public ClusterLinkMetadata currentMetadata() {
        return this.metadata();
    }

    public boolean onPartitionLinkFailure(TopicPartition topicPartition, MirrorFailureType failureType, String reason, boolean mayStopFetcher) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("onPartitionLinkFailure ").append(topicPartition).append(" failureType=").append(failureType).append(" reason=").append(reason).toString());
        PartitionAndState partitionAndState = this.linkedPartitions().get(topicPartition);
        if (Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Not processing cluster partition failure for ").append(topicPartition).append(" since link is paused").toString());
            return false;
        }
        if (partitionAndState != null && partitionAndState.partition().isActiveLinkDestinationLeader()) {
            long retryRemainingMs = partitionAndState.onLinkFailure(failureType, this.time.milliseconds(), this.clusterLinkConfig().retryTimeoutMs());
            if (retryRemainingMs <= 0L) {
                if (failureType.persistFailure()) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Mirroring of topic ").append(topicPartition.topic()).append(" stopped due to critical failure of partition ").append(topicPartition).append(" : ").append(reason).append(".").toString());
                    partitionAndState.partition().failClusterLink((Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                        this.onLinkFailureUpdateResponse(topicPartition, error);
                        return BoxedUnit.UNIT;
                    });
                } else if (mayStopFetcher) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Mirroring of topic ").append(topicPartition.topic()).append(" stopped due to failure of partition ").append(topicPartition).append(", mirroring will restart when issue is resolved : ").append(reason).append(".").toString());
                    this.removeLinkedFetcherForPartitions((Set<TopicPartition>)((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))), true);
                }
                return false;
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Cluster link failed due to: ").append(reason).append(", will retry for ").append(retryRemainingMs).append(" ms.").toString());
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Ignoring partition link failure since ").append(topicPartition).append(" is not an active link destination any more").toString());
        return false;
    }

    public boolean onPartitionLinkFailure$default$4() {
        return true;
    }

    private void onLinkFailureUpdateResponse(TopicPartition partition, Errors error) {
        boolean bl = Errors.OPERATION_NOT_ATTEMPTED.equals(error) ? true : (Errors.FENCED_LEADER_EPOCH.equals(error) ? true : Errors.INVALID_UPDATE_VERSION.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("We did not update cluster link failed state for ").append(partition).append(" since new metadata is available. Update will be retried on next failure.").toString());
            return;
        }
        if (Errors.NONE.equals(error)) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Link failed state was updated for ").append(partition).append(".").toString());
            return;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(this.msgWithLogIdent(ClusterLinkFetcherManager.$anonfun$onLinkFailureUpdateResponse$3(partition, error)));
            return;
        }
    }

    public void clearPartitionLinkFailure(TopicPartition topicPartition, Function0<String> reason, boolean hasNewRecords) {
        PartitionAndState partitionAndState = this.linkedPartitions().get(topicPartition);
        if (partitionAndState != null && partitionAndState.clearLinkFailure(hasNewRecords)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Clearing cluster link failure for partition ").append(topicPartition).append(" due to: ").append(reason.apply()).toString());
        }
    }

    public boolean clearPartitionLinkFailure$default$3() {
        return false;
    }

    public Option<Partition> partition(TopicPartition tp) {
        return Option$.MODULE$.apply((Object)this.linkedPartitions().get(tp)).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.partition());
    }

    private void maybeAddLinkedFetchers() {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.mutable.Map assignablePartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.unassignedPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
                ClusterLinkFetcherManager.$anonfun$maybeAddLinkedFetchers$1(this, assignablePartitions, tp);
                return BoxedUnit.UNIT;
            });
            this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)assignablePartitions, FetcherPool$Default$.MODULE$);
            assignablePartitions.keySet().foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherManager.$anonfun$maybeAddLinkedFetchers$3(this, elem)));
            if (this.unassignedPartitions().nonEmpty() || ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.linkedPartitions().keySet()).asScala()).exists((Function1 & Serializable & scala.Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherManager.$anonfun$maybeAddLinkedFetchers$4(this, topicPartition)))) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Request metadata due to unassigned partitions: ").append(this.unassignedPartitions()).toString());
                this.metadata().requestUpdate();
            }
            return;
        }
    }

    public long getTopicLag(String topic) {
        try {
            return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)ClusterLinkFetcherManager.$anonfun$getTopicLag$1(topic, BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Failed to mirror topic lag for ").append(topic).append(" ").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return -1L;
        }
    }

    private void updatePartitionCount(Map<String, Object> topicPartitionCounts) {
        java.util.Map newPartitions = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicPartitionCounts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            int v = x0$1._2$mcI$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)NewPartitions.increaseTo((int)v));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).asJava();
        this.destAdminClient.createPartitions(newPartitions).values().forEach((topic, future) -> future.whenComplete((x$13, e) -> {
            if (e == null) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Updated destination topic partition count for ").append((String)topic).append(" to ").append(topicPartitionCounts.apply(topic)).toString());
                return;
            }
            if (e instanceof InvalidPartitionsException) {
                Throwable throwable = e;
                String string = new StringBuilder(59).append("Could not update destination topic partition count for ").append((String)topic).append(" to ").append(topicPartitionCounts.apply(topic)).toString();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> x$14, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> x$15);
                return;
            }
            Throwable throwable = e;
            String string = new StringBuilder(59).append("Could not update destination topic partition count for ").append((String)topic).append(" to ").append(topicPartitionCounts.apply(topic)).toString();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> x$16, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> x$17);
        }));
    }

    public int partitionCount(String topic) {
        Seq<MetadataResponseData.MetadataResponseTopic> topicMetadata = this.replicaManager.metadataCache().getTopicMetadata((Set<String>)((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), this.brokerConfig.interBrokerListenerName(), this.replicaManager.metadataCache().getTopicMetadata$default$3(), this.replicaManager.metadataCache().getTopicMetadata$default$4());
        if (topicMetadata.isEmpty()) {
            return 0;
        }
        return ((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size();
    }

    public void updatePartitionFetchState(TopicPartition topicPartition, FetchState fetchState) {
        Option$.MODULE$.apply((Object)this.linkedPartitions().get(topicPartition)).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            x$18.fetchState_$eq((Option<FetchState>)new Some((Object)fetchState));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<ReplicaStatus.MirrorInfo> partitionMirrorState(TopicPartition topicPartition, ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<ApiException> linkAvailabilityException) {
        Option mirrorState = Option$.MODULE$.apply((Object)this.linkedPartitions().get(topicPartition)).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.mirrorState(persistentMirrorState, linkAvailabilityException));
        if (mirrorState.nonEmpty()) {
            return mirrorState;
        }
        ReplicaStatus.MirrorInfo.State state = persistentMirrorState;
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.ACTIVE;
        if (state == null ? state2 != null : !state.equals(state2)) {
            return new Some((Object)new ReplicaStatus.MirrorInfo(persistentMirrorState, -1L, -1L));
        }
        return None$.MODULE$;
    }

    public int mirrorPartitionCount() {
        return this.linkedPartitions().size();
    }

    @Override
    public int fetcherThreadCount() {
        return this.fetcherThreadMap().size();
    }

    public int fetcherThreadCount(int brokerId) {
        return this.fetcherThreadMap().keySet().count((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherManager.$anonfun$fetcherThreadCount$1(brokerId, x$20)));
    }

    public static final /* synthetic */ String $anonfun$reconfigure$1(ClusterLinkFetcherManager $this) {
        return new StringBuilder(22).append("Number of fetchers is ").append($this.fetcherThreadMap().size()).toString();
    }

    public static final /* synthetic */ void $anonfun$reconfigure$2(ClusterLinkFetcherManager $this, Tuple2 entry) {
        Set<TopicPartition> partitions = ((AbstractFetcherThread)entry._2()).partitions();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Fetcher ").append(((FetcherTag)entry._1()).fetcherId()).append(" to source broker ").append(((FetcherTag)entry._1()).brokerId()).append(" has ").append(partitions.size()).append(" ").append("partitions (").append(partitions.mkString(",")).append(")").toString());
    }

    public static final /* synthetic */ String $anonfun$reconfigure$4(ClusterLinkFetcherManager $this, Set updatedKeys$1, ClusterLinkConfig newConfig$1) {
        return new StringBuilder(56).append("Reconfiguring link ").append($this.linkName).append(" with new configs updated=").append(updatedKeys$1).append(" newConfig=").append(newConfig$1.values()).toString();
    }

    public static final /* synthetic */ String $anonfun$reconfigure$5() {
        return "Not reconfiguring fetcher manager since it's paused";
    }

    public static final /* synthetic */ String $anonfun$reconfigure$6() {
        return "Unpausing fetcher manager";
    }

    public static final /* synthetic */ String $anonfun$reconfigure$7() {
        return "Pausing fetcher manager";
    }

    public static final /* synthetic */ String $anonfun$reconfigure$8() {
        return "Not reconfiguring fetcher manager since replication configs haven't changed";
    }

    public static final /* synthetic */ String $anonfun$reconfigure$9(Set updatedKeys$1) {
        return new StringBuilder(58).append("Reconfiguring cluster link fetchers with updated configs: ").append(updatedKeys$1).toString();
    }

    public static final /* synthetic */ ClusterLinkNetworkClient $anonfun$reconfigure$10(ClusterLinkFetcherThread x$1) {
        return x$1.clusterLinkClient();
    }

    public static final /* synthetic */ String $anonfun$reconfigure$12(ClusterLinkConfig newConfig$1) {
        return new StringBuilder(51).append("Reconfiguring cluster link fetcher thread count to ").append(newConfig$1.numClusterLinkFetchers()).toString();
    }

    public static final /* synthetic */ String $anonfun$reconfigure$13(Set updatedKeys$1) {
        return new StringBuilder(55).append("Recreating cluster link fetchers with updated configs: ").append(updatedKeys$1).toString();
    }

    public static final /* synthetic */ void $anonfun$reconfigure$14(ClusterLinkFetcherManager $this, TopicPartition tp, PartitionAndState x$4) {
        $this.clearPartitionLinkFailure(tp, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping fetcher", $this.clearPartitionLinkFailure$default$3());
    }

    private final void addFailure$1(TopicPartition tp, MirrorFailureType failureType, String reason, scala.collection.mutable.Map failedLinks$1) {
        if (!failedLinks$1.contains((Object)tp)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Process metadata failure ").append(failureType).append(" for partition ").append(tp).append(" : ").append(reason).toString());
            failedLinks$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new Tuple2((Object)failureType, (Object)reason)));
        }
    }

    public static final /* synthetic */ String $anonfun$onNewMetadata$4(String topic$1) {
        return new StringBuilder(52).append("Partitions for linked destination topic ").append(topic$1).append(" are unknown").toString();
    }

    public static final /* synthetic */ String $anonfun$onNewMetadata$5(String topic$1, int destPartitionCount$1, Integer sourcePartitionCount$1) {
        return new StringBuilder(49).append("Increasing partitions for linked topic ").append(topic$1).append(" from ").append(destPartitionCount$1).append(" to ").append(sourcePartitionCount$1).toString();
    }

    public static final /* synthetic */ String $anonfun$onNewMetadata$6(String reason$2) {
        return new StringBuilder(103).append(reason$2).append(" This may be a transient issue or it could indicate that the source partition was").append(" deleted and recreated").toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$onNewMetadata$3(ClusterLinkFetcherManager $this, Cluster newCluster$1, scala.collection.mutable.Map updatedPartitionCounts$1, scala.collection.mutable.Map failedLinks$1, Tuple2 x0$1) {
        block14: {
            block11: {
                block13: {
                    block12: {
                        if (x0$1 == null) break block11;
                        tp = (TopicPartition)x0$1._1();
                        partitionAndState = (PartitionAndState)x0$1._2();
                        topic = tp.topic();
                        newTopicId = newCluster$1.topicId(topic);
                        expectedTopicId = partitionAndState.partition().getLinkedTopicId();
                        if (!newCluster$1.invalidTopics().contains(topic)) break block12;
                        $this.addFailure$1(tp, MirrorFailureType$IllegalState$.MODULE$, "Invalid topic", failedLinks$1);
                        break block13;
                    }
                    v0 = expectedTopicId;
                    var10_10 = Uuid.ZERO_UUID;
                    if (!(v0 == null ? var10_10 != null : v0.equals(var10_10) == false)) ** GOTO lbl-1000
                    v1 = newTopicId;
                    var11_11 = Uuid.ZERO_UUID;
                    if (!(v1 == null ? var11_11 != null : v1.equals(var11_11) == false)) ** GOTO lbl-1000
                    v2 = expectedTopicId;
                    if (v2 == null ? newTopicId != null : v2.equals(newTopicId) == false) {
                        $this.addFailure$1(tp, MirrorFailureType$SourceTopicDeleted$.MODULE$, new StringBuilder(86).append("Expected source topic id ").append(expectedTopicId).append(" for topic ").append(topic).append(", but got ").append(newTopicId).append(". Source topic was deleted and recreated").toString(), failedLinks$1);
                    } else if (newCluster$1.unauthorizedTopics().contains(topic)) {
                        $this.addFailure$1(tp, MirrorFailureType$TopicAuthorizationFailed$.MODULE$, "Topic authorization failed", failedLinks$1);
                    } else if (!newCluster$1.topics().contains(topic) && !newCluster$1.isBootstrapConfigured()) {
                        $this.addFailure$1(tp, MirrorFailureType$SourceTopicUnavailable$.MODULE$, new StringBuilder(30).append("Topic ").append(topic).append(" not present in metadata").toString(), failedLinks$1);
                    }
                }
                sourcePartitionCount = newCluster$1.partitionCountForTopic(topic);
                if (sourcePartitionCount != null) {
                    destPartitionCount = $this.partitionCount(topic);
                    if (destPartitionCount == 0) {
                        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$onNewMetadata$4(java.lang.String ), ()Ljava/lang/String;)((String)topic));
                        return;
                    }
                    if (destPartitionCount < Predef$.MODULE$.Integer2int(sourcePartitionCount)) {
                        if (tp.partition() == 0) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$onNewMetadata$5(java.lang.String int java.lang.Integer ), ()Ljava/lang/String;)((String)topic, (int)destPartitionCount, (Integer)sourcePartitionCount));
                            updatedPartitionCounts$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(sourcePartitionCount))));
                            $this.metrics.linkedTopicPartitionAdditionSensor().record();
                            return;
                        }
                    } else if (destPartitionCount > Predef$.MODULE$.Integer2int(sourcePartitionCount)) {
                        reason = new StringBuilder(64).append("Topic ").append(topic).append(" has ").append(destPartitionCount).append(" destination partitions, but only ").append(sourcePartitionCount).append(" source partitions.").toString();
                        $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$onNewMetadata$6(java.lang.String ), ()Ljava/lang/String;)((String)reason));
                        $this.addFailure$1(new TopicPartition(topic, 0), MirrorFailureType$SourceTopicUnavailable$.MODULE$, reason, failedLinks$1);
                        return;
                    }
                }
                break block14;
            }
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$onNewMetadata$7(ClusterLinkFetcherManager $this, scala.collection.mutable.Set updatedPartitions$1, scala.collection.mutable.Map linkedEpochChanges$1, scala.collection.mutable.Map failedLinks$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tp = (TopicPartition)x0$2._1();
            PartitionAndState partitionAndState = (PartitionAndState)x0$2._2();
            Partition partition = partitionAndState.partition();
            Metadata.LeaderAndEpoch oldLeaderAndEpoch = partitionAndState.sourceLeaderAndEpoch();
            Metadata.LeaderAndEpoch newLeaderAndEpoch = $this.metadata().currentLeader(tp);
            Metadata.LeaderAndEpoch leaderAndEpoch = oldLeaderAndEpoch;
            Metadata.LeaderAndEpoch leaderAndEpoch2 = Metadata.LeaderAndEpoch.noLeaderOrEpoch();
            if (leaderAndEpoch == null ? leaderAndEpoch2 != null : !leaderAndEpoch.equals(leaderAndEpoch2)) {
                Metadata.LeaderAndEpoch leaderAndEpoch3 = oldLeaderAndEpoch;
                if (leaderAndEpoch3 == null ? newLeaderAndEpoch != null : !leaderAndEpoch3.equals(newLeaderAndEpoch)) {
                    updatedPartitions$1.$plus$eq((Object)tp);
                }
            }
            Integer newEpoch = newLeaderAndEpoch.epoch.orElse(Predef$.MODULE$.int2Integer(-1));
            int oldEpoch = BoxesRunTime.unboxToInt((Object)partition.getLinkedLeaderEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            if (Predef$.MODULE$.Integer2int(newEpoch) >= 0 && oldEpoch < Predef$.MODULE$.Integer2int(newEpoch)) {
                partition.linkedLeaderOffsetsPending(!$this.isTruncationOnFetchSupportedOnLocalCluster());
                $this.metrics.linkedLeaderEpochChangeSensor().record();
                if (!$this.maybeHandleTooManyEpochUpdates(tp, partitionAndState, newLeaderAndEpoch)) {
                    updatedPartitions$1.$plus$eq((Object)tp);
                    linkedEpochChanges$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(newEpoch))));
                }
            }
            if (!failedLinks$1.contains((Object)tp) && newLeaderAndEpoch.leader.isPresent() && Predef$.MODULE$.Integer2int(newEpoch) >= 0) {
                if (oldEpoch > Predef$.MODULE$.Integer2int(newEpoch)) {
                    $this.addFailure$1(tp, MirrorFailureType$SourceTopicUnavailable$.MODULE$, new StringBuilder(41).append("Source epoch has gone backwards from ").append(oldEpoch).append(" to ").append(newEpoch).toString(), failedLinks$1);
                    return;
                }
                if (Predef$.MODULE$.Integer2int(newEpoch) >= oldEpoch && partitionAndState.clearLinkFailure(false)) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Clearing link failure for partition ").append(tp).append(" since newEpoch=").append(newEpoch).append(" is not less than oldEpoch=").append(oldEpoch).toString());
                    return;
                }
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$onNewMetadata$10(ClusterLinkFetcherManager $this, Tuple2 x0$3) {
        if (x0$3 != null) {
            Partition partition = (Partition)x0$3._1();
            int newEpoch = x0$3._2$mcI$sp();
            partition.updateLinkedLeaderEpoch(newEpoch, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                $this.onLinkedLeaderUpdateResponse(partition.topicPartition(), error);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$onNewMetadata$12(ClusterLinkFetcherManager $this, Tuple2 x0$4) {
        Tuple2 tuple2;
        TopicPartition tp;
        block3: {
            block2: {
                if (x0$4 == null) break block2;
                tp = (TopicPartition)x0$4._1();
                tuple2 = (Tuple2)x0$4._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)x0$4);
        }
        MirrorFailureType failureType = (MirrorFailureType)tuple2._1();
        String reason = (String)tuple2._2();
        boolean bl = $this.onPartitionLinkFailure(tp, failureType, reason, $this.onPartitionLinkFailure$default$4());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onMetadataFailure$2(ClusterLinkFetcherManager $this, MirrorFailureType failureType) {
        ((ConcurrentHashMap.KeySetView)$this.linkedPartitions().keySet()).forEach(tp -> $this.onPartitionLinkFailure((TopicPartition)tp, failureType, "Failed to get metadata", $this.onPartitionLinkFailure$default$4()));
    }

    public static final /* synthetic */ boolean $anonfun$populateFetcherPartitions$3(ClusterLinkFetcherManager $this, TopicPartition elem) {
        return $this.unassignedPartitions().add((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$populateFetcherPartitions$2(ClusterLinkFetcherManager $this, ClusterLinkFetcherThread x$5) {
        x$5.partitionsAndOffsets().keySet().foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherManager.$anonfun$populateFetcherPartitions$3($this, elem)));
    }

    public static final /* synthetic */ void $anonfun$handleSourceOffsets$2(ClusterLinkFetcherManager $this, TopicPartition tp$4, BooleanRef hasReadyPartitions$1, PartitionAndState partitionState) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("New source records available for waiting partition ").append(tp$4).append(" fetchState ").append(partitionState.fetchState()).append(" failureState ").append(partitionState.apiFailureType()).toString());
        partitionState.resetEpochUpdates();
        if (partitionState.apiFailureType().isEmpty()) {
            $this.unassignedPartitions().add((Object)tp$4);
            hasReadyPartitions$1.elem = true;
        }
    }

    public static final /* synthetic */ void $anonfun$addLinkedFetcherForPartitions$2(ClusterLinkFetcherManager $this, Partition partition) {
        PartitionAndState oldState = $this.linkedPartitions().get(partition.topicPartition());
        EpochUpdateState lastEpochUpdateState = (EpochUpdateState)Option$.MODULE$.apply((Object)oldState).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.lastEpochUpdateState()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new EpochUpdateState((Option<Object>)None$.MODULE$, 0));
        $this.linkedPartitions().put(partition.topicPartition(), new PartitionAndState(partition, lastEpochUpdateState));
        $this.unassignedPartitions().$plus$eq((Object)partition.topicPartition());
        if (!$this.isActive() || $this.isTruncationOnFetchSupportedOnLocalCluster()) {
            partition.linkedLeaderOffsetsPending(false);
        }
    }

    public static final /* synthetic */ boolean $anonfun$maybeNotifyReadyForFetch$1(Partition partition$3, ClusterLinkFetcherThread x$9) {
        return x$9.partitions().contains((Object)partition$3.topicPartition());
    }

    public static final /* synthetic */ String $anonfun$onLinkFailureUpdateResponse$3(TopicPartition partition$4, Errors error$1) {
        return new StringBuilder(76).append("Failed to update failed state for partition ").append(partition$4).append(" : ").append(error$1).append(", will retry on next failure.").toString();
    }

    public static final /* synthetic */ void $anonfun$maybeAddLinkedFetchers$1(ClusterLinkFetcherManager $this, scala.collection.mutable.Map assignablePartitions$1, TopicPartition tp) {
        $this.waitingPartitions().remove(tp);
        PartitionAndState partitionAndState = $this.linkedPartitions().get(tp);
        if (partitionAndState == null) {
            throw new IllegalStateException(new StringBuilder(27).append("Linked partition not found ").append(tp).toString());
        }
        Partition partition = partitionAndState.partition();
        Metadata.LeaderAndEpoch leaderAndEpoch = $this.metadata().currentLeader(tp);
        if (leaderAndEpoch.leader.isPresent() && leaderAndEpoch.epoch.isPresent()) {
            Integer sourceEpoch = (Integer)leaderAndEpoch.epoch.get();
            if (partition.getLeaderEpoch() >= Predef$.MODULE$.Integer2int(sourceEpoch)) {
                Node leader = (Node)leaderAndEpoch.leader.get();
                InitialFetchState initialFetchState = new InitialFetchState(new BrokerEndPoint(leader.id(), leader.host(), leader.port()), Predef$.MODULE$.Integer2int(sourceEpoch), partition.localLogOrException().localLogEndOffset());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Adding fetcher for linked partition ").append(tp).append(" ").append(initialFetchState).append(", localEpoch=").append(partition.getLeaderEpoch()).toString());
                assignablePartitions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState));
                partitionAndState.sourceLeaderAndEpoch_$eq(leaderAndEpoch);
                partition.truncateTo(initialFetchState.initOffset(), false);
                return;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$maybeAddLinkedFetchers$3(ClusterLinkFetcherManager $this, TopicPartition elem) {
        return $this.unassignedPartitions().remove((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$maybeAddLinkedFetchers$4(ClusterLinkFetcherManager $this, TopicPartition topicPartition) {
        return $this.failedPartitions().contains(topicPartition);
    }

    public static final /* synthetic */ void $anonfun$getTopicLag$2(String topic$2, LongRef maxLagThread$1, TopicPartition k, FetcherLagMetrics v) {
        block7: {
            block6: {
                String string;
                block5: {
                    string = k.topic();
                    if (string != null) break block5;
                    if (topic$2 != null) {
                        return;
                    }
                    break block6;
                }
                if (!string.equals(topic$2)) break block7;
            }
            maxLagThread$1.elem = package$.MODULE$.max(maxLagThread$1.elem, v.lag());
        }
    }

    public static final /* synthetic */ long $anonfun$getTopicLag$1(String topic$2, long curMaxLagAll, ClusterLinkFetcherThread fetcherThread) {
        LongRef maxLagThread = LongRef.create((long)0L);
        fetcherThread.fetcherLagStats().stats().foreachEntry((Function2<TopicPartition, FetcherLagMetrics, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(k, v) -> {
            ClusterLinkFetcherManager.$anonfun$getTopicLag$2(topic$2, maxLagThread, k, v);
            return BoxedUnit.UNIT;
        });
        return package$.MODULE$.max(curMaxLagAll, maxLagThread.elem);
    }

    private static final void printException$1(Function2 output, String topic$3, Map topicPartitionCounts$1, Throwable e$1) {
        output.apply((Object)new StringBuilder(59).append("Could not update destination topic partition count for ").append(topic$3).append(" to ").append(topicPartitionCounts$1.apply((Object)topic$3)).toString(), (Object)e$1);
    }

    public static final /* synthetic */ boolean $anonfun$fetcherThreadCount$1(int brokerId$1, FetcherTag x$20) {
        return x$20.brokerId() == brokerId$1;
    }

    public ClusterLinkFetcherManager(String linkName, UUID linkId, ClusterLinkConfig initialConfig, ClusterLinkManager clusterLinkManager, ClusterLinkDestConnectionManager destConnectionManager, KafkaConfig brokerConfig, ReplicaManager replicaManager, Admin destAdminClient, ReplicaQuota quota, ClusterLinkMetrics metrics, Option<String> tenant, Time time, Option<String> threadNamePrefix) {
        this.linkName = linkName;
        this.linkId = linkId;
        this.clusterLinkManager = clusterLinkManager;
        this.destConnectionManager = destConnectionManager;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.destAdminClient = destAdminClient;
        this.quota = quota;
        this.metrics = metrics;
        this.tenant = tenant;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        String x$1 = new StringBuilder(41).append("ClusterLinkFetcherManager on broker ").append(brokerConfig.brokerId()).append(" for ").append(linkName).toString();
        String x$2 = "ClusterLink";
        int x$3 = Predef$.MODULE$.Integer2int(initialConfig.numClusterLinkFetchers());
        FetchConnectionsMode$Combined$ x$4 = FetchConnectionsMode$Combined$.MODULE$;
        Map<String, String> x$5 = ClusterLinkFactory$.MODULE$.linkMetricTags(linkName);
        Option<Scheduler> x$6 = AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5();
        super(x$1, x$2, x$3, x$4, x$6, x$5);
        ClusterLinkFactory.FetcherManager.$init$(this);
        MetadataListener.$init$(this);
        this.linkedPartitions = new ConcurrentHashMap();
        this.unassignedPartitions = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.waitingPartitions = new ConcurrentHashMap();
        this.isTruncationOnFetchSupportedOnLocalCluster = ApiVersion$.MODULE$.isTruncationOnFetchSupported(brokerConfig.interBrokerProtocolVersion());
        this.clusterLinkConfig = initialConfig;
    }

    public static final /* synthetic */ Object $anonfun$reconfigure$2$adapted(ClusterLinkFetcherManager $this, Tuple2 entry) {
        ClusterLinkFetcherManager.$anonfun$reconfigure$2($this, entry);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reconfigure$11$adapted(java.util.Map newConfigValues$1, ClusterLinkNetworkClient x$2) {
        x$2.reconfigure(newConfigValues$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$updatePartitionCount$5$adapted(ClusterLinkFetcherManager $this, String x$14, Throwable x$15) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> x$14, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> x$15);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$updatePartitionCount$8$adapted(ClusterLinkFetcherManager $this, String x$16, Throwable x$17) {
        $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> x$16, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> x$17);
        return BoxedUnit.UNIT;
    }
}

