/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.LogAppendInfo;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread$;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.FetchState;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$IllegalState$;
import kafka.server.link.MirrorFailureType$SourceTopicDeleted$;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rMw!B!C\u0011\u0003Ie!B&C\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006\"B+\u0002\t\u00031\u0006\"CB^\u0003E\u0005I\u0011AB_\r\u0011Y%\t\u0001-\t\u0011u+!\u0011!Q\u0001\nyC\u0001\"[\u0003\u0003\u0002\u0003\u0006IA\u001b\u0005\t[\u0016\u0011\t\u0011)A\u0005]\"A\u0011/\u0002B\u0001B\u0003%!\u000f\u0003\u0005v\u000b\t\u0005\t\u0015!\u0003w\u0011!IXA!A!\u0002\u0013Q\bBC?\u0006\u0005\u0003\u0005\u000b\u0011\u0002@\u0002\n!Q\u0011qB\u0003\u0003\u0002\u0003\u0006I!!\u0005\t\u0015\u0005]QA!A!\u0002\u0013\tI\u0002\u0003\u0006\u0002 \u0015\u0011\t\u0011)A\u0005\u0003CA!\"a\n\u0006\u0005\u0003\u0005\u000b\u0011BA\u0015\u0011)\ty#\u0002B\u0001B\u0003%\u0011\u0011\u0007\u0005\u000b\u0003\u0017*!\u0011!Q\u0001\n\u00055\u0003bCA-\u000b\t\u0015\r\u0011\"\u0001C\u00037B!\"a\u0019\u0006\u0005\u0003\u0005\u000b\u0011BA/\u0011)\t)'\u0002B\u0001B\u0003%\u0011q\r\u0005\u000b\u0003[*!\u0011!Q\u0001\n\u0005=\u0004BCA>\u000b\t\u0005\t\u0015!\u0003\u0002~!11+\u0002C\u0001\u0003\u007fB\u0011\"a)\u0006\u0005\u0004%I!!*\t\u0011\u0005]V\u0001)A\u0005\u0003OC\u0011\"!/\u0006\u0005\u0004%I!!*\t\u0011\u0005mV\u0001)A\u0005\u0003OC\u0011\"!0\u0006\u0005\u0004%I!!*\t\u0011\u0005}V\u0001)A\u0005\u0003OC\u0011\"!1\u0006\u0005\u0004%I!a1\t\u0011\u0005%W\u0001)A\u0005\u0003\u000bD\u0011\"a3\u0006\u0005\u0004%I!!4\t\u0011\u0005eW\u0001)A\u0005\u0003\u001fD\u0011\"a7\u0006\u0001\u0004%I!!8\t\u0013\u0005\u0015X\u00011A\u0005\n\u0005\u001d\b\u0002CAz\u000b\u0001\u0006K!a8\t\u0013\u0005UX\u00011A\u0005\n\u0005\u0015\u0006\"CA|\u000b\u0001\u0007I\u0011BA}\u0011!\ti0\u0002Q!\n\u0005\u001d\u0006\"CA\u0000\u000b\t\u0007I\u0011\u000bB\u0001\u0011!\u0011I!\u0002Q\u0001\n\t\r\u0001b\u0002B\u0006\u000b\u0011\u0005#Q\u0002\u0005\b\u0005\u001f)A\u0011\u000bB\t\u0011\u001d\u0011i%\u0002C)\u0005\u001fB\u0011Ba$\u0006\u0005\u0004%\tE!\u0001\t\u0011\tEU\u0001)A\u0005\u0005\u0007AqAa%\u0006\t#\u0012)\nC\u0004\u0003,\u0016!\tF!,\t\u000f\tUV\u0001\"\u0015\u00038\"9!qZ\u0003\u0005B\tE\u0007\u0002\u0003Bp\u000b\u0011E#I!9\t\u000f\t%X\u0001\"\u0011\u0003l\"91QB\u0003\u0005B\r=\u0001bBB\u0017\u000b\u0011\u00053q\u0006\u0005\b\u0007\u0007*A\u0011IB#\u0011!\u0019I%\u0002C\u0001\u0005\u000e-\u0003bBB\"\u000b\u0011%1q\n\u0005\b\u0007/*A\u0011\tB\u0007\u0011\u001d\u0019I&\u0002C\t\u00077B\u0001b!\u0019\u0006\t\u0003\u0011%Q\u0002\u0005\b\u0007G*A\u0011IB3\u0011\u001d\u0019i'\u0002C!\u0007_Bqaa\u001e\u0006\t\u0013\u0019I(\u0001\rDYV\u001cH/\u001a:MS:\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012T!a\u0011#\u0002\t1Lgn\u001b\u0006\u0003\u000b\u001a\u000baa]3sm\u0016\u0014(\"A$\u0002\u000b-\fgm[1\u0004\u0001A\u0011!*A\u0007\u0002\u0005\nA2\t\\;ti\u0016\u0014H*\u001b8l\r\u0016$8\r[3s)\"\u0014X-\u00193\u0014\u0005\u0005i\u0005C\u0001(R\u001b\u0005y%\"\u0001)\u0002\u000bM\u001c\u0017\r\\1\n\u0005I{%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013\u0006)\u0011\r\u001d9msRyrk!&\u0004\u0018\u000ee51TBO\u0007?\u001b\tka+\u0004.\u000e=6\u0011WBZ\u0007k\u001b9l!/\u0011\u0005)+1CA\u0003Z!\tQ6,D\u0001E\u0013\taFI\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\r\u0005\u0002`M:\u0011\u0001\r\u001a\t\u0003C>k\u0011A\u0019\u0006\u0003G\"\u000ba\u0001\u0010:p_Rt\u0014BA3P\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015|\u0015!\u00034fi\u000eDWM]%e!\tq5.\u0003\u0002m\u001f\n\u0019\u0011J\u001c;\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005i{\u0017B\u00019E\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002#\rdWo\u001d;fe2Kgn[\"p]\u001aLw\r\u0005\u0002Kg&\u0011AO\u0011\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017aE2mkN$XM\u001d'j].lU\r^1eCR\f\u0007C\u0001&x\u0013\tA(IA\nDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-\u0001\bgKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0011\u0005)[\u0018B\u0001?C\u0005e\u0019E.^:uKJd\u0015N\\6GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001$\u0002\u000f\rdWo\u001d;fe&!\u0011qAA\u0001\u00059\u0011%o\\6fe\u0016sG\rU8j]RL1!`A\u0006\u0013\r\ti\u0001\u0012\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fE\u0002[\u0003'I1!!\u0006E\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\u0006sKBd\u0017nY1NOJ\u00042AWA\u000e\u0013\r\ti\u0002\u0012\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\rQ\u00161E\u0005\u0004\u0003K!%\u0001\u0004*fa2L7-Y)v_R\f\u0017AE2mkN$XM\u001d'j].lU\r\u001e:jGN\u00042ASA\u0016\u0013\r\tiC\u0011\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0003uS6,\u0007\u0003BA\u001a\u0003\u000fj!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0006kRLGn\u001d\u0006\u0005\u0003w\ti$\u0001\u0004d_6lwN\u001c\u0006\u0004\u000f\u0006}\"\u0002BA!\u0003\u0007\na!\u00199bG\",'BAA#\u0003\ry'oZ\u0005\u0005\u0003\u0013\n)D\u0001\u0003US6,\u0017\u0001\u00053z]\u0006l\u0017n\u0019$fi\u000eD7+\u001b>f!\u0015q\u0015qJA*\u0013\r\t\tf\u0014\u0002\n\rVt7\r^5p]B\u00022ASA+\u0013\r\t9F\u0011\u0002\u0012\r\u0016$8\r\u001b*fgB|gn]3TSj,\u0017!E2mkN$XM\u001d'j].\u001cE.[3oiV\u0011\u0011Q\f\t\u0004\u0015\u0006}\u0013bAA1\u0005\nA2\t\\;ti\u0016\u0014H*\u001b8l\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002%\rdWo\u001d;fe2Kgn[\"mS\u0016tG\u000fI\u0001\u001bY\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u\u00052|7m[5oON+g\u000e\u001a\t\u00045\u0006%\u0014bAA6\t\na!\t\\8dW&twmU3oI\u0006iAn\\4D_:$X\r\u001f;PaR\u0004RATA9\u0003kJ1!a\u001dP\u0005\u0019y\u0005\u000f^5p]B!\u00111GA<\u0013\u0011\tI(!\u000e\u0003\u00151{wmQ8oi\u0016DH/\u0001\u0004uK:\fg\u000e\u001e\t\u0005\u001d\u0006Ed\fF\u0012X\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u00151RAG\u0003\u001f\u000b\t*a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003;\u000by*!)\t\u000buC\u0002\u0019\u00010\t\u000b%D\u0002\u0019\u00016\t\u000b5D\u0002\u0019\u00018\t\u000bED\u0002\u0019\u0001:\t\u000bUD\u0002\u0019\u0001<\t\u000beD\u0002\u0019\u0001>\t\u000buD\u0002\u0019\u0001@\t\u000f\u0005=\u0001\u00041\u0001\u0002\u0012!9\u0011q\u0003\rA\u0002\u0005e\u0001bBA\u00101\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003OA\u0002\u0019AA\u0015\u0011\u001d\ty\u0003\u0007a\u0001\u0003cAq!a\u0013\u0019\u0001\u0004\ti\u0005C\u0004\u0002Za\u0001\r!!\u0018\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002h!I\u0011Q\u000e\r\u0011\u0002\u0003\u0007\u0011q\u000e\u0005\b\u0003wB\u0002\u0019AA?\u0003\u001di\u0017\r_,bSR,\"!a*\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u0006!A.\u00198h\u0015\t\t\t,\u0001\u0003kCZ\f\u0017\u0002BA[\u0003W\u0013q!\u00138uK\u001e,'/\u0001\u0005nCb<\u0016-\u001b;!\u0003!i\u0017N\u001c\"zi\u0016\u001c\u0018!C7j]\nKH/Z:!\u0003Ya\u0017N\\6GKR\u001c\u0007.\u001a:GY><8i\u001c8ue>d\u0017a\u00067j].4U\r^2iKJ4En\\<D_:$(o\u001c7!\u0003I)h\u000e\u001d:fM&DX\r\u001a'j].t\u0015-\\3\u0016\u0005\u0005\u0015\u0007\u0003BAU\u0003\u000fL1aZAV\u0003M)h\u000e\u001d:fM&DX\r\u001a'j].t\u0015-\\3!\u0003\u001diW\r\u001e:jGN,\"!a4\u0011\t\u0005E\u0017Q[\u0007\u0003\u0003'TA!a3\u0002:%!\u0011q[Aj\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0010Y\u0006\u001cHOR3uG\"$\u0016.\\3NgV\u0011\u0011q\u001c\t\u0004\u001d\u0006\u0005\u0018bAAr\u001f\n!Aj\u001c8h\u0003Ma\u0017m\u001d;GKR\u001c\u0007\u000eV5nK6\u001bx\fJ3r)\u0011\tI/a<\u0011\u00079\u000bY/C\u0002\u0002n>\u0013A!\u00168ji\"I\u0011\u0011\u001f\u0013\u0002\u0002\u0003\u0007\u0011q\\\u0001\u0004q\u0012\n\u0014\u0001\u00057bgR4U\r^2i)&lW-T:!\u0003E1W\r^2i%\u0016\u001c\bo\u001c8tKNK'0Z\u0001\u0016M\u0016$8\r\u001b*fgB|gn]3TSj,w\fJ3r)\u0011\tI/a?\t\u0013\u0005Ex%!AA\u0002\u0005\u001d\u0016A\u00054fi\u000eD'+Z:q_:\u001cXmU5{K\u0002\nA$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G-\u0006\u0002\u0003\u0004A\u0019aJ!\u0002\n\u0007\t\u001dqJA\u0004C_>dW-\u00198\u0002;%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fI\u0002\na\u0001Z8X_J\\GCAAu\u0003M1W\r^2i%\u0016\fX/Z:u\u0005VLG\u000eZ3s)\u0011\u0011\u0019Ba\n\u0011\t\tU!\u0011\u0005\b\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)!!1DA\u001d\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B\u0010\u00053\tABR3uG\"\u0014V-];fgRLAAa\t\u0003&\t9!)^5mI\u0016\u0014(\u0002\u0002B\u0010\u00053AqA!\u000b-\u0001\u0004\u0011Y#A\u0005gKR\u001c\u0007\u000eR1uCB!!Q\u0006B$\u001d\u0011\u0011yC!\u0011\u000f\t\tE\"Q\b\b\u0005\u0005g\u0011YD\u0004\u0003\u00036\tebbA1\u00038%\u0011\u0011QI\u0005\u0005\u0003\u0003\n\u0019%C\u0002H\u0003\u007fIAAa\u0010\u0002>\u000591\r\\5f]R\u001c\u0018\u0002\u0002B\"\u0005\u000b\n1CR3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJTAAa\u0010\u0002>%!!\u0011\nB&\u0005A1U\r^2i%\u0016\fX/Z:u\t\u0006$\u0018M\u0003\u0003\u0003D\t\u0015\u0013\u0001\u00077jgR|eMZ:fiJ+\u0017/^3ti\n+\u0018\u000e\u001c3feR!!\u0011\u000bB/!\u0011\u0011\u0019F!\u0017\u000f\t\t]!QK\u0005\u0005\u0005/\u0012I\"\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$\u0018\u0002\u0002B\u0012\u00057RAAa\u0016\u0003\u001a!9!qL\u0017A\u0002\t\u0005\u0014a\u00059beRLG/[8o)&lWm\u001d;b[B\u001c\b\u0003\u0003B2\u0005S\u0012iG!\u001e\u000e\u0005\t\u0015$b\u0001B4\u001f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-$Q\r\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002B8\u0005cj!!!\u000f\n\t\tM\u0014\u0011\b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u00119H!#\u000f\t\te$1\u0011\b\u0005\u0005w\u0012yH\u0004\u0003\u00032\tu\u0014\u0002BA\u001e\u0003{IAA!!\u0002:\u00059Q.Z:tC\u001e,\u0017\u0002\u0002BC\u0005\u000f\u000ba\u0003T5ti>3gm]3ugJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0005\u0005\u0003\u000bI$\u0003\u0003\u0003\f\n5%\u0001\u0006'jgR|eMZ:fiN\u0004\u0016M\u001d;ji&|gN\u0003\u0003\u0003\u0006\n\u001d\u0015aH5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fI\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u00039ygn\u00144gg\u0016$H+[3sK\u0012$bAa\u0001\u0003\u0018\nm\u0005b\u0002BMa\u0001\u0007!QN\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0011i\n\ra\u0001\u0005?\u000bAB]3rk\u0016\u001cH/\u00129pG\"\u0004bA!)\u0003(\u0006\u001dVB\u0001BR\u0015\u0011\u0011)+a,\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005S\u0013\u0019K\u0001\u0005PaRLwN\\1m\u0003Eyg\u000eU1si&$\u0018n\u001c8GK:\u001cW\r\u001a\u000b\u0007\u0005\u0007\u0011yKa-\t\u000f\tE\u0016\u00071\u0001\u0003n\u0005\u0011A\u000f\u001d\u0005\b\u0005;\u000b\u0004\u0019\u0001BP\u0003iA\u0017M\u001c3mKB\u000b'\u000f^5uS>t7oV5uQ\u0016\u0013(o\u001c:t)\u0019\tIO!/\u0003L\"9!1\u0018\u001aA\u0002\tu\u0016A\u00039beRLG/[8ogBA!1\rB5\u0005[\u0012y\f\u0005\u0003\u0003B\n\u001dWB\u0001Bb\u0015\u0011\u0011)-!\u000f\u0002\u0011A\u0014x\u000e^8d_2LAA!3\u0003D\n1QI\u001d:peNDaA!43\u0001\u0004q\u0016AC7fi\"|GMT1nK\u0006AAO];oG\u0006$X\r\u0006\u0004\u0002j\nM'Q\u001b\u0005\b\u0005c\u001b\u0004\u0019\u0001B7\u0011\u001d\u00119n\ra\u0001\u00053\fQc\u001c4gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002[\u00057L1A!8E\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq&\u001e9eCR,g)\u001a;dQ>3gm]3u\u0003:$W*Y=cK6\u000b'o\u001b+sk:\u001c\u0017\r^5p]\u000e{W\u000e\u001d7fi\u0016$B!!;\u0003d\"9!Q\u001d\u001bA\u0002\t\u001d\u0018\u0001\u00044fi\u000eDwJ\u001a4tKR\u001c\b\u0003\u0003B2\u0005S\u0012iG!7\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\u0011iOa?\u0003~\u000e\u0005\u0001#\u0002(\u0002r\t=\b\u0003\u0002By\u0005ol!Aa=\u000b\u0007\tUh)A\u0002m_\u001eLAA!?\u0003t\niAj\\4BaB,g\u000eZ%oM>DqA!-6\u0001\u0004\u0011i\u0007C\u0004\u0003\u0000V\u0002\r!a8\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0007\u0007)\u0004\u0019AB\u0003\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!1qAB\u0005\u001b\u0005)\u0011\u0002BB\u0006\u0003\u0017\u0011\u0011BR3uG\"$\u0015\r^1\u0002CU\u0004H-\u0019;f\u0011&<\u0007nV1uKJl\u0017M]6B]\u0012\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u0015\u0005}7\u0011CB\u000e\u0007G\u00199\u0003C\u0004\u0004\u0014Y\u0002\ra!\u0006\u0002\u0013A\f'\u000f^5uS>t\u0007cA@\u0004\u0018%!1\u0011DA\u0001\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0003vZ\u0002\ra!\b\u0011\t\tE8qD\u0005\u0005\u0007C\u0011\u0019PA\u0006BEN$(/Y2u\u0019><\u0007bBB\u0013m\u0001\u0007\u0011q\\\u0001\u001ag>,(oY3MK\u0006$WM\u001d%jO\"<\u0016\r^3s[\u0006\u00148\u000eC\u0004\u0004*Y\u0002\raa\u000b\u00025M|WO]2f\u0019\u0016\fG-\u001a:M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0011\u000b9\u000b\t(a8\u0002-MDw.\u001e7e\r>dGn\\<feRC'o\u001c;uY\u0016$\"Ba\u0001\u00042\rU2qGB!\u0011\u001d\u0019\u0019d\u000ea\u0001\u0005\u0007\tq\"[:Rk>$\u0018-\u0012=dK\u0016$W\r\u001a\u0005\b\u0003?9\u0004\u0019AA\u0011\u0011\u001d\u0019Id\u000ea\u0001\u0007w\t!BZ3uG\"\u001cF/\u0019;f!\rQ6QH\u0005\u0004\u0007\u007f!%a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0007b\u0002BMo\u0001\u0007!QN\u0001\u0010SN\u0014V-\u00193z\r>\u0014h)\u001a;dQR!!1AB$\u0011\u001d\u0011\t\f\u000fa\u0001\u0005[\n\u0001$\\1zE\u0016tu\u000e^5gsJ+\u0017\rZ=G_J4U\r^2i)\u0011\tIo!\u0014\t\u000f\rM\u0011\b1\u0001\u0004\u0016Q1!1AB)\u0007'Bqaa\u0005;\u0001\u0004\u0019)\u0002C\u0004\u0004Vi\u0002\rAa\u0001\u0002\u001fU\u0004H-\u0019;f\u0019\u0006<7+\u001a8t_J\f1$\\1sW\u001a{G\u000e\\8xKJ\u0014V\r\u001d7jG\u0006$\u0006N]8ui2,\u0017!G2mK\u0006\u0014\b+\u0019:uSRLwN\u001c'j].4\u0015-\u001b7ve\u0016$b!!;\u0004^\r}\u0003b\u0002BYy\u0001\u0007!Q\u000e\u0005\b\u0005\u007fd\u0004\u0019AAp\u0003Y)\b\u000fZ1uK\u0012Kh.Y7jG\u001a+Go\u00195TSj,\u0017!F;qI\u0006$XMR3uG\",'\u000fT1h'R\fGo\u001d\u000b\u0007\u0003S\u001c9g!\u001b\t\u000f\tEf\b1\u0001\u0003n!911\u000e A\u0002\u0005}\u0017a\u00017bO\u0006)R\u000f\u001d3bi\u00164U\r^2iKJ\u0014\u0015\u0010^3SCR,GCBAu\u0007c\u001a\u0019\bC\u0004\u00032~\u0002\rA!\u001c\t\u000f\rUt\b1\u0001\u0002`\u0006)!-\u001f;fg\u00061r-\u001a;Pe\u000e\u0013X-\u0019;f)>\u0004\u0018nY*f]N|'\u000f\u0006\u0006\u0004|\r\u00055QQBD\u0007#\u0003B!!5\u0004~%!1qPAj\u0005\u0019\u0019VM\\:pe\"111\u0011!A\u0002y\u000bQ\u0001^8qS\u000eDQ!\u0018!A\u0002yCqa!#A\u0001\u0004\u0019Y)\u0001\u0003ti\u0006$\b\u0003BAi\u0007\u001bKAaa$\u0002T\nqQ*Z1tkJ\f'\r\\3Ti\u0006$\bBBBJ\u0001\u0002\u0007a,A\u0006eKN\u001c'/\u001b9uS>t\u0007\"B/\u0004\u0001\u0004q\u0006\"B5\u0004\u0001\u0004Q\u0007\"B7\u0004\u0001\u0004q\u0007\"B9\u0004\u0001\u0004\u0011\b\"B;\u0004\u0001\u00041\b\"B=\u0004\u0001\u0004Q\bbBBR\u0007\u0001\u00071QU\u0001\u0016I\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s!\rQ5qU\u0005\u0004\u0007S\u0013%\u0001I\"mkN$XM\u001d'j].$Um\u001d;D_:tWm\u0019;j_:l\u0015M\\1hKJDQ!`\u0002A\u0002yDq!a\u0004\u0004\u0001\u0004\t\t\u0002C\u0004\u0002\u0018\r\u0001\r!!\u0007\t\u000f\u0005}1\u00011\u0001\u0002\"!9\u0011qE\u0002A\u0002\u0005%\u0002bBA\u0018\u0007\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003w\u001a\u0001\u0019AA?\u0011\u001d\tYe\u0001a\u0001\u0003\u001b\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nd'\u0006\u0002\u0004@*\"\u0011qNBaW\t\u0019\u0019\r\u0005\u0003\u0004F\u000e=WBABd\u0015\u0011\u0019Ima3\u0002\u0013Ut7\r[3dW\u0016$'bABg\u001f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rE7q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ClusterLinkFetcherThread
extends ReplicaFetcherThread {
    private final ClusterLinkMetadata clusterLinkMetadata;
    private final ClusterLinkFetcherManager fetcherManager;
    private final ReplicaManager replicaMgr;
    private final ClusterLinkMetrics clusterLinkMetrics;
    private final Time time;
    private final Function0<FetchResponseSize> dynamicFetchSize;
    private final ClusterLinkNetworkClient clusterLinkClient;
    private final Option<String> tenant;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer linkFetcherFlowControl;
    private final String unprefixedLinkName;
    private final Metrics metrics;
    private long lastFetchTimeMs;
    private Integer fetchResponseSize;
    private final boolean isTruncationOnFetchSupported;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Option<LogContext> $lessinit$greater$default$16() {
        return ClusterLinkFetcherThread$.MODULE$.$lessinit$greater$default$16();
    }

    public static ClusterLinkFetcherThread apply(String string, int n, KafkaConfig kafkaConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager clusterLinkFetcherManager, ClusterLinkDestConnectionManager clusterLinkDestConnectionManager, BrokerEndPoint brokerEndPoint, FailedPartitions failedPartitions, ReplicaManager replicaManager, ReplicaQuota replicaQuota, ClusterLinkMetrics clusterLinkMetrics, Time time, Option<String> option, Function0<FetchResponseSize> function0) {
        if (ClusterLinkFetcherThread$.MODULE$ == null) {
            throw null;
        }
        int apply_brokerId = kafkaConfig.brokerId();
        LogContext apply_logContext = new LogContext(new StringBuilder(68).append("[ClusterLinkFetcher brokerId=").append(apply_brokerId).append(" ").append("fetcherId=").append(n).append("] source(link=").append(clusterLinkMetadata.linkName()).append(", leaderId=").append(brokerEndPoint.id()).append(")] ").toString(), clusterLinkDestConnectionManager.maxLogLevel());
        ClusterLinkNetworkClient apply_clusterLinkClient = new ClusterLinkNetworkClient(clusterLinkConfig, ClusterLinkMetrics$.MODULE$.throttleTimeSensorName(clusterLinkMetadata.linkName()), (Option<ClusterLinkMetadata>)None$.MODULE$, (Option<MetadataUpdater>)new Some((Object)new ManualMetadataUpdater()), clusterLinkMetrics.metrics(), (Map<String, String>)ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()).$plus$plus((GenTraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerEndPoint.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fetcher-id"), (Object)Integer.toString(n))}))), time, new StringBuilder(22).append("link-").append(clusterLinkMetadata.linkName()).append("-broker-").append(apply_brokerId).append("-fetcher-").append(n).toString(), "fetcher", apply_logContext);
        clusterLinkDestConnectionManager.enableClusterLink(apply_clusterLinkClient, (Option<AdminMetadataManager>)None$.MODULE$);
        ReplicaFetcherBlockingSend apply_leaderEndpoint = new ReplicaFetcherBlockingSend(brokerEndPoint, kafkaConfig, Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaSocketTimeoutMs()), time, apply_clusterLinkClient.networkClient(), (Option<Reconfigurable>)None$.MODULE$);
        return new ClusterLinkFetcherThread(string, n, kafkaConfig, clusterLinkConfig, clusterLinkMetadata, clusterLinkFetcherManager, brokerEndPoint, failedPartitions, replicaManager, replicaQuota, clusterLinkMetrics, time, function0, apply_clusterLinkClient, apply_leaderEndpoint, (Option<LogContext>)new Some((Object)apply_logContext), option);
    }

    public ClusterLinkNetworkClient clusterLinkClient() {
        return this.clusterLinkClient;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer linkFetcherFlowControl() {
        return this.linkFetcherFlowControl;
    }

    private String unprefixedLinkName() {
        return this.unprefixedLinkName;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private long lastFetchTimeMs() {
        return this.lastFetchTimeMs;
    }

    private void lastFetchTimeMs_$eq(long x$1) {
        this.lastFetchTimeMs = x$1;
    }

    private Integer fetchResponseSize() {
        return this.fetchResponseSize;
    }

    private void fetchResponseSize_$eq(Integer x$1) {
        this.fetchResponseSize = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void doWork() {
        this.updateDynamicFetchSize();
        super.doWork();
    }

    @Override
    public FetchRequest.Builder fetchRequestBuilder(FetchSessionHandler.FetchRequestData fetchData) {
        this.lastFetchTimeMs_$eq(this.time.milliseconds());
        return FetchRequest.Builder.forConsumer((int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.fetchResponseSize())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
    }

    @Override
    public ListOffsetsRequest.Builder listOffsetRequestBuilder(Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> partitionTimestamps) {
        Seq topics = ((TraversableOnce)partitionTimestamps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = (ListOffsetsRequestData.ListOffsetsPartition)x0$1._2();
            ListOffsetsRequestData.ListOffsetsTopic listOffsetsTopic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(listOffsetPartition));
            return listOffsetsTopic;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean onOffsetTiered(TopicPartition topicPartition, Optional<Integer> requestEpoch) {
        this.fetcherManager.onPartitionLinkFailure(topicPartition, MirrorFailureType$IllegalState$.MODULE$, new StringBuilder(36).append("Unexpected tiered offset for ").append(topicPartition).append(" epoch ").append(requestEpoch).toString(), this.fetcherManager.onPartitionLinkFailure$default$4());
        return false;
    }

    @Override
    public boolean onPartitionFenced(TopicPartition tp, Optional<Integer> requestEpoch) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("onPartitionFenced ").append(tp).append(" : request metadata ").toString());
        this.clusterLinkMetadata.requestUpdate();
        return super.onPartitionFenced(tp, requestEpoch);
    }

    @Override
    public void handlePartitionsWithErrors(Map<TopicPartition, Errors> partitions, String methodName) {
        if (partitions.nonEmpty()) {
            BooleanRef needMetadata = BooleanRef.create((boolean)false);
            partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ClusterLinkFetcherThread.$anonfun$handlePartitionsWithErrors$1(this, needMetadata, x0$1);
                return BoxedUnit.UNIT;
            });
            if (needMetadata.elem) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Request metadata update because of errors for partitions ").append(partitions).toString());
                this.clusterLinkMetadata.requestUpdate();
            }
        }
        super.handlePartitionsWithErrors(partitions, methodName);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        if (log.logEndOffset() > offsetTruncationState.offset() && partition.getLinkedLeaderEpoch().contains((Object)BoxesRunTime.boxToInteger((int)0))) {
            String errorMessage = new StringBuilder(164).append("Failing mirror due to unexpected truncation to offset ").append(offsetTruncationState.offset()).append(" ").append("with source leader epoch 0 when destination leader leo is ").append(log.logEndOffset()).append(". ").append("Source topic may have been deleted and recreated.").toString();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            this.fetcherManager.onPartitionLinkFailure(tp, MirrorFailureType$SourceTopicDeleted$.MODULE$, errorMessage, false);
            this.markPartitionFailed(tp);
            return;
        }
        super.truncate(tp, offsetTruncationState);
    }

    @Override
    public void updateFetchOffsetAndMaybeMarkTruncationComplete(Map<TopicPartition, OffsetTruncationState> fetchOffsets) {
        super.updateFetchOffsetAndMaybeMarkTruncationComplete(fetchOffsets);
        fetchOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkFetcherThread.$anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition tp, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        this.fetcherManager.updatePartitionFetchState(tp, new FetchState(this.lastFetchTimeMs(), partitionData.highWatermark()));
        this.clearPartitionLinkFailure(tp, fetchOffset);
        return super.processPartitionData(tp, fetchOffset, partitionData);
    }

    @Override
    public long updateHighWatermarkAndStartOffset(Partition partition, AbstractLog log, long sourceLeaderHighWatermark, Option<Object> sourceLeaderLogStartOffset) {
        partition.maybeIncrementLinkLeaderHW(log);
        sourceLeaderLogStartOffset.foreach((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)sourceStartOffset -> {
            long destStartOffset = package$.MODULE$.min(log.highWatermark(), sourceStartOffset);
            return log.maybeIncrementLogStartOffset(destStartOffset, LeaderOffsetIncremented$.MODULE$);
        });
        return log.highWatermark();
    }

    @Override
    public boolean shouldFollowerThrottle(boolean isQuotaExceeded, ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return isQuotaExceeded && quota.isThrottled(topicPartition);
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return this.replicaMgr.onlinePartition(tp).exists((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)this.isReadyForFetch(partition, true)));
    }

    public void maybeNotifyReadyForFetch(Partition partition) {
        if (this.isReadyForFetch(partition, false)) {
            this.notifyReadyForFetch();
        }
    }

    private boolean isReadyForFetch(Partition partition, boolean updateLagSensor) {
        if (Predef$.MODULE$.Integer2int(this.linkFetcherFlowControl()) >= 0 && partition.leaderLogIfLocal().exists((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFetcherThread.$anonfun$isReadyForFetch$2(this, log)))) {
            if (updateLagSensor) {
                this.clusterLinkMetrics.destinationLagLinkFetcherThrottleSensor().record();
            }
            return false;
        }
        if (BoxesRunTime.equalsNumObject((Number)this.linkFetcherFlowControl(), (Object)BoxesRunTime.boxToInteger((int)-2))) {
            return !partition.isUnderReplicated();
        }
        return !partition.isUnderMinIsr();
    }

    @Override
    public void markFollowerReplicaThrottle() {
        this.replicaMgr.markClusterLinkReplicaThrottle();
    }

    public void clearPartitionLinkFailure(TopicPartition tp, long fetchOffset) {
        this.fetcherManager.clearPartitionLinkFailure(tp, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("New data fetched from ").append(tp).append(" offset ").append(fetchOffset).toString(), true);
    }

    public void updateDynamicFetchSize() {
        FetchResponseSize dynamicSize = (FetchResponseSize)this.dynamicFetchSize.apply();
        this.fetchSize_$eq(Predef$.MODULE$.int2Integer(dynamicSize.perPartitionSize()));
        this.fetchResponseSize_$eq(Predef$.MODULE$.int2Integer(dynamicSize.responseSize()));
    }

    @Override
    public void updateFetcherLagStats(TopicPartition tp, long lag) {
        super.updateFetcherLagStats(tp, lag);
        long topicLag = this.fetcherManager.getTopicLag(tp.topic());
        if (topicLag >= 0L) {
            this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-lag", (MeasurableStat)new Value(), "Mirror topic lag").record((double)topicLag);
        }
    }

    @Override
    public void updateFetcherByteRate(TopicPartition tp, long bytes) {
        super.updateFetcherByteRate(tp, bytes);
        this.getOrCreateTopicSensor(tp.topic(), "mirror-topic-byte-total", (MeasurableStat)new CumulativeSum(), "Mirror topic throughput").record((double)bytes);
    }

    private Sensor getOrCreateTopicSensor(String topic, String name, MeasurableStat stat, String description) {
        String unprefixedTopic = (String)this.tenant.map((Function1 & Serializable & scala.Serializable)t -> topic.substring(t.length() + 1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> topic);
        String sensorName = new StringBuilder(3).append(name).append("-").append(this.tenant).append("-").append(this.unprefixedLinkName()).append("-").append(unprefixedTopic).toString();
        Sensor sensor = this.metrics().sensor(sensorName, this.metrics().config(), TimeUnit.MINUTES.toSeconds(5L), new Sensor[0]);
        scala.collection.immutable.Map tags = ((TraversableOnce)new .colon.colon((Object)this.tenant.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)unprefixedTopic)), (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
        MetricName metricName = new MetricName(name, "cluster-link-metrics", description, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava());
        sensor.add(metricName, stat);
        return sensor;
    }

    public static final /* synthetic */ void $anonfun$handlePartitionsWithErrors$1(ClusterLinkFetcherThread $this, BooleanRef needMetadata$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Errors error = (Errors)x0$1._2();
            if (MirrorFailureType$.MODULE$.failureType(error.exception()).exists((Function1 & Serializable & scala.Serializable)failure -> BoxesRunTime.boxToBoolean((boolean)$this.fetcherManager.onPartitionLinkFailure(tp, failure, error.message(), false)))) {
                needMetadata$1.elem = true;
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$updateFetchOffsetAndMaybeMarkTruncationComplete$1(ClusterLinkFetcherThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            if (((OffsetTruncationState)x0$1._2()).truncationCompleted()) {
                $this.fetcherManager.partition(tp).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.linkedLeaderOffsetsPending(false);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ boolean $anonfun$isReadyForFetch$2(ClusterLinkFetcherThread $this, AbstractLog log) {
        return log.logEndOffset() - log.highWatermark() > (long)Predef$.MODULE$.Integer2int($this.linkFetcherFlowControl());
    }

    public ClusterLinkFetcherThread(String name, int fetcherId, KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, ClusterLinkMetadata clusterLinkMetadata, ClusterLinkFetcherManager fetcherManager, BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, ClusterLinkMetrics clusterLinkMetrics, Time time, Function0<FetchResponseSize> dynamicFetchSize, ClusterLinkNetworkClient clusterLinkClient, BlockingSend leaderEndpointBlockingSend, Option<LogContext> logContextOpt, Option<String> tenant) {
        this.clusterLinkMetadata = clusterLinkMetadata;
        this.fetcherManager = fetcherManager;
        this.replicaMgr = replicaMgr;
        this.clusterLinkMetrics = clusterLinkMetrics;
        this.time = time;
        this.dynamicFetchSize = dynamicFetchSize;
        this.clusterLinkClient = clusterLinkClient;
        this.tenant = tenant;
        super(name, fetcherId, sourceBroker, brokerConfig, failedPartitions, replicaMgr, clusterLinkMetrics.metrics(), time, quota, (Option<BlockingSend>)new Some((Object)leaderEndpointBlockingSend), logContextOpt, ClusterLinkFactory$.MODULE$.linkMetricTags(clusterLinkMetadata.linkName()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(clusterLinkConfig.replicaFetchBackoffMs()))));
        this.maxWait = clusterLinkConfig.replicaFetchWaitMaxMs();
        this.minBytes = clusterLinkConfig.replicaFetchMinBytes();
        this.linkFetcherFlowControl = clusterLinkConfig.linkFetcherFlowControl();
        this.unprefixedLinkName = (String)tenant.map((Function1 & Serializable & scala.Serializable)t -> $this.clusterLinkMetadata.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.clusterLinkMetadata.linkName());
        this.metrics = clusterLinkMetrics.metrics();
        this.lastFetchTimeMs = -1L;
        this.fetchResponseSize = clusterLinkConfig.replicaFetchResponseMaxBytes();
        this.isTruncationOnFetchSupported = false;
        this.isOffsetForLeaderEpochSupported = true;
    }
}

