/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeBoolean$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.Uuid;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkTopicState$ {
    public static ClusterLinkTopicState$ MODULE$;

    static {
        new ClusterLinkTopicState$();
    }

    public String toJsonString(ClusterLinkTopicState state) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.state().name()), CollectionConverters$.MODULE$.mapAsJavaMapConverter(state.toMap()).asJava())}))).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkTopicState fromJsonString(String json) {
        Product product;
        Option<JsonValue> option = Json$.MODULE$.parseFull(json);
        if (option instanceof Some) {
            void var9_9;
            void var8_8;
            void var7_6;
            JsonObject jsonObj = ((JsonValue)((Some)option).value()).asJsonObject();
            List entries = (List)((TraversableLike)TopicLinkState$.MODULE$.states().map((Function1 & Serializable & scala.Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), jsonObj.get(key.name())), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicState$.$anonfun$fromJsonString$2(x$2)));
            if (entries.size() != 1) {
                throw new IllegalStateException("Invalid cluster link topic state(s)");
            }
            Tuple2 tuple2 = (Tuple2)entries.head();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicLinkState k = (TopicLinkState)tuple2._1();
            JsonObject jsonObject = ((JsonValue)((Option)tuple2._2()).get()).asJsonObject();
            void key2 = var7_6;
            JsonObject jsonOpt = jsonObject;
            void key3 = var8_8;
            void jsonOpt2 = var9_9;
            if (TopicLinkMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                product = new ClusterLinkTopicState.Mirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), timeMs);
            } else if (TopicLinkPausedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean linkLevel = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("link_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean topicLevel = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("topic_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean wasFailed = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("was_failed").to(DecodeJson$DecodeBoolean$.MODULE$));
                product = new ClusterLinkTopicState.PausedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), linkLevel, topicLevel, wasFailed, timeMs);
            } else if (TopicLinkFailedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                product = new ClusterLinkTopicState.FailedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), timeMs);
            } else if (TopicLinkPendingStoppedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean synchronize = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("synchronize").to(DecodeJson$DecodeBoolean$.MODULE$));
                product = new ClusterLinkTopicState.PendingStoppedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), synchronize, timeMs);
            } else if (TopicLinkStoppedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq logEndOffsets = (Seq)jsonOpt2.apply("log_end_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                product = new ClusterLinkTopicState.StoppedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), (Seq<Object>)logEndOffsets, timeMs);
            } else {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                product = new ClusterLinkTopicState.FailedMirror(linkName, linkId, ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), timeMs);
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(26).append("Invalid topic state JSON: ").append(json).toString());
            }
            throw new MatchError(option);
        }
        return product;
    }

    public Option<Tuple2<String, String>> sourceTopicIdOption(Uuid sourceTopicId) {
        Uuid uuid = sourceTopicId;
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (!(uuid != null ? !uuid.equals(uuid2) : uuid2 != null)) {
            return None$.MODULE$;
        }
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source_topic_id"), (Object)sourceTopicId.toString()));
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$2(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    private static final void validateVersion$1(int expectedVersion, int actualVersion) {
        if (expectedVersion != actualVersion) {
            throw new IllegalStateException(new StringBuilder(40).append("Unexpected version '").append(expectedVersion).append("', actual version '").append(actualVersion).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    private static final Uuid sourceTopicId$1(JsonObject jsonOpt$1) {
        return (Uuid)jsonOpt$1.get("source_topic_id").map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.to(DecodeJson$DecodeString$.MODULE$)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicState$.$anonfun$fromJsonString$4(x$5))).map((Function1 & Serializable & scala.Serializable)x$1 -> Uuid.fromString((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    private ClusterLinkTopicState$() {
        MODULE$ = this;
    }
}

