/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.server.link.EpochUpdateState;
import kafka.server.link.FetchState;
import kafka.server.link.MirrorFailureType;
import kafka.server.link.MirrorFailureType$;
import kafka.server.link.MirrorFailureType$NoSourceRecords$;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.replica.ReplicaStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u000e\u001c\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001BA\u0002\u0013\u00051\u0007\u0003\u00059\u0001\t\u0005\r\u0011\"\u0001:\u0011!y\u0004A!A!B\u0013!\u0004\"\u0002#\u0001\t\u0003)\u0005bB%\u0001\u0001\u0004%\tA\u0013\u0005\bI\u0002\u0001\r\u0011\"\u0001f\u0011\u00199\u0007\u0001)Q\u0005\u0017\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007B\u0002<\u0001A\u0003%!\u000eC\u0004x\u0001\u0001\u0007I\u0011\u0001=\t\u0011}\u0004\u0001\u0019!C\u0001\u0003\u0003Aq!!\u0002\u0001A\u0003&\u0011\u0010\u0003\u0005\u0002\n\u0001\u0001\r\u0011\"\u0001y\u0011%\tY\u0001\u0001a\u0001\n\u0003\ti\u0001C\u0004\u0002\u0012\u0001\u0001\u000b\u0015B=\t\u0013\u0005U\u0001\u00011A\u0005\u0002\u0005]\u0001\"CA\u0011\u0001\u0001\u0007I\u0011AA\u0012\u0011!\t9\u0003\u0001Q!\n\u0005e\u0001bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002b\u0001!\t!a\u0019\u0003#A\u000b'\u000f^5uS>t\u0017I\u001c3Ti\u0006$XM\u0003\u0002\u001d;\u0005!A.\u001b8l\u0015\tqr$\u0001\u0004tKJ4XM\u001d\u0006\u0002A\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u0006I\u0001/\u0019:uSRLwN\\\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011afH\u0001\bG2,8\u000f^3s\u0013\t\u0001TFA\u0005QCJ$\u0018\u000e^5p]\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002)1\f7\u000f^#q_\u000eDW\u000b\u001d3bi\u0016\u001cF/\u0019;f+\u0005!\u0004CA\u001b7\u001b\u0005Y\u0012BA\u001c\u001c\u0005A)\u0005o\\2i+B$\u0017\r^3Ti\u0006$X-\u0001\rmCN$X\t]8dQV\u0003H-\u0019;f'R\fG/Z0%KF$\"AO\u001f\u0011\u0005\u0011Z\u0014B\u0001\u001f&\u0005\u0011)f.\u001b;\t\u000fy\"\u0011\u0011!a\u0001i\u0005\u0019\u0001\u0010J\u0019\u0002+1\f7\u000f^#q_\u000eDW\u000b\u001d3bi\u0016\u001cF/\u0019;fA!\u0012Q!\u0011\t\u0003I\tK!aQ\u0013\u0003\u0011Y|G.\u0019;jY\u0016\fa\u0001P5oSRtDc\u0001$H\u0011B\u0011Q\u0007\u0001\u0005\u0006S\u0019\u0001\ra\u000b\u0005\u0006e\u0019\u0001\r\u0001N\u0001\u0015g>,(oY3MK\u0006$WM]!oI\u0016\u0003xn\u00195\u0016\u0003-\u0003\"\u0001T1\u000f\u00055sfB\u0001(\\\u001d\ty\u0015L\u0004\u0002Q-:\u0011\u0011\u000bV\u0007\u0002%*\u00111+I\u0001\u0007yI|w\u000e\u001e \n\u0003U\u000b1a\u001c:h\u0013\t9\u0006,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+&\u0011\u0001E\u0017\u0006\u0003/bK!\u0001X/\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0001EW\u0005\u0003?\u0002\f\u0001\"T3uC\u0012\fG/\u0019\u0006\u00039vK!AY2\u0003\u001d1+\u0017\rZ3s\u0003:$W\t]8dQ*\u0011q\fY\u0001\u0019g>,(oY3MK\u0006$WM]!oI\u0016\u0003xn\u00195`I\u0015\fHC\u0001\u001eg\u0011\u001dq\u0004\"!AA\u0002-\u000bQc]8ve\u000e,G*Z1eKJ\fe\u000eZ#q_\u000eD\u0007%\u0001\bgC&dWO]3Ti\u0006\u0014H/T:\u0016\u0003)\u0004\"a\u001b;\u000e\u00031T!!\u001c8\u0002\r\u0005$x.\\5d\u0015\ty\u0007/\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001d:\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0006!!.\u0019<b\u0013\t)HN\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fqBZ1jYV\u0014Xm\u0015;beRl5\u000fI\u0001\u0010Y\u0006\u001cHOR1jYV\u0014X\rV=qKV\t\u0011\u0010E\u0002%urL!a_\u0013\u0003\r=\u0003H/[8o!\t)T0\u0003\u0002\u007f7\t\tR*\u001b:s_J4\u0015-\u001b7ve\u0016$\u0016\u0010]3\u0002'1\f7\u000f\u001e$bS2,(/\u001a+za\u0016|F%Z9\u0015\u0007i\n\u0019\u0001C\u0004?\u001b\u0005\u0005\t\u0019A=\u0002!1\f7\u000f\u001e$bS2,(/\u001a+za\u0016\u0004\u0003F\u0001\bB\u00039\t\u0007/\u001b$bS2,(/\u001a+za\u0016\f!#\u00199j\r\u0006LG.\u001e:f)f\u0004Xm\u0018\u0013fcR\u0019!(a\u0004\t\u000fy\u0002\u0012\u0011!a\u0001s\u0006y\u0011\r]5GC&dWO]3UsB,\u0007\u0005\u000b\u0002\u0012\u0003\u0006Qa-\u001a;dQN#\u0018\r^3\u0016\u0005\u0005e\u0001\u0003\u0002\u0013{\u00037\u00012!NA\u000f\u0013\r\tyb\u0007\u0002\u000b\r\u0016$8\r[*uCR,\u0017A\u00044fi\u000eD7\u000b^1uK~#S-\u001d\u000b\u0004u\u0005\u0015\u0002\u0002\u0003 \u0014\u0003\u0003\u0005\r!!\u0007\u0002\u0017\u0019,Go\u00195Ti\u0006$X\r\t\u0015\u0003)\u0005\u000b\u0001#\u001e9eCR,W\t]8dQN#\u0018\r^3\u0015\t\u0005=\u0012Q\u0007\t\u0004I\u0005E\u0012bAA\u001aK\t9!i\\8mK\u0006t\u0007BBA\u001c+\u0001\u00071*\u0001\bmK\u0006$WM]!oI\u0016\u0003xn\u00195\u0002\u001b=tG*\u001b8l\r\u0006LG.\u001e:f)!\ti$a\u0011\u0002H\u0005-\u0003c\u0001\u0013\u0002@%\u0019\u0011\u0011I\u0013\u0003\t1{gn\u001a\u0005\u0007\u0003\u000b2\u0002\u0019\u0001?\u0002\u0017\u0019\f\u0017\u000e\\;sKRK\b/\u001a\u0005\b\u0003\u00132\u0002\u0019AA\u001f\u0003\rqwn\u001e\u0005\b\u0003\u001b2\u0002\u0019AA(\u00039\u0011X\r\u001e:z)&lWm\\;u\u001bN\u00042\u0001JA)\u0013\r\t\u0019&\n\u0002\u0004\u0013:$\u0018!\u0005:fg\u0016$X\t]8dQV\u0003H-\u0019;fgR\t!(\u0001\tdY\u0016\f'\u000fT5oW\u001a\u000b\u0017\u000e\\;sKR!\u0011qFA/\u0011\u001d\ty\u0006\u0007a\u0001\u0003_\tQ\u0002[1t\u001d\u0016<(+Z2pe\u0012\u001c\u0018aC7jeJ|'o\u0015;bi\u0016$b!!\u001a\u0002~\u0005=\u0005\u0003BA4\u0003orA!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0004sKBd\u0017nY1\u000b\u0007\u0005ET,\u0001\u0004d_6lwN\\\u0005\u0005\u0003k\nY'A\u0007SKBd\u0017nY1Ti\u0006$Xo]\u0005\u0005\u0003s\nYH\u0001\u0006NSJ\u0014xN]%oM>TA!!\u001e\u0002l!9\u0011qP\rA\u0002\u0005\u0005\u0015!\u00069feNL7\u000f^3oi6K'O]8s'R\fG/\u001a\t\u0005\u0003\u0007\u000bII\u0004\u0003\u0002h\u0005\u0015\u0015\u0002BAD\u0003w\n!\"T5se>\u0014\u0018J\u001c4p\u0013\u0011\tY)!$\u0003\u000bM#\u0018\r^3\u000b\t\u0005\u001d\u00151\u0010\u0005\b\u0003#K\u0002\u0019AAJ\u0003U\tg/Y5mC\nLG.\u001b;z\u000bb\u001cW\r\u001d;j_:\u0004B\u0001\n>\u0002\u0016B!\u0011qSAO\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006=\u0014AB3se>\u00148/\u0003\u0003\u0002 \u0006e%\u0001D!qS\u0016C8-\u001a9uS>t\u0007")
public class PartitionAndState {
    private final Partition partition;
    private volatile EpochUpdateState lastEpochUpdateState;
    private Metadata.LeaderAndEpoch sourceLeaderAndEpoch;
    private final AtomicLong failureStartMs;
    private volatile Option<MirrorFailureType> lastFailureType;
    private volatile Option<MirrorFailureType> apiFailureType;
    private volatile Option<FetchState> fetchState;

    public Partition partition() {
        return this.partition;
    }

    public EpochUpdateState lastEpochUpdateState() {
        return this.lastEpochUpdateState;
    }

    public void lastEpochUpdateState_$eq(EpochUpdateState x$1) {
        this.lastEpochUpdateState = x$1;
    }

    public Metadata.LeaderAndEpoch sourceLeaderAndEpoch() {
        return this.sourceLeaderAndEpoch;
    }

    public void sourceLeaderAndEpoch_$eq(Metadata.LeaderAndEpoch x$1) {
        this.sourceLeaderAndEpoch = x$1;
    }

    public AtomicLong failureStartMs() {
        return this.failureStartMs;
    }

    public Option<MirrorFailureType> lastFailureType() {
        return this.lastFailureType;
    }

    public void lastFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.lastFailureType = x$1;
    }

    public Option<MirrorFailureType> apiFailureType() {
        return this.apiFailureType;
    }

    public void apiFailureType_$eq(Option<MirrorFailureType> x$1) {
        this.apiFailureType = x$1;
    }

    public Option<FetchState> fetchState() {
        return this.fetchState;
    }

    public void fetchState_$eq(Option<FetchState> x$1) {
        this.fetchState = x$1;
    }

    public boolean updateEpochState(Metadata.LeaderAndEpoch leaderAndEpoch) {
        BooleanRef updated = BooleanRef.create((boolean)false);
        leaderAndEpoch.epoch.ifPresent(currentEpoch -> {
            Option<Object> option;
            EpochUpdateState epochUpdateState = this.lastEpochUpdateState();
            if (epochUpdateState != null) {
                Option<Object> option2 = epochUpdateState.sourceEpoch();
                int lastEmptyUpdates = epochUpdateState.numEmptyEpochUpdates();
                if (option2 instanceof Some) {
                    int lastEpoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    if (Predef$.MODULE$.Integer2int(currentEpoch) <= lastEpoch) return;
                    this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), lastEmptyUpdates + 1));
                    updated$1.elem = true;
                    return;
                }
            }
            if (epochUpdateState == null || !None$.MODULE$.equals(option = epochUpdateState.sourceEpoch())) throw new MatchError((Object)epochUpdateState);
            this.lastEpochUpdateState_$eq(new EpochUpdateState((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(currentEpoch))), 1));
            updated$1.elem = true;
        });
        return updated.elem;
    }

    public long onLinkFailure(MirrorFailureType failureType, long now, int retryTimeoutMs) {
        long remainingRetryMs;
        Option<MirrorFailureType> lastFailureType = this.lastFailureType();
        this.lastFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        if (failureType.persistFailure() && !lastFailureType.exists((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.persistFailure()))) {
            this.failureStartMs().set(now);
        } else {
            this.failureStartMs().compareAndSet(0L, now);
        }
        long l = remainingRetryMs = failureType.retriable() ? this.failureStartMs().get() + (long)retryTimeoutMs - now : 0L;
        if (remainingRetryMs <= 0L || !failureType.retriable()) {
            this.apiFailureType_$eq((Option<MirrorFailureType>)new Some((Object)failureType));
        }
        return remainingRetryMs;
    }

    public void resetEpochUpdates() {
        this.lastEpochUpdateState_$eq(new EpochUpdateState(this.lastEpochUpdateState().sourceEpoch(), 0));
    }

    public boolean clearLinkFailure(boolean hasNewRecords) {
        if (hasNewRecords && this.lastEpochUpdateState().numEmptyEpochUpdates() > 0) {
            this.resetEpochUpdates();
        }
        this.apiFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        this.lastFailureType_$eq((Option<MirrorFailureType>)None$.MODULE$);
        return this.failureStartMs().getAndSet(0L) != 0L;
    }

    public ReplicaStatus.MirrorInfo mirrorState(ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<ApiException> availabilityException) {
        ReplicaStatus.MirrorInfo.State state;
        None$ none$;
        Option<MirrorFailureType> option = this.apiFailureType();
        if (option instanceof Some) {
            none$ = this.apiFailureType();
        } else if (None$.MODULE$.equals(option)) {
            none$ = this.lastEpochUpdateState().numEmptyEpochUpdates() > MirrorFailureType$NoSourceRecords$.MODULE$.ConsecutiveEpochChangeLowerThreshold() ? new Some((Object)MirrorFailureType$NoSourceRecords$.MODULE$) : None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Option<FetchState> currentFetchState = this.fetchState();
        if (ReplicaStatus.MirrorInfo.State.ACTIVE.equals(persistentMirrorState)) {
            ReplicaStatus.MirrorInfo.State state2;
            ReplicaStatus.MirrorInfo.State state3;
            Option option2 = none$.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.replicaStatusState());
            boolean bl = option2 instanceof Some && ReplicaStatus.MirrorInfo.State.ACTIVE.equals(state3 = (ReplicaStatus.MirrorInfo.State)((Some)option2).value()) ? true : None$.MODULE$.equals(option2);
            if (bl) {
                ReplicaStatus.MirrorInfo.State state4;
                if (availabilityException instanceof Some) {
                    ApiException e = (ApiException)((Object)((Some)availabilityException).value());
                    state4 = (ReplicaStatus.MirrorInfo.State)MirrorFailureType$.MODULE$.failureType(e).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.replicaStatusState()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ReplicaStatus.MirrorInfo.State.ACTIVE);
                } else {
                    state4 = ReplicaStatus.MirrorInfo.State.ACTIVE;
                }
                state2 = state4;
            } else if (option2 instanceof Some) {
                state2 = (ReplicaStatus.MirrorInfo.State)((Some)option2).value();
            } else {
                throw new MatchError((Object)option2);
            }
            state = state2;
        } else {
            state = persistentMirrorState;
        }
        return new ReplicaStatus.MirrorInfo(state, BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)x$24.lastFetchTimeMs())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)), BoxesRunTime.unboxToLong((Object)currentFetchState.map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25.lastFetchHighWatermark())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
    }

    public PartitionAndState(Partition partition, EpochUpdateState lastEpochUpdateState) {
        this.partition = partition;
        this.lastEpochUpdateState = lastEpochUpdateState;
        this.sourceLeaderAndEpoch = Metadata.LeaderAndEpoch.noLeaderOrEpoch();
        this.failureStartMs = new AtomicLong();
        this.lastFailureType = None$.MODULE$;
        this.apiFailureType = None$.MODULE$;
        this.fetchState = None$.MODULE$;
    }
}

