/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.List;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.TopicConfigSyncIncludeValidator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;

public final class TopicConfigSyncIncludeValidator$ {
    public static TopicConfigSyncIncludeValidator$ MODULE$;
    private final TopicConfigSyncIncludeValidator VALIDATOR;

    static {
        new TopicConfigSyncIncludeValidator$();
    }

    public TopicConfigSyncIncludeValidator VALIDATOR() {
        return this.VALIDATOR;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> validate(List<String> value) {
        void var2_2;
        Set topicConfigs = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(value).asScala()).toSet();
        this.checkUnknownTopicConfigs((Set<String>)topicConfigs);
        this.checkAlwaysConfigs((Set<String>)topicConfigs);
        this.checkIndependentConfigs((Set<String>)topicConfigs);
        return var2_2;
    }

    private void checkUnknownTopicConfigs(Set<String> configs) {
        Set diff = (Set)configs.$minus$minus(MirrorTopicConfigSyncRules$.MODULE$.AllConfigs());
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(79).append("Invalid topic configs specified in ").append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(": ").append(diff.mkString(",")).append(". Please use the common topic config name.").toString());
        }
    }

    private void checkAlwaysConfigs(Set<String> configs) {
        Set diff = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$minus$minus(configs);
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(113).append("To make cluster linking function properly, ").append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(" ").append("must include these topic configs: ").append(MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().mkString(",")).append(" ").append("\nThese topic configs are missing: ").append(diff.mkString(",")).toString());
        }
    }

    private void checkIndependentConfigs(Set<String> configs) {
        Set inter = (Set)configs.intersect(MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs());
        if (inter.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(110).append("To make cluster linking function properly, ").append(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp()).append(" ").append("cannot include these topic configs: ").append(MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs().mkString(",")).append(" ").append("\nRemove these topic configs: ").append(inter.mkString(",")).toString());
        }
    }

    private TopicConfigSyncIncludeValidator$() {
        MODULE$ = this;
        this.VALIDATOR = new TopicConfigSyncIncludeValidator();
    }
}

