/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.SegmentDeleteComplete;
import kafka.tier.state.OffsetAndEpoch;

public class TierSegmentDeleteComplete
extends AbstractTierSegmentMetadata {
    private static final byte VERSION_V1 = 1;
    private static final byte CURRENT_VERSION = 1;
    private static final int INITIAL_BUFFER_SIZE = 64;
    private final TopicIdPartition topicIdPartition;
    private final SegmentDeleteComplete metadata;

    public TierSegmentDeleteComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, Optional<OffsetAndEpoch> stateOffsetAndEpoch) {
        FlatBufferBuilder builder = new FlatBufferBuilder(64).forceDefaults(true);
        SegmentDeleteComplete.startSegmentDeleteComplete(builder);
        SegmentDeleteComplete.addVersion(builder, (byte)1);
        SegmentDeleteComplete.addTierEpoch(builder, tierEpoch);
        stateOffsetAndEpoch.ifPresent(offsetAndEpoch -> {
            int offsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, offsetAndEpoch.offset(), offsetAndEpoch.epoch().orElse(-1));
            SegmentDeleteComplete.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        });
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentDeleteComplete.addObjectId(builder, objectIdOffset);
        int entryId = SegmentDeleteComplete.endSegmentDeleteComplete(builder);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentDeleteComplete.getRootAsSegmentDeleteComplete(builder.dataBuffer());
    }

    public TierSegmentDeleteComplete(TopicIdPartition topicIdPartition, SegmentDeleteComplete metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public TierSegmentDeleteComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset) {
        this(topicIdPartition, tierEpoch, objectId, Optional.of(stateOffset));
    }

    public static int initialBufferSize() {
        return 64;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentDeleteComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE;
    }

    @Override
    public UUID messageId() {
        kafka.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String toString() {
        return "TierSegmentDeleteComplete(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ")";
    }
}

