/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.InitLeader;
import kafka.tier.state.OffsetAndEpoch;

public class TierTopicInitLeader
extends AbstractTierMetadata {
    private static final byte VERSION_V0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private static final int INITIAL_BUFFER_SIZE = 48;
    private final TopicIdPartition topicIdPartition;
    private final InitLeader metadata;

    public TierTopicInitLeader(TopicIdPartition topicIdPartition, int tierEpoch, UUID messageId, int brokerId) {
        if (tierEpoch < 0) {
            throw new IllegalArgumentException("Illegal tierEpoch: " + tierEpoch);
        }
        this.topicIdPartition = topicIdPartition;
        FlatBufferBuilder builder = new FlatBufferBuilder(TierTopicInitLeader.initialBufferSize()).forceDefaults(true);
        InitLeader.startInitLeader(builder);
        int messageIdOffset = kafka.tier.serdes.UUID.createUUID(builder, messageId.getMostSignificantBits(), messageId.getLeastSignificantBits());
        InitLeader.addMessageId(builder, messageIdOffset);
        InitLeader.addTierEpoch(builder, tierEpoch);
        InitLeader.addBrokerId(builder, brokerId);
        InitLeader.addVersion(builder, (byte)0);
        int entryId = InitLeader.endInitLeader(builder);
        builder.finish(entryId);
        this.metadata = InitLeader.getRootAsInitLeader(builder.dataBuffer());
    }

    public TierTopicInitLeader(TopicIdPartition topicIdPartition, InitLeader metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 48;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.InitLeader;
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        return new UUID(this.metadata.messageId().mostSignificantBits(), this.metadata.messageId().leastSignificantBits());
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return OffsetAndEpoch.EMPTY;
    }

    private byte version() {
        return this.metadata.version();
    }

    public int brokerId() {
        return this.metadata.brokerId();
    }

    public String toString() {
        return "TierInitLeader(version=" + this.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", messageIdAsBase64=" + this.messageIdAsBase64() + ", brokerId=" + this.brokerId() + ")";
    }
}

