/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import kafka.server.KafkaConfig;
import kafka.tier.store.TierObjectStoreConfig;
import scala.compat.java8.OptionConverters;

public class AzureBlockBlobTierObjectStoreConfig
extends TierObjectStoreConfig {
    public Optional<AzureCredentialsConfig> azureCredentialsConfig;
    public Optional<String> endpoint;
    public String container;
    public String azureBlobPrefix;
    public int drainThreshold;

    public AzureBlockBlobTierObjectStoreConfig(Optional<String> clusterIdOpt, KafkaConfig config) {
        super(clusterIdOpt, config);
        this.validateConfig(config);
        this.azureCredentialsConfig = this.readAzureCredentialsConfig(config);
        this.endpoint = OptionConverters.toJava(config.tierAzureBlockBlobEndpoint());
        this.container = config.tierAzureBlockBlobContainer();
        this.azureBlobPrefix = config.tierAzureBlockBlobPrefix();
        this.drainThreshold = config.tierAzureBlockBlobConnectionDrainSize();
    }

    private void validateConfig(KafkaConfig config) {
        if (config.tierAzureBlockBlobCredFilePath().isEmpty() && config.tierAzureBlockBlobEndpoint().isEmpty()) {
            throw new IllegalArgumentException("At least one of " + KafkaConfig.TierAzureBlockBlobCredFilePathProp() + " or " + KafkaConfig.TierAzureBlockBlobEndpointProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to Azure.");
        }
        if (config.tierAzureBlockBlobContainer() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierAzureBlockBlobContainerProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to Azure.");
        }
    }

    private Optional<AzureCredentialsConfig> readAzureCredentialsConfig(KafkaConfig config) {
        Optional azureBlockBlobCredFilePath = OptionConverters.toJava(config.tierAzureBlockBlobCredFilePath());
        if (!azureBlockBlobCredFilePath.isPresent()) {
            return Optional.empty();
        }
        AzureCredentialsConfig azureCredentials = AzureBlockBlobTierObjectStoreConfig.readCredFilePath((String)azureBlockBlobCredFilePath.get());
        if (!azureCredentials.connectionStringAuthMethod().booleanValue() && !azureCredentials.servicePrincipalWithSecretAuthMethod().booleanValue()) {
            throw new IllegalArgumentException("No credentials found in file: " + (String)azureBlockBlobCredFilePath.get() + ". One of connectionString or (azureClientId + azureTenantId + azureClientSecret) must be supplied");
        }
        if (azureCredentials.connectionString() != null && (azureCredentials.azureClientId() != null || azureCredentials.azureTenantId() != null || azureCredentials.azureClientSecret() != null)) {
            throw new IllegalArgumentException("Only one of connectionString or (azureClientId + azureTenantId + azureClientSecret) can be set in file " + (String)azureBlockBlobCredFilePath.get());
        }
        if (azureCredentials.servicePrincipalWithSecretAuthMethod().booleanValue() && config.tierAzureBlockBlobEndpoint().isEmpty()) {
            throw new IllegalArgumentException(KafkaConfig.TierAzureBlockBlobEndpointProp() + " must be specified when authenticating using a service principal with secret in file: " + (String)azureBlockBlobCredFilePath.get());
        }
        if (azureCredentials.connectionStringAuthMethod().booleanValue() && !config.tierAzureBlockBlobEndpoint().isEmpty()) {
            throw new IllegalArgumentException(KafkaConfig.TierAzureBlockBlobEndpointProp() + " should not be set when using a connection string in file: " + (String)azureBlockBlobCredFilePath.get());
        }
        return Optional.of(azureCredentials);
    }

    private static AzureCredentialsConfig readCredFilePath(String azureBlockBlobCredFilePath) {
        try {
            FileReader reader = new FileReader(azureBlockBlobCredFilePath);
            ObjectMapper objectMapper = new ObjectMapper();
            return (AzureCredentialsConfig)objectMapper.readValue((Reader)reader, AzureCredentialsConfig.class);
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Failed to get credential from file: " + azureBlockBlobCredFilePath, ioException);
        }
    }

    static class AzureCredentialsConfig {
        private String connectionString;
        private String azureClientId;
        private String azureTenantId;
        private String azureClientSecret;

        @JsonCreator
        public AzureCredentialsConfig(@JsonProperty(value="connectionString") String connectionString, @JsonProperty(value="azureClientId") String azureClientId, @JsonProperty(value="azureTenantId") String azureTenantId, @JsonProperty(value="azureClientSecret") String azureClientSecret) {
            this.connectionString = connectionString;
            this.azureClientId = azureClientId;
            this.azureTenantId = azureTenantId;
            this.azureClientSecret = azureClientSecret;
        }

        @JsonProperty
        public String connectionString() {
            return this.connectionString;
        }

        @JsonProperty
        public String azureClientId() {
            return this.azureClientId;
        }

        @JsonProperty
        public String azureTenantId() {
            return this.azureTenantId;
        }

        @JsonProperty
        public String azureClientSecret() {
            return this.azureClientSecret;
        }

        public Boolean connectionStringAuthMethod() {
            return this.connectionString != null;
        }

        public Boolean servicePrincipalWithSecretAuthMethod() {
            return this.azureClientId != null && this.azureTenantId != null && this.azureClientSecret != null;
        }
    }
}

