/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.time.Duration;
import java.util.Optional;
import kafka.server.KafkaConfig;
import kafka.tier.store.TierObjectStoreConfig;
import scala.compat.java8.OptionConverters;

public class GcsTierObjectStoreConfig
extends TierObjectStoreConfig {
    public String gcsBucket;
    public String gcsPrefix;
    public String gcsRegion;
    public Integer gcsWriteChunkSize;
    public Optional<String> gcsCredFilePath;
    public String gcsSseCustomerEncryptionKey;
    public Duration encryptionKeyManagerKeyRotationInterval;

    public GcsTierObjectStoreConfig(Optional<String> clusterIdOpt, KafkaConfig config) {
        super(clusterIdOpt, config);
        this.validateConfig(config);
        this.gcsBucket = config.tierGcsBucket();
        this.gcsRegion = config.tierGcsRegion();
        this.gcsPrefix = config.tierGcsPrefix();
        this.gcsWriteChunkSize = config.tierGcsWriteChunkSize();
        this.gcsCredFilePath = OptionConverters.toJava(config.tierGcsCredFilePath());
        this.gcsSseCustomerEncryptionKey = config.gcsSseCustomerEncryptionKey();
        this.encryptionKeyManagerKeyRotationInterval = Duration.ofMillis(config.encryptionKeyManagerKeyRotationIntervalMs());
    }

    protected GcsTierObjectStoreConfig(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt, String bucket, String prefix, String region, Integer writeChunkSize, String credFilePath, String gcsSseCustomerEncryptionKey, Duration encryptionKeyManagerKeyRotationInterval) {
        super(clusterIdOpt, brokerIdOpt);
        this.gcsBucket = bucket;
        this.gcsRegion = region;
        this.gcsPrefix = prefix;
        this.gcsWriteChunkSize = writeChunkSize;
        this.gcsCredFilePath = Optional.ofNullable(credFilePath);
        this.gcsSseCustomerEncryptionKey = gcsSseCustomerEncryptionKey;
        this.encryptionKeyManagerKeyRotationInterval = encryptionKeyManagerKeyRotationInterval;
    }

    public static GcsTierObjectStoreConfig createWithEmptyClusterIdBrokerId(String bucket, String prefix, String region, Integer writeChunkSize, String credFilePath, String gcsSseCustomerEncryptionKey, Duration encryptionKeyManagerKeyRotationInterval) {
        return new GcsTierObjectStoreConfig(Optional.empty(), Optional.empty(), bucket, prefix, region, writeChunkSize, credFilePath, gcsSseCustomerEncryptionKey, encryptionKeyManagerKeyRotationInterval);
    }

    private void validateConfig(KafkaConfig config) {
        if (config.tierGcsRegion() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierGcsRegionProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to GCS.");
        }
        if (config.tierGcsBucket() == null) {
            throw new IllegalArgumentException(KafkaConfig.TierGcsBucketProp() + " must be set if " + KafkaConfig.TierBackendProp() + " property is set to GCS.");
        }
    }
}

