/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.TierTask;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h!\u0002\u000f\u001e\u0003\u0003!\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\u0006%\u0002!\ta\u0015\u0005\u0006I\u0002!\t%\u001a\u0005\b=\u0001\u0001\r\u0011\"\u0003r\u0011\u001dQ\b\u00011A\u0005\nmDq!a\u0001\u0001A\u0003&!\u000fC\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A\u0011q\u0006\u0001!\u0002\u0013\t\t\u0002\u0003\u0005\u00022\u0001\u0001\r\u0011\"\u0003r\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)\u0004C\u0004\u0002:\u0001\u0001\u000b\u0015\u0002:\t\u0011\u0005m\u0002\u0001\"\u0005\u001e\u0003{A\u0001\"a\u0010\u0001\r#i\u0012\u0011\t\u0005\t\u0003/\u0002a\u0011C\u000f\u0002Z!A\u0011\u0011\u000e\u0001\u0007\u0012u\tY\u0007C\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a2\u0001\t\u0003\tI\rC\u0004\u0002L\u0002!\t%!4\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9\u0011Q\u001b\u0001\u0005\n\u0005]'!\u0004+jKJ$\u0016m]6Rk\u0016,XM\u0003\u0002\u001f?\u0005)A/Y:lg*\u0011\u0001%I\u0001\u0005i&,'OC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"!\n-\u0014\t\u00011CF\r\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\n\u0013!B;uS2\u001c\u0018BA\u0019/\u0005\u001daunZ4j]\u001e\u0004\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\t1\fgn\u001a\u0006\u0002o\u0005!!.\u0019<b\u0013\tIDGA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\u0004GRD\bC\u0001\u001f@\u001b\u0005i$B\u0001  \u0003\u001d1W\r^2iKJL!\u0001Q\u001f\u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u00115\f\u0007\u0010V1tWN\u0004\"aJ\"\n\u0005\u0011C#aA%oi\u0006!A/[7f!\t9\u0005+D\u0001I\u0015\ty\u0013J\u0003\u0002K\u0017\u000611m\\7n_:T!A\t'\u000b\u00055s\u0015AB1qC\u000eDWMC\u0001P\u0003\ry'oZ\u0005\u0003#\"\u0013A\u0001V5nK\u00061A(\u001b8jiz\"B\u0001V1cGB\u0019Q\u000b\u0001,\u000e\u0003u\u0001\"a\u0016-\r\u0001\u0011)\u0011\f\u0001b\u00015\n\tA+\u0005\u0002\\=B\u0011q\u0005X\u0005\u0003;\"\u0012qAT8uQ&tw\rE\u0002V?ZK!\u0001Y\u000f\u0003\u0011QKWM\u001d+bg.DQA\u000f\u0003A\u0002mBQ!\u0011\u0003A\u0002\tCQ!\u0012\u0003A\u0002\u0019\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u00051\u0007CA4o\u001d\tAG\u000e\u0005\u0002jQ5\t!N\u0003\u0002lG\u00051AH]8pizJ!!\u001c\u0015\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[\"*\u0012A\u001d\t\u0004gb4V\"\u0001;\u000b\u0005U4\u0018!C5n[V$\u0018M\u00197f\u0015\t9\b&\u0001\u0006d_2dWm\u0019;j_:L!!\u001f;\u0003\u000f1K7\u000f^*fi\u0006IA/Y:lg~#S-\u001d\u000b\u0003y~\u0004\"aJ?\n\u0005yD#\u0001B+oSRD\u0001\"!\u0001\b\u0003\u0003\u0005\rA]\u0001\u0004q\u0012\n\u0014A\u0002;bg.\u001c\b\u0005K\u0002\t\u0003\u000f\u00012aJA\u0005\u0013\r\tY\u0001\u000b\u0002\tm>d\u0017\r^5mK\u0006\t\u0002/\u0019:uSRLwN\\:J]\u0016\u0013(o\u001c:\u0016\u0005\u0005E\u0001\u0003CA\n\u0003;\t\t#!\u000b\u000e\u0005\u0005U!\u0002BA\f\u00033\t!bY8oGV\u0014(/\u001a8u\u0015\r\tYBN\u0001\u0005kRLG.\u0003\u0003\u0002 \u0005U!!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u00111EA\u0013\u001b\u0005y\u0012bAA\u0014?\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0004O\u0005-\u0012bAA\u0017Q\t!Aj\u001c8h\u0003I\u0001\u0018M\u001d;ji&|gn]%o\u000bJ\u0014xN\u001d\u0011\u0002\u0015A\u0014xnY3tg&tw-\u0001\bqe>\u001cWm]:j]\u001e|F%Z9\u0015\u0007q\f9\u0004\u0003\u0005\u0002\u00021\t\t\u00111\u0001s\u0003-\u0001(o\\2fgNLgn\u001a\u0011\u0002'\u0015\u0014(o\u001c:QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0015\u0003\t\u000b\u0011b]8siR\u000b7o[:\u0015\t\u0005\r\u0013Q\u000b\t\u0006\u0003\u000b\nyE\u0016\b\u0005\u0003\u000f\nYED\u0002j\u0003\u0013J\u0011!K\u0005\u0004\u0003\u001bB\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003#\n\u0019F\u0001\u0003MSN$(bAA'Q!1ad\u0004a\u0001\u0003\u0007\nqA\\3x)\u0006\u001c8\u000eF\u0003W\u00037\ny\u0006C\u0004\u0002^A\u0001\r!!\t\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBA1!\u0001\u0007\u00111M\u0001\t[\u0016$\u0018\rZ1uCB\u0019Q+!\u001a\n\u0007\u0005\u001dTDA\nTi\u0006\u0014Ho\u00115b]\u001e,W*\u001a;bI\u0006$\u0018-\u0001\u0006nCf\u0004&o\\2fgN$B!!\u001c\u0002tA\u0019q%a\u001c\n\u0007\u0005E\u0004FA\u0004C_>dW-\u00198\t\u000f\u0005\u0005\u0014\u00031\u0001\u0002vA\u0019Q+a\u001e\n\u0007\u0005eTD\u0001\bDQ\u0006tw-Z'fi\u0006$\u0017\r^1\u0002\u00195\f\u0017PY3BI\u0012$\u0016m]6\u0015\u0007q\fy\bC\u0004\u0002bI\u0001\r!a\u0019\u0002\u001f5\f\u0017PY3SK6|g/\u001a+bg.$2\u0001`AC\u0011\u001d\t\tg\u0005a\u0001\u0003\u000f\u00032!VAE\u0013\r\tY)\b\u0002\u0013'R|\u0007o\u00115b]\u001e,W*\u001a;bI\u0006$\u0018-\u0001\u0003q_2dGCAAI!\u00159\u00131SA\"\u0013\r\t)\n\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0002\t\u0011|g.\u001a\u000b\u0004y\u0006m\u0005BBAO+\u0001\u0007a+\u0001\u0003uCN\\\u0017!\u0003;bg.\u001cu.\u001e8u+\u0005\u0011\u0015\u0001D<ji\"\fE\u000e\u001c+bg.\u001cX\u0003BAT\u0003W#B!!+\u00028B\u0019q+a+\u0005\u000f\u00055vC1\u0001\u00020\n\tQ+E\u0002\\\u0003c\u00032aJAZ\u0013\r\t)\f\u000b\u0002\u0004\u0003:L\bbBA]/\u0001\u0007\u00111X\u0001\u0003M:\u0004raJA_\u0003\u0003\fI+C\u0002\u0002@\"\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u001d\f\u0019MV\u0005\u0004\u0003\u000b\u0004(aA*fi\u0006)1\r\\8tKR\tA0\u0001\u0005u_N#(/\u001b8h)\u00051\u0017A\u0002:f[>4X\rF\u0002}\u0003'Dq!!\u0018\u001b\u0001\u0004\t\t#\u0001\u0005gS:$G+Y:l)\u0019\tI.a7\u0002^B!q%a%W\u0011\u001d\tif\u0007a\u0001\u0003CAa!a8\u001c\u0001\u0004\u0011\u0018!B9vKV,\u0007")
public abstract class TierTaskQueue<T extends TierTask<T>>
implements Logging,
AutoCloseable {
    private final CancellationContext ctx;
    private final int maxTasks;
    private final Time time;
    private volatile ListSet<T> tasks;
    private final ConcurrentHashMap<TopicIdPartition, Object> partitionsInError;
    private ListSet<T> processing;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    private ListSet<T> tasks() {
        return this.tasks;
    }

    private void tasks_$eq(ListSet<T> x$1) {
        this.tasks = x$1;
    }

    private ConcurrentHashMap<TopicIdPartition, Object> partitionsInError() {
        return this.partitionsInError;
    }

    private ListSet<T> processing() {
        return this.processing;
    }

    private void processing_$eq(ListSet<T> x$1) {
        this.processing = x$1;
    }

    public int errorPartitionCount() {
        return this.partitionsInError().size();
    }

    public abstract List<T> sortTasks(List<T> var1);

    public abstract T newTask(TopicIdPartition var1, StartChangeMetadata var2);

    public abstract boolean mayProcess(ChangeMetadata var1);

    public void maybeAddTask(StartChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
            this.tasks_$eq(this.tasks().$plus(this.newTask(metadata.topicIdPartition(), metadata)));
        }
    }

    public void maybeRemoveTask(StopChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
        }
    }

    public synchronized Option<List<T>> poll() {
        List<T> sorted;
        List eligibleTasks;
        Instant now = Instant.ofEpochMilli(this.time.hiResClockMs());
        int processingSpace = this.maxTasks - this.processing().size();
        if (processingSpace > 0 && (eligibleTasks = (List)this.tasks().toList().filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)TierTaskQueue.$anonfun$poll$1(this, now, task)))).nonEmpty() && (sorted = this.sortTasks(eligibleTasks)).nonEmpty()) {
            List tasks = sorted.take(processingSpace);
            this.processing_$eq(this.processing().$plus$plus((GenTraversableOnce)tasks));
            return new Some((Object)tasks);
        }
        return None$.MODULE$;
    }

    public synchronized void done(T task) {
        if (((TierTask)task).isErrorState()) {
            this.partitionsInError().put(((TierTask)task).topicIdPartition(), BoxesRunTime.boxToLong((long)this.time.milliseconds()));
        }
        if (!this.processing().contains(task)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("done task ").append(task).append(" not found in processing set").toString());
        }
        this.processing_$eq(this.processing().$minus(task));
        if (!this.tasks().contains(task)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("cancelling done task ").append(task).append(" due to it no longer being in the task set").toString());
            ((TierTask)task).ctx().cancel();
        }
        if (((TierTask)task).ctx().isCancelled()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("removing done task ").append(task).append(" from the task set").toString());
            this.tasks_$eq(this.tasks().$minus(task));
        }
    }

    public int taskCount() {
        return this.tasks().size();
    }

    public <U> U withAllTasks(Function1<Set<T>, U> fn) {
        return (U)fn.apply(this.tasks());
    }

    @Override
    public void close() {
        this.ctx.cancel();
    }

    public String toString() {
        return new StringBuilder(18).append("tasks=").append(this.tasks()).append(" processing=").append(this.processing()).toString();
    }

    private void remove(TopicIdPartition topicIdPartition) {
        this.findTask(topicIdPartition, this.tasks()).foreach((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToLong((long)TierTaskQueue.$anonfun$remove$1(this, topicIdPartition, task)));
    }

    private Option<T> findTask(TopicIdPartition topicIdPartition, ListSet<T> queue) {
        return queue.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TierTaskQueue.$anonfun$findTask$1(topicIdPartition, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$poll$1(TierTaskQueue $this, Instant now$1, TierTask task) {
        return !$this.processing().apply((Object)task) && task.pausedUntil().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)now$1.isAfter(x$1))) && !$this.partitionsInError().containsKey(task.topicIdPartition());
    }

    public static final /* synthetic */ long $anonfun$remove$1(TierTaskQueue $this, TopicIdPartition topicIdPartition$1, TierTask task) {
        task.ctx().cancel();
        $this.tasks_$eq($this.tasks().$minus((Object)task));
        $this.processing_$eq($this.processing().$minus((Object)task));
        return BoxesRunTime.unboxToLong((Object)$this.partitionsInError().remove(topicIdPartition$1));
    }

    public static final /* synthetic */ boolean $anonfun$findTask$1(TopicIdPartition topicIdPartition$2, TierTask x$2) {
        TopicIdPartition topicIdPartition = x$2.topicIdPartition();
        return !(topicIdPartition != null ? !((Object)topicIdPartition).equals(topicIdPartition$2) : topicIdPartition$2 != null);
    }

    public TierTaskQueue(CancellationContext ctx, int maxTasks, Time time) {
        this.ctx = ctx;
        this.maxTasks = maxTasks;
        this.time = time;
        Logging.$init$(this);
        this.tasks = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionsInError = new ConcurrentHashMap();
        this.processing = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

