/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFailedException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Defaults$;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-c\u0001B\u001a5\u0005uB\u0001B\u0013\u0001\u0003\u0006\u0004%\te\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005C\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003V\u0011!Q\u0006A!a\u0001\n\u0003Y\u0006\u0002C0\u0001\u0005\u0003\u0007I\u0011\u00011\t\u0011%\u0004!\u0011!Q!\nqC\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t]\u0002\u0011)\u0019!C\u0001_\"A1\u000f\u0001B\u0001B\u0003%\u0001\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0012\u0001!\t%a\u0005\t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0005bBAN\u0001\u0011\u0005\u0013QT\u0004\b\u0003?#\u0004\u0012AAQ\r\u0019\u0019D\u0007#\u0001\u0002$\"1A/\u0005C\u0001\u0003WCQa_\t\u0005RqDq!!,\u0012\t\u0003\ty\u000b\u0003\u0005\u0002>F!\t\u0001NA`\u0011!\ty-\u0005C\u0001i\u0005E\u0007\u0002CAw#\u0011\u0005A'a<\t\u0011\t\u0005\u0011\u0003\"\u00015\u0005\u0007A\u0001B!\t\u0012\t\u0003!$1\u0005\u0005\t\u0005\u001f\nB\u0011\u0001\u001b\u0003R!9!1O\t\u0005\n\tUdA\u0002B@#\u0001\u0013\t\tC\u0005\u0003\u001cr\u0011)\u001a!C\u0001y\"I!Q\u0014\u000f\u0003\u0012\u0003\u0006I! \u0005\u000b\u0005?c\"Q3A\u0005\u0002\t\u0005\u0006B\u0003B[9\tE\t\u0015!\u0003\u0003$\"1A\u000f\bC\u0001\u0005oC\u0011B!1\u001d\u0003\u0003%\tAa1\t\u0013\t%G$%A\u0005\u0002\t-\u0007\"\u0003Bh9E\u0005I\u0011\u0001Bi\u0011%\u0011)\u000eHA\u0001\n\u0003\u00129\u000e\u0003\u0005\u0003hr\t\t\u0011\"\u0001p\u0011%\u0011I\u000fHA\u0001\n\u0003\u0011Y\u000fC\u0005\u0003vr\t\t\u0011\"\u0011\u0003x\"I1Q\u0001\u000f\u0002\u0002\u0013\u00051q\u0001\u0005\n\u0007\u0017a\u0012\u0011!C!\u0007\u001bA\u0011ba\u0004\u001d\u0003\u0003%\te!\u0005\b\u0013\rU\u0011#!A\t\u0002\r]a!\u0003B@#\u0005\u0005\t\u0012AB\r\u0011\u0019!X\u0006\"\u0001\u0004(!I\u00111T\u0017\u0002\u0002\u0013\u00153\u0011\u0006\u0005\n\u0003[k\u0013\u0011!CA\u0007WA\u0011b!\r.\u0003\u0003%\tia\r\t\u0013\r\u0005S&!A\u0005\n\r\r#aC!sG\"Lg/\u001a+bg.T!!\u000e\u001c\u0002\u000f\u0005\u00148\r[5wK*\u0011q\u0007O\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003si\nA\u0001^5fe*\t1(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001qD\tE\u0002@\u0001\nk\u0011AN\u0005\u0003\u0003Z\u0012\u0001\u0002V5feR\u000b7o\u001b\t\u0003\u0007\u0002i\u0011\u0001\u000e\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fj\nQ!\u001e;jYNL!!\u0013$\u0003\u000f1{wmZ5oO\u0006\u00191\r\u001e=\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!a\u0014\u001d\u0002\u000f\u0019,Go\u00195fe&\u0011\u0011K\u0014\u0002\u0014\u0007\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u0001\u0005GRD\b%\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]V\tQ\u000b\u0005\u0002W/6\t\u0001(\u0003\u0002Yq\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\u0013!B:uCR,W#\u0001/\u0011\u0005\rk\u0016B\u000105\u0005A\t%o\u00195jm\u0016$\u0016m]6Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR\u0011\u0011m\u001a\t\u0003E\u0016l\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\u0005+:LG\u000fC\u0004i\r\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'\u0001\u0004ti\u0006$X\rI\u0001\u0010CJ\u001c\u0007.\u001b<fe6+GO]5dgB\u00111\t\\\u0005\u0003[R\u0012q\"\u0011:dQ&4XM]'fiJL7m]\u0001\tEJ|7.\u001a:JIV\t\u0001\u000f\u0005\u0002cc&\u0011!o\u0019\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u0019a\u0014N\\5u}Q1!I^<ysjDQAS\u0006A\u00021CQaU\u0006A\u0002UCQAW\u0006A\u0002qCQA[\u0006A\u0002-DQA\\\u0006A\u0002A\f!\u0002\\8hO\u0016\u0014h*Y7f+\u0005i\bc\u0001@\u0002\f9\u0019q0a\u0002\u0011\u0007\u0005\u00051-\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u001f\u0002\rq\u0012xn\u001c;?\u0013\r\tIaY\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%1-\u0001\u0006ue\u0006t7/\u001b;j_:$B\"!\u0006\u0002.\u0005%\u0013\u0011LA5\u0003s\"B!a\u0006\u0002$A)\u0011\u0011DA\u0010\u00056\u0011\u00111\u0004\u0006\u0004\u0003;\u0019\u0017AC2p]\u000e,(O]3oi&!\u0011\u0011EA\u000e\u0005\u00191U\u000f^;sK\"9\u0011QE\u0007A\u0004\u0005\u001d\u0012AA3d!\u0011\tI\"!\u000b\n\t\u0005-\u00121\u0004\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!a\f\u000e\u0001\u0004\t\t$\u0001\u0003uS6,\u0007\u0003BA\u001a\u0003\u000bj!!!\u000e\u000b\u0007\u001d\u000b9D\u0003\u0003\u0002:\u0005m\u0012AB2p[6|gNC\u0002<\u0003{QA!a\u0010\u0002B\u00051\u0011\r]1dQ\u0016T!!a\u0011\u0002\u0007=\u0014x-\u0003\u0003\u0002H\u0005U\"\u0001\u0002+j[\u0016Dq!a\u0013\u000e\u0001\u0004\ti%A\tuS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJ\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'B\u0014!\u0002;pa&\u001c\u0017\u0002BA,\u0003#\u0012\u0011\u0003V5feR{\u0007/[2BaB,g\u000eZ3s\u0011\u001d\tY&\u0004a\u0001\u0003;\nq\u0002^5fe>\u0013'.Z2u'R|'/\u001a\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111\r\u001d\u0002\u000bM$xN]3\n\t\u0005\u001d\u0014\u0011\r\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\"9\u00111N\u0007A\u0002\u00055\u0014A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111\u000f\u001e\u0002\rM,'O^3s\u0013\u0011\t9(!\u001d\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"I\u00111P\u0007\u0011\u0002\u0003\u0007\u0011QP\u0001\u0012[\u0006D(+\u001a;ss\n\u000b7m[8gM6\u001b\b\u0003\u00022\u0002\u0000AL1!!!d\u0005\u0019y\u0005\u000f^5p]\u0006!BO]1og&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIU*\"!a\"+\t\u0005u\u0014\u0011R\u0016\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0005v]\u000eDWmY6fI*\u0019\u0011QS2\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0006=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006AAo\\*ue&tw\rF\u0001~\u0003-\t%o\u00195jm\u0016$\u0016m]6\u0011\u0005\r\u000b2\u0003B\t\u0002&\u0012\u00032AYAT\u0013\r\tIk\u0019\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0005\u0016!B1qa2LHc\u0003\"\u00022\u0006M\u0016QWA]\u0003wCQA\u0013\u000bA\u00021CQa\u0015\u000bA\u0002UCa!a.\u0015\u0001\u0004\u0001\u0018a\u00037fC\u0012,'/\u00129pG\"DQA\u001b\u000bA\u0002-DQA\u001c\u000bA\u0002A\f\u0001c\u00195fG.4\u0015-\u001b7fIN#\u0018\r^3\u0015\u0011\u0005\u0005\u00171YAf\u0003\u001b\u0004R!!\u0007\u0002 qCaAW\u000bA\u0002\u0005\u0015\u0007cA\"\u0002H&\u0019\u0011\u0011\u001a\u001b\u0003\u0017\u0019\u000b\u0017\u000e\\3e'R\fG/\u001a\u0005\u0006'V\u0001\r!\u0016\u0005\b\u0003W*\u0002\u0019AA7\u0003M)7\u000f^1cY&\u001c\b\u000eT3bI\u0016\u00148\u000f[5q))\t\u0019.a8\u0002h\u0006%\u00181\u001e\u000b\u0005\u0003+\fi\u000e\u0005\u0004\u0002\u001a\u0005}\u0011q\u001b\t\u0004\u0007\u0006e\u0017bAAni\ta!)\u001a4pe\u0016,\u0006\u000f\\8bI\"9\u0011Q\u0005\fA\u0004\u0005\u001d\u0002B\u0002.\u0017\u0001\u0004\t\t\u000fE\u0002D\u0003GL1!!:5\u00051\u0011UMZ8sK2+\u0017\rZ3s\u0011\u0015\u0019f\u00031\u0001V\u0011\u001d\tYE\u0006a\u0001\u0003\u001bBQA\u001c\fA\u0002A\f1#\\1zE\u0016Le.\u001b;jCR,W\u000b\u001d7pC\u0012$b\"!=\u0002v\u0006]\u0018\u0011`A~\u0003{\fy\u0010\u0006\u0003\u0002B\u0006M\bbBA\u0013/\u0001\u000f\u0011q\u0005\u0005\u00075^\u0001\r!a6\t\u000bM;\u0002\u0019A+\t\u000f\u0005=r\u00031\u0001\u00022!9\u00111J\fA\u0002\u00055\u0003bBA./\u0001\u0007\u0011Q\f\u0005\b\u0003W:\u0002\u0019AA7\u0003\u0019)\b\u000f\\8bIRa!Q\u0001B\t\u00053\u0011YB!\b\u0003 Q!!q\u0001B\b!\u0019\tI\"a\b\u0003\nA\u00191Ia\u0003\n\u0007\t5AGA\u0006BMR,'/\u00169m_\u0006$\u0007bBA\u00131\u0001\u000f\u0011q\u0005\u0005\u00075b\u0001\rAa\u0005\u0011\u0007\r\u0013)\"C\u0002\u0003\u0018Q\u0012a!\u00169m_\u0006$\u0007\"B*\u0019\u0001\u0004)\u0006bBA\u00181\u0001\u0007\u0011\u0011\u0007\u0005\u0006\u0015b\u0001\r\u0001\u0014\u0005\b\u00037B\u0002\u0019AA/\u000391\u0017N\\1mSj,W\u000b\u001d7pC\u0012$BB!\n\u0003*\t-\"Q\u0006B\u0018\u0005c!B!!6\u0003(!9\u0011QE\rA\u0004\u0005\u001d\u0002B\u0002.\u001a\u0001\u0004\u0011I\u0001C\u0003T3\u0001\u0007Q\u000bC\u0004\u00020e\u0001\r!!\r\t\u000f\u0005-\u0013\u00041\u0001\u0002N!9!1G\rA\u0002\tU\u0012A\u00042zi\u0016\u0014\u0016\r^3NKR\u0014\u0018n\u0019\t\u0006E\u0006}$q\u0007\t\u0005\u0005s\u0011Y%\u0004\u0002\u0003<)!!Q\bB \u0003\u0011\u0019wN]3\u000b\t\t\u0005#1I\u0001\b[\u0016$(/[2t\u0015\u0011\u0011)Ea\u0012\u0002\re\fW.\\3s\u0015\t\u0011I%A\u0002d_6LAA!\u0014\u0003<\t)Q*\u001a;fe\u0006\tR\u000f\u001d7pC\u0012\f'\r\\3TK\u001elWM\u001c;\u0015\u0011\tM#q\fB4\u0005c\u0002BA!\u0016\u0003\\5\u0011!q\u000b\u0006\u0004\u00053R\u0014a\u00017pO&!!Q\fB,\u0005E)\u0006\u000f\\8bI\u0006\u0014G.Z*fO6,g\u000e\u001e\u0005\b\u00053R\u0002\u0019\u0001B1!\u0011\u0011)Fa\u0019\n\t\t\u0015$q\u000b\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u0003ji\u0001\rAa\u001b\u0002\u00151|wmU3h[\u0016tG\u000f\u0005\u0003\u0003V\t5\u0014\u0002\u0002B8\u0005/\u0012!\u0002T8h'\u0016<W.\u001a8u\u0011\u0015\u0019&\u00041\u0001V\u0003E\u0019XmZ7f]R4\u0015\u000e\\3t\u000bbL7\u000f\u001e\u000b\u0005\u0005o\u0012i\bE\u0002c\u0005sJ1Aa\u001fd\u0005\u001d\u0011un\u001c7fC:DqAa\u0014\u001c\u0001\u0004\u0011\u0019FA\fTK\u001elWM\u001c;EK2,G/\u001a3Fq\u000e,\u0007\u000f^5p]N9ADa!\u0003\u0010\nU\u0005\u0003\u0002BC\u0005\u0017k!Aa\"\u000b\t\t%\u0015qG\u0001\u0007KJ\u0014xN]:\n\t\t5%q\u0011\u0002\u0013%\u0016$(/[1cY\u0016,\u0005pY3qi&|g\u000eE\u0002c\u0005#K1Aa%d\u0005\u001d\u0001&o\u001c3vGR\u00042A\u0019BL\u0013\r\u0011Ij\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004[N<\u0017\u0001B7tO\u0002\nQaY1vg\u0016,\"Aa)\u0011\t\t\u0015&q\u0016\b\u0005\u0005O\u0013YK\u0004\u0003\u0002\u0002\t%\u0016\"\u00013\n\u0007\t56-A\u0004qC\u000e\\\u0017mZ3\n\t\tE&1\u0017\u0002\n)\"\u0014xn^1cY\u0016T1A!,d\u0003\u0019\u0019\u0017-^:fAQ1!\u0011\u0018B_\u0005\u007f\u00032Aa/\u001d\u001b\u0005\t\u0002B\u0002BNC\u0001\u0007Q\u0010C\u0004\u0003 \u0006\u0002\rAa)\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005s\u0013)Ma2\t\u0011\tm%\u0005%AA\u0002uD\u0011Ba(#!\u0003\u0005\rAa)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u001a\u0016\u0004{\u0006%\u0015AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005'TCAa)\u0002\n\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"A!7\u0011\t\tm'Q]\u0007\u0003\u0005;TAAa8\u0003b\u0006!A.\u00198h\u0015\t\u0011\u0019/\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0005;\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003n\nM\bc\u00012\u0003p&\u0019!\u0011_2\u0003\u0007\u0005s\u0017\u0010C\u0004iO\u0005\u0005\t\u0019\u00019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!?\u0011\r\tm8\u0011\u0001Bw\u001b\t\u0011iPC\u0002\u0003\u0000\u000e\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019A!@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005o\u001aI\u0001\u0003\u0005iS\u0005\u0005\t\u0019\u0001Bw\u0003!A\u0017m\u001d5D_\u0012,G#\u00019\u0002\r\u0015\fX/\u00197t)\u0011\u00119ha\u0005\t\u0011!\\\u0013\u0011!a\u0001\u0005[\fqcU3h[\u0016tG\u000fR3mKR,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\tmVfE\u0003.\u00077\u0011)\nE\u0005\u0004\u001e\r\rRPa)\u0003:6\u00111q\u0004\u0006\u0004\u0007C\u0019\u0017a\u0002:v]RLW.Z\u0005\u0005\u0007K\u0019yBA\tBEN$(/Y2u\rVt7\r^5p]J\"\"aa\u0006\u0015\u0005\teGC\u0002B]\u0007[\u0019y\u0003\u0003\u0004\u0003\u001cB\u0002\r! \u0005\b\u0005?\u0003\u0004\u0019\u0001BR\u0003\u001d)h.\u00199qYf$Ba!\u000e\u0004>A)!-a \u00048A1!m!\u000f~\u0005GK1aa\u000fd\u0005\u0019!V\u000f\u001d7fe!I1qH\u0019\u0002\u0002\u0003\u0007!\u0011X\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!\u0012\u0011\t\tm7qI\u0005\u0005\u0007\u0013\u0012iN\u0001\u0004PE*,7\r\u001e")
public final class ArchiveTask
extends TierTask<ArchiveTask> {
    private final CancellationContext ctx;
    private final TopicIdPartition topicIdPartition;
    private ArchiveTaskState state;
    private final ArchiverMetrics archiverMetrics;
    private final int brokerId;

    public static ArchiveTask apply(CancellationContext cancellationContext, TopicIdPartition topicIdPartition, int n, ArchiverMetrics archiverMetrics, int n2) {
        return ArchiveTask$.MODULE$.apply(cancellationContext, topicIdPartition, n, archiverMetrics, n2);
    }

    @Override
    public CancellationContext ctx() {
        return this.ctx;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public ArchiveTaskState state() {
        return this.state;
    }

    public void state_$eq(ArchiveTaskState x$1) {
        this.state = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    public String loggerName() {
        return ArchiveTask.class.getName();
    }

    @Override
    public Future<ArchiveTask> transition(Time time, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, ReplicaManager replicaManager, Option<Object> maxRetryBackoffMs, ExecutionContext ec) {
        Future<BeforeUpload> future;
        if (this.ctx().isCancelled()) {
            future = Future$.MODULE$.successful((Object)this.state());
        } else {
            Object object;
            ArchiveTaskState archiveTaskState = this.state();
            if (archiveTaskState instanceof BeforeLeader) {
                BeforeLeader beforeLeader = (BeforeLeader)archiveTaskState;
                object = ArchiveTask$.MODULE$.establishLeadership(beforeLeader, this.topicIdPartition(), tierTopicAppender, this.brokerId(), ec);
            } else if (archiveTaskState instanceof BeforeUpload) {
                BeforeUpload beforeUpload = (BeforeUpload)archiveTaskState;
                object = ArchiveTask$.MODULE$.maybeInitiateUpload(beforeUpload, this.topicIdPartition(), time, tierTopicAppender, tierObjectStore, replicaManager, ec);
            } else if (archiveTaskState instanceof Upload) {
                Upload upload = (Upload)archiveTaskState;
                object = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), time, this.ctx(), tierObjectStore, ec);
            } else if (archiveTaskState instanceof AfterUpload) {
                AfterUpload afterUpload = (AfterUpload)archiveTaskState;
                object = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), time, tierTopicAppender, this.archiverMetrics.byteRateOpt(), ec);
            } else if (archiveTaskState instanceof FailedState) {
                FailedState failedState = (FailedState)archiveTaskState;
                object = ArchiveTask$.MODULE$.checkFailedState(failedState, this.topicIdPartition(), replicaManager);
            } else {
                throw new MatchError((Object)archiveTaskState);
            }
            future = object;
        }
        return future.map((Function1 & Serializable & scala.Serializable)result -> {
            this.onSuccessfulTransition();
            this.state_$eq((ArchiveTaskState)result);
            return this;
        }, ec).recover((PartialFunction)new scala.Serializable(this, maxRetryBackoffMs, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchiveTask $outer;
            private final Option maxRetryBackoffMs$1;
            private final Time time$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 instanceof TierMetadataRetriableException) {
                    TierMetadataRetriableException tierMetadataRetriableException = (TierMetadataRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Defaults$.MODULE$.METADATA_EXCEPTION_RETRY_MS())), this.time$1.hiResClockMs(), (Throwable)((Object)tierMetadataRetriableException));
                    object = this.$outer;
                } else if (x1 instanceof TierObjectStoreRetriableException) {
                    TierObjectStoreRetriableException tierObjectStoreRetriableException = (TierObjectStoreRetriableException)((Object)x1);
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Defaults$.MODULE$.OBJECT_STORE_EXCEPTION_RETRY_MS())), this.time$1.hiResClockMs(), (Throwable)((Object)tierObjectStoreRetriableException));
                    object = this.$outer;
                } else if (x1 instanceof TierArchiverFailedException) {
                    TierArchiverFailedException tierArchiverFailedException = (TierArchiverFailedException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask warn_this = archiveTask;
                    if (warn_this.logger().underlying().isWarnEnabled()) {
                        warn_this.logger().underlying().warn(warn_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$3(this)), (Throwable)$anonfun$transition$2.$anonfun$applyOrElse$4(tierArchiverFailedException));
                    }
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Defaults$.MODULE$.FENCED_STATE_EXCEPTION_RETRY_MS())), this.time$1.hiResClockMs(), tierArchiverFailedException);
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    object = this.$outer;
                } else if (x1 instanceof TierArchiverRestoreFencedException) {
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask debug_this = archiveTask;
                    if (debug_this.logger().underlying().isDebugEnabled()) {
                        debug_this.logger().underlying().debug(debug_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$6(this)));
                    }
                    this.$outer.state_$eq(new FailedState(this.$outer.state().leaderEpoch()));
                    object = this.$outer;
                } else if (x1 instanceof TierArchiverFencedException) {
                    TierArchiverFencedException tierArchiverFencedException = (TierArchiverFencedException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask info_this = archiveTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$7(this)), (Throwable)$anonfun$transition$2.$anonfun$applyOrElse$8(tierArchiverFencedException));
                    }
                    this.$outer.ctx().cancel();
                    object = this.$outer;
                } else if (x1 instanceof NotTierablePartitionException) {
                    NotTierablePartitionException notTierablePartitionException = (NotTierablePartitionException)x1;
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask info_this = archiveTask;
                    if (info_this.logger().underlying().isInfoEnabled()) {
                        info_this.logger().underlying().info(info_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$9(this)), (Throwable)$anonfun$transition$2.$anonfun$applyOrElse$10(notTierablePartitionException));
                    }
                    this.$outer.ctx().cancel();
                    object = this.$outer;
                } else if (x1 instanceof SegmentDeletedException) {
                    SegmentDeletedException segmentDeletedException = (SegmentDeletedException)((Object)x1);
                    this.$outer.state_$eq(this.$outer.state().handleSegmentDeletedException(segmentDeletedException));
                    this.$outer.retryTaskLater(BoxesRunTime.unboxToInt((Object)this.maxRetryBackoffMs$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Defaults$.MODULE$.SEGMENT_DELETED_RETRY_MS())), this.time$1.hiResClockMs(), (Throwable)((Object)segmentDeletedException));
                    object = this.$outer;
                } else if (x1 != null) {
                    ArchiveTask archiveTask = this.$outer;
                    if (archiveTask == null) {
                        throw null;
                    }
                    ArchiveTask error_this = archiveTask;
                    if (error_this.logger().underlying().isErrorEnabled()) {
                        error_this.logger().underlying().error(error_this.msgWithLogIdent($anonfun$transition$2.$anonfun$applyOrElse$12(this)), $anonfun$transition$2.$anonfun$applyOrElse$13(x1));
                    }
                    this.$outer.cancelAndSetErrorState(this.$outer, x1);
                    object = this.$outer;
                } else {
                    object = function1.apply(null);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = x1 instanceof TierMetadataRetriableException ? true : (x1 instanceof TierObjectStoreRetriableException ? true : (x1 instanceof TierArchiverFailedException ? true : (x1 instanceof TierArchiverRestoreFencedException ? true : (x1 instanceof TierArchiverFencedException ? true : (x1 instanceof NotTierablePartitionException ? true : (x1 instanceof SegmentDeletedException ? true : x1 != null))))));
                return bl;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$3($anonfun$transition$2 $this) {
                return new StringBuilder(61).append($this.$outer.topicIdPartition()).append(" failed, pausing archival process and marking ").append($this.$outer.topicIdPartition()).append(" to be in error").toString();
            }

            public static final /* synthetic */ TierArchiverFailedException $anonfun$applyOrElse$4(TierArchiverFailedException x4$1) {
                return x4$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$6($anonfun$transition$2 $this) {
                return new StringBuilder(54).append($this.$outer.topicIdPartition()).append(" encountered metadata fencing due to state restoration").toString();
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$7($anonfun$transition$2 $this) {
                return new StringBuilder(38).append($this.$outer.topicIdPartition()).append(" was fenced, stopping archival process").toString();
            }

            public static final /* synthetic */ TierArchiverFencedException $anonfun$applyOrElse$8(TierArchiverFencedException x6$1) {
                return x6$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$9($anonfun$transition$2 $this) {
                return new StringBuilder(39).append($this.$outer.topicIdPartition()).append(" is not tierable and cannot be archived").toString();
            }

            public static final /* synthetic */ NotTierablePartitionException $anonfun$applyOrElse$10(NotTierablePartitionException x7$1) {
                return x7$1;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$12($anonfun$transition$2 $this) {
                return new StringBuilder(89).append($this.$outer.topicIdPartition()).append(" failed due to unhandled exception, stopping archival process and marking ").append($this.$outer.topicIdPartition()).append(" to be in error").toString();
            }

            public static final /* synthetic */ Throwable $anonfun$applyOrElse$13(Throwable x9$1) {
                return x9$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maxRetryBackoffMs$1 = maxRetryBackoffMs$1;
                this.time$1 = time$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$4(kafka.tier.exceptions.TierArchiverFailedException ), $anonfun$applyOrElse$5(), $anonfun$applyOrElse$6(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$7(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$8(kafka.tier.exceptions.TierArchiverFencedException ), $anonfun$applyOrElse$9(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$10(kafka.tier.exceptions.NotTierablePartitionException ), $anonfun$applyOrElse$11(), $anonfun$applyOrElse$12(kafka.tier.tasks.archive.ArchiveTask$$anonfun$transition$2 ), $anonfun$applyOrElse$13(java.lang.Throwable )}, serializedLambda);
            }
        }, ec);
    }

    @Override
    public Option<Object> transition$default$5() {
        return None$.MODULE$;
    }

    public String toString() {
        return new StringBuilder(41).append("ArchiveTask(").append(this.topicIdPartition()).append(", state=").append(this.state().getClass().getName()).append(", epoch=").append(this.state().leaderEpoch()).append(", cancelled=").append(this.ctx().isCancelled()).append(")").toString();
    }

    public ArchiveTask(CancellationContext ctx, TopicIdPartition topicIdPartition, ArchiveTaskState state, ArchiverMetrics archiverMetrics, int brokerId) {
        this.ctx = ctx;
        this.topicIdPartition = topicIdPartition;
        this.state = state;
        this.archiverMetrics = archiverMetrics;
        this.brokerId = brokerId;
        super(archiverMetrics.retryRateOpt());
    }

    public static class SegmentDeletedException
    extends RetriableException
    implements Product,
    scala.Serializable {
        private final String msg;
        private final Throwable cause;

        public String msg() {
            return this.msg;
        }

        public Throwable cause() {
            return this.cause;
        }

        public SegmentDeletedException copy(String msg, Throwable cause) {
            return new SegmentDeletedException(msg, cause);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        public String productPrefix() {
            return "SegmentDeletedException";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.msg();
                }
                case 1: {
                    return this.cause();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SegmentDeletedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof SegmentDeletedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            SegmentDeletedException segmentDeletedException = (SegmentDeletedException)((Object)x$1);
            String string = this.msg();
            String string2 = segmentDeletedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = segmentDeletedException.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!segmentDeletedException.canEqual((Object)this)) return false;
            return true;
        }

        public SegmentDeletedException(String msg, Throwable cause) {
            this.msg = msg;
            this.cause = cause;
            super(msg, cause);
            Product.$init$((Product)this);
        }
    }
}

