/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StartPartitionDeletion;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.DeletionTaskQueue$;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc!\u0002\t\u0012\u0001EI\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u0011)\u0002!\u0011!Q\u0001\n-B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0019\u0019\u0007\u0001\"\u0015\u0014I\"1!\u000f\u0001C)'MDqa \u0001\u0005RM\t\t\u0001C\u0004\u0002\u0014\u0001!I!!\u0006\b\u0015\u0005\u0005\u0012#!A\t\u0002E\t\u0019CB\u0005\u0011#\u0005\u0005\t\u0012A\t\u0002&!1!,\u0004C\u0001\u0003[A\u0011\"a\f\u000e#\u0003%\t!!\r\u0003#\u0011+G.\u001a;j_:$\u0016m]6Rk\u0016,XM\u0003\u0002\u0013'\u00051A-\u001a7fi\u0016T!\u0001F\u000b\u0002\u000bQ\f7o[:\u000b\u0005Y9\u0012\u0001\u0002;jKJT\u0011\u0001G\u0001\u0006W\u000647.Y\n\u0003\u0001i\u00012a\u0007\u000f\u001f\u001b\u0005\u0019\u0012BA\u000f\u0014\u00055!\u0016.\u001a:UCN\\\u0017+^3vKB\u0011q\u0004I\u0007\u0002#%\u0011\u0011%\u0005\u0002\r\t\u0016dW\r^5p]R\u000b7o[\u0001\u0004GRD8\u0001\u0001\t\u0003K!j\u0011A\n\u0006\u0003OU\tqAZ3uG\",'/\u0003\u0002*M\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006AQ.\u0019=UCN\\7\u000f\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0002J]R\faaY8oM&<\u0007CA\u000e4\u0013\t!4CA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\u0005]\nU\"\u0001\u001d\u000b\u0005eR\u0014!B;uS2\u001c(BA\u001e=\u0003\u0019\u0019w.\\7p]*\u0011\u0001$\u0010\u0006\u0003}}\na!\u00199bG\",'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Cq\t!A+[7f\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"!\u0012%\u000e\u0003\u0019S!aR\f\u0002\rM,'O^3s\u0013\tIeI\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u0019I,GO]=SCR,w\n\u001d;\u0011\u00071be*\u0003\u0002N[\t1q\n\u001d;j_:\u0004\"a\u0014-\u000e\u0003AS!!\u0015*\u0002\t\r|'/\u001a\u0006\u0003'R\u000bq!\\3ue&\u001c7O\u0003\u0002V-\u00061\u00110Y7nKJT\u0011aV\u0001\u0004G>l\u0017BA-Q\u0005\u0015iU\r^3s\u0003\u0019a\u0014N\\5u}Q9A,\u00180`A\u0006\u0014\u0007CA\u0010\u0001\u0011\u0015\u0011s\u00011\u0001%\u0011\u0015Qs\u00011\u0001,\u0011\u0015\tt\u00011\u00013\u0011\u0015)t\u00011\u00017\u0011\u0015\u0019u\u00011\u0001E\u0011\u001dQu\u0001%AA\u0002-\u000b\u0011b]8siR\u000b7o[:\u0015\u0005\u0015\f\bc\u00014o=9\u0011q\r\u001c\b\u0003Q.l\u0011!\u001b\u0006\u0003U\u000e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u00055l\u0013a\u00029bG.\fw-Z\u0005\u0003_B\u0014A\u0001T5ti*\u0011Q.\f\u0005\u0006)!\u0001\r!Z\u0001\b]\u0016<H+Y:l)\rqBO\u001f\u0005\u0006k&\u0001\rA^\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"a\u001e=\u000e\u0003UI!!_\u000b\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\"B>\n\u0001\u0004a\u0018AB2iC:<W\r\u0005\u0002\u001c{&\u0011ap\u0005\u0002\u0014'R\f'\u000f^\"iC:<W-T3uC\u0012\fG/Y\u0001\u000b[\u0006L\bK]8dKN\u001cH\u0003BA\u0002\u0003\u0013\u00012\u0001LA\u0003\u0013\r\t9!\f\u0002\b\u0005>|G.Z1o\u0011\u001d\tYA\u0003a\u0001\u0003\u001b\t\u0001\"\\3uC\u0012\fG/\u0019\t\u00047\u0005=\u0011bAA\t'\tq1\t[1oO\u0016lU\r^1eCR\f\u0017\u0001\u0004;bg.\u0004&/[8sSRLH\u0003BA\f\u0003;\u00012\u0001LA\r\u0013\r\tY\"\f\u0002\u0005\u0019>tw\r\u0003\u0004\u0002 -\u0001\rAH\u0001\u0005i\u0006\u001c8.A\tEK2,G/[8o)\u0006\u001c8.U;fk\u0016\u0004\"aH\u0007\u0014\u00075\t9\u0003E\u0002-\u0003SI1!a\u000b.\u0005\u0019\te.\u001f*fMR\u0011\u00111E\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005M\"fA&\u00026-\u0012\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003%)hn\u00195fG.,GMC\u0002\u0002B5\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)%a\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DeletionTaskQueue
extends TierTaskQueue<DeletionTask> {
    private final CancellationContext ctx;
    private final TierTasksConfig config;
    private final ReplicaManager replicaManager;
    private final Option<Meter> retryRateOpt;

    public static Option<Meter> $lessinit$greater$default$6() {
        return DeletionTaskQueue$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public List<DeletionTask> sortTasks(List<DeletionTask> tasks) {
        return (List)tasks.sortBy((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToLong((long)this.taskPriority(task)), (Ordering)Ordering.Long$.MODULE$);
    }

    @Override
    public DeletionTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata change) {
        Product product;
        if (change instanceof StartLeadership) {
            StartLeadership startLeadership = (StartLeadership)change;
            product = new DeletionTask.DeleteAsLeaderMetadata(this.replicaManager, startLeadership.leaderEpoch());
        } else if (change instanceof StartPartitionDeletion) {
            StartPartitionDeletion startPartitionDeletion = (StartPartitionDeletion)change;
            product = new DeletionTask.DeletedPartitionMetadata(startPartitionDeletion.tieredObjects());
        } else {
            throw new MatchError((Object)change);
        }
        return new DeletionTask(this.ctx.subContext(), topicIdPartition, this.config, new DeletionTask.CollectDeletableSegments((DeletionTask.StateMetadata)product), this.retryRateOpt);
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        return true;
    }

    private long taskPriority(DeletionTask task) {
        DeletionTask.State state = task.state();
        long l = state instanceof DeletionTask.CollectDeletableSegments ? BoxesRunTime.unboxToLong((Object)task.lastProcessedMs().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) : (state instanceof DeletionTask.FailedState ? -2L : -1L);
        return l;
    }

    public DeletionTaskQueue(CancellationContext ctx, int maxTasks, TierTasksConfig config, Time time, ReplicaManager replicaManager, Option<Meter> retryRateOpt) {
        this.ctx = ctx;
        this.config = config;
        this.replicaManager = replicaManager;
        this.retryRateOpt = retryRateOpt;
        super(ctx, maxTasks, time);
    }
}

