/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.HashMap;
import java.util.Map;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.S3TierObjectStore;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import org.apache.kafka.common.utils.Time;

public class TierObjectStoreFactory {
    private static final Map<TierObjectStore.Backend, ReferenceCountedObjStore> BACKEND_INSTANCE_MAP = new HashMap<TierObjectStore.Backend, ReferenceCountedObjStore>(){
        {
            this.put(TierObjectStore.Backend.S3, new ReferenceCountedObjStore());
            this.put(TierObjectStore.Backend.GCS, new ReferenceCountedObjStore());
            this.put(TierObjectStore.Backend.Mock, new ReferenceCountedObjStore());
        }
    };

    public static synchronized TierObjectStore getObjectStoreInstance(Time time, TierObjectStore.Backend backend, TierObjectStoreConfig config) {
        if (!BACKEND_INSTANCE_MAP.containsKey((Object)backend)) {
            throw new IllegalArgumentException("Unsupported backend: " + (Object)((Object)backend));
        }
        return BACKEND_INSTANCE_MAP.get((Object)backend).getObjectStore(time, backend, config);
    }

    static synchronized int closeBackendInstance(TierObjectStore.Backend backend) {
        if (!BACKEND_INSTANCE_MAP.containsKey((Object)backend)) {
            throw new IllegalArgumentException("Unsupported backend: " + (Object)((Object)backend));
        }
        return BACKEND_INSTANCE_MAP.get((Object)backend).close();
    }

    static synchronized TierObjectStore maybeInitObjStore(Time time, TierObjectStore.Backend backend, TierObjectStoreConfig config) {
        switch (backend) {
            case S3: {
                return TierObjectStoreFactory.maybeInitS3Store(config);
            }
            case GCS: {
                return TierObjectStoreFactory.maybeInitGcsStore(time, config);
            }
            case Mock: {
                return TierObjectStoreFactory.maybeInitMockStore(time, config);
            }
        }
        throw new IllegalArgumentException("Unsupported backend: " + (Object)((Object)backend));
    }

    private static S3TierObjectStore maybeInitS3Store(TierObjectStoreConfig config) {
        if (config instanceof S3TierObjectStoreConfig) {
            return new S3TierObjectStore((S3TierObjectStoreConfig)config);
        }
        throw new IllegalArgumentException("Expected S3TierObjectStoreConfig but received instance of: " + config.getClass());
    }

    private static GcsTierObjectStore maybeInitGcsStore(Time time, TierObjectStoreConfig config) {
        if (config instanceof GcsTierObjectStoreConfig) {
            return new GcsTierObjectStore(time, (GcsTierObjectStoreConfig)config);
        }
        throw new IllegalArgumentException("Expected GcsTierObjectStoreConfig but received instance of: " + config.getClass());
    }

    private static MockInMemoryTierObjectStore maybeInitMockStore(Time time, TierObjectStoreConfig config) {
        return new MockInMemoryTierObjectStore(time, config);
    }

    private static class ReferenceCountedObjStore {
        private TierObjectStore objectStore = null;
        private int refCount = 0;

        ReferenceCountedObjStore() {
        }

        synchronized int close() {
            if (this.refCount > 0) {
                --this.refCount;
                if (this.refCount == 0 && this.objectStore != null) {
                    this.objectStore.close();
                    this.objectStore = null;
                }
            }
            return this.refCount;
        }

        synchronized TierObjectStore getObjectStore(Time time, TierObjectStore.Backend backend, TierObjectStoreConfig config) {
            if (this.refCount < 0) {
                throw new IllegalStateException("Incorrect state in ReferenceCountedObjStore for backend: " + (Object)((Object)backend) + " at refCount: " + this.refCount);
            }
            if (this.refCount == 0) {
                this.objectStore = TierObjectStoreFactory.maybeInitObjStore(time, backend, config);
            }
            ++this.refCount;
            return this.objectStore;
        }
    }
}

