/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools.restore;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateUtils;
import kafka.tier.state.Header;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.restore.SegmentStateIterator;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;

public class RestorePartitionOperator {
    private long fromTimestamp;
    private static final int ENTRY_LENGTH_SIZE = 2;
    private final TopicIdPartition topicIdPartition;
    private CheckedFileIO stateFileChannel;
    private Header header;
    private Map<UUID, SegmentState> segmentStateMap = new HashMap<UUID, SegmentState>();
    private List<SegmentState> segmentStateList = new ArrayList<SegmentState>();
    private Map<UUID, String> segmentPathMap = new HashMap<UUID, String>();
    private long headerSize = 0L;
    private int totalSegmentsInFile = 0;
    private String prefix;

    public RestorePartitionOperator(TopicPartition topicPartition, File stateFile, long fromTimestamp, String prefix) throws Exception {
        this.fromTimestamp = fromTimestamp;
        this.prefix = prefix == null ? "" : prefix;
        this.stateFileChannel = CheckedFileIO.open(stateFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        Optional<Header> headerOpt = FileTierPartitionState.readHeader(this.stateFileChannel);
        if (!headerOpt.isPresent()) {
            throw new IllegalStateException("Input state file is not valid, file path: " + stateFile.getAbsolutePath());
        }
        this.header = headerOpt.get();
        this.headerSize = this.header.size();
        this.topicIdPartition = new TopicIdPartition(topicPartition.topic(), headerOpt.get().topicId(), topicPartition.partition());
        this.loadLogSegments();
    }

    private void loadLogSegments() throws IOException {
        SegmentStateIterator it = new SegmentStateIterator(this.topicIdPartition, this.stateFileChannel, this.headerSize);
        while (it.hasNext()) {
            SegmentState segmentState = (SegmentState)it.next();
            ++this.totalSegmentsInFile;
            if (segmentState.maxTimestamp() < this.fromTimestamp) continue;
            this.segmentStateMap.put(segmentState.objectId(), segmentState);
            this.segmentStateList.add(segmentState);
        }
        this.maybeRemoveFenceSegments();
    }

    public int restore() throws Exception {
        int updateCount = 0;
        Long newLogStartOffset = null;
        for (int index = 0; index < this.segmentStateList.size(); ++index) {
            SegmentState segmentState = this.segmentStateList.get(index);
            if (newLogStartOffset == null) {
                newLogStartOffset = segmentState.baseOffset();
            }
            if (segmentState.state() != TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE && segmentState.state() != TierObjectMetadata.State.SEGMENT_DELETE_INITIATE) continue;
            this.updateSegmentState(segmentState.objectId(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE);
            TierObjectStore.ObjectMetadata objectMetadata = new TierObjectStore.ObjectMetadata(this.topicIdPartition, segmentState.objectId(), segmentState.tierEpoch(), segmentState.baseOffset(), segmentState.hasAbortedTxns(), segmentState.hasProducerState(), segmentState.hasEpochState(), segmentState.opaqueData());
            this.segmentPathMap.put(segmentState.objectId(), objectMetadata.toPath(this.prefix, TierObjectStore.FileType.SEGMENT));
            ++updateCount;
        }
        if (newLogStartOffset != null) {
            this.updateHeaderStartOffset(newLogStartOffset);
        }
        this.stateFileChannel.flush();
        return updateCount;
    }

    public void updateSegmentState(UUID objectId, TierObjectMetadata.State newState) throws Exception {
        SegmentState currentState = this.segmentStateMap.get(objectId);
        if (currentState == null) {
            throw new IllegalStateException("No metadata found for " + objectId);
        }
        if (!objectId.equals(currentState.objectId())) {
            throw new IllegalStateException("ObjectId mismatch. Expected: " + objectId + " Got: " + currentState.objectId());
        }
        TierObjectMetadata metadata = FileTierPartitionStateUtils.read(this.topicIdPartition, this.stateFileChannel, currentState.filePosition());
        if (!objectId.equals(metadata.objectId())) {
            throw new IllegalStateException("ObjectId mismatch. Expected: " + objectId + " Got: " + currentState.objectId());
        }
        int oldSize = metadata.payloadSize();
        metadata.forceMutateState(newState);
        int newSize = metadata.payloadSize();
        if (oldSize != newSize) {
            throw new IllegalStateException(String.format("Size mismatch for objectId %s, expected: %d, got: %d, topicIdPartition: %s.", metadata.objectId(), oldSize, newSize, this.topicIdPartition));
        }
        this.stateFileChannel.write(metadata.payloadBuffer(), currentState.filePosition() + 2);
    }

    public Map<UUID, String> getSegmentPathMap() {
        return this.segmentPathMap;
    }

    public int totalSegments() {
        return this.totalSegmentsInFile;
    }

    private void maybeRemoveFenceSegments() {
    }

    private void updateHeaderStartOffset(long startOffset) throws IOException {
        this.header = new Header(this.header.topicId(), this.header.versionInByte(), this.header.tierEpoch(), this.header.status(), startOffset, this.header.endOffset(), this.header.globalMaterializedOffsetAndEpoch(), this.header.localMaterializedOffsetAndEpoch(), this.header.errorOffsetAndEpoch(), this.header.restoreOffsetAndEpoch());
        FileTierPartitionState.writeHeader(this.stateFileChannel, this.header);
    }

    public Header header() {
        return this.header;
    }

    public SegmentState segmentStateByObjectID(UUID objectId) {
        return this.segmentStateMap.get(objectId);
    }

    public int segmentNumberWithState(TierObjectMetadata.State state) {
        int count = 0;
        for (SegmentState segmentState : this.segmentStateList) {
            if (segmentState.state() != state) continue;
            ++count;
        }
        return count;
    }
}

