/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.Collection;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopicAdmin;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.TopicPartition;

public class TierTopic
implements InitializedTierTopic {
    private final String topicName;
    private TierTopicPartitioner partitioner;
    private OptionalInt numPartitions = OptionalInt.empty();

    public TierTopic(String tierNamespace) {
        this.topicName = TierTopic.topicName(tierNamespace);
    }

    public void initialize(AdminZkClient adminZkClient, int configuredNumPartitions, short configuredReplicationFactor) {
        this.initialize(TierTopicAdmin.ensureTopic(adminZkClient, this.topicName, configuredNumPartitions, configuredReplicationFactor));
    }

    public void initialize(int numPartitions) {
        this.numPartitions = OptionalInt.of(numPartitions);
        this.partitioner = new TierTopicPartitioner(numPartitions);
    }

    @Override
    public Set<TopicPartition> toTierTopicPartitions(Collection<TopicIdPartition> tieredPartitions) {
        if (this.partitioner == null) {
            throw new IllegalStateException("initialize must be called for TierTopic before use.");
        }
        return TierTopic.toTierTopicPartitions(tieredPartitions, this.topicName, this.partitioner);
    }

    @Override
    public TopicPartition toTierTopicPartition(TopicIdPartition tieredPartition) {
        if (this.partitioner == null) {
            throw new IllegalStateException("initialize must be called for TierTopic before use.");
        }
        return TierTopic.toTierTopicPartition(tieredPartition, this.topicName, this.partitioner);
    }

    @Override
    public String topicName() {
        return this.topicName;
    }

    @Override
    public OptionalInt numPartitions() {
        return this.numPartitions;
    }

    public static String topicName(String tierNamespace) {
        if (tierNamespace != null && !tierNamespace.isEmpty()) {
            return "_confluent-tier-state-" + tierNamespace;
        }
        return "_confluent-tier-state";
    }

    public static Set<TopicPartition> toTierTopicPartitions(Collection<TopicIdPartition> tieredPartitions, String topicName, TierTopicPartitioner partitioner) {
        return tieredPartitions.stream().map(tieredPartition -> TierTopic.toTierTopicPartition(tieredPartition, topicName, partitioner)).collect(Collectors.toSet());
    }

    public static TopicPartition toTierTopicPartition(TopicIdPartition tieredPartition, String topicName, TierTopicPartitioner partitioner) {
        return new TopicPartition(topicName, partitioner.partitionId(tieredPartition));
    }
}

