/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rus!B(Q\u0011\u0003)f!B,Q\u0011\u0003A\u0006\"B0\u0002\t\u0003\u0001\u0007\u0002C1\u0002\u0005\u0004%\t\u0001\u00152\t\r-\f\u0001\u0015!\u0003d\u0011\u0015a\u0017\u0001\"\u0001n\u0011\u001d\t\t!\u0001C\u0005\u0003\u0007Aq!!\u0006\u0002\t\u0013\t9\u0002C\u0004\u0002\u001c\u0005!I!!\b\t\u0011\u0005\u0005\u0012\u0001\"\u0001Q\u0003GA\u0001\"!\u001d\u0002\t\u0003\u0001\u00161\u000f\u0004\u000b\u0003\u001b\f\u0001\u0013aI\u0001%\u0006=\u0007bBAj\u0017\u0019\u0005\u0011Q\u001b\u0004\u0007\u00053\tAAa\u0007\t\u0015\t%RB!A!\u0002\u0013\u0011Y\u0003\u0003\u0006\u000385\u0011\t\u0011)A\u0005\u0005sAaaX\u0007\u0005\u0002\tm\u0002bBAj\u001b\u0011\u0005#1\t\u0005\b\u0005\u001b\nA\u0011\u0002B(\u0011\u001d\u0011I(\u0001C\u0005\u0005w2a!a!\u0002\u0001\u0005\u0015\u0005BB0\u0015\t\u0003\t9\tC\u0005\u0002\nR\u0011\r\u0011\"\u0001\u0002\f\"A\u0011Q\u0013\u000b!\u0002\u0013\ti\tC\u0005\u0002\u0018R\u0011\r\u0011\"\u0001\u0002\f\"A\u0011\u0011\u0014\u000b!\u0002\u0013\ti\tC\u0005\u0002\u001cR\u0011\r\u0011\"\u0001\u0002\f\"A\u0011Q\u0014\u000b!\u0002\u0013\ti\tC\u0004\u0002 R!\t!!)\t\u000f\u00055F\u0003\"\u0001\u00020\"9\u0011\u0011\u0018\u000b\u0005\u0002\u0005m\u0006bBAd)\u0011\u0005\u0011\u0011\u001a\u0004\u0007\u0005'\u000bAA!&\t\r}\u0003C\u0011\u0001BM\u0011\u001d\t\u0019\u000e\tC!\u0005;3aA!*\u0002\t\t\u001d\u0006BB0$\t\u0003\u0011I\u000bC\u0004\u0002T\u000e\"\tE!,\u0007\r\tE\u0016\u0001\u0002BZ\u0011\u0019yf\u0005\"\u0001\u00036\"I!\u0011\u0018\u0014C\u0002\u0013\u0005!1\u0018\u0005\t\u0005\u00134\u0003\u0015!\u0003\u0003>\"9\u00111\u001b\u0014\u0005B\t-gA\u0002Bh\u0003\u0011\u0011\t\u000e\u0003\u0006sW\t\u0005\t\u0015!\u0003t\u0005?DaaX\u0016\u0005\u0002\t\u0005\b\"\u0003BtW\t\u0007I\u0011\u0001Bu\u0011!\u00119p\u000bQ\u0001\n\t-\b\"\u0003B}W\t\u0007I\u0011\u0001Bu\u0011!\u0011Yp\u000bQ\u0001\n\t-\b\"\u0003B\u007fW\t\u0007I\u0011\u0001Bu\u0011!\u0011yp\u000bQ\u0001\n\t-\b\"CB\u0001W\t\u0007I\u0011AB\u0002\u0011!\u0019Ya\u000bQ\u0001\n\r\u0015\u0001\"CB\u0007W\t\u0007I\u0011AB\b\u0011!\u0019Ib\u000bQ\u0001\n\rE\u0001\"CB\u000eW\t\u0007I\u0011\u0001Bu\u0011!\u0019ib\u000bQ\u0001\n\t-\b\"CB\u0010W\t\u0007I\u0011AB\u0011\u0011!\u0019)c\u000bQ\u0001\n\r\r\u0002\"CB\u0014W\t\u0007I\u0011AB\u0011\u0011!\u0019Ic\u000bQ\u0001\n\r\r\u0002\"CB\u0016W\t\u0007I\u0011\u0001Bu\u0011!\u0019ic\u000bQ\u0001\n\t-\b\"CB\u0018W\t\u0007I\u0011\u0001Bu\u0011!\u0019\td\u000bQ\u0001\n\t-\b\"CB\u001aW\t\u0007I\u0011\u0001Bu\u0011!\u0019)d\u000bQ\u0001\n\t-\b\"CB\u001cW\t\u0007I\u0011\u0001Bu\u0011!\u0019Id\u000bQ\u0001\n\t-\bbBB\u001eW\u0011\u00051Q\b\u0005\u000b\u0007\u001fZ\u0003R1A\u0005\u0002\rE\u0003B\u0003B<W!\u0015\r\u0011\"\u0001\u0004R!Q!QL\u0016\t\u0006\u0004%\ta!\u0015\t\u0015\u0005M2\u0006#b\u0001\n\u0003\u0019\t\u0006\u0003\u0006\u0002*-B)\u0019!C\u0001\u0007#B!ba\u0015,\u0011\u000b\u0007I\u0011AB+\u0011)\tIg\u000bEC\u0002\u0013\u00051\u0011\f\u0005\b\u00077ZC\u0011AAe\u0003=!U/\u001c9M_\u001e\u001cVmZ7f]R\u001c(BA)S\u0003\u0015!xn\u001c7t\u0015\u0005\u0019\u0016!B6bM.\f7\u0001\u0001\t\u0003-\u0006i\u0011\u0001\u0015\u0002\u0010\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugN\u0011\u0011!\u0017\t\u00035vk\u0011a\u0017\u0006\u00029\u0006)1oY1mC&\u0011al\u0017\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005)\u0016\u0001\u0004*fG>\u0014H-\u00138eK:$X#A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017\u0001\u00027b]\u001eT\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kK\n11\u000b\u001e:j]\u001e\fQBU3d_J$\u0017J\u001c3f]R\u0004\u0013\u0001B7bS:$\"A\\9\u0011\u0005i{\u0017B\u00019\\\u0005\u0011)f.\u001b;\t\u000bI,\u0001\u0019A:\u0002\t\u0005\u0014xm\u001d\t\u00045R4\u0018BA;\\\u0005\u0015\t%O]1z!\t9hP\u0004\u0002yyB\u0011\u0011pW\u0007\u0002u*\u00111\u0010V\u0001\u0007yI|w\u000e\u001e \n\u0005u\\\u0016A\u0002)sK\u0012,g-\u0003\u0002k\u007f*\u0011QpW\u0001\u000eIVl\u0007\u000fV5feN#\u0018\r^3\u0015\u00079\f)\u0001C\u0004\u0002\b\u0019\u0001\r!!\u0003\u0002\t\u0019LG.\u001a\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB4\u0002\u0005%|\u0017\u0002BA\n\u0003\u001b\u0011AAR5mK\u0006aA-^7q)bt\u0017J\u001c3fqR\u0019a.!\u0007\t\u000f\u0005\u001dq\u00011\u0001\u0002\n\u00051B-^7q!J|G-^2fe&#7K\\1qg\"|G\u000fF\u0002o\u0003?Aq!a\u0002\t\u0001\u0004\tI!A\u0005ek6\u0004\u0018J\u001c3fqRYa.!\n\u0002(\u0005E\u0012QGA4\u0011\u001d\t9!\u0003a\u0001\u0003\u0013Aq!!\u000b\n\u0001\u0004\tY#A\bj]\u0012,\u0007pU1oSRLxJ\u001c7z!\rQ\u0016QF\u0005\u0004\u0003_Y&a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003gI\u0001\u0019AA\u0016\u0003)1XM]5gs>sG.\u001f\u0005\b\u0003oI\u0001\u0019AA\u001d\u0003ii\u0017n]'bi\u000eDWm\u001d$pe&sG-\u001a=GS2,7/T1q!\u001d\tY$!\u0012w\u0003\u0013j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019eW\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA$\u0003{\u00111!T1q!\u0019\tY%!\u0016\u0002\\9!\u0011QJA)\u001d\rI\u0018qJ\u0005\u00029&\u0019\u00111K.\u0002\u000fA\f7m[1hK&!\u0011qKA-\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005M3\fE\u0004[\u0003;\n\t'!\u0019\n\u0007\u0005}3L\u0001\u0004UkBdWM\r\t\u00045\u0006\r\u0014bAA37\n!Aj\u001c8h\u0011\u001d\tI'\u0003a\u0001\u0003W\na\"\\1y\u001b\u0016\u001c8/Y4f'&TX\rE\u0002[\u0003[J1!a\u001c\\\u0005\rIe\u000e^\u0001\u000eIVl\u0007\u000fV5nK&sG-\u001a=\u0015\u00179\f)(a\u001e\u0002z\u0005m\u00141\u001a\u0005\b\u0003\u000fQ\u0001\u0019AA\u0005\u0011\u001d\tIC\u0003a\u0001\u0003WAq!a\r\u000b\u0001\u0004\tY\u0003C\u0004\u0002~)\u0001\r!a \u0002'QLW.Z%oI\u0016DH)^7q\u000bJ\u0014xN]:\u0011\u0007\u0005\u0005E#D\u0001\u0002\u0005M!\u0016.\\3J]\u0012,\u0007\u0010R;na\u0016\u0013(o\u001c:t'\t!\u0012\f\u0006\u0002\u0002\u0000\u0005qR.[:NCR\u001c\u0007.Z:G_J$\u0016.\\3J]\u0012,\u0007PR5mKNl\u0015\r]\u000b\u0003\u0003\u001b\u0003r!a\u000f\u0002FY\fy\t\u0005\u0004\u0002<\u0005E\u00151L\u0005\u0005\u0003'\u000biDA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018aH7jg6\u000bGo\u00195fg\u001a{'\u000fV5nK&sG-\u001a=GS2,7/T1qA\u0005\u0019r.\u001e;PM>\u0013H-\u001a:US6,7\u000f^1na\u0006!r.\u001e;PM>\u0013H-\u001a:US6,7\u000f^1na\u0002\nQc\u001d5bY2|wo\u00144gg\u0016$hj\u001c;G_VtG-\u0001\ftQ\u0006dGn\\<PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3!\u0003]\u0011XmY8sI6K7/\\1uG\"$\u0016.\\3J]\u0012,\u0007\u0010F\u0004o\u0003G\u000b)+!+\t\u000f\u0005\u001dA\u00041\u0001\u0002\n!9\u0011q\u0015\u000fA\u0002\u0005\u0005\u0014AD5oI\u0016DH+[7fgR\fW\u000e\u001d\u0005\b\u0003Wc\u0002\u0019AA1\u00031awn\u001a+j[\u0016\u001cH/Y7q\u0003y\u0011XmY8sI>+Ho\u00144Pe\u0012,'/\u00138eKb$\u0016.\\3ti\u0006l\u0007\u000fF\u0004o\u0003c\u000b\u0019,!.\t\u000f\u0005\u001dQ\u00041\u0001\u0002\n!9\u0011qU\u000fA\u0002\u0005\u0005\u0004bBA\\;\u0001\u0007\u0011\u0011M\u0001\u0013aJ,g/\u00138eKb$\u0016.\\3ti\u0006l\u0007/A\u000esK\u000e|'\u000fZ*iC2dwn^(gMN,GOT8u\r>,h\u000e\u001a\u000b\b]\u0006u\u0016qXAb\u0011\u001d\t9A\ba\u0001\u0003\u0013Aq!!1\u001f\u0001\u0004\t\t'A\u0006j]\u0012,\u0007p\u00144gg\u0016$\bbBAc=\u0001\u0007\u0011\u0011M\u0001\nY><wJ\u001a4tKR\f1\u0002\u001d:j]R,%O]8sgR\ta\u000eC\u0004\u0002j)\u0001\r!a\u001b\u0003\u001b5+7o]1hKB\u000b'o]3s+\u0019\t\t.a9\u0002zN\u00111\"W\u0001\u0006a\u0006\u00148/\u001a\u000b\u0005\u0003/\fi\u0010E\u0004[\u0003;\nI.!>\u0011\u000bi\u000bY.a8\n\u0007\u0005u7L\u0001\u0004PaRLwN\u001c\t\u0005\u0003C\f\u0019\u000f\u0004\u0001\u0005\u000f\u0005\u00158B1\u0001\u0002h\n\t1*\u0005\u0003\u0002j\u0006=\bc\u0001.\u0002l&\u0019\u0011Q^.\u0003\u000f9{G\u000f[5oOB\u0019!,!=\n\u0007\u0005M8LA\u0002B]f\u0004RAWAn\u0003o\u0004B!!9\u0002z\u00129\u00111`\u0006C\u0002\u0005\u001d(!\u0001,\t\u000f\u0005}H\u00021\u0001\u0003\u0002\u00051!/Z2pe\u0012\u0004BAa\u0001\u0003\u00165\u0011!Q\u0001\u0006\u0005\u0003\u007f\u00149A\u0003\u0003\u0003\n\t-\u0011AB2p[6|gNC\u0002T\u0005\u001bQAAa\u0004\u0003\u0012\u00051\u0011\r]1dQ\u0016T!Aa\u0005\u0002\u0007=\u0014x-\u0003\u0003\u0003\u0018\t\u0015!A\u0002*fG>\u0014HM\u0001\u000bEK\u000e|G-\u001a:NKN\u001c\u0018mZ3QCJ\u001cXM]\u000b\u0007\u0005;\u0011\u0019Ca\n\u0014\t5I&q\u0004\t\b\u0003\u0003[!\u0011\u0005B\u0013!\u0011\t\tOa\t\u0005\u000f\u0005\u0015XB1\u0001\u0002hB!\u0011\u0011\u001dB\u0014\t\u001d\tY0\u0004b\u0001\u0003O\f!b[3z\t\u0016\u001cw\u000eZ3s!\u0019\u0011iCa\r\u0003\"5\u0011!q\u0006\u0006\u0004\u0005c\u0011\u0016AC:fe&\fG.\u001b>fe&!!Q\u0007B\u0018\u0005\u001d!UmY8eKJ\fAB^1mk\u0016$UmY8eKJ\u0004bA!\f\u00034\t\u0015BC\u0002B\u001f\u0005\u007f\u0011\t\u0005E\u0004\u0002\u00026\u0011\tC!\n\t\u000f\t%\u0002\u00031\u0001\u0003,!9!q\u0007\tA\u0002\teB\u0003\u0002B#\u0005\u0017\u0002rAWA/\u0005\u000f\u0012I\u0005E\u0003[\u00037\u0014\t\u0003E\u0003[\u00037\u0014)\u0003C\u0004\u0002\u0000F\u0001\rA!\u0001\u0002\u000f\u0011,X\u000e\u001d'pORyaN!\u0015\u0003T\t]#1\fB0\u0005C\u0012)\bC\u0004\u0002\bI\u0001\r!!\u0003\t\u000f\tU#\u00031\u0001\u0002,\u0005i\u0001O]5oi\u000e{g\u000e^3oiNDqA!\u0017\u0013\u0001\u0004\tI$A\u0011o_:\u001cuN\\:fGV$\u0018N^3QC&\u00148OR8s\u0019><g)\u001b7fg6\u000b\u0007\u000fC\u0004\u0003^I\u0001\r!a\u000b\u0002\u001f%\u001cH)Z3q\u0013R,'/\u0019;j_:Dq!!\u001b\u0013\u0001\u0004\tY\u0007C\u0004\u0003dI\u0001\rA!\u001a\u0002\rA\f'o]3sa\u0019\u00119Ga\u001b\u0003rA9\u0011\u0011Q\u0006\u0003j\t=\u0004\u0003BAq\u0005W\"AB!\u001c\u0003b\u0005\u0005\t\u0011!B\u0001\u0003O\u00141a\u0018\u00132!\u0011\t\tO!\u001d\u0005\u0019\tM$\u0011MA\u0001\u0002\u0003\u0015\t!a:\u0003\u0007}##\u0007C\u0004\u0003xI\u0001\r!a\u000b\u0002%M\\\u0017\u000e\u001d*fG>\u0014H-T3uC\u0012\fG/Y\u0001\u0010aJLg\u000e\u001e\"bi\u000eDG*\u001a<fYR)aN! \u0003\u0010\"9!qP\nA\u0002\t\u0005\u0015!\u00022bi\u000eD\u0007\u0003\u0002BB\u0005\u0013sAAa\u0001\u0003\u0006&!!q\u0011B\u0003\u0003I1\u0015\u000e\\3M_\u001eLe\u000e];u'R\u0014X-Y7\n\t\t-%Q\u0012\u0002\u0017\r&dWm\u00115b]:,GNU3d_J$')\u0019;dQ*!!q\u0011B\u0003\u0011\u001d\u0011\tj\u0005a\u0001\u0003C\n\u0011#Y2dk6,H.\u0019;jm\u0016\u0014\u0015\u0010^3t\u0005QyeMZ:fiNlUm]:bO\u0016\u0004\u0016M]:feN!\u0001%\u0017BL!\u0015\t\ti\u0003<w)\t\u0011Y\nE\u0002\u0002\u0002\u0002\"BAa(\u0003$B9!,!\u0018\u0003\"\n\u0005\u0006\u0003\u0002.\u0002\\ZDq!a@#\u0001\u0004\u0011\tAA\u000eUe\u0006t7/Y2uS>tGj\\4NKN\u001c\u0018mZ3QCJ\u001cXM]\n\u0005Ge\u00139\n\u0006\u0002\u0003,B\u0019\u0011\u0011Q\u0012\u0015\t\t}%q\u0016\u0005\b\u0003\u007f,\u0003\u0019\u0001B\u0001\u0005}\u0019E.^:uKJlU\r^1eCR\fGj\\4NKN\u001c\u0018mZ3QCJ\u001cXM]\n\u0005Me\u00139\n\u0006\u0002\u00038B\u0019\u0011\u0011\u0011\u0014\u0002'5,G/\u00193bi\u0006\u0014VmY8sIN+'\u000fZ3\u0016\u0005\tu\u0006\u0003\u0002B`\u0005\u000bl!A!1\u000b\t\t\r'1B\u0001\t[\u0016$\u0018\rZ1uC&!!q\u0019Ba\u0005MiU\r^1eCR\f'+Z2pe\u0012\u001cVM\u001d3f\u0003QiW\r^1eCR\f'+Z2pe\u0012\u001cVM\u001d3fAQ!!q\u0014Bg\u0011\u001d\tyP\u000ba\u0001\u0005\u0003\u0011a\u0003R;na2{wmU3h[\u0016tGo](qi&|gn]\n\u0004W\tM\u0007\u0003\u0002Bk\u00057l!Aa6\u000b\u0007\te'+A\u0003vi&d7/\u0003\u0003\u0003^\n]'!F\"p[6\fg\u000e\u001a#fM\u0006,H\u000e^(qi&|gn]\u0005\u0004e\nmG\u0003\u0002Br\u0005K\u00042!!!,\u0011\u0015\u0011X\u00061\u0001t\u0003!\u0001(/\u001b8u\u001fB$XC\u0001Bv!\u0011\u0011iOa=\u000e\u0005\t=(B\u0001By\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0005\u0005k\u0014yOA\tPaRLwN\\*qK\u000e\u0014U/\u001b7eKJ\f\u0011\u0002\u001d:j]R|\u0005\u000f\u001e\u0011\u0002\u0013Y,'/\u001b4z\u001fB$\u0018A\u0003<fe&4\u0017p\u00149uA\u0005q\u0011N\u001c3fqN\u000bg.\u001b;z\u001fB$\u0018aD5oI\u0016D8+\u00198jif|\u0005\u000f\u001e\u0011\u0002\u0011\u0019LG.Z:PaR,\"a!\u0002\u0011\u000b\t58q\u0001<\n\t\r%!q\u001e\u0002\u001c\u0003J<W/\\3oi\u0006\u001b7-\u001a9uS:<w\n\u001d;j_:\u001c\u0006/Z2\u0002\u0013\u0019LG.Z:PaR\u0004\u0013!E7bq6+7o]1hKNK'0Z(qiV\u00111\u0011\u0003\t\u0007\u0005[\u001c9aa\u0005\u0011\u0007\u0011\u001c)\"C\u0002\u0004\u0018\u0015\u0014q!\u00138uK\u001e,'/\u0001\nnCblUm]:bO\u0016\u001c\u0016N_3PaR\u0004\u0013\u0001\u00053fKBLE/\u001a:bi&|gn\u00149u\u0003E!W-\u001a9Ji\u0016\u0014\u0018\r^5p]>\u0003H\u000fI\u0001\u0010m\u0006dW/\u001a#fG>$WM](qiV\u001111\u0005\t\u0006\u0005[\u001c9aY\u0001\u0011m\u0006dW/\u001a#fG>$WM](qi\u0002\nQb[3z\t\u0016\u001cw\u000eZ3s\u001fB$\u0018AD6fs\u0012+7m\u001c3fe>\u0003H\u000fI\u0001\u000b_\u001a47/\u001a;t\u001fB$\u0018aC8gMN,Go](qi\u0002\n\u0011\u0003\u001e:b]N\f7\r^5p]2{wm\u00149u\u0003I!(/\u00198tC\u000e$\u0018n\u001c8M_\u001e|\u0005\u000f\u001e\u0011\u0002%\rdWo\u001d;fe6+G/\u00193bi\u0006|\u0005\u000f^\u0001\u0014G2,8\u000f^3s\u001b\u0016$\u0018\rZ1uC>\u0003H\u000fI\u0001\u0016g.L\u0007OU3d_J$W*\u001a;bI\u0006$\u0018m\u00149u\u0003Y\u00198.\u001b9SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1PaR\u0004\u0013!D7fgN\fw-\u001a)beN,'/\u0006\u0002\u0004@A21\u0011IB#\u0007\u0017\u0002r!!!\f\u0007\u0007\u001aI\u0005\u0005\u0003\u0002b\u000e\u0015CaCB$\r\u0006\u0005\t\u0011!B\u0001\u0003O\u00141a\u0018\u00134!\u0011\t\toa\u0013\u0005\u0017\r5c)!A\u0001\u0002\u000b\u0005\u0011q\u001d\u0002\u0004?\u0012\"\u0014AE:i_VdG\r\u0015:j]R$\u0015\r^1M_\u001e,\"!a\u000b\u0002\u000b\u0019LG.Z:\u0016\u0005\r]\u0003c\u0001.uGV\u0011\u00111N\u0001\nG\",7m[!sON\u0004")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        public MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of files to be dumped. The supported file types include log files, index files, time index files, transaction index files, producer snapshots and tier state files.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private final OptionSpecBuilder clusterMetadataOpt = this.parser().accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
        private final OptionSpecBuilder skipRecordMetadataOpt = this.parser().accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        public OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options().has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has((OptionSpec)this.clusterMetadataOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options().has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options().valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    private static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

