/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.availability;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import integration.kafka.availability.BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.availability.AllThreadsStuck$;
import kafka.availability.AnyThreadStuck$;
import kafka.availability.BrokerHealthManager;
import kafka.availability.BrokerHealthStatus;
import kafka.availability.Healthy$;
import kafka.availability.Suspect$;
import kafka.availability.Unhealthy$;
import kafka.server.BaseRequestTest;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Exit$;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0012%\u0001-BQa\r\u0001\u0005\u0002QBQa\u000e\u0001\u0005Ba2A!\u0013\u0001A\u0015\"AAk\u0001BI\u0002\u0013\u0005Q\u000b\u0003\u0005a\u0007\t\u0005\r\u0011\"\u0001b\u0011!!7A!E!B\u00131\u0006\u0002C3\u0004\u0005#\u0007I\u0011\u00014\t\u0011)\u001c!\u00111A\u0005\u0002-D\u0001\"\\\u0002\u0003\u0012\u0003\u0006Ka\u001a\u0005\u0006g\r!\tA\u001c\u0005\bg\u000e\t\t\u0011\"\u0001u\u0011\u001d98!%A\u0005\u0002aD\u0011\"a\u0002\u0004#\u0003%\t!!\u0003\t\u0013\u000551!!A\u0005B\u0005=\u0001\"CA\u000f\u0007\u0005\u0005I\u0011AA\u0010\u0011%\t9cAA\u0001\n\u0003\tI\u0003C\u0005\u00024\r\t\t\u0011\"\u0011\u00026!I\u00111I\u0002\u0002\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003\u001f\u001a\u0011\u0011!C!\u0003#B\u0011\"a\u0015\u0004\u0003\u0003%\t%!\u0016\t\u0013\u0005]3!!A\u0005B\u0005es!CA/\u0001\u0005\u0005\t\u0012AA0\r!I\u0005!!A\t\u0002\u0005\u0005\u0004BB\u001a\u0018\t\u0003\ty\u0007C\u0005\u0002T]\t\t\u0011\"\u0012\u0002V!I\u0011\u0011O\f\u0002\u0002\u0013\u0005\u00151\u000f\u0005\n\u0003s:\u0012\u0011!CA\u0003wBq!!$\u0001\t\u0003\ty\tC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011q\u001d\u0001\u0005\u0002\u0005-\u0007bBAv\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003_\u0004A\u0011AAf\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003\u0017\u0014!E\u0011:pW\u0016\u0014\b*Z1mi\"l\u0015M\\1hKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0013'\u00031\tg/Y5mC\nLG.\u001b;z\u0015\t9\u0003&A\u0003lC\u001a\\\u0017MC\u0001*\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M\u0011\u0001\u0001\f\t\u0003[Ej\u0011A\f\u0006\u0003_A\naa]3sm\u0016\u0014(\"A\u0014\n\u0005Ir#a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005)\u0004C\u0001\u001c\u0001\u001b\u0005!\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tIt\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0003V]&$\b\"\u0002!\u0003\u0001\u0004\t\u0015A\u00039s_B,'\u000f^5fgB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005kRLGNC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%A\u0003)s_B,'\u000f^5fg\n\u0011C\u000b\u001b:fC\u0012dunY1m\u0007>,h\u000e^3sg:+Xn\u0015;vG.\u001c\u0016-\u001c9mKN\u001cBaA&O#B\u0011!\bT\u0005\u0003\u001bn\u0012a!\u00118z%\u00164\u0007C\u0001\u001eP\u0013\t\u00016HA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0012\u0016BA*<\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003M!\bN]3bI2{7-\u00197D_VtG/\u001a:t+\u00051\u0006CA,_\u001b\u0005A&BA\u0013Z\u0015\t9#L\u0003\u0002\\9\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0002;\u0006\u0011\u0011n\\\u0005\u0003?b\u00131\u0003\u00165sK\u0006$Gj\\2bY\u000e{WO\u001c;feN\fq\u0003\u001e5sK\u0006$Gj\\2bY\u000e{WO\u001c;feN|F%Z9\u0015\u0005e\u0012\u0007bB2\u0006\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014\u0001\u0006;ie\u0016\fG\rT8dC2\u001cu.\u001e8uKJ\u001c\b%\u0001\u0005ok6\u001cF/^2l+\u00059\u0007C\u0001\u001ei\u0013\tI7H\u0001\u0003M_:<\u0017\u0001\u00048v[N#XoY6`I\u0015\fHCA\u001dm\u0011\u001d\u0019\u0007\"!AA\u0002\u001d\f\u0011B\\;n'R,8m\u001b\u0011\u0015\u0007=\f(\u000f\u0005\u0002q\u00075\t\u0001\u0001C\u0003U\u0015\u0001\u0007a\u000bC\u0003f\u0015\u0001\u0007q-\u0001\u0003d_BLHcA8vm\"9Ak\u0003I\u0001\u0002\u00041\u0006bB3\f!\u0003\u0005\raZ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005I(F\u0001,{W\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003Y\u0014AC1o]>$\u0018\r^5p]&\u0019\u0011QA?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-!FA4{\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC#\u0002\t1\fgnZ\u0005\u0005\u00037\t)B\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00012AOA\u0012\u0013\r\t)c\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\t\t\u0004E\u0002;\u0003[I1!a\f<\u0005\r\te.\u001f\u0005\tGB\t\t\u00111\u0001\u0002\"\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00028A1\u0011\u0011HA \u0003Wi!!a\u000f\u000b\u0007\u0005u2(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0011\u0002<\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9%!\u0014\u0011\u0007i\nI%C\u0002\u0002Lm\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005d%\u0005\u0005\t\u0019AA\u0016\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0011\u0003!!xn\u0015;sS:<GCAA\t\u0003\u0019)\u0017/^1mgR!\u0011qIA.\u0011!\u0019W#!AA\u0002\u0005-\u0012A\t+ie\u0016\fG\rT8dC2\u001cu.\u001e8uKJ\u001ch*^7TiV\u001c7nU1na2,7\u000f\u0005\u0002q/M!q#a\u0019R!\u001d\t)'a\u001bWO>l!!a\u001a\u000b\u0007\u0005%4(A\u0004sk:$\u0018.\\3\n\t\u00055\u0014q\r\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA0\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y\u0017QOA<\u0011\u0015!&\u00041\u0001W\u0011\u0015)'\u00041\u0001h\u0003\u001d)h.\u00199qYf$B!! \u0002\nB)!(a \u0002\u0004&\u0019\u0011\u0011Q\u001e\u0003\r=\u0003H/[8o!\u0015Q\u0014Q\u0011,h\u0013\r\t9i\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005-5$!AA\u0002=\f1\u0001\u001f\u00131\u0003A1\u0017N\u001c3TiV\u001c7\u000e\u00165sK\u0006$7\u000fF\u0004:\u0003#\u000by*a/\t\u000f\u0005ME\u00041\u0001\u0002\u0016\u0006\u0019\"M]8lKJDU-\u00197uQ6\u000bg.Y4feB!\u0011qSAN\u001b\t\tIJ\u0003\u0002&a%!\u0011QTAM\u0005M\u0011%o\\6fe\"+\u0017\r\u001c;i\u001b\u0006t\u0017mZ3s\u0011\u001d\t\t\u000b\ba\u0001\u0003G\u000bA\u0002\u001e5sK\u0006$7o\u0015;vG.\u0004\u0002\"!*\u0002,\u0006=\u0016QW\u0007\u0003\u0003OSA!!+\u0002<\u00059Q.\u001e;bE2,\u0017\u0002BAW\u0003O\u00131!T1q!\u0011\t\u0019\"!-\n\t\u0005M\u0016Q\u0003\u0002\u0007)\"\u0014X-\u00193\u0011\u000b\u0005\u0015\u0016qW8\n\t\u0005e\u0016q\u0015\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bBBA_9\u0001\u0007q-\u0001\tok6\u001c\u0016-\u001c9mKN$vnV1ji\u0006\u0019b-\u001b8e\u001dVlG\u000b\u001b:fC\u0012\u001c8\u000b^;dWR)q.a1\u0002F\"9\u0011\u0011U\u000fA\u0002\u0005\r\u0006BBAd;\u0001\u0007q-\u0001\u0006ok6\u001c\u0016-\u001c9mKN\fQ\t^3ti\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5z\u001f:,7\u000b^;dWRC'/Z1e\u0005V$(+Z2pm\u0016\u00148OQ3g_J,'I]8lKJ$U-Z7fIVs\u0007.Z1mi\"LH#A\u001d)\u0007y\ty\r\u0005\u0003\u0002R\u0006\rXBAAj\u0015\u0011\t).a6\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002Z\u0006m\u0017a\u00026va&$XM\u001d\u0006\u0005\u0003;\fy.A\u0003kk:LGO\u0003\u0002\u0002b\u0006\u0019qN]4\n\t\u0005\u0015\u00181\u001b\u0002\u0005)\u0016\u001cH/A\u0014uKN$(I]8lKJDU-\u00197uQ\u001a{'oY3D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007fA\u0010\u0002P\u0006!D/Z:u\u0005J|7.\u001a:IK\u0006dG\u000f[*uCR,8\u000f\u0016:b]NLG/[8o\rJ|WnU;ta\u0016\u001cG\u000fV8IK\u0006dG\u000f[=)\u0007\u0001\ny-A\u0011uKN$H)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0018\t\u001d9mS\u0016$\u0007K]8qKJd\u0017\u0010K\u0002\"\u0003\u001f\f\u0011\u0006^3ti\n\u0013xn[3s\u0011\u0016\fG\u000e\u001e5NC:\fw-\u001a:QCN\u001cX\r\u001a+p!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001\u0012\u0002P\u0002")
public class BrokerHealthManagerIntegrationTest
extends BaseRequestTest {
    private volatile BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$ ThreadLocalCountersNumStuckSamples$module;

    public BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$ ThreadLocalCountersNumStuckSamples() {
        if (this.ThreadLocalCountersNumStuckSamples$module == null) {
            this.ThreadLocalCountersNumStuckSamples$lzycompute$1();
        }
        return this.ThreadLocalCountersNumStuckSamples$module;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
    }

    public void findStuckThreads(BrokerHealthManager brokerHealthManager, scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>> threadsStuck, long numSamplesToWait) {
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + numSamplesToWait) {
            brokerHealthManager.prevThreadLocalCountersSnapshot().forEach((thread, threadLocalCountersList) -> threadLocalCountersList.forEach(threadLocalCounters -> {
                ObjectRef tlcInMap = ObjectRef.create(null);
                ListBuffer threadLocalCountersNumStuckSamplesList = (ListBuffer)threadsStuck.getOrElseUpdate(thread, (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
                threadLocalCountersNumStuckSamplesList.foreach((Function1 & Serializable & scala.Serializable)threadLocalCountersNumStuckSample -> {
                    BrokerHealthManagerIntegrationTest.$anonfun$findStuckThreads$4(threadLocalCounters, tlcInMap, threadLocalCountersNumStuckSample);
                    return BoxedUnit.UNIT;
                });
                if ((ThreadLocalCountersNumStuckSamples)tlcInMap.elem == null) {
                    tlcInMap.elem = new ThreadLocalCountersNumStuckSamples(this, (ThreadLocalCounters)threadLocalCounters, 0L);
                    threadLocalCountersNumStuckSamplesList.$plus$eq((Object)((ThreadLocalCountersNumStuckSamples)tlcInMap.elem));
                }
                if (threadLocalCounters.numInProgressOps >= 1L) {
                    ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples = (ThreadLocalCountersNumStuckSamples)tlcInMap.elem;
                    threadLocalCountersNumStuckSamples.numStuck_$eq(threadLocalCountersNumStuckSamples.numStuck() + threadLocalCounters.numInProgressOps);
                    return;
                }
                ((ThreadLocalCountersNumStuckSamples)tlcInMap.elem).numStuck_$eq(0L);
            }));
        }
    }

    public ThreadLocalCountersNumStuckSamples findNumThreadsStuck(scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>> threadsStuck, long numSamples) {
        ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal = new ThreadLocalCountersNumStuckSamples(this, null, 0L);
        threadsStuck.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BrokerHealthManagerIntegrationTest.$anonfun$findNumThreadsStuck$1(numSamples, threadLocalCountersNumStuckSamplesReturnVal, x0$1);
            return BoxedUnit.UNIT;
        });
        return threadLocalCountersNumStuckSamplesReturnVal;
    }

    @Test
    public void testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy() {
        ReentrantLock lock = new ReentrantLock();
        Condition condition = lock.newCondition();
        AtomicBoolean condVar = new AtomicBoolean(false);
        KafkaServer kafkaServer = (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + 5L) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(!(brokerHealthStatus != null ? !brokerHealthStatus.equals(healthy$) : healthy$ != null));
        }
        int numSamplesEngineThreadGroupsStuck = BrokerHealthManagerIntegrationTest.metricValue$1("BrokerHealthManager", "ContiguousSamplesEngineThreadGroupsStuck");
        int numUnhealthySamples = BrokerHealthManagerIntegrationTest.metricValue$1("BrokerHealthManager", "ContiguousUnhealthySamples");
        int numSamplesNoStorageThreadsMakingProgress = BrokerHealthManagerIntegrationTest.metricValue$1("BrokerHealthManager", "ContiguousSamplesNoStorageThreadMakingProgress");
        Predef$.MODULE$.assert(numSamplesEngineThreadGroupsStuck >= 0);
        Predef$.MODULE$.assert(numUnhealthySamples >= 0);
        Predef$.MODULE$.assert(numSamplesNoStorageThreadsMakingProgress >= 0);
        KafkaScheduler qual$1 = kafkaServer.kafkaScheduler();
        String x$1 = "broker-health-test";
        JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> BrokerHealthManagerIntegrationTest.stuckThreadRunnable$1(lock, condVar, condition);
        long x$3 = qual$1.schedule$default$3();
        long x$4 = qual$1.schedule$default$4();
        TimeUnit x$5 = qual$1.schedule$default$5();
        qual$1.schedule(x$1, (Function0)x$2, x$3, x$4, x$5);
        scala.collection.mutable.Map threadsStuck = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        brokerHealthManager.totalSamples();
        this.findStuckThreads(brokerHealthManager, (scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>>)threadsStuck, 5L);
        int numSamplesStorageThreadGroupsStuck = BrokerHealthManagerIntegrationTest.metricValue$1("BrokerHealthManager", "ContiguousSamplesStorageThreadGroupsStuck");
        ThreadLocalCountersNumStuckSamples threadCountersNumStuckCounters = this.findNumThreadsStuck((scala.collection.mutable.Map<Thread, ListBuffer<ThreadLocalCountersNumStuckSamples>>)threadsStuck, 5L);
        ThreadLocalCounters counters = threadCountersNumStuckCounters.threadLocalCounters();
        long totalThreadCountersStuck = threadCountersNumStuckCounters.numStuck();
        lock.lock();
        condVar.set(true);
        condition.signal();
        lock.unlock();
        Predef$.MODULE$.assert(totalThreadCountersStuck >= 1L);
        Predef$.MODULE$.assert(counters != null);
        ThreadLocalCounters.ThreadGroupType threadGroupType = counters.threadGroupType;
        ThreadLocalCounters.ThreadGroupType threadGroupType2 = ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD;
        Predef$.MODULE$.assert(!(threadGroupType != null ? !threadGroupType.equals(threadGroupType2) : threadGroupType2 != null));
        Predef$.MODULE$.assert(numSamplesStorageThreadGroupsStuck > 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Num of samples storage thread groups stuck = ").append(numSamplesStorageThreadGroupsStuck).toString());
        BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        Predef$.MODULE$.assert(!(brokerHealthStatus != null ? !brokerHealthStatus.equals(healthy$) : healthy$ != null));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerHealthForceControlledShutdown() {
        void setHaltProcedure_haltProcedure;
        VolatileBooleanRef hasCalledExit = VolatileBooleanRef.create((boolean)false);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$1(hasCalledExit, BoxesRunTime.unboxToInt((Object)x$1), x$2);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableLike)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + (long)brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(!(brokerHealthStatus != null ? !brokerHealthStatus.equals(healthy$) : healthy$ != null));
        }
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "0");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$3(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$5(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$7(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$9(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        try {
            long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime5 = System.currentTimeMillis();
            while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$11(kafkaServer)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$12());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime6 = System.currentTimeMillis();
            while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$13(kafkaServer)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$14());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime7 = System.currentTimeMillis();
            while (!hasCalledExit.elem) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthForceControlledShutdown$16());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit$.MODULE$.resetHaltProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerHealthStatusTransitionFromSuspectToHealthy() {
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableLike)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        long currentSamples = brokerHealthManager.totalSamples();
        while (brokerHealthManager.totalSamples() < currentSamples + (long)brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect()) {
            BrokerHealthStatus brokerHealthStatus = brokerHealthManager.brokerHealthStatus();
            Healthy$ healthy$ = Healthy$.MODULE$;
            Predef$.MODULE$.assert(!(brokerHealthStatus != null ? !brokerHealthStatus.equals(healthy$) : healthy$ != null));
        }
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "1");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "0");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "50");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$2(kafkaServer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$4(kafkaServer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicConfigsAppliedProperly() {
        KafkaServer kafkaServer = ((KafkaServer)this.servers().head()).kafkaController().isActive() ? (KafkaServer)((IterableLike)this.servers().tail()).head() : (KafkaServer)this.servers().head();
        BrokerHealthManager brokerHealthManager = kafkaServer.brokerHealthManager();
        Properties props = new Properties();
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 180 ? 1 : 0) != 0, (String)"Default number of unhealthy samples should be 180");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerUnhealthyProp(), "1000");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$2(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 30 ? 1 : 0) != 0, (String)"Default number of suspect samples should be 30");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerNumSamplesBeforeBrokerSuspectProp(), "250");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$5(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 90 ? 1 : 0) != 0, (String)"Default number of suspect samples percentage should be 90");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransitionProp(), "99");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$8(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((brokerHealthManager.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 70 ? 1 : 0) != 0, (String)"Default number of unhealthy samples percentage should be 70");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransitionProp(), "99");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$11(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "AllThreadsStuck");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$14(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$15());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$16(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$17());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l14 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$18(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$19(brokerHealthManager));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "Disabled");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l15 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l16 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime8 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$21(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$22());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l17 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l18 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime9 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$23(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$24());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "AnyThreadStuck");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l19 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l20 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime10 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$26(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime10 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$27());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l21 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l22 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime11 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$28(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime11 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$29());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l23 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l24 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime12 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$30(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime12 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$31(brokerHealthManager));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "2000");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l25 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l26 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime13 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$33(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime13 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$34());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)brokerHealthManager.config().isBrokerHealthManagerMitigationEnabled(), (String)"Mitigation must be on");
        Assertions.assertTrue((boolean)brokerHealthManager.isMitigationEnabled(), (String)"Mitigation must be on");
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "false");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l27 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l28 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime14 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$36(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime14 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$37());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l29 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l30 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime15 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$38(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime15 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$39());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        props.put(KafkaConfig$.MODULE$.BrokerHealthManagerStorageRequestHandlerThreadsStuckCriteriaProp(), "");
        kafkaServer.dynamicConfigHandlers().get((Object)ConfigType$.MODULE$.Broker()).foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.processConfigChanges(ConfigEntityName$.MODULE$.Default(), props);
            return BoxedUnit.UNIT;
        });
        long l31 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l32 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime16 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$41(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime16 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$42());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l33 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l34 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime17 = System.currentTimeMillis();
        while (!BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$43(brokerHealthManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime17 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerHealthManagerIntegrationTest.$anonfun$testDynamicConfigsAppliedProperly$44());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testBrokerHealthManagerPassedToPartitions() {
        String topic = "topic1";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)this.createTopicWithAssignment("topic1", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.createTopicWithAssignment$default$3()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        KafkaServer kafkaServer = (KafkaServer)this.serverForId(leader).get();
        Assertions.assertNotNull((Object)kafkaServer.brokerHealthManager());
        Assertions.assertTrue((boolean)kafkaServer.replicaManager().brokerHealthManager().nonEmpty());
        TopicPartition tp = new TopicPartition(topic, partition);
        HostedPartition hostedPartition = kafkaServer.replicaManager().getPartition(tp);
        boolean bl = hostedPartition instanceof HostedPartition.Online ? ((HostedPartition.Online)hostedPartition).partition().brokerHealthManagerOpt().nonEmpty() : false;
        Assertions.assertTrue((boolean)bl);
    }

    private final void ThreadLocalCountersNumStuckSamples$lzycompute$1() {
        synchronized (this) {
            if (this.ThreadLocalCountersNumStuckSamples$module == null) {
                this.ThreadLocalCountersNumStuckSamples$module = new BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$findStuckThreads$4(ThreadLocalCounters threadLocalCounters$1, ObjectRef tlcInMap$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSample) {
        block7: {
            block6: {
                ThreadLocalCounters.MetricComponentType metricComponentType;
                ThreadLocalCounters.MetricComponentType metricComponentType2;
                block5: {
                    metricComponentType2 = threadLocalCountersNumStuckSample.threadLocalCounters().metricComponentType;
                    metricComponentType = threadLocalCounters$1.metricComponentType;
                    if (metricComponentType2 != null) break block5;
                    if (metricComponentType != null) {
                        return;
                    }
                    break block6;
                }
                if (!metricComponentType2.equals(metricComponentType)) break block7;
            }
            tlcInMap$1.elem = threadLocalCountersNumStuckSample;
        }
    }

    public static final /* synthetic */ void $anonfun$findNumThreadsStuck$2(long numSamples$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples) {
        if (threadLocalCountersNumStuckSamples.numStuck() >= numSamples$1) {
            threadLocalCountersNumStuckSamplesReturnVal$1.threadLocalCounters_$eq(threadLocalCountersNumStuckSamples.threadLocalCounters());
            threadLocalCountersNumStuckSamplesReturnVal$1.numStuck_$eq(threadLocalCountersNumStuckSamplesReturnVal$1.numStuck() + 1L);
        }
    }

    public static final /* synthetic */ void $anonfun$findNumThreadsStuck$1(long numSamples$1, ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamplesReturnVal$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ((ListBuffer)x0$1._2()).foreach((Function1 & Serializable & scala.Serializable)threadLocalCountersNumStuckSamples -> {
                BrokerHealthManagerIntegrationTest.$anonfun$findNumThreadsStuck$2(numSamples$1, threadLocalCountersNumStuckSamplesReturnVal$1, threadLocalCountersNumStuckSamples);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$1(ReentrantLock lock$1, AtomicBoolean condVar$1, Condition condition$1) {
        lock$1.lock();
        while (!condVar$1.get()) {
            condition$1.await();
        }
        lock$1.unlock();
    }

    private static final void stuckThreadRunnable$1(ReentrantLock lock$1, AtomicBoolean condVar$1, Condition condition$1) {
        ThreadCountersManager.wrapIO(() -> {
            BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$1(lock$1, condVar$1, condition$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$2(String name$1, String metricType$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getName();
        if (string == null) {
            if (name$1 != null) {
                return false;
            }
        } else if (!string.equals(name$1)) return false;
        String string2 = metricName.getType();
        if (string2 == null) {
            if (metricType$1 == null) return true;
            return false;
        } else {
            if (!string2.equals(metricType$1)) return false;
            return true;
        }
    }

    private static final int metricValue$1(String metricType, String name) {
        return BoxesRunTime.unboxToInt((Object)((Gauge)((Tuple2)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerHealthManagerIntegrationTest.$anonfun$testBrokerHealthyOneStuckThreadButRecoversBeforeBrokerDeemedUnhealthy$2(name, metricType, x0$1)))).head())._2()).value());
    }

    public static final /* synthetic */ Nothing$ $anonfun$testBrokerHealthForceControlledShutdown$1(VolatileBooleanRef hasCalledExit$1, int x$1, Option x$2) {
        hasCalledExit$1.elem = true;
        throw new Exception();
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$3(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 1;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$4() {
        return "Num Samples is not 1";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$5(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 1;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$6() {
        return "Num Samples is not 1";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$7(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$8() {
        return "Num Samples is not 0";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$9(BrokerHealthManager brokerHealthManager$1) {
        return brokerHealthManager$1.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 0;
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$10() {
        return "Num Samples is not 0";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$11(KafkaServer kafkaServer$1) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$1.brokerHealthManager().brokerHealthStatus();
        Unhealthy$ unhealthy$ = Unhealthy$.MODULE$;
        return !(brokerHealthStatus != null ? !brokerHealthStatus.equals(unhealthy$) : unhealthy$ != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$12() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthForceControlledShutdown$13(KafkaServer kafkaServer$1) {
        BrokerState brokerState = kafkaServer$1.brokerState();
        BrokerState brokerState2 = BrokerState.SHUTTING_DOWN;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$14() {
        return "Broker is not undergoing controlled shutdown";
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthForceControlledShutdown$16() {
        return "Exit wasn't triggered";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$2(KafkaServer kafkaServer$2) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$2.brokerHealthManager().brokerHealthStatus();
        Suspect$ suspect$ = Suspect$.MODULE$;
        return !(brokerHealthStatus != null ? !brokerHealthStatus.equals(suspect$) : suspect$ != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$3() {
        return "Broker is still Healthy";
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$4(KafkaServer kafkaServer$2) {
        BrokerHealthStatus brokerHealthStatus = kafkaServer$2.brokerHealthManager().brokerHealthStatus();
        Healthy$ healthy$ = Healthy$.MODULE$;
        return !(brokerHealthStatus != null ? !brokerHealthStatus.equals(healthy$) : healthy$ != null);
    }

    public static final /* synthetic */ String $anonfun$testBrokerHealthStatusTransitionFromSuspectToHealthy$5() {
        return "Broker is still Suspect";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$2(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerNumSamplesBeforeBrokerUnhealthy() == 1000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$3() {
        return "Num Samples is not 1000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$5(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerNumSamplesBeforeBrokerSuspect() == 250;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$6() {
        return "Num Samples is not 250";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$8(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerPercentageUnhealthySamplesForHealthyToSuspectStateTransition() == 99;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$9() {
        return "Num % Samples is not 99";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$11(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerPercentageUnhealthySamplesForSuspectToUnhealthyStateTransition() == 99;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$12() {
        return "Num % Samples is not 99";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$14(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$15() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$16(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$17() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$18(BrokerHealthManager brokerHealthManager$2) {
        Object object = brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
        AllThreadsStuck$ allThreadsStuck$ = AllThreadsStuck$.MODULE$;
        return !(object != null ? !object.equals(allThreadsStuck$) : allThreadsStuck$ != null);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$19(BrokerHealthManager brokerHealthManager$2) {
        return new StringBuilder(39).append("Request Handler thread status criteria ").append(brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$21(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$22() {
        return "Thread status criteria size is not 2";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$23(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$24() {
        return "Request handler thread is still present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$26(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$27() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$28(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$29() {
        return "Request handler thread isn't present";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$30(BrokerHealthManager brokerHealthManager$2) {
        Object object = brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
        AnyThreadStuck$ anyThreadStuck$ = AnyThreadStuck$.MODULE$;
        return !(object != null ? !object.equals(anyThreadStuck$) : anyThreadStuck$ != null);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$31(BrokerHealthManager brokerHealthManager$2) {
        return new StringBuilder(39).append("Request Handler thread status criteria ").append(brokerHealthManager$2.config().storageThreadStatusCriteria().apply((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$33(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().brokerHealthManagerSampleDurationMs() == 2000;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$34() {
        return "SampleDurationMs is not 2000";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$36(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.config().isBrokerHealthManagerMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$37() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$38(BrokerHealthManager brokerHealthManager$2) {
        return !brokerHealthManager$2.isMitigationEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$39() {
        return "Mitigation must be off";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$41(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$42() {
        return "Thread status criteria size is not 3";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicConfigsAppliedProperly$43(BrokerHealthManager brokerHealthManager$2) {
        return brokerHealthManager$2.config().storageThreadStatusCriteria().contains((Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
    }

    public static final /* synthetic */ String $anonfun$testDynamicConfigsAppliedProperly$44() {
        return "Request handler thread isn't present";
    }

    public BrokerHealthManagerIntegrationTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerEnabledProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerSampleDurationMsProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.BrokerHealthManagerMitigationEnabledProp(), "true");
    }

    public class ThreadLocalCountersNumStuckSamples
    implements Product,
    scala.Serializable {
        private ThreadLocalCounters threadLocalCounters;
        private long numStuck;
        public final /* synthetic */ BrokerHealthManagerIntegrationTest $outer;

        public ThreadLocalCounters threadLocalCounters() {
            return this.threadLocalCounters;
        }

        public void threadLocalCounters_$eq(ThreadLocalCounters x$1) {
            this.threadLocalCounters = x$1;
        }

        public long numStuck() {
            return this.numStuck;
        }

        public void numStuck_$eq(long x$1) {
            this.numStuck = x$1;
        }

        public ThreadLocalCountersNumStuckSamples copy(ThreadLocalCounters threadLocalCounters, long numStuck) {
            return new ThreadLocalCountersNumStuckSamples(this.integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer(), threadLocalCounters, numStuck);
        }

        public ThreadLocalCounters copy$default$1() {
            return this.threadLocalCounters();
        }

        public long copy$default$2() {
            return this.numStuck();
        }

        public String productPrefix() {
            return "ThreadLocalCountersNumStuckSamples";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.threadLocalCounters();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.numStuck());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ThreadLocalCountersNumStuckSamples;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.threadLocalCounters())), (int)Statics.longHash((long)this.numStuck())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ThreadLocalCountersNumStuckSamples)) return false;
            if (((ThreadLocalCountersNumStuckSamples)x$1).integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer() != this.integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ThreadLocalCountersNumStuckSamples threadLocalCountersNumStuckSamples = (ThreadLocalCountersNumStuckSamples)x$1;
            ThreadLocalCounters threadLocalCounters = this.threadLocalCounters();
            ThreadLocalCounters threadLocalCounters2 = threadLocalCountersNumStuckSamples.threadLocalCounters();
            if (threadLocalCounters == null) {
                if (threadLocalCounters2 != null) {
                    return false;
                }
            } else if (!threadLocalCounters.equals(threadLocalCounters2)) return false;
            if (this.numStuck() != threadLocalCountersNumStuckSamples.numStuck()) return false;
            if (!threadLocalCountersNumStuckSamples.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BrokerHealthManagerIntegrationTest integration$kafka$availability$BrokerHealthManagerIntegrationTest$ThreadLocalCountersNumStuckSamples$$$outer() {
            return this.$outer;
        }

        public ThreadLocalCountersNumStuckSamples(BrokerHealthManagerIntegrationTest $outer, ThreadLocalCounters threadLocalCounters, long numStuck) {
            this.threadLocalCounters = threadLocalCounters;
            this.numStuck = numStuck;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

