/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.catalog;

import java.io.Serializable;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.TestUtils$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT, brokers=3, controllers=3)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001q4Aa\u0002\u0005\u0001\u001f!Aa\u0003\u0001B\u0001B\u0003%q\u0003C\u0003-\u0001\u0011\u0005Q\u0006C\u00032\u0001\u0011\u0005!\u0007C\u0003W\u0001\u0011%q\u000bC\u0003\\\u0001\u0011%!\u0007C\u0003]\u0001\u0011%!G\u0001\u0017L%\u00064G/T3uC\u0012\fG/Y\"pY2,7\r^8s\u000b:\f'\r\\3e\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011\u0011BC\u0001\bG\u0006$\u0018\r\\8h\u0015\tYA\"A\u0003lC\u001a\\\u0017MC\u0001\u000e\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feB\u0011\u0001$\u000b\b\u00033\u0019r!AG\u0012\u000f\u0005m\u0001cB\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u000f\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\"E\u0005!A/Z:u\u0015\u0005Y\u0011B\u0001\u0013&\u0003\u0015QWO\\5u\u0015\t\t#%\u0003\u0002(Q\u0005a\"+\u00194u\u00072,8\u000f^3s\u0013:4xnY1uS>t7i\u001c8uKb$(B\u0001\u0013&\u0013\tQ3FA\nSC\u001a$8\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cWM\u0003\u0002(Q\u00051A(\u001b8jiz\"\"A\f\u0019\u0011\u0005=\u0002Q\"\u0001\u0005\t\u000bY\u0011\u0001\u0019A\f\u00029Q,7\u000f^'fi\u0006$\u0017\r^1D_2dWm\u0019;pe\u0016s\u0017M\u00197fIR\t1\u0007\u0005\u0002\u0012i%\u0011QG\u0005\u0002\u0005+:LG\u000f\u000b\u0003\u0004our\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e&\u0003)\tgN\\8uCRLwN\\\u0005\u0003ye\u00121b\u00117vgR,'\u000fV3ti\u0006\u00012/\u001a:wKJ\u0004&o\u001c9feRLWm\u001d\u0017\u0002\u007f-*\u0001i\u0011#G\u000fB\u0011\u0001(Q\u0005\u0003\u0005f\u0012Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f\u0013!R\u0001#G>tg\r\\;f]Rt3-\u0019;bY><gfY8mY\u0016\u001cGo\u001c:/K:\f'\r\\3\u0002\u000bY\fG.^3\"\u0003!\u000bA\u0001\u001e:vK\"\"1A\u0013$V!\tY5+D\u0001M\u0015\tie*A\u0002ba&T!a\u0014)\u0002\u000f),\b/\u001b;fe*\u0011A%\u0015\u0006\u0002%\u0006\u0019qN]4\n\u0005Qc%a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002\u0015\u0005!\u0012m\u0019;jm\u0016\u001cu\u000e\u001c7fGR|'oQ8v]R,\u0012\u0001\u0017\t\u0003#eK!A\u0017\n\u0003\u0007%sG/\u0001\u000fwKJLg-_(oYf|e.Z!di&4XmQ8mY\u0016\u001cGo\u001c:\u0002%\r|g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0005\u0001y3\u0015\r\u0005\u0002L?&\u0011\u0001\r\u0014\u0002\u0004)\u0006<\u0017%A\u0007)\u0011\u0001\u0019gm\u001a7n]6\u0004\"\u0001\u000f3\n\u0005\u0015L$aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001c\u0018aC2mkN$XM\u001d+za\u0016$\u0013\u0001[\u0005\u0003S*\fQa\u0013*B\rRS!a[\u001d\u0002\tQK\b/Z\u0001\bEJ|7.\u001a:t;\u0005\u0019\u0011aC2p]R\u0014x\u000e\u001c7feNDC\u0001\u00019GmB\u0011\u0011\u000f^\u0007\u0002e*\u00111\u000fT\u0001\nKb$XM\\:j_:L!!\u001e:\u0003\u0015\u0015CH/\u001a8e/&$\b\u000eL\u0001xG\u0005A\bCA={\u001b\u0005A\u0013BA>)\u0005U\u0019E.^:uKJ$Vm\u001d;FqR,gn]5p]N\u0004")
public class KRaftMetadataCollectorEnabledIntegrationTest {
    private final RaftClusterInvocationContext.RaftClusterInstance cluster;

    /*
     * WARNING - void declaration
     */
    @Timeout(value=10L)
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.catalog.collector.enable", value="true")})
    public void testMetadataCollectorEnabled() {
        this.cluster.waitForReadyBrokers();
        this.verifyOnlyOneActiveCollector();
        this.controllerFailover();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$testMetadataCollectorEnabled$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$testMetadataCollectorEnabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyOnlyOneActiveCollector();
    }

    private int activeCollectorCount() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllerServers()).asScala()).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$activeCollectorCount$1(x$1)));
    }

    private void verifyOnlyOneActiveCollector() {
        IntRef activeCount = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllerServers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)controllerServer -> {
            KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$verifyOnlyOneActiveCollector$1(activeCount, controllerServer);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokersMap().values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> (BrokerServer)x$5, Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)broker -> {
            KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$verifyOnlyOneActiveCollector$5(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)activeCount.elem, (String)"Should have exactly one active collector");
    }

    private void controllerFailover() {
        ControllerServer oldLeader = (ControllerServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllerServers()).asScala()).find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$controllerFailover$1(x$7))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("No controller leader found, should not have happened");
        });
        int oldEpoch = KRaftMetadataCollectorEnabledIntegrationTest.getCurrentEpoch$1(oldLeader);
        oldLeader.raftManager().client().resign(oldEpoch);
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllerServers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)controller -> {
            KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$controllerFailover$3(oldEpoch, controller);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataCollectorEnabled$1(KRaftMetadataCollectorEnabledIntegrationTest $this) {
        return $this.activeCollectorCount() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testMetadataCollectorEnabled$2() {
        return "No active collector after leader change";
    }

    public static final /* synthetic */ boolean $anonfun$activeCollectorCount$1(ControllerServer x$1) {
        return x$1.metadataCollector().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isActive()));
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyOneActiveCollector$1(IntRef activeCount$1, ControllerServer controllerServer) {
        if (controllerServer.controller().isActive()) {
            Assertions.assertTrue((boolean)controllerServer.metadataCollector().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isActive())));
            ++activeCount$1.elem;
            return;
        }
        Assertions.assertFalse((boolean)controllerServer.metadataCollector().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isActive())));
    }

    public static final /* synthetic */ void $anonfun$verifyOnlyOneActiveCollector$5(BrokerServer broker) {
        Assertions.assertFalse((boolean)broker.metadataCollector().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isActive())));
    }

    private static final int getCurrentEpoch$1(ControllerServer controller) {
        return controller.raftManager().leaderAndEpoch().epoch();
    }

    public static final /* synthetic */ boolean $anonfun$controllerFailover$1(ControllerServer x$7) {
        return x$7.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$controllerFailover$4(ControllerServer controller$1, int oldEpoch$1) {
        return KRaftMetadataCollectorEnabledIntegrationTest.getCurrentEpoch$1(controller$1) > oldEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$controllerFailover$5() {
        return "Leader didn't advance epoch";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$controllerFailover$3(int oldEpoch$1, ControllerServer controller) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$controllerFailover$4(controller, oldEpoch$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KRaftMetadataCollectorEnabledIntegrationTest.$anonfun$controllerFailover$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public KRaftMetadataCollectorEnabledIntegrationTest(RaftClusterInvocationContext.RaftClusterInstance cluster) {
        this.cluster = cluster;
    }
}

