/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.coordinator.quota;

import integration.kafka.coordinator.quota.TestClientQuotaCallback;
import integration.kafka.coordinator.quota.TestClientQuotaCallback$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.ReportQuotaConsumptionRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u000f\u001e\u0001\u0019BQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004;\u0001\u0001\u0006I\u0001\u000e\u0005\bw\u0001\u0011\r\u0011\"\u00014\u0011\u0019a\u0004\u0001)A\u0005i!9Q\b\u0001b\u0001\n\u0003\u0019\u0004B\u0002 \u0001A\u0003%A\u0007C\u0004@\u0001\t\u0007I\u0011A\u001a\t\r\u0001\u0003\u0001\u0015!\u00035\u0011\u001d\t\u0005A1A\u0005\u0002MBaA\u0011\u0001!\u0002\u0013!\u0004\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001E\u0011%\u0011\u0006\u00011AA\u0002\u0013\u00051\u000bC\u0005Z\u0001\u0001\u0007\t\u0011)Q\u0005\u000b\"I!\f\u0001a\u0001\u0002\u0004%\ta\u0017\u0005\nE\u0002\u0001\r\u00111A\u0005\u0002\rD\u0011\"\u001a\u0001A\u0002\u0003\u0005\u000b\u0015\u0002/\t\u0013\u0019\u0004\u0001\u0019!a\u0001\n\u00039\u0007\"\u00038\u0001\u0001\u0004\u0005\r\u0011\"\u0001p\u0011%\t\b\u00011A\u0001B\u0003&\u0001\u000eC\u0003s\u0001\u0011\u00053\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\n\u0003w\u0003\u0011\u0013!C\u0005\u0003{Ca!a5\u0001\t#\u001a$!\u0005#z]\u0006l\u0017nY)v_R\f7\u000fV3ti*\u0011adH\u0001\u0006cV|G/\u0019\u0006\u0003A\u0005\n1bY8pe\u0012Lg.\u0019;pe*\u0011!eI\u0001\u0006W\u000647.\u0019\u0006\u0002I\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!bS\"A\u0015\u000b\u0005)Z\u0013aA1qS*\t!%\u0003\u0002.S\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002aA\u0011\u0011\u0007A\u0007\u0002;\u0005Qa.^7TKJ4XM]:\u0016\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u00121!\u00138u\u0003-qW/\\*feZ,'o\u001d\u0011\u000219,X.U;pi\u0006\u001cHk\u001c9jGB\u000b'\u000f^5uS>t7/A\rok6\fVo\u001c;bgR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0013a\u00022s_.,'\u000fM\u0001\tEJ|7.\u001a:1A\u00059!M]8lKJ\f\u0014\u0001\u00032s_.,'/\r\u0011\u0002'\t\u0014xn[3s\u0019&l\u0017\u000e\u001e)s_\u0012,8-\u001a:\u0002)\t\u0014xn[3s\u0019&l\u0017\u000e\u001e)s_\u0012,8-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0003\u0015\u0003\"A\u0012)\u000e\u0003\u001dS!\u0001S%\u0002\u000bU$\u0018\u000e\\:\u000b\u0005)[\u0015AB2p[6|gN\u0003\u0002#\u0019*\u0011QJT\u0001\u0007CB\f7\r[3\u000b\u0003=\u000b1a\u001c:h\u0013\t\tvI\u0001\u0003US6,\u0017\u0001\u0003;j[\u0016|F%Z9\u0015\u0005Q;\u0006CA\u001bV\u0013\t1fG\u0001\u0003V]&$\bb\u0002-\u000e\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014!\u0002;j[\u0016\u0004\u0013AB2p]\u001aLw-F\u0001]!\ti\u0006-D\u0001_\u0015\ty6&\u0001\u0004tKJ4XM]\u0005\u0003Cz\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0005Q#\u0007b\u0002-\u0011\u0003\u0003\u0005\r\u0001X\u0001\bG>tg-[4!\u00035qW\r^<pe.\u001cE.[3oiV\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002l\u0017\u000691\r\\5f]R\u001c\u0018BA7k\u00055qU\r^<pe.\u001cE.[3oi\u0006\tb.\u001a;x_J\\7\t\\5f]R|F%Z9\u0015\u0005Q\u0003\bb\u0002-\u0014\u0003\u0003\u0005\r\u0001[\u0001\u000f]\u0016$xo\u001c:l\u00072LWM\u001c;!\u0003\u0015\u0019X\r^+q)\t!F\u000fC\u0003v+\u0001\u0007a/\u0001\u0005uKN$\u0018J\u001c4p!\t9X0D\u0001y\u0015\tQ\u0013P\u0003\u0002{w\u00069!.\u001e9ji\u0016\u0014(B\u0001?O\u0003\u0015QWO\\5u\u0013\tq\bP\u0001\u0005UKN$\u0018J\u001c4pQ\r)\u0012\u0011\u0001\t\u0004o\u0006\r\u0011bAA\u0003q\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f\u001e*fa>\u0014HoQ8ogVl\u0007\u000f^5p]R\u0019A+a\u0003\t\u000f\u00055a\u00031\u0001\u0002\u0010\u00051\u0011/^8sk6\u0004B!!\u0005\u0002 9!\u00111CA\u000e!\r\t)BN\u0007\u0003\u0003/Q1!!\u0007&\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0004\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\tiB\u000e\u0015\b-\u0005\u001d\u0012qGA\u001d!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003cI\u0018A\u00029be\u0006l7/\u0003\u0003\u00026\u0005-\"a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002<\u0005}\u0012EAA\u001f\u0003\tQ8.\t\u0002\u0002B\u0005)1N]1gi\":a#!\u0012\u0002N\u0005=\u0003\u0003BA$\u0003\u0013j!!a\f\n\t\u0005-\u0013q\u0006\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!!\u0015\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0A\fuKN$\u0018+^8uCN$v\u000e]5d\r\u0006LGn\u001c<feR\u0019A+a\u0016\t\u000f\u00055q\u00031\u0001\u0002\u0010!:q#a\n\u00028\u0005mC\u0006BA\u001e\u0003\u007fAsaFA#\u0003\u001b\ny%A\nuKN$\u0018+^8uC\u0016C\b/\u001b:bi&|g\u000eF\u0002U\u0003GBq!!\u0004\u0019\u0001\u0004\ty\u0001K\u0004\u0019\u0003O\t9$a\u001a-\t\u0005m\u0012q\b\u0015\b1\u0005\u0015\u0013QJA(\u0003E9W\r\u001e*fcV,7\u000f\u001e\"vS2$WM\u001d\u000b\r\u0003_\n\u0019)a\"\u0002\u0018\u0006\u001d\u0016\u0011\u0017\t\u0005\u0003c\niH\u0004\u0003\u0002t\u0005eTBAA;\u0015\r\t9(S\u0001\te\u0016\fX/Z:ug&!\u00111PA;\u0003u\u0011V\r]8siF+x\u000e^1D_:\u001cX/\u001c9uS>t'+Z9vKN$\u0018\u0002BA@\u0003\u0003\u0013qAQ;jY\u0012,'O\u0003\u0003\u0002|\u0005U\u0004BBAC3\u0001\u0007A'\u0001\u0005ce>\\WM]%e\u0011\u001d\tI)\u0007a\u0001\u0003\u0017\u000b1\"];pi\u0006,e\u000e^5usB!\u0011QRAJ\u001b\t\tyIC\u0002\u001f\u0003#S!\u0001I\u0016\n\t\u0005U\u0015q\u0012\u0002\f#V|G/Y#oi&$\u0018\u0010C\u0004\u0002\u001af\u0001\r!a'\u0002\u001f\rd\u0017.\u001a8u#V|G/\u0019+za\u0016\u0004B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004=\u0005\u0005&BA0L\u0013\u0011\t)+a(\u0003\u001f\rc\u0017.\u001a8u#V|G/\u0019+za\u0016Dq!!+\u001a\u0001\u0004\tY+A\u0003vg\u0006<W\rE\u00026\u0003[K1!a,7\u0005\u0019!u.\u001e2mK\"I\u00111W\r\u0011\u0002\u0003\u0007\u0011QW\u0001\ni\"\u0014x\u000e\u001e;mK\u0012\u00042!NA\\\u0013\r\tIL\u000e\u0002\b\u0005>|G.Z1o\u0003m9W\r\u001e*fcV,7\u000f\u001e\"vS2$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0018\u0016\u0005\u0003k\u000b\tm\u000b\u0002\u0002DB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017!C;oG\",7m[3e\u0015\r\tiMN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAi\u0003\u000f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003-\u0011'o\\6fe\u000e{WO\u001c;")
public class DynamicQuotasTest
extends IntegrationTestHarness {
    private final int numServers;
    private final int numQuotasTopicPartitions;
    private final int broker0;
    private final int broker1;
    private final int brokerLimitProducer;
    private Time time;
    private KafkaConfig config;
    private NetworkClient networkClient;

    public int numServers() {
        return this.numServers;
    }

    public int numQuotasTopicPartitions() {
        return this.numQuotasTopicPartitions;
    }

    public int broker0() {
        return this.broker0;
    }

    public int broker1() {
        return this.broker1;
    }

    public int brokerLimitProducer() {
        return this.brokerLimitProducer;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public NetworkClient networkClient() {
        return this.networkClient;
    }

    public void networkClient_$eq(NetworkClient x$1) {
        this.networkClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.serverConfig().put(KafkaConfig$.MODULE$.DynamicQuotaEnabledProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasTopicPartitionsProp(), Integer.toString(this.numQuotasTopicPartitions()));
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasTopicReplicationFactorProp(), Integer.toString(2));
        this.serverConfig().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), TestClientQuotaCallback.class.getName());
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasExpirationTimeMsProp(), Integer.toString(0));
        this.serverConfig().put(KafkaConfig$.MODULE$.QuotasExpirationIntervalMsProp(), Integer.toString(2000));
        this.serverConfig().put("confluent.quota.tenant.broker.max.producer.rate", Integer.toString(this.brokerLimitProducer()));
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.brokers(), "_confluent-quotas", this.numQuotasTopicPartitions());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            DynamicQuotasTest.$anonfun$setUp$1(broker);
            return BoxedUnit.UNIT;
        });
        this.config_$eq(((KafkaBroker)this.brokers().head()).config());
        this.time_$eq(((KafkaBroker)this.brokers().head()).time());
        Metrics metrics = ((KafkaBroker)this.brokers().head()).metrics();
        LogContext logContext = new LogContext("DynamicQuotasTest ");
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.config().interBrokerSecurityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config(), (ListenerName)this.config().interBrokerListenerName(), (String)this.config().saslMechanismInterBrokerProtocol(), (Time)this.time(), (boolean)this.config().saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), metrics, this.time(), "dynamic-quota-test-client-metrics", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), false, channelBuilder, logContext);
        this.networkClient_$eq(new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), "dynamic-quota-test-client", 1, 50L, 50L, -1, Predef$.MODULE$.Integer2int(this.config().socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config().connectionSetupTimeoutMaxMs()), this.time(), false, new ApiVersions(), logContext));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReportConsumption(String quorum) {
        Node node;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        int partition = ((QuotaCoordinator)((KafkaBroker)this.brokers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        Option option = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            int brokerId = broker.config().brokerId();
            ReportQuotaConsumptionRequest.Builder requestBuilder = this.getRequestBuilder(brokerId, quotaEntity, ClientQuotaType.PRODUCE, (double)(brokerId + 1) * 100.0, this.getRequestBuilder$default$5());
            ClientRequest request = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)requestBuilder, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$1(response));
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
                Assertions.fail((String)new StringBuilder(24).append("Node ").append(node).append(" never became ready").toString());
            }
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        });
        Map quotas = ((QuotaDescription)((QuotaCoordinator)((KafkaBroker)this.brokers().apply(node.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity)._2()).brokerQuotas();
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            DynamicQuotasTest.$anonfun$testReportConsumption$3(quotas, broker);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testQuotasTopicFailover(String quorum) {
        void var29_28;
        void var28_27;
        Node node;
        void var20_19;
        void var19_18;
        Node node2;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        double usageBroker0 = 1000.0;
        double usageBroker1 = 2000.0;
        int partition = ((QuotaCoordinator)((KafkaBroker)this.brokers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        int initialLeader = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), "_confluent-quotas", partition, TestUtils$.MODULE$.waitForPartitionMetadata$default$4()).leader();
        Option option = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node2 = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node2 = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        ReportQuotaConsumptionRequest.Builder requestBuilderBroker0 = this.getRequestBuilder(this.broker0(), quotaEntity, ClientQuotaType.PRODUCE, usageBroker0, this.getRequestBuilder$default$5());
        ClientRequest requestBroker0 = this.networkClient().newClientRequest(node2.idString(), (AbstractRequest.Builder)requestBuilderBroker0, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$2(response));
        if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node2, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
            Assertions.fail((String)new StringBuilder(24).append("Node ").append(node2).append(" never became ready").toString());
        }
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)requestBroker0, (Time)this.time());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicQuotasTest.$anonfun$testQuotasTopicFailover$2(this, initialLeader, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicQuotasTest.$anonfun$testQuotasTopicFailover$3(initialLeader));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long lastUpdatedTimestamp = ((QuotaEntry)((QuotaCoordinator)((KafkaBroker)this.brokers().apply(initialLeader)).quotaCoordinatorOpt().get()).quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp();
        ((KafkaBroker)this.brokers().apply(initialLeader)).shutdown();
        ((KafkaBroker)this.brokers().apply(initialLeader)).awaitShutdown();
        int newLeader = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), "_confluent-quotas", partition, TestUtils$.MODULE$.waitForPartitionMetadata$default$4()).leader();
        QuotaCoordinator newCoordinator = (QuotaCoordinator)((KafkaBroker)this.brokers().apply(newLeader)).quotaCoordinatorOpt().get();
        Tuple2 tuple2 = newCoordinator.describeQuota(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Errors error = (Errors)tuple2._1();
        QuotaDescription loadedQuota = (QuotaDescription)tuple2._2();
        void error2 = var19_18;
        double quotaValue = BoxesRunTime.unboxToDouble((Object)((MapLike)var20_19.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker0()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)error2, (String)new StringBuilder(37).append("Got error ").append(error2).append(" when describing quota for ").append(quotaEntity).toString());
        Assertions.assertEquals((double)this.brokerLimitProducer(), (double)quotaValue, (String)new StringBuilder(44).append("Loaded quotas ").append(quotaValue).append(" did not match expected quota ").append(this.brokerLimitProducer()).toString());
        Assertions.assertEquals((long)lastUpdatedTimestamp, (long)((QuotaEntry)newCoordinator.quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp(), (String)new StringBuilder(63).append("Loaded last update timestamp ").append(((QuotaEntry)newCoordinator.quotaStateManager().getQuota(quotaEntity).get()).lastUpdatedTimestamp()).append(" ").append("did not match expected timestamp ").append(lastUpdatedTimestamp).toString());
        ReportQuotaConsumptionRequest.Builder requestBuilderBroker1 = this.getRequestBuilder(this.broker1(), quotaEntity, ClientQuotaType.PRODUCE, usageBroker1, this.getRequestBuilder$default$5());
        Option option2 = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option2 instanceof Some) {
            node = (Node)((Some)option2).value();
        } else if (None$.MODULE$.equals(option2)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option2);
        }
        ClientRequest request = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)requestBuilderBroker1, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$2(response));
        if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
            Assertions.fail((String)new StringBuilder(24).append("Node ").append(node).append(" never became ready").toString());
        }
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        Tuple2 tuple22 = newCoordinator.describeQuota(quotaEntity);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Errors newError = (Errors)tuple22._1();
        QuotaDescription newLoadedQuota = (QuotaDescription)tuple22._2();
        void newError2 = var28_27;
        void newLoadedQuota2 = var29_28;
        double quotaValueBroker0 = BoxesRunTime.unboxToDouble((Object)((MapLike)newLoadedQuota2.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker0()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        double quotaValueBroker1 = BoxesRunTime.unboxToDouble((Object)((MapLike)newLoadedQuota2.brokerQuotas().apply((Object)BoxesRunTime.boxToInteger((int)this.broker1()))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((Object)Errors.NONE, (Object)newError2, (String)new StringBuilder(37).append("Got error ").append(newError2).append(" when describing quota for ").append(quotaEntity).toString());
        Assertions.assertEquals((double)40000.0, (double)quotaValueBroker0, (String)new StringBuilder(51).append("Loaded quotas ").append(quotaValueBroker0).append(" did not match expected quota 40000.0").toString());
        Assertions.assertEquals((double)80000.0, (double)quotaValueBroker1, (String)new StringBuilder(51).append("Loaded quotas ").append(quotaValueBroker1).append(" did not match expected quota 80000.0").toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testQuotaExpiration(String quorum) {
        Node node;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"tenant1")})));
        int partition = ((QuotaCoordinator)((KafkaBroker)this.brokers().head()).quotaCoordinatorOpt().get()).partitionFor(quotaEntity);
        Option option = ((KafkaBroker)this.brokers().head()).metadataCache().getPartitionLeaderEndpoint("_confluent-quotas", partition, this.config().interBrokerListenerName());
        if (option instanceof Some) {
            node = (Node)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            node = (Node)Assertions.fail((String)new StringBuilder(46).append("Could not get node for quotas topic partition ").append(partition).toString());
        } else {
            throw new MatchError((Object)option);
        }
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            int brokerId = broker.config().brokerId();
            ReportQuotaConsumptionRequest.Builder requestBuilder = this.getRequestBuilder(brokerId, quotaEntity, ClientQuotaType.PRODUCE, (double)(brokerId + 1) * 100.0, this.getRequestBuilder$default$5());
            ClientRequest request = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)requestBuilder, this.time().milliseconds(), true, Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), response -> DynamicQuotasTest.requestCallback$3(response));
            if (!NetworkClientUtils.awaitReady((KafkaClient)this.networkClient(), (Node)node, (Time)this.time(), (long)this.config().requestTimeoutMs().longValue())) {
                Assertions.fail((String)new StringBuilder(24).append("Node ").append(node).append(" never became ready").toString());
            }
            return NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)request, (Time)this.time());
        });
        Map quotas = ((QuotaDescription)((QuotaCoordinator)((KafkaBroker)this.brokers().apply(node.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity)._2()).brokerQuotas();
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            DynamicQuotasTest.$anonfun$testQuotaExpiration$3(quotas, broker);
            return BoxedUnit.UNIT;
        });
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        alterableConfigs.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.QuotasExpirationTimeMsProp()).setValue("5000").setConfigOperation(AlterConfigOp.OpType.SET.id()));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(alterableConfigs));
        IncrementalAlterConfigsRequest.Builder alterConfigRequestBuilder = new IncrementalAlterConfigsRequest.Builder(data);
        ClientRequest alterConfigsRequest = this.networkClient().newClientRequest(node.idString(), (AbstractRequest.Builder)alterConfigRequestBuilder, this.time().milliseconds(), true);
        NetworkClientUtils.sendAndReceive((KafkaClient)this.networkClient(), (ClientRequest)alterConfigsRequest, (Time)this.time());
        Thread.sleep(10000L);
        Tuple2 quotasAfterExpiration = ((QuotaCoordinator)((KafkaBroker)this.brokers().apply(node.id())).quotaCoordinatorOpt().get()).describeQuota(quotaEntity);
        if (quotasAfterExpiration != null) {
            Errors error = (Errors)quotasAfterExpiration._1();
            QuotaDescription quotaDescription = (QuotaDescription)quotasAfterExpiration._2();
            if (error != null && quotaDescription != null) {
                Assertions.assertEquals((Object)new QuotaDescription((Map)Predef$.MODULE$.Map().empty()), (Object)quotaDescription, (String)new StringBuilder(67).append("Got description ").append(quotaDescription).append(" when describing entity ").append(quotaEntity).append(", but expected an empty map").toString());
                Assertions.assertEquals((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)error, (String)new StringBuilder(24).append("Got error ").append(error).append(" but expected ").append(Errors.QUOTA_ENTITY_NOT_FOUND).toString());
                return;
            }
        }
        throw new MatchError((Object)quotasAfterExpiration);
    }

    private ReportQuotaConsumptionRequest.Builder getRequestBuilder(int brokerId, QuotaEntity quotaEntity, ClientQuotaType clientQuotaType, double usage, boolean throttled) {
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        quotaEntity.entityTypes().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicQuotasTest.$anonfun$getRequestBuilder$1(entryData, x0$1)));
        entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType(clientQuotaType.toString()).setUsage(usage).setThrottled(throttled));
        ReportQuotaConsumptionRequestData requestData = new ReportQuotaConsumptionRequestData().setBrokerId(brokerId).setEntries((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)entryData, (List)Nil$.MODULE$)).asJava());
        return new ReportQuotaConsumptionRequest.Builder(requestData);
    }

    private boolean getRequestBuilder$default$5() {
        return false;
    }

    @Override
    public int brokerCount() {
        return this.numServers();
    }

    public static final /* synthetic */ String $anonfun$setUp$3(KafkaBroker broker$1) {
        return new StringBuilder(48).append("Quota coordinator on broker ").append(broker$1).append(" never became active").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setUp$1(KafkaBroker broker) {
        AtomicBoolean atomicBoolean = ((QuotaCoordinator)broker.quotaCoordinatorOpt().get()).isActive();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!atomicBoolean.get()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicQuotasTest.$anonfun$setUp$3(broker));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private static final void requestCallback$1(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ void $anonfun$testReportConsumption$3(Map quotas$1, KafkaBroker broker) {
        int brokerId = broker.config().brokerId();
        double expected = TestClientQuotaCallback$.MODULE$.clusterLevelQuota() / (double)6 * (double)(brokerId + 1);
        double actual = BoxesRunTime.unboxToDouble((Object)((MapLike)quotas$1.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((double)expected, (double)actual, (String)new StringBuilder(39).append("Got quota of ").append(actual).append(" for broker ").append(brokerId).append(" but expected ").append(expected).toString());
    }

    private static final void requestCallback$2(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ boolean $anonfun$testQuotasTopicFailover$2(DynamicQuotasTest $this, int initialLeader$1, int partition$1) {
        boolean x$2;
        TopicPartition x$1;
        LogManager qual$1 = ((KafkaBroker)$this.brokers().apply(initialLeader$1)).logManager();
        return ((AbstractLog)qual$1.getLog(x$1 = new TopicPartition("_confluent-quotas", partition$1), x$2 = qual$1.getLog$default$2()).get()).highWatermark() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testQuotasTopicFailover$3(int initialLeader$1) {
        return new StringBuilder(65).append("Quota records were not successfully written to the log on broker ").append(initialLeader$1).toString();
    }

    private static final void requestCallback$3(ClientResponse response) {
        Assertions.assertEquals((int)1, (int)response.responseBody().errorCounts().size());
        Assertions.assertTrue((boolean)response.responseBody().errorCounts().containsKey(Errors.NONE));
    }

    public static final /* synthetic */ void $anonfun$testQuotaExpiration$3(Map quotas$2, KafkaBroker broker) {
        int brokerId = broker.config().brokerId();
        double expected = TestClientQuotaCallback$.MODULE$.clusterLevelQuota() / (double)6 * (double)(brokerId + 1);
        double actual = BoxesRunTime.unboxToDouble((Object)((MapLike)quotas$2.apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).apply((Object)ClientQuotaType.PRODUCE.toString()));
        Assertions.assertEquals((double)expected, (double)actual, (String)new StringBuilder(39).append("Got quota of ").append(actual).append(" for broker ").append(brokerId).append(" but expected ").append(expected).toString());
    }

    public static final /* synthetic */ boolean $anonfun$getRequestBuilder$1(ReportQuotaConsumptionRequestData.EntryData entryData$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String entityType = (String)x0$1._1();
        String entityName = (String)x0$1._2();
        boolean bl = entryData$1.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType(entityType).setEntityName(entityName));
        return bl;
    }

    public DynamicQuotasTest() {
        this.numServers = 3;
        this.numQuotasTopicPartitions = 3;
        this.broker0 = 0;
        this.broker1 = 1;
        this.brokerLimitProducer = 80000;
    }
}

