/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.controller.ClusterLinkControlManager;
import org.apache.kafka.controller.QuorumController;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001\t%b\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQa\u0011\u0001\u0005\u0002\u0011CQ\u0001\u0016\u0001\u0005\nUCQ! \u0001\u0005\nyDq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005\"CAQ\u0001E\u0005I\u0011AAR\u0011%\t9\fAI\u0001\n\u0003\t\u0019\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"I\u0011Q\u001e\u0001\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003g\u0004\u0011\u0013!C\u0001\u0003kD\u0011\"!?\u0001#\u0003%\t!a?\t\u0013\u0005}\b!%A\u0005\u0002\t\u0005!\u0001J\"mkN$XM\u001d'j].\u001cuN\u001c;s_2dWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005Q)\u0012\u0001\u00027j].T!AF\f\u0002\u000b-\fgm[1\u000b\u0003a\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011aE\u0001\u0017i\u0016\u001cHo\u00117vgR,'\u000fT5oW\u000e{gNZ5hgR\u0011qE\u000b\t\u00039!J!!K\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006W\t\u0001\r\u0001L\u0001\u0010G2,8\u000f^3s\u0013:\u001cH/\u00198dKB\u0011Q&M\u0007\u0002])\u0011q\u0006M\u0001\u0005i\u0016\u001cHOC\u0001\u0017\u0013\t\u0011dFA\bDYV\u001cH/\u001a:J]N$\u0018M\\2fQ!\u0011AGO\u001eA\u0003\n\u000b\u0005CA\u001b9\u001b\u00051$BA\u001c/\u0003)\tgN\\8uCRLwN\\\u0005\u0003sY\u00121b\u00117vgR,'\u000fV3ti\u0006Y1\r\\;ti\u0016\u0014H+\u001f9fI\u0005a\u0014BA\u001f?\u0003\u0015Y%+\u0011$U\u0015\tyd'\u0001\u0003UsB,\u0017a\u00022s_.,'o]\u000f\u0002\u0003\u0005Y1m\u001c8ue>dG.\u001a:t\u00039\"Xm\u001d;DYV\u001cH/\u001a:Ti\u0006$Xm\u00148BGRLg/Z\"p]R\u0014x\u000e\u001c7fe\u0006sGMR8mY><XM]:\u0015\u0005\u001d*\u0005\"B\u0016\u0004\u0001\u0004a\u0003FC\u00025um\u0002\u0015IQ$I\u0013v\t1!\u0001\ttKJ4XM\u001d)s_B,'\u000f^5fg2\n!jK\u0003L\u001d>\u000b&\u000b\u0005\u00026\u0019&\u0011QJ\u000e\u0002\u0016\u00072,8\u000f^3s\u0007>tg-[4Qe>\u0004XM\u001d;z\u0003\rYW-_\u0011\u0002!\u0006)3M]3bi\u0016t3\r\\;ti\u0016\u0014h\u0006\\5oW:\u0002x\u000e\\5ds:\u001aG.Y:t]9\fW.Z\u0001\u0006m\u0006dW/Z\u0011\u0002'\u0006\u0011\u0014N\u001c;fOJ\fG/[8o]-\fgm[1/Y&t7N\f+fgR\u001c%/Z1uK\u000ecWo\u001d;fe2Kgn\u001b)pY&\u001c\u00170A\bsC\u001a$8i\u001c8ue>dG.\u001a:t)\t1V\u000eE\u0002X?\nt!\u0001W/\u000f\u0005ecV\"\u0001.\u000b\u0005mK\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\tqV$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'\u0001\u0002'jgRT!AX\u000f\u0011\u0005\r\\W\"\u00013\u000b\u0005\u00154\u0017AC2p]R\u0014x\u000e\u001c7fe*\u0011ac\u001a\u0006\u0003Q&\fa!\u00199bG\",'\"\u00016\u0002\u0007=\u0014x-\u0003\u0002mI\n\u0001\u0012+^8sk6\u001cuN\u001c;s_2dWM\u001d\u0005\u0006W\u0011\u0001\rA\u001c\t\u0003_jt!\u0001]<\u000f\u0005E,hB\u0001:u\u001d\tI6/C\u0001\u0017\u0013\ty\u0003'\u0003\u0002w]\u0005)!.\u001e8ji&\u0011\u00010_\u0001\u001d%\u00064Go\u00117vgR,'/\u00138w_\u000e\fG/[8o\u0007>tG/\u001a=u\u0015\t1h&\u0003\u0002|y\n\u0019\"+\u00194u\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK*\u0011\u00010_\u0001\u001aCN\u001cXM\u001d;D_:$(o\u001c7NC:\fw-\u001a:Ti\u0006$X\r\u0006\u0003(\u007f\u0006=\u0002bBA\u0001\u000b\u0001\u0007\u00111A\u0001\u0006Y&t7n\u001d\t\u0005/~\u000b)\u0001\u0005\u0003\u0002\b\u0005%b\u0002BA\u0005\u0003GqA!a\u0003\u0002\u001e9!\u0011QBA\r\u001d\u0011\ty!a\u0006\u000f\t\u0005E\u0011Q\u0003\b\u00043\u0006M\u0011\"\u00016\n\u0005!L\u0017B\u0001\fh\u0013\r\tYBZ\u0001\u0007G>lWn\u001c8\n\t\u0005}\u0011\u0011E\u0001\b[\u0016\u001c8/Y4f\u0015\r\tYBZ\u0005\u0005\u0003K\t9#A\u000fDe\u0016\fG/Z\"mkN$XM\u001d'j].\u001c(+Z9vKN$H)\u0019;b\u0015\u0011\ty\"!\t\n\t\u0005-\u0012Q\u0006\u0002\n\u000b:$(/\u001f#bi\u0006TA!!\n\u0002(!9\u0011\u0011G\u0003A\u0002\u0005M\u0012!G2mkN$XM\u001d'j].\u001cuN\u001c;s_2l\u0015M\\1hKJ\u00042aYA\u001b\u0013\r\t9\u0004\u001a\u0002\u001a\u00072,8\u000f^3s\u0019&t7nQ8oiJ|G.T1oC\u001e,'/\u0001\ruKN$8I]3bi\u0016\fe\u000e\u001a#fY\u0016$X\rT5oWN$2aJA\u001f\u0011\u0015Yc\u00011\u0001oQ!1AGO\u001eA\u0003\n\u000b\u0015a\b;fgR\u001cv.\u001e:dK&s\u0017\u000e^5bi\u0016$G*\u001b8l\u0007J,\u0017\r^5p]R\u0019q%!\u0012\t\u000b-:\u0001\u0019\u00018)\u0011\u001d!$h\u000f!B\u0005\u0006\u000bqd]3oI\u000e{g\u000e\u001e:pY2,'o\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8l)\u0019\ti%a\u001c\u0002zAA\u0011qJA,\u0003;\n\u0019G\u0004\u0003\u0002R\u0005M\u0003CA-\u001e\u0013\r\t)&H\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00131\f\u0002\u0004\u001b\u0006\u0004(bAA+;A!\u0011qJA0\u0013\u0011\t\t'a\u0017\u0003\rM#(/\u001b8h!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$\u0002BA5\u0003C\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003[\n9G\u0001\u0004FeJ|'o\u001d\u0005\b\u0003cB\u0001\u0019AA:\u0003!a\u0017N\\6ECR\f\u0007#B,\u0002v\u0005\u0015\u0011bAA<C\n\u00191+Z9\t\r\u0015D\u0001\u0019AA>!\u0011\ti(a!\u000e\u0005\u0005}$bAAAa\u00059a.\u001a;x_J\\\u0017\u0002BAC\u0003\u007f\u0012AbU8dW\u0016$8+\u001a:wKJ\fQc]3oI\u0012+G.\u001a;f\u00072,8\u000f^3s\u0019&t7\u000e\u0006\u0006\u0002N\u0005-\u0015\u0011SAJ\u0003;Cq!!$\n\u0001\u0004\ty)A\u0005mS:\\g*Y7fgB)q+!\u001e\u0002^!1Q-\u0003a\u0001\u0003wB\u0011\"!&\n!\u0003\u0005\r!a&\u0002\u0019Y\fG.\u001b3bi\u0016|e\u000e\\=\u0011\u0007q\tI*C\u0002\u0002\u001cv\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002 &\u0001\n\u00111\u0001\u0002\u0018\u0006)am\u001c:dK\u0006y2/\u001a8e\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0015&\u0006BAL\u0003O[#!!+\u0011\t\u0005-\u00161W\u0007\u0003\u0003[SA!a,\u00022\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003ouIA!!.\u0002.\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002?M,g\u000e\u001a#fY\u0016$Xm\u00117vgR,'\u000fT5oW\u0012\"WMZ1vYR$C'\u0001\ttK:$\u0017\t\u001c;fe\u000e{gNZ5hgRA\u0011QJA_\u0003\u0003\f9\rC\u0004\u0002@2\u0001\r!!\u0018\u0002\u00111Lgn\u001b(b[\u0016Dq!a1\r\u0001\u0004\t)-A\u0004d_:4\u0017nZ:\u0011\u0011\u0005=\u0013qKA/\u0003;Ba!\u001a\u0007A\u0002\u0005m\u0014aC2mkN$XM\u001d'j].$B\"!\u0002\u0002N\u0006=\u00171[Ak\u0003ODq!a0\u000e\u0001\u0004\ti\u0006C\u0005\u0002R6\u0001\n\u00111\u0001\u0002^\u0005I1\r\\;ti\u0016\u0014\u0018\n\u001a\u0005\n\u0003\u0007l\u0001\u0013!a\u0001\u0003\u000bD\u0011\"a6\u000e!\u0003\u0005\r!!7\u0002\r1Lgn[%e!\u0015a\u00121\\Ap\u0013\r\ti.\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0005\u00181]\u0007\u0003\u0003CIA!!:\u0002\"\t!Q+^5e\u0011%\tI/\u0004I\u0001\u0002\u0004\tY/\u0001\u0004uK:\fg\u000e\u001e\t\u00069\u0005m\u0017QL\u0001\u0016G2,8\u000f^3s\u0019&t7\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tP\u000b\u0003\u0002^\u0005\u001d\u0016!F2mkN$XM\u001d'j].$C-\u001a4bk2$HeM\u000b\u0003\u0003oTC!!2\u0002(\u0006)2\r\\;ti\u0016\u0014H*\u001b8lI\u0011,g-Y;mi\u0012\"TCAA\u007fU\u0011\tI.a*\u0002+\rdWo\u001d;fe2Kgn\u001b\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u0001\u0016\u0005\u0003W\f9\u000b\u000b\u0004\u0001\u0005\u000f\t&Q\u0004\t\u0005\u0005\u0013\u0011I\"\u0004\u0002\u0003\f)!!Q\u0002B\b\u0003%)\u0007\u0010^3og&|gN\u0003\u0003\u0003\u0012\tM\u0011aA1qS*!!Q\u0003B\f\u0003\u001dQW\u000f]5uKJT!A^5\n\t\tm!1\u0002\u0002\u000b\u000bb$XM\u001c3XSRDGF\u0001B\u0010G\t\u0011\t\u0003\u0005\u0003\u0003$\t\u0015R\"A=\n\u0007\t\u001d\u0012PA\u000bDYV\u001cH/\u001a:UKN$X\t\u001f;f]NLwN\\:")
public class ClusterLinkControllerIntegrationTest {
    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testClusterLinkConfigs(ClusterInstance clusterInstance) {
        Map<String, Errors> results = this.sendAlterConfigs("test-link", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
        String x$1 = "test-link";
        Map x$2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:0")}));
        String x$3 = this.clusterLink$default$2();
        Option<Uuid> x$4 = this.clusterLink$default$4();
        Option<String> x$5 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink(x$1, x$3, (Map<String, String>)x$2, x$4, x$5), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        results = this.sendAlterConfigs("test-link", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=3, serverProperties={@ClusterConfigProperty(key="create.cluster.link.policy.class.name", value="integration.kafka.link.TestCreateClusterLinkPolicy")})
    public void testClusterStateOnActiveControllerAndFollowers(ClusterInstance clusterInstance) {
        Assertions.assertTrue((boolean)clusterInstance.isKRaftTest());
        List<QuorumController> controllers = this.raftControllers((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance);
        Assertions.assertEquals((int)3, (int)controllers.size());
        controllers.foreach((Function1 & Serializable & scala.Serializable)qc -> {
            this.assertControlManagerState((List<CreateClusterLinksRequestData.EntryData>)Nil$.MODULE$, qc.clusterLinkControlManager());
            return BoxedUnit.UNIT;
        });
        String linkName = "test-link";
        Some x$2 = new Some((Object)"lkc-123");
        String x$3 = this.clusterLink$default$2();
        Map<String, String> x$4 = this.clusterLink$default$3();
        Option<Uuid> x$5 = this.clusterLink$default$4();
        CreateClusterLinksRequestData.EntryData link = this.clusterLink(linkName, x$3, x$4, x$5, (Option<String>)x$2);
        Map<String, Errors> results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)link, (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)linkName));
        controllers.foreach((Function1 & Serializable & scala.Serializable)qc -> {
            this.assertControlManagerState((List<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)link, (List)Nil$.MODULE$), qc.clusterLinkControlManager());
            return BoxedUnit.UNIT;
        });
    }

    private List<QuorumController> raftControllers(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(clusterInstance.controllersMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            QuorumController quorumController = (QuorumController)((ControllerServer)x0$1._2()).controller();
            return quorumController;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toList();
    }

    /*
     * WARNING - void declaration
     */
    private void assertControlManagerState(List<CreateClusterLinksRequestData.EntryData> links, ClusterLinkControlManager clusterLinkControlManager) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$1(links, clusterLinkControlManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        links.foreach((Function1 & Serializable & scala.Serializable)link -> {
            ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$3(clusterLinkControlManager, link);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testCreateAndDeleteLinks(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        String x$1 = "test-link";
        Some x$2 = new Some((Object)Uuid.randomUuid());
        String x$3 = this.clusterLink$default$2();
        Map<String, String> x$4 = this.clusterLink$default$3();
        Option<String> x$5 = this.clusterLink$default$5();
        Map<String, Errors> results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink(x$1, x$3, x$4, (Option<Uuid>)x$2, x$5), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map configs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)ClusterLinkConfig.LinkMode.DESTINATION.name())}));
        String x$6 = "test-link";
        Some x$8 = new Some((Object)Uuid.randomUuid());
        String x$9 = this.clusterLink$default$2();
        Option<String> x$10 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink(x$6, x$9, (Map<String, String>)configs, (Option<Uuid>)x$8, x$10), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map badConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)"badMode")}));
        String x$11 = "test-link";
        String x$13 = this.clusterLink$default$2();
        Option<Uuid> x$14 = this.clusterLink$default$4();
        Option<String> x$15 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink(x$11, x$13, (Map<String, String>)badConfigs, x$14, x$15), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)results.apply((Object)"test-link"));
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_EXISTS, (Object)results.apply((Object)"test-link"));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$1(clusterInstance)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        results = this.sendDeleteClusterLink((Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"not-a-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), true, this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendDeleteClusterLink((Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"not-a-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendDeleteClusterLink((Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"not-a-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)new .colon.colon((Object)this.clusterLink("another-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4(), this.clusterLink$default$5()), (List)Nil$.MODULE$)), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"another-link"));
        results = this.sendDeleteClusterLink((Seq<String>)new .colon.colon((Object)"test-link", (List)new .colon.colon((Object)"another-link", (List)Nil$.MODULE$)), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"another-link"));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$3(clusterInstance)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testSourceInitiatedLinkCreation(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        Map configs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)ClusterLinkConfig.LinkMode.SOURCE.name())}));
        String x$1 = "test-link";
        String x$3 = this.clusterLink$default$2();
        Option<Uuid> x$4 = this.clusterLink$default$4();
        Option<String> x$5 = this.clusterLink$default$5();
        Map<String, Errors> results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink(x$1, x$3, (Map<String, String>)configs, x$4, x$5), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map badConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)"badMode")}));
        String x$6 = "test-link";
        Some x$8 = new Some((Object)Uuid.randomUuid());
        String x$9 = this.clusterLink$default$2();
        Option<String> x$10 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink(x$6, x$9, (Map<String, String>)badConfigs, (Option<Uuid>)x$8, x$10), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)results.apply((Object)"test-link"));
        String x$11 = "test-link";
        Some x$13 = new Some((Object)Uuid.randomUuid());
        String x$14 = this.clusterLink$default$2();
        Option<String> x$15 = this.clusterLink$default$5();
        results = this.sendControllerCreateClusterLink((Seq<CreateClusterLinksRequestData.EntryData>)new .colon.colon((Object)this.clusterLink(x$11, x$14, (Map<String, String>)configs, (Option<Uuid>)x$13, x$15), (List)Nil$.MODULE$), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
    }

    public Map<String, Errors> sendControllerCreateClusterLink(Seq<CreateClusterLinksRequestData.EntryData> linkData, SocketServer controller) {
        CreateClusterLinksRequestData data = new CreateClusterLinksRequestData().setEntries((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(linkData).asJava()).setTimeoutMs(Integer.MAX_VALUE);
        CreateClusterLinksRequest request = (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(data).build();
        CreateClusterLinksResponse response = (CreateClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(CreateClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.linkName()), (Object)Errors.forCode((short)entry.errorCode())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Errors> sendDeleteClusterLink(Seq<String> linkNames, SocketServer controller, boolean validateOnly, boolean force) {
        DeleteClusterLinksRequest request = (DeleteClusterLinksRequest)new DeleteClusterLinksRequest.Builder((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(linkNames).asJava(), validateOnly, force, Integer.MAX_VALUE).build();
        DeleteClusterLinksResponse response = (DeleteClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(DeleteClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().entries()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.linkName()), (Object)Errors.forCode((short)entry.errorCode())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public boolean sendDeleteClusterLink$default$3() {
        return false;
    }

    public boolean sendDeleteClusterLink$default$4() {
        return false;
    }

    public Map<String, Errors> sendAlterConfigs(String linkName, Map<String, String> configs, SocketServer controller) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName);
        IncrementalAlterConfigsRequest request = (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(Collections.singleton(resource), Collections.singletonMap(resource, CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String value;
            String key;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    key = (String)x0$1._1();
                    value = (String)x0$1._2();
                    if (key != null && value != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(key, value), AlterConfigOp.OpType.SET);
            return alterConfigOp;
        }, Iterable$.MODULE$.canBuildFrom())).asJavaCollection()), false).build();
        IncrementalAlterConfigsResponse response2 = (IncrementalAlterConfigsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(IncrementalAlterConfigsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response2.data().responses()).asScala()).map((Function1 & Serializable & scala.Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.resourceName()), (Object)Errors.forCode((short)response.errorCode())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public CreateClusterLinksRequestData.EntryData clusterLink(String linkName, String clusterId, Map<String, String> configs, Option<Uuid> linkId, Option<String> tenant) {
        return new CreateClusterLinksRequestData.EntryData().setLinkName(linkName).setLinkId((Uuid)linkId.getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setClusterId(clusterId).setTenantPrefix((String)tenant.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)).setConfigs((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            CreateClusterLinksRequestData.ConfigData configData = new CreateClusterLinksRequestData.ConfigData().setKey(k).setValue(v);
            return configData;
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava());
    }

    public String clusterLink$default$2() {
        return "source-cluster";
    }

    public Map<String, String> clusterLink$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<Uuid> clusterLink$default$4() {
        return None$.MODULE$;
    }

    public Option<String> clusterLink$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$assertControlManagerState$1(List links$1, ClusterLinkControlManager clusterLinkControlManager$1) {
        return links$1.size() == clusterLinkControlManager$1.getClusterLinkControlState().links.size();
    }

    public static final /* synthetic */ String $anonfun$assertControlManagerState$2() {
        return "Number of links is not as expected";
    }

    public static final /* synthetic */ String $anonfun$assertControlManagerState$5(Optional linkId$1) {
        return new StringBuilder(22).append("Does not contain link ").append(linkId$1.get()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$assertControlManagerState$6(ClusterLinkControlManager clusterLinkControlManager$1, Optional linkId$1) {
        return ((Set)clusterLinkControlManager$1.getClusterLinkControlState().policyLinks.get()).contains(linkId$1.get());
    }

    public static final /* synthetic */ String $anonfun$assertControlManagerState$7(Optional linkId$1) {
        return new StringBuilder(33).append("Does not contain link ").append(linkId$1.get()).append(" in policy.").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assertControlManagerState$3(ClusterLinkControlManager clusterLinkControlManager$1, CreateClusterLinksRequestData.EntryData link) {
        Optional linkId = clusterLinkControlManager$1.getClusterLinkId(link.linkName());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!clusterLinkControlManager$1.getClusterLinkControlState().links.contains(linkId.get())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$5(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$6(clusterLinkControlManager$1, linkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$assertControlManagerState$7(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteLinks$1(RaftClusterInvocationContext.RaftClusterInstance clusterInstance$1) {
        return clusterInstance$1.metadataImage().get(BoxesRunTime.boxToInteger((int)0)).clusterLinks().clusterLink("test-link").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteLinks$2() {
        return "Broker never saw new cluster link";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteLinks$3(RaftClusterInvocationContext.RaftClusterInstance clusterInstance$1) {
        return !clusterInstance$1.metadataImage().get(BoxesRunTime.boxToInteger((int)0)).clusterLinks().clusterLink("test-link").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteLinks$4() {
        return "Broker never saw cluster link get deleted";
    }
}

