/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0006\r\u0001MAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005B\u0005BQ\u0001\u000b\u0001\u0005B%BQa\u000e\u0001\u0005\u0002aBQ!\u0019\u0001\u0005\u0002\tDQ!\u001b\u0001\u0005\u0002)DQa\u001c\u0001\u0005\u0002ADQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\u0002qDq!a\u0001\u0001\t\u0003\t)A\u0001\fESN\f'\r\\3US\u0016\u00148\u000b^8sC\u001e,G+Z:u\u0015\tia\"\u0001\u0003uS\u0016\u0014(BA\b\u0011\u0003\u0015Y\u0017MZ6b\u0015\u0005\t\u0012aC5oi\u0016<'/\u0019;j_:\u001c\u0001a\u0005\u0002\u0001)A\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0006gR\fG/\u001a\u0006\u0003\u001beQ\u0011aD\u0005\u00037Y\u0011\u0011CQ1tKRKWM]*uCR,G+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\tA\"A\u0006ce>\\WM]\"pk:$X#\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\u0007%sG/A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011!&\f\t\u0003G-J!\u0001\f\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006]\r\u0001\raL\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bC\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0011)H/\u001b7\u000b\u0003Q\nAA[1wC&\u0011a'\r\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u000b;fgR4U\r^2i%\u0016\fX/Z:u/&$\b\u000eV5fe\u0016$7\u000b^8sC\u001e,G)[:bE2,G\r\u0006\u0002+s!)!\b\u0002a\u0001w\u00051\u0011/^8sk6\u0004\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 %\u001b\u0005y$B\u0001!\u0013\u0003\u0019a$o\\8u}%\u0011!\tJ\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002CI!\"AaR+W!\tA5+D\u0001J\u0015\tQ5*\u0001\u0005qe>4\u0018\u000eZ3s\u0015\taU*\u0001\u0004qCJ\fWn\u001d\u0006\u0003\u001d>\u000bqA[;qSR,'O\u0003\u0002Q#\u0006)!.\u001e8ji*\t!+A\u0002pe\u001eL!\u0001V%\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u00059\u0016%\u0001-\u0002\u0005i\\\u0007\u0006\u0002\u0003[=~\u0003\"a\u0017/\u000e\u0003-K!!X&\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u00011\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0\u0001\u0016uKN$\u0018\t\u001a3OK^\u0014V\r\u001d7jG\u0006<\u0016\u000e\u001e5US\u0016\u0014X\rZ*u_J\fw-\u001a#jg\u0006\u0014G.\u001a3\u0015\u0005)\u001a\u0007\"\u0002\u001e\u0006\u0001\u0004Y\u0004\u0006B\u0003H+\u0016d#a\u00164\"\u0003\u001d\fQa\u001b:bMRDC!\u0002._?\u0006AC/Z:u%\u0016\u0004H.[2bi&|gnV5uQRKWM]3e'R|'/Y4f\t&\u001c\u0018M\u00197fIR\u0011!f\u001b\u0005\u0006u\u0019\u0001\ra\u000f\u0015\u0005\r\u001d+V\u000e\f\u0002XM\"\"aA\u00170`\u0003!\"Xm\u001d;EK2,G/\u001a+pa&\u001cw+\u001b;i)&,'/\u001a3Ti>\u0014\u0018mZ3ESN\f'\r\\3e)\tQ\u0013\u000fC\u0003;\u000f\u0001\u00071\b\u000b\u0003\b\u000fV\u001bHFA,gQ\u00119!LX0\u0002SQ,7\u000f\u001e'pOJ+G/\u001a8uS>tw+\u001b;i)&,'/\u001a3Ti>\u0014\u0018mZ3ESN\f'\r\\3e)\tQs\u000fC\u0003;\u0011\u0001\u00071\b\u000b\u0003\t\u000fVKHFA,gQ\u0011A!LX0\u0002\u0001R,7\u000f\u001e'pOJ+G/\u001a8uS>t\u0017I\u001a;feRKWM]3e\t\u0006$\u0018-S:EK2,G/\u001a3B]\u0012$\u0016.\u001a:fIN#xN]1hK\u0012K7/\u00192mK\u0012$\"AK?\t\u000biJ\u0001\u0019A\u001e)\t%9Uk \u0017\u0003/\u001aDC!\u0003._?\u0006\u0019D/Z:u\t\u0016dW\r^5p]R\u000b7o[*uCR,W*Y2iS:,w\u000b[3o)&,'o\u0015;pe\u0006<W\rR5tC\ndW\r\u001a\u000b\u0004U\u0005\u001d\u0001\"\u0002\u001e\u000b\u0001\u0004Y\u0004&\u0002\u0006H+\u0006-AFA,gQ\u0011Q!LX0")
public class DisableTierStorageTest
extends BaseTierStateTest {
    @Override
    public int brokerCount() {
        return 5;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testFetchRequestWithTieredStorageDisabled(String quorum) {
        void var4_4;
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        int replica2 = tuple2._2$mcI$sp();
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var3_3, (int)var4_4);
        this.waitForHotSetRetentionToKickIn((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3, var4_4})));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier enabled");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testFetchRequestWithTieredStorageDisabled$2(leaderLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testFetchRequestWithTieredStorageDisabled$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier disabled");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.switchLeader((int)var3_3, (int)var4_4);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier disabled and new leader elected");
        this.fetchTieredAndLocalDataAndValidate((int)var4_4, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.switchLeader((int)var4_4, (int)var3_3);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier disabled and new leader elected (that has since been rolled)");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAddNewReplicaWithTieredStorageDisabled(String quorum) {
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        this.appendMessagesToLeaderAndWaitUntilTiered((int)var3_3, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$2(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int replica3 = this.addReplicaToAssignment((int)var3_3);
        this.waitForReplicaToGetInSync((int)var3_3, replica3);
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int replica4 = this.addReplicaToAssignment((int)var3_3);
        this.waitForReplicaToGetInSync((int)var3_3, replica4);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReplicationWithTieredStorageDisabled(String quorum) {
        Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topicName(), 1, 3, this.props(), this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        int replica1 = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        Seq followers = (Seq)((KafkaBroker)this.brokerForId(replica1).get()).replicaManager().getPartitionOrException(this.topicPartition()).assignmentState().replicas().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != replica1);
        followers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)follower -> this.killBroker(follower));
        this.appendMessagesToLeaderAndWaitUntilTiered(replica1, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(replica1).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$4(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.restartDeadBroker(BoxesRunTime.unboxToInt((Object)followers.head()), this.restartDeadBroker$default$2());
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.head()));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$5(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.restartDeadBroker(BoxesRunTime.unboxToInt((Object)followers.apply(1)), this.restartDeadBroker$default$2());
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.apply(1)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteTopicWithTieredStorageDisabled(String quorum) {
        String topic1 = "foo";
        String topic2 = "bar";
        TopicPartition topicPartition1 = new TopicPartition(topic1, 0);
        TopicPartition topicPartition2 = new TopicPartition(topic2, 0);
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic1, 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(topicPartition1);
        AbstractLog topic1Log = (AbstractLog)((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().getLog(topicPartition1).get();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic2, 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(topicPartition2);
        AbstractLog topic2Log = (AbstractLog)((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().getLog(topicPartition2).get();
        int numMessages = 100;
        IntRef totalMessages1 = IntRef.create((int)0);
        while (topic1Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topic1, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages1.elem += numMessages;
        }
        IntRef totalMessages2 = IntRef.create((int)0);
        while (topic2Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topic2, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages2.elem += numMessages;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$1(this, topic1Log, totalMessages1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$3(this, topic2Log, totalMessages2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        List<TierLogSegment> tieredSegments1 = this.tierLogSegments(topic1Log);
        List<TierLogSegment> tieredSegments2 = this.tierLogSegments(topic2Log);
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        DeleteTopicsResult future1 = adminClient.deleteTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJavaCollection());
        this.changeTopicConfig("confluent.tier.enable", "false", topic2);
        long l5 = 200L;
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$5(topic2Log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        DeleteTopicsResult future2 = adminClient.deleteTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJavaCollection());
        future1.all().get(30000L, TimeUnit.MILLISECONDS);
        future2.all().get(30000L, TimeUnit.MILLISECONDS);
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(topic1LeaderId).get()).tierObjectStoreOpt().get();
        this.verifyTieredSegmentsDeleted(topic1, objStore, tieredSegments1);
        this.verifyTieredSegmentsDeleted(topic2, objStore, tieredSegments2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLogRetentionWithTieredStorageDisabled(String quorum) {
        int numMessages = 100;
        ObjectRef topic = ObjectRef.create((Object)"");
        ((TraversableLike)new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$2(this, topic, numMessages, x$3);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled(String quorum) {
        int numMessages = 100;
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(x$1, x$2).get();
        while (log.numberOfSegments() < 4) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.changeTopicConfig("confluent.tier.enable", "false", this.topicName());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long currentNumMessages = log.logEndOffset();
        long lastTieredOffset = log.tierPartitionState().endOffset();
        String desiredRetentionSizeBytes = Long.toString(log.size());
        while (log.logEndOffset() < currentNumMessages * 3L) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        }
        List segmentsNotTiered = log.localLogSegments(lastTieredOffset + 1L, log.logEndOffset()).toList();
        this.changeTopicConfig("retention.bytes", desiredRetentionSizeBytes, this.topicName());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(log, segmentsNotTiered)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeletionTaskStateMachineWhenTierStorageDisabled(String quorum) {
        this.props().put("retention.bytes", "-1");
        this.props().put("retention.ms", "-1");
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicPartition().topic(), 1, 1, this.props(), this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(leaderId).get()).tierObjectStoreOpt().get();
        this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        List<TierLogSegment> tieredSegments = this.tierLogSegments(log);
        this.changeTopicConfig("retention.ms", "100", this.changeTopicConfig$default$3());
        this.verifyTieredSegmentsDeleted(this.topicPartition().topic(), objStore, tieredSegments);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestWithTieredStorageDisabled$2(AbstractLog leaderLog$1) {
        return !leaderLog$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testFetchRequestWithTieredStorageDisabled$3() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$1(AbstractLog log$1) {
        return log$1.logStartOffset() < log$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$2(AbstractLog log$1) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$1.logStartOffset()).append(" localLogStartOffset ").append(log$1.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$3(AbstractLog log$1) {
        return !log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$4() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$3(AbstractLog log$2) {
        return log$2.logStartOffset() < log$2.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$4(AbstractLog log$2) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$2.logStartOffset()).append(" localLogStartOffset ").append(log$2.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$5(AbstractLog log$2) {
        return !log$2.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$1(DisableTierStorageTest $this, AbstractLog topic1Log$1, IntRef totalMessages1$1) {
        return topic1Log$1.logEndOffset() == (long)totalMessages1$1.elem && $this.tierLogSegments(topic1Log$1).size() >= topic1Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$2() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$3(DisableTierStorageTest $this, AbstractLog topic2Log$1, IntRef totalMessages2$1) {
        return topic2Log$1.logEndOffset() == (long)totalMessages2$1.elem && $this.tierLogSegments(topic2Log$1).size() >= topic2Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$4() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$5(AbstractLog topic2Log$1) {
        return !topic2Log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$4(Partition partition$1) {
        return partition$1.log().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$5(Partition partition$1) {
        return new StringBuilder(34).append("log did not resolve for partition ").append(partition$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$6(Partition partition$1) {
        return ((AbstractLog)partition$1.log().get()).tierPartitionState().numSegments() >= ((AbstractLog)partition$1.log().get()).numberOfSegments() - 1 && ((AbstractLog)partition$1.log().get()).localLogStartOffset() > Predef$.MODULE$.Long2long((Long)((AbstractLog)partition$1.log().get()).tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$7() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$8(Partition partition$1) {
        return !((AbstractLog)partition$1.log().get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$9() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$10(LongRef expectedLogStartOffset$1, Partition partition$1) {
        return expectedLogStartOffset$1.elem == partition$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$11(Partition partition$1, LongRef expectedLogStartOffset$1) {
        return new StringBuilder(46).append("Unexpected log start offset: ").append(partition$1.logStartOffset()).append(" Expected value: ").append(expectedLogStartOffset$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testLogRetentionWithTieredStorageDisabled$2(DisableTierStorageTest $this, ObjectRef topic$1, int numMessages$1, Tuple2 x$3) {
        if (x$3 != null) {
            long retentionSizeBytes;
            String configVal = (String)x$3._1();
            int index = x$3._2$mcI$sp();
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Testing topic created with config.TierEnable = ").append(configVal).toString());
            $this.props().put("confluent.tier.enable", configVal);
            topic$1.elem = new StringBuilder(1).append($this.topicName()).append("-").append(index).toString();
            int leaderId = BoxesRunTime.unboxToInt((Object)$this.createTopic((String)topic$1.elem, 1, 1, $this.props(), $this.createTopic$default$5(), $this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
            $this.waitUntilLogCreatedOnBrokers((String)topic$1.elem, 0);
            Partition partition = ((KafkaBroker)$this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(new TopicPartition((String)topic$1.elem, 0));
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$4(partition)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$5(partition));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            while (((AbstractLog)partition.log().get()).numberOfSegments() < 4) {
                TestUtils$.MODULE$.generateAndProduceMessages($this.brokers().toSeq(), (String)topic$1.elem, numMessages$1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            }
            LongRef expectedLogStartOffset = LongRef.create((long)0L);
            String string = configVal;
            String string2 = "true";
            if (string != null && string.equals(string2)) {
                long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l4 = 30000L;
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$6(partition)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$7());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                $this.changeTopicConfig("confluent.tier.enable", "false", (String)topic$1.elem);
                long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l6 = 30000L;
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime3 = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$8(partition)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$9());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                List<TierLogSegment> tieredSegments = $this.tierLogSegments((AbstractLog)partition.log().get());
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((TierLogSegment)tieredSegments.head()).size() + 1);
                expectedLogStartOffset.elem = ((TierLogSegment)tieredSegments.apply(1)).baseOffset();
            } else {
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((LogSegment)((AbstractLog)partition.log().get()).localLogSegments().head()).size() + 1);
                expectedLogStartOffset.elem = ((LogSegment)((AbstractLog)partition.log().get()).localLogSegments().toList().apply(1)).baseOffset();
            }
            $this.changeTopicConfig("retention.bytes", Long.toString(retentionSizeBytes), (String)topic$1.elem);
            long l7 = 10L;
            long l8 = 60000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$10(expectedLogStartOffset, partition)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$11(partition, expectedLogStartOffset));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(AbstractLog log$3) {
        return log$3.tierPartitionState().numSegments() >= log$3.numberOfSegments() - 1 && log$3.localLogStartOffset() > Predef$.MODULE$.Long2long((Long)log$3.tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$2() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(AbstractLog log$3) {
        return !log$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$4() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(AbstractLog log$3, List segmentsNotTiered$1) {
        return log$3.logStartOffset() >= ((LogSegment)segmentsNotTiered$1.apply(1)).baseOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$6() {
        return "Timed out waiting for retention to delete some local segments";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(AbstractLog log$3) {
        return log$3.localLogStartOffset() == log$3.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(AbstractLog log$3) {
        return new StringBuilder(39).append("LogStartOffset ").append(log$3.logStartOffset()).append(" != localLogStartOffset ").append(log$3.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(AbstractLog log$3) {
        return !log$3.tierPartitionState().startOffset().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$10() {
        return "FirstTieredOffset is defined after all tiered segments are deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(AbstractLog log$4) {
        return !log$4.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$2() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(AbstractLog log$4) {
        return log$4.tierPartitionState().numSegments() == 0;
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$4() {
        return "Timed out waiting for all tiered segments to delete";
    }
}

