/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditManager;
import kafka.durability.audit.DurabilityAuditCheck$;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.db.ConfigFlag$;
import kafka.durability.utils.DurabilityTierTopicReader$;
import kafka.durability.utils.TierTopicEvents;
import kafka.durability.utils.TierTopicEvents$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\u000e\u001c\u0001\tBQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005R=BQA\u000e\u0001\u0005\n]Bqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u00030\u0011\u00199\u0005\u0001)A\u0005a!9\u0001\n\u0001b\u0001\n\u0013y\u0003BB%\u0001A\u0003%\u0001\u0007C\u0004K\u0001\u0001\u0007I\u0011B\u0018\t\u000f-\u0003\u0001\u0019!C\u0005\u0019\"1q\n\u0001Q!\nABq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0015\u0005\u00067\u0002!I\u0001\u0018\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0011\u001d\t\t\u0001\u0001Q\u0001\nYDq!a\u0001\u0001\t\u0003\n)\u0001\u0003\u0004\u0002&\u0001!\te\u000e\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!a\u001d\u0001\t\u0013\tY\b\u0003\u0004\u0002\u000e\u0002!Ia\u000e\u0005\b\u0003\u001f\u0003A\u0011BAI\u0011\u001d\t9\n\u0001C\u0005\u00033\u0013A\u0004R;sC\nLG.\u001b;z)&,'oQ8na\u0006\u001cG/[8o)\u0016\u001cHO\u0003\u0002\u001d;\u0005!A/[3s\u0015\tqr$A\u0003lC\u001a\\\u0017MC\u0001!\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M\u0011\u0001a\t\t\u0003I!j\u0011!\n\u0006\u0003M\u001d\n1!\u00199j\u0015\u0005q\u0012BA\u0015&\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001-!\ti\u0003!D\u0001\u001c\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u00121!\u00138u\u00035\u0019wN\u001c4jOV\u0014X-T8dWR\t\u0001\b\u0005\u00022s%\u0011!H\r\u0002\u0005+:LG/A\u0003u_BL7-F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003mC:<'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N\f1\u0002]1si&$\u0018n\u001c8tA\u0005iQ.\u0019=Ok6\u0014VmY8sIN\fa\"\\1y\u001dVl'+Z2pe\u0012\u001c\b%\u0001\nok6\u0004&o\u001c3vG\u0016$'+Z2pe\u0012\u001c\u0018A\u00068v[B\u0013x\u000eZ;dK\u0012\u0014VmY8sIN|F%Z9\u0015\u0005aj\u0005b\u0002(\f\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0014a\u00058v[B\u0013x\u000eZ;dK\u0012\u0014VmY8sIN\u0004\u0013a\u00049s_\u0012,8-\u001a3SK\u000e|'\u000fZ:\u0016\u0003I\u0003Ba\u0015-1a5\tAK\u0003\u0002V-\u00069Q.\u001e;bE2,'BA,3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00033R\u00131!T1q\u0003A\u0001(o\u001c3vG\u0016$'+Z2pe\u0012\u001c\b%A\bu_BL7\rU1si&$\u0018n\u001c8t+\u0005i\u0006c\u00010gS:\u0011q\f\u001a\b\u0003A\u000el\u0011!\u0019\u0006\u0003E\u0006\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005\u0015\u0014\u0014a\u00029bG.\fw-Z\u0005\u0003O\"\u00141aU3r\u0015\t)'\u0007\u0005\u0002ke6\t1N\u0003\u0002m[\u000611m\\7n_:T!A\b8\u000b\u0005=\u0004\u0018AB1qC\u000eDWMC\u0001r\u0003\ry'oZ\u0005\u0003g.\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004fq&$X\rZ\u000b\u0002mB\u0011qO`\u0007\u0002q*\u0011\u0011P_\u0001\u0007CR|W.[2\u000b\u0005md\u0018AC2p]\u000e,(O]3oi*\u0011Q0Q\u0001\u0005kRLG.\u0003\u0002\u0000q\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq!\u001a=ji\u0016$\u0007%A\u0003tKR,\u0006\u000fF\u00029\u0003\u000fAq!!\u0003\u0013\u0001\u0004\tY!\u0001\u0005uKN$\u0018J\u001c4p!\u0011\ti!!\u0007\u000e\u0005\u0005=!b\u0001\u0014\u0002\u0012)!\u00111CA\u000b\u0003\u001dQW\u000f]5uKJT1!a\u0006q\u0003\u0015QWO\\5u\u0013\u0011\tY\"a\u0004\u0003\u0011Q+7\u000f^%oM>D3AEA\u0010!\u0011\ti!!\t\n\t\u0005\r\u0012q\u0002\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007M\tI\u0003\u0005\u0003\u0002\u000e\u0005-\u0012\u0002BA\u0017\u0003\u001f\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002/Q,7\u000f\u001e$jYR,'oQ8na\u0006\u001cG/\u0012<f]R\u001cHc\u0001\u001d\u00024!9\u0011Q\u0007\u000bA\u0002\u0005]\u0012AB9v_J,X\u000e\u0005\u0003\u0002:\u0005\u0005c\u0002BA\u001e\u0003{\u0001\"\u0001\u0019\u001a\n\u0007\u0005}\"'\u0001\u0004Qe\u0016$WMZ\u0005\u0004\t\u0006\r#bAA e!:A#a\u0012\u0002X\u0005e\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\taJ|g/\u001b3fe*!\u0011\u0011KA\t\u0003\u0019\u0001\u0018M]1ng&!\u0011QKA&\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u00111LA0C\t\ti&\u0001\u0002{W\u0006\u0012\u0011\u0011M\u0001\u0006WJ\fg\r\u001e\u0015\b)\u0005\u0015\u0014QNA8!\u0011\t9'!\u001b\u000e\u0005\u0005=\u0013\u0002BA6\u0003\u001f\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005E\u0014\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006\u0019\u0002O]8ek\u000e,7*Z=fIJ+7m\u001c:egR\u0019\u0001(a\u001e\t\r\u0005eT\u00031\u00011\u0003)qW/\u001c*fG>\u0014Hm\u001d\u000b\u0004q\u0005u\u0004bBA@-\u0001\u0007\u0011\u0011Q\u0001\nW\u0016Lh+\u00197vKN\u0004RAXAB\u0003\u000fK1!!\"i\u0005\u0011a\u0015n\u001d;\u0011\u000bE\nI\t\r\u0019\n\u0007\u0005-%G\u0001\u0004UkBdWMM\u0001$o\u0006LG/\u00168uS2\u001cVmZ7f]R\u001cH+[3sK\u0012\fe\u000eZ\"p[B\f7\r^3e\u0003a1XM]5gs\u000e{W.\\5u\u0003:$7k^1q\u000bZ,g\u000e\u001e\u000b\u0004q\u0005M\u0005BBAK1\u0001\u0007\u0011.\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\u0017I,h.Q;eSRTuN\u0019\u000b\u0004q\u0005m\u0005bBAO3\u0001\u0007\u0011qT\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o\u0013:4w\u000e\u0005\u0003_M\u0006\u0005\u0006CB\u0019\u0002\n&\f\u0019\u000bE\u00022\u0003KK1!a*3\u0005\u0011auN\\4")
public class DurabilityTierCompactionTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final int maxNumRecords;
    private int numProducedRecords;
    private final Map<Object, Object> producedRecords;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private int maxNumRecords() {
        return this.maxNumRecords;
    }

    private int numProducedRecords() {
        return this.numProducedRecords;
    }

    private void numProducedRecords_$eq(int x$1) {
        this.numProducedRecords = x$1;
    }

    private Map<Object, Object> producedRecords() {
        return this.producedRecords;
    }

    private Seq<TopicPartition> topicPartitions() {
        return (Seq)package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable & scala.Serializable)p -> DurabilityTierCompactionTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFilterCompactEvents(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        this.verifyCommitAndSwapEvent(topicPartition);
        long config = ConfigFlag$.MODULE$.OnceCompacted().id();
        this.runAuditJob((Seq<Tuple2<TopicPartition, Object>>)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)config)), (List)Nil$.MODULE$));
    }

    private void produceKeyedRecords(int numRecords) {
        Random random = new Random();
        List keyValues = (List)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).toList().map((Function1 & Serializable & scala.Serializable)i -> DurabilityTierCompactionTest.$anonfun$produceKeyedRecords$1(this, random, BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom());
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)keyValues);
        this.numProducedRecords_$eq(this.numProducedRecords() + numRecords);
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable & scala.Serializable)group -> (List)((List)((List)group.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int k = x0$1._1$mcI$sp();
                int v = x0$1._2$mcI$sp();
                this.producedRecords().put((Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)v));
                long timestamp = System.currentTimeMillis();
                ProducerRecord producerRecord = new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                return producerRecord;
            }, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS), List$.MODULE$.canBuildFrom()));
        }
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    private void verifyCommitAndSwapEvent(TopicPartition topicPartition) {
        brokerId = 0;
        broker = (KafkaBroker)this.brokerForId(brokerId).get();
        qual$1 = broker.logManager();
        x$2 = qual$1.getLog$default$2();
        topicId = (Uuid)((AbstractLog)qual$1.getLog(topicPartition, x$2).get()).topicId().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyCommitAndSwapEvent$1(), ()Lorg/apache/kafka/common/Uuid;)());
        topicIdPartition = new TopicIdPartition(topicPartition.topic(), new UUID(topicId.getMostSignificantBits(), topicId.getLeastSignificantBits()), topicPartition.partition());
        auditManager = (AuditManager)broker.auditManager().get();
        eventFromStart = DurabilityTierTopicReader$.MODULE$.apply(auditManager.config(), new CountDownLatch(1), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)BoxesRunTime.boxToLong((long)DurabilityAuditConstants$.MODULE$.TIER_TOPIC_INITIAL_SEEK()))}))).retrieveTierRecords();
        Assertions.assertTrue((boolean)eventFromStart.contains((Object)topicIdPartition), (String)"Expected non-zero events");
        topicEvents1 = (TierTopicEvents)eventFromStart.getOrElse((Object)topicIdPartition, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyCommitAndSwapEvent$2(), ()Lkafka/durability/utils/TierTopicEvents;)());
        Assertions.assertTrue((boolean)(topicEvents1.uploadMessages().nonEmpty() != false && topicEvents1.uploadInitMessages().nonEmpty() != false && topicEvents1.commitAndSwapMessages().nonEmpty() != false), (String)"Expected non-zero events");
        Assertions.assertTrue((boolean)DurabilityTierTopicReader$.MODULE$.apply(auditManager.config(), new CountDownLatch(1), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicIdPartition), (Object)BoxesRunTime.boxToLong((long)0L))}))).retrieveTierRecords().contains((Object)topicIdPartition), (String)"Expected non-zero events");
        topicEvents2 = (TierTopicEvents)eventFromStart.getOrElse((Object)topicIdPartition, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyCommitAndSwapEvent$3(), ()Lkafka/durability/utils/TierTopicEvents;)());
        Assertions.assertTrue((boolean)(topicEvents2.uploadMessages().nonEmpty() != false && topicEvents2.uploadInitMessages().nonEmpty() != false && topicEvents2.commitAndSwapMessages().nonEmpty() != false), (String)"Expected non-zero events");
        v0 = topicEvents2.uploadMessages();
        var12_12 = topicEvents1.uploadMessages();
        if (v0 != null ? v0.equals(var12_12) == false : var12_12 != null) ** GOTO lbl-1000
        v1 = topicEvents2.uploadInitMessages();
        var13_13 = topicEvents1.uploadInitMessages();
        if (v1 != null ? v1.equals(var13_13) == false : var13_13 != null) ** GOTO lbl-1000
        v2 = topicEvents2.commitAndSwapMessages();
        var14_14 = topicEvents1.commitAndSwapMessages();
        if (!(v2 != null ? v2.equals(var14_14) == false : var14_14 != null)) {
            v3 = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = false;
        }
        Assertions.assertTrue((boolean)v3, (String)"Messages count doesn't match");
    }

    private void runAuditJob(Seq<Tuple2<TopicPartition, Object>> topicPartitionInfo) {
        int brokerId = 0;
        KafkaBroker broker = (KafkaBroker)this.brokerForId(brokerId).get();
        AuditManager auditManager = (AuditManager)broker.auditManager().get();
        Set auditChecks = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{DurabilityAuditCheck$.MODULE$.ChecksumAudit(), DurabilityAuditCheck$.MODULE$.PeriodicalAudit(), DurabilityAuditCheck$.MODULE$.CompactTopicAudit()}));
        new AuditJob(topicPartitionInfo, broker.logManager(), new CountDownLatch(1), auditManager.reporter(), 0, broker.tierObjectStoreOpt(), Time.SYSTEM, auditChecks, auditManager.config(), auditManager.db(), (Option)new Some((Object)auditManager.replicaManager())).run();
        topicPartitionInfo.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DurabilityTierCompactionTest.$anonfun$runAuditJob$1(auditManager, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(DurabilityTierCompactionTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ Tuple2 $anonfun$produceKeyedRecords$1(DurabilityTierCompactionTest $this, Random random$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt($this.maxNumRecords() / 10), $this.numProducedRecords() + i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$1) {
        tierPartitionState$1.flush();
        ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState$1.segments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        return log$1.tierableLogSegments().isEmpty() && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$1, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(168).append("timeout waiting for tiered segments to be compacted.").append(" tierable segments: ").append(log$1.tierableLogSegments()).append(",").append(" local segments ").append(log$1.localLogSegments()).append(",").append(" tiered segments: ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState$1.segments()).asScala()).toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 90000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState.segments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(DurabilityTierCompactionTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            DurabilityTierCompactionTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Uuid $anonfun$verifyCommitAndSwapEvent$1() {
        return Uuid.ZERO_UUID;
    }

    public static final /* synthetic */ TierTopicEvents $anonfun$verifyCommitAndSwapEvent$2() {
        return TierTopicEvents$.MODULE$.apply();
    }

    public static final /* synthetic */ TierTopicEvents $anonfun$verifyCommitAndSwapEvent$3() {
        return TierTopicEvents$.MODULE$.apply();
    }

    public static final /* synthetic */ void $anonfun$runAuditJob$1(AuditManager auditManager$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Assertions.assertTrue((auditManager$1.reporter().getDurabilityCounters(topicPartition)._2$mcJ$sp() == 0L ? 1 : 0) != 0);
            return;
        }
        throw new MatchError(null);
    }

    public DurabilityTierCompactionTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().setProperty("confluent.durability.audit.enable", Boolean.toString(true));
        this.serverConfig().setProperty("confluent.durability.topic.replication.factor", "1");
        this.serverConfig().setProperty("confluent.durability.topic.partition.count", "1");
        this.serverConfig().setProperty("confluent.durability.audit.batch.flush.frequency.ms", "1500");
        this.serverConfig().setProperty("confluent.durability.events.allowed", "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType");
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.maxNumRecords = 5000;
        this.numProducedRecords = 0;
        this.producedRecords = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

