/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t]h\u0001\u0002\u0017.\u0001QBQ\u0001\u0010\u0001\u0005\u0002uBQ\u0001\u0011\u0001\u0005R\u0005CQ\u0001\u0013\u0001\u0005\n%Cq!\u0014\u0001C\u0002\u0013%a\n\u0003\u0004X\u0001\u0001\u0006Ia\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0003B\u0011\u0019I\u0006\u0001)A\u0005\u0005\"9!\f\u0001a\u0001\n\u0013Y\u0006b\u00023\u0001\u0001\u0004%I!\u001a\u0005\u0007Q\u0002\u0001\u000b\u0015\u0002/\t\u000f%\u0004!\u0019!C\u0005\u0003\"1!\u000e\u0001Q\u0001\n\tCqa\u001b\u0001A\u0002\u0013%\u0011\tC\u0004m\u0001\u0001\u0007I\u0011B7\t\r=\u0004\u0001\u0015)\u0003C\u0011\u001d\u0001\bA1A\u0005\nEDaa\u001e\u0001!\u0002\u0013\u0011\b\"\u0002=\u0001\t\u0013I\b\"CA\u0012\u0001\t\u0007I\u0011AA\u0013\u0011!\tY\u0004\u0001Q\u0001\n\u0005\u001d\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\u0007\u0003?\u0002A\u0011I%\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\t\t\u000e\u0001C\u0001\u0003'Dq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002j\u0002!I!a;\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!Q\u0004\u0001\u0005\n\t\u0015\u0002b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011\u0019\u0011Y\u0007\u0001C\u0005\u0013\"1!Q\u000e\u0001\u0005\n%CaAa\u001c\u0001\t\u0013I\u0005B\u0002B9\u0001\u0011%\u0011\nC\u0004\u0003t\u0001!IA!\u001e\t\u000f\t5\u0005\u0001\"\u0003\u0003\u0010\"I!1\u0014\u0001\u0012\u0002\u0013%!Q\u0014\u0005\b\u0005\u001b\u0003A\u0011\u0002BZ\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{CqA!8\u0001\t\u0013\u0011yN\u0001\u000eUS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8F]\u0012$v.\u00128e)\u0016\u001cHO\u0003\u0002/_\u0005!A/[3s\u0015\t\u0001\u0014'A\u0003lC\u001a\\\u0017MC\u00013\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M\u0011\u0001!\u000e\t\u0003mij\u0011a\u000e\u0006\u0003qe\n1!\u00199j\u0015\u0005\u0001\u0014BA\u001e8\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001?!\ty\u0004!D\u0001.\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u00131!\u00138u\u00035\u0019wN\u001c4jOV\u0014X-T8dWR\t!\n\u0005\u0002D\u0017&\u0011A\n\u0012\u0002\u0005+:LG/A\u0003u_BL7-F\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003mC:<'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N\f1\u0002]1si&$\u0018n\u001c8tA\u0005\u0001\u0002/\u0019:uSRLwN\u001c'fC\u0012,'o]\u000b\u00029B!QL\u0019\"C\u001b\u0005q&BA0a\u0003%IW.\\;uC\ndWM\u0003\u0002b\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\rt&aA'ba\u0006!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'o]0%KF$\"A\u00134\t\u000f\u001dL\u0011\u0011!a\u00019\u0006\u0019\u0001\u0010J\u0019\u0002#A\f'\u000f^5uS>tG*Z1eKJ\u001c\b%A\u0007nCbtU/\u001c*fG>\u0014Hm]\u0001\u000f[\u0006Dh*^7SK\u000e|'\u000fZ:!\u0003IqW/\u001c)s_\u0012,8-\u001a3SK\u000e|'\u000fZ:\u0002-9,X\u000e\u0015:pIV\u001cW\r\u001a*fG>\u0014Hm]0%KF$\"A\u00138\t\u000f\u001dt\u0011\u0011!a\u0001\u0005\u0006\u0019b.^7Qe>$WoY3e%\u0016\u001cwN\u001d3tA\u0005y\u0001O]8ek\u000e,GMU3d_J$7/F\u0001s!\u0011\u0019hO\u0011\"\u000e\u0003QT!!\u001e1\u0002\u000f5,H/\u00192mK&\u00111\r^\u0001\u0011aJ|G-^2fIJ+7m\u001c:eg\u0002\nq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002uB)10a\u0002\u0002\u000e9\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\ty8'\u0001\u0004=e>|GOP\u0005\u0002\u000b&\u0019\u0011Q\u0001#\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000b!\u0005\u0003BA\b\u0003?i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0007G>lWn\u001c8\u000b\u0007A\n9B\u0003\u0003\u0002\u001a\u0005m\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001e\u0005\u0019qN]4\n\t\u0005\u0005\u0012\u0011\u0003\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019)\u00070\u001b;fIV\u0011\u0011q\u0005\t\u0005\u0003S\t9$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0019\tGo\\7jG*!\u0011\u0011GA\u001a\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003k\u0019\u0016\u0001B;uS2LA!!\u000f\u0002,\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq!\u001a=ji\u0016$\u0007%A\u0003tKR,\u0006\u000fF\u0002K\u0003\u0003Bq!a\u0011\u0016\u0001\u0004\t)%\u0001\u0005uKN$\u0018J\u001c4p!\u0011\t9%a\u0015\u000e\u0005\u0005%#b\u0001\u001d\u0002L)!\u0011QJA(\u0003\u001dQW\u000f]5uKJTA!!\u0015\u0002\u001c\u0005)!.\u001e8ji&!\u0011QKA%\u0005!!Vm\u001d;J]\u001a|\u0007fA\u000b\u0002ZA!\u0011qIA.\u0013\u0011\ti&!\u0013\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r1\u00121\r\t\u0005\u0003\u000f\n)'\u0003\u0003\u0002h\u0005%#!C!gi\u0016\u0014X)Y2i\u0003y!Xm\u001d;Be\u000eD\u0017N^3D_6\u0004\u0018m\u0019;B]\u0012$\u0016.\u001a:GKR\u001c\u0007\u000eF\u0002K\u0003[Bq!a\u001c\u0018\u0001\u0004\t\t(\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003g\nYH\u0004\u0003\u0002v\u0005]\u0004CA?E\u0013\r\tI\bR\u0001\u0007!J,G-\u001a4\n\u0007Y\u000biHC\u0002\u0002z\u0011CsaFAA\u0003#\u000b\u0019\n\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u0011A\u0014xN^5eKJTA!a#\u0002L\u00051\u0001/\u0019:b[NLA!a$\u0002\u0006\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!!&\u0002\u001a\u0006\u0012\u0011qS\u0001\u0003u.\f#!a'\u0002\u000b-\u0014\u0018M\u001a;)\u000f]\ty*a*\u0002*B!\u0011\u0011UAR\u001b\t\tI)\u0003\u0003\u0002&\u0006%%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\tY+\u0001\r|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018rk>\u0014X/\\\u001f|au\fQ\u0005^3ti\u0012+G.\u001a;f\u0007>l\u0007/Y2uK\u0012\u001cVmZ7f]R\u001chI]8n\u0011>$8/\u001a;\u0015\u0007)\u000b\t\fC\u0004\u0002pa\u0001\r!!\u001d)\u000fa\t\t)!%\u000262\"\u0011QSAMQ\u001dA\u0012qTAT\u0003S\u000bA\u0004^3ti6+GO]5dg:{G/Q2rk&\u0014X\rT8h\u0019>\u001c7\u000eF\u0002K\u0003{Cq!a\u001c\u001a\u0001\u0004\t\t\bK\u0004\u001a\u0003\u0003\u000b\t*!1-\t\u0005U\u0015\u0011\u0014\u0015\b3\u0005}\u0015qUAU\u0003Q\"Xm\u001d;D_:\u001cWO\u001d:f]RdunY1m\u0003:$G+[3s\u0007>l\u0007/Y2uS>tWI\\1cY\u0016\fe\u000e\u001a#jg\u0006\u0014G.\u001a\u000b\u0004\u0015\u0006%\u0007bBA85\u0001\u0007\u0011\u0011\u000f\u0015\b5\u0005\u0005\u0015\u0011SAgY\t\t)\nK\u0004\u001b\u0003?\u000b9+!+\u0002oQ,7\u000f^\"p]\u000e,(O]3oi2{7-\u00197B]\u0012$\u0016.\u001a:D_6\u0004\u0018m\u0019;j_:<\u0016\u000e\u001e5Qe\u00164WM\u001d+jKJ4U\r^2i)\rQ\u0015Q\u001b\u0005\b\u0003_Z\u0002\u0019AA9Q\u001dY\u0012\u0011QAI\u00033d#!!&)\u000fm\ty*a*\u0002*\u0006QD/Z:u\u0007>t7-\u001e:sK:$Hj\\2bY\u0006sG\rV5fe\u000e{W\u000e]1di&|g\u000eR5tC\ndW\rT8dC2\u001cu.\u001c9bGRLwN\u001c\u000b\u0004\u0015\u0006\u0005\bbBA89\u0001\u0007\u0011\u0011\u000f\u0015\b9\u0005\u0005\u0015\u0011SAsY\t\t)\nK\u0004\u001d\u0003?\u000b9+!+\u0002GY,'/\u001b4z\u001b\u0016$(/[2t\u0007\u0006dGNY1dW:{Go\u0012:bE2{w\rT8dWRY!*!<\u0002r\n\r!Q\u0002B\r\u0011\u0019\ty/\ba\u0001\u0005\u0006AAn\\4J]\u0012,\u0007\u0010C\u0004\u0002tv\u0001\r!!>\u0002\t1|wm\u001d\t\u0006w\u0006\u001d\u0011q\u001f\t\u0005\u0003s\fy0\u0004\u0002\u0002|*\u0019\u0011Q`\u001d\u0002\u00071|w-\u0003\u0003\u0003\u0002\u0005m(aC!cgR\u0014\u0018m\u0019;M_\u001eDqA!\u0002\u001e\u0001\u0004\u00119!\u0001\u0006cORC'/Z1e\u0013\u0012\u0003B!!\u000b\u0003\n%!!1BA\u0016\u0005)\tEo\\7jG2{gn\u001a\u0005\b\u0005\u001fi\u0002\u0019\u0001B\t\u0003\u0015a\u0017\r^2i!\u0011\u0011\u0019B!\u0006\u000e\u0005\u0005=\u0012\u0002\u0002B\f\u0003_\u0011abQ8v]R$un\u001e8MCR\u001c\u0007\u000eC\u0004\u0003\u001cu\u0001\r!a\n\u0002-5,GO]5dg\u000e{W\u000e];uK\u000e{W\u000e\u001d7fi\u0016\f1\u0003\u001d:pIV\u001cWmS3zK\u0012\u0014VmY8sIN$2A\u0013B\u0011\u0011\u0019\u0011\u0019C\ba\u0001\u0005\u0006Qa.^7SK\u000e|'\u000fZ:\u0015\u0007)\u00139\u0003C\u0004\u0003*}\u0001\rAa\u000b\u0002\u0013-,\u0017PV1mk\u0016\u001c\b#B>\u0003.\tE\u0012\u0002\u0002B\u0018\u0003\u0017\u0011A\u0001T5tiB)1Ia\rC\u0005&\u0019!Q\u0007#\u0003\rQ+\b\u000f\\33\u0003]\u0019wN\u001c4jOV\u0014X\rR;bY\u000e{W\u000e]1di&|g\u000eF\u0002K\u0005wAqA!\u0010!\u0001\u0004\u0011y$A\u0003qe>\u00048\u000f\u0005\u0003\u0003B\t\rSBAA\u001a\u0013\u0011\u0011)%a\r\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tbYR,'\u000fV8qS\u000e\u001cuN\u001c4jOR!!1\nB.!\u0011\u0011iEa\u0016\u000e\u0005\t=#\u0002\u0002B)\u0005'\nQ!\u00193nS:TAA!\u0016\u0002\u0016\u000591\r\\5f]R\u001c\u0018\u0002\u0002B-\u0005\u001f\u0012!#\u00117uKJ\u001cuN\u001c4jON\u0014Vm];mi\"9!QL\u0011A\u0002\t}\u0013!D2p]\u001aLw-\u00128ue&,7\u000f\u0005\u0004\u0003B\t\u0005$QM\u0005\u0005\u0005G\n\u0019DA\u0005BeJ\f\u0017\u0010T5tiB!!Q\nB4\u0013\u0011\u0011IGa\u0014\u0003\u001b\u0005cG/\u001a:D_:4\u0017nZ(q\u0003\r:\u0018-\u001b;V]RLGnU3h[\u0016tGo\u001d+jKJ,G-\u00118e\u0007>l\u0007/Y2uK\u0012\f\u0011e^1jiVsG/\u001b7TK\u001elWM\u001c;t\u0019>\u001c\u0017\r\u001c7z\u0007>l\u0007/Y2uK\u0012\fQe^1jiVsG/\u001b7BY2\u001cVmZ7f]R\u001cH)\u001a7fi\u0016$gI]8n\u0011>$8/\u001a;\u0002c]\f\u0017\u000e^+oi&d7+Z4nK:$8\u000fT8dC2d\u0017pQ8na\u0006\u001cG/\u001a3B]\u0012$\u0016.\u001a:D_6\u0004\u0018m\u0019;fI\u0006aa/\u00197jI\u0006$X\rT8hgR\u0019!Ja\u001e\t\u000f\ted\u00051\u0001\u0003|\u0005Ia/\u00197jI\u0006$xN\u001d\t\t\u0007\nu$\u0011QA|\u0015&\u0019!q\u0010#\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003\u0002BB\u0005\u0013k!A!\"\u000b\u0007\t\u001d\u0015(\u0001\u0004tKJ4XM]\u0005\u0005\u0005\u0017\u0013)IA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\u0018aG2p]N,X.Z!oIZ\u000bG.\u001b3bi\u0016$\u0016.\u001a:GKR\u001c\u0007\u000eF\u0002K\u0005#C\u0011Ba%(!\u0003\u0005\rA!&\u0002!%\u001cH)^1m\u0007>l\u0007/Y2uS>t\u0007cA\"\u0003\u0018&\u0019!\u0011\u0014#\u0003\u000f\t{w\u000e\\3b]\u0006)3m\u001c8tk6,\u0017I\u001c3WC2LG-\u0019;f)&,'OR3uG\"$C-\u001a4bk2$H%M\u000b\u0003\u0005?SCA!&\u0003\".\u0012!1\u0015\t\u0005\u0005K\u0013y+\u0004\u0002\u0003(*!!\u0011\u0016BV\u0003%)hn\u00195fG.,GMC\u0002\u0003.\u0012\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tLa*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rF\u0003K\u0005k\u0013I\f\u0003\u0004\u00038&\u0002\rA]\u0001\fWZ\u001cX\t\u001f9fGR,G\rC\u0004\u0003\u0014&\u0002\rA!&\u0002#\u001d,G/\u0014\"fC:\fE\u000f\u001e:jEV$X-\u0006\u0003\u0003@\n\u0015GC\u0002Ba\u0005/\u0014I\u000e\u0005\u0003\u0003D\n\u0015G\u0002\u0001\u0003\b\u0005\u000fT#\u0019\u0001Be\u0005\u0005!\u0016\u0003\u0002Bf\u0005#\u00042a\u0011Bg\u0013\r\u0011y\r\u0012\u0002\b\u001d>$\b.\u001b8h!\r\u0019%1[\u0005\u0004\u0005+$%aA!os\"9\u0011q\u0015\u0016A\u0002\u0005E\u0004b\u0002BnU\u0001\u0007\u0011\u0011O\u0001\nCR$(/\u001b2vi\u0016\f\u0011cZ3u\u001b\u0016$(/[2P]2+\u0017\rZ3s)\u0011\u0011\tO!<\u0011\t\t\r(\u0011^\u0007\u0003\u0005KTAAa:\u0002\u0012\u00059Q.\u001a;sS\u000e\u001c\u0018\u0002\u0002Bv\u0005K\u00141bS1gW\u0006lU\r\u001e:jG\"9!q^\u0016A\u0002\tE\u0018AC7fiJL7MT1nKB!\u0011q\u0002Bz\u0013\u0011\u0011)0!\u0005\u0003\u00155+GO]5d\u001d\u0006lW\r")
public class TierCompactionEndToEndTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private scala.collection.immutable.Map<Object, Object> partitionLeaders;
    private final int maxNumRecords;
    private int numProducedRecords;
    private final Map<Object, Object> producedRecords;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 3;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private scala.collection.immutable.Map<Object, Object> partitionLeaders() {
        return this.partitionLeaders;
    }

    private void partitionLeaders_$eq(scala.collection.immutable.Map<Object, Object> x$1) {
        this.partitionLeaders = x$1;
    }

    private int maxNumRecords() {
        return this.maxNumRecords;
    }

    private int numProducedRecords() {
        return this.numProducedRecords;
    }

    private void numProducedRecords_$eq(int x$1) {
        this.numProducedRecords = x$1;
    }

    private Map<Object, Object> producedRecords() {
        return this.producedRecords;
    }

    private Seq<TopicPartition> topicPartitions() {
        return (Seq)package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable & scala.Serializable)p -> TierCompactionEndToEndTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveCompactAndTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(this.consumeAndValidateTierFetch$default$1());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCompactedSegmentsFromHotset(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "86400000");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(this.consumeAndValidateTierFetch$default$1());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMetricsNotAcquireLogLock(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", new StringBuilder(14).append("compact").append(",").append("delete").toString());
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        Seq logs = (Seq)this.brokers().toSeq().flatMap((Function1 & Serializable & scala.Serializable)broker -> broker.logManager().allLogs(), Seq$.MODULE$.canBuildFrom());
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean metricsComputeComplete = new AtomicBoolean(false);
        AtomicLong bgThreadID = new AtomicLong(-1L);
        Runnable computeMetrics = () -> {
            bgThreadID.set(Thread.currentThread().getId());
            latch.await();
            ((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null && (Metric)check$ifrefutable$1._2() instanceof Gauge))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                Metric gauge;
                if (x$3 == null || !((gauge = (Metric)x$3._2()) instanceof Gauge)) {
                    throw new MatchError(x$3);
                }
                Object object = ((Gauge)gauge).value();
                return object;
            });
            metricsComputeComplete.set(true);
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = executor.submit(computeMetrics);
            this.verifyMetricsCallbackNotGrabLogLock(0, (Seq<AbstractLog>)logs, bgThreadID, latch, metricsComputeComplete);
            future.get();
        }
        finally {
            executor.shutdownNow();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testConcurrentLocalAndTierCompactionEnableAndDisable(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("confluent.tier.cleaner.enable", "false");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$4, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$1(x$4, log);
            return BoxedUnit.UNIT;
        });
        this.waitUntilSegmentsLocallyCompacted();
        ArrayList<AlterConfigOp> newConfigs1 = new ArrayList<AlterConfigOp>();
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.enable", "true"), AlterConfigOp.OpType.SET));
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.dual.compaction", "true"), AlterConfigOp.OpType.SET));
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", Double.toString(0.1)), AlterConfigOp.OpType.SET));
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.min.cleanable.ratio", Double.toString(0.1)), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs1);
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$5, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$2(x$5, log);
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$6, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$7, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        });
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        this.produceKeyedRecords(2000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        ArrayList<AlterConfigOp> newConfigs2 = new ArrayList<AlterConfigOp>();
        newConfigs2.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.enable", "false"), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs2);
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$8, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$7(x$8, log);
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$9, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$10, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        });
        this.produceKeyedRecords(2000);
        this.waitUntilSegmentsLocallyCompacted();
        ArrayList<AlterConfigOp> newConfigs3 = new ArrayList<AlterConfigOp>();
        newConfigs3.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.enable", "true"), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs3);
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$11, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$12(x$11, log);
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$12, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$13, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        });
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        this.produceKeyedRecords(3000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testConcurrentLocalAndTierCompactionWithPreferTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.configureDualCompaction(props);
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(6000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        this.consumeAndValidateTierFetch(true);
        MetricName bytesFetchedTotalMetricName = new MetricName("BytesFetchedTotal", "TierFetcher", "", Collections.emptyMap());
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.getMetricOnLeader(bytesFetchedTotalMetricName).metricValue()) == 0.0 ? 1 : 0) != 0);
        int preferTierFetchMs = 0;
        ArrayList<AlterConfigOp> newConfigs = new ArrayList<AlterConfigOp>();
        newConfigs.add(new AlterConfigOp(new ConfigEntry("confluent.compacted.topic.prefer.tier.fetch.ms", Integer.toString(preferTierFetchMs)), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs);
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$14, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$1(preferTierFetchMs, x$14, log);
            return BoxedUnit.UNIT;
        });
        this.consumeAndValidateTierFetch(true);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.getMetricOnLeader(bytesFetchedTotalMetricName).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testConcurrentLocalAndTierCompactionDisableLocalCompaction(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.configureDualCompaction(props);
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        ArrayList<AlterConfigOp> newConfigs = new ArrayList<AlterConfigOp>();
        newConfigs.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.dual.compaction", "false"), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs);
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$15, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$1(x$15, log);
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$16, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        });
        this.validateLogs((Function2<KafkaBroker, AbstractLog, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x$17, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        });
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(true);
        this.produceKeyedRecords(3000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(true);
    }

    private void verifyMetricsCallbackNotGrabLogLock(int logIndex, Seq<AbstractLog> logs, AtomicLong bgThreadID, CountDownLatch latch, AtomicBoolean metricsComputeComplete) {
        if (logIndex < logs.size()) {
            Object object = ((MergedLog)logs.apply(logIndex)).lock();
            synchronized (object) {
                this.verifyMetricsCallbackNotGrabLogLock(logIndex + 1, logs, bgThreadID, latch, metricsComputeComplete);
                return;
            }
        }
        latch.countDown();
        while (!metricsComputeComplete.get()) {
            ThreadInfo bgThreadInfo;
            Thread.sleep(500L);
            if (bgThreadID.get() <= 0L || (bgThreadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(bgThreadID.get())) == null) continue;
            Assertions.assertNotEquals((Object)((Object)Thread.State.BLOCKED), (Object)((Object)bgThreadInfo.getThreadState()));
        }
    }

    private void produceKeyedRecords(int numRecords) {
        Random random = new Random();
        List keyValues = (List)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).toList().map((Function1 & Serializable & scala.Serializable)i -> TierCompactionEndToEndTest.$anonfun$produceKeyedRecords$1(this, random, BoxesRunTime.unboxToInt((Object)i)), List$.MODULE$.canBuildFrom());
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)keyValues);
        this.numProducedRecords_$eq(this.numProducedRecords() + numRecords);
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable & scala.Serializable)group -> (List)((List)((List)group.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int k = x0$1._1$mcI$sp();
                int v = x0$1._2$mcI$sp();
                this.producedRecords().put((Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)v));
                long timestamp = System.currentTimeMillis();
                ProducerRecord producerRecord = new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                return producerRecord;
            }, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$18 -> (RecordMetadata)x$18.get(10L, TimeUnit.SECONDS), List$.MODULE$.canBuildFrom()));
        }
    }

    private void configureDualCompaction(Properties props) {
        props.put("confluent.tier.cleaner.dual.compaction", "true");
        props.put("min.cleanable.dirty.ratio", Double.toString(0.1));
    }

    private AlterConfigsResult alterTopicConfig(ArrayList<AlterConfigOp> configEntries) {
        AlterConfigsResult alterConfigsResult;
        HashMap<ConfigResource, ArrayList<AlterConfigOp>> configs = new HashMap<ConfigResource, ArrayList<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topic()), configEntries);
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(configs);
        }
        return alterConfigsResult;
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void waitUntilSegmentsLocallyCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsLocallyCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void waitUntilAllSegmentsDeletedFromHotset() {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void waitUntilSegmentsLocallyCompactedAndTierCompacted() {
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilSegmentsLocallyCompacted();
    }

    private void validateLogs(Function2<KafkaBroker, AbstractLog, BoxedUnit> validator) {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validator, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void consumeAndValidateTierFetch(boolean isDualCompaction) {
        this.consumeAndValidateTierFetch(this.producedRecords(), isDualCompaction);
    }

    private void consumeAndValidateTierFetch(Map<Object, Object> kvsExpected, boolean isDualCompaction) {
        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
        KafkaConsumer consumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.List<TopicPartition> partitions = Collections.singletonList(topicPartition);
        consumer.assign(partitions);
        consumer.seekToBeginning(partitions);
        ArrayList kvsRead = new ArrayList();
        int timeout = 5000;
        ConsumerRecords records = consumer.poll(Duration.ofMillis(timeout));
        do {
            records.forEach((Consumer)new Consumer<ConsumerRecord<String, String>>(null, kvsRead){
                private final ArrayList kvsRead$1;

                public Consumer<ConsumerRecord<String, String>> andThen(Consumer<? super ConsumerRecord<String, String>> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                public void accept(ConsumerRecord<String, String> r) {
                    this.kvsRead$1.add(new Tuple2.mcII.sp(Integer.parseInt((String)r.key()), Integer.parseInt((String)r.value())));
                }
                {
                    this.kvsRead$1 = kvsRead$1;
                }
            });
        } while (!(records = consumer.poll(Duration.ofMillis(timeout))).isEmpty());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(kvsRead).asScala()).toMap(Predef$.MODULE$.$conforms()), kvsExpected);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=read,form=tier", "MeanRate")) > 0.0 ? 1 : 0) != 0, (String)"Compaction read throughput should be > 0");
        Assertions.assertTrue((BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=write,form=tier", "MeanRate")) > 0.0 ? 1 : 0) != 0, (String)"Compaction write throughput should be > 0");
        int partitionsTaskInError = BoxesRunTime.unboxToInt(this.getMBeanAttribute("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError", "Value"));
        Assertions.assertEquals((int)0, (int)partitionsTaskInError, (String)"task shows no partitions in error state");
        if (isDualCompaction) {
            Assertions.assertTrue((BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionValidationPassedPerSec,form=tier", "MeanRate")) > 0.0 ? 1 : 0) != 0, (String)"Compaction validation passed > 0");
            double compactionValidationFailed = BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionValidationFailedPerSec,form=tier", "MeanRate"));
            Assertions.assertEquals((double)0.0, (double)compactionValidationFailed, (String)"Compaction validation failed count shall be 0");
        }
    }

    private boolean consumeAndValidateTierFetch$default$1() {
        return false;
    }

    private <T> T getMBeanAttribute(String name, String attribute) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return (T)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName(name), (String[])((Object[])new String[]{attribute})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> attr.getValue(), Buffer$.MODULE$.canBuildFrom())).head();
    }

    private KafkaMetric getMetricOnLeader(MetricName metricName) {
        int leaderId = BoxesRunTime.unboxToInt((Object)this.partitionLeaders().apply((Object)BoxesRunTime.boxToInteger((int)0)));
        return (KafkaMetric)((TraversableOnce)((TraversableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionEndToEndTest.$anonfun$getMetricOnLeader$1(leaderId, x$19)))).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.metrics().metric(metricName), Buffer$.MODULE$.canBuildFrom())).toList().head();
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierCompactionEndToEndTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$1(KafkaBroker x$4, AbstractLog log) {
        log.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$3(AbstractLog log$1) {
        return log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$4() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$2(KafkaBroker x$5, AbstractLog log) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$8(AbstractLog log$2) {
        return !log$2.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$9() {
        return "TierPartitionState#tieringEnabled flag set to false";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$7(KafkaBroker x$8, AbstractLog log) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$8(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$13(AbstractLog log$3) {
        return log$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$14() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$12(KafkaBroker x$11, AbstractLog log) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$13(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$14());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$2(AbstractLog log$4, int preferTierFetchMs$1) {
        return BoxesRunTime.equalsNumObject((Number)log$4.config().confluentLogConfig().preferTierFetchMs(), (Object)BoxesRunTime.boxToInteger((int)preferTierFetchMs$1));
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$3() {
        return "Timeout setting PreferTierFetchMs";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$1(int preferTierFetchMs$1, KafkaBroker x$14, AbstractLog log) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$2(log, preferTierFetchMs$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$2(AbstractLog log$5) {
        return !Predef$.MODULE$.Boolean2boolean(log$5.config().confluentLogConfig().tierCleanerDualCompaction());
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$3() {
        return "Timeout setting TierCleanerDualCompaction to false";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$1(KafkaBroker x$15, AbstractLog log) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$2(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$produceKeyedRecords$1(TierCompactionEndToEndTest $this, Random random$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt($this.maxNumRecords() / 10), $this.numProducedRecords() + i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$6) {
        tierPartitionState$1.flush();
        ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState$1.segments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        return log$6.tierableLogSegments().isEmpty() && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$6, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(168).append("timeout waiting for tiered segments to be compacted.").append(" tierable segments: ").append(log$6.tierableLogSegments()).append(",").append(" local segments ").append(log$6.localLogSegments()).append(",").append(" tiered segments: ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState$1.segments()).asScala()).toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 90000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState.segments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(TierCompactionEndToEndTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsLocallyCompacted$2(TopicPartition tp$2, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$2, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        Assertions.assertTrue((boolean)broker.logManager().cleaner().awaitCleaned(tp$2, tierPartitionState.compactDirtyStartOffset(), 90000L), (String)new StringBuilder(208).append("timeout waiting for local segments to be compacted.").append(" tierable segments: ").append(log.tierableLogSegments()).append(",").append(" local segments ").append(log.localLogSegments()).append(",").append(" tiered segments: ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState.segments()).asScala()).toList()).append(",").append(" end offset: ").append(tierPartitionState.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState.committedEndOffset()).append(",").append(" tier cleaner dirty start offset: ").append(tierPartitionState.compactDirtyStartOffset()).append(",").append(" local cleaner checkpoint: ").append(broker.logManager().cleaner().cleanerManager().allCleanerCheckpoints().get((Object)tp$2)).toString());
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsLocallyCompacted$1(TierCompactionEndToEndTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsLocallyCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilAllSegmentsDeletedFromHotset$3(AbstractLog log$7) {
        return log$7.localLogSegments().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$waitUntilAllSegmentsDeletedFromHotset$4(AbstractLog log$7) {
        return new StringBuilder(82).append("Timeout waiting for local segments from being removed from hotset. local segments ").append(log$7.localLogSegments()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilAllSegmentsDeletedFromHotset$2(TopicPartition tp$3, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$3, x$2).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 90000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$4(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$waitUntilAllSegmentsDeletedFromHotset$1(TierCompactionEndToEndTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validateLogs$2(TopicPartition tp$4, Function2 validator$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$4, x$2).get();
        validator$1.apply((Object)broker, (Object)log);
    }

    public static final /* synthetic */ void $anonfun$validateLogs$1(TierCompactionEndToEndTest $this, Function2 validator$1, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$2(tp, validator$1, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMetricOnLeader$1(int leaderId$1, KafkaBroker x$19) {
        return x$19.config().brokerId() == leaderId$1;
    }

    public TierCompactionEndToEndTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerDualCompactionValidationPercentProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "0");
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.partitionLeaders = null;
        this.maxNumRecords = 5000;
        this.numProducedRecords = 0;
        this.producedRecords = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

