/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.management;

import integration.kafka.tier.management.BackupObjectLifecycleManagerTestUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.UUID;
import kafka.backupRestore.objectLifecycle.serdes.LifecycleManagerState;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupobjectlifecycle.LifecycleManager;
import kafka.tier.backupobjectlifecycle.StateManager;
import kafka.tier.backupobjectlifecycle.StateManagerConfig;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\r\u001a\u0001\tBQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u0004:\u0001\u0001\u0006I\u0001\f\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u00199\u0005\u0001)A\u0005y!9\u0001\n\u0001b\u0001\n\u0003Y\u0003BB%\u0001A\u0003%A\u0006C\u0004K\u0001\t\u0007I\u0011A\u001e\t\r-\u0003\u0001\u0015!\u0003=\u0011\u001da\u0005A1A\u0005\u0002-Ba!\u0014\u0001!\u0002\u0013a\u0003b\u0002(\u0001\u0005\u0004%\ta\u000f\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002\u001f\t\u000fA\u0003!\u0019!C\u0001#\"1a\u000b\u0001Q\u0001\nICqa\u0016\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004`\u0001\u0001\u0006I!\u0017\u0005\u0006A\u0002!\t%\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006y\u0002!\t! \u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!a\u0011\u0001\t\u0003\t)EA\u0015CC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:N_\u000e\\G+[7f)\u0016\u001cHo\u001d\u0006\u00035m\t!\"\\1oC\u001e,W.\u001a8u\u0015\taR$\u0001\u0003uS\u0016\u0014(B\u0001\u0010 \u0003\u0015Y\u0017MZ6b\u0015\u0005\u0001\u0013aC5oi\u0016<'/\u0019;j_:\u001c\u0001a\u0005\u0002\u0001GA\u0011A%J\u0007\u00023%\u0011a%\u0007\u0002&\u0005\u0006\u001c7.\u001e9PE*,7\r\u001e'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s)\u0016\u001cH/\u0016;jYN\fa\u0001P5oSRtD#A\u0015\u0011\u0005\u0011\u0002\u0011a\u0002;pa&\u001cw,M\u000b\u0002YA\u0011QF\u000e\b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR!!M\u0011\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0012\u0014\u0001\u0003;pa&\u001cw,\r\u0011\u0002\tQ\u0004x,M\u000b\u0002yA\u0011Q(R\u0007\u0002})\u0011q\bQ\u0001\u0007G>lWn\u001c8\u000b\u0005y\t%B\u0001\"D\u0003\u0019\t\u0007/Y2iK*\tA)A\u0002pe\u001eL!A\u0012 \u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)A\u000f]02A\u00059Ao\u001c9jG~\u0013\u0014\u0001\u0003;pa&\u001cwL\r\u0011\u0002\tQ\u0004xLM\u0001\u0006iB|&\u0007I\u0001\bi>\u0004\u0018nY04\u0003!!x\u000e]5d?N\u0002\u0013\u0001\u0002;q?N\nQ\u0001\u001e9`g\u0001\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#\u0001*\u0011\u0005M#V\"\u0001\u001a\n\u0005U\u0013$aA%oi\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039z\nQ!\u001e;jYNL!AX.\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n!B\u0019:pW\u0016\u0014H+[7f)\t\u0011W\r\u0005\u0002[G&\u0011Am\u0017\u0002\u0005)&lW\rC\u0003g%\u0001\u0007!+\u0001\u0005ce>\\WM]%e\u0003\u0015\u0019X\r^+q)\tIG\u000e\u0005\u0002TU&\u00111N\r\u0002\u0005+:LG\u000fC\u0003n'\u0001\u0007a.\u0001\u0005uKN$\u0018J\u001c4p!\tyg/D\u0001q\u0015\t\t(/A\u0002ba&T!a\u001d;\u0002\u000f),\b/\u001b;fe*\u0011QoQ\u0001\u0006UVt\u0017\u000e^\u0005\u0003oB\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0003'e\u0004\"a\u001c>\n\u0005m\u0004(A\u0003\"fM>\u0014X-R1dQ\u0006iC/Z:u'\u0016<W.\u001a8ugR{')\u001a#fY\u0016$X\rZ%o)\",g)\u001e;ve\u0016<U\r^:EK2,G/\u001a3\u0015\u0005%t\b\"B@\u0015\u0001\u0004a\u0013AB9v_J,X\u000eK\u0004\u0015\u0003\u0007\t\u0019\"!\u0006\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005A\u0001O]8wS\u0012,'OC\u0002\u0002\u000eI\fa\u0001]1sC6\u001c\u0018\u0002BA\t\u0003\u000f\u00111BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFAA\fC\t\tI\"\u0001\u0002{W\":A#!\b\u0002&\u0005\u001d\u0002\u0003BA\u0010\u0003Ci!!a\u0003\n\t\u0005\r\u00121\u0002\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!!\u000b\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0A\fuKN$\u0018J\\2sK\u0006\u001cX-\u00138SKR,g\u000e^5p]R\u0019\u0011.a\f\t\u000b},\u0002\u0019\u0001\u0017)\u000fU\t\u0019!a\u0005\u000241\u0012\u0011q\u0003\u0015\b+\u0005u\u0011QEA\u0014\u0003]!Xm\u001d;EK\u000e\u0014X-Y:f\u0013:\u0014V\r^3oi&|g\u000eF\u0002j\u0003wAQa \fA\u00021BsAFA\u0002\u0003'\ty\u0004\f\u0002\u0002\u0018!:a#!\b\u0002&\u0005\u001d\u0012!\b;fgR$Um\u0019:fCN,\u0017J\\2sK\u0006\u001cXMU3uK:$\u0018n\u001c8\u0015\u0007%\f9\u0005C\u0003\u0000/\u0001\u0007A\u0006K\u0004\u0018\u0003\u0007\t\u0019\"a\u0013-\u0005\u0005]\u0001fB\f\u0002\u001e\u0005\u0015\u0012q\u0005")
public class BackupObjectLifecycleManagerMockTimeTests
extends BackupObjectLifecycleManagerTestUtils {
    private final String topic_1;
    private final TopicPartition tp_1 = new TopicPartition(this.topic_1(), 0);
    private final String topic_2;
    private final TopicPartition tp_2 = new TopicPartition(this.topic_2(), 0);
    private final String topic_3;
    private final TopicPartition tp_3 = new TopicPartition(this.topic_3(), 0);
    private final int numPartitions;
    private final MockTime time = new MockTime(0L, 1633846250000L, 1633846250000000L, true);

    public String topic_1() {
        return this.topic_1;
    }

    public TopicPartition tp_1() {
        return this.tp_1;
    }

    public String topic_2() {
        return this.topic_2;
    }

    public TopicPartition tp_2() {
        return this.tp_2;
    }

    public String topic_3() {
        return this.topic_3;
    }

    public TopicPartition tp_3() {
        return this.tp_3;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public MockTime time() {
        return this.time;
    }

    @Override
    public Time brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "7");
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3,4:4,5:5,6:6,7:7");
        this._testInfo_$eq(testInfo);
        super.setUp(this._testInfo());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testSegmentsToBeDeletedInTheFutureGetsDeleted(String quorum) {
        LifecycleManager clm = this.lifecycleManager();
        MockInMemoryTierObjectStore mockInMemoryTierObjectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        String x$1 = this.tp_1().topic();
        Properties x$2 = this.topicProps();
        int x$32 = this.createTopic$default$2();
        int x$42 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$32, x$42, x$2, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(topic1LeaderId).toList());
        this.changeTopicConfig("retention.ms", "259200000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        Option leader1Log = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().getLog(this.tp_1());
        FileTierPartitionState ftps1 = (FileTierPartitionState)((AbstractLog)leader1Log.get()).tierPartitionState();
        ReplicaManager replicaManager1 = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager();
        String x$7 = this.tp_2().topic();
        Properties x$8 = this.topicProps();
        int x$9 = this.createTopic$default$2();
        int x$10 = this.createTopic$default$3();
        ListenerName x$11 = this.createTopic$default$5();
        Properties x$12 = this.createTopic$default$6();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$7, x$9, x$10, x$8, x$11, x$12).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_2(), this.brokerForId(topic2LeaderId).toList());
        this.changeTopicConfig("retention.ms", "691200000", this.tp_2().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_2(), topic2LeaderId, 1);
        Option leader2Log = ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().getLog(this.tp_2());
        FileTierPartitionState ftps2 = (FileTierPartitionState)((AbstractLog)leader2Log.get()).tierPartitionState();
        ReplicaManager replicaManager2 = ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager();
        replicaManager1.deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1Log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$3 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$1(x$3);
            return BoxedUnit.UNIT;
        });
        long l = 500L;
        long l2 = 600000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$2(ftps1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegmentsTP1 = new HashSet<UUID>();
        deletedSegmentsTP1.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps1, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        replicaManager2.deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_2()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader2Log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$4 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$4(x$4);
            return BoxedUnit.UNIT;
        });
        long l3 = 500L;
        long l4 = 600000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$5(ftps2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegmentsTP2 = new HashSet<UUID>();
        deletedSegmentsTP2.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps2, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1Log.get()));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader2Log.get()));
        this.time().setCurrentTimeMs(this.time().milliseconds() + 259200000L);
        clm.doOneCLMRun();
        this.checkNonCurrentObjectExistence(deletedSegmentsTP1, (TopicIdPartition)ftps1.topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
        this.checkNonCurrentObjectExistence(deletedSegmentsTP2, (TopicIdPartition)ftps2.topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        .colon.colon retentionInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 3, -1, false, false), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_2().topic(), 7, -1, false, false), (List)Nil$.MODULE$));
        .colon.colon latestDataFilesInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 4), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 604800000L);
        clm.doOneCLMRun();
        this.checkNonCurrentObjectExistence(deletedSegmentsTP2, (TopicIdPartition)ftps2.topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
        .colon.colon retentionInfoList2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 3, -1, false, false), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_2().topic(), 7, -1, false, false), (List)Nil$.MODULE$));
        Nil$ latestDataFilesInfoList2 = Nil$.MODULE$;
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState2 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList2, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList2, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState2);
        this.deleteTopicAndWaitUntilDeleted(this.tp_1().topic());
        this.deleteTopicAndWaitUntilDeleted(this.tp_2().topic());
        clm.doOneCLMRun();
        Nil$ retentionInfoList3 = Nil$.MODULE$;
        Nil$ latestDataFilesInfoList3 = Nil$.MODULE$;
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState3 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList3, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList3, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState3);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testIncreaseInRetention(String quorum) {
        LifecycleManager clm = this.lifecycleManager();
        Properties props = new Properties();
        props.put("segment.bytes", "2048");
        props.put("confluent.tier.local.hotset.ms", "10");
        props.put("confluent.tier.local.hotset.bytes", "2048");
        props.put("file.delete.delay.ms", "10");
        String x$1 = this.tp_1().topic();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$52 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$4, props, x$52, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(topic1LeaderId).toList());
        Option leader1Log = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().getLog(this.tp_1());
        FileTierPartitionState ftps = (FileTierPartitionState)((AbstractLog)leader1Log.get()).tierPartitionState();
        MockInMemoryTierObjectStore objectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        long curTime = this.time().milliseconds();
        this.changeTopicConfig("retention.ms", "259200000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 10);
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1Log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$5 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testIncreaseInRetention$1(x$5);
            return BoxedUnit.UNIT;
        });
        long l = 500L;
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testIncreaseInRetention$2(ftps)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testIncreaseInRetention$3(ftps));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1Log.get()));
        clm.doOneCLMRun();
        LifecycleManagerState lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)objectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        .colon.colon retentionInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 3, -1, false, false), (List)Nil$.MODULE$);
        .colon.colon latestDataFilesInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 3), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList, 1);
        this.validateLifecycleManagerState(objectStore, lifecycleManagerExpectedState);
        .colon.colon blobMetadata = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 3L, new DateTime(curTime + 259200000L).dayOfMonth().get()), (List)Nil$.MODULE$);
        .colon.colon topicMetadataList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), ((TopicIdPartition)((AbstractLog)leader1Log.get()).topicIdPartition().get()).topicId().toString(), 0, TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadataList);
        this.validateBackupObjectsDeletionState(objectStore, lifecycleManagerState.latestDataFiles(0).latestFile(), lifecycleManagerState.latestDataFiles(0).date(), backupObjectsState);
        this.checkNonCurrentObjectExistence(TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        this.changeTopicConfig("retention.ms", "345600000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 10);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 259200000L);
        clm.doOneCLMRun();
        .colon.colon retentionInfoList2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 4, -1, false, false), (List)Nil$.MODULE$);
        .colon.colon latestDataFilesInfoList2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 1), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState2 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList2, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList2, 1);
        this.validateLifecycleManagerState(objectStore, lifecycleManagerExpectedState2);
        Nil$ blobMetadata2 = Nil$.MODULE$;
        int numDeleted = TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()).size();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numDeleted).foreach(arg_0 -> BackupObjectLifecycleManagerMockTimeTests.$anonfun$testIncreaseInRetention$6$adapted(this, (List)blobMetadata2, curTime, arg_0));
        .colon.colon topicMetadataList2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), ((TopicIdPartition)((AbstractLog)leader1Log.get()).topicIdPartition().get()).topicId().toString(), 0, TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata2), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState2 = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadataList2);
        this.validateBackupObjectsDeletionState(objectStore, ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfoList2.head()).latestFile(), ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfoList2.head()).date(), backupObjectsState2);
        this.checkNonCurrentObjectExistence(TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        .colon.colon retentionInfoList3 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 4, -1, false, false), (List)Nil$.MODULE$);
        Nil$ latestDataFilesInfoList3 = Nil$.MODULE$;
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState3 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList3, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList3, 1);
        this.validateLifecycleManagerState(objectStore, lifecycleManagerExpectedState3);
        this.checkNonCurrentObjectExistence(TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDecreaseInRetention(String quorum) {
        LifecycleManager clm = this.lifecycleManager();
        String x$1 = this.tp_1().topic();
        Properties x$2 = this.topicProps();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$62 = this.createTopic$default$6();
        int tp1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$4, x$2, x$5, x$62).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(tp1LeaderId).toList());
        Option leader1Log = ((KafkaBroker)this.brokerForId(tp1LeaderId).get()).replicaManager().getLog(this.tp_1());
        FileTierPartitionState ftps = (FileTierPartitionState)((AbstractLog)leader1Log.get()).tierPartitionState();
        ReplicaManager replicaManager = ((KafkaBroker)this.brokerForId(tp1LeaderId).get()).replicaManager();
        MockInMemoryTierObjectStore objectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        long curTime = this.time().milliseconds();
        this.changeTopicConfig("retention.ms", "345600000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), tp1LeaderId, 1);
        replicaManager.deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1Log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$6 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$1(x$6);
            return BoxedUnit.UNIT;
        });
        long l = 500L;
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$2(ftps)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$3(ftps));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1Log.get()));
        clm.doOneCLMRun();
        LifecycleManagerState lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)objectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        .colon.colon retentionInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 4, -1, false, false), (List)Nil$.MODULE$);
        .colon.colon latestDataFilesInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 4), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList, 1);
        this.validateLifecycleManagerState(objectStore, lifecycleManagerExpectedState);
        .colon.colon blobMetadata = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 4L, new DateTime(curTime + 345600000L).dayOfMonth().get()), (List)Nil$.MODULE$);
        .colon.colon topicMetadataList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), ((TopicIdPartition)((AbstractLog)leader1Log.get()).topicIdPartition().get()).topicId().toString(), 0, TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadataList);
        this.validateBackupObjectsDeletionState(objectStore, lifecycleManagerState.latestDataFiles(0).latestFile(), lifecycleManagerState.latestDataFiles(0).date(), backupObjectsState);
        this.checkNonCurrentObjectExistence(TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        HashSet<UUID> firstRunDeletedSegments = new HashSet<UUID>();
        firstRunDeletedSegments.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        this.changeTopicConfig("retention.ms", "259200000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), tp1LeaderId, 1);
        replicaManager.deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1Log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$7 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$6(x$7);
            return BoxedUnit.UNIT;
        });
        long l3 = 500L;
        long l4 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$7(ftps)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$8(ftps));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1Log.get()));
        clm.doOneCLMRun();
        lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)objectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        .colon.colon retentionInfoList2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 4, 3, true, true), (List)Nil$.MODULE$);
        .colon.colon latestDataFilesInfoList2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 4), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState2 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList2, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList2, 1);
        this.validateLifecycleManagerState(objectStore, lifecycleManagerExpectedState2);
        Nil$ blobMetadata2 = Nil$.MODULE$;
        int numDeleted1 = TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()).size();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), numDeleted1).foreach(arg_0 -> BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$11$adapted(this, (List)blobMetadata2, curTime, arg_0));
        .colon.colon topicMetadataList2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), ((TopicIdPartition)((AbstractLog)leader1Log.get()).topicIdPartition().get()).topicId().toString(), 0, TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata2), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState2 = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadataList2);
        this.validateBackupObjectsDeletionState(objectStore, lifecycleManagerState.latestDataFiles(0).latestFile(), lifecycleManagerState.latestDataFiles(0).date(), backupObjectsState2);
        this.checkNonCurrentObjectExistence(TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), tp1LeaderId, 1);
        replicaManager.deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1Log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$8 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$12(x$8);
            return BoxedUnit.UNIT;
        });
        long l5 = 500L;
        long l6 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$13(ftps)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$14(ftps));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegmentsAfterDecreaseInRetention = new HashSet<UUID>();
        deletedSegmentsAfterDecreaseInRetention.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        clm.doOneCLMRun();
        lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)objectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        .colon.colon retentionInfoList3 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 3, 3, true, true), (List)Nil$.MODULE$);
        .colon.colon latestDataFilesInfoList3 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 3), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState3 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList3, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList3, 1);
        this.validateLifecycleManagerState(objectStore, lifecycleManagerExpectedState3);
        Nil$ blobMetadata3 = Nil$.MODULE$;
        int numDeleted2 = TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()).size();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), numDeleted2).foreach(arg_0 -> BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$17$adapted(this, (List)blobMetadata3, curTime, arg_0));
        .colon.colon topicMetadataList3 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), ((TopicIdPartition)((AbstractLog)leader1Log.get()).topicIdPartition().get()).topicId().toString(), 0, TierTestUtils$.MODULE$.deletedSegments(ftps, TierTestUtils$.MODULE$.deletedSegments$default$2()), (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata3), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState3 = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadataList3);
        this.validateBackupObjectsDeletionState(objectStore, lifecycleManagerState.latestDataFiles(0).latestFile(), lifecycleManagerState.latestDataFiles(0).date(), backupObjectsState3);
        this.checkNonCurrentObjectExistence(deletedSegmentsAfterDecreaseInRetention, (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)objectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        Assertions.assertTrue((lifecycleManagerState.retentionDataLength() == 1 ? 1 : 0) != 0);
        String string = lifecycleManagerState.retentionData(0).topic();
        String string2 = this.tp_1().topic();
        Assertions.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.retentionData(0).currentRetentionInDays() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.tierOffsetsLength() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.tierOffsets(0) > 0L ? 1 : 0) != 0);
        this.checkNonCurrentObjectExistence(deletedSegmentsAfterDecreaseInRetention, (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)objectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        Assertions.assertTrue((lifecycleManagerState.retentionDataLength() == 1 ? 1 : 0) != 0);
        String string3 = lifecycleManagerState.retentionData(0).topic();
        String string4 = this.tp_1().topic();
        Assertions.assertTrue((!(string3 != null ? !string3.equals(string4) : string4 != null) ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.retentionData(0).currentRetentionInDays() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.tierOffsetsLength() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.tierOffsets(0) > 0L ? 1 : 0) != 0);
        this.checkNonCurrentObjectExistence(deletedSegmentsAfterDecreaseInRetention, (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        deletedSegmentsAfterDecreaseInRetention.removeIf(e -> firstRunDeletedSegments.contains(e));
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)objectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        Assertions.assertTrue((lifecycleManagerState.retentionDataLength() == 1 ? 1 : 0) != 0);
        String string5 = lifecycleManagerState.retentionData(0).topic();
        String string6 = this.tp_1().topic();
        Assertions.assertTrue((!(string5 != null ? !string5.equals(string6) : string6 != null) ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.retentionData(0).currentRetentionInDays() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.tierOffsetsLength() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((lifecycleManagerState.tierOffsets(0) > 0L ? 1 : 0) != 0);
        this.checkNonCurrentObjectExistence(deletedSegmentsAfterDecreaseInRetention, (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, true);
        this.checkNonCurrentObjectExistence(firstRunDeletedSegments, (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, false);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        this.checkNonCurrentObjectExistence(deletedSegmentsAfterDecreaseInRetention, (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, false);
        this.checkNonCurrentObjectExistence(firstRunDeletedSegments, (TopicIdPartition)ftps.topicIdPartition().get(), (TierObjectStore)objectStore, false);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDecreaseIncreaseRetention(String quorum) {
        Properties props = new Properties();
        props.put("segment.bytes", "2048");
        props.put("confluent.tier.local.hotset.ms", "10");
        props.put("confluent.tier.local.hotset.bytes", "2048");
        props.put("file.delete.delay.ms", "10");
        LifecycleManager clm = this.lifecycleManager();
        props.put("retention.ms", "604800000");
        String x$1 = this.tp_1().topic();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$4, props, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(topic1LeaderId).toList());
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).logManager();
        TopicPartition x$7 = this.tp_1();
        boolean x$8 = qual$1.getLog$default$2();
        Option leader1log = qual$1.getLog(x$7, x$8);
        FileTierPartitionState tierPartitionState = (FileTierPartitionState)((AbstractLog)leader1log.get()).tierPartitionState();
        MockInMemoryTierObjectStore mockInMemoryTierObjectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokerForId(topic1LeaderId).get()).tierObjectStoreOpt().get();
        String topicId = ((TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get()).topicId().toString();
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$9 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$1(x$9);
            return BoxedUnit.UNIT;
        });
        long l = 500L;
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$2(tierPartitionState)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$3(tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegments1 = new HashSet<UUID>();
        deletedSegments1.addAll(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1log.get()));
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 7), "00000001"), (List)Nil$.MODULE$);
        .colon.colon retentionInfo = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 7, -1, false, false), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState);
        Nil$ blobMetadata = Nil$.MODULE$;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), deletedSegments1.size()).foreach(arg_0 -> BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$4$adapted(this, (List)blobMetadata, arg_0));
        .colon.colon topicMetadata = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), topicId, 0, deletedSegments1, (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadata);
        this.validateBackupObjectsDeletionState(mockInMemoryTierObjectStore, ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo.head()).latestFile(), ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo.head()).date(), backupObjectsState);
        this.checkNonCurrentObjectExistence(deletedSegments1, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        this.changeTopicConfig("retention.ms", "259200000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$10 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$5(x$10);
            return BoxedUnit.UNIT;
        });
        long l3 = 500L;
        long l4 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$6(tierPartitionState)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$7(tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1log.get()));
        HashSet<UUID> deletedSegments2 = new HashSet<UUID>();
        deletedSegments2.addAll(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        deletedSegments2.removeIf(e -> deletedSegments1.contains(e));
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 7), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 6), "00000001"), (List)Nil$.MODULE$));
        .colon.colon retentionInfo2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 7, 3, true, true), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState2 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo2, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo2, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState2);
        ObjectRef blobMetadata2 = ObjectRef.create((Object)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), deletedSegments2.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            blobMetadata2$3.elem = (List)((List)blobMetadata2$3.elem).$colon$plus((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 7L, new DateTime(this.time().milliseconds() + 604800000L).dayOfMonth().get()), List$.MODULE$.canBuildFrom());
        });
        .colon.colon topicMetadata2 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), topicId, 0, deletedSegments2, (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)((List)blobMetadata2.elem)), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState2 = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadata2);
        this.validateBackupObjectsDeletionState(mockInMemoryTierObjectStore, ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo2.head()).latestFile(), ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo2.head()).date(), backupObjectsState2);
        this.checkNonCurrentObjectExistence(deletedSegments2, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        this.changeTopicConfig("retention.ms", "432000000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$11 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$10(x$11);
            return BoxedUnit.UNIT;
        });
        long l5 = 500L;
        long l6 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$11(tierPartitionState)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$12(tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1log.get()));
        HashSet<UUID> deletedSegments3 = new HashSet<UUID>();
        HashSet<UUID> deletedSegmentsOnly3 = new HashSet<UUID>();
        deletedSegments3.addAll(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        deletedSegments3.removeIf(e -> deletedSegments1.contains(e));
        deletedSegmentsOnly3.addAll(deletedSegments3);
        deletedSegmentsOnly3.removeIf(e -> deletedSegments2.contains(e));
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo3 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 6), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 5), "00000001"), (List)Nil$.MODULE$));
        .colon.colon retentionInfo3 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 6, 5, true, true), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState3 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo3, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo3, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState3);
        ObjectRef blobMetadata3 = ObjectRef.create((Object)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), deletedSegments3.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            blobMetadata3$2.elem = (List)((List)blobMetadata3$2.elem).$colon$plus((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 6L, new DateTime(this.time().milliseconds() + 518400000L).dayOfMonth().get()), List$.MODULE$.canBuildFrom());
        });
        .colon.colon topicMetadata3 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), topicId, 0, deletedSegments3, (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)((List)blobMetadata3.elem)), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState3 = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadata3);
        this.validateBackupObjectsDeletionState(mockInMemoryTierObjectStore, ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo3.head()).latestFile(), ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo3.head()).date(), backupObjectsState3);
        this.checkNonCurrentObjectExistence(deletedSegments3, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$12 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$16(x$12);
            return BoxedUnit.UNIT;
        });
        long l7 = 500L;
        long l8 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$17(tierPartitionState)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$18(tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1log.get()));
        HashSet<UUID> deletedSegments4 = new HashSet<UUID>();
        HashSet<UUID> deletedSegmentsOnly4 = new HashSet<UUID>();
        deletedSegments4.addAll(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        deletedSegments4.removeIf(e -> deletedSegments1.contains(e));
        deletedSegmentsOnly4.addAll(deletedSegments4);
        deletedSegmentsOnly4.removeIf(e -> deletedSegments3.contains(e));
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo4 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 5), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 4), "00000001"), (List)Nil$.MODULE$));
        .colon.colon retentionInfo4 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 5, 5, true, true), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState4 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo4, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo4, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState4);
        ObjectRef blobMetadata4 = ObjectRef.create((Object)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), deletedSegments4.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            blobMetadata4$1.elem = (List)((List)blobMetadata4$1.elem).$colon$plus((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 5L, new DateTime(this.time().milliseconds() + 432000000L).dayOfMonth().get()), List$.MODULE$.canBuildFrom());
        });
        .colon.colon topicMetadata4 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), topicId, 0, deletedSegments4, (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)((List)blobMetadata4.elem)), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState4 = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadata4);
        this.validateBackupObjectsDeletionState(mockInMemoryTierObjectStore, ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo4.head()).latestFile(), ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo4.head()).date(), backupObjectsState4);
        this.checkNonCurrentObjectExistence(deletedSegments4, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo5 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 4), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 3), "00000001"), (List)Nil$.MODULE$));
        .colon.colon retentionInfo5 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 5, -1, false, false), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState5 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo5, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo5, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState5);
        this.changeTopicConfig("retention.ms", "691200000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1log.get()).logEndOffset()))})), (Function1 & Serializable & scala.Serializable)x$13 -> {
            BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$22(x$13);
            return BoxedUnit.UNIT;
        });
        long l9 = 500L;
        long l10 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$23(tierPartitionState)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$24(tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegments6 = new HashSet<UUID>();
        deletedSegments6.addAll(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState, TierTestUtils$.MODULE$.deletedSegments$default$2()));
        deletedSegments6.removeIf(e -> deletedSegments1.contains(e) || deletedSegments4.contains(e));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1log.get()));
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo6 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 7), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 4), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 3), "00000001"), (List)Nil$.MODULE$)));
        .colon.colon retentionInfo6 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 7, -1, false, false), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState6 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo6, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo6, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState6);
        ObjectRef blobMetadata6 = ObjectRef.create((Object)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), deletedSegments6.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            blobMetadata6$1.elem = (List)((List)blobMetadata6$1.elem).$colon$plus((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 7L, new DateTime(this.time().milliseconds() + 604800000L).dayOfMonth().get()), List$.MODULE$.canBuildFrom());
        });
        .colon.colon topicMetadata6 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_1().topic(), topicId, 0, deletedSegments6, (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)((List)blobMetadata6.elem)), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState6 = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadata6);
        this.validateBackupObjectsDeletionState(mockInMemoryTierObjectStore, ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo6.head()).latestFile(), ((BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo)latestDataFilesInfo6.head()).date(), backupObjectsState6);
        this.checkNonCurrentObjectExistence(deletedSegments6, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 345600000L);
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo7 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 3), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 2), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 1), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 0), "00000001"), (List)Nil$.MODULE$))));
        .colon.colon retentionInfo7 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 7, -1, false, false), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState7 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo7, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo7, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState7);
        this.checkNonCurrentObjectExistence(deletedSegments1, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
        this.checkNonCurrentObjectExistence(deletedSegments2, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.checkNonCurrentObjectExistence(deletedSegments3, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.checkNonCurrentObjectExistence(deletedSegments4, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo8 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 2), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 1), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 0), "00000001"), (List)Nil$.MODULE$)));
        .colon.colon retentionInfo8 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 7, -1, false, false), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState8 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo8, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo8, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState8);
        this.checkNonCurrentObjectExistence(deletedSegments2, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
        this.checkNonCurrentObjectExistence(deletedSegmentsOnly3, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.checkNonCurrentObjectExistence(deletedSegmentsOnly4, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        .colon.colon latestDataFilesInfo9 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 1), "00000001"), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(this.time().milliseconds(), 0), "00000001"), (List)Nil$.MODULE$));
        .colon.colon retentionInfo9 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 7, -1, false, false), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState9 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo9, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo9, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState9);
        this.checkNonCurrentObjectExistence(deletedSegments3, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
        this.checkNonCurrentObjectExistence(deletedSegmentsOnly4, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
        deletedSegments4.addAll(deletedSegments6);
        this.time().setCurrentTimeMs(this.time().milliseconds() + 86400000L);
        clm.doOneCLMRun();
        Nil$ latestDataFilesInfo10 = Nil$.MODULE$;
        .colon.colon retentionInfo10 = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 7, -1, false, false), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState10 = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfo10, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfo10, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState10);
        this.checkNonCurrentObjectExistence(deletedSegments4, (TopicIdPartition)((AbstractLog)leader1log.get()).topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
    }

    public static final /* synthetic */ void $anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$1(Map x$3) {
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$2(FileTierPartitionState ftps1$1) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps1$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$3() {
        return "Leader1 logs aren't deleted after retention bytes change";
    }

    public static final /* synthetic */ void $anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$4(Map x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$5(FileTierPartitionState ftps2$1) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps2$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testSegmentsToBeDeletedInTheFutureGetsDeleted$6() {
        return "Leader2 logs aren't deleted after retention bytes change";
    }

    public static final /* synthetic */ void $anonfun$testIncreaseInRetention$1(Map x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$testIncreaseInRetention$2(FileTierPartitionState ftps$1) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 9;
    }

    public static final /* synthetic */ String $anonfun$testIncreaseInRetention$3(FileTierPartitionState ftps$1) {
        return new StringBuilder(47).append("Expected deleted segments >= 9, actual deleted ").append(TierTestUtils$.MODULE$.deletedSegments(ftps$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ List $anonfun$testIncreaseInRetention$6(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata2$1, long curTime$1, int i) {
        return (List)blobMetadata2$1.$colon$plus((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata($this, 4L, new DateTime(curTime$1 + 345600000L).dayOfMonth().get()), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testDecreaseInRetention$1(Map x$6) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseInRetention$2(FileTierPartitionState ftps$2) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps$2, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseInRetention$3(FileTierPartitionState ftps$2) {
        return new StringBuilder(47).append("Expected deleted segments >= 1, actual deleted ").append(TierTestUtils$.MODULE$.deletedSegments(ftps$2, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ void $anonfun$testDecreaseInRetention$6(Map x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseInRetention$7(FileTierPartitionState ftps$2) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps$2, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 2;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseInRetention$8(FileTierPartitionState ftps$2) {
        return new StringBuilder(47).append("Expected deleted segments >= 2, actual deleted ").append(TierTestUtils$.MODULE$.deletedSegments(ftps$2, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ List $anonfun$testDecreaseInRetention$11(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata2$2, long curTime$2, int i) {
        return (List)blobMetadata2$2.$colon$plus((Object)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata($this, 4L, new DateTime(curTime$2 + 345600000L).dayOfMonth().get()), (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testDecreaseInRetention$12(Map x$8) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseInRetention$13(FileTierPartitionState ftps$2) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps$2, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 3;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseInRetention$14(FileTierPartitionState ftps$2) {
        return new StringBuilder(47).append("Expected deleted segments >= 3, actual deleted ").append(TierTestUtils$.MODULE$.deletedSegments(ftps$2, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ List $anonfun$testDecreaseInRetention$17(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata3$1, long curTime$2, int i) {
        return (List)blobMetadata3$1.$colon$plus((Object)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata($this, 3L, new DateTime(curTime$2 + 259200000L).dayOfMonth().get()), (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testDecreaseIncreaseRetention$1(Map x$9) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseIncreaseRetention$2(FileTierPartitionState tierPartitionState$1) {
        return TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseIncreaseRetention$3(FileTierPartitionState tierPartitionState$1) {
        return new StringBuilder(47).append("Expected Total deleted  segments > 1, actual = ").append(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ List $anonfun$testDecreaseIncreaseRetention$4(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata$1, int i) {
        return (List)blobMetadata$1.$colon$plus((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata($this, 7L, new DateTime($this.time().milliseconds() + 604800000L).dayOfMonth().get()), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testDecreaseIncreaseRetention$5(Map x$10) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseIncreaseRetention$6(FileTierPartitionState tierPartitionState$1) {
        return TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 2;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseIncreaseRetention$7(FileTierPartitionState tierPartitionState$1) {
        return new StringBuilder(47).append("Expected Total deleted  segments >=2, actual = ").append(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ void $anonfun$testDecreaseIncreaseRetention$10(Map x$11) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseIncreaseRetention$11(FileTierPartitionState tierPartitionState$1) {
        return TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 3;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseIncreaseRetention$12(FileTierPartitionState tierPartitionState$1) {
        return new StringBuilder(47).append("Expected Total deleted  segments > 3, actual = ").append(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ void $anonfun$testDecreaseIncreaseRetention$16(Map x$12) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseIncreaseRetention$17(FileTierPartitionState tierPartitionState$1) {
        return TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 4;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseIncreaseRetention$18(FileTierPartitionState tierPartitionState$1) {
        return new StringBuilder(47).append("Expected Total deleted  segments > 4, actual = ").append(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public static final /* synthetic */ void $anonfun$testDecreaseIncreaseRetention$22(Map x$13) {
    }

    public static final /* synthetic */ boolean $anonfun$testDecreaseIncreaseRetention$23(FileTierPartitionState tierPartitionState$1) {
        return TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size() >= 5;
    }

    public static final /* synthetic */ String $anonfun$testDecreaseIncreaseRetention$24(FileTierPartitionState tierPartitionState$1) {
        return new StringBuilder(48).append("Expected Total deleted  segments >= 5, actual = ").append(TierTestUtils$.MODULE$.deletedSegments(tierPartitionState$1, TierTestUtils$.MODULE$.deletedSegments$default$2()).size()).toString();
    }

    public BackupObjectLifecycleManagerMockTimeTests() {
        this.topic_1 = "topic-1";
        this.topic_2 = "topic-2";
        this.topic_3 = "topic-3";
        this.numPartitions = 1;
    }

    public static final /* synthetic */ List $anonfun$testIncreaseInRetention$6$adapted(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata2$1, long curTime$1, Object i) {
        return BackupObjectLifecycleManagerMockTimeTests.$anonfun$testIncreaseInRetention$6($this, blobMetadata2$1, curTime$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ List $anonfun$testDecreaseInRetention$11$adapted(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata2$2, long curTime$2, Object i) {
        return BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$11($this, blobMetadata2$2, curTime$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ List $anonfun$testDecreaseInRetention$17$adapted(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata3$1, long curTime$2, Object i) {
        return BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseInRetention$17($this, blobMetadata3$1, curTime$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ List $anonfun$testDecreaseIncreaseRetention$4$adapted(BackupObjectLifecycleManagerMockTimeTests $this, List blobMetadata$1, Object i) {
        return BackupObjectLifecycleManagerMockTimeTests.$anonfun$testDecreaseIncreaseRetention$4($this, blobMetadata$1, BoxesRunTime.unboxToInt((Object)i));
    }
}

