/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.management;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.server.BaseRequestTest;
import kafka.server.HostedPartition;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001\u0002\u0010 \u0001!BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005BUBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004J\u0001\u0001\u0006IA\u0010\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u00199\u0006\u0001)A\u0005\u0019\"9\u0001\f\u0001b\u0001\n\u0003I\u0006B\u00022\u0001A\u0003%!\fC\u0003d\u0001\u0011\u0005C\rC\u0004k\u0001\t\u0007I\u0011A6\t\rQ\u0004\u0001\u0015!\u0003m\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!a\u0007\u0001\t\u0003\t\t\u0002C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003Cq!a#\u0001\t\u0003\ti\tC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAg\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\ty\u000f\u0001C\u0005\u0003cDq!a@\u0001\t\u0013\u0011\t\u0001C\u0004\u0003\u0012\u0001!IAa\u0005\u00037QKWM]3e!\u0006\u0014H/\u001b;j_:\u0014VmY8wKJLH+Z:u\u0015\t\u0001\u0013%\u0001\u0006nC:\fw-Z7f]RT!AI\u0012\u0002\tQLWM\u001d\u0006\u0003I\u0015\nQa[1gW\u0006T\u0011AJ\u0001\fS:$Xm\u001a:bi&|gn\u0001\u0001\u0014\u0005\u0001I\u0003C\u0001\u0016/\u001b\u0005Y#B\u0001\u0017.\u0003\u0019\u0019XM\u001d<fe*\tA%\u0003\u00020W\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002?\u0005Y!M]8lKJ\u001cu.\u001e8u+\u00051\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$aA%oi\u0006IAo\u001c9jG:\u000bW.Z\u000b\u0002}A\u0011qH\u0012\b\u0003\u0001\u0012\u0003\"!\u0011\u001d\u000e\u0003\tS!aQ\u0014\u0002\rq\u0012xn\u001c;?\u0013\t)\u0005(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#9\u0003)!x\u000e]5d\u001d\u0006lW\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005a\u0005CA'V\u001b\u0005q%BA(Q\u0003\u0019\u0019w.\\7p]*\u0011A%\u0015\u0006\u0003%N\u000ba!\u00199bG\",'\"\u0001+\u0002\u0007=\u0014x-\u0003\u0002W\u001d\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u000bA\u0014x\u000e]:\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\tU$\u0018\u000e\u001c\u0006\u0002?\u0006!!.\u0019<b\u0013\t\tGL\u0001\u0006Qe>\u0004XM\u001d;jKN\fa\u0001\u001d:paN\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t)\u0007\u000e\u0005\u00028M&\u0011q\r\u000f\u0002\u0005+:LG\u000fC\u0003j\u0013\u0001\u0007!,\u0001\u0006qe>\u0004XM\u001d;jKN\fa!\u001a=ji\u0016$W#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018AB1u_6L7M\u0003\u0002r9\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Mt'!D!u_6L7MQ8pY\u0016\fg.A\u0004fq&$X\r\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0015<\b\"\u0002=\r\u0001\u0004I\u0018\u0001\u0003;fgRLeNZ8\u0011\u0007i\f\u0019!D\u0001|\u0015\taX0A\u0002ba&T!A`@\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011A*\u0002\u000b),h.\u001b;\n\u0007\u0005\u00151P\u0001\u0005UKN$\u0018J\u001c4pQ\ra\u0011\u0011\u0002\t\u0004u\u0006-\u0011bAA\u0007w\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u001a\u0015\u0004\u001b\u0005U\u0001c\u0001>\u0002\u0018%\u0019\u0011\u0011D>\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u00049sKB\f'/\u001a$peR+7\u000f^\u00010i\u0016\u001cHOU3d_Z,'/_!u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:XSRDgj\u001c#bi\u0006\fE\u000fT8dC2dun\u001a\u000b\u0004K\u0006\u0005\u0002BBA\u0012\u001f\u0001\u0007a(\u0001\u0004rk>\u0014X/\u001c\u0015\b\u001f\u0005\u001d\u0012qGA\u001d!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003ci\u0018A\u00029be\u0006l7/\u0003\u0003\u00026\u0005-\"a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0002\u0002<\u0005\u0012\u0011QH\u0001\u0003u.DsaDA!\u0003\u0013\nY\u0005\u0005\u0003\u0002D\u0005\u0015SBAA\u0018\u0013\u0011\t9%a\f\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA'\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001@i\u0016\u001cHOU3d_Z,'/_!u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:XSRDGj\\2bY2+u\nT3tgRC\u0017M\u001c'bgR$\u0016.\u001a:fI>3gm]3u)\r)\u00171\u000b\u0005\u0007\u0003G\u0001\u0002\u0019\u0001 )\u000fA\t9#a\u000e\u0002X1\u0012\u00111\b\u0015\b!\u0005\u0005\u0013\u0011JA&\u0003A\"Xm\u001d;SK\u000e|g/\u001a:z\u0003R,fn\u00197fC:dU-\u00193fe^KG\u000f[!mY\u0012\u000bG/Y!u\u0019>\u001c\u0017\r\u001c'pOR\u0019Q-a\u0018\t\r\u0005\r\u0012\u00031\u0001?Q\u001d\t\u0012qEA\u001c\u0003Gb#!a\u000f)\u000fE\t\t%!\u0013\u0002L\u0005aD/Z:u%\u0016\u001cwN^3ss\u0006#XK\\2mK\u0006tG*Z1eKJ<\u0016\u000e\u001e5M'>{E\u000eZ3s)\"\fgNR5sgR$\u0016.\u001a:fI>3gm]3u)\r)\u00171\u000e\u0005\u0007\u0003G\u0011\u0002\u0019\u0001 )\u000fI\t9#a\u000e\u0002p1\u0012\u00111\b\u0015\b%\u0005\u0005\u0013\u0011JA&\u0003M\"Xm\u001d;SK\u000e|g/\u001a:z\u0003R,fn\u00197fC:dU-\u00193fe^KG\u000f\u001b#jm\u0016\u0014x-\u001a8dK\u0006#Hj\\2bY2{w\rF\u0002f\u0003oBa!a\t\u0014\u0001\u0004q\u0004fB\n\u0002(\u0005]\u00121\u0010\u0017\u0003\u0003wAsaEA!\u0003\u0013\nY%A\u001buKN$(+Z2pm\u0016\u0014\u00180\u0011;V]\u000edW-\u00198MK\u0006$WM],iK:tunU3h[\u0016tG\u000fS1t\u0005\u0016,g\u000eV5fe\u0016$GcA3\u0002\u0004\"1\u00111\u0005\u000bA\u0002yBs\u0001FA\u0014\u0003o\t9\t\f\u0002\u0002<!:A#!\u0011\u0002J\u0005-\u0013!\u0010;fgR\u0014VmY8wKJL\u0018\t^+oG2,\u0017M\u001c'fC\u0012,'OR8s)>\u0004\u0018nY\"sK\u0006$X\rZ,ji\"$\u0016.\u001a:j]\u001e$\u0015n]1cY\u0016$GcA3\u0002\u0010\"1\u00111E\u000bA\u0002yBs!FA\u0014\u0003o\t\u0019\n\f\u0002\u0002<!:Q#!\u0011\u0002J\u0005-\u0013a\u0004;jKJdunZ*fO6,g\u000e^:\u0015\t\u0005m\u0015\u0011\u0018\t\u0007\u0003;\u000b9+!,\u000f\t\u0005}\u00151\u0015\b\u0004\u0003\u0006\u0005\u0016\"A\u001d\n\u0007\u0005\u0015\u0006(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00161\u0016\u0002\u0005\u0019&\u001cHOC\u0002\u0002&b\u0002B!a,\u000266\u0011\u0011\u0011\u0017\u0006\u0004\u0003gk\u0013a\u00017pO&!\u0011qWAY\u00059!\u0016.\u001a:M_\u001e\u001cVmZ7f]RDq!a-\u0017\u0001\u0004\tY\f\u0005\u0003\u00020\u0006u\u0016\u0002BA`\u0003c\u00131\"\u00112tiJ\f7\r\u001e'pO\u0006\u0001E/Z:u%\u0016\u001cwN^3ss\u0006#XK\\2mK\u0006tG*Z1eKJ<\u0016\u000e\u001e5US\u0016\u0014X\r\u001a#bi\u0006\u0014U\u000f\u001e+jKJLgnZ*j]\u000e,G)[:bE2,G\rF\u0002f\u0003\u000bDa!a\t\u0018\u0001\u0004q\u0004fB\f\u0002(\u0005]\u0012\u0011\u001a\u0017\u0003\u0003wAsaFA!\u0003\u0013\nY%A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$R!ZAi\u0003+Da!a5\u0019\u0001\u0004q\u0014aA6fs\"1\u0011q\u001b\rA\u0002y\nQA^1mk\u0016$2!ZAn\u0011\u0015A\u0016\u00041\u0001[\u0003=\u0019'/Z1uKR+7\u000f\u001e+pa&\u001cG\u0003BAq\u0003[\u0004\u0012bNArm\u0005\u001dh'a:\n\u0007\u0005\u0015\bH\u0001\u0004UkBdW\r\u000e\t\u0004U\u0005%\u0018bAAvW\tY1*\u00194lC\n\u0013xn[3s\u0011\u0015A&\u00041\u0001[\u0003m\t\u0007\u000f]3oI6+7o]1hKN\fe\u000e\u001a,fe&4\u0017pU=oGR9Q-a=\u0002x\u0006m\bBBA{7\u0001\u0007a'A\u0006ok6lUm]:bO\u0016\u001c\bBBA}7\u0001\u0007a'\u0001\u0005mK\u0006$WM]%e\u0011\u0019\tip\u0007a\u0001m\u0005Qam\u001c7m_^,'/\u00133\u0002)]\f\u0017\u000e\u001e$pe&\u001b(\u000fV8DQ\u0006tw-\u001a+p)\u0015)'1\u0001B\u0004\u0011\u001d\u0011)\u0001\ba\u0001\u0003O\fa\u0001\\3bI\u0016\u0014\bb\u0002B\u00059\u0001\u0007!1B\u0001\fKb\u0004Xm\u0019;fI&\u001b(\u000f\u0005\u0003@\u0005\u001b1\u0014b\u0001B\b\u0011\n\u00191+\u001a;\u00021]\f\u0017\u000e\u001e$peJ+\u0007\u000f\\5dCR{')\u001a'fC\u0012,'\u000fF\u0003f\u0005+\u00119\u0002C\u0003K;\u0001\u0007A\nC\u0004\u0003\u001au\u0001\r!a:\u0002\u00139,w\u000fT3bI\u0016\u0014\b")
public class TieredPartitionRecoveryTest
extends BaseRequestTest {
    private final String topicName;
    private final TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
    private final Properties props = new Properties();
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 5;
    }

    public String topicName() {
        return this.topicName;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.prepareForTest();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "16384");
        this.props().put("confluent.tier.local.hotset.bytes", "16384");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
        this.props().put("unclean.leader.election.enable", "true");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithNoDataAtLocalLog(String quorum) {
        void var3_3;
        void var4_4;
        void var5_5;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$1(this, (KafkaBroker)var4_4)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numMessages = 26000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$3(this, log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = log.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset(String quorum) {
        void var4_4;
        void var5_5;
        void var3_3;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int numMessages = 1000;
        this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var5_5);
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$1(this, log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long firstTieredOffset = ((TierLogSegment)this.tierLogSegments(log).head()).baseOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)firstTieredOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered segment");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered segment");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered segment");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithAllDataAtLocalLog(String quorum) {
        void var6_6;
        void var4_4;
        void var5_5;
        void var3_3;
        this.props().put("confluent.tier.local.hotset.bytes", "-1");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaBroker replica2 = (KafkaBroker)tuple4._4();
        int numMessages = 10000;
        this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var5_5);
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        long expectedLogStartOffset = log.logStartOffset();
        long expectedLogEndOffset = log.logEndOffset();
        long expectedLocalLogStartOffset = ((AbstractLog)var6_6.replicaManager().getLog(this.topicPartition()).get()).localLogStartOffset();
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Unexpected LogStartOffset after recovery");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.logEndOffset(), (String)"Unexpected LogEndOffset after recovery");
        Assertions.assertEquals((long)expectedLocalLogStartOffset, (long)log_2.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset after recovery");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset after recovery");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset(String quorum) {
        void var18_16;
        void var6_6;
        void var5_5;
        void var3_3;
        void var4_4;
        this.props().put("segment.bytes", "4096");
        this.props().put("confluent.tier.local.hotset.bytes", "40960");
        this.props().put("retention.bytes", "40960");
        this.props().put("file.delete.delay.ms", "100");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaBroker replica2 = (KafkaBroker)tuple4._4();
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        int numMessages = 50;
        while (log.size() < 40960L) {
            this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var5_5);
        }
        long oldLocalLogStartOffsetFollower = ((AbstractLog)var6_6.replicaManager().getLog(this.topicPartition()).get()).localLogStartOffset();
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        this.props().clear();
        this.props().put("confluent.tier.local.hotset.bytes", "20480");
        this.props().put("retention.bytes", "20480");
        this.changeTopicConfig(this.props());
        SortedSet offsetAndSize = (SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        log.localLogSegments().iterator().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)offsetAndSize.add((Object)new Tuple2.mcJI.sp(segment.baseOffset(), segment.size()))));
        this.tierLogSegments(log).iterator().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)offsetAndSize.add((Object)new Tuple2.mcJI.sp(segment.baseOffset(), segment.size()))));
        LongRef newStartOffset = LongRef.create((long)log.logEndOffset());
        Iterator it = offsetAndSize.toList().reverseIterator();
        for (int sizeInBytes = 0; sizeInBytes < 20480 && it.hasNext(); sizeInBytes += var18_16) {
            void var16_15;
            Tuple2 tuple2 = (Tuple2)it.next();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long baseOffset = tuple2._1$mcJ$sp();
            int segmentSize = tuple2._2$mcI$sp();
            newStartOffset.elem = var16_15;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$3(this, log, newStartOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long firstTieredOffset = ((TierLogSegment)this.tierLogSegments(log).head()).baseOffset();
        long expectedLogEndOffset = log.logEndOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$5(firstTieredOffset, log_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$7(log_2, oldLocalLogStartOffsetFollower)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$9(expectedLogEndOffset, log_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$11(firstTieredOffset, log_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$13(log_2, lastTieredOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$14(log_2, lastTieredOffset));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog(String quorum) {
        void var5_5;
        void var4_4;
        void var3_3;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker cfr_ignored_0 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaBroker replica2 = (KafkaBroker)tuple4._4();
        int numMessages = 5000;
        this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var4_4);
        this.killBrokerById((int)var3_3);
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaBroker)var5_5);
        this.restartDeadBrokerById((int)var3_3, this.restartDeadBrokerById$default$2());
        this.waitForIsrToChangeTo((KafkaBroker)var5_5, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3, var4_4}))));
        this.appendMessagesAndVerifySync(numMessages, (int)var4_4, (int)var3_3);
        AbstractLog followerLog = (AbstractLog)this.brokerWithId((int)var3_3).replicaManager().getLog(this.topicPartition()).get();
        Seq editedEpochEntries = (Seq)((LeaderEpochFileCache)followerLog.leaderEpochCache().get()).epochEntries().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends EpochEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                return (B1)new EpochEntry(x1.epoch(), x1.startOffset() + 1L);
            }

            public final boolean isDefinedAt(EpochEntry x1) {
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((LeaderEpochFileCache)followerLog.leaderEpochCache().get()).clearAndFlush();
        editedEpochEntries.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog$1(followerLog, entry);
            return BoxedUnit.UNIT;
        });
        AbstractLog leaderLog = (AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get();
        long expectedLogStartOffset = leaderLog.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(leaderLog).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.waitForIsrToChangeTo((KafkaBroker)var5_5, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var4_4}))));
        this.killBrokerById((int)var4_4);
        this.restartDeadBrokerById((int)var3_3, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var3_3));
        AbstractLog log = (AbstractLog)this.brokerWithId((int)var3_3).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log.logStartOffset(), (String)"Unexpected LogStartOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.logEndOffset(), (String)"Unexpected LogEndOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset after recovery");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWhenNoSegmentHasBeenTiered(String quorum) {
        void var3_3;
        void var4_4;
        void var5_5;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        Predef$.MODULE$.assert(log.logStartOffset() == 0L && log.logEndOffset() == 0L && log.tierPartitionState().numSegments() == 0);
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)0L, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled(String quorum) {
        void var4_4;
        void var5_5;
        void var3_3;
        this.props().put("confluent.tier.enable", "false");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int numMessages = 1000;
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId((int)var5_5).get()).replicaManager().getLog(this.topicPartition()).get();
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$1(log, numMessages, followerLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = followerLog.logStartOffset();
        long expectedLogEndOffset = followerLog.logEndOffset();
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$3(log, numMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered segment");
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered segment");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered segment");
    }

    private List<TierLogSegment> tierLogSegments(AbstractLog log) {
        return log.tieredLogSegments().toList();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled(String quorum) {
        void var3_3;
        void var4_4;
        void var5_5;
        this.props().put("segment.bytes", "4096");
        this.props().put("confluent.tier.local.hotset.bytes", "4096");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$1(this, (KafkaBroker)var4_4)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AbstractLog log1 = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        int numMessages = 100;
        IntRef totalMessages = IntRef.create((int)0);
        while (log1.numberOfSegments() < 4) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages.elem += numMessages;
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$3(log1, totalMessages)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$4(log1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = log1.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log1).last()).endOffset();
        this.changeTopicConfig("confluent.tier.enable", "false");
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$5(log1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long log1LocalLogStartOffset = log1.localLogStartOffset();
        long log1LogEndOffset = log1.logEndOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        KafkaBroker replica2 = (KafkaBroker)this.brokerForId((int)var5_5).get();
        this.waitForReplicaToBeLeader(this.topicPartition(), replica2);
        AbstractLog log2 = (AbstractLog)replica2.replicaManager().getLog(this.topicPartition()).get();
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$7(log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
        long oldSize = log2.size();
        long targetEndOffset = log2.logEndOffset() * 2L;
        while (log2.logEndOffset() < targetEndOffset) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        }
        long retentionBytes = log2.size() - oldSize;
        this.changeTopicConfig("retention.bytes", Long.toString(retentionBytes));
        LongRef size = LongRef.create((long)0L);
        LongRef startOffset = LongRef.create((long)((LogSegment)log2.localLogSegments().toList().last()).baseOffset());
        log2.localLogSegments().toList().reverse().foreach((Function1 & Serializable & scala.Serializable)seg -> {
            TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$9(size, retentionBytes, startOffset, seg);
            return BoxedUnit.UNIT;
        });
        long startOffsetAfterRetention = startOffset.elem;
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$10(log2, startOffsetAfterRetention)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$11(startOffsetAfterRetention, log2));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$12(log2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.killBrokerById((int)var5_5);
        this.restartDeadBrokerById((int)var3_3, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var3_3));
        AbstractLog log3 = (AbstractLog)this.brokerWithId((int)var3_3).replicaManager().getLog(this.topicPartition()).get();
        long l13 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l14 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$14(log1LocalLogStartOffset, log3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$15());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)log1LogEndOffset, (long)log3.logEndOffset(), (String)"Unexpected LogEndOffset");
        Assertions.assertEquals((long)log1LocalLogStartOffset, (long)log3.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset");
        Assertions.assertEquals((long)log1LogEndOffset, (long)log3.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset");
        Predef$.MODULE$.assert(log3.tierPartitionState().numSegments() == 0);
    }

    private void changeTopicConfig(String key, String value) {
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(key, value), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topicName()), Collections.singletonList(alterConfigOp));
        this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()).incrementalAlterConfigs(configs).all().get(5L, TimeUnit.SECONDS);
    }

    private void changeTopicConfig(Properties props) {
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)adminClient, this.topicName(), props, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4());
    }

    private Tuple4<Object, KafkaBroker, Object, KafkaBroker> createTestTopic(Properties props) {
        Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topicName(), 1, 2, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        KafkaBroker leader = (KafkaBroker)this.brokerForId(leaderId).get();
        int followerId = TestUtils$.MODULE$.findFollowerId(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers());
        KafkaBroker follower = (KafkaBroker)this.brokerForId(followerId).get();
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)leaderId), (Object)leader, (Object)BoxesRunTime.boxToInteger((int)followerId), (Object)follower);
    }

    /*
     * WARNING - void declaration
     */
    private void appendMessagesAndVerifySync(int numMessages, int leaderId, int followerId) {
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getLog(this.topicPartition()).get();
        long currentEndOffset = leaderLog.logEndOffset();
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        long l = 50L;
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$appendMessagesAndVerifySync$1(this, leaderLog, currentEndOffset, numMessages, followerLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$appendMessagesAndVerifySync$2(this, leaderLog, followerLog, currentEndOffset, numMessages));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForIsrToChangeTo(KafkaBroker leader, Set<Object> expectedIsr) {
        Partition partition = leader.replicaManager().getPartitionOrException(this.topicPartition());
        long l = 50L;
        long l2 = 150000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForIsrToChangeTo$1(partition, expectedIsr)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForIsrToChangeTo$2(expectedIsr, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForReplicaToBeLeader(TopicPartition topicPartition, KafkaBroker newLeader) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$1(newLeader, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Partition partition = newLeader.replicaManager().getPartitionOrException(topicPartition);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$3(partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$4(partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$1(TieredPartitionRecoveryTest $this, KafkaBroker replica1$1) {
        return !replica1$1.replicaManager().getPartitionOrException($this.topicPartition()).isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$2() {
        return "Waiting for log to be clean";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$3(TieredPartitionRecoveryTest $this, AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1 && $this.tierLogSegments(log$1).size() >= log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$4() {
        return "Timeout waiting for all messages to be written";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$1(TieredPartitionRecoveryTest $this, AbstractLog log$2, int numMessages$2) {
        return log$2.logEndOffset() == (long)(2 * numMessages$2) && $this.tierLogSegments(log$2).size() >= log$2.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$2() {
        return "Timeout waiting for some segments to tier";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$3(TieredPartitionRecoveryTest $this, AbstractLog log$3, LongRef newStartOffset$1) {
        return log$3.logStartOffset() == newStartOffset$1.elem && ((TierLogSegment)$this.tierLogSegments(log$3).head()).baseOffset() == newStartOffset$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$4() {
        return "Timed out waiting for retention to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$5(long firstTieredOffset$1, AbstractLog log_2$1) {
        return firstTieredOffset$1 == log_2$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$6() {
        return "Post recovery, LogStartOffset does not match first tiered offset";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$7(AbstractLog log_2$1, long oldLocalLogStartOffsetFollower$1) {
        return log_2$1.localLogStartOffset() > oldLocalLogStartOffsetFollower$1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$8() {
        return "LocalLogStartOffset has not incremented to match first tiered offset";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$9(long expectedLogEndOffset$1, AbstractLog log_2$1) {
        return expectedLogEndOffset$1 == log_2$1.logEndOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$10() {
        return "Unexpected LogEndOffset after recovery";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$11(long firstTieredOffset$1, AbstractLog log_2$1) {
        return firstTieredOffset$1 == log_2$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$12() {
        return "Unexpected LocalLogStartOffset after recovery";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$13(AbstractLog log_2$1, long lastTieredOffset$1) {
        return log_2$1.localLogEndOffset() >= lastTieredOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$14(AbstractLog log_2$1, long lastTieredOffset$1) {
        return new StringBuilder(72).append("LocalLogEndOffset ").append(log_2$1.localLogEndOffset()).append(" is lesser than the last tiered offset ").append(lastTieredOffset$1).append(" after recovery").toString();
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog$1(AbstractLog followerLog$1, EpochEntry entry) {
        ((LeaderEpochFileCache)followerLog$1.leaderEpochCache().get()).assign(entry.epoch(), entry.startOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$1(AbstractLog log$4, int numMessages$3, AbstractLog followerLog$2) {
        return log$4.logEndOffset() == (long)numMessages$3 && followerLog$2.logEndOffset() == (long)numMessages$3;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$2() {
        return "Timeout waiting for all messages to be written and synced";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$3(AbstractLog log$4, int numMessages$3) {
        return log$4.logEndOffset() == (long)(2 * numMessages$3);
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$4() {
        return "Timeout waiting for all messages to be written";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$1(TieredPartitionRecoveryTest $this, KafkaBroker replica1$2) {
        return !replica1$2.replicaManager().getPartitionOrException($this.topicPartition()).isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$2() {
        return "Waiting for log to be clean";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$3(AbstractLog log1$1, IntRef totalMessages$1) {
        return log1$1.logEndOffset() == (long)totalMessages$1.elem && log1$1.tierPartitionState().numSegments() >= log1$1.numberOfSegments() - 1 && log1$1.localLogStartOffset() > log1$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$4(AbstractLog log1$1) {
        return new StringBuilder(59).append("Timeout waiting for all messages to be written and tiered ").append(log1$1.tierPartitionState().numSegments()).append(" ").append(log1$1.numberOfSegments()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$5(AbstractLog log1$1) {
        return !log1$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$6() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$7(AbstractLog log2$1) {
        return !log2$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$8() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$9(LongRef size$1, long retentionBytes$1, LongRef startOffset$1, LogSegment seg) {
        if (size$1.elem < retentionBytes$1) {
            size$1.elem += (long)seg.size();
            startOffset$1.elem = seg.baseOffset();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$10(AbstractLog log2$1, long startOffsetAfterRetention$1) {
        return log2$1.logStartOffset() == startOffsetAfterRetention$1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$11(long startOffsetAfterRetention$1, AbstractLog log2$1) {
        return new StringBuilder(67).append("Timed out waiting for logStartOffset to change (expected: ").append(startOffsetAfterRetention$1).append(" actual: ").append(log2$1.logStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$12(AbstractLog log2$1) {
        return log2$1.tierPartitionState().numSegments() == 0;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$13() {
        return "Timed out waiting for tiered segments to delete";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$14(long log1LocalLogStartOffset$1, AbstractLog log3$1) {
        return log1LocalLogStartOffset$1 == log3$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$15() {
        return "Unexpected LogStartOffset";
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndVerifySync$1(TieredPartitionRecoveryTest $this, AbstractLog leaderLog$1, long currentEndOffset$1, int numMessages$4, AbstractLog followerLog$3) {
        return leaderLog$1.logEndOffset() >= currentEndOffset$1 + (long)numMessages$4 && leaderLog$1.logEndOffset() == followerLog$3.logEndOffset() && $this.tierLogSegments(leaderLog$1).size() >= leaderLog$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndVerifySync$2(TieredPartitionRecoveryTest $this, AbstractLog leaderLog$1, AbstractLog followerLog$3, long currentEndOffset$1, int numMessages$4) {
        return new StringBuilder(180).append("Timeout waiting for all messages to be written, synced and tiered.").append(" Leader logEndOffset ").append(leaderLog$1.logEndOffset()).append(" Follower logEndOffset ").append(followerLog$3.logEndOffset()).append(" Expected logEndOffset ").append(currentEndOffset$1 + (long)numMessages$4).append(" Tiered Segments ").append($this.tierLogSegments(leaderLog$1).size()).append(" Expected min tiered segments ").append(leaderLog$1.numberOfSegments() - 1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForIsrToChangeTo$1(Partition partition$1, Set expectedIsr$1) {
        return partition$1.inSyncReplicaIds().equals((Object)expectedIsr$1);
    }

    public static final /* synthetic */ String $anonfun$waitForIsrToChangeTo$2(Set expectedIsr$1, Partition partition$1) {
        return new StringBuilder(51).append("Timeout waiting for ISR to change to ").append(expectedIsr$1).append(". Current Isr ").append(partition$1.inSyncReplicaIds()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToBeLeader$1(KafkaBroker newLeader$1, TopicPartition topicPartition$1) {
        HostedPartition hostedPartition = newLeader$1.replicaManager().getPartition(topicPartition$1);
        HostedPartition.None$ none$ = HostedPartition.None$.MODULE$;
        return hostedPartition == null ? none$ != null : !hostedPartition.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToBeLeader$2() {
        return "Timed out waiting for partition object at new leader";
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToBeLeader$3(Partition partition$2) {
        return partition$2.isLeader() && !partition$2.isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToBeLeader$4(Partition partition$2) {
        return new StringBuilder(102).append("Timed out waiting for leader to change and log to be recovered, if needed. isLeader=").append(partition$2.isLeader()).append(", isUncleanLeader=").append(partition$2.isUncleanLeader()).toString();
    }

    public TieredPartitionRecoveryTest() {
        this.topicName = "tiered-topic";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.exited = new AtomicBoolean(false);
    }
}

