/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.Exit$;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001\u0002$H\u00011CQ!\u0017\u0001\u0005\u0002iCq!\u0018\u0001A\u0002\u0013\u0005a\fC\u0004q\u0001\u0001\u0007I\u0011A9\t\ra\u0004\u0001\u0015)\u0003`\u0011\u001dI\bA1A\u0005\niDq!!\u0006\u0001A\u0003%1\u0010C\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003\u0002\u001a!A\u00111\u0006\u0001!\u0002\u0013\tY\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u00111\t\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H!A\u0011q\n\u0001!\u0002\u0013\tI\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002H!A\u00111\u000b\u0001!\u0002\u0013\tI\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002X!A\u0011Q\r\u0001!\u0002\u0013\tI\u0006C\u0005\u0002h\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011Q\u000e\u0001!\u0002\u0013\tY\u0007C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011Q\u000f\u0001!\u0002\u0013\tY\u0007C\u0005\u0002x\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011\u0011\u0010\u0001!\u0002\u0013\tY\u0007C\u0005\u0002|\u0001\u0011\r\u0011\"\u0003\u0002j!A\u0011Q\u0010\u0001!\u0002\u0013\tY\u0007C\u0005\u0002\u0000\u0001\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011Q\u0014\u0001!\u0002\u0013\t\u0019\tC\u0005\u0002 \u0002\u0011\r\u0011\"\u0003\u0002\"\"A\u0011\u0011\u0018\u0001!\u0002\u0013\t\u0019\u000bC\u0004\u0002<\u0002!I!!0\t\u0013\u0005M\u0007!%A\u0005\n\u0005U\u0007\"CAv\u0001\t\u0007I\u0011BAw\u0011!\ty\u000f\u0001Q\u0001\n\u0005}\u0006\"CAy\u0001\t\u0007I\u0011BAz\u0011!\tY\u0010\u0001Q\u0001\n\u0005U\bbCA\u007f\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007fD1B!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0010!Y!1\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u0001\u0011-\u0011)\u0002\u0001a\u0001\u0002\u0004%IAa\u0006\t\u0017\te\u0001\u00011AA\u0002\u0013%!1\u0004\u0005\f\u0005?\u0001\u0001\u0019!A!B\u0013\t9\nC\u0006\u0003\"\u0001\u0001\r\u00111A\u0005\n\t]\u0001b\u0003B\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0005KA1B!\u000b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0018\"9!1\u0006\u0001\u0005B\t5\u0002b\u0002B(\u0001\u0011\u0005#\u0011\u000b\u0005\b\u00057\u0002A\u0011\u0001B)\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005#BqA!\u001b\u0001\t\u0013\u0011Y\u0007C\u0005\u0003\u0004\u0002\t\n\u0011\"\u0003\u0003\u0006\"9!\u0011\u0012\u0001\u0005\n\t-\u0005b\u0002BJ\u0001\u0011%!Q\u0013\u0005\b\u00057\u0003A\u0011\u0002BO\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005#BqAa-\u0001\t\u0003\u0011\t\u0006C\u0004\u00038\u0002!\tA!\u0015\t\u000f\tm\u0006\u0001\"\u0003\u0003>\"9!\u0011\u0019\u0001\u0005\u0002\tE\u0003b\u0002Bc\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0005\u0013\u0004A\u0011\u0002Bf\u0011\u001d\u0011y\r\u0001C\u0001\u0005#BqAa5\u0001\t\u0003\u0011\t\u0006C\u0004\u0003X\u0002!\tA!\u0015\t\u000f\tm\u0007\u0001\"\u0003\u0003^\"9!Q\u001d\u0001\u0005\n\t\u001d\b\"CB\u0004\u0001E\u0005I\u0011BB\u0005\u0011\u001d\u0019i\u0001\u0001C\u0005\u0007\u001fAqaa\u0005\u0001\t\u0013\u0019)B\u0001\bBG2\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005!K\u0015!B1e[&t'\"\u0001&\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!T*\u0011\u00059\u000bV\"A(\u000b\u0005AK\u0015AB:feZ,'/\u0003\u0002S\u001f\n\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0011\u0005Q;V\"A+\u000b\u0005YK\u0015!B;uS2\u001c\u0018B\u0001-V\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A.\u0011\u0005q\u0003Q\"A$\u0002\u000fM,'O^3sgV\tq\fE\u0002aU6t!!Y4\u000f\u0005\t,W\"A2\u000b\u0005\u0011\\\u0015A\u0002\u001fs_>$h(C\u0001g\u0003\u0015\u00198-\u00197b\u0013\tA\u0017.A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0019L!a\u001b7\u0003\u0007M+\u0017O\u0003\u0002iSB\u0011aJ\\\u0005\u0003_>\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t\u0011h\u000f\u0005\u0002ti6\t\u0011.\u0003\u0002vS\n!QK\\5u\u0011\u001d98!!AA\u0002}\u000b1\u0001\u001f\u00132\u0003!\u0019XM\u001d<feN\u0004\u0013!\u00039sS:\u001c\u0017\u000e]1m+\u0005Y\bc\u0001?\u0002\u00125\tQP\u0003\u0002\u007f\u007f\u0006!\u0011-\u001e;i\u0015\u0011\t\t!a\u0001\u0002\u0011M,7-\u001e:jifTA!!\u0002\u0002\b\u000511m\\7n_:T1ASA\u0005\u0015\u0011\tY!!\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ty!A\u0002pe\u001eL1!a\u0005~\u00059Y\u0015MZ6b!JLgnY5qC2\f!\u0002\u001d:j]\u000eL\u0007/\u00197!\u0003\u0015)6/\u001a:t+\t\tY\u0002E\u0003\u0002\u001e\u0005\u001d20\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003%IW.\\;uC\ndWMC\u0002\u0002&%\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0007M+G/\u0001\u0004Vg\u0016\u00148\u000fI\u0001\u0006\u0011>\u001cHo]\u000b\u0003\u0003c\u0001b!!\b\u0002(\u0005M\u0002\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0005Y\u0006twM\u0003\u0002\u0002>\u0005!!.\u0019<b\u0013\u0011\t\t%a\u000e\u0003\rM#(/\u001b8h\u0003\u0019Aun\u001d;tA\u0005\u0001\u0012\t\u001c7po\"{7\u000f^\"p[6\fg\u000eZ\u000b\u0003\u0003\u0013\u0002Ra]A&\u0003gI1!!\u0014j\u0005\u0015\t%O]1z\u0003E\tE\u000e\\8x\u0011>\u001cHoQ8n[\u0006tG\rI\u0001\u0010\t\u0016t\u0017\u0010S8ti\u000e{W.\\1oI\u0006\u0001B)\u001a8z\u0011>\u001cHoQ8n[\u0006tG\rI\u0001\u0010\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dKV\u0011\u0011\u0011\f\t\u0005\u00037\n\t'\u0004\u0002\u0002^)!\u0011qLA\u0002\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA2\u0003;\u0012qBU3t_V\u00148-\u001a)biR,'O\\\u0001\u0011\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0002\na\u0002V8qS\u000e\u0014Vm]8ve\u000e,7/\u0006\u0002\u0002lA1\u0011QDA\u0014\u00033\nq\u0002V8qS\u000e\u0014Vm]8ve\u000e,7\u000fI\u0001\u000f\u000fJ|W\u000f\u001d*fg>,(oY3t\u0003=9%o\\;q%\u0016\u001cx.\u001e:dKN\u0004\u0013\u0001\u0007+sC:\u001c\u0018m\u0019;j_:\fG.\u00133SKN|WO]2fg\u0006IBK]1og\u0006\u001cG/[8oC2LEMU3t_V\u00148-Z:!\u00039!vn[3o%\u0016\u001cx.\u001e:dKN\fq\u0002V8lK:\u0014Vm]8ve\u000e,7\u000fI\u0001\u000e+N,'OU3t_V\u00148-Z:\u0002\u001dU\u001bXM\u001d*fg>,(oY3tA\u0005\t\"+Z:pkJ\u001cW\rV8D_6l\u0017M\u001c3\u0016\u0005\u0005\r\u0005\u0003CA\u000f\u0003\u000b\u000bI)a&\n\t\u0005\u001d\u0015q\u0004\u0002\u0004\u001b\u0006\u0004\bCBAF\u0003'\u000bIF\u0004\u0003\u0002\u000e\u0006=\u0005C\u00012j\u0013\r\t\t*[\u0001\u0007!J,G-\u001a4\n\t\u0005%\u0012Q\u0013\u0006\u0004\u0003#K\u0007#B:\u0002L\u0005e\u0005\u0003BAF\u00037KA!!\u0011\u0002\u0016\u0006\u0011\"+Z:pkJ\u001cW\rV8D_6l\u0017M\u001c3!\u0003Q\u0011Vm]8ve\u000e,Gk\\(qKJ\fG/[8ogV\u0011\u00111\u0015\t\t\u0003;\t))!#\u0002&B91/a*\u0002,\u0006]\u0015bAAUS\n1A+\u001e9mKJ\u0002b!a#\u0002\u0014\u00065\u0006\u0003BAX\u0003kk!!!-\u000b\t\u0005M\u00161A\u0001\u0004C\u000ed\u0017\u0002BA\\\u0003c\u0013A\"Q2m\u001fB,'/\u0019;j_:\fQCU3t_V\u00148-\u001a+p\u001fB,'/\u0019;j_:\u001c\b%\u0001\fQe>$WoY3s%\u0016\u001cx.\u001e:dKR{\u0017i\u00197t)\u0011\ty,!3\u0011\u0011\u0005u\u0011QQAE\u0003\u0003\u0004b!a#\u0002\u0014\u0006\r\u0007\u0003BAX\u0003\u000bLA!a2\u00022\n\u0011\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\u0011%\tYm\bI\u0001\u0002\u0004\ti-A\tf]\u0006\u0014G.Z%eK6\u0004x\u000e^3oG\u0016\u00042a]Ah\u0013\r\t\t.\u001b\u0002\b\u0005>|G.Z1o\u0003\u0001\u0002&o\u001c3vG\u0016\u0014(+Z:pkJ\u001cW\rV8BG2\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]'\u0006BAg\u00033\\#!a7\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003KL\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011^Ap\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017\u0007>t7/^7feJ+7o\\;sG\u0016$v.Q2mgV\u0011\u0011qX\u0001\u0018\u0007>t7/^7feJ+7o\\;sG\u0016$v.Q2mg\u0002\n1cQ7e)>\u0014Vm]8ve\u000e,7\u000fV8BG2,\"!!>\u0011\u0011\u0005u\u0011QQAL\u0003o\u0004\u0002\"a#\u0002z\u0006%\u0015\u0011Y\u0005\u0005\u0003\u000f\u000b)*\u0001\u000bD[\u0012$vNU3t_V\u00148-Z:U_\u0006\u001bG\u000eI\u0001\fEJ|7.\u001a:Qe>\u00048/\u0006\u0002\u0003\u0002A!!1\u0001B\u0005\u001b\t\u0011)A\u0003\u0003\u0003\b\u0005m\u0012\u0001B;uS2LAAa\u0003\u0003\u0006\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u001f\t\u0014xn[3s!J|\u0007o]0%KF$2A\u001dB\t\u0011!9h%!AA\u0002\t\u0005\u0011\u0001\u00042s_.,'\u000f\u0015:paN\u0004\u0013A\u0002>l\u0003J<7/\u0006\u0002\u0002\u0018\u0006Q!p[!sON|F%Z9\u0015\u0007I\u0014i\u0002\u0003\u0005xS\u0005\u0005\t\u0019AAL\u0003\u001dQ8.\u0011:hg\u0002\n\u0011\"\u00193nS:\f%oZ:\u0002\u001b\u0005$W.\u001b8Be\u001e\u001cx\fJ3r)\r\u0011(q\u0005\u0005\to2\n\t\u00111\u0001\u0002\u0018\u0006Q\u0011\rZ7j]\u0006\u0013xm\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0007I\u0014y\u0003C\u0004\u000329\u0002\rAa\r\u0002\u0011Q,7\u000f^%oM>\u0004BA!\u000e\u0003D5\u0011!q\u0007\u0006\u0005\u0005s\u0011Y$A\u0002ba&TAA!\u0010\u0003@\u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B!\u0003\u001b\tQA[;oSRLAA!\u0012\u00038\tAA+Z:u\u0013:4w\u000eK\u0002/\u0005\u0013\u0002BA!\u000e\u0003L%!!Q\nB\u001c\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\t!\u000fK\u00020\u0005+\u0002BA!\u000e\u0003X%!!\u0011\fB\u001c\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\ruKN$\u0018i\u00197DY&<\u0016\u000e\u001e5BkRDwN]5{KJD3\u0001\rB0!\u0011\u0011)D!\u0019\n\t\t\r$q\u0007\u0002\u0005)\u0016\u001cH/\u0001\fuKN$\u0018i\u00197DY&<\u0016\u000e\u001e5BI6Lg.\u0011)JQ\r\t$qL\u0001\rGJ,\u0017\r^3TKJ4XM\u001d\u000b\u0004e\n5\u0004\"\u0003B8eA\u0005\t\u0019\u0001B9\u00035\u0019w.\\7b]\u0012\u001cuN\u001c4jOB)1Oa\u001d\u0003x%\u0019!QO5\u0003\r=\u0003H/[8o!\u0011\u0011IHa \u000e\u0005\tm$\u0002\u0002B?\u0003w\t!![8\n\t\t\u0005%1\u0010\u0002\u0005\r&dW-\u0001\fde\u0016\fG/Z*feZ,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119I\u000b\u0003\u0003r\u0005e\u0017\u0001C2bY2l\u0015-\u001b8\u0015\t\t5%q\u0012\t\bg\u0006\u001d\u0016\u0011TAM\u0011\u001d\u0011\t\n\u000ea\u0001\u0003/\u000bA!\u0019:hg\u0006QA/Z:u\u0003\u000ed7\t\\5\u0015\u0007I\u00149\nC\u0004\u0003\u001aV\u0002\r!a&\u0002\u000f\rlG-\u0011:hg\u0006!\u0012m]:feR|U\u000f\u001e9vi\u000e{g\u000e^1j]N$\u0012B\u001dBP\u0005G\u00139Ka+\t\u000f\t\u0005f\u00071\u0001\u0002\u001a\u00061\u0001O]3gSbDqA!*7\u0001\u0004\tI)A\u0005sKN|WO]2fg\"9!\u0011\u0016\u001cA\u0002\u0005]\u0015a\u0003:fg>,(oY3D[\u0012DqA!,7\u0001\u0004\tI*\u0001\u0004pkR\u0004X\u000f^\u0001&i\u0016\u001cH\u000f\u0015:pIV\u001cWM]\"p]N,X.\u001a:DY&<\u0016\u000e\u001e5BkRDwN]5{KJD3a\u000eB0\u0003\r\"Xm\u001d;Qe>$WoY3s\u0007>t7/^7fe\u000ec\u0017nV5uQ\u0006#W.\u001b8B!&C3\u0001\u000fB0\u0003Y!Xm\u001d;BG2\u001cE.[,ji\"\u001cE.[3oi&#\u0007fA\u001d\u0003`\u00059B/Z:u!J|G-^2fe\u000e{gn];nKJ\u001cE.\u001b\u000b\u0004e\n}\u0006b\u0002BMu\u0001\u0007\u0011qS\u0001*i\u0016\u001cH/Q2mg>s\u0007K]3gSb,GMU3t_V\u00148-Z:XSRD\u0017)\u001e;i_JL'0\u001a:)\u0007m\u0012y&A\u0014uKN$\u0018i\u00197t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cWm],ji\"\fE-\\5o\u0003BK\u0005f\u0001\u001f\u0003`\u0005YB/Z:u\u0003\u000ed7o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dKN$2A\u001dBg\u0011\u001d\u0011I*\u0010a\u0001\u0003/\u000bQ\u0004^3ti&sg/\u00197jI\u0006+H\u000f[8sSj,'\u000f\u0015:pa\u0016\u0014H/\u001f\u0015\u0004}\t}\u0013\u0001\u0005;fgR\u0004\u0016\r\u001e;fe:$\u0016\u0010]3tQ\ry$qL\u0001\u0014i\u0016\u001cHo\u00117vgR,'\u000fT5oW\u0006\u001bGn\u001d\u0015\u0004\u0001\n}\u0013A\u0003;fgR\u0014V-\\8wKR9!Oa8\u0003b\n\r\bb\u0002BM\u0003\u0002\u0007\u0011q\u0013\u0005\b\u0005K\u000b\u0005\u0019AAE\u0011\u001d\u0011I+\u0011a\u0001\u0003/\u000bqbZ3u\u0003\u000edGk\\\"p[6\fg\u000e\u001a\u000b\t\u0005S\u0014YO!>\u0003zB91/a*\u0002B\u0006]\u0005b\u0002Bw\u0005\u0002\u0007!q^\u0001\u000fa\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\tyK!=\n\t\tM\u0018\u0011\u0017\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007b\u0002B|\u0005\u0002\u0007\u00111V\u0001\u000b_B,'/\u0019;j_:\u001c\b\"\u0003B~\u0005B\u0005\t\u0019\u0001B\u007f\u0003\u001da\u0017N\\6JIN\u0004b!a#\u0002\u0014\n}\b\u0003BB\u0001\u0007\u0007i!!a\u0001\n\t\r\u0015\u00111\u0001\u0002\u0005+VLG-A\rhKR\f5\r\u001c+p\u0007>lW.\u00198eI\u0011,g-Y;mi\u0012\u001aTCAB\u0006U\u0011\u0011i0!7\u0002\r\u001d,GoQ7e)\u0011\t9j!\u0005\t\u000f\t5H\t1\u0001\u0003p\u0006qq/\u001b;i\u0003V$\bn\u001c:ju\u0016\u0014HCAB\f)\r\u00118\u0011\u0004\u0005\b\u00077)\u0005\u0019AB\u000f\u0003\u00051\u0007CB:\u0004 \r\r\"/C\u0002\u0004\"%\u0014\u0011BR;oGRLwN\\\u0019\u0011\t\r\u00152QF\u0007\u0003\u0007OQAa!\u000b\u0004,\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0007A\u000b9!\u0003\u0003\u00040\r\u001d\"AC!vi\"|'/\u001b>fe\u0002")
public class AclCommandTest
extends QuorumTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final Set<KafkaPrincipal> Users = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final Set<String> Hosts = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = (String[])((Object[])new String[]{"--allow-host", "host1", "--allow-host", "host2"});
    private final String[] DenyHostCommand = (String[])((Object[])new String[]{"--deny-host", "host1", "--deny-host", "host2"});
    private final ResourcePattern ClusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final Set<ResourcePattern> TopicResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> GroupResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TransactionalIdResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TokenResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> UserResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.USER, "User:test-user1", PatternType.LITERAL), new ResourcePattern(ResourceType.USER, "User:test-user2", PatternType.LITERAL)}));
    private final Map<Set<ResourcePattern>, String[]> ResourceToCommand = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new String[]{"--topic", "test-1", "--topic", "test-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new String[]{"--cluster"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new String[]{"--group", "testGroup-1", "--group", "testGroup-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new String[]{"--transactional-id", "t0", "--transactional-id", "t1"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new String[]{"--delegation-token", "token1", "--delegation-token", "token2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.UserResources()), (Object)new String[]{"--user-principal", "User:test-user1", "--user-principal", "User:test-user2"})}));
    private final Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "Alter"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite", "--operation", "Alter", "--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE})), (Object)new String[]{"--operation", "Read", "--operation", "Describe", "--operation", "Delete"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.UserResources()), (Object)new Tuple2((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS})), (Object)new String[]{"--operation", "CreateTokens", "--operation", "DescribeTokens"}))}));
    private final Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5()))}));
    private final Map<String[], Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"}), this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"}), this.ProducerResourceToAcls(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"}), this.ConsumerResourceToAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Set k = (Set)x0$1._1();
        Set v = (Set)x0$1._2();
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1()).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple2;
    }, Map$.MODULE$.canBuildFrom())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"}), this.ConsumerResourceToAcls().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        Set k = (Set)x0$2._1();
        Set v = (Set)x0$2._2();
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((GenTraversableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple2;
    }, Map$.MODULE$.canBuildFrom()))}));
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private ResourcePattern ClusterResource() {
        return this.ClusterResource;
    }

    private Set<ResourcePattern> TopicResources() {
        return this.TopicResources;
    }

    private Set<ResourcePattern> GroupResources() {
        return this.GroupResources;
    }

    private Set<ResourcePattern> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private Set<ResourcePattern> TokenResources() {
        return this.TokenResources;
    }

    private Set<ResourcePattern> UserResources() {
        return this.UserResources;
    }

    private Map<Set<ResourcePattern>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    private Map<Set<ResourcePattern>, Set<AccessControlEntry>> ProducerResourceToAcls(boolean enableIdempotence) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)AclOperation.IDEMPOTENT_WRITE) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5()))}));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private Map<String[], Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.brokerProps().put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        this.brokerProps().put(AclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq((String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()}));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testAclCli(this.adminArgs());
    }

    private void createServer(Option<File> commandConfig) {
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(this.brokerProps()), TestUtils$.MODULE$.createServer$default$2()), (List)Nil$.MODULE$));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        String[] adminArgs = (String[])((Object[])new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)});
        if (commandConfig.isDefined()) {
            adminArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])adminArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--command-config", ((File)commandConfig.get()).getAbsolutePath()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        this.adminArgs_$eq(adminArgs);
    }

    private Option<File> createServer$default$1() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<String, String> callMain(String[] args) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AclCommand$.MODULE$.main(args);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            void grabConsoleOutputAndError_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)grabConsoleOutputAndError_out.toString(), (Object)grabConsoleOutputAndError_err.toString());
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$4);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputContains(String prefix, Set<ResourcePattern> resources, String[] resourceCmd, String output) {
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$assertOutputContains$1(this, resourceCmd, prefix, output, resource);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testProducerConsumerCli(this.adminArgs());
    }

    @Test
    public void testAclCliWithClientId() {
        File adminClientConfig = TestUtils$.MODULE$.tempFile();
        PrintWriter pw = new PrintWriter(adminClientConfig);
        pw.println("client.id=my-client");
        pw.close();
        this.createServer((Option<File>)new Some((Object)adminClientConfig));
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, Level.WARN);
        try {
            this.testAclCli(this.adminArgs());
        }
        finally {
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, previousLevel);
            LogCaptureAppender$.MODULE$.unregister(appender);
        }
        Assertions.assertFalse((boolean)appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCliWithClientId$1(e))).isDefined(), (String)"There should be no warnings about multiple registration of mbeans");
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$9);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer(this.createServer$default$1());
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        String[] cmd = (String[])((Object[])new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"});
        this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, (Authorizer)aclAuthorizer);
        }
        this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        KafkaConfig withAuthorizer_kafkaConfig2 = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig2.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2((Authorizer)withAuthorizer_authZ);
        }
    }

    @Test
    public void testInvalidAuthorizerProperty() {
        String[] args = (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()});
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(AclAuthorizer.class.getName(), new AclCommand.AclCommandOptions(args));
        Assertions.assertThrows(IllegalArgumentException.class, () -> aclCommandService.listAcls());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPatternTypes() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$10) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$10);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PatternType.values())).foreach((Function1 & Serializable & scala.Serializable)patternType -> {
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testClusterLinkAcls() {
        this.createServer(this.createServer$default$1());
        String[] cmdArgs = this.adminArgs();
        Uuid link1 = Uuid.randomUuid();
        Uuid link2 = Uuid.randomUuid();
        Uuid local = Uuid.ZERO_UUID;
        Set<ResourcePattern> link1Resources = this.TopicResources();
        Set<ResourcePattern> link2Resources = this.GroupResources();
        Set multiLinkResources = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}));
        Map linkIdMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(link1Resources), (Object)new .colon.colon((Object)link1, (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(link2Resources), (Object)new .colon.colon((Object)link2, (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)multiLinkResources), (Object)new .colon.colon((Object)link1, (List)new .colon.colon((Object)link2, (List)new .colon.colon((Object)local, (List)Nil$.MODULE$))))}));
        linkIdMap.keySet().foreach((Function1 & Serializable & scala.Serializable)resources -> {
            AclCommandTest.$anonfun$testClusterLinkAcls$1(this, linkIdMap, cmdArgs, local, resources);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void testRemove(String[] cmdArgs, Set<ResourcePattern> resources, String[] resourceCmd) {
        void var6_6;
        void var5_5;
        Tuple2<String, String> tuple2 = this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--remove", ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String out = (String)tuple2._1();
        String err = (String)tuple2._2();
        void out2 = var5_5;
        void err2 = var6_6;
        Assertions.assertEquals((Object)"", (Object)out2);
        Assertions.assertEquals((Object)"", (Object)err2);
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Set<AccessControlEntry>, String[]> getAclToCommand(AclPermissionType permissionType, Set<AclOperation> operations, Set<Uuid> linkIds) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts(), linkIds), (Object)this.getCmd(permissionType));
    }

    private Set<Uuid> getAclToCommand$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private String[] getCmd(AclPermissionType permissionType) {
        AclPermissionType aclPermissionType = permissionType;
        AclPermissionType aclPermissionType2 = AclPermissionType.ALLOW;
        String principalCmd = !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null) ? "--allow-principal" : "--deny-principal";
        AclPermissionType aclPermissionType3 = permissionType;
        AclPermissionType aclPermissionType4 = AclPermissionType.ALLOW;
        String[] cmd2 = !(aclPermissionType3 != null ? !aclPermissionType3.equals(aclPermissionType4) : aclPermissionType4 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable & scala.Serializable)(cmd, user) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{principalCmd, user.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps(), false);
        try (AclAuthorizer authZ = new AclAuthorizer();){
            authZ.configure(kafkaConfig.originals());
            f.apply((Object)authZ);
        }
    }

    public static final /* synthetic */ void $anonfun$testAclCli$4(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, Set resources$1, String[] cmdArgs$1, String[] resourceCmd$1, AclPermissionType permissionType) {
        void var18_18;
        void var17_17;
        void var13_13;
        void var12_12;
        void var8_8;
        void var7_7;
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(permissionType, (Set<AclOperation>)((Set)operationToCmd._1()), $this.getAclToCommand$default$3());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        void acls2 = var7_7;
        void cmd2 = var8_8;
        Tuple2<String, String> tuple22 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operationToCmd._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String addOut = (String)tuple22._1();
        String addErr = (String)tuple22._2();
        void addOut2 = var12_12;
        void addErr2 = var13_13;
        $this.assertOutputContains("Adding ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)addOut2);
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)addOut2);
        Assertions.assertEquals((Object)"", (Object)addErr2);
        resources$1.foreach(arg_0 -> AclCommandTest.$anonfun$testAclCli$4$adapted($this, (Set)acls2, arg_0));
        Tuple2<String, String> tuple23 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1)).$colon$plus((Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String listOut = (String)tuple23._1();
        String listErr = (String)tuple23._2();
        void listOut2 = var17_17;
        void listErr2 = var18_18;
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)listOut2);
        Assertions.assertEquals((Object)"", (Object)listErr2);
        $this.testRemove(cmdArgs$1, (Set<ResourcePattern>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$4) {
        if (x$4 != null) {
            Set resources = (Set)x$4._1();
            String[] resourceCmd = (String[])x$4._2();
            ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclPermissionType[]{AclPermissionType.ALLOW, AclPermissionType.DENY}))).foreach((Function1 & Serializable & scala.Serializable)permissionType -> {
                AclCommandTest.$anonfun$testAclCli$3($this, resources, cmdArgs$1, resourceCmd, permissionType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$assertOutputContains$2(String x$5) {
        return !x$5.startsWith("--");
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$3(String prefix$1, String resourceType$1, String output$1, String name) {
        String expected = new StringBuilder(75).append(prefix$1).append(" for resource `ResourcePattern(resourceType=").append(resourceType$1).append(", name=").append(name).append(", patternType=LITERAL)`:").toString();
        Assertions.assertTrue((boolean)output$1.contains(expected), (String)new StringBuilder(26).append("Substring ").append(expected).append(" not in output:\n").append(output$1).toString());
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$1(AclCommandTest $this, String[] resourceCmd$2, String prefix$1, String output$1, ResourcePattern resource) {
        String resourceType = resource.resourceType().toString();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(resource.equals($this.ClusterResource()) ? (Object[])new String[]{"kafka-cluster"} : (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$assertOutputContains$2(x$5))))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            AclCommandTest.$anonfun$assertOutputContains$3(prefix$1, resourceType, output$1, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAclCliWithClientId$1(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        if (!(level != null ? !level.equals(level2) : level2 != null) && e.getThrowableInformation() != null) {
            String string = e.getThrowableInformation().getThrowable().getClass().getName();
            String string2 = InstanceAlreadyExistsException.class.getName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$6(AclCommandTest $this, Set acls$2, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$8) {
        if (x$8 != null) {
            Set resources = (Set)x$8._1();
            Set acls = (Set)x$8._2();
            resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$6($this, acls, resource);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$2, Tuple2 x$9) {
        if (x$9 != null) {
            String[] cmd = (String[])x$9._1();
            Map resourcesToAcls = (Map)x$9._2();
            String[] resourceCommand = (String[])((TraversableOnce)resourcesToAcls.keys().map($this.ResourceToCommand(), Iterable$.MODULE$.canBuildFrom())).foldLeft(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.getCmd(AclPermissionType.ALLOW))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
            resourcesToAcls.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$8);
                return BoxedUnit.UNIT;
            });
            $this.testRemove(cmdArgs$2, (Set<ResourcePattern>)((TraversableOnce)resourcesToAcls.keys().flatten((Function1)Predef$.MODULE$.$conforms())).toSet(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCommand)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        AccessControlEntry writeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry describeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry createAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl, describeAcl, createAcl}))), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$10) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
            return;
        }
        Assertions.assertThrows(RuntimeException.class, () -> this.callMain(cmd));
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(listCmd, !patternType.equals(PatternType.UNKNOWN));
        String[] removeCmd = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        $this.verifyPatternType$1(removeCmd, !patternType.equals(PatternType.UNKNOWN));
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$4(Set acls$3, Seq linkIds$1, ResourcePattern resource$3, Authorizer authorizer) {
        Set linkAcls = (Set)acls$3.map((Function1 & Serializable & scala.Serializable)acl -> SecurityUtils.aceWithClusterLinkIds((AccessControlEntry)acl, (Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(linkIds$1).asJava())), Set$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)linkAcls, authorizer, resource$3, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$3(AclCommandTest $this, Set acls$3, Seq linkIds$1, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            AclCommandTest.$anonfun$testClusterLinkAcls$4(acls$3, linkIds$1, resource, (Authorizer)aclAuthorizer);
        }
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$6(Uuid local$1, String listOut$1, Uuid linkId) {
        Uuid uuid = linkId;
        String linkIdString = !(uuid != null ? !uuid.equals(local$1) : local$1 != null) ? "LocalCluster" : linkId.toString();
        Assertions.assertTrue((boolean)listOut$1.contains(linkIdString), (String)new StringBuilder(40).append("Link-id '").append(linkIdString).append("' not included in list output: ").append(listOut$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$1(AclCommandTest $this, Map linkIdMap$1, String[] cmdArgs$3, Uuid local$1, Set resources) {
        void var21_21;
        void var20_20;
        void var16_16;
        void var15_15;
        void var11_11;
        void var10_10;
        String[] resourceCmd = (String[])$this.ResourceToCommand().apply((Object)resources);
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources);
        Seq linkIds = (Seq)linkIdMap$1.apply((Object)resources);
        String[] linkIdCmd = (String[])((TraversableOnce)linkIds.flatMap((Function1 & Serializable & scala.Serializable)id -> new .colon.colon((Object)"--link-id", (List)new .colon.colon((Object)id.toString(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        Tuple2<Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(AclPermissionType.ALLOW, (Set<AclOperation>)((Set)operationToCmd._1()), $this.getAclToCommand$default$3());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        void acls2 = var10_10;
        void cmd2 = var11_11;
        Tuple2<String, String> tuple22 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmd2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resourceCmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])operationToCmd._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linkIdCmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String addOut = (String)tuple22._1();
        String addErr = (String)tuple22._2();
        void addOut2 = var15_15;
        void addErr2 = var16_16;
        $this.assertOutputContains("Adding ACLs", (Set<ResourcePattern>)resources, resourceCmd, (String)addOut2);
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources, resourceCmd, (String)addOut2);
        Assertions.assertEquals((Object)"", (Object)addErr2);
        resources.foreach(arg_0 -> AclCommandTest.$anonfun$testClusterLinkAcls$3$adapted($this, (Set)acls2, linkIds, arg_0));
        Tuple2<String, String> tuple23 = $this.callMain((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linkIdCmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String listOut = (String)tuple23._1();
        String listErr = (String)tuple23._2();
        void listOut2 = var20_20;
        void listErr2 = var21_21;
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources, resourceCmd, (String)listOut2);
        linkIds.foreach(arg_0 -> AclCommandTest.$anonfun$testClusterLinkAcls$6$adapted(local$1, (String)listOut2, arg_0));
        Assertions.assertEquals((Object)"", (Object)listErr2);
        $this.testRemove((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])linkIdCmd)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), (Set<ResourcePattern>)resources, resourceCmd);
    }

    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, ResourcePattern resource) {
        KafkaConfig withAuthorizer_kafkaConfig = KafkaConfig$.MODULE$.fromProps($this.brokerProps(), false);
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclAuthorizer aclAuthorizer = withAuthorizer_authZ;
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)aclAuthorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        }
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$1$adapted(AclCommandTest $this, Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$1($this, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$2$adapted(Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$5$adapted(Set acls$1, ResourcePattern resource$1, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, authorizer, resource$1, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$4$adapted(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        AclCommandTest.$anonfun$testAclCli$4($this, acls$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testProducerConsumerCli$7$adapted(Set acls$2, ResourcePattern resource$2, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, authorizer, resource$2, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClusterLinkAcls$4$adapted(Set acls$3, Seq linkIds$1, ResourcePattern resource$3, Authorizer authorizer) {
        AclCommandTest.$anonfun$testClusterLinkAcls$4(acls$3, linkIds$1, resource$3, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClusterLinkAcls$3$adapted(AclCommandTest $this, Set acls$3, Seq linkIds$1, ResourcePattern resource) {
        AclCommandTest.$anonfun$testClusterLinkAcls$3($this, acls$3, linkIds$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClusterLinkAcls$6$adapted(Uuid local$1, String listOut$1, Uuid linkId) {
        AclCommandTest.$anonfun$testClusterLinkAcls$6(local$1, listOut$1, linkId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testRemove$2$adapted(ResourcePattern resource$4, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, resource$4, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        return BoxedUnit.UNIT;
    }
}

