/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0013'\u0001-BQA\r\u0001\u0005\u0002MBQA\u000e\u0001\u0005B]BqA\u0010\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004@\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001b\u0001\n\u0003a\u0005BB.\u0001A\u0003%Q\nC\u0004]\u0001\t\u0007I\u0011A!\t\ru\u0003\u0001\u0015!\u0003C\u0011\u001dq\u0006A1A\u0005\u00021Caa\u0018\u0001!\u0002\u0013i\u0005b\u00021\u0001\u0005\u0004%\t!\u0011\u0005\u0007C\u0002\u0001\u000b\u0011\u0002\"\t\u000f\t\u0004!\u0019!C\u0001\u0019\"11\r\u0001Q\u0001\n5Cq\u0001\u001a\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004f\u0001\u0001\u0006IA\u0011\u0005\bM\u0002\u0011\r\u0011\"\u0001M\u0011\u00199\u0007\u0001)A\u0005\u001b\"9\u0001\u000e\u0001b\u0001\n\u0003\t\u0005BB5\u0001A\u0003%!\tC\u0004k\u0001\t\u0007I\u0011\u0001'\t\r-\u0004\u0001\u0015!\u0003N\u0011\u001d9\u0003\u00011A\u0005\u00021Dq!\u001f\u0001A\u0002\u0013\u0005!\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0015B7\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!&\u0001\t\u0003\t9\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m&!E!eIB\u000b'\u000f^5uS>t7\u000fV3ti*\u0011q\u0005K\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002S\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001-!\ti\u0003'D\u0001/\u0015\ty\u0003&\u0001\u0004tKJ4XM]\u0005\u0003c9\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0002\"!\u000e\u0001\u000e\u0003\u0019\n1B\u0019:pW\u0016\u00148i\\;oiV\t\u0001\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0002J]R\f1\u0002]1si&$\u0018n\u001c8JI\u0006a\u0001/\u0019:uSRLwN\\%eA\u00051Ao\u001c9jGF*\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019\u0019FO]5oO\u00069Ao\u001c9jGF\u0002\u0013\u0001\u0005;pa&\u001c\u0017'Q:tS\u001etW.\u001a8u+\u0005i\u0005\u0003\u0002(TqUk\u0011a\u0014\u0006\u0003!F\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005IS\u0014AC2pY2,7\r^5p]&\u0011Ak\u0014\u0002\u0004\u001b\u0006\u0004\bC\u0001,Z\u001b\u00059&B\u0001-)\u0003)\u0019wN\u001c;s_2dWM]\u0005\u00035^\u0013\u0011CU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u\u0003E!x\u000e]5dc\u0005\u001b8/[4o[\u0016tG\u000fI\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005\u0001Bo\u001c9jGJ\n5o]5h]6,g\u000e^\u0001\u0012i>\u0004\u0018n\u0019\u001aBgNLwM\\7f]R\u0004\u0013A\u0002;pa&\u001c7'A\u0004u_BL7m\r\u0011\u0002!Q|\u0007/[24\u0003N\u001c\u0018n\u001a8nK:$\u0018!\u0005;pa&\u001c7'Q:tS\u001etW.\u001a8uA\u00051Ao\u001c9jGR\nq\u0001^8qS\u000e$\u0004%\u0001\tu_BL7\rN!tg&<g.\\3oi\u0006\tBo\u001c9jGR\n5o]5h]6,g\u000e\u001e\u0011\u0002\rQ|\u0007/[26\u0003\u001d!x\u000e]5dk\u0001\n\u0001\u0003^8qS\u000e,\u0014i]:jO:lWM\u001c;\u0002#Q|\u0007/[26\u0003N\u001c\u0018n\u001a8nK:$\b%F\u0001n!\tqw/D\u0001p\u0015\t9\u0003O\u0003\u0002re\u000691\r\\5f]R\u001c(BA\u0015t\u0015\t!X/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0006\u0019qN]4\n\u0005a|'!B!e[&t\u0017!C1e[&tw\fJ3r)\tYh\u0010\u0005\u0002:y&\u0011QP\u000f\u0002\u0005+:LG\u000fC\u0004\u00005\u0005\u0005\t\u0019A7\u0002\u0007a$\u0013'\u0001\u0004bI6Lg\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004w\u0006\u001d\u0001bBA\u00059\u0001\u0007\u00111B\u0001\ti\u0016\u001cH/\u00138g_B!\u0011QBA\u000e\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011aA1qS*!\u0011QCA\f\u0003\u001dQW\u000f]5uKJT1!!\u0007v\u0003\u0015QWO\\5u\u0013\u0011\ti\"a\u0004\u0003\u0011Q+7\u000f^%oM>D3\u0001HA\u0011!\u0011\ti!a\t\n\t\u0005\u0015\u0012q\u0002\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0006;fgR<&o\u001c8h%\u0016\u0004H.[2b\u0007>,h\u000e\u001e\u000b\u0004w\u0006-\u0002bBA\u0017;\u0001\u0007\u0011qF\u0001\u0007cV|'/^7\u0011\t\u0005E\u0012q\b\b\u0005\u0003g\tY\u0004E\u0002\u00026ij!!a\u000e\u000b\u0007\u0005e\"&\u0001\u0004=e>|GOP\u0005\u0004\u0003{Q\u0014A\u0002)sK\u0012,g-C\u0002J\u0003\u0003R1!!\u0010;Q\u001di\u0012QIA+\u0003/\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\ty%a\u0005\u0002\rA\f'/Y7t\u0013\u0011\t\u0019&!\u0013\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\tI&!\u0018\"\u0005\u0005m\u0013A\u0001>lC\t\ty&A\u0003le\u00064G\u000fK\u0004\u001e\u0003G\nY'!\u001c\u0011\t\u0005\u0015\u0014qM\u0007\u0003\u0003\u001bJA!!\u001b\u0002N\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003_\n\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003\r\"Xm\u001d;NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p]NLen\u0011:fCR,Gk\u001c9jGN$2a_A;\u0011\u001d\tiC\ba\u0001\u0003_AsAHA#\u0003+\nI\b\f\u0003\u0002Z\u0005u\u0003f\u0002\u0010\u0002d\u0005-\u0014QN\u0001(i\u0016\u001cH/T5tg&tw\rU1si&$\u0018n\u001c8t\u0013:\u001c%/Z1uKB\u000b'\u000f^5uS>t7\u000fF\u0002|\u0003\u0003Cq!!\f \u0001\u0004\ty\u0003K\u0004 \u0003\u000b\n)&!\"-\t\u0005e\u0013Q\f\u0015\b?\u0005\r\u00141NA7\u0003]!Xm\u001d;J]\u000e\u0014X-\\3oiB\u000b'\u000f^5uS>t7\u000fF\u0002|\u0003\u001bCq!!\f!\u0001\u0004\ty\u0003K\u0004!\u0003\u000b\n)&!%-\t\u0005e\u0013Q\f\u0015\bA\u0005\r\u00141NA7\u0003y!Xm\u001d;NC:,\u0018\r\\!tg&<g.\\3oi>3'+\u001a9mS\u000e\f7\u000fF\u0002|\u00033Cq!!\f\"\u0001\u0004\ty\u0003K\u0004\"\u0003\u000b\n)&!(-\t\u0005e\u0013Q\f\u0015\bC\u0005\r\u00141NA7\u0003y!Xm\u001d;SKBd\u0017nY1QY\u0006\u001cW-\\3oi\u0006cGnU3sm\u0016\u00148\u000fF\u0002|\u0003KCq!!\f#\u0001\u0004\ty\u0003K\u0004#\u0003\u000b\n)&!+-\u0005\u0005e\u0003f\u0002\u0012\u0002d\u0005-\u0014QN\u0001#i\u0016\u001cHOU3qY&\u001c\u0017\r\u00157bG\u0016lWM\u001c;QCJ$\u0018.\u00197TKJ4XM]:\u0015\u0007m\f\t\fC\u0004\u0002.\r\u0002\r!a\f)\u000f\r\n)%!\u0016\u000262\u0012\u0011\u0011\f\u0015\bG\u0005\r\u00141NA7\u0003e1\u0018\r\\5eCR,G*Z1eKJ\fe\u000e\u001a*fa2L7-Y:\u0015\u0013m\fi,a;\u0002n\u0006E\bbBA`I\u0001\u0007\u0011\u0011Y\u0001\t[\u0016$\u0018\rZ1uCB!\u00111YAs\u001d\u0011\t)-a8\u000f\t\u0005\u001d\u0017\u0011\u001c\b\u0005\u0003\u0013\f)N\u0004\u0003\u0002L\u0006Mg\u0002BAg\u0003#tA!!\u000e\u0002P&\ta/\u0003\u0002uk&\u0011\u0011f]\u0005\u0004\u0003/\u0014\u0018AB2p[6|g.\u0003\u0003\u0002\\\u0006u\u0017\u0001\u0003:fcV,7\u000f^:\u000b\u0007\u0005]'/\u0003\u0003\u0002b\u0006\r\u0018\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0015\u0011\tY.!8\n\t\u0005\u001d\u0018\u0011\u001e\u0002\u000e)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u000b\t\u0005\u0005\u00181\u001d\u0005\u0006}\u0011\u0002\r\u0001\u000f\u0005\u0007\u0003_$\u0003\u0019\u0001\u001d\u0002!\u0015D\b/Z2uK\u0012dU-\u00193fe&#\u0007bBAzI\u0001\u0007\u0011Q_\u0001\u0011Kb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dCN\u0004R!!\r\u0002xbJA!!?\u0002B\t\u00191+\u001a;")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$))}));
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Nil$.MODULE$))}));
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})), (Seq)Nil$.MODULE$))}));
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), (Seq)Nil$.MODULE$))}));
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$))}));
    private Admin admin = null;

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.isKRaftTest()) {
            this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> (Void)((BrokerServer)broker).lifecycleManager().initialUnfenceFuture().get());
        }
        this.createTopicWithAssignment(this.topic1(), (Map<Object, Seq<Object>>)((Map)this.topic1Assignment().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int k = x0$1._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic2(), (Map<Object, Seq<Object>>)((Map)this.topic2Assignment().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int k = x0$2._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic3(), (Map<Object, Seq<Object>>)((Map)this.topic3Assignment().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            int k = x0$3._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$3._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(this.topic4(), (Map<Object, Seq<Object>>)((Map)this.topic4Assignment().map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            int k = x0$4._1$mcI$sp();
            ReplicaAssignment v = (ReplicaAssignment)x0$4._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())), this.createTopicWithAssignment$default$3());
        this.admin_$eq(this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testWrongReplicaCount(String quorum) {
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)2, Collections.singletonList(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))))).all().get()).getCause().getClass());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMissingPartitionsInCreateTopics(String quorum) {
        HashMap<Integer, java.util.List<Object>> topic6Placements = new HashMap<Integer, java.util.List<Object>>();
        topic6Placements.put(Predef$.MODULE$.int2Integer(1), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}));
        topic6Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}));
        HashMap<Integer, java.util.List<Object>> topic7Placements = new HashMap<Integer, java.util.List<Object>>();
        topic7Placements.put(Predef$.MODULE$.int2Integer(2), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}));
        topic7Placements.put(Predef$.MODULE$.int2Integer(3), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}));
        java.util.Map futures = this.admin().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic("new-topic6", topic6Placements), new NewTopic("new-topic7", topic7Placements)})).values();
        Throwable topic6Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic6")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic6Cause.getClass());
        Assertions.assertTrue((boolean)topic6Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)new StringBuilder(26).append("Unexpected error message: ").append(topic6Cause.getMessage()).toString());
        Throwable topic7Cause = Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)futures.get("new-topic7")).get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, topic7Cause.getClass());
        Assertions.assertTrue((boolean)topic7Cause.getMessage().contains("partitions should be a consecutive 0-based integer sequence"), (String)new StringBuilder(26).append("Unexpected error message: ").append(topic7Cause.getMessage()).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMissingPartitionsInCreatePartitions(String quorum) {
        Throwable cause = Assertions.assertThrows(ExecutionException.class, () -> this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3, Collections.singletonList(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))))).all().get()).getCause();
        Assertions.assertEquals(InvalidReplicaAssignmentException.class, cause.getClass());
        if (this.isKRaftTest()) {
            Assertions.assertTrue((boolean)cause.getMessage().contains("Attempted to add 2 additional partition(s), but only 1 assignment(s) were specified."), (String)new StringBuilder(26).append("Unexpected error message: ").append(cause.getMessage()).toString());
        } else {
            Assertions.assertTrue((boolean)cause.getMessage().contains("Increasing the number of partitions by 2 but 1 assignments provided."), (String)new StringBuilder(26).append("Unexpected error message: ").append(cause.getMessage()).toString());
        }
        if (!this.isKRaftTest()) {
            Assertions.assertTrue((boolean)((AdminOperationException)Assertions.assertThrows(AdminOperationException.class, () -> {
                AdminZkClient qual$1 = this.adminZkClient();
                String x$3 = this.topic5();
                scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic5Assignment();
                AdminZkClient qual$2 = this.adminZkClient();
                RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
                Option x$2 = qual$2.getBrokerMetadatas$default$2();
                Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
                int x$6 = 2;
                Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Nil$.MODULE$))})));
                boolean x$8 = true;
                boolean x$9 = qual$1.addPartitions$default$6();
                Option x$10 = qual$1.addPartitions$default$7();
                Option x$11 = qual$1.addPartitions$default$8();
                qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$9, x$10, x$11, x$8);
            })).getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testIncrementPartitions(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic1(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic1(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)3);
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            AddPartitionsTest.$anonfun$testIncrementPartitions$2(partition);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testManualAssignmentOfReplicas(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3, Arrays.asList((Object[])new java.util.List[]{Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})})))).all().get();
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin$default$6());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partition1Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        Assertions.assertEquals((int)leader1, (int)partition1Metadata.leader());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partition2Metadata = TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        Assertions.assertEquals((int)leader2, (int)partition2Metadata.leader());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)3, (int)topicMetadata.partitionMetadata().size());
        Assertions.assertEquals((int)0, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assertions.assertEquals((int)1, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assertions.assertEquals((int)2, (int)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        java.util.List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply((int)1)).replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).toSet());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testReplicaPlacementAllServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic3(), NewPartitions.increaseTo((int)7))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 3, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 4, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 5, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic3(), 6, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic3(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testReplicaPlacementPartialServers(String quorum) {
        this.admin().createPartitions(Collections.singletonMap(this.topic2(), NewPartitions.increaseTo((int)3))).all().get();
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 1, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic2(), 2, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        MetadataResponse response = (MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava(), false).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$3)));
        Assertions.assertTrue((boolean)partitionOpt.isDefined(), (String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)expectedLeaderId)), (Object)partition.leaderId, (String)"Partition leader id should match");
        Assertions.assertEquals(expectedReplicas, (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.replicaIds).asScala()).toSet(), (String)"Replica set should match");
    }

    public static final /* synthetic */ void $anonfun$testIncrementPartitions$2(MetadataResponse.PartitionMetadata partition) {
        java.util.List replicas = partition.replicaIds;
        Assertions.assertEquals((int)2, (int)replicas.size());
        Assertions.assertTrue((boolean)partition.leaderId.isPresent());
        Integer leaderId = (Integer)partition.leaderId.get();
        Assertions.assertTrue((boolean)replicas.contains(leaderId));
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$3) {
        return x$3.partition() == partitionId$1;
    }

    public AddPartitionsTest() {
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
        this.topic5 = "new-topic5";
    }
}

