/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import kafka.admin.MetadataQuorumCommand$;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u000114Aa\u0002\u0005\u0001\u001b!AA\u0003\u0001B\u0001B\u0003%Q\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003?\u0001\u0011\u0005\u0011\u0005C\u0003B\u0001\u0011\u0005\u0011\u0005C\u0003G\u0001\u0011\u0005\u0011EA\rNKR\fG-\u0019;b#V|'/^7D_6l\u0017M\u001c3UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0017aB2mkN$XM\u001d\t\u0003-ei\u0011a\u0006\u0006\u00031)\tA\u0001^3ti&\u0011!d\u0006\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"!H\u0010\u0011\u0005y\u0001Q\"\u0001\u0005\t\u000bQ\u0011\u0001\u0019A\u000b\u0002OQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Rk>\u0014X/\u001c*fa2L7-\u0019;j_:\u001cVoY2fgN4W\u000f\u001c\u000b\u0002EA\u0011qbI\u0005\u0003IA\u0011A!\u00168ji\"\"1A\n\u0017.!\t9#&D\u0001)\u0015\tIs#\u0001\u0006b]:|G/\u0019;j_:L!a\u000b\u0015\u0003\u0019\rcWo\u001d;feR+7\u000f^:\u0002\u000bY\fG.^3-\u00079ZThK\u00040eMB\u0014HO\u001d\u0011\u0005\u001d\u0002\u0014BA\u0019)\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002\u0017\rdWo\u001d;feRK\b/\u001a\u0013\u0002i%\u0011QGN\u0001\u0006\u0017J\u000be\t\u0016\u0006\u0003o!\nA\u0001V=qK\u00069!M]8lKJ\u001cX$A\u0002\u0002\u0017\r|g\u000e\u001e:pY2,'o]\u0016\b_I\u001a\u0004(\u000f\u001e=;\u0005\u00111fB\u00183gab$(O\u0001#i\u0016\u001cH\u000fR3tGJL'-Z)v_J,Xn\u0015;biV\u001c8+^2dKN\u001ch-\u001e7)\t\u00111C\u0006\u0011\u0017\u0004]mj\u0014!\t;fgR|e\u000e\\=P]\u0016\u0014%o\\6fe\u0006sGm\u00148f\u0007>tGO]8mY\u0016\u0014\b\u0006B\u0003'Y\rc\u0013\u0001R\u0016\b_I\u001a\u0004(\u0012\u001eF;\u0005\t\u0011A\u0007;fgR$Um]2sS\n,\u0017+^8sk6LeNW6N_\u0012,\u0007F\u0002\u00040e!C\u0014\bJ\u0001J\u0013\tQe'\u0001\u0002[\u0017\"\"\u0001\u0001\u0014\u0017Y!\tie+D\u0001O\u0015\ty\u0005+A\u0002ba&T!!\u0015*\u0002\u000f),\b/\u001b;fe*\u00111\u000bV\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002+\u0006\u0019qN]4\n\u0005]s%a\u0001+bO\u0006\n\u0011,A\u0006j]R,wM]1uS>t\u0007\u0006\u0002\u0001\\eM\u0002\"a\n/\n\u0005uC#aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001c\b\u0006\u0002\u0001`Y\u0015\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019(\u0002\u0013\u0015DH/\u001a8tS>t\u0017B\u00013b\u0005))\u0005\u0010^3oI^KG\u000f\u001b\u0017\u0002M\u000e\nq\r\u0005\u0002iU6\t\u0011N\u0003\u0002T/%\u00111.\u001b\u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0001")
public class MetadataQuorumCommandTest {
    private final ClusterInstance cluster;

    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=3), @ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=3)})
    public void testDescribeQuorumReplicationSuccessful() {
        this.cluster.waitForReadyBrokers();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--replication"}));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Regex leaderPattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+[-]?\\d+\\s+Leader\\s+")).r();
        Regex followerPattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+[-]?\\d+\\s+Follower\\s+")).r();
        Regex observerPattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\s+\\d+\\s+\\d+\\s+\\d+\\s+[-]?\\d+\\s+Observer\\s+")).r();
        String[] outputs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.split("\n"))).tail();
        Type type = this.cluster.config().clusterType();
        Type type2 = Type.CO_KRAFT;
        if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null)) {
            Assertions.assertEquals((int)Math.max(this.cluster.config().numControllers(), this.cluster.config().numBrokers()), (int)outputs.length);
        } else {
            Assertions.assertEquals((int)(this.cluster.config().numBrokers() + this.cluster.config().numControllers()), (int)outputs.length);
        }
        Assertions.assertTrue((boolean)leaderPattern.findFirstIn((CharSequence)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).head()).nonEmpty());
        Assertions.assertEquals((int)1, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$2(leaderPattern, x$1))));
        Assertions.assertEquals((int)(this.cluster.config().numControllers() - 1), (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$3(followerPattern, x$2))));
        Type type3 = this.cluster.config().clusterType();
        Type type4 = Type.CO_KRAFT;
        if (!(type3 != null ? !((Object)((Object)type3)).equals((Object)type4) : type4 != null)) {
            Assertions.assertEquals((int)Math.max(0, this.cluster.config().numBrokers() - this.cluster.config().numControllers()), (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$4(observerPattern, x$3))));
            return;
        }
        Assertions.assertEquals((int)this.cluster.config().numBrokers(), (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataQuorumCommandTest.$anonfun$testDescribeQuorumReplicationSuccessful$5(observerPattern, x$4))));
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=3), @ClusterTest(clusterType=Type.KRAFT, brokers=3, controllers=2), @ClusterTest(clusterType=Type.KRAFT, brokers=2, controllers=3)})
    public void testDescribeQuorumStatusSuccessful() {
        this.cluster.waitForReadyBrokers();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--status"}));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] outputs = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("ClusterId:\\s+\\S{22}")).r().findFirstIn((CharSequence)outputs[0]).nonEmpty());
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("LeaderId:\\s+\\d+")).r().findFirstIn((CharSequence)outputs[1]).nonEmpty());
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("LeaderEpoch:\\s+\\d+")).r().findFirstIn((CharSequence)outputs[2]).nonEmpty());
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("HighWatermark:\\s+[-]?\\d+")).r().findFirstIn((CharSequence)outputs[3]).nonEmpty());
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("MaxFollowerLag:\\s+\\d+")).r().findFirstIn((CharSequence)outputs[4]).nonEmpty());
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("MaxFollowerLagTimeMs:\\s+[-]?\\d+")).r().findFirstIn((CharSequence)outputs[5]).nonEmpty());
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("CurrentVoters:\\s+\\[\\d+(,\\d+)*\\]")).r().findFirstIn((CharSequence)outputs[6]).nonEmpty());
        Type type = this.cluster.config().clusterType();
        Type type2 = Type.CO_KRAFT;
        if (!(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null) && this.cluster.config().numBrokers() <= this.cluster.config().numControllers()) {
            Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("CurrentObservers:\\s+\\[\\]")).r().findFirstIn((CharSequence)outputs[7]).nonEmpty());
            return;
        }
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString("CurrentObservers:\\s+\\[\\d+(,\\d+)*\\]")).r().findFirstIn((CharSequence)outputs[7]).nonEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTests(value={@ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)})
    public void testOnlyOneBrokerAndOneController() {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--status"}));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertEquals((Object)"MaxFollowerLag:         0", (Object)string.split("\n")[4]);
        Assertions.assertEquals((Object)"MaxFollowerLagTimeMs:   0", (Object)string.split("\n")[5]);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MetadataQuorumCommand$.MODULE$.mainNoExit((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--replication"}));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = grabConsoleOutput_out2.toString();
        Assertions.assertEquals((Object)"0", (Object)string2.split("\n")[1].split("\\s+")[2]);
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3)
    public void testDescribeQuorumInZkMode() {
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> MetadataQuorumCommand$.MODULE$.mainNoExit((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--status"}))).getCause() instanceof UnsupportedVersionException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> MetadataQuorumCommand$.MODULE$.mainNoExit((String[])((Object[])new String[]{"--bootstrap-server", $this.cluster.bootstrapServers(), "describe", "--replication"}))).getCause() instanceof UnsupportedVersionException));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$2(Regex leaderPattern$1, String x$1) {
        return leaderPattern$1.findFirstIn((CharSequence)x$1).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$3(Regex followerPattern$1, String x$2) {
        return followerPattern$1.findFirstIn((CharSequence)x$2).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$4(Regex observerPattern$1, String x$3) {
        return observerPattern$1.findFirstIn((CharSequence)x$3).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumReplicationSuccessful$5(Regex observerPattern$1, String x$4) {
        return observerPattern$1.findFirstIn((CharSequence)x$4).nonEmpty();
    }

    public MetadataQuorumCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

