/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import kafka.admin.MirrorCommand$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001y4AAD\b\u0001)!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C!M!IQ\u0007\u0001a\u0001\u0002\u0004%IA\u000e\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\n\u0011C\u0011b\u0013\u0001A\u0002\u0003\u0005\u000b\u0015B\u001c\t\u00131\u0003\u0001\u0019!a\u0001\n\u0013i\u0005\"C-\u0001\u0001\u0004\u0005\r\u0011\"\u0003[\u0011%a\u0006\u00011A\u0001B\u0003&a\nC\u0003^\u0001\u0011\u0005a\fC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0003v\u0001\u0011\u0005\u0001\u000fC\u0003x\u0001\u0011\u0005\u0001\u000fC\u0003z\u0001\u0011\u0005\u0001O\u0001\u0011NSJ\u0014xN]\"p[6\fg\u000eZ,ji\"\fE-\\5o\u00072LWM\u001c;UKN$(B\u0001\t\u0012\u0003\u0015\tG-\\5o\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0012\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005i9\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005qyR\"A\u000f\u000b\u0005y\t\u0012!B;uS2\u001c\u0018B\u0001\u0011\u001e\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0012\u0011\u0005\u0011\u0002Q\"A\b\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\n\t\u0004Q5zS\"A\u0015\u000b\u0005)Z\u0013AC2pY2,7\r^5p]*\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/S\t\u00191+Z9\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\n\u0012AB:feZ,'/\u0003\u00025c\tY1*\u00194lC\u000e{gNZ5h\u0003-\tG-\\5o\u00072LWM\u001c;\u0016\u0003]\u0002\"\u0001O!\u000e\u0003eR!\u0001\u0005\u001e\u000b\u0005mb\u0014aB2mS\u0016tGo\u001d\u0006\u0003%uR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u000f\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0010C\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011Q)\u0013\t\u0003\r\u001ek\u0011aK\u0005\u0003\u0011.\u0012A!\u00168ji\"9!\nBA\u0001\u0002\u00049\u0014a\u0001=%c\u0005a\u0011\rZ7j]\u000ec\u0017.\u001a8uA\u0005iA/Z:u)>\u0004\u0018n\u0019(b[\u0016,\u0012A\u0014\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005E[S\"\u0001*\u000b\u0005M\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002VW\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)6&A\tuKN$Hk\u001c9jG:\u000bW.Z0%KF$\"!R.\t\u000f);\u0011\u0011!a\u0001\u001d\u0006qA/Z:u)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013!B:fiV\u0004HCA#`\u0011\u0015\u0001\u0017\u00021\u0001b\u0003\u0011IgNZ8\u0011\u0005\tLW\"A2\u000b\u0005\u0011,\u0017aA1qS*\u0011amZ\u0001\bUV\u0004\u0018\u000e^3s\u0015\tAw(A\u0003kk:LG/\u0003\u0002kG\nAA+Z:u\u0013:4w\u000e\u000b\u0002\nYB\u0011!-\\\u0005\u0003]\u000e\u0014!BQ3g_J,W)Y2i\u0003)\"Xm\u001d;De\u0016\fG/Z'jeJ|'oV5uQ:{g.T1uG\"LgnZ'jeJ|'\u000fV8qS\u000e$\u0012!\u0012\u0015\u0003\u0015I\u0004\"AY:\n\u0005Q\u001c'\u0001\u0002+fgR\f!\u0006^3ti\u000e\u0013X-\u0019;f\u001b&\u0014(o\u001c:XSRDgj\u001c8fq&\u001cH/\u001a8u\u00072,8\u000f^3s\u0019&t7\u000e\u000b\u0002\fe\u0006\u0011C/Z:u\u0007J,\u0017\r^3NSJ\u0014xN],ji\"l\u0015N\u001d:pe\u0016$7i\u001c8gS\u001eD#\u0001\u0004:\u0002\u000b\rdwn]3)\u00055Y\bC\u00012}\u0013\ti8MA\u0005BMR,'/R1dQ\u0002")
public class MirrorCommandWithAdminClientTest
extends KafkaServerTestHarness {
    private Admin adminClient;
    private String testTopicName;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 1;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = 1;
        short x$5 = (short)1;
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5, x$17).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    @BeforeEach
    public void setup(TestInfo info) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @Test
    public void testCreateMirrorWithNonMatchingMirrorTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--create", "--source-topic", this.testTopicName(), "--mirror-topic", "another-topic", "--link", "nonexistent"});
        Assertions.assertThrows(UnsupportedVersionException.class, () -> MirrorCommand$.MODULE$.run(args, (Option)new Some((Object)((ConfluentAdmin)this.adminClient()))));
    }

    @Test
    public void testCreateMirrorWithNonexistentClusterLink() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--create", "--source-topic", this.testTopicName(), "--mirror-topic", this.testTopicName(), "--link", "nonexistent"});
        Assertions.assertThrows(ClusterLinkNotFoundException.class, () -> MirrorCommand$.MODULE$.run(args, (Option)new Some((Object)((ConfluentAdmin)this.adminClient()))));
    }

    @Test
    public void testCreateMirrorWithMirroredConfig() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--create", "--source-topic", this.testTopicName(), "--mirror-topic", this.testTopicName(), "--link", "linked-cluster", "--config", "delete.retention.ms=1000"});
        Assertions.assertThrows(ClusterLinkNotFoundException.class, () -> MirrorCommand$.MODULE$.run(args, (Option)new Some((Object)((ConfluentAdmin)this.adminClient()))));
    }

    @AfterEach
    public void close() {
        if (this.adminClient() != null) {
            this.adminClient().close();
        }
    }
}

