/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import kafka.admin.ReplicaStatusCommand$;
import kafka.admin.ReplicaStatusCommandTest$;
import kafka.admin.ReplicaStatusCommandTest$ReplicaStatusEntry$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001B0a\u0005\u0015DQ\u0001\u001c\u0001\u0005\u00025DQ\u0001\u001d\u0001\u0005BEDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002X\u0001!I!!\u0017\u0007\r\u0005E\u0004\u0001QA:\u0011)\tY#\u0002BK\u0002\u0013\u0005\u0011q\u0011\u0005\u000b\u0003\u0013+!\u0011#Q\u0001\n\u00055\u0002BCAF\u000b\tU\r\u0011\"\u0001\u0002\u000e\"Q\u0011qR\u0003\u0003\u0012\u0003\u0006I!a\u001a\t\u0015\u0005EUA!f\u0001\n\u0003\ti\t\u0003\u0006\u0002\u0014\u0016\u0011\t\u0012)A\u0005\u0003OB!\"!&\u0006\u0005+\u0007I\u0011AAL\u0011)\ty*\u0002B\tB\u0003%\u0011\u0011\u0014\u0005\u000b\u0003C+!Q3A\u0005\u0002\u0005]\u0005BCAR\u000b\tE\t\u0015!\u0003\u0002\u001a\"Q\u0011QU\u0003\u0003\u0016\u0004%\t!a&\t\u0015\u0005\u001dVA!E!\u0002\u0013\tI\n\u0003\u0006\u0002*\u0016\u0011)\u001a!C\u0001\u0003/C!\"a+\u0006\u0005#\u0005\u000b\u0011BAM\u0011)\ti+\u0002BK\u0002\u0013\u0005\u0011q\u0013\u0005\u000b\u0003_+!\u0011#Q\u0001\n\u0005e\u0005BCAY\u000b\tU\r\u0011\"\u0001\u00024\"Q\u0011\u0011Y\u0003\u0003\u0012\u0003\u0006I!!.\t\u0015\u0005\rWA!f\u0001\n\u0003\t\u0019\f\u0003\u0006\u0002F\u0016\u0011\t\u0012)A\u0005\u0003kC!\"a2\u0006\u0005+\u0007I\u0011AAZ\u0011)\tI-\u0002B\tB\u0003%\u0011Q\u0017\u0005\u000b\u0003\u0017,!Q3A\u0005\u0002\u0005M\u0006BCAg\u000b\tE\t\u0015!\u0003\u00026\"Q\u0011qZ\u0003\u0003\u0016\u0004%\t!a\"\t\u0015\u0005EWA!E!\u0002\u0013\ti\u0003\u0003\u0006\u0002T\u0016\u0011)\u001a!C\u0001\u0003+D!\"!7\u0006\u0005#\u0005\u000b\u0011BAl\u0011)\tY.\u0002BK\u0002\u0013\u0005\u00111\u0017\u0005\u000b\u0003;,!\u0011#Q\u0001\n\u0005U\u0006BCAp\u000b\tU\r\u0011\"\u0001\u00024\"Q\u0011\u0011]\u0003\u0003\u0012\u0003\u0006I!!.\t\r1,A\u0011AAr\u0011%\u0011I!BA\u0001\n\u0003\u0011Y\u0001C\u0005\u0003.\u0015\t\n\u0011\"\u0001\u00030!I!QI\u0003\u0012\u0002\u0013\u0005!q\t\u0005\n\u0005\u0017*\u0011\u0013!C\u0001\u0005\u000fB\u0011B!\u0014\u0006#\u0003%\tAa\u0014\t\u0013\tMS!%A\u0005\u0002\t=\u0003\"\u0003B+\u000bE\u0005I\u0011\u0001B(\u0011%\u00119&BI\u0001\n\u0003\u0011y\u0005C\u0005\u0003Z\u0015\t\n\u0011\"\u0001\u0003P!I!1L\u0003\u0012\u0002\u0013\u0005!Q\f\u0005\n\u0005C*\u0011\u0013!C\u0001\u0005;B\u0011Ba\u0019\u0006#\u0003%\tA!\u0018\t\u0013\t\u0015T!%A\u0005\u0002\tu\u0003\"\u0003B4\u000bE\u0005I\u0011\u0001B\u0018\u0011%\u0011I'BI\u0001\n\u0003\u0011Y\u0007C\u0005\u0003p\u0015\t\n\u0011\"\u0001\u0003^!I!\u0011O\u0003\u0012\u0002\u0013\u0005!Q\f\u0005\n\u0005g*\u0011\u0011!C!\u0005kB\u0011Ba\u001f\u0006\u0003\u0003%\t!!$\t\u0013\tuT!!A\u0005\u0002\t}\u0004\"\u0003BF\u000b\u0005\u0005I\u0011\tBG\u0011%\u0011)*BA\u0001\n\u0003\u00119\nC\u0005\u0003\u001c\u0016\t\t\u0011\"\u0011\u0003\u001e\"I!qT\u0003\u0002\u0002\u0013\u0005#\u0011\u0015\u0005\n\u0005G+\u0011\u0011!C!\u0005K;\u0011B!+\u0001\u0003\u0003E\tAa+\u0007\u0013\u0005E\u0004!!A\t\u0002\t5\u0006B\u00027B\t\u0003\u0011Y\fC\u0005\u0003 \u0006\u000b\t\u0011\"\u0012\u0003\"\"I!QX!\u0002\u0002\u0013\u0005%q\u0018\u0005\n\u0005C\f\u0015\u0011!CA\u0005GDqA!=\u0001\t\u0013\u0011\u0019\u0010C\u0004\u0004\u0012\u0001!\taa\u0005\t\u000f\r-\u0002\u0001\"\u0001\u0004\u0014!91q\u0006\u0001\u0005\u0002\rM\u0001bBB\u001a\u0001\u0011\u000511\u0003\u0005\b\u0007o\u0001A\u0011AB\n\u0011\u001d\u0019Y\u0004\u0001C\u0001\u0007'Aqaa\u0010\u0001\t\u0003\u0019\u0019\u0002C\u0004\u0004D\u0001!\taa\u0005\t\u000f\r\u001d\u0003\u0001\"\u0003\u0004J!91q\n\u0001\u0005\u0002\rM\u0001bBB*\u0001\u0011\u000511\u0003\u0005\b\u0007/\u0002A\u0011BB-\u0011\u001d\u0019\u0019\u0007\u0001C\u0001\u0007'Aqaa\u001a\u0001\t\u0003\u0019\u0019\u0002C\u0004\u0004l\u0001!\taa\u0005\t\u000f\r=\u0004\u0001\"\u0001\u0004\u0014!911\u000f\u0001\u0005\n\rU\u0004bBB?\u0001\u0011\u000511\u0003\u0005\b\u0007\u0003\u0003A\u0011AB\n\u000f\u001d\u0019)\t\u0019E\u0001\u0007\u000f3aa\u00181\t\u0002\r%\u0005B\u00027\\\t\u0003\u0019Y\tC\u0004\u0004\u000en#\taa$\t\u000f\r%6\f\"\u0001\u0004,\nA\"+\u001a9mS\u000e\f7\u000b^1ukN\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005\u0005\u0014\u0017!B1e[&t'\"A2\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\n\f1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u00111\u000e\u001b\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u001c\t\u0003_\u0002i\u0011\u0001Y\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t!\u000fE\u0002tqjl\u0011\u0001\u001e\u0006\u0003kZ\f!bY8mY\u0016\u001cG/[8o\u0015\u00059\u0018!B:dC2\f\u0017BA=u\u0005\r\u0019V-\u001d\t\u0003wzl\u0011\u0001 \u0006\u0003{\n\faa]3sm\u0016\u0014\u0018BA@}\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002%\r\u0014X-\u0019;f)>\u0004\u0018nY!oI^\u000b\u0017\u000e\u001e\u000b\t\u0003\u000b\ti!!\u000b\u0002DA!\u0011qAA\u0005\u001b\u00051\u0018bAA\u0006m\n!QK\\5u\u0011\u001d\tya\u0001a\u0001\u0003#\taa\u00197jK:$\b\u0003BA\n\u0003Ki!!!\u0006\u000b\u0007\u0005\f9B\u0003\u0003\u0002\u001a\u0005m\u0011aB2mS\u0016tGo\u001d\u0006\u0004G\u0006u!\u0002BA\u0010\u0003C\ta!\u00199bG\",'BAA\u0012\u0003\ry'oZ\u0005\u0005\u0003O\t)BA\u0006BI6Lgn\u00117jK:$\bbBA\u0016\u0007\u0001\u0007\u0011QF\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001am6\u0011\u0011Q\u0007\u0006\u0004\u0003o!\u0017A\u0002\u001fs_>$h(C\u0002\u0002<Y\fa\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001em\"9\u0011QI\u0002A\u0002\u0005\u001d\u0013!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0003#\nAA[1wC&!\u0011QKA&\u0005\u001dIe\u000e^3hKJ\f!B];o\u0007>lW.\u00198e)!\ti#a\u0017\u0002f\u00055\u0004bBA/\t\u0001\u0007\u0011qL\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005\u001d\u0011\u0011MA\u0017\u0013\r\t\u0019G\u001e\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u000b\"\u0001\u0019AA4!\u0011\t9!!\u001b\n\u0007\u0005-dOA\u0002J]RDq!a\u001c\u0005\u0001\u0004\ty&\u0001\u0003be\u001e\u001c(A\u0005*fa2L7-Y*uCR,8/\u00128uef\u001cr!BA;\u0003w\n\t\t\u0005\u0003\u0002\b\u0005]\u0014bAA=m\n1\u0011I\\=SK\u001a\u0004B!a\u0002\u0002~%\u0019\u0011q\u0010<\u0003\u000fA\u0013x\u000eZ;diB!\u0011qAAB\u0013\r\t)I\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0003\u0003[\ta\u0001^8qS\u000e\u0004\u0013!\u00039beRLG/[8o+\t\t9'\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\nqA]3qY&\u001c\u0017-\u0001\u0005sKBd\u0017nY1!\u0003!I7\u000fT3bI\u0016\u0014XCAAM!\u0011\t9!a'\n\u0007\u0005ueOA\u0004C_>dW-\u00198\u0002\u0013%\u001cH*Z1eKJ\u0004\u0013AC5t\u001f\n\u001cXM\u001d<fe\u0006Y\u0011n](cg\u0016\u0014h/\u001a:!\u00035I7/S:s\u000b2Lw-\u001b2mK\u0006q\u0011n]%te\u0016c\u0017nZ5cY\u0016\u0004\u0013aB5t\u0013:L5O]\u0001\tSNLe.S:sA\u0005Q\u0011n]\"bk\u001eDG/\u00169\u0002\u0017%\u001c8)Y;hQR,\u0006\u000fI\u0001\u0012Y\u0006\u001cHoQ1vO\"$X\u000b\u001d'bO6\u001bXCAA[!\u0019\t9!a.\u0002<&\u0019\u0011\u0011\u0018<\u0003\r=\u0003H/[8o!\u0011\t9!!0\n\u0007\u0005}fO\u0001\u0003M_:<\u0017A\u00057bgR\u001c\u0015-^4iiV\u0003H*Y4Ng\u0002\na\u0002\\1ti\u001a+Go\u00195MC\u001el5/A\bmCN$h)\u001a;dQ2\u000bw-T:!\u00039awnZ*uCJ$xJ\u001a4tKR\fq\u0002\\8h'R\f'\u000f^(gMN,G\u000fI\u0001\rY><WI\u001c3PM\u001a\u001cX\r^\u0001\u000eY><WI\u001c3PM\u001a\u001cX\r\u001e\u0011\u0002\u00171,\u0017\rZ3s\u000bB|7\r[\u0001\rY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eI\u0001\f[&\u0014(o\u001c:Ti\u0006$X-\u0006\u0002\u0002XB1\u0011qAA\\\u0003[\tA\"\\5se>\u00148\u000b^1uK\u0002\nQ#\\5se>\u0014H*Y:u\r\u0016$8\r\u001b+j[\u0016l5/\u0001\fnSJ\u0014xN\u001d'bgR4U\r^2i)&lW-T:!\u0003qi\u0017N\u001d:pe2\u000b7\u000f\u001e$fi\u000eD\u0007*[4i/\u0006$XM]7be.\fQ$\\5se>\u0014H*Y:u\r\u0016$8\r\u001b%jO\"<\u0016\r^3s[\u0006\u00148\u000e\t\u000b#\u0003K\fI/a;\u0002n\u0006=\u0018\u0011_Az\u0003k\f90!?\u0002|\u0006u\u0018q B\u0001\u0005\u0007\u0011)Aa\u0002\u0011\u0007\u0005\u001dX!D\u0001\u0001\u0011\u001d\tYC\na\u0001\u0003[Aq!a#'\u0001\u0004\t9\u0007C\u0004\u0002\u0012\u001a\u0002\r!a\u001a\t\u000f\u0005Ue\u00051\u0001\u0002\u001a\"9\u0011\u0011\u0015\u0014A\u0002\u0005e\u0005bBASM\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003S3\u0003\u0019AAM\u0011\u001d\tiK\na\u0001\u00033Cq!!-'\u0001\u0004\t)\fC\u0004\u0002D\u001a\u0002\r!!.\t\u000f\u0005\u001dg\u00051\u0001\u00026\"9\u00111\u001a\u0014A\u0002\u0005U\u0006bBAhM\u0001\u0007\u0011Q\u0006\u0005\b\u0003'4\u0003\u0019AAl\u0011\u001d\tYN\na\u0001\u0003kCq!a8'\u0001\u0004\t),\u0001\u0003d_BLHCIAs\u0005\u001b\u0011yA!\u0005\u0003\u0014\tU!q\u0003B\r\u00057\u0011iBa\b\u0003\"\t\r\"Q\u0005B\u0014\u0005S\u0011Y\u0003C\u0005\u0002,\u001d\u0002\n\u00111\u0001\u0002.!I\u00111R\u0014\u0011\u0002\u0003\u0007\u0011q\r\u0005\n\u0003#;\u0003\u0013!a\u0001\u0003OB\u0011\"!&(!\u0003\u0005\r!!'\t\u0013\u0005\u0005v\u0005%AA\u0002\u0005e\u0005\"CASOA\u0005\t\u0019AAM\u0011%\tIk\nI\u0001\u0002\u0004\tI\nC\u0005\u0002.\u001e\u0002\n\u00111\u0001\u0002\u001a\"I\u0011\u0011W\u0014\u0011\u0002\u0003\u0007\u0011Q\u0017\u0005\n\u0003\u0007<\u0003\u0013!a\u0001\u0003kC\u0011\"a2(!\u0003\u0005\r!!.\t\u0013\u0005-w\u0005%AA\u0002\u0005U\u0006\"CAhOA\u0005\t\u0019AA\u0017\u0011%\t\u0019n\nI\u0001\u0002\u0004\t9\u000eC\u0005\u0002\\\u001e\u0002\n\u00111\u0001\u00026\"I\u0011q\\\u0014\u0011\u0002\u0003\u0007\u0011QW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tD\u000b\u0003\u0002.\tM2F\u0001B\u001b!\u0011\u00119D!\u0011\u000e\u0005\te\"\u0002\u0002B\u001e\u0005{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}b/\u0001\u0006b]:|G/\u0019;j_:LAAa\u0011\u0003:\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\n\u0016\u0005\u0003O\u0012\u0019$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u000b\u0016\u0005\u00033\u0013\u0019$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012:\u0014AD2paf$C-\u001a4bk2$H\u0005O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011yF\u000b\u0003\u00026\nM\u0012aD2paf$C-\u001a4bk2$H%\r\u0019\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cE\nqbY8qs\u0012\"WMZ1vYR$\u0013GM\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132g\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\nD'\u0006\u0002\u0003n)\"\u0011q\u001bB\u001a\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0014aD2paf$C-\u001a4bk2$H%\r\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\b\u0005\u0003\u0002J\te\u0014\u0002BA \u0003\u0017\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0002\n\u001d\u0005\u0003BA\u0004\u0005\u0007K1A!\"w\u0005\r\te.\u001f\u0005\n\u0005\u0013S\u0014\u0011!a\u0001\u0003O\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BH!\u0015\u0019(\u0011\u0013BA\u0013\r\u0011\u0019\n\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u001a\ne\u0005\"\u0003BEy\u0005\u0005\t\u0019\u0001BA\u0003!A\u0017m\u001d5D_\u0012,GCAA4\u0003!!xn\u0015;sS:<GC\u0001B<\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0014BT\u0011%\u0011IiPA\u0001\u0002\u0004\u0011\t)\u0001\nSKBd\u0017nY1Ti\u0006$Xo]#oiJL\bcAAt\u0003N)\u0011Ia,\u0002\u0002B1#\u0011\u0017B\\\u0003[\t9'a\u001a\u0002\u001a\u0006e\u0015\u0011TAM\u00033\u000b),!.\u00026\u0006U\u0016QFAl\u0003k\u000b),!:\u000e\u0005\tM&b\u0001B[m\u00069!/\u001e8uS6,\u0017\u0002\u0002B]\u0005g\u0013!#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82mQ\u0011!1V\u0001\u0006CB\u0004H.\u001f\u000b#\u0003K\u0014\tMa1\u0003F\n\u001d'\u0011\u001aBf\u0005\u001b\u0014yM!5\u0003T\nU'q\u001bBm\u00057\u0014iNa8\t\u000f\u0005-B\t1\u0001\u0002.!9\u00111\u0012#A\u0002\u0005\u001d\u0004bBAI\t\u0002\u0007\u0011q\r\u0005\b\u0003+#\u0005\u0019AAM\u0011\u001d\t\t\u000b\u0012a\u0001\u00033Cq!!*E\u0001\u0004\tI\nC\u0004\u0002*\u0012\u0003\r!!'\t\u000f\u00055F\t1\u0001\u0002\u001a\"9\u0011\u0011\u0017#A\u0002\u0005U\u0006bBAb\t\u0002\u0007\u0011Q\u0017\u0005\b\u0003\u000f$\u0005\u0019AA[\u0011\u001d\tY\r\u0012a\u0001\u0003kCq!a4E\u0001\u0004\ti\u0003C\u0004\u0002T\u0012\u0003\r!a6\t\u000f\u0005mG\t1\u0001\u00026\"9\u0011q\u001c#A\u0002\u0005U\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005K\u0014i\u000f\u0005\u0004\u0002\b\u0005]&q\u001d\t%\u0003\u000f\u0011I/!\f\u0002h\u0005\u001d\u0014\u0011TAM\u00033\u000bI*!'\u00026\u0006U\u0016QWA[\u0003[\t9.!.\u00026&\u0019!1\u001e<\u0003\u000fQ+\b\u000f\\32m!I!q^#\u0002\u0002\u0003\u0007\u0011Q]\u0001\u0004q\u0012\u0002\u0014!\u0006:v]\u000e{W.\\1oIB\u000b'o]3PkR\u0004X\u000f\u001e\u000b\u000b\u0005k\u001c9a!\u0003\u0004\f\r5\u0001C\u0002B|\u0007\u0003\t)O\u0004\u0003\u0003z\nuh\u0002BA\u001a\u0005wL\u0011a^\u0005\u0004\u0005\u007f4\u0018a\u00029bG.\fw-Z\u0005\u0005\u0007\u0007\u0019)A\u0001\u0003MSN$(b\u0001B\u0000m\"9\u0011Q\f$A\u0002\u0005}\u0003bBA#\r\u0002\u0007\u0011q\r\u0005\b\u0003_2\u0005\u0019AA0\u0011\u001d\u0019yA\u0012a\u0001\u00033\u000b\u0001#\u001a=qK\u000e$X*\u001b:s_JLeNZ8\u00025Q,7\u000f\u001e,fe\n|7/\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\u0005\u0005\u0015\u0001fA$\u0004\u0018A!1\u0011DB\u0014\u001b\t\u0019YB\u0003\u0003\u0004\u001e\r}\u0011aA1qS*!1\u0011EB\u0012\u0003\u001dQW\u000f]5uKJTAa!\n\u0002\"\u0005)!.\u001e8ji&!1\u0011FB\u000e\u0005\u0011!Vm\u001d;\u0002'Q,7\u000f^*qK\u000eLg-[3e)>\u0004\u0018nY:)\u0007!\u001b9\"A\fuKN$8\u000b]3dS\u001aLW\r\u001a)beRLG/[8og\"\u001a\u0011ja\u0006\u0002\u001fQ,7\u000f\u001e'fC\u0012,'o](oYfD3ASB\f\u0003M!Xm\u001d;MK\u0006$WM]:Fq\u000edW\u000fZ3eQ\rY5qC\u0001\u0012i\u0016\u001cHo\u00142tKJ4XM]:P]2L\bf\u0001'\u0004\u0018\u0005)B/Z:u\u001f\n\u001cXM\u001d<feN,\u0005p\u00197vI\u0016$\u0007fA'\u0004\u0018\u0005aA/Z:u\u001d>$\u0018J\\%te\"\u001aaja\u0006\u0002\u001bI,h\u000eV3ti>+H\u000f];u)\u0019\t)aa\u0013\u0004N!9\u0011qN(A\u0002\u0005}\u0003bBB\b\u001f\u0002\u0007\u0011\u0011T\u0001\u000bi\u0016\u001cHoT;uaV$\bf\u0001)\u0004\u0018\u00059B/Z:u\u001fV$\b/\u001e;J]\u000edW\u000fZ3NSJ\u0014xN\u001d\u0015\u0004#\u000e]\u0011a\u0003:v]R+7\u000f\u001e&t_:$\u0002\"!\u0002\u0004\\\ru3\u0011\r\u0005\b\u0003_\u0012\u0006\u0019AA0\u0011\u001d\u0019yF\u0015a\u0001\u00033\u000b\u0011#\u001a=qK\u000e$8\t\\;ti\u0016\u0014H*\u001b8l\u0011\u001d\u0019yA\u0015a\u0001\u00033\u000b\u0001\u0002^3ti*\u001bxN\u001c\u0015\u0004'\u000e]\u0011!\u0006;fgRT5o\u001c8J]\u000edW\u000fZ3MS:\\W\r\u001a\u0015\u0004)\u000e]\u0011!\u0006;fgRT5o\u001c8J]\u000edW\u000fZ3NSJ\u0014xN\u001d\u0015\u0004+\u000e]\u0011a\u0004;fgRl\u0015n]:j]\u001e\f%oZ:)\u0007Y\u001b9\"A\buKN$\u0018J\u001c<bY&$\u0017I]4t)\u0019\t)aa\u001e\u0004z!9\u0011qN,A\u0002\u0005}\u0003bBB>/\u0002\u0007\u0011QF\u0001\u0017Kb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:Qe\u00164\u0017\u000e_*ue\u0006\tB/Z:u\u0013:4\u0018\r\\5e)>\u0004\u0018nY:)\u0007a\u001b9\"\u0001\ruKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\\:Be\u001eD3!WB\f\u0003a\u0011V\r\u001d7jG\u0006\u001cF/\u0019;vg\u000e{W.\\1oIR+7\u000f\u001e\t\u0003_n\u001b2aWA;)\t\u00199)\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\r\u0006\u0003\u0004\u0012\u000eu\u0005\u0003CA\u0018\u0007'\u000bica&\n\t\rU\u0015\u0011\t\u0002\u0004\u001b\u0006\u0004\b\u0003BA%\u00073KAaa'\u0002L\t1qJ\u00196fGRDqaa(^\u0001\u0004\u0019\t+A\u0004tKJ4XM]:\u0011\tMD81\u0015\t\u0004w\u000e\u0015\u0016bABTy\nY1*\u00194lCN+'O^3s\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000f\u0006\u0003\u0002.\r5\u0006bBBP=\u0002\u00071\u0011\u0015")
public final class ReplicaStatusCommandTest
extends KafkaServerTestHarness {
    private volatile ReplicaStatusCommandTest$ReplicaStatusEntry$ ReplicaStatusEntry$module;

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ReplicaStatusCommandTest$.MODULE$.createConfig(seq);
    }

    public ReplicaStatusCommandTest$ReplicaStatusEntry$ ReplicaStatusEntry() {
        if (this.ReplicaStatusEntry$module == null) {
            this.ReplicaStatusEntry$lzycompute$1();
        }
        return this.ReplicaStatusEntry$module;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 3;
        String x$2 = this.zkConnect();
        boolean x$3 = false;
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b")}));
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)x$4, x$13, x$14, x$15, x$16, x$17).map((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            return KafkaConfig$.MODULE$.fromProps(config);
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private void createTopicAndWait(AdminClient client, String topic, Integer numPartitions) {
        NewTopic newTopic = new NewTopic(topic, Optional.of(numPartitions), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)"{\n        \"version\":1,\n        \"replicas\":[{\n          \"count\": 2,\n          \"constraints\":{\"rack\":\"a\"}\n        }],\n        \"observers\":[{\n         \"count\": 1,\n         \"constraints\":{\"rack\":\"b\"}\n        }]\n      }")}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(numPartitions)).foreach((Function1 & Serializable & scala.Serializable)p -> TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topic, BoxesRunTime.unboxToInt((Object)p), TestUtils$.MODULE$.waitForPartitionMetadata$default$4()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicaStatusCommandTest.$anonfun$createTopicAndWait$2(client, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicaStatusCommandTest.$anonfun$createTopicAndWait$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String runCommand(String[] topics, int numPartitions, String[] args) {
        String string;
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ReplicaStatusCommandTest$.MODULE$.createConfig((Seq<KafkaServer>)this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var6_5 = resource_resource;
            string = ReplicaStatusCommandTest.$anonfun$runCommand$1(this, topics, numPartitions, args, (AdminClient)var6_5);
        }
        finally {
            resource_resource.close();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private List<ReplicaStatusEntry> runCommandParseOutput(String[] topics, int numPartitions, String[] args, boolean expectMirrorInfo) {
        String output = this.runCommand(topics, numPartitions, args);
        Scanner scanner = new Scanner(output);
        Assertions.assertTrue((boolean)scanner.hasNextLine());
        String mirrorScan = expectMirrorInfo ? "\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)" : "";
        scanner.findInLine(new StringBuilder(101).append("(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)").append(mirrorScan).toString());
        MatchResult topMatch = scanner.match();
        List headers = ReplicaStatusCommand$.MODULE$.headers(false, expectMirrorInfo);
        Assertions.assertTrue((topMatch.groupCount() == headers.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), headers.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            String string = topMatch.group(idx + 1);
            Object object = headers.apply(idx);
            Assertions.assertTrue((!(string != null ? !string.equals(object) : object != null) ? 1 : 0) != 0);
        });
        scanner.nextLine();
        Buffer result = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String mirrorPattern = expectMirrorInfo ? "\\s+(\\S+)\\s+(-?[0-9]*)\\s+(-?[0-9]*)" : "";
        Pattern pattern = Pattern.compile(new StringBuilder(156).append("(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(true|false)\\s+(true|false)\\s+(true|false)\\s+(true|false)\\s+(true|false)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s+(\\S+)").append(mirrorPattern).toString());
        while (scanner.hasNextLine()) {
            void var16_16;
            void var15_15;
            void var14_14;
            None$ none$;
            None$ none$2;
            None$ none$3;
            scanner.findInLine(pattern);
            MatchResult subMatch = scanner.match();
            Assertions.assertTrue((subMatch.groupCount() == headers.size() ? 1 : 0) != 0);
            if (expectMirrorInfo) {
                none$3 = ReplicaStatusCommandTest.toMirrorState$1(subMatch.group(14));
                none$2 = ReplicaStatusCommandTest.toMirrorLongOption$1(subMatch.group(15));
                none$ = ReplicaStatusCommandTest.toMirrorLongOption$1(subMatch.group(16));
            } else {
                none$3 = None$.MODULE$;
                none$2 = None$.MODULE$;
                none$ = None$.MODULE$;
            }
            None$ none$4 = none$;
            None$ none$5 = none$2;
            Option mirrorState = (Option)none$3;
            Option mirrorLastFetchTimeMs = (Option)none$5;
            Option mirrorLastFetchHighWatermark = (Option)none$4;
            void mirrorState2 = var14_14;
            void mirrorLastFetchTimeMs2 = var15_15;
            void mirrorLastFetchHighWatermark2 = var16_16;
            result.$plus$eq((Object)new ReplicaStatusEntry(this, subMatch.group(1), new StringOps(Predef$.MODULE$.augmentString(subMatch.group(2))).toInt(), new StringOps(Predef$.MODULE$.augmentString(subMatch.group(3))).toInt(), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(4)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(5)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(6)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(7)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(8)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(9)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(10)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(11)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(12)), subMatch.group(13), (Option<String>)mirrorState2, (Option<Object>)mirrorLastFetchTimeMs2, (Option<Object>)mirrorLastFetchHighWatermark2));
            scanner.nextLine();
        }
        return result.toList();
    }

    @Test
    public void testVerboseTopicPartitions() {
        String[] topics = (String[])((Object[])new String[]{"test-topic-1", "test-topic-2"});
        int numPartitions = 2;
        String output = this.runCommand(topics, numPartitions, (String[])((Object[])new String[]{"--verbose"}));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics)).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ReplicaStatusCommandTest.$anonfun$testVerboseTopicPartitions$1(this, numPartitions, output, topic);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)output.contains("IsLeader: true"));
        Assertions.assertTrue((boolean)output.contains("IsLeader: false"));
        Assertions.assertTrue((boolean)output.contains("IsObserver: true"));
        Assertions.assertTrue((boolean)output.contains("IsObserver: false"));
        Assertions.assertTrue((boolean)output.contains("IsIsrEligible: true"));
        Assertions.assertTrue((boolean)output.contains("IsIsrEligible: false"));
    }

    @Test
    public void testSpecifiedTopics() {
        String[] topics = (String[])((Object[])new String[]{"test-topic-1", "test-topic-2", "test-topic-3"});
        String output = this.runCommand(topics, 1, (String[])((Object[])new String[]{"--topics", new StringBuilder(1).append(topics[0]).append(",").append(topics[2]).toString(), "--verbose"}));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(7).append("Topic: ").append(topics[0]).toString()));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(7).append("Topic: ").append(topics[1]).toString()));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(7).append("Topic: ").append(topics[2]).toString()));
    }

    @Test
    public void testSpecifiedPartitions() {
        String[] topics = (String[])((Object[])new String[]{"test-topic"});
        String output = this.runCommand(topics, 4, (String[])((Object[])new String[]{"--partitions", "0,2-3", "--verbose"}));
        Assertions.assertTrue((boolean)output.contains("Partition: 0"));
        Assertions.assertFalse((boolean)output.contains("Partition: 1"));
        Assertions.assertTrue((boolean)output.contains("Partition: 2"));
        Assertions.assertTrue((boolean)output.contains("Partition: 3"));
    }

    @Test
    public void testLeadersOnly() {
        String topic = "test-topic";
        String output = this.runCommand((String[])((Object[])new String[]{topic}), 1, (String[])((Object[])new String[]{"--leaders", "--verbose"}));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 2").toString()));
        Assertions.assertTrue((boolean)output.contains("IsLeader: true"));
        Assertions.assertFalse((boolean)output.contains("IsLeader: false"));
    }

    @Test
    public void testLeadersExcluded() {
        String topic = "test-topic";
        String output = this.runCommand((String[])((Object[])new String[]{topic}), 1, (String[])((Object[])new String[]{"--leaders", "exclude", "--verbose"}));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("Topic: ").append(topic).append("\nPartition: 0\nReplica").toString()));
        Assertions.assertFalse((boolean)output.contains("IsLeader: true"));
        Assertions.assertTrue((boolean)output.contains("IsLeader: false"));
    }

    @Test
    public void testObserversOnly() {
        String topic = "test-topic";
        String output = this.runCommand((String[])((Object[])new String[]{topic}), 1, (String[])((Object[])new String[]{"--observers", "--verbose"}));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 0").toString()));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 1").toString()));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 2").toString()));
        Assertions.assertTrue((boolean)output.contains("IsObserver: true"));
        Assertions.assertFalse((boolean)output.contains("IsObserver: false"));
    }

    @Test
    public void testObserversExcluded() {
        String topic = "test-topic";
        String output = this.runCommand((String[])((Object[])new String[]{topic}), 1, (String[])((Object[])new String[]{"--observers", "exclude", "--verbose"}));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 0").toString()));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 1").toString()));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 2").toString()));
        Assertions.assertFalse((boolean)output.contains("IsObserver: true"));
        Assertions.assertTrue((boolean)output.contains("IsObserver: false"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNotInIsr() {
        void resource_resource;
        String topic = "test-topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map assignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ReplicaStatusCommandTest$.MODULE$.createConfig((Seq<KafkaServer>)this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var6_5 = resource_resource;
            ReplicaStatusCommandTest.$anonfun$testNotInIsr$1(this, topic, assignments, topicPartition, (AdminClient)var6_5);
        }
        finally {
            resource_resource.close();
        }
    }

    private void runTestOutput(String[] args, boolean expectMirrorInfo) {
        List<ReplicaStatusEntry> entries = this.runCommandParseOutput((String[])((Object[])new String[]{"test-topic-1", "test-topic-2"}), 2, args, expectMirrorInfo);
        Assertions.assertEquals((int)12, (int)entries.size());
        Set tpr = (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set leaders = (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        entries.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ReplicaStatusCommandTest.$anonfun$runTestOutput$1(this, tpr, leaders, entry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testOutput() {
        this.runTestOutput((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), false);
    }

    @Test
    public void testOutputIncludeMirror() {
        this.runTestOutput((String[])((Object[])new String[]{"--include-mirror"}), true);
    }

    /*
     * Unable to fully structure code
     */
    private void runTestJson(String[] args, boolean expectClusterLink, boolean expectMirrorInfo) {
        topics = (String[])((Object[])new String[]{"test-topic-1", "test-topic-2"});
        jsonTopics = ((JsonValue)Json$.MODULE$.parseFull(this.runCommand(topics, 2, args)).get()).asJsonArray().iterator();
        headers = ReplicaStatusCommand$.MODULE$.headers(expectClusterLink, expectMirrorInfo);
        topicsCount = 0;
        while (jsonTopics.hasNext()) {
            jsonTopic = ((JsonValue)jsonTopics.next()).asJsonObject();
            ++topicsCount;
            v0 = topic = (String)jsonTopic.apply("Topic").to((DecodeJson)DecodeJson.DecodeString$.MODULE$);
            var10_10 = "test-topic-1";
            if (v0 != null && v0.equals(var10_10)) ** GOTO lbl-1000
            v1 = topic;
            var11_11 = "test-topic-2";
            if (v1 != null && v1.equals(var11_11)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            Assertions.assertTrue((boolean)v2);
            partitionsCount = 0;
            jsonPartitions = jsonTopic.apply("Partitions").asJsonArray().iterator();
            while (jsonPartitions.hasNext()) {
                jsonPartition = ((JsonValue)jsonPartitions.next()).asJsonObject();
                ++partitionsCount;
                partition = BoxesRunTime.unboxToInt((Object)jsonPartition.apply("Partition").to((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
                Assertions.assertTrue((boolean)(partition == 0 || partition == 1));
                replicasCount = 0;
                jsonReplicas = jsonPartition.apply("Replicas").asJsonArray().iterator();
                while (jsonReplicas.hasNext()) {
                    jsonReplica = ((JsonValue)jsonReplicas.next()).asJsonObject();
                    ++replicasCount;
                    replica = BoxesRunTime.unboxToInt((Object)jsonReplica.apply("Replica").to((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
                    Assertions.assertTrue((boolean)(replica >= 0 && replica <= 2));
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), headers.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)V, $anonfun$runTestJson$1(kafka.utils.json.JsonObject scala.collection.immutable.List int ), (I)V)((JsonObject)jsonReplica, (List)headers));
                }
                Assertions.assertTrue((boolean)(replicasCount == 3));
            }
            Assertions.assertTrue((boolean)(partitionsCount == 2));
        }
        Assertions.assertTrue((boolean)(topicsCount == 2));
    }

    @Test
    public void testJson() {
        this.runTestJson((String[])((Object[])new String[]{"--json"}), false, false);
    }

    @Test
    public void testJsonIncludeLinked() {
        this.runTestJson((String[])((Object[])new String[]{"--json", "--include-linked"}), true, false);
    }

    @Test
    public void testJsonIncludeMirror() {
        this.runTestJson((String[])((Object[])new String[]{"--json", "--include-mirror"}), false, true);
    }

    @Test
    public void testMissingArgs() {
        try {
            ReplicaStatusCommand$.MODULE$.main((String[])((Object[])new String[]{"--topics", "test-topic"}));
            Assertions.fail();
            return;
        }
        catch (Throwable throwable) {
            Assertions.assertTrue((boolean)throwable.getMessage().startsWith("Missing required option(s)"));
            return;
        }
    }

    private void testInvalidArgs(String[] args, String expectedErrorPrefixStr) {
        try {
            ReplicaStatusCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.listenerName())})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            Assertions.fail();
            return;
        }
        catch (Throwable throwable) {
            Assertions.assertTrue((boolean)throwable.getMessage().startsWith(expectedErrorPrefixStr));
            return;
        }
    }

    @Test
    public void testInvalidTopics() {
        this.testInvalidArgs((String[])((Object[])new String[]{"--topics"}), "Option topics requires an argument");
        this.testInvalidArgs((String[])((Object[])new String[]{"--topics", ""}), "Topic name");
        this.testInvalidArgs((String[])((Object[])new String[]{"--topics", "."}), "Topic name");
        this.testInvalidArgs((String[])((Object[])new String[]{"--topics", "invalid-1:topic"}), "Topic name");
    }

    @Test
    public void testInvalidPartitionsArg() {
        this.testInvalidRange$1("2-1");
        this.testInvalidRange$1("1-3-5");
        this.testInvalidValue$1("");
        this.testInvalidValue$1("abc");
    }

    private final void ReplicaStatusEntry$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicaStatusEntry$module == null) {
                this.ReplicaStatusEntry$module = new ReplicaStatusCommandTest$ReplicaStatusEntry$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndWait$3(TopicPartitionInfo x$1) {
        return x$1.leader() != null;
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndWait$2(AdminClient client$1, String topic$1) {
        TopicDescription topicDescription = (TopicDescription)((java.util.Map)client$1.describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava()).allTopicNames().get()).get(topic$1);
        boolean bl = topicDescription == null ? false : ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommandTest.$anonfun$createTopicAndWait$3(x$1)));
        return bl;
    }

    public static final /* synthetic */ String $anonfun$createTopicAndWait$4() {
        return "Failed to create topic";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ String $anonfun$runCommand$1(ReplicaStatusCommandTest $this, String[] topics$1, int numPartitions$1, String[] args$1, AdminClient client) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topics$1)).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            $this.createTopicAndWait(client, x$2, Predef$.MODULE$.int2Integer(numPartitions$1));
            return BoxedUnit.UNIT;
        });
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ReplicaStatusCommand$.MODULE$.main((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.listenerName())})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private static final boolean toBoolean$1(String value) {
        boolean bl;
        if ("true".equals(value)) {
            bl = true;
        } else if ("false".equals(value)) {
            bl = false;
        } else {
            throw new MatchError((Object)value);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final long toLong$1(String value) {
        void var1_1;
        long num = new StringOps(Predef$.MODULE$.augmentString(value)).toLong();
        Assertions.assertTrue((num >= 0L ? 1 : 0) != 0);
        return (long)var1_1;
    }

    private static final Option toLongOption$1(String value) {
        String string = value;
        String string2 = "-1";
        if (string != null && string.equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)ReplicaStatusCommandTest.toLong$1(value)));
    }

    private static final Option toMirrorState$1(String value) {
        String string = value;
        String string2 = "-";
        if (string != null && string.equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)value);
    }

    private static final Option toMirrorLongOption$1(String value) {
        block3: {
            block2: {
                String string = value;
                String string2 = "-";
                if (string != null && string.equals(string2)) break block2;
                String string3 = value;
                String string4 = "-1";
                if (string3 == null || !string3.equals(string4)) break block3;
            }
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)ReplicaStatusCommandTest.toLong$1(value)));
    }

    public static final /* synthetic */ void $anonfun$testVerboseTopicPartitions$1(ReplicaStatusCommandTest $this, int numPartitions$2, String output$1, String topic) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions$2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.servers().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replica -> {
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(7).append("Topic: ").append(topic).toString()));
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(11).append("Partition: ").append(partition).toString()));
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(9).append("Replica: ").append(replica).toString()));
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testNotInIsr$1(ReplicaStatusCommandTest $this, String topic$3, scala.collection.immutable.Map assignments$1, TopicPartition topicPartition$1, AdminClient client) {
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic$3, (Map<Object, Seq<Object>>)assignments$1, (Seq<KafkaBroker>)$this.servers());
        ((KafkaServer)$this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        TestUtils$.MODULE$.waitForLeaderToBecome((Admin)client, topicPartition$1, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        TestUtils$.MODULE$.produceMessage($this.servers(), topic$3, "message", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ReplicaStatusCommand$.MODULE$.main((String[])((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.listenerName()), "--leaders", "exclude", "--verbose"}));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertFalse((boolean)string.contains(new StringBuilder(31).append("Topic: ").append(topic$3).append("\nPartition: 0\nReplica: 0").toString()));
        Assertions.assertFalse((boolean)string.contains("IsInIsr: true"));
        Assertions.assertTrue((boolean)string.contains(new StringBuilder(31).append("Topic: ").append(topic$3).append("\nPartition: 0\nReplica: 1").toString()));
        Assertions.assertTrue((boolean)string.contains("IsInIsr: false"));
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$2(long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$3(ReplicaStatusEntry entry$1, long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)entry$1.isCaughtUp());
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$4(long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$5(long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ Option $anonfun$runTestOutput$6(ReplicaStatusEntry entry$1, long logStartOffset) {
        return entry$1.logEndOffset().map((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)logEndOffset -> Assertions.assertTrue((logStartOffset <= logEndOffset ? 1 : 0) != 0));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$runTestOutput$1(ReplicaStatusCommandTest $this, Set tpr$1, Set leaders$1, ReplicaStatusEntry entry) {
        v0 = entry.topic();
        var4_4 = "test-topic-1";
        if (v0 != null && v0.equals(var4_4)) ** GOTO lbl-1000
        v1 = entry.topic();
        var5_5 = "test-topic-2";
        if (v1 != null && v1.equals(var5_5)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)v2);
        Assertions.assertTrue((boolean)(entry.partition() == 0 || entry.partition() == 1));
        Assertions.assertTrue((boolean)(entry.replica() >= 0 && entry.replica() < $this.servers().size()));
        Assertions.assertTrue((boolean)tpr$1.add((Object)new StringBuilder(2).append(entry.topic()).append("-").append(entry.partition()).append("-").append(entry.replica()).toString()));
        if (entry.isLeader()) {
            Assertions.assertTrue((boolean)leaders$1.add((Object)new StringBuilder(1).append(entry.topic()).append("-").append(entry.partition()).toString()));
            Assertions.assertTrue((boolean)entry.isInIsr());
            Assertions.assertTrue((boolean)entry.isCaughtUp());
            Assertions.assertNotEquals((Object)"\"N/A\"", (Object)entry.leaderEpoch());
        } else {
            Assertions.assertEquals((Object)"\"N/A\"", (Object)entry.leaderEpoch());
        }
        if (entry.replica() == 2) {
            Assertions.assertTrue((boolean)entry.isObserver());
            Assertions.assertFalse((boolean)entry.isIsrEligible());
        } else {
            Assertions.assertFalse((boolean)entry.isObserver());
            Assertions.assertTrue((boolean)entry.isIsrEligible());
            Assertions.assertTrue((boolean)entry.isInIsr());
        }
        entry.lastCaughtUpLagMs().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$2(long ), (J)V)());
        entry.lastFetchLagMs().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$3(kafka.admin.ReplicaStatusCommandTest$ReplicaStatusEntry long ), (J)V)((ReplicaStatusEntry)entry));
        entry.logStartOffset().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$4(long ), (J)V)());
        entry.logEndOffset().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$5(long ), (J)V)());
        entry.logStartOffset().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$runTestOutput$6$adapted(kafka.admin.ReplicaStatusCommandTest$ReplicaStatusEntry java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)((ReplicaStatusEntry)entry));
        Assertions.assertEquals((Object)None$.MODULE$, entry.mirrorState());
        Assertions.assertEquals((Object)None$.MODULE$, entry.mirrorLastFetchTimeMs());
        Assertions.assertEquals((Object)None$.MODULE$, entry.mirrorLastFetchHighWatermark());
    }

    public static final /* synthetic */ void $anonfun$runTestJson$1(JsonObject jsonReplica$1, List headers$2, int idx) {
        Assertions.assertTrue((jsonReplica$1.apply((String)headers$2.apply(idx)) != null ? 1 : 0) != 0);
    }

    private final void testInvalidRange$1(String partitionStr) {
        this.testInvalidArgs((String[])((Object[])new String[]{"--partitions", partitionStr}), "Invalid partition range");
    }

    private final void testInvalidValue$1(String partitionStr) {
        this.testInvalidArgs((String[])((Object[])new String[]{"--partitions", partitionStr}), "Failed to parse partition");
    }

    public static final /* synthetic */ Object $anonfun$testNotInIsr$1$adapted(ReplicaStatusCommandTest $this, String topic$3, scala.collection.immutable.Map assignments$1, TopicPartition topicPartition$1, AdminClient client) {
        ReplicaStatusCommandTest.$anonfun$testNotInIsr$1($this, topic$3, assignments$1, topicPartition$1, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Option $anonfun$runTestOutput$6$adapted(ReplicaStatusEntry entry$1, Object logStartOffset) {
        return ReplicaStatusCommandTest.$anonfun$runTestOutput$6(entry$1, BoxesRunTime.unboxToLong((Object)logStartOffset));
    }

    public class ReplicaStatusEntry
    implements Product,
    scala.Serializable {
        private final String topic;
        private final int partition;
        private final int replica;
        private final boolean isLeader;
        private final boolean isObserver;
        private final boolean isIsrEligible;
        private final boolean isInIsr;
        private final boolean isCaughtUp;
        private final Option<Object> lastCaughtUpLagMs;
        private final Option<Object> lastFetchLagMs;
        private final Option<Object> logStartOffset;
        private final Option<Object> logEndOffset;
        private final String leaderEpoch;
        private final Option<String> mirrorState;
        private final Option<Object> mirrorLastFetchTimeMs;
        private final Option<Object> mirrorLastFetchHighWatermark;
        public final /* synthetic */ ReplicaStatusCommandTest $outer;

        public String topic() {
            return this.topic;
        }

        public int partition() {
            return this.partition;
        }

        public int replica() {
            return this.replica;
        }

        public boolean isLeader() {
            return this.isLeader;
        }

        public boolean isObserver() {
            return this.isObserver;
        }

        public boolean isIsrEligible() {
            return this.isIsrEligible;
        }

        public boolean isInIsr() {
            return this.isInIsr;
        }

        public boolean isCaughtUp() {
            return this.isCaughtUp;
        }

        public Option<Object> lastCaughtUpLagMs() {
            return this.lastCaughtUpLagMs;
        }

        public Option<Object> lastFetchLagMs() {
            return this.lastFetchLagMs;
        }

        public Option<Object> logStartOffset() {
            return this.logStartOffset;
        }

        public Option<Object> logEndOffset() {
            return this.logEndOffset;
        }

        public String leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<String> mirrorState() {
            return this.mirrorState;
        }

        public Option<Object> mirrorLastFetchTimeMs() {
            return this.mirrorLastFetchTimeMs;
        }

        public Option<Object> mirrorLastFetchHighWatermark() {
            return this.mirrorLastFetchHighWatermark;
        }

        public ReplicaStatusEntry copy(String topic, int partition, int replica, boolean isLeader, boolean isObserver, boolean isIsrEligible, boolean isInIsr, boolean isCaughtUp, Option<Object> lastCaughtUpLagMs, Option<Object> lastFetchLagMs, Option<Object> logStartOffset, Option<Object> logEndOffset, String leaderEpoch, Option<String> mirrorState, Option<Object> mirrorLastFetchTimeMs, Option<Object> mirrorLastFetchHighWatermark) {
            return new ReplicaStatusEntry(this.kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer(), topic, partition, replica, isLeader, isObserver, isIsrEligible, isInIsr, isCaughtUp, lastCaughtUpLagMs, lastFetchLagMs, logStartOffset, logEndOffset, leaderEpoch, mirrorState, mirrorLastFetchTimeMs, mirrorLastFetchHighWatermark);
        }

        public String copy$default$1() {
            return this.topic();
        }

        public Option<Object> copy$default$10() {
            return this.lastFetchLagMs();
        }

        public Option<Object> copy$default$11() {
            return this.logStartOffset();
        }

        public Option<Object> copy$default$12() {
            return this.logEndOffset();
        }

        public String copy$default$13() {
            return this.leaderEpoch();
        }

        public Option<String> copy$default$14() {
            return this.mirrorState();
        }

        public Option<Object> copy$default$15() {
            return this.mirrorLastFetchTimeMs();
        }

        public Option<Object> copy$default$16() {
            return this.mirrorLastFetchHighWatermark();
        }

        public int copy$default$2() {
            return this.partition();
        }

        public int copy$default$3() {
            return this.replica();
        }

        public boolean copy$default$4() {
            return this.isLeader();
        }

        public boolean copy$default$5() {
            return this.isObserver();
        }

        public boolean copy$default$6() {
            return this.isIsrEligible();
        }

        public boolean copy$default$7() {
            return this.isInIsr();
        }

        public boolean copy$default$8() {
            return this.isCaughtUp();
        }

        public Option<Object> copy$default$9() {
            return this.lastCaughtUpLagMs();
        }

        public String productPrefix() {
            return "ReplicaStatusEntry";
        }

        public int productArity() {
            return 16;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.topic();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.partition());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this.replica());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isLeader());
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isObserver());
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isIsrEligible());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isInIsr());
                }
                case 7: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isCaughtUp());
                }
                case 8: {
                    return this.lastCaughtUpLagMs();
                }
                case 9: {
                    return this.lastFetchLagMs();
                }
                case 10: {
                    return this.logStartOffset();
                }
                case 11: {
                    return this.logEndOffset();
                }
                case 12: {
                    return this.leaderEpoch();
                }
                case 13: {
                    return this.mirrorState();
                }
                case 14: {
                    return this.mirrorLastFetchTimeMs();
                }
                case 15: {
                    return this.mirrorLastFetchHighWatermark();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicaStatusEntry;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.topic())), (int)this.partition()), (int)this.replica()), (int)(this.isLeader() ? 1231 : 1237)), (int)(this.isObserver() ? 1231 : 1237)), (int)(this.isIsrEligible() ? 1231 : 1237)), (int)(this.isInIsr() ? 1231 : 1237)), (int)(this.isCaughtUp() ? 1231 : 1237)), (int)Statics.anyHash(this.lastCaughtUpLagMs())), (int)Statics.anyHash(this.lastFetchLagMs())), (int)Statics.anyHash(this.logStartOffset())), (int)Statics.anyHash(this.logEndOffset())), (int)Statics.anyHash((Object)this.leaderEpoch())), (int)Statics.anyHash(this.mirrorState())), (int)Statics.anyHash(this.mirrorLastFetchTimeMs())), (int)Statics.anyHash(this.mirrorLastFetchHighWatermark())), (int)16);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ReplicaStatusEntry)) return false;
            if (((ReplicaStatusEntry)x$1).kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer() != this.kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ReplicaStatusEntry replicaStatusEntry = (ReplicaStatusEntry)x$1;
            String string = this.topic();
            String string2 = replicaStatusEntry.topic();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.partition() != replicaStatusEntry.partition()) return false;
            if (this.replica() != replicaStatusEntry.replica()) return false;
            if (this.isLeader() != replicaStatusEntry.isLeader()) return false;
            if (this.isObserver() != replicaStatusEntry.isObserver()) return false;
            if (this.isIsrEligible() != replicaStatusEntry.isIsrEligible()) return false;
            if (this.isInIsr() != replicaStatusEntry.isInIsr()) return false;
            if (this.isCaughtUp() != replicaStatusEntry.isCaughtUp()) return false;
            Option<Object> option = this.lastCaughtUpLagMs();
            Option<Object> option2 = replicaStatusEntry.lastCaughtUpLagMs();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.lastFetchLagMs();
            Option<Object> option4 = replicaStatusEntry.lastFetchLagMs();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Object> option5 = this.logStartOffset();
            Option<Object> option6 = replicaStatusEntry.logStartOffset();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<Object> option7 = this.logEndOffset();
            Option<Object> option8 = replicaStatusEntry.logEndOffset();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            String string3 = this.leaderEpoch();
            String string4 = replicaStatusEntry.leaderEpoch();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option9 = this.mirrorState();
            Option<String> option10 = replicaStatusEntry.mirrorState();
            if (option9 == null) {
                if (option10 != null) {
                    return false;
                }
            } else if (!option9.equals(option10)) return false;
            Option<Object> option11 = this.mirrorLastFetchTimeMs();
            Option<Object> option12 = replicaStatusEntry.mirrorLastFetchTimeMs();
            if (option11 == null) {
                if (option12 != null) {
                    return false;
                }
            } else if (!option11.equals(option12)) return false;
            Option<Object> option13 = this.mirrorLastFetchHighWatermark();
            Option<Object> option14 = replicaStatusEntry.mirrorLastFetchHighWatermark();
            if (option13 == null) {
                if (option14 != null) {
                    return false;
                }
            } else if (!option13.equals(option14)) return false;
            if (!replicaStatusEntry.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReplicaStatusCommandTest kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer() {
            return this.$outer;
        }

        public ReplicaStatusEntry(ReplicaStatusCommandTest $outer, String topic, int partition, int replica, boolean isLeader, boolean isObserver, boolean isIsrEligible, boolean isInIsr, boolean isCaughtUp, Option<Object> lastCaughtUpLagMs, Option<Object> lastFetchLagMs, Option<Object> logStartOffset, Option<Object> logEndOffset, String leaderEpoch, Option<String> mirrorState, Option<Object> mirrorLastFetchTimeMs, Option<Object> mirrorLastFetchHighWatermark) {
            this.topic = topic;
            this.partition = partition;
            this.replica = replica;
            this.isLeader = isLeader;
            this.isObserver = isObserver;
            this.isIsrEligible = isIsrEligible;
            this.isInIsr = isInIsr;
            this.isCaughtUp = isCaughtUp;
            this.lastCaughtUpLagMs = lastCaughtUpLagMs;
            this.lastFetchLagMs = lastFetchLagMs;
            this.logStartOffset = logStartOffset;
            this.logEndOffset = logEndOffset;
            this.leaderEpoch = leaderEpoch;
            this.mirrorState = mirrorState;
            this.mirrorLastFetchTimeMs = mirrorLastFetchTimeMs;
            this.mirrorLastFetchHighWatermark = mirrorLastFetchHighWatermark;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

