/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0011Ea\u0001\u0002$H\u00011CQ!\u0018\u0001\u0005\u0002yCQ\u0001\u0019\u0001\u0005B\u0005Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004w\u0001\u0001\u0006IA\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u0019a\b\u0001)A\u0005s\"IQ\u0010\u0001a\u0001\u0002\u0004%IA \u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0002\u0003\u0006\u0002*\u0001\u0001\r\u0011!Q!\n}D1\"a\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.!Y\u0011q\t\u0001A\u0002\u0003\u0007I\u0011BA%\u0011-\ti\u0005\u0001a\u0001\u0002\u0003\u0006K!a\f\t\u0017\u0005=\u0003\u00011AA\u0002\u0013%\u0011\u0011\u000b\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0007C\u0006\u0002j\u0001\u0001\r\u0011!Q!\n\u0005M\u0003\u0002CA6\u0001\u0001&I!!\u001c\t\u0011\u0005e\u0004\u0001)C\u0005\u0003wB\u0011\"!\"\u0001#\u0003%I!a\"\t\u000f\u0005u\u0005\u0001\"\u0011\u0002 \"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAg\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqAa\u0007\u0001\t\u0003\u0011i\u0002C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005/\u0002A\u0011\u0001B-\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KBqAa\u001c\u0001\t\u0003\u0011\t\bC\u0004\u0003|\u0001!\tA! \t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\"9!1\u0013\u0001\u0005\u0002\tU\u0005b\u0002BP\u0001\u0011\u0005!\u0011\u0015\u0005\b\u0005W\u0003A\u0011\u0001BW\u0011\u001d\u00119\f\u0001C\u0001\u0005sCqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003P\u0002!\tA!5\t\u000f\tm\u0007\u0001\"\u0001\u0003^\"9!q\u001d\u0001\u0005\u0002\t%\bb\u0002Bz\u0001\u0011\u0005!Q\u001f\u0005\b\u0005\u007f\u0004A\u0011AB\u0001\u0011\u001d\u0019Y\u0001\u0001C\u0001\u0007\u001bAqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004$\u0001!\ta!\n\t\u000f\r=\u0002\u0001\"\u0001\u00042!911\b\u0001\u0005\u0002\ru\u0002bBB$\u0001\u0011\u00051\u0011\n\u0005\b\u0007'\u0002A\u0011AB+\u0011\u001d\u0019y\u0006\u0001C\u0001\u0007CBqaa\u001b\u0001\t\u0003\u0019i\u0007C\u0004\u0004x\u0001!\ta!\u001f\t\u000f\r\r\u0005\u0001\"\u0001\u0004\u0006\"91q\u0012\u0001\u0005\u0002\rE\u0005bBBN\u0001\u0011\u0005\u00111\u0019\u0005\b\u0007K\u0003A\u0011AAb\u0011\u001d\u0019I\u000b\u0001C\u0001\u0003\u0007Dqa!,\u0001\t\u0003\t\u0019\rC\u0004\u00042\u0002!\t!a1\t\u000f\rU\u0006\u0001\"\u0001\u0002D\"91\u0011\u0018\u0001\u0005\u0002\u0005\r\u0007bBB_\u0001\u0011\u00051q\u0018\u0005\b\u0007\u0013\u0004A\u0011ABf\u0011\u001d\u0019)\u000e\u0001C\u0001\u0007/Dqa!9\u0001\t\u0003\u0019\u0019\u000fC\u0004\u0004n\u0002!\taa<\t\u000f\re\b\u0001\"\u0001\u0004|\"9AQ\u0001\u0001\u0005\u0002\u0011\u001d!a\u0007+pa&\u001c7i\\7nC:$\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002I\u0013\u0006)\u0011\rZ7j]*\t!*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001i5+\u0017\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!&\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011!k\u0014\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011AkV\u0007\u0002+*\u0011a+S\u0001\u0006kRLGn]\u0005\u00031V\u0013q\u0001T8hO&tw\r\u0005\u0002[76\tq)\u0003\u0002]\u000f\ni!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#A0\u0011\u0005i\u0003\u0011aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\t\u00042a\u00195k\u001b\u0005!'BA3g\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002O\u0006)1oY1mC&\u0011\u0011\u000e\u001a\u0002\u0004'\u0016\f\bCA6o\u001b\u0005a'BA7J\u0003\u0019\u0019XM\u001d<fe&\u0011q\u000e\u001c\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002eB\u00111\u000f^\u0007\u0002M&\u0011QO\u001a\u0002\u0004\u0013:$\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0019I\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014X#A=\u0011\u0005MT\u0018BA>g\u0005\u0015\u0019\u0006n\u001c:u\u0003e!WMZ1vYR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002\u0019Q|\u0007/[2TKJ4\u0018nY3\u0016\u0003}\u0004B!!\u0001\u0002\u00169!\u00111AA\t\u001d\u0011\t)!a\u0004\u000f\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003L\u0003\u0019a$o\\8u}%\t!*\u0003\u0002I\u0013&\u0019\u00111C$\u0002\u0019Q{\u0007/[2D_6l\u0017M\u001c3\n\t\u0005]\u0011\u0011\u0004\u0002\r)>\u0004\u0018nY*feZL7-\u001a\u0006\u0004\u0003'9\u0015\u0001\u0005;pa&\u001c7+\u001a:wS\u000e,w\fJ3r)\u0011\ty\"!\n\u0011\u0007M\f\t#C\u0002\u0002$\u0019\u0014A!\u00168ji\"A\u0011q\u0005\u0005\u0002\u0002\u0003\u0007q0A\u0002yIE\nQ\u0002^8qS\u000e\u001cVM\u001d<jG\u0016\u0004\u0013aC1e[&t7\t\\5f]R,\"!a\f\u0011\t\u0005E\u00121I\u0007\u0003\u0003gQ1\u0001SA\u001b\u0015\u0011\t9$!\u000f\u0002\u000f\rd\u0017.\u001a8ug*\u0019!*a\u000f\u000b\t\u0005u\u0012qH\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u0005\u0013aA8sO&!\u0011QIA\u001a\u0005\u0015\tE-\\5o\u0003=\tG-\\5o\u00072LWM\u001c;`I\u0015\fH\u0003BA\u0010\u0003\u0017B\u0011\"a\n\f\u0003\u0003\u0005\r!a\f\u0002\u0019\u0005$W.\u001b8DY&,g\u000e\u001e\u0011\u0002\u001bQ,7\u000f\u001e+pa&\u001cg*Y7f+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005uc\u0002BA,\u00033\u00022!a\u0002g\u0013\r\tYFZ\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0013\u0011\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mc-A\tuKN$Hk\u001c9jG:\u000bW.Z0%KF$B!a\b\u0002h!I\u0011q\u0005\b\u0002\u0002\u0003\u0007\u00111K\u0001\u000fi\u0016\u001cH\u000fV8qS\u000et\u0015-\\3!\u0003I\u0019'/Z1uK\u0006sGmV1jiR{\u0007/[2\u0015\t\u0005}\u0011q\u000e\u0005\b\u0003c\u0002\u0002\u0019AA:\u0003\u0011y\u0007\u000f^:\u0011\t\u0005\u0005\u0011QO\u0005\u0005\u0003o\nIBA\nU_BL7mQ8n[\u0006tGm\u00149uS>t7/A\nxC&$hi\u001c:U_BL7m\u0011:fCR,G\r\u0006\u0004\u0002 \u0005u\u0014\u0011\u0011\u0005\b\u0003\u007f\n\u0002\u0019AA*\u0003%!x\u000e]5d\u001d\u0006lW\r\u0003\u0005\u0002\u0004F\u0001\n\u00111\u0001s\u0003\u001d!\u0018.\\3pkR\fQd^1ji\u001a{'\u000fV8qS\u000e\u001c%/Z1uK\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013S3A]AFW\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\u0013Ut7\r[3dW\u0016$'bAALM\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!B:fiV\u0003H\u0003BA\u0010\u0003CCq!a)\u0014\u0001\u0004\t)+\u0001\u0003j]\u001a|\u0007\u0003BAT\u0003kk!!!+\u000b\t\u0005-\u0016QV\u0001\u0004CBL'\u0002BAX\u0003c\u000bqA[;qSR,'O\u0003\u0003\u00024\u0006}\u0012!\u00026v]&$\u0018\u0002BA\\\u0003S\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0004'\u0005m\u0006\u0003BAT\u0003{KA!a0\u0002*\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u000b\rdwn]3\u0015\u0005\u0005}\u0001f\u0001\u000b\u0002HB!\u0011qUAe\u0013\u0011\tY-!+\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0003;fgR\u001c%/Z1uKR!\u0011qDAi\u0011\u001d\t\u0019.\u0006a\u0001\u0003'\na!];peVl\u0007fB\u000b\u0002X\u0006\u001d\u0018\u0011\u001e\t\u0005\u00033\f\u0019/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003!\u0001(o\u001c<jI\u0016\u0014(\u0002BAq\u0003[\u000ba\u0001]1sC6\u001c\u0018\u0002BAs\u00037\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BAv\u0003_\f#!!<\u0002\u0005i\\\u0017EAAy\u0003\u0015Y'/\u00194uQ\u001d)\u0012Q_A\u007f\u0003\u007f\u0004B!a>\u0002z6\u0011\u0011q\\\u0005\u0005\u0003w\fyNA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\u0012!\u0011A\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018A\u0006;fgR\u001c%/Z1uK^KG\u000f\u001b#fM\u0006,H\u000e^:\u0015\t\u0005}!q\u0001\u0005\b\u0003'4\u0002\u0019AA*Q\u001d1\u0012q[At\u0005\u0017aC!a;\u0002p\":a#!>\u0002~\u0006}\u0018\u0001\t;fgR\u001c%/Z1uK^KG\u000f\u001b#fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:$B!a\b\u0003\u0014!9\u00111[\fA\u0002\u0005M\u0003fB\f\u0002X\u0006\u001d(q\u0003\u0017\u0005\u0003W\fy\u000fK\u0004\u0018\u0003k\fi0a@\u0002?Q,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002 \t}\u0001bBAj1\u0001\u0007\u00111\u000b\u0015\b1\u0005]\u0017q\u001dB\u0012Y\u0011\tY/a<)\u000fa\t)0!@\u0002\u0000\u0006)B/Z:u\u0007J,\u0017\r^3XSRD7i\u001c8gS\u001e\u001cH\u0003BA\u0010\u0005WAq!a5\u001a\u0001\u0004\t\u0019\u0006K\u0004\u001a\u0003/\f9Oa\f-\t\u0005-\u0018q\u001e\u0015\b3\u0005U\u0018Q`A\u0000\u0003m!Xm\u001d;De\u0016\fG/Z,iK:\fEN]3bIf,\u00050[:ugR!\u0011q\u0004B\u001c\u0011\u001d\t\u0019N\u0007a\u0001\u0003'BsAGAl\u0003O\u0014Y\u0004\f\u0003\u0002l\u0006=\bf\u0002\u000e\u0002v\u0006u\u0018q`\u0001+i\u0016\u001cHo\u0011:fCR,w\u000b[3o\u00032\u0014X-\u00193z\u000bbL7\u000f^:XSRD\u0017J\u001a(pi\u0016C\u0018n\u001d;t)\u0011\tyBa\u0011\t\u000f\u0005M7\u00041\u0001\u0002T!:1$a6\u0002h\n\u001dC\u0006BAv\u0003_DsaGA{\u0003{\fy0A\u0010uKN$8I]3bi\u0016<\u0016\u000e\u001e5SKBd\u0017nY1BgNLwM\\7f]R$B!a\b\u0003P!9\u00111\u001b\u000fA\u0002\u0005M\u0003f\u0002\u000f\u0002X\u0006\u001d(1\u000b\u0017\u0005\u0003W\fy\u000fK\u0004\u001d\u0003k\fi0a@\u0002MQ,7\u000f^\"sK\u0006$XmV5uQ&sg/\u00197jIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0006\u0003\u0002 \tm\u0003bBAj;\u0001\u0007\u00111\u000b\u0015\b;\u0005]\u0017q\u001dB0Y\u0011\tY/a<)\u000fu\t)0!@\u0002\u0000\u00069C/Z:u\u0007J,\u0017\r^3XSRDg*Z4bi&4XMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s)\u0011\tyBa\u001a\t\u000f\u0005Mg\u00041\u0001\u0002T!:a$a6\u0002h\n-D\u0006BAv\u0003_DsAHA{\u0003{\fy0\u0001\u0013uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u)\u0011\tyBa\u001d\t\u000f\u0005Mw\u00041\u0001\u0002T!:q$a6\u0002h\n]D\u0006BAv\u0003_DsaHA{\u0003{\fy0A\u000euKN$\u0018J\u001c<bY&$Gk\u001c9jG2+g/\u001a7D_:4\u0017n\u001a\u000b\u0005\u0003?\u0011y\bC\u0004\u0002T\u0002\u0002\r!a\u0015)\u000f\u0001\n9.a:\u0003\u00042\"\u00111^AxQ\u001d\u0001\u0013Q_A\u007f\u0003\u007f\fa\u0002^3ti2K7\u000f\u001e+pa&\u001c7\u000f\u0006\u0003\u0002 \t-\u0005bBAjC\u0001\u0007\u00111\u000b\u0015\bC\u0005]\u0017q\u001dBHY\u0011\tY/a<)\u000f\u0005\n)0!@\u0002\u0000\u0006iB/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i\u0013:\u001cG.\u001e3f\u0019&\u001cH\u000f\u0006\u0003\u0002 \t]\u0005bBAjE\u0001\u0007\u00111\u000b\u0015\bE\u0005]\u0017q\u001dBNY\u0011\tY/a<)\u000f\t\n)0!@\u0002\u0000\u0006\tC/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i\u000bb\u001cG.\u001e3f\u0013:$XM\u001d8bYR!\u0011q\u0004BR\u0011\u001d\t\u0019n\ta\u0001\u0003'BsaIAl\u0003O\u00149\u000b\f\u0003\u0002l\u0006=\bfB\u0012\u0002v\u0006u\u0018q`\u0001\u0018i\u0016\u001cH/\u00117uKJ\u0004\u0016M\u001d;ji&|gnQ8v]R$B!a\b\u00030\"9\u00111\u001b\u0013A\u0002\u0005M\u0003f\u0002\u0013\u0002X\u0006\u001d(1\u0017\u0017\u0005\u0003W\fy\u000fK\u0004%\u0003k\fi0a@\u0002'Q,7\u000f^!mi\u0016\u0014\u0018i]:jO:lWM\u001c;\u0015\t\u0005}!1\u0018\u0005\b\u0003',\u0003\u0019AA*Q\u001d)\u0013q[At\u0005\u007fcC!a;\u0002p\":Q%!>\u0002~\u0006}\u0018a\r;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001b>\u0014X-Q:tS\u001etW.\u001a8u)\"\fg\u000eU1si&$\u0018n\u001c8t)\u0011\tyBa2\t\u000f\u0005Mg\u00051\u0001\u0002T!:a%a6\u0002h\n-G\u0006BAv\u0003_DsAJA{\u0003{\fy0A\u001auKN$\u0018\t\u001c;fe\u0006\u001b8/[4o[\u0016tGoV5uQ6{'/\u001a)beRLG/[8ogRC\u0017M\\!tg&<g.\\3oiR!\u0011q\u0004Bj\u0011\u001d\t\u0019n\na\u0001\u0003'BsaJAl\u0003O\u00149\u000e\f\u0003\u0002l\u0006=\bfB\u0014\u0002v\u0006u\u0018q`\u0001#i\u0016\u001cH/\u00117uKJ<\u0016\u000e\u001e5J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0015\t\u0005}!q\u001c\u0005\b\u0003'D\u0003\u0019AA*Q\u001dA\u0013q[At\u0005GdC!a;\u0002p\":\u0001&!>\u0002~\u0006}\u0018!\b;fgR\fE\u000e^3s/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;\u0015\t\u0005}!1\u001e\u0005\b\u0003'L\u0003\u0019AA*Q\u001dI\u0013q[At\u0005_dC!a;\u0002p\":\u0011&!>\u0002~\u0006}\u0018!\u000b;fgR\fE\u000e^3s/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000f\u0006\u0003\u0002 \t]\bbBAjU\u0001\u0007\u00111\u000b\u0015\bU\u0005]\u0017q\u001dB~Y\u0011\tY/a<)\u000f)\n)0!@\u0002\u0000\u0006\tC/Z:u\u0007J,\u0017\r^3BYR,'\u000fV8qS\u000e<\u0016\u000e\u001e5SC\u000e\\\u0017i^1sKR!\u0011qDB\u0002\u0011\u001d\t\u0019n\u000ba\u0001\u0003'BsaKAl\u0003O\u001c9\u0001\f\u0003\u0002l\u0006=\bfB\u0016\u0002v\u0006u\u0018q`\u00010i\u0016\u001cHoQ8oM&<\u0007K]3tKJ4\u0018\r^5p]\u0006\u001b'o\\:t!\u0006\u0014H/\u001b;j_:\fE\u000e^3sCRLwN\u001c\u000b\u0005\u0003?\u0019y\u0001C\u0004\u0002T2\u0002\r!a\u0015)\u000f1\n9.a:\u0004\u00141\"\u00111^AxQ\u001da\u0013Q_A\u007f\u0003\u007f\f\u0011\u0003^3tiR{\u0007/[2EK2,G/[8o)\u0011\tyba\u0007\t\u000f\u0005MW\u00061\u0001\u0002T!:Q&a6\u0002h\u000e}A\u0006BAv\u0003_Ds!LA{\u0003{\fy0\u0001\u0019uKN$Hk\u001c9jG^KG\u000f[\"pY2LG-\u001b8h\u0007\"\f'\u000fR3mKRLwN\\!oI\u000e\u0013X-\u0019;f\u0003\u001e\f\u0017N\u001c\u000b\u0005\u0003?\u00199\u0003C\u0004\u0002T:\u0002\r!a\u0015)\u000f9\n9.a:\u0004,1\"\u00111^AxQ\u001dq\u0013Q_A\u007f\u0003\u007f\fq\u0003^3ti\u0012+G.\u001a;f\u0013:$XM\u001d8bYR{\u0007/[2\u0015\t\u0005}11\u0007\u0005\b\u0003'|\u0003\u0019AA*Q\u001dy\u0013q[At\u0007oaC!a;\u0002p\":q&!>\u0002~\u0006}\u0018A\b;fgR$U\r\\3uK^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:u)\u0011\tyba\u0010\t\u000f\u0005M\u0007\u00071\u0001\u0002T!:\u0001'a6\u0002h\u000e\rC\u0006BAv\u0003_Ds\u0001MA{\u0003{\fy0\u0001\u0016uKN$H)\u001a7fi\u0016<\u0006.\u001a8U_BL7\rR8fg:$X\t_5ti^KG\u000f[%g\u000bbL7\u000f^:\u0015\t\u0005}11\n\u0005\b\u0003'\f\u0004\u0019AA*Q\u001d\t\u0014q[At\u0007\u001fbC!a;\u0002p\":\u0011'!>\u0002~\u0006}\u0018\u0001\u0004;fgR$Um]2sS\n,G\u0003BA\u0010\u0007/Bq!a53\u0001\u0004\t\u0019\u0006K\u00043\u0003/\f9oa\u0017-\t\u0005-\u0018q\u001e\u0015\be\u0005U\u0018Q`A\u0000\u0003\u0001\"Xm\u001d;EKN\u001c'/\u001b2f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;\u0015\t\u0005}11\r\u0005\b\u0003'\u001c\u0004\u0019AA*Q\u001d\u0019\u0014q[At\u0007ObC!a;\u0002p\":1'!>\u0002~\u0006}\u0018\u0001\f;fgR$Um]2sS\n,w\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgR<\u0016\u000e\u001e5JM\u0016C\u0018n\u001d;t)\u0011\tyba\u001c\t\u000f\u0005MG\u00071\u0001\u0002T!:A'a6\u0002h\u000eMD\u0006BAv\u0003_Ds\u0001NA{\u0003{\fy0A\u0011uKN$H)Z:de&\u0014W-\u00168bm\u0006LG.\u00192mKB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002 \rm\u0004bBAjk\u0001\u0007\u00111\u000b\u0015\bk\u0005]\u0017q]B@Y\u0011\tY/a<)\u000fU\n)0!@\u0002\u0000\u0006)C/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003?\u00199\tC\u0004\u0002TZ\u0002\r!a\u0015)\u000fY\n9.a:\u0004\f2\"\u00111^AxQ\u001d1\u0014Q_A\u007f\u0003\u007f\f\u0011\u0005^3ti\u0012+7o\u0019:jE\u0016,f\u000eZ3s\u001b&t\u0017j\u001d:QCJ$\u0018\u000e^5p]N$B!a\b\u0004\u0014\"9\u00111[\u001cA\u0002\u0005M\u0003fB\u001c\u0002X\u0006\u001d8q\u0013\u0017\u0005\u0003W\fy\u000fK\u00048\u0003k\fi0a@\u0002IQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3XSRD\u0017J\u001c<bY&$wJY:feZ,'oQ8v]RD3\u0001OBP!\u0011\t9k!)\n\t\r\r\u0016\u0011\u0016\u0002\u0005)\u0016\u001cH/A\u0014uKN$H)Z:de&\u0014WmV5uQ&sg/\u00197jINKhn\u0019*fa2L7-Y\"pk:$\bfA\u001d\u0004 \u00061C/Z:u\t\u0016\u001c8M]5cK^KG\u000f[%om\u0006d\u0017\u000eZ*z]\u000e\u0014V\r\u001d7jG\u0006\u0014\u0016mY6)\u0007i\u001ay*A\u0012uKN$H)Z:de&\u0014WmV5uQ&sg/\u00197jI>\u00137/\u001a:wKJ\u0014\u0016mY6)\u0007m\u001ay*\u0001\u0012uKN$H)Z:de&\u0014WmV5uQNKhn\u0019*fa2L7-Y(gM2Lg.\u001a\u0015\u0004y\r}\u0015a\b;fgR$Um]2sS\n,w+\u001b;i\u001f\n\u001cXM\u001d<fe>3g\r\\5oK\"\u001aQha(\u0002SQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3XSRD7i\u001c:sK\u000e$H.\u001f)mC\u000e,G\rU1si&$\u0018n\u001c8tQ\rq4qT\u0001Bi\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]N<\u0006.\u001a8SK\u0006\u001c8/[4o[\u0016tG/S:J]B\u0013xn\u001a:fgN$B!a\b\u0004B\"9\u00111[ A\u0002\u0005M\u0003fB \u0002X\u0006\u001d8Q\u0019\u0017\u0005\u0003W\fy\u000fK\u0004@\u0003k\fi0a@\u0002=Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3Bi6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA\u0010\u0007\u001bDq!a5A\u0001\u0004\t\u0019\u0006K\u0004A\u0003/\f9o!5-\t\u0005-\u0018q\u001e\u0015\b\u0001\u0006U\u0018Q`A\u0000\u0003\u0019\"Xm\u001d;EKN\u001c'/\u001b2f+:$WM]'j]&\u001b(\u000fU1si&$\u0018n\u001c8t\u001b&DX\r\u001a\u000b\u0005\u0003?\u0019I\u000eC\u0004\u0002T\u0006\u0003\r!a\u0015)\u000f\u0005\u000b9.a:\u0004^2\"\u00111^AxQ\u001d\t\u0015Q_A\u007f\u0003\u007f\f1\u0005^3ti\u0012+7o\u0019:jE\u0016\u0014V\r]8si>3XM\u001d:jI\u0012,gnQ8oM&<7\u000f\u0006\u0003\u0002 \r\u0015\bbBAj\u0005\u0002\u0007\u00111\u000b\u0015\b\u0005\u0006]\u0017q]BuY\u0011\tY/a<)\u000f\t\u000b)0!@\u0002\u0000\u0006qC/Z:u\t\u0016\u001c8M]5cK\u0006sG\rT5tiR{\u0007/[2t/&$\bn\\;u\u0013:$XM\u001d8bYR{\u0007/[2t)\u0011\tyb!=\t\u000f\u0005M7\t1\u0001\u0002T!:1)a6\u0002h\u000eUH\u0006BAv\u0003_DsaQA{\u0003{\fy0\u0001\u001fuKN$H)Z:de&\u0014W\rR8fg:{GOR1jY^CWM\u001c'jgRLgn\u001a*fCN\u001c\u0018n\u001a8nK:$\u0018j]+oCV$\bn\u001c:ju\u0016$G\u0003BA\u0010\u0007{Dq!a5E\u0001\u0004\t\u0019\u0006K\u0004E\u0003/\f9\u000f\"\u0001-\t\u0005-\u0018q\u001e\u0015\b\t\u0006U\u0018Q`A\u0000\u0003\u0001\"Xm\u001d;De\u0016\fG/Z,ji\"$v\u000e]5d\u001d\u0006lWmQ8mY&\u001c\u0018n\u001c8\u0015\t\u0005}A\u0011\u0002\u0005\b\u0003',\u0005\u0019AA*Q\u001d)\u0015q[At\t\u001baC!a;\u0002p\":Q)!>\u0002~\u0006}\b")
public class TopicCommandIntegrationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor;
    private TopicCommand.TopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 6;
        String x$2 = this.zkConnectOrNull();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5, x$17).map((Function1 & Serializable & scala.Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.TopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.TopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        super.setUp(info);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
        this.topicService_$eq(TopicCommand.TopicService$.MODULE$.apply(this.adminClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreate(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaults(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultReplication(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultPartitions(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithConfigs(String quorum) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExists(String quorum) {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExistsWithIfNotExists(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-not-exists"}));
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithReplicaAssignment(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithInvalidReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativeReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativePartitionCount(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidTopicLevelConfig(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithIncludeList(String quorum) {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(topic1));
        Assertions.assertTrue((boolean)string.contains(topic2));
        Assertions.assertFalse((boolean)string.contains(topic3));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithExcludeInternal(String quorum) {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(topic1));
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterPartitionCount(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignment(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterAssignment$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testAlterAssignment$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMoreAssignmentThanPartitions(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMorePartitionsThanAssignment(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWithInvalidPartitionCount(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(this.adminClient());
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService.alterTopic(alterOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"})));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAlterTopicWithRackAware(String quorum) {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(info.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Buffer$.MODULE$.canBuildFrom())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$3(this, alteredNumPartitions)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        assignment = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(info.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Buffer$.MODULE$.canBuildFrom())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigPreservationAcrossPartitionAlteration(String quorum) {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        Config props = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)props.get(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)props.get(cleanupKey).value(), (String)"Properties after creation have incorrect value");
        if (!this.isKRaftTest()) {
            this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        }
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Config newProps = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)newProps.get(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)newProps.get(cleanupKey).value(), (String)"Updated properties have incorrect value");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.testTopicName(), 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicWithCollidingCharDeletionAndCreateAgain(String quorum) {
        String topicWithCollidingChar = "test.a";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", topicWithCollidingChar}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", topicWithCollidingChar}));
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(topicWithCollidingChar);
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), topicWithCollidingChar, 1, this.brokers());
        Assertions.assertDoesNotThrow(() -> this.createAndWaitTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteInternalTopic(String quorum) {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        if (!this.isKRaftTest()) {
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), "__consumer_offsets", 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"})));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribe(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExist(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"})));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnavailablePartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).asScala()).apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$1(x$10))).get()).partition();
            this.killBroker(0);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                TestUtils$.MODULE$.waitForPartitionMetadata(this.aliveBrokers(), this.testTopicName(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()), (String)new StringBuilder(19).append("Unexpected output: ").append(rows[0]).toString());
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$1(this)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidObserverCount() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidSyncReplicaCount() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidSyncReplicaRack() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidObserverRack() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithSyncReplicaOffline() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeWithSyncReplicaOffline$1(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeWithSyncReplicaOffline$3());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithObserverOffline() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(5);
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithCorrectlyPlacedPartitions() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((Object)"", (Object)rows[0]);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress(String quorum) {
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.brokers().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$15)), Buffer$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).allTopicNames().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(testTopicDesc.partitions()).asScala()).head();
        Buffer replicasOfFirstPartition = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(firstPartition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.id()), Buffer$.MODULE$.canBuildFrom());
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)brokerIds.diff((GenSeq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])simpleDescribeOutputRows)).size());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out2.toString();
        Assertions.assertEquals((Object)"", (Object)string, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(string).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$17))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), TestUtils$.MODULE$.waitForAllReassignmentsToComplete$default$2());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAtMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$1(this)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$3(this));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertEquals((int)1, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitionsMixed(String quorum) {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            if (this.isKRaftTest()) {
                this.ensureConsistentKRaftMetadata();
            } else {
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(this, underMinIsrTopic, offlineTopic)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$3());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assertions.assertEquals((int)2, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeReportOverriddenConfigs(String quorum) {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAndListTopicsWithoutInternalTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)string2.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)string2.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized(String quorum) {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        this.topicService_$eq(TopicCommand.TopicService$.MODULE$.apply(this.adminClient()));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithTopicNameCollision(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic("foo_bar", 1, (short)6))).all().get();
        this.waitForTopicCreated("foo_bar", this.waitForTopicCreated$default$2());
        Assertions.assertThrows(InvalidTopicException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "foo.bar"}))));
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$2(TopicCommandIntegrationTest $this, KafkaBroker x$4) {
        return x$4.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$2($this, x$4)));
    }

    public static final /* synthetic */ String $anonfun$testAlterPartitionCount$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$2(TopicCommandIntegrationTest $this, KafkaBroker x$5) {
        return x$5.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterAssignment$2($this, x$5)));
    }

    public static final /* synthetic */ String $anonfun$testAlterAssignment$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$4(TopicCommandIntegrationTest $this, int alteredNumPartitions$1, KafkaBroker x$8) {
        return x$8.metadataCache().getTopicPartitions($this.testTopicName()).size() == alteredNumPartitions$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$3(TopicCommandIntegrationTest $this, int alteredNumPartitions$1) {
        return $this.brokers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$4($this, alteredNumPartitions$1, x$8)));
    }

    public static final /* synthetic */ String $anonfun$testCreateAlterTopicWithRackAware$5() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$10) {
        return x$10.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaBroker x$11) {
        return x$11.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandIntegrationTest $this, MetadataResponseData.MetadataResponseTopic x$12) {
        return x$12.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$13) {
        return x$13.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandIntegrationTest $this, int partitionOnBroker0$1, boolean result, KafkaBroker server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$12))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$13)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandIntegrationTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)$this.brokers().filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$3(x$11)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandIntegrationTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$14) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$14.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 5;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$2($this, x$14)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeWithSyncReplicaOffline$1(TopicCommandIntegrationTest $this) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append($this.testTopicName()).toString());
    }

    public static final /* synthetic */ String $anonfun$testDescribeWithSyncReplicaOffline$3() {
        return "--invalid-replica-placement-partitions did not return the correct topic after the broker was killed";
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaBroker x$15) {
        return x$15.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandIntegrationTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$17) {
        return x$17.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$2(TopicCommandIntegrationTest $this, KafkaBroker x$18) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$18.metadataCache().getPartitionInfo($this.testTopicName(), 0).get()).isr().size() == 4;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeAtMinIsrPartitions$1(TopicCommandIntegrationTest $this) {
        return $this.aliveBrokers().forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeAtMinIsrPartitions$2($this, x$18)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeAtMinIsrPartitions$3(TopicCommandIntegrationTest $this) {
        return new StringBuilder(72).append("Timeout waiting for partition metadata propagating to brokers for ").append($this.testTopicName()).append(" topic").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$2(String underMinIsrTopic$1, String offlineTopic$1, KafkaBroker broker) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(underMinIsrTopic$1, 0).get()).isr().size() < 6 && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker.metadataCache().getPartitionInfo(offlineTopic$1, 0).get()).leader() == -1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(TopicCommandIntegrationTest $this, String underMinIsrTopic$1, String offlineTopic$1) {
        return $this.aliveBrokers().forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$2(underMinIsrTopic$1, offlineTopic$1, broker)));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderMinIsrPartitionsMixed$3() {
        return "Timeout waiting for partition metadata propagating to brokers for underMinIsrTopic topic";
    }

    public TopicCommandIntegrationTest() {
        RackAwareTest.$init$(this);
        this.numPartitions = 1;
        this.defaultReplicationFactor = (short)1;
    }
}

