/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import kafka.admin.balancer.ClusterRebalanceCommand$;
import kafka.admin.balancer.ClusterRebalanceCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerSelfHealMode;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.clients.admin.BalancerStatusDescription;
import org.apache.kafka.clients.admin.ComputeEvenClusterLoadPlanResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBalancerStatusResult;
import org.apache.kafka.clients.admin.DescribeEvenClusterLoadStatusResult;
import org.apache.kafka.clients.admin.EvenClusterLoadPlan;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;
import org.apache.kafka.clients.admin.EvenClusterLoadStatusDescription;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.TriggerEvenClusterLoadResult;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.apache.kafka.common.errors.BalancerOfflineException;
import org.apache.kafka.common.errors.BrokerAdditionInProgressException;
import org.apache.kafka.common.errors.BrokerFailureFixInProgressException;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.EvenClusterLoadTaskInProgressException;
import org.apache.kafka.common.errors.RebalancePlanComputationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.SystemTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u000f\u001e\u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u0019y\u0004\u0001)A\u0005y!9\u0001\t\u0001b\u0001\n\u0003Y\u0004BB!\u0001A\u0003%A\bC\u0004C\u0001\u0001\u0007I\u0011A\"\t\u000fA\u0003\u0001\u0019!C\u0001#\"1q\u000b\u0001Q!\n\u0011CQ\u0001\u0017\u0001\u0005\u0002eCQ!\u001a\u0001\u0005\n\u0019Da!!\u0001\u0001\t\u0003I\u0006BBA\u0006\u0001\u0011\u0005\u0011\fC\u0004\u0002\u0010\u0001!I!!\u0005\t\r\u0005u\u0001\u0001\"\u0001Z\u0011\u0019\t\t\u0003\u0001C\u00013\"1\u0011Q\u0005\u0001\u0005\u0002eCq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!1\u0011\u0011\u000f\u0001\u0005\u0002eCq!!\u001e\u0001\t\u0013\t9\b\u0003\u0004\u0002\u0012\u0002!\t!\u0017\u0005\u0007\u0003+\u0003A\u0011A-\t\r\u0005e\u0005\u0001\"\u0001Z\u0011\u0019\ti\n\u0001C\u00013\nY2\t\\;ti\u0016\u0014(+\u001a2bY\u0006t7-Z\"p[6\fg\u000e\u001a+fgRT!AH\u0010\u0002\u0011\t\fG.\u00198dKJT!\u0001I\u0011\u0002\u000b\u0005$W.\u001b8\u000b\u0003\t\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u000f\u0002\u001f\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ,\u0012!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\nA\u0001\\1oO*\ta'\u0001\u0003kCZ\f\u0017B\u0001\u001d4\u0005\u0019\u0019FO]5oO\u0006\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'\u000fI\u0001\u000eGV\u0014(/\u001a8u)&lW-T:\u0016\u0003q\u0002\"AJ\u001f\n\u0005y:#\u0001\u0002'p]\u001e\fabY;se\u0016tG\u000fV5nK6\u001b\b%\u0001\u0006qe\u00164H+[7f\u001bN\f1\u0002\u001d:fmRKW.Z'tA\u0005yA/Z:u\u0003\u0012l\u0017N\\\"mS\u0016tG/F\u0001E!\t)e*D\u0001G\u0015\t\u0001sI\u0003\u0002I\u0013\u000691\r\\5f]R\u001c(B\u0001\u0012K\u0015\tYE*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0006\u0019qN]4\n\u0005=3%aD'pG.\fE-\\5o\u00072LWM\u001c;\u0002'Q,7\u000f^!e[&t7\t\\5f]R|F%Z9\u0015\u0005I+\u0006C\u0001\u0014T\u0013\t!vE\u0001\u0003V]&$\bb\u0002,\n\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\n\u0014\u0001\u0005;fgR\fE-\\5o\u00072LWM\u001c;!\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0006FA\u0006\\!\ta6-D\u0001^\u0015\tqv,A\u0002ba&T!\u0001Y1\u0002\u000f),\b/\u001b;fe*\u0011!\rT\u0001\u0006UVt\u0017\u000e^\u0005\u0003Iv\u0013!BQ3g_J,W)Y2i\u0003)\u0011XO\\\"p[6\fg\u000e\u001a\u000b\u0005OF4\b\u0010\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003U\u001ej\u0011a\u001b\u0006\u0003Y\u000e\na\u0001\u0010:p_Rt\u0014B\u00018(\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001\b\u001d\u0006\u0003]\u001eBQA\u001d\u0007A\u0002M\fA!\u0019:hgB\u0019a\u0005^4\n\u0005U<#!B!se\u0006L\b\"B<\r\u0001\u0004!\u0015aD7pG.\fE-\\5o\u00072LWM\u001c;\t\u000bed\u0001\u0019\u0001>\u00021\t\fG.\u00198dKJ\u001cu.\\7b]\u0012|\u0005/\u001a:bi&|g\u000e\u0005\u0003'wv\u0014\u0016B\u0001?(\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002F}&\u0011qP\u0012\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003I!Xm\u001d;D_6l\u0017M\u001c3PaRLwN\\:)\u00075\t)\u0001E\u0002]\u0003\u000fI1!!\u0003^\u0005\u0011!Vm\u001d;\u0002QQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3CC2\fgnY3s'R\fG/^:TS6\u0004H.Z*uCR,8/Z:)\u00079\t)!\u0001\u0011bgN,'\u000f^*uCR,8\u000fV=qKB\u0013x\u000e]3sYf\u0014V\r]8si\u0016$Gc\u0001*\u0002\u0014!9\u0011QC\bA\u0002\u0005]\u0011\u0001E:uCR,8\u000fV8WC2LG-\u0019;f!\r)\u0015\u0011D\u0005\u0004\u000371%A\u0004\"bY\u0006t7-\u001a:Ti\u0006$Xo]\u0001&i\u0016\u001cH\u000fR3tGJL'-\u001a\"bY\u0006t7-\u001a:Ti\u0006$Xo]#se>\u00148\u000b^1ukND3\u0001EA\u0003\u0003i!Xm\u001d;EKN\u001c'/\u001b2f+:,g/\u001a8M_\u0006$G+Y:lQ\r\t\u0012QA\u0001/i\u0016\u001cH\u000fR3tGJL'-Z+oKZ,g\u000eT8bI&sG)[:bE2,G-\u00118e'R\f'\u000f^*uCR,7\u000fK\u0002\u0013\u0003\u000b\t\u0011F^1mS\u0012\fG/Z(viB,H/\u00118e\u000bJ\u0014xN\u001d$peVsWM^3o\u0019>\fGm\u0015;biV\u001cH#\u0002*\u0002.\u0005]\u0002bBA\u0018'\u0001\u0007\u0011\u0011G\u0001\u000eGV\u0014(/\u001a8u'R\fG/^:\u0011\u0007\u0015\u000b\u0019$C\u0002\u00026\u0019\u0013Q#\u0012<f]\u000ecWo\u001d;fe2{\u0017\rZ*uCR,8\u000fC\u0004\u0002:M\u0001\r!!\r\u0002\u0015A\u0014XM^*uCR,8/\u0001\rwC2LG-\u0019;f+:,g/\u001a8M_\u0006$7\u000b^1ukN$\u0012bZA \u0003\u0013\ni%!\u0015\t\u000f\u0005\u0005C\u00031\u0001\u0002D\u0005IB/Z:u\u0011\u0016\fG.\u00168fm\u0016tGj\\1e)JLwmZ3s!\r)\u0015QI\u0005\u0004\u0003\u000f2%\u0001\u0006\"bY\u0006t7-\u001a:TK24\u0007*Z1m\u001b>$W\rC\u0004\u0002LQ\u0001\r!!\r\u0002#Q,7\u000f^\"veJ,g\u000e^*uCR,8\u000fC\u0004\u0002PQ\u0001\r!!\r\u0002\u001dQ,7\u000f\u001e)sKZ\u001cF/\u0019;vg\"9\u00111\u000b\u000bA\u0002\u0005U\u0013!D3se>\u0014Hk\u001c*fiV\u0014h\u000eE\u0002F\u0003/J1!!\u0017G\u0005Y\u0011\u0015\r\\1oG\u0016\u0014x\n]3sCRLwN\\#se>\u0014\u0018\u0001H:fiV\u0004XI^3o\u0019>\fG\rR3tGJL\u0007\u000f^5p]6{7m\u001b\u000b\u000e%\u0006}\u0013\u0011MA2\u0003K\nI'!\u001c\t\u000f\u0005\u0005S\u00031\u0001\u0002D!9\u0011qF\u000bA\u0002\u0005E\u0002bBA\u001d+\u0001\u0007\u0011\u0011\u0007\u0005\u0007\u0003O*\u0002\u0019\u0001\u001f\u0002'\r,(O]3oiV\u0003H-\u0019;f)&lW-T:\t\r\u0005-T\u00031\u0001=\u0003A\u0001(/\u001a<Va\u0012\fG/\u001a+j[\u0016l5\u000fC\u0004\u0002pU\u0001\r!!\u0016\u0002\u001d=\u0004XM]1uS>tWI\u001d:pe\u0006\u0001C/Z:u\t\u0016\u001c8M]5cKVsWM^3o\u0019>\fG\rV1tW\u0016\u0013(o\u001c:tQ\r1\u0012QA\u0001\u000eO\u0016$XI\u001d:peJ+w-\u001a=\u0015\r\u0005e\u0014\u0011RAG!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003\u0007;\u0013\u0001B;uS2LA!a\"\u0002~\tyQK\\1oG\"|'/\u001a3SK\u001e,\u0007\u0010\u0003\u0004\u0002\f^\u0001\raZ\u0001\u0012Kb\u0004Xm\u0019;fIBC\u0017m]3OC6,\u0007bBAH/\u0001\u0007\u0011QK\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0002EQ,7\u000f\u001e+sS\u001e<WM]#wK:\u001cE.^:uKJL5oU;dG\u0016\u001c8OZ;mQ\rA\u0012QA\u0001+i\u0016\u001cH\u000f\u0016:jO\u001e,'/\u0012<f]\u000ecWo\u001d;fe2{\u0017\rZ0uQJ|wo]#yG\u0016\u0004H/[8oQ\rI\u0012QA\u0001&i\u0016\u001cHoQ8naV$X-\u0012<f]\u000ecWo\u001d;fe2{\u0017\r\u001a)mC:\u001cVoY2fgND3AGA\u0003\u00035\"Xm\u001d;D_6\u0004X\u000f^3Fm\u0016t7\t\\;ti\u0016\u0014Hj\\1e!2\fg\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u00047\u0005\u0015\u0001")
public class ClusterRebalanceCommandTest {
    private final String bootstrapServer;
    private final long currentTimeMs = new SystemTime().hiResClockMs();
    private final long prevTimeMs = this.currentTimeMs() - new package.DurationInt(package$.MODULE$.DurationInt(60)).second().toMillis();
    private MockAdminClient testAdminClient = (MockAdminClient)Mockito.mock(MockAdminClient.class);

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    public long prevTimeMs() {
        return this.prevTimeMs;
    }

    public MockAdminClient testAdminClient() {
        return this.testAdminClient;
    }

    public void testAdminClient_$eq(MockAdminClient x$1) {
        this.testAdminClient = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.testAdminClient_$eq((MockAdminClient)Mockito.mock(MockAdminClient.class));
    }

    /*
     * WARNING - void declaration
     */
    private String runCommand(String[] args, MockAdminClient mockAdminClient, Function1<ConfluentAdmin, BoxedUnit> balancerCommandOperation) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            new ClusterRebalanceCommandOptions((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            if (ClusterRebalanceCommand$.MODULE$ == null) {
                throw null;
            }
            try {
                balancerCommandOperation.apply((Object)mockAdminClient);
                return;
            }
            catch (ApiException runBalancerCommand_e) {
                if (runBalancerCommand_e instanceof TimeoutException) {
                    throw new AdminCommandFailedException("Timed out waiting for the balancer status", (Throwable)runBalancerCommand_e);
                }
                if (runBalancerCommand_e instanceof ClusterAuthorizationException) {
                    ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)runBalancerCommand_e;
                    throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), (Throwable)runBalancerCommand_e);
                }
                boolean bl = runBalancerCommand_e instanceof BalancerOfflineException ? true : (runBalancerCommand_e instanceof BalancerLoadError ? true : (runBalancerCommand_e instanceof BrokerRemovalInProgressException ? true : (runBalancerCommand_e instanceof BrokerAdditionInProgressException ? true : (runBalancerCommand_e instanceof EvenClusterLoadTaskInProgressException ? true : (runBalancerCommand_e instanceof BrokerFailureFixInProgressException ? true : runBalancerCommand_e instanceof RebalancePlanComputationException)))));
                if (bl) {
                    throw new AdminCommandFailedException(runBalancerCommand_e.getMessage(), (Throwable)runBalancerCommand_e);
                }
                throw runBalancerCommand_e;
            }
            catch (Throwable runBalancerCommand_e) {
                Predef$.MODULE$.println((Object)"Error while issuing the balancer status request");
                throw runBalancerCommand_e;
            }
        };
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    @Test
    public void testCommandOptions() {
        ClusterRebalanceCommandOptions options_none = new ClusterRebalanceCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_none.verifyArgs(), (String)"Expected IllegalArgumentException if no bootstrap-server arg provided");
        ClusterRebalanceCommandOptions options_noCommand = new ClusterRebalanceCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_noCommand.verifyArgs(), (String)"Expected IllegalArgumentException if no subcommand provided");
        ClusterRebalanceCommandOptions options_statusAndDescribe = new ClusterRebalanceCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(), "--status", "--describe"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_statusAndDescribe.verifyArgs(), (String)"Expected IllegalArgumentException if multiple subcommands provided");
        ClusterRebalanceCommandOptions options_statusAndRebalance = new ClusterRebalanceCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(), "--status", "--rebalance"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_statusAndRebalance.verifyArgs(), (String)"Expected IllegalArgumentException if multiple subcommands provided");
        ClusterRebalanceCommandOptions options_statusAndEvenClusterLoadPlan = new ClusterRebalanceCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(), "--status", "--rebalance-dry-run"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> options_statusAndEvenClusterLoadPlan.verifyArgs(), (String)"Expected IllegalArgumentException if multiple subcommands provided");
        new ClusterRebalanceCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.bootstrapServer(), "--status"})).verifyArgs();
    }

    @Test
    public void testDescribeBalancerStatusSimpleStatuses() {
        BalancerStatus[] balancerStatuses = BalancerStatus.values();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])balancerStatuses)).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.assertStatusTypeProperlyReported(x$1);
            return BoxedUnit.UNIT;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
    }

    /*
     * WARNING - void declaration
     */
    private void assertStatusTypeProperlyReported(BalancerStatus statusToValidate) {
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        this.testAdminClient_$eq((MockAdminClient)Mockito.mock(MockAdminClient.class));
        DescribeBalancerStatusResult describeBalancerStatusResult = (DescribeBalancerStatusResult)Mockito.mock(DescribeBalancerStatusResult.class);
        KafkaFutureImpl describeBalancerStatusDescriptionMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        BalancerStatusDescription mockBalancerStatusDescription = (BalancerStatusDescription)Mockito.spy((Object)new BalancerStatusDescription(statusToValidate, (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), null));
        Mockito.when((Object)this.testAdminClient().describeBalancerStatus()).thenReturn((Object)describeBalancerStatusResult);
        Mockito.when((Object)describeBalancerStatusResult.description()).thenReturn((Object)describeBalancerStatusDescriptionMock);
        Mockito.when((Object)describeBalancerStatusDescriptionMock.get()).thenReturn((Object)mockBalancerStatusDescription);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.describeBalancerStatus(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = (String[])((Object[])new String[]{"--status"});
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void runCommand_grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = runCommand_grabConsoleOutput_out.toString();
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).describeBalancerStatus();
        ((BalancerStatusDescription)Mockito.verify((Object)mockBalancerStatusDescription)).balancerStatus();
        Assertions.assertTrue((boolean)string.contains(statusToValidate.toString()), (String)new StringBuilder(28).append("Expected status to be ").append(statusToValidate.toString()).append(", got ").append(string).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeBalancerStatusErrorStatus() {
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        DescribeBalancerStatusResult describeBalancerStatusResult = (DescribeBalancerStatusResult)Mockito.mock(DescribeBalancerStatusResult.class);
        KafkaFutureImpl describeBalancerStatusDescriptionMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        String testErrorString = "test error";
        BalancerOperationError balancerError = new BalancerOperationError(Errors.BALANCER_OFFLINE, testErrorString);
        BalancerStatusDescription mockBalancerStatusDescription = (BalancerStatusDescription)Mockito.spy((Object)new BalancerStatusDescription(BalancerStatus.ERROR, (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), balancerError));
        Mockito.when((Object)this.testAdminClient().describeBalancerStatus()).thenReturn((Object)describeBalancerStatusResult);
        Mockito.when((Object)describeBalancerStatusResult.description()).thenReturn((Object)describeBalancerStatusDescriptionMock);
        Mockito.when((Object)describeBalancerStatusDescriptionMock.get()).thenReturn((Object)mockBalancerStatusDescription);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.describeBalancerStatus(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = (String[])((Object[])new String[]{"--status"});
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void runCommand_grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = runCommand_grabConsoleOutput_out.toString();
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).describeBalancerStatus();
        ((BalancerStatusDescription)Mockito.verify((Object)mockBalancerStatusDescription)).balancerStatus();
        Assertions.assertTrue((boolean)string.contains(BalancerStatus.ERROR.toString()), (String)new StringBuilder(33).append("Expected status to be error, got ").append(string).toString());
        Assertions.assertTrue((boolean)string.contains(testErrorString), (String)new StringBuilder(40).append("Expected to see test error message, got ").append(string).toString());
    }

    @Test
    public void testDescribeUnevenLoadTask() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])EvenClusterLoadStatus.values())).foreach((Function1 & Serializable & scala.Serializable)currentStatus -> {
            ClusterRebalanceCommandTest.$anonfun$testDescribeUnevenLoadTask$1(this, currentStatus);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeUnevenLoadInDisabledAndStartStates() {
        String unevenLoadDisabledOutput = this.validateUnevenLoadStatus(BalancerSelfHealMode.EMPTY_BROKER, null, null, null);
        Assertions.assertFalse((boolean)unevenLoadDisabledOutput.contains("Previous"), (String)new StringBuilder(53).append("Did not expect to see output for previous state, got ").append(unevenLoadDisabledOutput).toString());
        String unevenLoadStartingOutput = this.validateUnevenLoadStatus(BalancerSelfHealMode.ANY_UNEVEN_LOAD, EvenClusterLoadStatus.STARTING, null, null);
        Assertions.assertFalse((boolean)unevenLoadStartingOutput.contains("Previous"), (String)new StringBuilder(53).append("Did not expect to see output for previous state, got ").append(unevenLoadStartingOutput).toString());
    }

    private void validateOutputAndErrorForUnevenLoadStatus(EvenClusterLoadStatus currentStatus, EvenClusterLoadStatus prevStatus) {
        String testErrorMessage = "test error";
        EvenClusterLoadStatus evenClusterLoadStatus = currentStatus;
        EvenClusterLoadStatus evenClusterLoadStatus2 = EvenClusterLoadStatus.BALANCING_FAILED;
        BalancerOperationError testException = (evenClusterLoadStatus == null ? evenClusterLoadStatus2 != null : !evenClusterLoadStatus.equals(evenClusterLoadStatus2)) && (prevStatus == null || !prevStatus.equals(EvenClusterLoadStatus.BALANCING_FAILED)) ? null : new BalancerOperationError(Errors.BALANCER_OPERATION_FAILED, testErrorMessage);
        String testOutput = this.validateUnevenLoadStatus(BalancerSelfHealMode.ANY_UNEVEN_LOAD, currentStatus, prevStatus, testException);
        if (!(currentStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED) || prevStatus != null && prevStatus.equals((Object)EvenClusterLoadStatus.BALANCING_FAILED))) {
            Assertions.assertFalse((boolean)testOutput.contains("Exception"), (String)new StringBuilder(71).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected no exception to be reported in output, got ").append(testOutput).toString());
            Assertions.assertFalse((boolean)testOutput.contains(testErrorMessage), (String)new StringBuilder(64).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected no error message in output, but got ").append(testOutput).toString());
            return;
        }
        Assertions.assertTrue((boolean)testOutput.contains("Exception"), (String)new StringBuilder(99).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected an Exception to be reported in command output, but didn't find one in: ").append(testOutput).toString());
        Assertions.assertTrue((boolean)testOutput.contains(testErrorMessage), (String)new StringBuilder(75).append("When testing (").append(currentStatus).append(", ").append(prevStatus).append("), expected the test error message ").append(testErrorMessage).append(" but didn't find it in: ").append(testOutput).toString());
    }

    /*
     * WARNING - void declaration
     */
    private String validateUnevenLoadStatus(BalancerSelfHealMode testHealUnevenLoadTrigger, EvenClusterLoadStatus testCurrentStatus, EvenClusterLoadStatus testPrevStatus, BalancerOperationError errorToReturn) {
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        Regex healUnevenLoadTriggerRegex = (Regex)new StringOps(Predef$.MODULE$.augmentString("HealUnevenLoadTrigger: (\\w+)")).r().unanchored();
        Regex currentRegex = (Regex)new StringOps(Predef$.MODULE$.augmentString("Current: (\\w+)")).r().unanchored();
        Regex prevStatusRegex = (Regex)new StringOps(Predef$.MODULE$.augmentString("Previous: (\\w+)")).r().unanchored();
        this.setupEvenLoadDescriptionMock(testHealUnevenLoadTrigger, testCurrentStatus, testPrevStatus, 0L, 0L, errorToReturn);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.describeAnyUnevenLoadTask(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = (String[])((Object[])new String[]{"--describe"});
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void runCommand_grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = runCommand_grabConsoleOutput_out.toString();
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).describeEvenClusterLoadStatus();
        Option option = healUnevenLoadTriggerRegex.unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String extractedHealUnevenLoadTrigger = (String)((LinearSeqOptimized)option.get()).apply(0);
            Assertions.assertTrue((boolean)extractedHealUnevenLoadTrigger.equals(testHealUnevenLoadTrigger.toString()), (String)new StringBuilder(71).append("Current uneven-load task status wasn't the expected value, got ").append(extractedHealUnevenLoadTrigger).append(" wanted ").append(testHealUnevenLoadTrigger).toString());
        } else {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(58).append("Couldn't find healUnevenLoadTrigger of even load task in: ").append(string).toString());
        }
        if (testCurrentStatus != null) {
            Option option2 = currentRegex.unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String extractedCurrentStatus = (String)((LinearSeqOptimized)option2.get()).apply(0);
                Assertions.assertTrue((boolean)extractedCurrentStatus.equals(testCurrentStatus.toString()), (String)new StringBuilder(71).append("Current uneven-load task status wasn't the expected value, got ").append(extractedCurrentStatus).append(" wanted ").append(testCurrentStatus).toString());
            } else {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)new StringBuilder(53).append("Couldn't find current status of uneven load task in: ").append(string).toString());
            }
        } else {
            Assertions.assertFalse((boolean)string.contains("Current:"), (String)new StringBuilder(46).append("Expected no current state to be printed, got: ").append(string).toString());
            Assertions.assertTrue((boolean)string.contains("No current status"), (String)new StringBuilder(54).append("Expected no current status string to be printed, got: ").append(string).toString());
        }
        if (testPrevStatus != null) {
            Option option3 = prevStatusRegex.unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                String extractedPreviousStatus = (String)((LinearSeqOptimized)option3.get()).apply(0);
                Assertions.assertTrue((boolean)extractedPreviousStatus.equals(testPrevStatus.toString()), (String)new StringBuilder(72).append("Previous uneven-load task status wasn't the expected value, got ").append(extractedPreviousStatus).append(" wanted ").append(testPrevStatus).toString());
            } else {
                BoxedUnit cfr_ignored_2 = (BoxedUnit)Assertions.fail((String)new StringBuilder(54).append("Couldn't find status of previous uneven load task in: ").append(string).toString());
            }
        } else {
            Assertions.assertFalse((boolean)string.contains("Previous"), (String)new StringBuilder(47).append("Expected no previous state to be printed, got: ").append(string).toString());
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private void setupEvenLoadDescriptionMock(BalancerSelfHealMode testHealUnevenLoadTrigger, EvenClusterLoadStatus currentStatus, EvenClusterLoadStatus prevStatus, long currentUpdateTimeMs, long prevUpdateTimeMs, BalancerOperationError operationError) {
        v0 = currentStatus;
        var9_7 = EvenClusterLoadStatus.BALANCING_FAILED;
        if (!(v0 == null ? var9_7 != null : v0.equals(var9_7) == false)) ** GOTO lbl-1000
        v1 = prevStatus;
        var10_8 = EvenClusterLoadStatus.BALANCING_FAILED;
        if (!(v1 != null ? v1.equals(var10_8) == false : var10_8 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)(v2 ^ operationError == null), (String)new StringBuilder(92).append("Invalid status/error combination sent to test: currentStatus: ").append(currentStatus).append(" prevStatus: ").append(prevStatus).append(" operationError: ").append(operationError).toString());
        this.testAdminClient_$eq((MockAdminClient)Mockito.mock(MockAdminClient.class));
        describeUnevenLoadTaskResult = (DescribeEvenClusterLoadStatusResult)Mockito.mock(DescribeEvenClusterLoadStatusResult.class);
        describeUnevenLoadDescriptionMock = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)this.testAdminClient().describeEvenClusterLoadStatus()).thenReturn((Object)describeUnevenLoadTaskResult);
        Mockito.when((Object)describeUnevenLoadTaskResult.description()).thenReturn((Object)describeUnevenLoadDescriptionMock);
        spyUnevenLoadDescription = (EvenClusterLoadStatusDescription)Mockito.spy((Object)new EvenClusterLoadStatusDescription(testHealUnevenLoadTrigger, currentStatus, prevStatus, currentUpdateTimeMs, prevUpdateTimeMs, operationError));
        Mockito.when((Object)describeUnevenLoadDescriptionMock.get()).thenReturn((Object)spyUnevenLoadDescription);
    }

    @Test
    public void testDescribeUnevenLoadTaskErrors() {
        BalancerOperationError currentError = new BalancerOperationError(Errors.BALANCER_OPERATION_FAILED, "current operation failed");
        String currentErrorOutput = this.validateUnevenLoadStatus(BalancerSelfHealMode.ANY_UNEVEN_LOAD, EvenClusterLoadStatus.BALANCING_FAILED, EvenClusterLoadStatus.BALANCED, currentError);
        UnanchoredRegex currentErrorRegex = this.getErrorRegex("Current", currentError);
        Option option = ((Regex)currentErrorRegex).unapplySeq((CharSequence)currentErrorOutput);
        boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl, (String)new StringBuilder(34).append("Expected error message ").append(((Regex)currentErrorRegex).toString()).append(" in output ").append(currentErrorOutput).toString());
        BalancerOperationError prevError = new BalancerOperationError(Errors.BALANCER_OPERATION_FAILED, "previous operation failed");
        String prevErrorOutput = this.validateUnevenLoadStatus(BalancerSelfHealMode.ANY_UNEVEN_LOAD, EvenClusterLoadStatus.BALANCED, EvenClusterLoadStatus.BALANCING_FAILED, prevError);
        UnanchoredRegex prevErrorRegex = this.getErrorRegex("Previous", prevError);
        Option option2 = ((Regex)prevErrorRegex).unapplySeq((CharSequence)prevErrorOutput);
        boolean bl2 = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl2, (String)new StringBuilder(34).append("Expected error message ").append(((Regex)prevErrorRegex).toString()).append(" in output ").append(prevErrorOutput).toString());
        String bothErrorOutput = this.validateUnevenLoadStatus(BalancerSelfHealMode.ANY_UNEVEN_LOAD, EvenClusterLoadStatus.BALANCING_FAILED, EvenClusterLoadStatus.BALANCING_FAILED, currentError);
        Option option3 = ((Regex)currentErrorRegex).unapplySeq((CharSequence)bothErrorOutput);
        boolean bl3 = !option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl3, (String)new StringBuilder(34).append("Expected error message ").append(((Regex)currentErrorRegex).toString()).append(" in output ").append(bothErrorOutput).toString());
        Option option4 = ((Regex)prevErrorRegex).unapplySeq((CharSequence)bothErrorOutput);
        boolean bl4 = !option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0;
        Assertions.assertFalse((boolean)bl4, (String)new StringBuilder(40).append("Did not expect error message ").append(((Regex)prevErrorRegex).toString()).append(" in output ").append(bothErrorOutput).toString());
        Option option5 = ((Regex)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(34).append("Previous: ").append(EvenClusterLoadStatus.BALANCING_FAILED.toString()).append("\\s*\\R\\s*Last Update Time").toString())).r().unanchored()).unapplySeq((CharSequence)bothErrorOutput);
        boolean bl5 = !option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(0) == 0;
        Assertions.assertTrue((boolean)bl5, (String)new StringBuilder(75).append("Expected no error message for previous phase when both in error state, got ").append(bothErrorOutput).toString());
    }

    private UnanchoredRegex getErrorRegex(String expectedPhaseName, BalancerOperationError expectedError) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(12).append(expectedPhaseName).append(": ").append(EvenClusterLoadStatus.BALANCING_FAILED.toString()).append("\\s*\\R\\s*").append(expectedError.exception().getClass().getName()).append(": ").append(expectedError.errorMessage()).toString())).r().unanchored();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTriggerEvenClusterIsSuccessful() {
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        TriggerEvenClusterLoadResult triggerEvenClusterLoadResult = (TriggerEvenClusterLoadResult)Mockito.mock(TriggerEvenClusterLoadResult.class);
        KafkaFutureImpl result = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)triggerEvenClusterLoadResult.result()).thenReturn((Object)result);
        Mockito.when((Object)result.get()).thenReturn(null);
        Mockito.when((Object)this.testAdminClient().triggerEvenClusterLoad()).thenReturn((Object)triggerEvenClusterLoadResult);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.triggerEvenClusterLoad(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = (String[])((Object[])new String[]{"--rebalance"});
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void runCommand_grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        runCommand_grabConsoleOutput_out.toString();
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).triggerEvenClusterLoad();
    }

    @Test
    public void testTriggerEvenClusterLoad_throwsException() {
        TriggerEvenClusterLoadResult triggerEvenClusterLoadResult = (TriggerEvenClusterLoadResult)Mockito.mock(TriggerEvenClusterLoadResult.class);
        KafkaFutureImpl result = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)triggerEvenClusterLoadResult.result()).thenReturn((Object)result);
        Mockito.when((Object)result.get()).thenThrow(BrokerRemovalInProgressException.class);
        Mockito.when((Object)this.testAdminClient().triggerEvenClusterLoad()).thenReturn((Object)triggerEvenClusterLoadResult);
        AdminCommandFailedException receivedException = (AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> {
            void runCommand_balancerCommandOperation;
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)client -> {
                ClusterRebalanceCommand$.MODULE$.triggerEvenClusterLoad(client);
                return BoxedUnit.UNIT;
            };
            MockAdminClient runCommand_mockAdminClient = this.testAdminClient();
            String[] runCommand_args = (String[])((Object[])new String[]{"--rebalance"});
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void runCommand_grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            runCommand_grabConsoleOutput_out.toString();
        }, () -> "Cannot trigger even cluster load operation while remove broker request is in progress.");
        Assertions.assertNotNull((Object)receivedException.getCause(), (String)"Expected the exception to have a cause");
        Assertions.assertEquals(BrokerRemovalInProgressException.class, receivedException.getCause().getClass());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testComputeEvenClusterLoadPlanSuccess() {
        void runCommand_balancerCommandOperation;
        void runCommand_mockAdminClient;
        KafkaFutureImpl future = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        ComputeEvenClusterLoadPlanResult result = (ComputeEvenClusterLoadPlanResult)Mockito.mock(ComputeEvenClusterLoadPlanResult.class);
        Mockito.when((Object)future.get()).thenReturn(Mockito.mock(EvenClusterLoadPlan.class));
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Mockito.when((Object)this.testAdminClient().computeEvenClusterLoadPlan()).thenReturn((Object)result);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)client -> {
            ClusterRebalanceCommand$.MODULE$.computeEvenClusterLoadPlan(client);
            return BoxedUnit.UNIT;
        };
        MockAdminClient mockAdminClient = this.testAdminClient();
        String[] runCommand_args = (String[])((Object[])new String[]{"--rebalance-dry-run"});
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, (MockAdminClient)runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void runCommand_grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        runCommand_grabConsoleOutput_out.toString();
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).computeEvenClusterLoadPlan();
    }

    @Test
    public void testComputeEvenClusterLoadPlanThrowsException() {
        KafkaFutureImpl future = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        ComputeEvenClusterLoadPlanResult result = (ComputeEvenClusterLoadPlanResult)Mockito.mock(ComputeEvenClusterLoadPlanResult.class);
        Mockito.when((Object)future.get()).thenThrow(RebalancePlanComputationException.class);
        Mockito.when((Object)result.result()).thenReturn((Object)future);
        Mockito.when((Object)this.testAdminClient().computeEvenClusterLoadPlan()).thenReturn((Object)result);
        AdminCommandFailedException thrownException = (AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> {
            void runCommand_balancerCommandOperation;
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)client -> {
                ClusterRebalanceCommand$.MODULE$.computeEvenClusterLoadPlan(client);
                return BoxedUnit.UNIT;
            };
            MockAdminClient runCommand_mockAdminClient = this.testAdminClient();
            String[] runCommand_args = (String[])((Object[])new String[]{"--rebalance-dry-run"});
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = () -> ClusterRebalanceCommandTest.$anonfun$runCommand$1(this, runCommand_args, runCommand_mockAdminClient, (Function1)runCommand_balancerCommandOperation);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream runCommand_grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void runCommand_grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)runCommand_grabConsoleOutput_out, (Function0)runCommand_grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            runCommand_grabConsoleOutput_out.toString();
        }, () -> "Expected PlanComputationException to be thrown when plan computation fails.");
        ((ConfluentAdmin)Mockito.verify((Object)this.testAdminClient())).computeEvenClusterLoadPlan();
        Assertions.assertEquals(RebalancePlanComputationException.class, thrownException.getCause().getClass());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnevenLoadTask$2(EvenClusterLoadStatus x$2) {
        return !x$2.equals((Object)EvenClusterLoadStatus.STARTING);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnevenLoadTask$3(EvenClusterLoadStatus x$3) {
        return !x$3.equals((Object)EvenClusterLoadStatus.BALANCING);
    }

    public static final /* synthetic */ void $anonfun$testDescribeUnevenLoadTask$1(ClusterRebalanceCommandTest $this, EvenClusterLoadStatus currentStatus) {
        $this.validateOutputAndErrorForUnevenLoadStatus(currentStatus, null);
        if (!currentStatus.equals((Object)EvenClusterLoadStatus.STARTING)) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])EvenClusterLoadStatus.values())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterRebalanceCommandTest.$anonfun$testDescribeUnevenLoadTask$2(x$2))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterRebalanceCommandTest.$anonfun$testDescribeUnevenLoadTask$3(x$3))))).foreach((Function1 & Serializable & scala.Serializable)prevStatus -> {
                $this.validateOutputAndErrorForUnevenLoadStatus(currentStatus, prevStatus);
                return BoxedUnit.UNIT;
            });
        }
    }

    public ClusterRebalanceCommandTest() {
        this.bootstrapServer = "localhost:9092";
    }
}

