/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!\u0002\f\u0018\u0003\u0003a\u0002\"B\u0014\u0001\t\u0003A\u0003\"\u0002\u0016\u0001\t\u0003Y\u0003\"\u0002\u001a\u0001\t\u0003Z\u0003bB\u001a\u0001\u0001\u0004%\t\u0001\u000e\u0005\b\u0001\u0002\u0001\r\u0011\"\u0001B\u0011\u00199\u0005\u0001)Q\u0005k!I\u0001\n\u0001a\u0001\u0002\u0004%\t!\u0013\u0005\n+\u0002\u0001\r\u00111A\u0005\u0002YC\u0011\u0002\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002&\t\u000be\u0003A\u0011\t.\t\u000b\u0001\u0004A\u0011I1\t\u000b\u0019\u0004A\u0011A1\t\u000b-\u0004A\u0011A1\t\u000b5\u0004A\u0011\u00018\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\tI\u0006\u0001C\u0001\u00037B\u0011\"! \u0001#\u0003%\t!a \t\u0013\u0005U\u0005!%A\u0005\u0002\u0005]%\u0001\u0007\"bg\u0016\fE-\\5o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011\u0001$G\u0001\u0004CBL'\"\u0001\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001!H\u0011\u0011\u0005yyR\"A\f\n\u0005\u0001:\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011J\u0012!B;uS2\u001c\u0018B\u0001\u0014$\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0015\u0011\u0005y\u0001\u0011a\u00032s_.,'oQ8v]R,\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0004\u0013:$\u0018a\u00037pO\u0012K'oQ8v]R\f\u0001\u0002^3ti&sgm\\\u000b\u0002kA\u0011aGP\u0007\u0002o)\u0011\u0001\u0004\u000f\u0006\u0003si\nqA[;qSR,'O\u0003\u0002<y\u0005)!.\u001e8ji*\tQ(A\u0002pe\u001eL!aP\u001c\u0003\u0011Q+7\u000f^%oM>\fA\u0002^3ti&sgm\\0%KF$\"AQ#\u0011\u00055\u001a\u0015B\u0001#/\u0005\u0011)f.\u001b;\t\u000f\u0019+\u0011\u0011!a\u0001k\u0005\u0019\u0001\u0010J\u0019\u0002\u0013Q,7\u000f^%oM>\u0004\u0013AB2mS\u0016tG/F\u0001K!\tY5+D\u0001M\u0015\tie*A\u0003bI6LgN\u0003\u0002P!\u000691\r\\5f]R\u001c(B\u0001\u000eR\u0015\t\u0011F(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003)2\u0013Q!\u00113nS:\f!b\u00197jK:$x\fJ3r)\t\u0011u\u000bC\u0004G\u0011\u0005\u0005\t\u0019\u0001&\u0002\u000f\rd\u0017.\u001a8uA\u0005)1/\u001a;VaR\u0011!i\u0017\u0005\u0006g)\u0001\r!\u000e\u0015\u0003\u0015u\u0003\"A\u000e0\n\u0005};$A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001CQ\tY1\r\u0005\u00027I&\u0011Qm\u000e\u0002\n\u0003\u001a$XM]#bG\"\fa\u0003^3ti\u000e\u0013X-\u0019;f\t\u0016dW\r^3U_BL7m\u001d\u0015\u0003\u0019!\u0004\"AN5\n\u0005)<$\u0001\u0002+fgR\f\u0001\u0004^3ti\u0006+H\u000f[8sSj,Gm\u00149fe\u0006$\u0018n\u001c8tQ\ti\u0001.\u0001\u000fd_:4\u0017nZ;sK\u0012\u001cE.^:uKJ\u0004VM]7jgNLwN\\:\u0016\u0003=\u00042\u0001]<{\u001d\t\tX\u000f\u0005\u0002s]5\t1O\u0003\u0002u7\u00051AH]8pizJ!A\u001e\u0018\u0002\rA\u0013X\rZ3g\u0013\tA\u0018PA\u0002TKRT!A\u001e\u0018\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0002bG2T!a )\u0002\r\r|W.\\8o\u0013\r\t\u0019\u0001 \u0002\r\u0003\u000edw\n]3sCRLwN\\\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0007\t\u000bI\u0001C\u0004\u0002\f=\u0001\r!!\u0004\u0002\u000f\r|gNZ5hgB1\u0011qBA\u000b\u00033i!!!\u0005\u000b\u0007\u0005Ma&\u0001\u0006d_2dWm\u0019;j_:LA!a\u0006\u0002\u0012\t\u00191+Z9\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!Q\u000f^5m\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003YY'/\u00194u\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e\u001cHCAA\u0007\u00031\u0019'/Z1uK\u000e{gNZ5h+\t\t\t\u0004\u0005\u0005\u0002\u001c\u0005M\u0012qGA\u001f\u0013\u0011\t)$!\b\u0003\u00075\u000b\u0007\u000fE\u0002q\u0003sI1!a\u000fz\u0005\u0019\u0019FO]5oOB!\u0011qHA#\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0005\u0012\u0001\u00027b]\u001eLA!a\u0012\u0002B\t1qJ\u00196fGR\fQb^1ji\u001a{'\u000fV8qS\u000e\u001cHc\u0002\"\u0002N\u0005=\u0013Q\u000b\u0005\u0006\u0011J\u0001\rA\u0013\u0005\b\u0003#\u0012\u0002\u0019AA*\u0003=)\u0007\u0010]3di\u0016$\u0007K]3tK:$\bCBA\b\u0003+\t9\u0004C\u0004\u0002XI\u0001\r!a\u0015\u0002\u001f\u0015D\b/Z2uK\u0012l\u0015n]:j]\u001e\f\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0015\u0005u\u00131MA3\u0003S\n\u0019\bE\u0002L\u0003?J1!!\u0019M\u0005A!v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eC\u0003I'\u0001\u0007!\nC\u0004\u0002hM\u0001\r!a\u000e\u0002\u000bQ|\u0007/[2\t\u0013\u0005-4\u0003%AA\u0002\u00055\u0014a\u00043fg\u000e\u0014\u0018NY3PaRLwN\\:\u0011\u0007-\u000by'C\u0002\u0002r1\u0013Q\u0003R3tGJL'-\u001a+pa&\u001c7o\u00149uS>t7\u000fC\u0005\u0002vM\u0001\n\u00111\u0001\u0002x\u0005AR\r\u001f9fGR,GMT;n!\u0006\u0014H/\u001b;j_:\u001cx\n\u001d;\u0011\t5\nI\bL\u0005\u0004\u0003wr#AB(qi&|g.\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0002*\"\u0011QNABW\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u0013Ut7\r[3dW\u0016$'bAAH]\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0015\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\"TCAAMU\u0011\t9(a!)\u000f\u0001\ti*a)\u0002&B\u0019a'a(\n\u0007\u0005\u0005vGA\u0004US6,w.\u001e;\u0002\u000bY\fG.^3\u001f\u0003a\u0004")
public abstract class BaseAdminIntegrationTest
extends IntegrationTestHarness {
    private TestInfo testInfo = null;
    private Admin client;

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public TestInfo testInfo() {
        return this.testInfo;
    }

    public void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.brokers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    @Test
    public void testCreateDeleteTopics() {
        this.client_$eq(Admin.create(this.createConfig()));
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)new .colon.colon((Object)"mytopic3", (List)Nil$.MODULE$)));
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$))).asJava())}))).asJava()), (List)new .colon.colon((Object)new NewTopic("mytopic2", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty()))), (List)Nil$.MODULE$)));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.validateMetadataAndConfigs$1(validateResult);
        CreateTopicsResult createResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        this.validateMetadataAndConfigs$1(createResult);
        scala.collection.immutable.Map<String, Uuid> topicIds = this.getTopicIds();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            BaseAdminIntegrationTest.$anonfun$testCreateDeleteTopics$1(createResult, topicIds, topic);
            return BoxedUnit.UNIT;
        });
        CreateTopicsResult failedCreateResult = this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava());
        java.util.Map results = failedCreateResult.values();
        Assertions.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertTrue((boolean)results.containsKey("mytopic3"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.numPartitions("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.replicationFactor("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.config("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).allTopicNames().get();
        Assertions.assertEquals((Object)topics.toSet(), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assertions.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assertions.assertEquals((int)2, (int)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assertions.assertEquals((int)1, (int)topic0Partition0.leader().id());
        Assertions.assertEquals((int)0, (int)topic0Partition0.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assertions.assertEquals((int)2, (int)topic0Partition1.leader().id());
        Assertions.assertEquals((int)1, (int)topic0Partition1.partition());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assertions.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assertions.assertEquals((int)3, (int)topic1.partitions().size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartitionInfo partition = (TopicPartitionInfo)topic1.partitions().get(partitionId);
            Assertions.assertEquals((int)partitionId, (int)partition.partition());
            Assertions.assertEquals((int)3, (int)partition.replicas().size());
            partition.replicas().forEach(replica -> {
                Assertions.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
                Assertions.assertTrue((replica.id() < this.brokerCount() ? 1 : 0) != 0);
            });
            Assertions.assertEquals((int)partition.replicas().size(), (int)((SeqLike)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size(), (String)"No duplicate replica ids");
            Assertions.assertEquals((int)3, (int)partition.isr().size());
            Assertions.assertEquals((Object)partition.replicas(), (Object)partition.isr());
            Assertions.assertTrue((boolean)partition.replicas().contains(partition.leader()));
        });
        TopicDescription topic3 = (TopicDescription)topicToDescription.get("mytopic3");
        Assertions.assertEquals((Object)"mytopic3", (Object)topic3.name());
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (int)topic3.partitions().size());
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (int)((TopicPartitionInfo)topic3.partitions().get(0)).replicas().size());
        this.client().deleteTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testAuthorizedOperations() {
        this.client_$eq(Admin.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Assertions.assertNull((Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        Assertions.assertEquals((Object)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configuredClusterPermissions()).asJava()), (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        TopicDescription topicResult = this.getTopicMetadata(this.client(), topic, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assertions.assertNull((Object)topicResult.authorizedOperations());
        topicResult = this.getTopicMetadata(this.client(), topic, new DescribeTopicsOptions().includeAuthorizedOperations(true), this.getTopicMetadata$default$4());
        Assertions.assertEquals((Object)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.TOPIC)).asJava()), (Object)topicResult.authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER);
    }

    @Override
    public void modifyConfigs(Seq<Properties> configs) {
        super.modifyConfigs(configs);
        if (this.testInfo().getTestMethod().toString().contains("testCreateTopicsReturnsConfigs")) {
            configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
                config.setProperty(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
                config.setProperty(KafkaConfig$.MODULE$.LogRetentionTimeMinutesProp(), "240");
                return config.setProperty(KafkaConfig$.MODULE$.LogRollTimeJitterMillisProp(), "123");
            });
        }
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            if (!config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp())) {
                return config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass");
            }
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Properties> kraftControllerConfigs() {
        void var2_2;
        Properties controllerConfig = new Properties();
        if (this.testInfo().getTestMethod().toString().contains("testCreateTopicsReturnsConfigs")) {
            controllerConfig.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1");
        }
        .colon.colon controllerConfigs = new .colon.colon((Object)controllerConfig, (List)Nil$.MODULE$);
        this.modifyConfigs((Seq<Properties>)controllerConfigs);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.put("request.timeout.ms", "20000");
        TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties()).forEach((key, value) -> config.put((String)key, (String)value));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void waitForTopics(Admin client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$waitForTopics$1(client, expectedPresent, expectedMissing)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseAdminIntegrationTest.$anonfun$waitForTopics$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public TopicDescription getTopicMetadata(Admin client, String topic, DescribeTopicsOptions describeOptions, Option<Object> expectedNumPartitionsOpt) {
        ObjectRef result = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$getTopicMetadata$1(client, topic, describeOptions, result, expectedNumPartitionsOpt)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BaseAdminIntegrationTest.$anonfun$getTopicMetadata$4(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (TopicDescription)result.elem;
    }

    public DescribeTopicsOptions getTopicMetadata$default$3() {
        return new DescribeTopicsOptions();
    }

    public Option<Object> getTopicMetadata$default$4() {
        return None$.MODULE$;
    }

    private final void validateMetadataAndConfigs$1(CreateTopicsResult result) {
        Assertions.assertEquals((int)2, (Integer)((Integer)result.numPartitions("mytopic").get()));
        Assertions.assertEquals((int)2, (Integer)((Integer)result.replicationFactor("mytopic").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.numPartitions("mytopic2").get()));
        Assertions.assertEquals((int)3, (Integer)((Integer)result.replicationFactor("mytopic2").get()));
        Assertions.assertEquals((Integer)((KafkaConfig)this.configs().head()).numPartitions(), (Integer)((Integer)result.numPartitions("mytopic3").get()));
        Assertions.assertEquals((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (Integer)((Integer)result.replicationFactor("mytopic3").get()));
        Assertions.assertFalse((boolean)((Config)result.config("mytopic").get()).entries().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$1(CreateTopicsResult createResult$1, scala.collection.immutable.Map topicIds$1, String topic) {
        Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)createResult$1.topicId(topic).get());
        Assertions.assertEquals((Object)topicIds$1.apply((Object)topic), (Object)createResult$1.topicId(topic).get());
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$3(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$1(Admin client$1, Seq expectedPresent$1, Seq expectedMissing$1) {
        java.util.Set topics = (java.util.Set)client$1.listTopics().names().get();
        return expectedPresent$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$waitForTopics$3(topics, topicName)));
    }

    public static final /* synthetic */ String $anonfun$waitForTopics$4() {
        return "timed out waiting for topics";
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$1(Admin client$2, String topic$1, DescribeTopicsOptions describeOptions$1, ObjectRef result$1, Option expectedNumPartitionsOpt$1) {
        KafkaFuture topicResult = (KafkaFuture)client$2.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava(), describeOptions$1).topicNameValues().get(topic$1);
        try {
            result$1.elem = (TopicDescription)topicResult.get();
            return BoxesRunTime.unboxToBoolean((Object)expectedNumPartitionsOpt$1.map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 == ((TopicDescription)result$1.elem).partitions().size()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof ExecutionException) || !(((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException)) {
                throw throwable;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$getTopicMetadata$4(String topic$1) {
        return new StringBuilder(35).append("Timed out waiting for metadata for ").append(topic$1).toString();
    }
}

