/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.FixedPortTestUtils$;
import kafka.log.AbstractLog;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001\u0002\u00180\u0001QBQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r=\u0004\u0001\u0015!\u0003d\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015a\b\u0001\"\u0003~\u0011%\t)\u0002AI\u0001\n\u0013\t9\u0002C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005=\u0003\u0001\"\u0001\u00020!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA1\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\tY\u0007\u0001C\u0001\u0003_Aq!a\u001c\u0001\t\u0003\ty\u0003C\u0004\u0002\u0002\u0002!I!a!\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u00111\u0014\u0001\u0005\n\u0005u\u0005bBAR\u0001\u0011%\u0011Q\u0015\u0005\b\u0003c\u0003A\u0011AA\u0018\u0011\u001d\t9\f\u0001C\u0001\u0003_Aq!a/\u0001\t\u0003\ty\u0003C\u0004\u0002@\u0002!I!!1\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9!\u0011\u0002\u0001\u0005\n\t-\u0001\"\u0003B\u000b\u0001E\u0005I\u0011\u0002B\f\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqAa\u0010\u0001\t\u0013\u0011\tE\u0002\u0004\u0003J\u0001!!1\n\u0005\n\u0003?\n#Q1A\u0005\u0002\rC\u0011Ba\u0015\"\u0005\u0003\u0005\u000b\u0011\u0002#\t\r}\nC\u0011\u0001B+\u0011!\u0011Y&\ta\u0001\n\u0003\u0019\u0005\"\u0003B/C\u0001\u0007I\u0011\u0001B0\u0011\u001d\u0011)'\tQ!\n\u0011CqAa\u001a\"\t\u0003\ny\u0003C\u0004\u0003j\u0001!IAa\u001b\t\u0013\tU\u0005!%A\u0005\n\t]\u0005b\u0002BN\u0001\u0011%!Q\u0014\u0005\n\u0005k\u0003\u0011\u0013!C\u0005\u0003/A\u0011Ba.\u0001#\u0003%IA!/\u0003%\r{gn];nKJ\u0014u.\u001e8dKR+7\u000f\u001e\u0006\u0003aE\n1!\u00199j\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0004\u0001UJ\u0004C\u0001\u001c8\u001b\u0005y\u0013B\u0001\u001d0\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3tiB\u0011!(P\u0007\u0002w)\u0011A(M\u0001\u0006kRLGn]\u0005\u0003}m\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003B\u0011a\u0007A\u0001\r[\u0006DxI]8vaNK'0Z\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n\u0019\u0011J\u001c;\u0002\u001b5\f\u0007p\u0012:pkB\u001c\u0016N_3!\u0003M9'/Y2fMVd7\t\\8tKRKW.Z't+\u0005i\u0005cA#O!&\u0011qJ\u0012\u0002\u0005'>lW\r\u0005\u0002F#&\u0011!K\u0012\u0002\u0005\u0019>tw-\u0001\u000bhe\u0006\u001cWMZ;m\u00072|7/\u001a+j[\u0016l5\u000fI\u0001\tKb,7-\u001e;peV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005mc\u0016\u0001B;uS2T\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`1\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013aD2p]N,X.\u001a:Q_2dWM]:\u0016\u0003\r\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001b$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002kK\n1!)\u001e4gKJ\u0004\"\u0001\\7\u000e\u0003\u0001I!A\\\u001c\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'/\u0001\td_:\u001cX/\\3s!>dG.\u001a:tA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001s!\r\u0019HO^\u0007\u0002O&\u0011Qo\u001a\u0002\u0004'\u0016\f\bCA<{\u001b\u0005A(BA=2\u0003\u0019\u0019XM\u001d<fe&\u00111\u0010\u001f\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u000bhK:,'/\u0019;f\u0017\u000647.Y\"p]\u001aLwm\u001d\u000b\u0003ezDqAQ\u0006\u0011\u0002\u0003\u0007q\u0010\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002G\u001b\t\t9AC\u0002\u0002\nM\na\u0001\u0010:p_Rt\u0014bAA\u0007\r\u00061\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004G\u0003y9WM\\3sCR,7*\u00194lC\u000e{gNZ5hg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a)\u001aq0a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\nG\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003c\u00012!RA\u001a\u0013\r\t)D\u0012\u0002\u0005+:LG\u000fK\u0002\u000e\u0003s\u0001B!a\u000f\u0002L5\u0011\u0011Q\b\u0006\u0004a\u0005}\"\u0002BA!\u0003\u0007\nqA[;qSR,'O\u0003\u0003\u0002F\u0005\u001d\u0013!\u00026v]&$(BAA%\u0003\ry'oZ\u0005\u0005\u0003\u001b\niDA\u0005BMR,'/R1dQ\u0006\tC/Z:u\u0007>t7/^7qi&|gnV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fg\"\u001aa\"a\u0015\u0011\t\u0005m\u0012QK\u0005\u0005\u0003/\niD\u0001\u0003UKN$\u0018!G2p]N,X.Z,ji\"\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKN$B!!\r\u0002^!1\u0011qL\bA\u0002\u0011\u000b\u0001B\\;n\u0013R,'o]\u0001$i\u0016\u001cHoU3fW\u0006sGmQ8n[&$x+\u001b;i\u0005J|7.\u001a:GC&dWO]3tQ\r\u0001\u00121K\u0001 g\u0016,7.\u00118e\u0007>lW.\u001b;XSRD'I]8lKJ4\u0015-\u001b7ve\u0016\u001cH\u0003BA\u0019\u0003SBa!a\u0018\u0012\u0001\u0004!\u0015!\t;fgR\u001cVOY:de&\u0014Wm\u00165f]R{\u0007/[2V]\u00064\u0018-\u001b7bE2,\u0007f\u0001\n\u0002T\u0005IA/Z:u\u00072|7/\u001a\u0015\b'\u0005M\u0014\u0011PA>!\u0011\tY$!\u001e\n\t\u0005]\u0014Q\b\u0002\t\t&\u001c\u0018M\u00197fI\u0006)a/\u00197vK\u0006\u0012\u0011QP\u0001\r\u00072KUI\u0014+T[EJ$g\r\u0015\u0004'\u0005M\u0013AE2iK\u000e\\7\t\\8tK\u001e{w\u000e\u001a)bi\"$b!!\r\u0002\u0006\u0006%\u0005BBAD)\u0001\u0007A)\u0001\u0006ok6\u0014VmY8sINDa!a#\u0015\u0001\u0004y\u0018aB4s_V\u0004\u0018\nZ\u0001!G\",7m[\"m_N,w+\u001b;i\u0007>|'\u000fZ5oCR|'OR1jYV\u0014X\r\u0006\u0005\u00022\u0005E\u00151SAL\u0011\u0019\t9)\u0006a\u0001\t\"1\u0011QS\u000bA\u0002}\fA\u0002Z=oC6L7m\u0012:pkBDa!!'\u0016\u0001\u0004y\u0018aC7b]V\fGn\u0012:pkB\fqBZ5oI\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0004\t\u0006}\u0005BBAQ-\u0001\u0007q0A\u0003he>,\b/\u0001\u000fdQ\u0016\u001c7n\u00117pg\u0016<\u0016\u000e\u001e5DYV\u001cH/\u001a:GC&dWO]3\u0015\u0011\u0005E\u0012qUAU\u0003[Ca!a\"\u0018\u0001\u0004!\u0005BBAV/\u0001\u0007q0\u0001\u0004he>,\b/\r\u0005\u0007\u0003_;\u0002\u0019A@\u0002\r\u001d\u0014x.\u001e93\u0003\u0019#Xm\u001d;S_2d\u0017N\\4Ce>\\WM\u001d*fgR\f'\u000f^:XSRD7+\\1mY\u0016\u0014X*\u0019=He>,\boU5{K\u000e{gNZ5h\t&\u001c(/\u001e9ug\nKwm\u0012:pkBDs\u0001GA:\u0003s\nY\bK\u0002\u0019\u0003'\n\u0001\b^3ti\u000e{gn];nKJ\u0014VmY3jm\u0016\u001ch)\u0019;bY\u0016C8-\u001a9uS>tw\u000b[3o\u000fJ|W\u000f\u001d)bgN,7/T1y'&TX\rK\u0002\u001a\u0003'\n\u0001\u0004^3ti\u000ecwn]3EkJLgn\u001a*fE\u0006d\u0017M\\2fQ\rQ\u00121K\u0001\u001aG\",7m[\"m_N,G)\u001e:j]\u001e\u0014VMY1mC:\u001cW\r\u0006\u0006\u00022\u0005\r\u0017QYAe\u0003#Da!a#\u001c\u0001\u0004y\bBBAd7\u0001\u0007q0A\u0003u_BL7\r\u0003\u0004U7\u0001\u0007\u00111\u001a\t\u0004/\u00065\u0017bAAh1\nyQ\t_3dkR|'oU3sm&\u001cW\rC\u0004\u0002Tn\u0001\r!!6\u00027\t\u0014xn[3sg\u00063\u0018-\u001b7bE2,G)\u001e:j]\u001e\u001cEn\\:f!\r)\u0015q[\u0005\u0004\u000334%a\u0002\"p_2,\u0017M\\\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3s\u0003:$'+Z2fSZ,G\u0003CAp\u0005\u0003\u0011\u0019Aa\u0002\u0011\u0011\u0005\u0005\u0018\u0011_A{\u0003kl!!a9\u000b\t\u0005\u0015\u0018q]\u0001\tG>t7/^7fe*!\u0011\u0011^Av\u0003\u001d\u0019G.[3oiNT1AMAw\u0015\u0011\ty/a\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\u00190a9\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015)\u0015q_A~\u0013\r\tIP\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u000b\u0006u\u0018bAA\u0000\r\n!!)\u001f;f\u0011\u0019\tY\t\ba\u0001\u007f\"9!Q\u0001\u000fA\u0002\u0005U\u0017\u0001D7b]V\fG.Q:tS\u001et\u0007BBAD9\u0001\u0007A)A\nsK\u000e,\u0017N^3Fq\u0006\u001cGOU3d_J$7\u000f\u0006\u0005\u00022\t5!q\u0002B\t\u0011\u0019\t)/\ba\u0001W\"1\u0011qQ\u000fA\u0002\u0011C\u0001Ba\u0005\u001e!\u0003\u0005\r\u0001U\u0001\ni&lWm\\;u\u001bN\fQD]3dK&4X-\u0012=bGR\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0003\u00053Q3\u0001UA\u000e\u0003Y\u0019XOY7ji\u000ecwn]3B]\u00124\u0016\r\\5eCR,GC\u0003B\u0010\u0005W\u0011iC!\r\u0003<A)qK!\t\u0003&%\u0019!1\u0005-\u0003\r\u0019+H/\u001e:f!\r)%qE\u0005\u0004\u0005S1%aA!os\"9\u0011Q]\u0010A\u0002\u0005}\u0007B\u0002B\u0018?\u0001\u0007\u0001+\u0001\bdY>\u001cX\rV5nK>,H/T:\t\u000f\tMr\u00041\u0001\u00036\u0005qQ.\u001b8DY>\u001cX\rV5nK6\u001b\b\u0003B#\u00038AK1A!\u000fG\u0005\u0019y\u0005\u000f^5p]\"9!QH\u0010A\u0002\tU\u0012AD7bq\u000ecwn]3US6,Wj]\u0001\u0011G\",7m[\"m_N,Gm\u0015;bi\u0016$b!!\r\u0003D\t\u0015\u0003BBAFA\u0001\u0007q\u0010\u0003\u0004\u0003H\u0001\u0002\r\u0001R\u0001\u0011G>lW.\u001b;uK\u0012\u0014VmY8sIN\u0014QCQ8v]\u000e,'I]8lKJ\u001c6\r[3ek2,'oE\u0002\"\u0005\u001b\u00022A\u000fB(\u0013\r\u0011\tf\u000f\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-A\u0005ok6LE/\u001a:tAQ!!q\u000bB-!\ta\u0017\u0005\u0003\u0004\u0002`\u0011\u0002\r\u0001R\u0001\u0005SR,'/\u0001\u0005ji\u0016\u0014x\fJ3r)\u0011\t\tD!\u0019\t\u0011\t\rd%!AA\u0002\u0011\u000b1\u0001\u001f\u00132\u0003\u0015IG/\u001a:!\u0003\u0019!wnV8sW\u0006)2M]3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cHC\u0003B7\u0005\u007f\u0012\tI!\"\u0003\nB1\u0011\u0011\u0001B8\u0005gJAA!\u001d\u0002\u0014\t\u00191+\u001a;\u0011\t\tU$1P\u0007\u0003\u0005oRAA!\u001f\u0002l\u000611m\\7n_:LAA! \u0003x\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BBAdS\u0001\u0007q\u0010\u0003\u0004\u0003\u0004&\u0002\r\u0001R\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r\t\u001d\u0015\u00061\u0001E\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\n\u0005\u0017K\u0003\u0013!a\u0001\u0005\u001b\u000b1\u0002^8qS\u000e\u001cuN\u001c4jOB!!q\u0012BI\u001b\u0005Q\u0016b\u0001BJ5\nQ\u0001K]8qKJ$\u0018.Z:\u0002?\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8og\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u001a*\"!QRA\u000e\u00031\u0001(o\u001c3vG\u0016\u00148+\u001a8e))\t\tDa(\u0003.\n=&\u0011\u0017\u0005\b\u0005C[\u0003\u0019\u0001BR\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003\u0003BS\u0005S\u000b)0!>\u000e\u0005\t\u001d&\u0002\u0002BQ\u0003OLAAa+\u0003(\ni1*\u00194lCB\u0013x\u000eZ;dKJDa!a\",\u0001\u0004!\u0005\u0002CAdWA\u0005\t\u0019A@\t\u0013\t\r5\u0006%AA\u0002\tM\u0006\u0003B#\u00038\u0011\u000ba\u0003\u001d:pIV\u001cWM]*f]\u0012$C-\u001a4bk2$HeM\u0001\u0017aJ|G-^2feN+g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0018\u0016\u0005\u0005g\u000bY\u0002")
public class ConsumerBounceTest
extends AbstractConsumerTest {
    private final int maxGroupSize;
    private final Some<Object> gracefulCloseTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public Some<Object> gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers() {
        return this.consumerPollers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties), Seq$.MODULE$.canBuildFrom());
    }

    private String generateKafkaConfigs$default$1() {
        return Integer.toString(this.maxGroupSize());
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            this.consumerPollers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            this.executor().shutdownNow();
            Assertions.assertTrue((boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS), (String)"Executor did not terminate");
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.producerSend$default$3(), this.producerSend$default$4());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(Duration.ofMillis(100L))).asScala();
            records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Assertions.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    /*
     * WARNING - void declaration
     */
    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.producerSend$default$3(), this.producerSend$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$1(this, numRecords)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assertions.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Seeking to ").append(pos).toString());
                consumer.seek(this.tp(), pos);
                Assertions.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Assertions.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.brokerCount(), this.$outer.brokerCount(), this.$outer.createTopic$default$4(), this.$outer.createTopic$default$5(), this.$outer.createTopic$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(Duration.ZERO);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AbstractConsumerTest.ConsumerAssignmentPoller poller = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller);
        poller.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
        poller.shutdown();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        AbstractConsumerTest.ConsumerAssignmentPoller poller2 = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller2);
        poller2.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
    }

    @Test
    @Disabled(value="CLIENTS-1923")
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.producerSend$default$3(), this.producerSend$default$4());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    /*
     * WARNING - void declaration
     */
    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setCoordinatorKeys(Collections.singletonList(group))).build();
        IntRef nodeId = IntRef.create((int)-1);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$findCoordinator$1(this, request, nodeId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$findCoordinator$2(group));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return nodeId.elem;
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", Integer.toString(requestTimeout));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Disabled(value="CLIENTS-1923")
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String group = "group-max-size-test";
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        int partitionCount = consumerCount * 2;
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, partitionCount, this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(consumerCount, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(Integer.toString(maxGroupSize));
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)serverIdx -> {
            this.killBroker(serverIdx);
            KafkaConfig config = (KafkaConfig)newConfigs.apply(serverIdx);
            this.servers().update(serverIdx, (Object)TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId())));
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)this.raisedExceptions$1().size());
        Assertions.assertTrue((boolean)(this.raisedExceptions$1().head() instanceof GroupMaxSizeReachedException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        void var5_5;
        String group = "fatal-exception-test";
        String topic = "fatal-exception-test";
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, this.maxGroupSize(), this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(this.maxGroupSize(), (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.addConsumersToGroup(1, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer rejectedConsumerPollers = (Buffer)tuple2._2();
        AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer = (AbstractConsumerTest.ConsumerAssignmentPoller)((Object)var5_5.head());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(rejectedConsumer)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)(rejectedConsumer.thrownException().get() instanceof GroupMaxSizeReachedException));
        this.producerSend(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()), this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitions.size())));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, executor, topic);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, executor, topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller = manualAssign ? this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)Nil$.MODULE$, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})))) : this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        this.receiveExactRecords(consumerPoller, numRecords, this.receiveExactRecords$default$3());
        consumerPoller.shutdown();
        return consumer;
    }

    /*
     * WARNING - void declaration
     */
    private void receiveExactRecords(AbstractConsumerTest.ConsumerAssignmentPoller consumer, int numRecords, long timeoutMs) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$receiveExactRecords$1(consumer, numRecords)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeoutMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$receiveExactRecords$2(numRecords, consumer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeoutMs), (long)waitUntilTrue_pause));
        }
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(() -> {
            int closeGraceTimeMs = 2000;
            long startMs = System.currentTimeMillis();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Closing consumer with timeout ").append(closeTimeoutMs).append(" ms.").toString());
            consumer.close(Duration.ofMillis(closeTimeoutMs));
            long timeTakenMs = System.currentTimeMillis() - startMs;
            maxCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assertions.assertTrue((timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0, (String)new StringBuilder(20).append("Close took too long ").append(timeTakenMs).toString()));
            minCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assertions.assertTrue((timeTakenMs >= ms ? 1 : 0) != 0, (String)new StringBuilder(27).append("Close finished too quickly ").append(timeTakenMs).toString()));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("consumer.close() completed in ").append(timeTakenMs).append(" ms.").toString());
        }, BoxesRunTime.boxToInteger((int)0));
    }

    /*
     * WARNING - void declaration
     */
    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$checkClosedState$1(consumer, assignSemaphore)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$checkClosedState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        if (committedRecords > 0) {
            Assertions.assertEquals((long)committedRecords, (long)((OffsetAndMetadata)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
        consumer.close();
    }

    private scala.collection.immutable.Set<TopicPartition> createTopicPartitions(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        this.createTopic(topic, numPartitions, replicationFactor, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        return ((TraversableOnce)package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable & scala.Serializable)part -> ConsumerBounceTest.$anonfun$createTopicPartitions$1(topic, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
    }

    private Properties createTopicPartitions$default$4() {
        return new Properties();
    }

    private void producerSend(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        ((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.getPartition$1(numPartitions, partitionIndex)), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes())), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> (RecordMetadata)x$4.get(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String producerSend$default$3() {
        return this.topic();
    }

    private Option<Object> producerSend$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assertions.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$2(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((AbstractLog)server.replicaManager().localLog($this.tp()).get()).highWatermark() == (long)numRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$1(ConsumerBounceTest $this, int numRecords$1) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$2($this, numRecords$1, server)));
    }

    public static final /* synthetic */ String $anonfun$seekAndCommitWithBrokerFailures$3() {
        return "Failed to update high watermark for followers after timeout";
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$1) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            ((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1 & Serializable & scala.Serializable)i -> producer$1.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes())), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assertions.assertEquals((int)0, (int)remainingRecords.elem);
    }

    public static final /* synthetic */ boolean $anonfun$findCoordinator$1(ConsumerBounceTest $this, FindCoordinatorRequest request$1, IntRef nodeId$1) {
        FindCoordinatorResponse response = (FindCoordinatorResponse)$this.connectAndReceive((AbstractRequest)request$1, $this.connectAndReceive$default$2(), $this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        nodeId$1.elem = response.node().id();
        Errors errors = response.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ String $anonfun$findCoordinator$2(String group$1) {
        return new StringBuilder(37).append("Failed to find coordinator for group ").append(group$1).toString();
    }

    private final Seq raisedExceptions$1() {
        return (Seq)this.consumerPollers().flatten((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(x$3.thrownException()));
    }

    public static final /* synthetic */ boolean $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(ConsumerBounceTest $this) {
        return $this.raisedExceptions$1().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4() {
        return "The remaining consumers in the group could not fetch the expected records";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer$1) {
        return rejectedConsumer$1.thrownException().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$2() {
        return "Extra consumer did not throw an exception";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(AbstractConsumerTest.ConsumerAssignmentPoller p) {
        return p.receivedMessages() >= 100;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(ConsumerBounceTest $this) {
        return $this.consumerPollers().forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(p)));
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$5() {
        return "The consumers in the group could not fetch the expected records";
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, ExecutorService executor$1, String topic$2) {
        return executor$1.submit(() -> {
            consumer.subscribe(Collections.singletonList(topic$2));
            revokeSemaphore.foreach((Function1 & Serializable & scala.Serializable)s -> {
                s.release();
                return BoxedUnit.UNIT;
            });
            consumer.poll(0L);
        }, BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumer.poll(Duration.ofMillis(100L)));
        }
        Assertions.assertTrue((boolean)future.isDone(), (String)"Rebalance did not complete in time");
    }

    private final Future createConsumerToRebalance$1(String groupId$1, ExecutorService executor$1, String topic$2) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), executor$1, topic$2);
        Assertions.assertTrue((boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS), (String)"Rebalance not triggered");
        Assertions.assertFalse((boolean)future.isDone(), (String)"Rebalance completed too early");
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$receiveExactRecords$1(AbstractConsumerTest.ConsumerAssignmentPoller consumer$2, int numRecords$2) {
        return consumer$2.receivedMessages() == numRecords$2;
    }

    public static final /* synthetic */ String $anonfun$receiveExactRecords$2(int numRecords$2, AbstractConsumerTest.ConsumerAssignmentPoller consumer$2) {
        return new StringBuilder(48).append("Consumer did not receive expected ").append(numRecords$2).append(". It received ").append(consumer$2.receivedMessages()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkClosedState$1(KafkaConsumer consumer$4, Semaphore assignSemaphore$1) {
        consumer$4.poll(Duration.ofMillis(100L));
        return assignSemaphore$1.tryAcquire();
    }

    public static final /* synthetic */ String $anonfun$checkClosedState$2() {
        return "Assignment did not complete on time";
    }

    public static final /* synthetic */ TopicPartition $anonfun$createTopicPartitions$1(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    private final int getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        int n;
        if (numPartitions$1 instanceof Some) {
            int partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int nextPart = partitionIndex$1.elem % partitions;
            ++partitionIndex$1.elem;
            n = nextPart;
        } else if (None$.MODULE$.equals(numPartitions$1)) {
            n = this.part();
        } else {
            throw new MatchError((Object)numPartitions$1);
        }
        return n;
    }

    public ConsumerBounceTest() {
        this.maxGroupSize = 5;
        this.consumerConfig().setProperty("enable.auto.commit", "true");
    }

    private class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers(this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers$default$1());
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
                return;
            }
            Thread.sleep(500L);
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

