/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.Both$;
import kafka.api.EndToEndAuthorizationTest;
import kafka.metrics.BrokerLoad;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001e4Q\u0001D\u0007\u0002\u0002IAQa\u0006\u0001\u0005\u0002aAQA\u0007\u0001\u0005RmAqa\u000b\u0001C\u0002\u0013EC\u0006\u0003\u0004<\u0001\u0001\u0006I!\f\u0005\by\u0001\u0011\r\u0011\"\u0015-\u0011\u0019i\u0004\u0001)A\u0005[!)a\b\u0001D\t\u007f!)1\n\u0001D\t\u0019\")Q\u000b\u0001C!-\")\u0011\u000e\u0001C\u0001U\")Q\u000f\u0001C\u0001U\ni2+Y:m\u000b:$Gk\\#oI\u0006+H\u000f[8sSj\fG/[8o)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u001b%\u0011a#\u0004\u0002\u001a\u000b:$Gk\\#oI\u0006+H\u000f[8sSj\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011A\u0003A\u0001\u0011g\u0016\u001cWO]5usB\u0013x\u000e^8d_2,\u0012\u0001\b\t\u0003;%j\u0011A\b\u0006\u0003?\u0001\nA!Y;uQ*\u0011\u0011EI\u0001\tg\u0016\u001cWO]5us*\u00111\u0005J\u0001\u0007G>lWn\u001c8\u000b\u0005A)#B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001eL!A\u000b\u0010\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001.!\rq\u0013gM\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!1k\\7f!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003vi&d'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\nAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\u0018!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0019W\u000647.Y\"mS\u0016tGoU1tY6+7\r[1oSNlW#\u0001!\u0011\u0005\u0005CeB\u0001\"G!\t\u0019u&D\u0001E\u0015\t)\u0015#\u0001\u0004=e>|GOP\u0005\u0003\u000f>\na\u0001\u0015:fI\u00164\u0017BA%K\u0005\u0019\u0019FO]5oO*\u0011qiL\u0001\u001aW\u000647.Y*feZ,'oU1tY6+7\r[1oSNl7/F\u0001N!\rq5\u000bQ\u0007\u0002\u001f*\u0011\u0001+U\u0001\nS6lW\u000f^1cY\u0016T!AU\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002U\u001f\n!A*[:u\u0003\u0015\u0019X\r^+q)\t9&\f\u0005\u0002/1&\u0011\u0011l\f\u0002\u0005+:LG\u000fC\u0003\\\u0013\u0001\u0007A,\u0001\u0005uKN$\u0018J\u001c4p!\ti6-D\u0001_\u0015\tqqL\u0003\u0002aC\u00069!.\u001e9ji\u0016\u0014(B\u00012(\u0003\u0015QWO\\5u\u0013\t!gL\u0001\u0005UKN$\u0018J\u001c4pQ\tIa\r\u0005\u0002^O&\u0011\u0001N\u0018\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\f;fgR$vo\\\"p]N,X.\u001a:t/&$\b\u000eR5gM\u0016\u0014XM\u001c;TCNd7I]3eK:$\u0018.\u00197t)\u00059\u0006F\u0001\u0006m!\tiV.\u0003\u0002o=\n!A+Z:uQ\u0011Q\u0001o\u001d;\u0011\u0005u\u000b\u0018B\u0001:_\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012aD\u0001-i\u0016\u001cHO\u0011:pW\u0016\u0014Hj\\1e/&$\bnQ8o]\u0016\u001cG/[8o%\u0016\fW\u000f\u001e5f]RL7-\u0019;j_:D#a\u00037)\t-\u00018\u000f\u001f\u0010\u0002q\u0002")
public abstract class SaslEndToEndAuthorizationTest
extends EndToEndAuthorizationTest {
    private final Some<Properties> serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
    private final Some<Properties> clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_SSL;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public abstract String kafkaClientSaslMechanism();

    public abstract List<String> kafkaServerSaslMechanisms();

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)Option$.MODULE$.apply((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, this.jaasSections$default$4()));
        String clientLoginContext = this.jaasClientLoginModule(this.kafkaClientSaslMechanism(), this.jaasClientLoginModule$default$2());
        this.producerConfig().put("sasl.jaas.config", clientLoginContext);
        this.consumerConfig().put("sasl.jaas.config", clientLoginContext);
        this.adminClientConfig().put("sasl.jaas.config", clientLoginContext);
        this.serverConfig().setProperty("confluent.broker.load.window.size.ms", "1000");
        this.serverConfig().setProperty("confluent.broker.load.num.samples", "1000");
        super.setUp(testInfo);
    }

    @Timeout(value=15L)
    @Test
    public void testTwoConsumersWithDifferentSaslCredentials() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer1 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.consumerConfig().remove("sasl.jaas.config");
        this.consumerConfig().remove("sasl.client.callback.handler.class");
        KafkaConsumer consumer2 = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer1.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer2.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer1, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer2, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            Assertions.fail((String)"Expected exception as consumer2 has no access to topic or group");
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            Assertions.assertTrue((boolean)topicAuthorizationException.unauthorizedTopics().contains(this.topic()));
        }
        catch (GroupAuthorizationException e) {
            Assertions.assertEquals((Object)this.group(), (Object)e.groupId());
        }
        this.confirmReauthenticationMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Timeout(value=120L)
    @Test
    public void testBrokerLoadWithConnectionReauthentication() {
        this.setReadAndWriteAcls(this.tp());
        int NumProducers = 3 * this.servers().size();
        ListBuffer list = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), NumProducers).foreach((Function1 & Serializable & scala.Serializable)_ -> list.$plus$eq(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3())));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        long maxTimeToWait = Duration.ofSeconds(30L).toMillis();
        long reauthTime = new StringOps(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp()))).toLong();
        Map prevServiceTimes = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> prevServiceTimes.put((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()), (Object)BoxesRunTime.boxToDouble((double)0.0)));
        ((KafkaServer)this.servers().head()).time().sleep(reauthTime);
        for (long timeWaited = 0L; timeWaited <= maxTimeToWait; timeWaited += reauthTime) {
            void var2_2;
            var2_2.foreach((Function1 & Serializable & scala.Serializable)producer -> {
                this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp());
                return BoxedUnit.UNIT;
            });
            TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords() * var2_2.size(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((KafkaServer)this.servers().head()).time().sleep(reauthTime);
            this.confirmReauthenticationMetrics();
            this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
                Assertions.assertTrue((boolean)s.socketServer().brokerLoad().isDefined());
                Assertions.assertTrue((boolean)((BrokerLoad)s.socketServer().brokerLoad().get()).weightedAverageTotalServiceLocalTimeMetric().isDefined());
                double totalServiceLocalTime = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)s.socketServer().brokerLoad().get()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
                Assertions.assertTrue((totalServiceLocalTime > 0.0 ? 1 : 0) != 0);
                double prevServiceTime = BoxesRunTime.unboxToDouble((Object)prevServiceTimes.apply((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId())));
                Assertions.assertTrue((prevServiceTime == 0.0 || totalServiceLocalTime < (double)5 * prevServiceTime ? 1 : 0) != 0);
                return prevServiceTimes.put((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()), (Object)BoxesRunTime.boxToDouble((double)totalServiceLocalTime));
            });
        }
    }
}

