/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u00041\u0001\u0001\u0006I\u0001\u000b\u0005\bc\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0011\u0004\u0001)A\u0005Q!91\u0007\u0001b\u0001\n\u0003!\u0004BB\u001e\u0001A\u0003%Q\u0007C\u0004=\u0001\t\u0007I\u0011\u0001\u001b\t\ru\u0002\u0001\u0015!\u00036\u0011%q\u0004\u00011AA\u0002\u0013\u0005q\bC\u0005S\u0001\u0001\u0007\t\u0019!C\u0001'\"I\u0011\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0011\u0005\n5\u0002\u0001\r\u00111A\u0005\u0002mC\u0011\"\u0019\u0001A\u0002\u0003\u0007I\u0011\u00012\t\u0013\u0011\u0004\u0001\u0019!A!B\u0013a\u0006\"B3\u0001\t\u00032\u0007\"B:\u0001\t\u0003\"\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\u0012!\u0004\u0016:b]N\f7\r^5p]N,\u0005\u0010]5sCRLwN\u001c+fgRT!a\u0006\r\u0002\u0007\u0005\u0004\u0018NC\u0001\u001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}A\u0012aC5oi\u0016<'/\u0019;j_:L!!\t\u0010\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\f\u0002\rQ|\u0007/[22+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011a\u0017M\\4\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\u000fQ|\u0007/[22A\u00051Ao\u001c9jGJ\nq\u0001^8qS\u000e\u0014\u0004%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002kA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0002%I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\taJ|G-^2feV\t\u0001\t\u0005\u0003B\u00152cU\"\u0001\"\u000b\u0005y\u001a%B\u0001#F\u0003\u001d\u0019G.[3oiNT!!\u0007$\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'oZ\u0005\u0003\u0017\n\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bc\u0001\u001cN\u001f&\u0011aj\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003mAK!!U\u001c\u0003\t\tKH/Z\u0001\raJ|G-^2fe~#S-\u001d\u000b\u0003)^\u0003\"AN+\n\u0005Y;$\u0001B+oSRDq\u0001W\u0006\u0002\u0002\u0003\u0007\u0001)A\u0002yIE\n\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u0011\r|gn];nKJ,\u0012\u0001\u0018\t\u0005;~cE*D\u0001_\u0015\tQ6)\u0003\u0002a=\ni1*\u00194lC\u000e{gn];nKJ\fAbY8ogVlWM]0%KF$\"\u0001V2\t\u000fas\u0011\u0011!a\u00019\u0006I1m\u001c8tk6,'\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tq\rE\u0002iW6l\u0011!\u001b\u0006\u0003U^\n!bY8mY\u0016\u001cG/[8o\u0013\ta\u0017NA\u0002TKF\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\r\u0002\rM,'O^3s\u0013\t\u0011xNA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!B:fiV\u0003HC\u0001+v\u0011\u00151\u0018\u00031\u0001x\u0003!!Xm\u001d;J]\u001a|\u0007C\u0001=\u007f\u001b\u0005I(BA\f{\u0015\tYH0A\u0004kkBLG/\u001a:\u000b\u0005uD\u0015!\u00026v]&$\u0018BA@z\u0005!!Vm\u001d;J]\u001a|\u0007fA\t\u0002\u0004A\u0019\u00010!\u0002\n\u0007\u0005\u001d\u0011P\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002)\"\u001a!#a\u0004\u0011\u0007a\f\t\"C\u0002\u0002\u0014e\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002oQ,7\u000f\u001e\"v[B$&/\u00198tC\u000e$\u0018n\u001c8bY\u0016\u0003xn\u00195BMR,'/\u00138wC2LG\r\u0015:pIV\u001cWM]%e\u001b\u0006\u0004\b/\u001b8h)\r!\u0016\u0011\u0004\u0005\b\u00037\u0019\u0002\u0019AA\u000f\u0003\u0019\tXo\u001c:v[B!\u0011qDA\u0017\u001d\u0011\t\t#!\u000b\u0011\u0007\u0005\rr'\u0004\u0002\u0002&)\u0019\u0011q\u0005\u000e\u0002\rq\u0012xn\u001c;?\u0013\r\tYcN\u0001\u0007!J,G-\u001a4\n\u0007=\nyCC\u0002\u0002,]BsaEA\u001a\u0003\u0007\n)\u0005\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0011A\u0014xN^5eKJT1!!\u0010{\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011IA\u001c\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011qIA&C\t\tI%\u0001\u0002{W\u0006\u0012\u0011QJ\u0001\u0006WJ\fg\r\u001e\u0015\b'\u0005E\u0013\u0011LA.!\u0011\t\u0019&!\u0016\u000e\u0005\u0005m\u0012\u0002BA,\u0003w\u0011\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0005\u0005u\u0013\u0001G>eSN\u0004H.Y=OC6,WPL9v_J,X.P>1{\u0006Y1/\u001a:wKJ\u0004&o\u001c9t)\t\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI\u0007L\u0001\u0005kRLG.\u0003\u0003\u0002n\u0005\u001d$A\u0003)s_B,'\u000f^5fg\u0002")
public class TransactionsExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final int replicationFactor;
    private KafkaProducer<byte[], byte[]> producer;
    private KafkaConsumer<byte[], byte[]> consumer;

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", this.brokers(), TestUtils$.MODULE$.createTransactionalProducer$default$3(), TestUtils$.MODULE$.createTransactionalProducer$default$4(), TestUtils$.MODULE$.createTransactionalProducer$default$5(), TestUtils$.MODULE$.createTransactionalProducer$default$6(), TestUtils$.MODULE$.createTransactionalProducer$default$7(), TestUtils$.MODULE$.createTransactionalProducer$default$8()));
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        boolean x$2 = false;
        boolean x$3 = true;
        String x$4 = TestUtils$.MODULE$.createConsumer$default$2();
        Option<String> x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        String x$6 = TestUtils$.MODULE$.createConsumer$default$4();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        SecurityProtocol x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<File> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        Option<Properties> x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        ByteArrayDeserializer x$12 = TestUtils$.MODULE$.createConsumer$default$12();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$4, x$5, x$6, x$2, x$3, x$7, x$8, x$9, x$10, x$11, x$12));
        this.createTopic(this.topic1(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(this.topic2(), this.numPartitions(), 3, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        this.consumer().close();
        super.tearDown();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBumpTransactionalEpochAfterInvalidProducerIdMapping(String quorum) {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(0), "2", "2", false));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), Predef$.MODULE$.int2Integer(0), "4", "4", false));
        this.producer().abortTransaction();
        Thread.sleep(3000L);
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "1", "1", false));
        Thread.sleep(500L);
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        this.producer().abortTransaction();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(2), "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "1", "1", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), Predef$.MODULE$.int2Integer(3), "3", "3", true));
        this.producer().commitTransaction();
        this.consumer().subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 4, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        serverProps.put(KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp(), "2000");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsRemoveExpiredTransactionalIdCleanupIntervalMsProp(), "500");
        return var1_1;
    }

    public TransactionsExpirationTest() {
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
        this.replicationFactor = 3;
    }
}

