/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\b\u0010\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004*\u0001\u0001\u0006Ia\t\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0011\u0019!\u0004\u0001)A\u0005Y!9Q\u0007\u0001b\u0001\n\u0013\u0011\u0003B\u0002\u001c\u0001A\u0003%1\u0005C\u00048\u0001\u0001\u0007I\u0011\u0002\u001d\t\u000fq\u0002\u0001\u0019!C\u0005{!11\t\u0001Q!\neBQ\u0001\u0012\u0001\u0005B\u0015CQa\u0016\u0001\u0005BaCQ!\u0018\u0001\u0005\u0002y\u0013q\u0003\u0015:pIV\u001cWM]\"p[B\u0014Xm]:j_:$Vm\u001d;\u000b\u0005A\t\u0012\u0001\u0002;fgRT!AE\n\u0002\u0007\u0005\u0004\u0018NC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0005i\u0019\u0012AB:feZ,'/\u0003\u0002\u001d3\t\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005y\u0011\u0001\u00032s_.,'/\u00133\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u00121!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\u0003u_BL7-F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003mC:<'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006ok6\u0014VmY8sIN\f1B\\;n%\u0016\u001cwN\u001d3tA\u00051!M]8lKJ,\u0012!\u000f\t\u00031iJ!aO\r\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u000bEJ|7.\u001a:`I\u0015\fHC\u0001 B!\t!s(\u0003\u0002AK\t!QK\\5u\u0011\u001d\u0011\u0015\"!AA\u0002e\n1\u0001\u001f\u00132\u0003\u001d\u0011'o\\6fe\u0002\nQa]3u+B$\"A\u0010$\t\u000b\u001d[\u0001\u0019\u0001%\u0002\u0011Q,7\u000f^%oM>\u0004\"!S)\u000e\u0003)S!AE&\u000b\u00051k\u0015a\u00026va&$XM\u001d\u0006\u0003\u001d>\u000bQA[;oSRT\u0011\u0001U\u0001\u0004_J<\u0017B\u0001*K\u0005!!Vm\u001d;J]\u001a|\u0007FA\u0006U!\tIU+\u0003\u0002W\u0015\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\u0010\u0015\u0003\u0019i\u0003\"!S.\n\u0005qS%!C!gi\u0016\u0014X)Y2i\u0003=!Xm\u001d;D_6\u0004(/Z:tS>tGc\u0001 `W\")\u0001-\u0004a\u0001C\u00061\u0011/^8sk6\u0004\"AY5\u000f\u0005\r<\u0007C\u00013&\u001b\u0005)'B\u00014\u0016\u0003\u0019a$o\\8u}%\u0011\u0001.J\u0001\u0007!J,G-\u001a4\n\u0005MR'B\u00015&\u0011\u0015aW\u00021\u0001b\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8)\t5qgo\u001e\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003g.\u000ba\u0001]1sC6\u001c\u0018BA;q\u0005%\u00195O^*pkJ\u001cW-A\u0003wC2,X\r\f\u0005yurt\u0018\u0011AA\u0003C\u0005I\u0018AC6sC\u001a$HF\\8oK\u0006\n10\u0001\u0006le\u00064G\u000fL4{SB\f\u0013!`\u0001\rWJ\fg\r\u001e\u0017t]\u0006\u0004\b/_\u0011\u0002\u007f\u0006I1N]1gi2b'\u0010N\u0011\u0003\u0003\u0007\t!b\u001b:bMRd#p\u001d;eC\t\t9!A\u0004{W2:'0\u001b9)\u00075\tY\u0001\u0005\u0003\u0002\u000e\u0005=Q\"\u0001:\n\u0007\u0005E!OA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\u0004")
public class ProducerCompressionTest
extends QuorumTestHarness {
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaBroker broker = null;

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaBroker broker() {
        return this.broker;
    }

    private void broker_$eq(KafkaBroker x$1) {
        this.broker = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.broker_$eq(this.createBroker(new KafkaConfig((Map)props), this.createBroker$default$2(), this.createBroker$default$3(), this.createBroker$default$4()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @ParameterizedTest
    @CsvSource(value={"kraft,none", "kraft,gzip", "kraft,snappy", "kraft,lz4", "kraft,zstd", "zk,gzip"})
    public void testCompression(String quorum, String compression) {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$));
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, TestUtils$.MODULE$.createConsumer$default$2(), TestUtils$.MODULE$.createConsumer$default$3(), TestUtils$.MODULE$.createConsumer$default$4(), TestUtils$.MODULE$.createConsumer$default$5(), TestUtils$.MODULE$.createConsumer$default$6(), TestUtils$.MODULE$.createConsumer$default$7(), TestUtils$.MODULE$.createConsumer$default$8(), TestUtils$.MODULE$.createConsumer$default$9(), TestUtils$.MODULE$.createConsumer$default$10(), TestUtils$.MODULE$.createConsumer$default$11(), TestUtils$.MODULE$.createConsumer$default$12());
        try {
            try (Admin admin = TestUtils$.MODULE$.createAdminClient(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), TestUtils$.MODULE$.createAdminClient$default$3());){
                TestUtils$.MODULE$.createTopicWithAdmin(admin, this.topic(), new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), TestUtils$.MODULE$.createTopicWithAdmin$default$4(), TestUtils$.MODULE$.createTopicWithAdmin$default$5(), TestUtils$.MODULE$.createTopicWithAdmin$default$6(), TestUtils$.MODULE$.createTopicWithAdmin$default$7());
            }
            int partition = 0;
            IndexedSeq messageValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1 & Serializable & scala.Serializable)i -> ProducerCompressionTest.$anonfun$testCompression$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            long now = System.currentTimeMillis();
            ((TraversableLike)((IndexedSeq)messageValues.map((Function1 & Serializable & scala.Serializable)message -> producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())), IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$1);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((TraversableLike)((IterableLike)messageValues.zip(records, IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null && (Tuple2)check$ifrefutable$2._1() != null))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$6(now, x$2);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    public static final /* synthetic */ String $anonfun$testCompression$1(int i) {
        return new StringBuilder(5).append("value").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$1) {
        if (x$1 != null) {
            Future future = (Future)x$1._1();
            Assertions.assertEquals((long)x$1._2$mcI$sp(), (long)((RecordMetadata)future.get()).offset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testCompression$6(long now$1, Tuple2 x$2) {
        if (x$2 != null) {
            Tuple2 tuple2 = (Tuple2)x$2._1();
            int index = x$2._2$mcI$sp();
            if (tuple2 != null) {
                String messageValue = (String)tuple2._1();
                ConsumerRecord record = (ConsumerRecord)tuple2._2();
                Assertions.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assertions.assertEquals((long)now$1, (long)record.timestamp());
                Assertions.assertEquals((long)index, (long)record.offset());
                return;
            }
        }
        throw new MatchError((Object)x$2);
    }

    public ProducerCompressionTest() {
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
    }
}

