/*
 * Decompiled with CFR 0.152.
 */
package kafka.assignor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kafka.assignor.ZkClusterDescriber;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ZkClusterDescriberTest {
    private static final List<Node> NODES = Arrays.asList(new Node(0, "localhost", 9092, "rackA"), new Node(1, "localhost", 9093, "rackB"), new Node(2, "localhost", 9094, "rackA"), new Node(3, "localhost", 9095, "rackB"));
    private static final Cluster CLUSTER1 = new Cluster("myClusterId", NODES, Arrays.asList(new PartitionInfo("foo", 0, NODES.get(0), new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[0]), new PartitionInfo("foo", 1, NODES.get(1), new Node[]{NODES.get(1), NODES.get(2), NODES.get(0)}, new Node[]{NODES.get(1), NODES.get(2), NODES.get(0)}, new Node[0]), new PartitionInfo("foo", 2, NODES.get(2), new Node[]{NODES.get(2), NODES.get(0), NODES.get(1)}, new Node[]{NODES.get(2), NODES.get(0)}, new Node[0]), new PartitionInfo("bar", 0, NODES.get(1), new Node[]{NODES.get(0), NODES.get(1), NODES.get(2)}, new Node[]{NODES.get(0), NODES.get(1)}, new Node[0])), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), NODES.get(1), Collections.emptyMap());
    private static final ZkClusterDescriber DESCRIBER1 = new ZkClusterDescriber(CLUSTER1);

    @Test
    public void testTopicNames() {
        HashSet topicNames = new HashSet();
        DESCRIBER1.topicNames().forEachRemaining(name -> topicNames.add(name));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar")), topicNames);
    }

    @Test
    public void testReplicasForTopicName() {
        Assertions.assertEquals(Arrays.asList(Arrays.asList(0, 1, 2), Arrays.asList(1, 2, 0), Arrays.asList(2, 0, 1)), (Object)DESCRIBER1.replicasForTopicName("foo"));
        Assertions.assertEquals(Arrays.asList(Arrays.asList(0, 1, 2)), (Object)DESCRIBER1.replicasForTopicName("bar"));
        Assertions.assertEquals(Arrays.asList(new Object[0]), (Object)DESCRIBER1.replicasForTopicName("baz"));
    }

    @Test
    public void testUsableBrokers() {
        HashSet brokers = new HashSet();
        DESCRIBER1.usableBrokers().forEachRemaining(broker -> brokers.add(broker));
        Assertions.assertEquals(new HashSet<UsableBroker>(Arrays.asList(new UsableBroker(0, Optional.of("rackA"), false), new UsableBroker(1, Optional.of("rackB"), false), new UsableBroker(2, Optional.of("rackA"), false), new UsableBroker(3, Optional.of("rackB"), false))), brokers);
    }
}

